/* ***** BEGIN LICENSE BLOCK *****
 * FW4SPL - Copyright (C) IRCAD, 2009-2013.
 * Distributed under the terms of the GNU Lesser General Public License (LGPL) as
 * published by the Free Software Foundation.
 * ****** END LICENSE BLOCK ****** */

#include <fwMedData/Series.hpp>

#include <fwServices/Base.hpp>
#include <fwServices/ObjectMsg.hpp>
#include <fwServices/macros.hpp>
#include <fwServices/registry/ObjectService.hpp>
#include <fwServices/registry/ServiceConfig.hpp>
#include <fwServices/IEditionService.hpp>

#include <fwGui/Cursor.hpp>

#include <fwComEd/helper/SeriesDB.hpp>

#include "uiIO/action/SSeriesDBMerger.hpp"

namespace uiIO
{
namespace action
{

fwServicesRegisterMacro( ::fwGui::IActionSrv , ::uiIO::action::SSeriesDBMerger , ::fwMedData::SeriesDB ) ;

//------------------------------------------------------------------------------

SSeriesDBMerger::SSeriesDBMerger( ) throw() : m_ioSelectorSrvConfig ("IOSelectorServiceConfigVRRenderReader")
{}

//------------------------------------------------------------------------------

SSeriesDBMerger::~SSeriesDBMerger() throw()
{}

//------------------------------------------------------------------------------

void SSeriesDBMerger::info(std::ostream &_sstream )
{
    _sstream << "Action for add SeriesDB" << std::endl;
}

//------------------------------------------------------------------------------

void SSeriesDBMerger::configuring() throw( ::fwTools::Failed )
{
    SLM_TRACE_FUNC();

    this->::fwGui::IActionSrv::initialize();
    std::vector < ConfigurationType > vectConfig = m_configuration->find("IOSelectorSrvConfig");
    if(!vectConfig.empty())
    {
        ConfigurationType selectorConfig = vectConfig.at(0);
        SLM_ASSERT("Missing 'name' attribute", selectorConfig->hasAttribute("name")) ;
        m_ioSelectorSrvConfig = selectorConfig->getAttributeValue("name") ;
    }
}

//------------------------------------------------------------------------------

void SSeriesDBMerger::updating( ) throw(::fwTools::Failed)
{
    SLM_TRACE_FUNC();
    ::fwGui::LockAction lock(this->getSptr());
    ::fwMedData::SeriesDB::sptr seriesDB = this->getObject< ::fwMedData::SeriesDB >();
    SLM_ASSERT("SeriesDB not instanced", seriesDB);

    // Create a new SeriesDB
    ::fwMedData::SeriesDB::sptr localSeriesDB = ::fwMedData::SeriesDB::New();

    /// Create IOSelectorService on the new SeriesDB and execute it.

    // Get the config
    ::fwRuntime::ConfigurationElement::csptr ioCfg;
    ioCfg = ::fwServices::registry::ServiceConfig::getDefault()->getServiceConfig(m_ioSelectorSrvConfig ,
                                                                                  "::uiIO::editor::IOSelectorService");
    SLM_ASSERT("Sorry, there is not service configuration "
               << m_ioSelectorSrvConfig
               << " for ::uiIO::editor::IOSelectorService", ioCfg) ;

    // Init and execute the service
    ::fwServices::IService::sptr ioSelectorSrv;
    ioSelectorSrv = ::fwServices::add(localSeriesDB,
                                      "::gui::editor::IDialogEditor",
                                      "::uiIO::editor::IOSelectorService");
    ioSelectorSrv->setConfiguration( ::fwRuntime::ConfigurationElement::constCast(ioCfg) ) ;
    ioSelectorSrv->configure() ;
    ioSelectorSrv->start();
    ioSelectorSrv->update();
    ioSelectorSrv->stop();
    ::fwServices::OSR::unregisterService( ioSelectorSrv );

    ::fwComEd::helper::SeriesDB sDBhelper(seriesDB);
    sDBhelper.merge(localSeriesDB);
    sDBhelper.notify(this->getSptr());
}

//------------------------------------------------------------------------------

void SSeriesDBMerger::starting() throw (::fwTools::Failed)
{
    this->::fwGui::IActionSrv::actionServiceStarting();
}

//------------------------------------------------------------------------------

void SSeriesDBMerger::receiving( ::fwServices::ObjectMsg::csptr _msg ) throw (::fwTools::Failed)
{}

//------------------------------------------------------------------------------

void SSeriesDBMerger::stopping() throw (::fwTools::Failed)
{
    this->::fwGui::IActionSrv::actionServiceStopping();
}

//------------------------------------------------------------------------------

} // namespace action
} // namespace uiIO
