/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::compressibilityModels::Chung

Description
    Chung compressibility model.

SourceFiles
    Chung.C

\*---------------------------------------------------------------------------*/

#ifndef Chung_H
#define Chung_H

#include <barotropicCompressibilityModel/barotropicCompressibilityModel.H>
#include <OpenFOAM/dimensionedScalar.H>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{
namespace compressibilityModels
{

/*---------------------------------------------------------------------------*\
                           Class Chung Declaration
\*---------------------------------------------------------------------------*/

class Chung
:
    public barotropicCompressibilityModel
{
    // Private data

        dimensionedScalar psiv_;
        dimensionedScalar psil_;

        dimensionedScalar rhovSat_;
        dimensionedScalar rholSat_;


public:

    //- Runtime type information
    TypeName("Chung");


    // Constructors

        //- construct from components
        Chung
        (
            const dictionary& compressibilityProperties,
            const volScalarField& gamma,
            const word& psiName = "psi"
        );


    // Destructor

        ~Chung()
        {}


    // Member Functions

        //- Correct the Chung compressibility
        void correct();

        //- Read transportProperties dictionary
        bool read(const dictionary& compressibilityProperties);
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace compressibilityModels
} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
