/*
 * Decompiled with CFR 0.152.
 */
package visad.data.hdfeos;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.hdfeos.GctpFunction;

public class PolarStereographic
extends CoordinateSystem {
    double r_major;
    double r_minor;
    double es;
    double e;
    double e4;
    double center_lon;
    double center_lat;
    double fac;
    double ind;
    double mcs;
    double tcs;
    double false_northing;
    double false_easting;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};

    public PolarStereographic(double lon_center, double lat_center) throws VisADException {
        this(RealTupleType.SpatialEarth2DTuple, 6371230.0, 6371230.0, lon_center, lat_center, 0.0, 0.0);
    }

    public PolarStereographic(double r_major, double r_minor, double lon_center, double lat_center) throws VisADException {
        this(RealTupleType.SpatialEarth2DTuple, r_major, r_minor, lon_center, lat_center, 0.0, 0.0);
    }

    public PolarStereographic(RealTupleType reference, double r_major, double r_minor, double lon_center, double lat_center) throws VisADException {
        this(reference, r_major, r_minor, lon_center, lat_center, 0.0, 0.0);
    }

    public static PolarStereographic makePolarStereographic(RealTupleType reference, double La1, double Lo1, double Lov) throws VisADException {
        return PolarStereographic.makePolarStereographic(reference, 6371230.0, 6371230.0, La1, Lo1, Lov, 1.0471975511965976);
    }

    public static PolarStereographic makePolarStereographic(RealTupleType reference, double r_major, double r_minor, double La1, double Lo1, double Lov, double lat_center) throws VisADException {
        PolarStereographic ps = new PolarStereographic(reference, r_major, r_minor, Lov, lat_center, 0.0, 0.0);
        double[][] values = ps.fromReference(new double[][]{{Lo1}, {La1}});
        double false_easting = values[0][0];
        double false_northing = values[1][0];
        return new PolarStereographic(reference, r_major, r_minor, Lov, lat_center, -false_easting, -false_northing);
    }

    public PolarStereographic(RealTupleType reference, double r_major, double r_minor, double lon_center, double lat_center, double false_easting, double false_northing) throws VisADException {
        super(reference, coordinate_system_units);
        this.r_major = r_major;
        this.r_minor = r_minor;
        this.center_lon = lon_center;
        this.center_lat = lat_center;
        this.false_easting = false_easting;
        this.false_northing = false_northing;
        double[] dum_1 = new double[1];
        double[] dum_2 = new double[1];
        double[] dum_3 = new double[1];
        double temp = r_minor / r_major;
        this.es = 1.0 - temp * temp;
        this.e = Math.sqrt(this.es);
        this.e4 = GctpFunction.e4fn(this.e);
        this.fac = lat_center < 0.0 ? -1.0 : 1.0;
        this.ind = 0.0;
        if (Math.abs(Math.abs(lat_center) - 1.5707963267948966) > 1.0E-10) {
            double con1;
            this.ind = 1.0;
            dum_1[0] = con1 = this.fac * this.center_lat;
            GctpFunction.sincos(dum_1, dum_2, dum_3);
            double sinphi = dum_2[0];
            double cosphi = dum_3[0];
            this.mcs = GctpFunction.msfnz(this.e, sinphi, cosphi);
            this.tcs = GctpFunction.tsfnz(this.e, con1, sinphi);
        }
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("PolarStereographic: tuple dim != 2");
        }
        double[][] t_tuples = new double[2][n_tuples];
        for (int ii = 0; ii < n_tuples; ++ii) {
            double lon;
            double x = (tuples[0][ii] - this.false_easting) * this.fac;
            double y = (tuples[1][ii] - this.false_northing) * this.fac;
            double rh = Math.sqrt(x * x + y * y);
            double ts = this.ind != 0.0 ? rh * this.tcs / (this.r_major * this.mcs) : rh * this.e4 / (this.r_major * 2.0);
            double lat = GctpFunction.phi2z(this.e, ts);
            if (lat != Double.NaN) {
                lat *= this.fac;
            }
            if (rh == 0.0) {
                lon = this.fac * this.center_lon;
            } else {
                double temp = Math.atan2(x, -y);
                lon = GctpFunction.adjust_lon(this.fac * temp + this.center_lon);
            }
            t_tuples[0][ii] = lon;
            t_tuples[1][ii] = lat;
        }
        return t_tuples;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        int n_tuples = tuples[0].length;
        int tuple_dim = tuples.length;
        if (tuple_dim != 2) {
            throw new VisADException("PolarStereographic: tuple dim != 2");
        }
        double[][] t_tuples = new double[2][n_tuples];
        for (int ii = 0; ii < n_tuples; ++ii) {
            double lon = tuples[0][ii];
            double lat = tuples[1][ii];
            double con1 = this.fac * GctpFunction.adjust_lon(lon - this.center_lon);
            double con2 = this.fac * lat;
            double sinphi = Math.sin(con2);
            double ts = GctpFunction.tsfnz(this.e, con2, sinphi);
            double rh = this.ind != 0.0 ? this.r_major * this.mcs * ts / this.tcs : 2.0 * this.r_major * ts / this.e4;
            t_tuples[0][ii] = this.fac * rh * Math.sin(con1) + this.false_easting;
            t_tuples[1][ii] = -this.fac * rh * Math.cos(con1) + this.false_northing;
        }
        return t_tuples;
    }

    public boolean equals(Object cs) {
        return cs instanceof PolarStereographic;
    }

    public static void main(String[] args) throws VisADException {
        int i;
        double r_major = 6371230.0;
        double r_minor = 6371230.0;
        double center_lat = 0.6981317007977318;
        double center_lon = -1.7453292519943295;
        double false_easting = 0.0;
        double false_northing = 0.0;
        double[][] values_in = new double[][]{{-2.3292989, -1.6580627, -1.6580627, -1.6580627, center_lon}, {0.2127555, 0.4363323, 0.6981317, 0.8726646, 1.5707963267948966}};
        RealType[] reals = new RealType[]{RealType.Longitude, RealType.Latitude};
        RealTupleType reference = new RealTupleType(reals);
        PolarStereographic cs = new PolarStereographic(reference, r_major, r_minor, center_lon, center_lat, false_easting, false_northing);
        double[][] values = ((CoordinateSystem)cs).fromReference(values_in);
        for (i = 0; i < values_in[0].length; ++i) {
            System.out.println(values_in[0][i] + ",  " + values_in[1][i]);
        }
        System.out.println("--------------------------\n");
        for (i = 0; i < values[0].length; ++i) {
            System.out.println(values[0][i] + ",  " + values[1][i]);
        }
        double[][] values_R = ((CoordinateSystem)cs).toReference(values);
        System.out.println("--------------------------\n");
        for (int i2 = 0; i2 < values_R[0].length; ++i2) {
            System.out.println(values_R[0][i2] + ",  " + values_R[1][i2]);
        }
        PolarStereographic ps = PolarStereographic.makePolarStereographic(reference, -0.36348227002033906, -2.6179938779914944, -1.8325957145940461);
        values = ps.fromReference(new double[][]{{-2.6179938779914944}, {-0.36348227002033906}});
        System.out.println("x: " + values[0][0]);
        System.out.println("y: " + values[1][0]);
        values = ps.fromReference(new double[][]{{-1.8325957145940461}, {1.5707963267948966}});
        System.out.println("x: " + values[0][0]);
        System.out.println("y: " + values[1][0]);
    }
}

