/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import java.io.IOException;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grid.GridIndexToNC;
import ucar.nc2.iosp.grid.GridServiceProvider;
import ucar.nc2.iosp.mcidas.McIDASGridReader;
import ucar.nc2.iosp.mcidas.McIDASGridRecord;
import ucar.nc2.iosp.mcidas.McIDASLookup;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class McIDASGridServiceProvider
extends GridServiceProvider {
    protected McIDASGridReader mcGridReader;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        try {
            this.mcGridReader = new McIDASGridReader();
            this.mcGridReader.init(raf, false);
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    public String getFileTypeId() {
        return "McIDASGrid";
    }

    public String getFileTypeDescription() {
        return "McIDAS Grid file";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        long start = System.currentTimeMillis();
        if (this.mcGridReader == null) {
            this.mcGridReader = new McIDASGridReader();
        }
        this.mcGridReader.init(raf);
        GridIndex index = this.mcGridReader.getGridIndex();
        this.open(index, cancelTask);
        if (debugOpen) {
            System.out.println(" GridServiceProvider.open " + ncfile.getLocation() + " took " + (System.currentTimeMillis() - start));
        }
    }

    protected void open(GridIndex index, CancelTask cancelTask) throws IOException {
        McIDASLookup lookup = new McIDASLookup((McIDASGridRecord)index.getGridRecords().get(0));
        GridIndexToNC delegate = new GridIndexToNC();
        delegate.setUseDescriptionForVariableName(false);
        delegate.open(index, lookup, 4, this.ncfile, this.fmrcCoordSys, cancelTask);
        this.ncfile.finish();
    }

    public boolean sync() {
        try {
            if (!this.mcGridReader.init()) {
                return false;
            }
            GridIndex index = this.mcGridReader.getGridIndex();
            this.ncfile.empty();
            this.open(index, null);
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    protected float[] _readData(GridRecord gr) throws IOException {
        return this.mcGridReader.readGrid((McIDASGridRecord)gr);
    }

    public static void main(String[] args) throws IOException {
        McIDASGridServiceProvider mciosp = new McIDASGridServiceProvider();
        RandomAccessFile rf = new RandomAccessFile(args[0], "r", 2048);
        MakeNetcdfFile ncfile = new MakeNetcdfFile(mciosp, rf, args[0], null);
    }

    static class MakeNetcdfFile
    extends NetcdfFile {
        MakeNetcdfFile(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

