/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;

public class IndexConstant
extends Index {
    protected IndexConstant(int rank) {
        super(rank);
    }

    protected IndexConstant(int[] shape) {
        super(shape);
    }

    protected IndexConstant(int[] shape, int[] stride) {
        super(shape, stride);
    }

    public int currentElement() {
        return 0;
    }

    IndexIterator getIndexIterator(Array maa) {
        return new IteratorConstant(this.size, maa);
    }

    private class IteratorConstant
    implements IndexIterator {
        private int currElement = -1;
        private final Array maa;
        private long size;
        private Index counter = null;

        IteratorConstant(long size, Array maa) {
            this.size = size;
            this.maa = maa;
        }

        public boolean hasNext() {
            return (long)this.currElement < this.size - 1L;
        }

        public boolean hasMore(int howMany) {
            return (long)this.currElement < this.size - (long)howMany;
        }

        public String toString() {
            if (this.counter == null) {
                this.counter = new Index(this.maa.getShape());
            }
            this.counter.setCurrentCounter(this.currElement);
            return this.counter.toString();
        }

        public int[] getCurrentCounter() {
            if (this.counter == null) {
                this.counter = new Index(this.maa.getShape());
            }
            this.counter.setCurrentCounter(this.currElement);
            return this.counter.current;
        }

        public double getDoubleCurrent() {
            return this.maa.getDouble(0);
        }

        public double getDoubleNext() {
            ++this.currElement;
            return this.maa.getDouble(0);
        }

        public void setDoubleCurrent(double val) {
            this.maa.setDouble(0, val);
        }

        public void setDoubleNext(double val) {
            ++this.currElement;
            this.maa.setDouble(0, val);
        }

        public float getFloatCurrent() {
            return this.maa.getFloat(this.currElement);
        }

        public float getFloatNext() {
            ++this.currElement;
            return this.maa.getFloat(0);
        }

        public void setFloatCurrent(float val) {
            this.maa.setFloat(this.currElement, val);
        }

        public void setFloatNext(float val) {
            ++this.currElement;
            this.maa.setFloat(0, val);
        }

        public long getLongCurrent() {
            return this.maa.getLong(this.currElement);
        }

        public long getLongNext() {
            ++this.currElement;
            return this.maa.getLong(0);
        }

        public void setLongCurrent(long val) {
            this.maa.setLong(this.currElement, val);
        }

        public void setLongNext(long val) {
            ++this.currElement;
            this.maa.setLong(0, val);
        }

        public int getIntCurrent() {
            return this.maa.getInt(this.currElement);
        }

        public int getIntNext() {
            ++this.currElement;
            return this.maa.getInt(0);
        }

        public void setIntCurrent(int val) {
            this.maa.setInt(this.currElement, val);
        }

        public void setIntNext(int val) {
            ++this.currElement;
            this.maa.setInt(0, val);
        }

        public short getShortCurrent() {
            return this.maa.getShort(this.currElement);
        }

        public short getShortNext() {
            ++this.currElement;
            return this.maa.getShort(0);
        }

        public void setShortCurrent(short val) {
            this.maa.setShort(this.currElement, val);
        }

        public void setShortNext(short val) {
            ++this.currElement;
            this.maa.setShort(0, val);
        }

        public byte getByteCurrent() {
            return this.maa.getByte(this.currElement);
        }

        public byte getByteNext() {
            ++this.currElement;
            return this.maa.getByte(0);
        }

        public void setByteCurrent(byte val) {
            this.maa.setByte(this.currElement, val);
        }

        public void setByteNext(byte val) {
            ++this.currElement;
            this.maa.setByte(0, val);
        }

        public char getCharCurrent() {
            return this.maa.getChar(this.currElement);
        }

        public char getCharNext() {
            ++this.currElement;
            return this.maa.getChar(0);
        }

        public void setCharCurrent(char val) {
            this.maa.setChar(this.currElement, val);
        }

        public void setCharNext(char val) {
            ++this.currElement;
            this.maa.setChar(0, val);
        }

        public boolean getBooleanCurrent() {
            return this.maa.getBoolean(this.currElement);
        }

        public boolean getBooleanNext() {
            ++this.currElement;
            return this.maa.getBoolean(0);
        }

        public void setBooleanCurrent(boolean val) {
            this.maa.setBoolean(this.currElement, val);
        }

        public void setBooleanNext(boolean val) {
            ++this.currElement;
            this.maa.setBoolean(0, val);
        }

        public Object getObjectCurrent() {
            return this.maa.getObject(this.currElement);
        }

        public Object getObjectNext() {
            ++this.currElement;
            return this.maa.getObject(0);
        }

        public void setObjectCurrent(Object val) {
            this.maa.setObject(this.currElement, val);
        }

        public void setObjectNext(Object val) {
            ++this.currElement;
            this.maa.setObject(0, val);
        }

        public Object next() {
            ++this.currElement;
            return this.maa.getObject(0);
        }
    }
}

