--
-- $Id: pc-ibm-at-standard.vhdl,v 1.12 2013-05-15 10:31:45 vrsieh Exp $
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity pc_ibm_at_standard is
	port(
		power_switch : in boolean;
		reset_button : in boolean;

		key : in boolean_array(0 to 127);

		screen_shot : in boolean;
		rec : in boolean;

		opt_screen : out opt_rgb
	);
end pc_ibm_at_standard;

architecture structural of pc_ibm_at_standard is
	signal power_board : at_conn;
	signal power_dev0 : molex_ide_power_conn;
	signal power_dev1 : molex_ide_power_conn;
	signal power_dev2 : molex_ide_power_conn;
	signal power_dev3 : molex_ide_power_conn;
	signal power_dev4 : molex_ide_power_conn;
	signal power_dev5 : molex_ide_power_conn;
	signal power_dev6 : molex_ide_power_conn;
	signal power_dev7 : molex_ide_power_conn;

	signal int_isa0 : isa_conn;
	signal int_isa1 : isa_conn;
	signal int_isa2 : isa_conn;
	signal int_isa3 : isa_conn;
	signal int_isa4 : isa_conn;
	signal int_isa5 : isa_conn;
	signal int_isa6 : isa_conn;
	signal int_isa7 : isa_conn;
	signal int_kbd : ps2_conn;
	signal int_n_reset_button : std_logic;
	signal int_vga : vga_conn;
	signal int_power_led : boolean_conn;
	signal int_speaker : sound;
	signal int_sound : sound;
	signal int_power230v : boolean;

begin
	chassis : chassis_at
		port map(
			mech_reset_button => reset_button,
			n_reset_button => int_n_reset_button,
			power_led => int_power_led,
			speaker => int_speaker,
			audio_speaker => int_sound
		);
	power_supply : power_supply_at
		port map(
			mech_power_switch => power_switch,
			power_board => power_board,
			power_dev0 => power_dev0,
			power_dev1 => power_dev1,
			power_dev2 => power_dev2,
			power_dev3 => power_dev3,
			power_dev4 => power_dev4,
			power_dev5 => power_dev5,
			power_dev6 => power_dev6,
			power_dev7 => power_dev7,
			power_230v => int_power230v
		);
	motherboard : mb_ibm_at
		port map(
			power => power_board,
			isa0 => int_isa0,
			isa1 => int_isa1,
			isa2 => int_isa2,
			isa3 => int_isa3,
			isa4 => int_isa4,
			isa5 => int_isa5,
			isa6 => int_isa6,
			isa7 => int_isa7,
			keyboard => int_kbd,
			speaker => int_speaker,
			power_led => int_power_led,
			n_reset_button => int_n_reset_button
		);
	keyboard : keyboard
		port map(
			ps2 => int_kbd,
			key0 => key(0), key1 => key(1),
			key2 => key(2), key3 => key(3),
			key4 => key(4), key5 => key(5),
			key6 => key(6), key7 => key(7),
			key8 => key(8), key9 => key(9),
			key10 => key(10), key11 => key(11),
			key12 => key(12), key13 => key(13),
			key14 => key(14), key15 => key(15),
			key16 => key(16), key17 => key(17),
			key18 => key(18), key19 => key(19),
			key20 => key(20), key21 => key(21),
			key22 => key(22), key23 => key(23),
			key24 => key(24), key25 => key(25),
			key26 => key(26), key27 => key(27),
			key28 => key(28), key29 => key(29),
			key30 => key(30), key31 => key(31),
			key32 => key(32), key33 => key(33),
			key34 => key(34), key35 => key(35),
			key36 => key(36), key37 => key(37),
			key38 => key(38), key39 => key(39),
			key40 => key(40), key41 => key(41),
			key42 => key(42), key43 => key(43),
			key44 => key(44), key45 => key(45),
			key46 => key(46), key47 => key(47),
			key48 => key(48), key49 => key(49),
			key50 => key(50), key51 => key(51),
			key52 => key(52), key53 => key(53),
			key54 => key(54), key55 => key(55),
			key56 => key(56), key57 => key(57),
			key58 => key(58), key59 => key(59),
			key60 => key(60), key61 => key(61),
			key62 => key(62), key63 => key(63),
			key64 => key(64), key65 => key(65),
			key66 => key(66), key67 => key(67),
			key68 => key(68), key69 => key(69),
			key70 => key(70), key71 => key(71),
			key72 => key(72), key73 => key(73),
			key74 => key(74), key75 => key(75),
			key76 => key(76), key77 => key(77),
			key78 => key(78), key79 => key(79),
			key80 => key(80), key81 => key(81),
			key82 => key(82), key83 => key(83),
			key84 => key(84), key85 => key(85),
			key86 => key(86), key87 => key(87),
			key88 => key(88), key89 => key(89),
			key90 => key(90), key91 => key(91),
			key92 => key(92), key93 => key(93),
			key94 => key(94), key95 => key(95),
			key96 => key(96), key97 => key(97),
			key98 => key(98), key99 => key(99),
			key100 => key(100), key101 => key(101),
			key102 => key(102), key103 => key(103),
			key104 => key(104), key105 => key(105),
			key106 => key(106), key107 => key(107),
			key108 => key(108), key109 => key(109),
			key110 => key(110), key111 => key(111),
			key112 => key(112), key113 => key(113),
			key114 => key(114), key115 => key(115),
			key116 => key(116), key117 => key(117),
			key118 => key(118), key119 => key(119),
			key120 => key(120), key121 => key(121),
			key122 => key(122), key123 => key(123),
			key124 => key(124), key125 => key(125),
			key126 => key(126), key127 => key(127)
		);
	monitor : monitor_eizo_flexscan_f67
		port map(
			vga => int_vga,
			opt_video => opt_screen,
			screen_shot => screen_shot,
			rec => rec,
			power_230v => int_power230v
		);
	video : isa_gen_vga
		port map(
			isa => int_isa0,
			vga => int_vga
		);
end structural;
