--
-- $Id: pc-4.vhdl,v 1.2 2013-05-30 08:47:00 vrsieh Exp $
--
-- Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.ALL;
use expect.procedures.ALL;
library ieee;
use ieee.std_logic_1164.ALL;

entity pc_standard is
	generic(
		disksize : integer := 2048
	);
	port(
		ext_eth0 : inout eth_conn;
		ext_usb0 : inout usb_conn;
		ext_usb1 : inout usb_conn;
		ext_par : inout parallel;
		ext_ser0 : inout serial;
		ext_ser1 : inout serial;

		power_switch : in boolean;
		power_button : in boolean;
		reset_button : in boolean;

		media_floppy : inout floppy;
		floppy : in cstring;
		media_cd : inout magneto_optical;
		cdrom : in cstring;
		media_image : inout opt_rgb;
		image : in cstring;

		key : in boolean_array(0 to 127);

		mouse_dx : in integer;
		mouse_dy : in integer;
		mouse_dz : in integer;
		mouse_button1 : in boolean;
		mouse_button2 : in boolean;
		mouse_button3 : in boolean;
		mouse_button4 : in boolean;
		mouse_button5 : in boolean;

		screen_shot : in boolean;
		rec : in boolean;

		opt_screen : out opt_rgb
	);
end pc_standard;

architecture structural of pc_standard is
	signal int_power : std_logic;
	signal int_pci : pci_bus;

begin
	arm : chip_arm
		port map(
			power => int_power,
			main => int_pci
		);
end structural;
