/*
 * $Id: system.c,v 1.9 2013-05-15 13:46:51 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "system.h"
#include "glue-main.h"
#include "glue-gui.h"
#include "glue-log.h"

#include "system.inc1"
#include "system.inc3"
#include "system.inc5"

static void *cpssp = &cpssp;

static const struct {
    const char *type;
    void *(*create)(char *);
    void (*destroy)(void *);
    void (*suspend)(void *, FILE *);
    void (*resume)(void *, FILE *);
    void *(*merge)(void *, void *);
    void (*split)(void *);
} sig_type[] = {
#include "system.inc2"
#include "system.inc4"
};

static const struct {
    const char *type;
    const char *generic[50];
    const char *port[1500];
    enum system_gender gender[1500];
    void *(*create)(const char *name, ...);
    void (*destroy)(void *);
    void (*suspend)(void *, FILE *);
    void (*resume)(void *, FILE *);
    void *(*gui_create)(unsigned int page, const char *name, ...);
    void (*gui_destroy)(void *);
    void (*gui_suspend)(void *, FILE *);
    void (*gui_resume)(void *, FILE *);
    void *(*aui_create)(const char *name, ...);
    void (*aui_destroy)(void *);
    void (*aui_suspend)(void *, FILE *);
    void (*aui_resume)(void *, FILE *);
} comp_type[] = {
#include "system.inc6"
};

/* Generic GUI pages. */
static struct {
    unsigned int id;
    char *name;
} page[64];
static unsigned int page_count = 0;

/* Generic signals. */
static struct {
    unsigned int id;
    char *type;
    char *name;

    void *ptr;
} sig[10000];

/* Generic components. */
static struct {
    char *type;
    char *name;
    unsigned int node;
    unsigned int page;
    unsigned int id;

    void *ptr;
    void *aui_ptr;
    void *gui_ptr;
} comp[200];

/* Generic generics. */
static struct {
    unsigned int comp_id;
    char *type;
    char *name;
    char *value;
} generic[2000];
static unsigned int generic_count = 0;

/* Generic connections. */
static struct {
    unsigned int comp_id;
    char *port;
    enum system_gender gender;
    unsigned int sig_id;
    void *sig_ptr;

    void *merge;
    int peer;
} conn[2000];

static const char *system_name[64];
static unsigned int system_level;

static unsigned int
system_id(void)
{
    static unsigned int id = 0;

    return id++;
}

void
system_name_push(const char *name)
{
    assert(name);

    assert(system_level < sizeof(system_name) / sizeof(system_name[0]));
    system_name[system_level++] = name;
}

void
system_name_pop(void)
{
    assert(1 <= system_level);
    system_level--;
}

const char *
system_path(void)
{
    static char path[1024];
    unsigned int level;

    assert(1 <= system_level);

    assert(strlen(system_name[0]) + 1 <= sizeof(path));
    strcpy(path, system_name[0]);
    for (level = 1; level < system_level; level++) {
	assert(strlen(path) + 1 + strlen(system_name[level]) + 1
	       <= sizeof(path));
	strcat(path, ":");
	strcat(path, system_name[level]);
    }

    return path;
}

int
system_page_create(const char *name)
{
    unsigned int page_id;
    unsigned int pi;

    page_id = system_id();

    for (pi = 0; pi < page_count; pi++) {
	if (strcasecmp(page[pi].name, name) == 0) {
	    /* Found */
	    assert(0); /* FIXME */
	    return -1;
	}
    }

    page[page_count].id = page_id;
    page[page_count].name = strdup(name);
    assert(page[page_count].name);

    gui_page_add(page_id, page[page_count].name);

    return page_id;
}

int
system_page_destroy(unsigned int page_id)
{
    /* FIXME */

    return 0;
}

int
system_page_lookup(const char *name)
{
    unsigned int pi;

    for (pi = 0; ; pi++) {
	if (pi == sizeof(page) / sizeof(page[0])) {
	    /* Page not found. */
	    return -1;
	}

	if (strcasecmp(page[pi].name, name) == 0) {
	    break;
	}
    }

    return page[pi].id;
}

int
system_sig_create(const char *type, const char *name)
{
    unsigned int sig_id;
    unsigned int si;

    sig_id = system_id();

    for (si = 0; si < sizeof(sig) / sizeof(sig[0]); si++) {
	if (! sig[si].type
	    || ! sig[si].name) {
	    continue;
	}
	if (strcasecmp(sig[si].name, name) == 0) {
	    /* Found */
	    assert(0);
	    return -1;
	}
    }
    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Table Full */
	    assert(0);
	    return -1;
	}
	if (! sig[si].name) {
	    break;
	}
    }

    sig[si].id = sig_id;

    sig[si].type = strdup(type);
    assert(sig[si].type);

    sig[si].name = strdup(name);
    assert(sig[si].name);

    sig[si].ptr = NULL;

    return sig_id;
}

void *
system_sig_get(unsigned int sig_id)
{
    unsigned int si;

    /* Lookup signal. */
    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Not found. */
	    /* FIXME */
	    assert(0);
	}
	if (! sig[si].type
	    || ! sig[si].name) {
	    continue;
	}
	if (sig[si].id == sig_id) {
	    /* Found */
	    break;
	}
    }

    assert(sig[si].id == sig_id);
    assert(sig[si].type);
    assert(sig[si].name);

    if (! sig[si].ptr) {
	unsigned int j;

	for (j = 0; ; j++) {
	    if (j == sizeof(sig_type) / sizeof(sig_type[0])) {
		/* FIXME */
		fprintf(stderr, "Type: %s.\n", sig[si].type);
		assert(0);
	    }
	    if (strcasecmp(sig[si].type, sig_type[j].type) == 0) {
		sig[si].ptr = sig_type[j].create(sig[si].name);
		break;
	    }
	}
    }

    return sig[si].ptr;
}

int
system_sig_unget(void *ptr)
{
    unsigned int si;
    unsigned int j;

    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Signal not found. */
	    assert(0); /* FIXME */
	}
	if (! sig[si].type
	    || ! sig[si].name) {
	    continue;
	}
	if (sig[si].ptr == ptr) {
	    break;
	}
    }

    for (j = 0; ; j++) {
	if (j == sizeof(sig_type) / sizeof(sig_type[0])) {
	    /* FIXME */
	    assert(0);
	}
	if (strcasecmp(sig[si].type, sig_type[j].type) == 0) {
	    sig_type[j].destroy(sig[si].ptr);
	    break;
	}
    }

    sig[si].ptr = NULL;

    return 0;
}

void
system_sig_destroy(unsigned int sig_id)
{
    unsigned int si;

    /* Lookup signal. */
    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Not found. */
	    return; /* FIXME */
	}
	if (! sig[si].type
	    || ! sig[si].name) {
	    continue;
	}
	if (sig[si].id == sig_id) {
	    /* Found. */
	    break;
	}
    }

    if (sig[si].ptr) {
	/* Hack - FIXME */
	system_sig_unget(sig[si].ptr);
    }

    free(sig[si].type);
    sig[si].type = NULL;

    free(sig[si].name);
    sig[si].name = NULL;
}

int
system_sig_info(unsigned int sig_id, char *type, char *name)
{
    unsigned int si;

    /* Lookup signal. */
    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Not found. */
	    return -1;
	}
	if (! sig[si].type
	    || ! sig[si].name) {
	    continue;
	}
	if (sig[si].id == sig_id) {
	    /* Found. */
	    break;
	}
    }

    strcpy(type, sig[si].type);
    strcpy(name, sig[si].name);

    return 0;
}

int
system_comp_create(
		   const char *type,
		   const char *name,
		   unsigned int node,
		   unsigned int page
		  )
{
    int comp_id;
    unsigned int ci;

    if (strchr(name, '/')) {
	/* Name mustn't contain '/'. */
	fprintf(stderr, "%s: WARNING: %s: %s.\n", progname,
		name, "Bad name");
	return -1;
    }

    comp_id = system_id();

    for (ci = 0; ci < sizeof(comp) / sizeof(comp[0]); ci++) {
	if (! comp[ci].name) {
	    continue;
	}
	if (strcasecmp(comp[ci].name, name) == 0) {
	    /* Found */
	    fprintf(stderr, "ERROR: %s: exists already.\n", name);
	    assert(0); /* FIXME */
	    return -1;
	}
    }
    for (ci = 0; ; ci++) {
	if (ci == sizeof(comp) / sizeof(comp[0])) {
	    /* Table Full */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (! comp[ci].name) {
	    break;
	}
    }

    comp[ci].id = comp_id;

    comp[ci].type = strdup(type);
    assert(comp[ci].type);

    comp[ci].name = strdup(name);
    assert(comp[ci].name);

    comp[ci].node = node;
    comp[ci].page = page;

    return comp_id;
}

int
system_comp_generic_set(
			unsigned int comp_id,
			const char *t,
			const char *n,
			const char *v
		       )
{
    char *type;
    char *name;
    char *value;
    unsigned int i;

    /* check if generic with that name is already present */
    for (i = 0; i < generic_count; i++) {
	if (generic[i].comp_id != comp_id) {
	    continue;
	}

	if (strcasecmp(generic[i].name, n) == 0) {
	    faum_log(FAUM_LOG_WARNING, "system", __func__,
		     "Generic %s of component %d already set!\n",
		     n, comp_id);
	}
    }

    generic[generic_count].comp_id = comp_id;

    assert(t);
    type = strdup(t);
    assert(type);
    assert(n);
    name = strdup(n);
    assert(name);
    generic[generic_count].type = type;
    generic[generic_count].name = name;

    if (v) {
	value = strdup(v);
	assert(value);
    } else {
	value = NULL;
    }
    generic[generic_count].value = value;

    generic_count++;

    return 0;
}

int
system_comp_port_connect(
			 unsigned int comp_id,
			 const char *port,
			 unsigned int sig_id
			)
{
    unsigned int conn_id;
    unsigned int ci;
    unsigned int si;

    for (ci = 0; ; ci ++) {
	if (ci == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (comp[ci].id == comp_id) {
	    /* Component found. */
	    break;
	}
    }
    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Signal not found. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (sig[si].id == sig_id) {
	    /* Signal found. */
	    break;
	}
    }

    for (conn_id = 0; conn_id < sizeof(conn) / sizeof(conn[0]); conn_id++) {
	if (! conn[conn_id].port) {
	    continue;
	}

	if (conn[conn_id].comp_id == comp_id
	    && strcasecmp(conn[conn_id].port, port) == 0) {
	    /* Port already defined. */
	    assert(0); /* FIXME */
	    return -1;
	}
    }

    /* Lookup free connection entry. */
    for (conn_id = 0; ; conn_id++) {
	if (conn_id == sizeof(conn) / sizeof(conn[0])) {
	    /* Table full. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (! conn[conn_id].port) {
	    break;
	}
    }

    conn[conn_id].comp_id = comp_id;
    conn[conn_id].port = strdup(port);
    assert(conn[conn_id].port);
    conn[conn_id].sig_id = sig_id;
    conn[conn_id].sig_ptr = system_sig_get(sig_id);

    conn[conn_id].merge = NULL;
    conn[conn_id].peer = -1;

    return 0;
}

static const char *
generic_get(unsigned int comp_id, const char *name)
{
    unsigned int i;

    for (i = 0; ; i++) {
	if (i == generic_count) {
	    fprintf(stderr, "WARNING: Generic %s not set for component!\n",
		    name);
	    return NULL;
	}
	if (generic[i].comp_id == comp_id
	    && strcasecmp(generic[i].name, name) == 0) {
	    return generic[i].value;
	}
    }
}

static void *
sig_lookup(unsigned int comp_id, const char *port, enum system_gender gender)
{
    unsigned int conn_id;

    for (conn_id = 0; ; conn_id++) {
	if (conn_id == sizeof(conn) / sizeof(conn[0])) {
	    assert(0); /* FIXME */
	}
	assert(conn_id < sizeof(conn) / sizeof(conn[0]));

	if (! conn[conn_id].port) {
	    continue;
	}

	if (conn[conn_id].comp_id == comp_id
	    && strcasecmp(conn[conn_id].port, port) == 0) {
	    if (gender != SYSTEM_GENDER_NEUTRAL) {
		assert(conn[conn_id].gender == 0
		       || conn[conn_id].gender == gender);
		conn[conn_id].gender = gender;
	    }
	    return conn[conn_id].sig_ptr;
	}
    }
}

int
system_comp_init(unsigned int comp_id)
{
    unsigned int ci;
    unsigned int i;

    /* Lookup component. */
    for (ci = 0; ; ci++) {
	if (ci == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (comp[ci].id == comp_id
	    && comp[ci].type
	    && comp[ci].name) {
	    /* Component found. */
	    break;
	}
    }

    for (i = 0; ; i++) {
	if (i == sizeof(comp_type) / sizeof(comp_type[0])) {
	    fprintf(stderr, "%s\n", comp[ci].type);
	    assert(0); /* FIXME */
	}
	if (strcasecmp(comp[ci].type, comp_type[i].type) == 0) {
	    const void *ptr[1500];
	    unsigned int nptrs;
	    unsigned int j;

	    nptrs = 0;
	    for (j = 0; comp_type[i].generic[j]; j++) {
		ptr[nptrs++] = generic_get(comp_id, comp_type[i].generic[j]);
	    }
	    for (j = 0; comp_type[i].port[j]; j++) {
		ptr[nptrs++] = sig_lookup(comp_id, comp_type[i].port[j], comp_type[i].gender[j]);
	    }
	    while (nptrs < 1500) {
		ptr[nptrs++] = NULL;
	    }

	    if (comp_type[i].create) {
		comp[ci].ptr = comp_type[i].create(comp[ci].name,
						   ptr[0], ptr[1], ptr[2], ptr[3], ptr[4],
						   ptr[5], ptr[6], ptr[7], ptr[8], ptr[9],
						   ptr[10], ptr[11], ptr[12], ptr[13], ptr[14],
						   ptr[15], ptr[16], ptr[17], ptr[18], ptr[19],
						   ptr[20], ptr[21], ptr[22], ptr[23], ptr[24],
						   ptr[25], ptr[26], ptr[27], ptr[28], ptr[29],
						   ptr[30], ptr[31], ptr[32], ptr[33], ptr[34],
						   ptr[35], ptr[36], ptr[37], ptr[38], ptr[39],
						   ptr[40], ptr[41], ptr[42], ptr[43], ptr[44],
						   ptr[45], ptr[46], ptr[47], ptr[48], ptr[49],
						   ptr[50], ptr[51], ptr[52], ptr[53], ptr[54],
						   ptr[55], ptr[56], ptr[57], ptr[58], ptr[59],
						   ptr[60], ptr[61], ptr[62], ptr[63], ptr[64],
						   ptr[65], ptr[66], ptr[67], ptr[68], ptr[69],
						   ptr[70], ptr[71], ptr[72], ptr[73], ptr[74],
						   ptr[75], ptr[76], ptr[77], ptr[78], ptr[79],
						   ptr[80], ptr[81], ptr[82], ptr[83], ptr[84],
						   ptr[85], ptr[86], ptr[87], ptr[88], ptr[89],
						   ptr[90], ptr[91], ptr[92], ptr[93], ptr[94],
						   ptr[95], ptr[96], ptr[97], ptr[98], ptr[99],
						   ptr[100], ptr[101], ptr[102], ptr[103], ptr[104],
						   ptr[105], ptr[106], ptr[107], ptr[108], ptr[109],
						   ptr[110], ptr[111], ptr[112], ptr[113], ptr[114],
						   ptr[115], ptr[116], ptr[117], ptr[118], ptr[119],
						   ptr[120], ptr[121], ptr[122], ptr[123], ptr[124],
						   ptr[125], ptr[126], ptr[127], ptr[128], ptr[129],
						   ptr[130], ptr[131], ptr[132], ptr[133], ptr[134],
						   ptr[135], ptr[136], ptr[137], ptr[138], ptr[139],
						   ptr[140], ptr[141], ptr[142], ptr[143], ptr[144],
						   ptr[145], ptr[146], ptr[147], ptr[148], ptr[149],
						   ptr[150], ptr[151], ptr[152], ptr[153], ptr[154],
						   ptr[155], ptr[156], ptr[157], ptr[158], ptr[159],
						   ptr[160], ptr[161], ptr[162], ptr[163], ptr[164],
						   ptr[165], ptr[166], ptr[167], ptr[168], ptr[169],
						   ptr[170], ptr[171], ptr[172], ptr[173], ptr[174],
						   ptr[175], ptr[176], ptr[177], ptr[178], ptr[179],
						   ptr[180], ptr[181], ptr[182], ptr[183], ptr[184],
						   ptr[185], ptr[186], ptr[187], ptr[188], ptr[189],
						   ptr[190], ptr[191], ptr[192], ptr[193], ptr[194],
						   ptr[195], ptr[196], ptr[197], ptr[198], ptr[199],
						   ptr[200], ptr[201], ptr[202], ptr[203], ptr[204],
						   ptr[205], ptr[206], ptr[207], ptr[208], ptr[209],
						   ptr[210], ptr[211], ptr[212], ptr[213], ptr[214],
						   ptr[215], ptr[216], ptr[217], ptr[218], ptr[219],
						   ptr[220], ptr[221], ptr[222], ptr[223], ptr[224],
						   ptr[225], ptr[226], ptr[227], ptr[228], ptr[229],
						   ptr[230], ptr[231], ptr[232], ptr[233], ptr[234],
						   ptr[235], ptr[236], ptr[237], ptr[238], ptr[239],
						   ptr[240], ptr[241], ptr[242], ptr[243], ptr[244],
						   ptr[245], ptr[246], ptr[247], ptr[248], ptr[249],
						   ptr[250], ptr[251], ptr[252], ptr[253], ptr[254],
						   ptr[255], ptr[256], ptr[257], ptr[258], ptr[259],
						   ptr[260], ptr[261], ptr[262], ptr[263], ptr[264],
						   ptr[265], ptr[266], ptr[267], ptr[268], ptr[269],
						   ptr[270], ptr[271], ptr[272], ptr[273], ptr[274],
						   ptr[275], ptr[276], ptr[277], ptr[278], ptr[279],
						   ptr[280], ptr[281], ptr[282], ptr[283], ptr[284],
						   ptr[285], ptr[286], ptr[287], ptr[288], ptr[289],
						   ptr[290], ptr[291], ptr[292], ptr[293], ptr[294],
						   ptr[295], ptr[296], ptr[297], ptr[298], ptr[299],
						   ptr[300], ptr[301], ptr[302], ptr[303], ptr[304],
						   ptr[305], ptr[306], ptr[307], ptr[308], ptr[309],
						   ptr[310], ptr[311], ptr[312], ptr[313], ptr[314],
						   ptr[315], ptr[316], ptr[317], ptr[318], ptr[319],
						   ptr[320], ptr[321], ptr[322], ptr[323], ptr[324],
						   ptr[325], ptr[326], ptr[327], ptr[328], ptr[329],
						   ptr[330], ptr[331], ptr[332], ptr[333], ptr[334],
						   ptr[335], ptr[336], ptr[337], ptr[338], ptr[339],
						   ptr[340], ptr[341], ptr[342], ptr[343], ptr[344],
						   ptr[345], ptr[346], ptr[347], ptr[348], ptr[349],
						   ptr[350], ptr[351], ptr[352], ptr[353], ptr[354],
						   ptr[355], ptr[356], ptr[357], ptr[358], ptr[359],
						   ptr[360], ptr[361], ptr[362], ptr[363], ptr[364],
						   ptr[365], ptr[366], ptr[367], ptr[368], ptr[369],
						   ptr[370], ptr[371], ptr[372], ptr[373], ptr[374],
						   ptr[375], ptr[376], ptr[377], ptr[378], ptr[379],
						   ptr[380], ptr[381], ptr[382], ptr[383], ptr[384],
						   ptr[385], ptr[386], ptr[387], ptr[388], ptr[389],
						   ptr[390], ptr[391], ptr[392], ptr[393], ptr[394],
						   ptr[395], ptr[396], ptr[397], ptr[398], ptr[399],
						   ptr[400], ptr[401], ptr[402], ptr[403], ptr[404],
						   ptr[405], ptr[406], ptr[407], ptr[408], ptr[409],
						   ptr[410], ptr[411], ptr[412], ptr[413], ptr[414],
						   ptr[415], ptr[416], ptr[417], ptr[418], ptr[419],
						   ptr[420], ptr[421], ptr[422], ptr[423], ptr[424],
						   ptr[425], ptr[426], ptr[427], ptr[428], ptr[429],
						   ptr[430], ptr[431], ptr[432], ptr[433], ptr[434],
						   ptr[435], ptr[436], ptr[437], ptr[438], ptr[439],
						   ptr[440], ptr[441], ptr[442], ptr[443], ptr[444],
						   ptr[445], ptr[446], ptr[447], ptr[448], ptr[449],
						   ptr[450], ptr[451], ptr[452], ptr[453], ptr[454],
						   ptr[455], ptr[456], ptr[457], ptr[458], ptr[459],
						   ptr[460], ptr[461], ptr[462], ptr[463], ptr[464],
						   ptr[465], ptr[466], ptr[467], ptr[468], ptr[469],
						   ptr[470], ptr[471], ptr[472], ptr[473], ptr[474],
						   ptr[475], ptr[476], ptr[477], ptr[478], ptr[479],
						   ptr[480], ptr[481], ptr[482], ptr[483], ptr[484],
						   ptr[485], ptr[486], ptr[487], ptr[488], ptr[489],
						   ptr[490], ptr[491], ptr[492], ptr[493], ptr[494],
						   ptr[495], ptr[496], ptr[497], ptr[498], ptr[499],
						   ptr[500], ptr[501], ptr[502], ptr[503], ptr[504],
						   ptr[505], ptr[506], ptr[507], ptr[508], ptr[509],
						   ptr[510], ptr[511], ptr[512], ptr[513], ptr[514],
						   ptr[515], ptr[516], ptr[517], ptr[518], ptr[519],
						   ptr[520], ptr[521], ptr[522], ptr[523], ptr[524],
						   ptr[525], ptr[526], ptr[527], ptr[528], ptr[529],
						   ptr[530], ptr[531], ptr[532], ptr[533], ptr[534],
						   ptr[535], ptr[536], ptr[537], ptr[538], ptr[539],
						   ptr[540], ptr[541], ptr[542], ptr[543], ptr[544],
						   ptr[545], ptr[546], ptr[547], ptr[548], ptr[549],
						   ptr[550], ptr[551], ptr[552], ptr[553], ptr[554],
						   ptr[555], ptr[556], ptr[557], ptr[558], ptr[559],
						   ptr[560], ptr[561], ptr[562], ptr[563], ptr[564],
						   ptr[565], ptr[566], ptr[567], ptr[568], ptr[569],
						   ptr[570], ptr[571], ptr[572], ptr[573], ptr[574],
						   ptr[575], ptr[576], ptr[577], ptr[578], ptr[579],
						   ptr[580], ptr[581], ptr[582], ptr[583], ptr[584],
						   ptr[585], ptr[586], ptr[587], ptr[588], ptr[589],
						   ptr[590], ptr[591], ptr[592], ptr[593], ptr[594],
						   ptr[595], ptr[596], ptr[597], ptr[598], ptr[599],
						   ptr[600], ptr[601], ptr[602], ptr[603], ptr[604],
						   ptr[605], ptr[606], ptr[607], ptr[608], ptr[609],
						   ptr[610], ptr[611], ptr[612], ptr[613], ptr[614],
						   ptr[615], ptr[616], ptr[617], ptr[618], ptr[619],
						   ptr[620], ptr[621], ptr[622], ptr[623], ptr[624],
						   ptr[625], ptr[626], ptr[627], ptr[628], ptr[629],
						   ptr[630], ptr[631], ptr[632], ptr[633], ptr[634],
						   ptr[635], ptr[636], ptr[637], ptr[638], ptr[639],
						   ptr[640], ptr[641], ptr[642], ptr[643], ptr[644],
						   ptr[645], ptr[646], ptr[647], ptr[648], ptr[649],
						   ptr[650], ptr[651], ptr[652], ptr[653], ptr[654],
						   ptr[655], ptr[656], ptr[657], ptr[658], ptr[659],
						   ptr[660], ptr[661], ptr[662], ptr[663], ptr[664],
						   ptr[665], ptr[666], ptr[667], ptr[668], ptr[669],
						   ptr[670], ptr[671], ptr[672], ptr[673], ptr[674],
						   ptr[675], ptr[676], ptr[677], ptr[678], ptr[679],
						   ptr[680], ptr[681], ptr[682], ptr[683], ptr[684],
						   ptr[685], ptr[686], ptr[687], ptr[688], ptr[689],
						   ptr[690], ptr[691], ptr[692], ptr[693], ptr[694],
						   ptr[695], ptr[696], ptr[697], ptr[698], ptr[699],
						   ptr[700], ptr[701], ptr[702], ptr[703], ptr[704],
						   ptr[705], ptr[706], ptr[707], ptr[708], ptr[709],
						   ptr[710], ptr[711], ptr[712], ptr[713], ptr[714],
						   ptr[715], ptr[716], ptr[717], ptr[718], ptr[719],
						   ptr[720], ptr[721], ptr[722], ptr[723], ptr[724],
						   ptr[725], ptr[726], ptr[727], ptr[728], ptr[729],
						   ptr[730], ptr[731], ptr[732], ptr[733], ptr[734],
						   ptr[735], ptr[736], ptr[737], ptr[738], ptr[739],
						   ptr[740], ptr[741], ptr[742], ptr[743], ptr[744],
						   ptr[745], ptr[746], ptr[747], ptr[748], ptr[749],
						   ptr[750], ptr[751], ptr[752], ptr[753], ptr[754],
						   ptr[755], ptr[756], ptr[757], ptr[758], ptr[759],
						   ptr[760], ptr[761], ptr[762], ptr[763], ptr[764],
						   ptr[765], ptr[766], ptr[767], ptr[768], ptr[769],
						   ptr[770], ptr[771], ptr[772], ptr[773], ptr[774],
						   ptr[775], ptr[776], ptr[777], ptr[778], ptr[779],
						   ptr[780], ptr[781], ptr[782], ptr[783], ptr[784],
						   ptr[785], ptr[786], ptr[787], ptr[788], ptr[789],
						   ptr[790], ptr[791], ptr[792], ptr[793], ptr[794],
						   ptr[795], ptr[796], ptr[797], ptr[798], ptr[799],
						   ptr[800], ptr[801], ptr[802], ptr[803], ptr[804],
						   ptr[805], ptr[806], ptr[807], ptr[808], ptr[809],
						   ptr[810], ptr[811], ptr[812], ptr[813], ptr[814],
						   ptr[815], ptr[816], ptr[817], ptr[818], ptr[819],
						   ptr[820], ptr[821], ptr[822], ptr[823], ptr[824],
						   ptr[825], ptr[826], ptr[827], ptr[828], ptr[829],
						   ptr[830], ptr[831], ptr[832], ptr[833], ptr[834],
						   ptr[835], ptr[836], ptr[837], ptr[838], ptr[839],
						   ptr[840], ptr[841], ptr[842], ptr[843], ptr[844],
						   ptr[845], ptr[846], ptr[847], ptr[848], ptr[849],
						   ptr[850], ptr[851], ptr[852], ptr[853], ptr[854],
						   ptr[855], ptr[856], ptr[857], ptr[858], ptr[859],
						   ptr[860], ptr[861], ptr[862], ptr[863], ptr[864],
						   ptr[865], ptr[866], ptr[867], ptr[868], ptr[869],
						   ptr[870], ptr[871], ptr[872], ptr[873], ptr[874],
						   ptr[875], ptr[876], ptr[877], ptr[878], ptr[879],
						   ptr[880], ptr[881], ptr[882], ptr[883], ptr[884],
						   ptr[885], ptr[886], ptr[887], ptr[888], ptr[889],
						   ptr[890], ptr[891], ptr[892], ptr[893], ptr[894],
						   ptr[895], ptr[896], ptr[897], ptr[898], ptr[899],
						   ptr[900], ptr[901], ptr[902], ptr[903], ptr[904],
						   ptr[905], ptr[906], ptr[907], ptr[908], ptr[909],
						   ptr[910], ptr[911], ptr[912], ptr[913], ptr[914],
						   ptr[915], ptr[916], ptr[917], ptr[918], ptr[919],
						   ptr[920], ptr[921], ptr[922], ptr[923], ptr[924],
						   ptr[925], ptr[926], ptr[927], ptr[928], ptr[929],
						   ptr[930], ptr[931], ptr[932], ptr[933], ptr[934],
						   ptr[935], ptr[936], ptr[937], ptr[938], ptr[939],
						   ptr[940], ptr[941], ptr[942], ptr[943], ptr[944],
						   ptr[945], ptr[946], ptr[947], ptr[948], ptr[949],
						   ptr[950], ptr[951], ptr[952], ptr[953], ptr[954],
						   ptr[955], ptr[956], ptr[957], ptr[958], ptr[959],
						   ptr[960], ptr[961], ptr[962], ptr[963], ptr[964],
						   ptr[965], ptr[966], ptr[967], ptr[968], ptr[969],
						   ptr[970], ptr[971], ptr[972], ptr[973], ptr[974],
						   ptr[975], ptr[976], ptr[977], ptr[978], ptr[979],
						   ptr[980], ptr[981], ptr[982], ptr[983], ptr[984],
						   ptr[985], ptr[986], ptr[987], ptr[988], ptr[989],
						   ptr[990], ptr[991], ptr[992], ptr[993], ptr[994],
						   ptr[995], ptr[996], ptr[997], ptr[998], ptr[999],
						   ptr[1000], ptr[1001], ptr[1002], ptr[1003], ptr[1004],
						   ptr[1005], ptr[1006], ptr[1007], ptr[1008], ptr[1009],
						   ptr[1010], ptr[1011], ptr[1012], ptr[1013], ptr[1014],
						   ptr[1015], ptr[1016], ptr[1017], ptr[1018], ptr[1019],
						   ptr[1020], ptr[1021], ptr[1022], ptr[1023], ptr[1024],
						   ptr[1025], ptr[1026], ptr[1027], ptr[1028], ptr[1029],
						   ptr[1030], ptr[1031], ptr[1032], ptr[1033], ptr[1034],
						   ptr[1035], ptr[1036], ptr[1037], ptr[1038], ptr[1039],
						   ptr[1040], ptr[1041], ptr[1042], ptr[1043], ptr[1044],
						   ptr[1045], ptr[1046], ptr[1047], ptr[1048], ptr[1049],
						   ptr[1050], ptr[1051], ptr[1052], ptr[1053], ptr[1054],
						   ptr[1055], ptr[1056], ptr[1057], ptr[1058], ptr[1059],
						   ptr[1060], ptr[1061], ptr[1062], ptr[1063], ptr[1064],
						   ptr[1065], ptr[1066], ptr[1067], ptr[1068], ptr[1069],
						   ptr[1070], ptr[1071], ptr[1072], ptr[1073], ptr[1074],
						   ptr[1075], ptr[1076], ptr[1077], ptr[1078], ptr[1079],
						   ptr[1080], ptr[1081], ptr[1082], ptr[1083], ptr[1084],
						   ptr[1085], ptr[1086], ptr[1087], ptr[1088], ptr[1089],
						   ptr[1090], ptr[1091], ptr[1092], ptr[1093], ptr[1094],
						   ptr[1095], ptr[1096], ptr[1097], ptr[1098], ptr[1099],
						   ptr[1100], ptr[1101], ptr[1102], ptr[1103], ptr[1104],
						   ptr[1105], ptr[1106], ptr[1107], ptr[1108], ptr[1109],
						   ptr[1110], ptr[1111], ptr[1112], ptr[1113], ptr[1114],
						   ptr[1115], ptr[1116], ptr[1117], ptr[1118], ptr[1119],
						   ptr[1120], ptr[1121], ptr[1122], ptr[1123], ptr[1124],
						   ptr[1125], ptr[1126], ptr[1127], ptr[1128], ptr[1129],
						   ptr[1130], ptr[1131], ptr[1132], ptr[1133], ptr[1134],
						   ptr[1135], ptr[1136], ptr[1137], ptr[1138], ptr[1139],
						   ptr[1140], ptr[1141], ptr[1142], ptr[1143], ptr[1144],
						   ptr[1145], ptr[1146], ptr[1147], ptr[1148], ptr[1149],
						   ptr[1150], ptr[1151], ptr[1152], ptr[1153], ptr[1154],
						   ptr[1155], ptr[1156], ptr[1157], ptr[1158], ptr[1159],
						   ptr[1160], ptr[1161], ptr[1162], ptr[1163], ptr[1164],
						   ptr[1165], ptr[1166], ptr[1167], ptr[1168], ptr[1169],
						   ptr[1170], ptr[1171], ptr[1172], ptr[1173], ptr[1174],
						   ptr[1175], ptr[1176], ptr[1177], ptr[1178], ptr[1179],
						   ptr[1180], ptr[1181], ptr[1182], ptr[1183], ptr[1184],
						   ptr[1185], ptr[1186], ptr[1187], ptr[1188], ptr[1189],
						   ptr[1190], ptr[1191], ptr[1192], ptr[1193], ptr[1194],
						   ptr[1195], ptr[1196], ptr[1197], ptr[1198], ptr[1199],
						   ptr[1200], ptr[1201], ptr[1202], ptr[1203], ptr[1204],
						   ptr[1205], ptr[1206], ptr[1207], ptr[1208], ptr[1209],
						   ptr[1210], ptr[1211], ptr[1212], ptr[1213], ptr[1214],
						   ptr[1215], ptr[1216], ptr[1217], ptr[1218], ptr[1219],
						   ptr[1220], ptr[1221], ptr[1222], ptr[1223], ptr[1224],
						   ptr[1225], ptr[1226], ptr[1227], ptr[1228], ptr[1229],
						   ptr[1230], ptr[1231], ptr[1232], ptr[1233], ptr[1234],
						   ptr[1235], ptr[1236], ptr[1237], ptr[1238], ptr[1239],
						   ptr[1240], ptr[1241], ptr[1242], ptr[1243], ptr[1244],
						   ptr[1245], ptr[1246], ptr[1247], ptr[1248], ptr[1249],
						   ptr[1250], ptr[1251], ptr[1252], ptr[1253], ptr[1254],
						   ptr[1255], ptr[1256], ptr[1257], ptr[1258], ptr[1259],
						   ptr[1260], ptr[1261], ptr[1262], ptr[1263], ptr[1264],
						   ptr[1265], ptr[1266], ptr[1267], ptr[1268], ptr[1269],
						   ptr[1270], ptr[1271], ptr[1272], ptr[1273], ptr[1274],
						   ptr[1275], ptr[1276], ptr[1277], ptr[1278], ptr[1279],
						   ptr[1280], ptr[1281], ptr[1282], ptr[1283], ptr[1284],
						   ptr[1285], ptr[1286], ptr[1287], ptr[1288], ptr[1289],
						   ptr[1290], ptr[1291], ptr[1292], ptr[1293], ptr[1294],
						   ptr[1295], ptr[1296], ptr[1297], ptr[1298], ptr[1299],
						   ptr[1300], ptr[1301], ptr[1302], ptr[1303], ptr[1304],
						   ptr[1305], ptr[1306], ptr[1307], ptr[1308], ptr[1309],
						   ptr[1310], ptr[1311], ptr[1312], ptr[1313], ptr[1314],
						   ptr[1315], ptr[1316], ptr[1317], ptr[1318], ptr[1319],
						   ptr[1320], ptr[1321], ptr[1322], ptr[1323], ptr[1324]);
	    } else {
		comp[ci].ptr = NULL;
	    }
	    if (comp_type[i].gui_create) {
		comp[ci].gui_ptr = comp_type[i].gui_create(comp[ci].page, comp[ci].name,
							   ptr[0], ptr[1], ptr[2], ptr[3], ptr[4],
							   ptr[5], ptr[6], ptr[7], ptr[8], ptr[9],
							   ptr[10], ptr[11], ptr[12], ptr[13], ptr[14],
							   ptr[15], ptr[16], ptr[17], ptr[18], ptr[19],
							   ptr[20], ptr[21], ptr[22], ptr[23], ptr[24],
							   ptr[25], ptr[26], ptr[27], ptr[28], ptr[29],
							   ptr[30], ptr[31], ptr[32], ptr[33], ptr[34],
							   ptr[35], ptr[36], ptr[37], ptr[38], ptr[39],
							   ptr[40], ptr[41], ptr[42], ptr[43], ptr[44],
							   ptr[45], ptr[46], ptr[47], ptr[48], ptr[49],
							   ptr[50], ptr[51], ptr[52], ptr[53], ptr[54],
							   ptr[55], ptr[56], ptr[57], ptr[58], ptr[59],
							   ptr[60], ptr[61], ptr[62], ptr[63], ptr[64],
							   ptr[65], ptr[66], ptr[67], ptr[68], ptr[69],
							   ptr[70], ptr[71], ptr[72], ptr[73], ptr[74],
							   ptr[75], ptr[76], ptr[77], ptr[78], ptr[79],
							   ptr[80], ptr[81], ptr[82], ptr[83], ptr[84],
							   ptr[85], ptr[86], ptr[87], ptr[88], ptr[89],
							   ptr[90], ptr[91], ptr[92], ptr[93], ptr[94],
							   ptr[95], ptr[96], ptr[97], ptr[98], ptr[99],
							   ptr[100], ptr[101], ptr[102], ptr[103], ptr[104],
							   ptr[105], ptr[106], ptr[107], ptr[108], ptr[109],
							   ptr[110], ptr[111], ptr[112], ptr[113], ptr[114],
							   ptr[115], ptr[116], ptr[117], ptr[118], ptr[119],
							   ptr[120], ptr[121], ptr[122], ptr[123], ptr[124],
							   ptr[125], ptr[126], ptr[127], ptr[128], ptr[129],
							   ptr[130], ptr[131], ptr[132], ptr[133], ptr[134],
							   ptr[135], ptr[136], ptr[137], ptr[138], ptr[139],
							   ptr[140], ptr[141], ptr[142], ptr[143], ptr[144],
							   ptr[145], ptr[146], ptr[147], ptr[148], ptr[149],
							   ptr[150], ptr[151], ptr[152], ptr[153], ptr[154],
							   ptr[155], ptr[156], ptr[157], ptr[158], ptr[159],
							   ptr[160], ptr[161], ptr[162], ptr[163], ptr[164],
							   ptr[165], ptr[166], ptr[167], ptr[168], ptr[169],
							   ptr[170], ptr[171], ptr[172], ptr[173], ptr[174],
							   ptr[175], ptr[176], ptr[177], ptr[178], ptr[179],
							   ptr[180], ptr[181], ptr[182], ptr[183], ptr[184],
							   ptr[185], ptr[186], ptr[187], ptr[188], ptr[189],
							   ptr[190], ptr[191], ptr[192], ptr[193], ptr[194],
							   ptr[195], ptr[196], ptr[197], ptr[198], ptr[199],
							   ptr[200], ptr[201], ptr[202], ptr[203], ptr[204],
							   ptr[205], ptr[206], ptr[207], ptr[208], ptr[209],
							   ptr[210], ptr[211], ptr[212], ptr[213], ptr[214],
							   ptr[215], ptr[216], ptr[217], ptr[218], ptr[219],
							   ptr[220], ptr[221], ptr[222], ptr[223], ptr[224],
							   ptr[225], ptr[226], ptr[227], ptr[228], ptr[229],
							   ptr[230], ptr[231], ptr[232], ptr[233], ptr[234],
							   ptr[235], ptr[236], ptr[237], ptr[238], ptr[239],
							   ptr[240], ptr[241], ptr[242], ptr[243], ptr[244],
							   ptr[245], ptr[246], ptr[247], ptr[248], ptr[249],
							   ptr[250], ptr[251], ptr[252], ptr[253], ptr[254],
							   ptr[255], ptr[256], ptr[257], ptr[258], ptr[259],
							   ptr[260], ptr[261], ptr[262], ptr[263], ptr[264],
							   ptr[265], ptr[266], ptr[267], ptr[268], ptr[269],
							   ptr[270], ptr[271], ptr[272], ptr[273], ptr[274],
							   ptr[275], ptr[276], ptr[277], ptr[278], ptr[279],
							   ptr[280], ptr[281], ptr[282], ptr[283], ptr[284],
							   ptr[285], ptr[286], ptr[287], ptr[288], ptr[289],
							   ptr[290], ptr[291], ptr[292], ptr[293], ptr[294],
							   ptr[295], ptr[296], ptr[297], ptr[298], ptr[299],
							   ptr[300], ptr[301], ptr[302], ptr[303], ptr[304],
							   ptr[305], ptr[306], ptr[307], ptr[308], ptr[309],
							   ptr[310], ptr[311], ptr[312], ptr[313], ptr[314],
							   ptr[315], ptr[316], ptr[317], ptr[318], ptr[319],
							   ptr[320], ptr[321], ptr[322], ptr[323], ptr[324],
							   ptr[325], ptr[326], ptr[327], ptr[328], ptr[329],
							   ptr[330], ptr[331], ptr[332], ptr[333], ptr[334],
							   ptr[335], ptr[336], ptr[337], ptr[338], ptr[339],
							   ptr[340], ptr[341], ptr[342], ptr[343], ptr[344],
							   ptr[345], ptr[346], ptr[347], ptr[348], ptr[349],
							   ptr[350], ptr[351], ptr[352], ptr[353], ptr[354],
							   ptr[355], ptr[356], ptr[357], ptr[358], ptr[359],
							   ptr[360], ptr[361], ptr[362], ptr[363], ptr[364],
							   ptr[365], ptr[366], ptr[367], ptr[368], ptr[369],
							   ptr[370], ptr[371], ptr[372], ptr[373], ptr[374],
							   ptr[375], ptr[376], ptr[377], ptr[378], ptr[379],
							   ptr[380], ptr[381], ptr[382], ptr[383], ptr[384],
							   ptr[385], ptr[386], ptr[387], ptr[388], ptr[389],
							   ptr[390], ptr[391], ptr[392], ptr[393], ptr[394],
							   ptr[395], ptr[396], ptr[397], ptr[398], ptr[399],
							   ptr[400], ptr[401], ptr[402], ptr[403], ptr[404],
							   ptr[405], ptr[406], ptr[407], ptr[408], ptr[409],
							   ptr[410], ptr[411], ptr[412], ptr[413], ptr[414],
							   ptr[415], ptr[416], ptr[417], ptr[418], ptr[419],
							   ptr[420], ptr[421], ptr[422], ptr[423], ptr[424],
							   ptr[425], ptr[426], ptr[427], ptr[428], ptr[429],
							   ptr[430], ptr[431], ptr[432], ptr[433], ptr[434],
							   ptr[435], ptr[436], ptr[437], ptr[438], ptr[439],
							   ptr[440], ptr[441], ptr[442], ptr[443], ptr[444],
							   ptr[445], ptr[446], ptr[447], ptr[448], ptr[449],
							   ptr[450], ptr[451], ptr[452], ptr[453], ptr[454],
							   ptr[455], ptr[456], ptr[457], ptr[458], ptr[459],
							   ptr[460], ptr[461], ptr[462], ptr[463], ptr[464],
							   ptr[465], ptr[466], ptr[467], ptr[468], ptr[469],
							   ptr[470], ptr[471], ptr[472], ptr[473], ptr[474],
							   ptr[475], ptr[476], ptr[477], ptr[478], ptr[479],
							   ptr[480], ptr[481], ptr[482], ptr[483], ptr[484],
							   ptr[485], ptr[486], ptr[487], ptr[488], ptr[489],
							   ptr[490], ptr[491], ptr[492], ptr[493], ptr[494],
							   ptr[495], ptr[496], ptr[497], ptr[498], ptr[499],
							   ptr[500], ptr[501], ptr[502], ptr[503], ptr[504],
							   ptr[505], ptr[506], ptr[507], ptr[508], ptr[509],
							   ptr[510], ptr[511], ptr[512], ptr[513], ptr[514],
							   ptr[515], ptr[516], ptr[517], ptr[518], ptr[519],
							   ptr[520], ptr[521], ptr[522], ptr[523], ptr[524],
							   ptr[525], ptr[526], ptr[527], ptr[528], ptr[529],
							   ptr[530], ptr[531], ptr[532], ptr[533], ptr[534],
							   ptr[535], ptr[536], ptr[537], ptr[538], ptr[539],
							   ptr[540], ptr[541], ptr[542], ptr[543], ptr[544],
							   ptr[545], ptr[546], ptr[547], ptr[548], ptr[549],
							   ptr[550], ptr[551], ptr[552], ptr[553], ptr[554],
							   ptr[555], ptr[556], ptr[557], ptr[558], ptr[559],
							   ptr[560], ptr[561], ptr[562], ptr[563], ptr[564],
							   ptr[565], ptr[566], ptr[567], ptr[568], ptr[569],
							   ptr[570], ptr[571], ptr[572], ptr[573], ptr[574],
							   ptr[575], ptr[576], ptr[577], ptr[578], ptr[579],
							   ptr[580], ptr[581], ptr[582], ptr[583], ptr[584],
							   ptr[585], ptr[586], ptr[587], ptr[588], ptr[589],
							   ptr[590], ptr[591], ptr[592], ptr[593], ptr[594],
							   ptr[595], ptr[596], ptr[597], ptr[598], ptr[599],
							   ptr[600], ptr[601], ptr[602], ptr[603], ptr[604],
							   ptr[605], ptr[606], ptr[607], ptr[608], ptr[609],
							   ptr[610], ptr[611], ptr[612], ptr[613], ptr[614],
							   ptr[615], ptr[616], ptr[617], ptr[618], ptr[619],
							   ptr[620], ptr[621], ptr[622], ptr[623], ptr[624],
							   ptr[625], ptr[626], ptr[627], ptr[628], ptr[629],
							   ptr[630], ptr[631], ptr[632], ptr[633], ptr[634],
							   ptr[635], ptr[636], ptr[637], ptr[638], ptr[639],
							   ptr[640], ptr[641], ptr[642], ptr[643], ptr[644],
							   ptr[645], ptr[646], ptr[647], ptr[648], ptr[649],
							   ptr[650], ptr[651], ptr[652], ptr[653], ptr[654],
							   ptr[655], ptr[656], ptr[657], ptr[658], ptr[659],
							   ptr[660], ptr[661], ptr[662], ptr[663], ptr[664],
							   ptr[665], ptr[666], ptr[667], ptr[668], ptr[669],
							   ptr[670], ptr[671], ptr[672], ptr[673], ptr[674],
							   ptr[675], ptr[676], ptr[677], ptr[678], ptr[679],
							   ptr[680], ptr[681], ptr[682], ptr[683], ptr[684],
							   ptr[685], ptr[686], ptr[687], ptr[688], ptr[689],
							   ptr[690], ptr[691], ptr[692], ptr[693], ptr[694],
							   ptr[695], ptr[696], ptr[697], ptr[698], ptr[699],
							   ptr[700], ptr[701], ptr[702], ptr[703], ptr[704],
							   ptr[705], ptr[706], ptr[707], ptr[708], ptr[709],
							   ptr[710], ptr[711], ptr[712], ptr[713], ptr[714],
							   ptr[715], ptr[716], ptr[717], ptr[718], ptr[719],
							   ptr[720], ptr[721], ptr[722], ptr[723], ptr[724],
							   ptr[725], ptr[726], ptr[727], ptr[728], ptr[729],
							   ptr[730], ptr[731], ptr[732], ptr[733], ptr[734],
							   ptr[735], ptr[736], ptr[737], ptr[738], ptr[739],
							   ptr[740], ptr[741], ptr[742], ptr[743], ptr[744],
							   ptr[745], ptr[746], ptr[747], ptr[748], ptr[749],
							   ptr[750], ptr[751], ptr[752], ptr[753], ptr[754],
							   ptr[755], ptr[756], ptr[757], ptr[758], ptr[759],
							   ptr[760], ptr[761], ptr[762], ptr[763], ptr[764],
							   ptr[765], ptr[766], ptr[767], ptr[768], ptr[769],
							   ptr[770], ptr[771], ptr[772], ptr[773], ptr[774],
							   ptr[775], ptr[776], ptr[777], ptr[778], ptr[779],
							   ptr[780], ptr[781], ptr[782], ptr[783], ptr[784],
							   ptr[785], ptr[786], ptr[787], ptr[788], ptr[789],
							   ptr[790], ptr[791], ptr[792], ptr[793], ptr[794],
							   ptr[795], ptr[796], ptr[797], ptr[798], ptr[799],
							   ptr[800], ptr[801], ptr[802], ptr[803], ptr[804],
							   ptr[805], ptr[806], ptr[807], ptr[808], ptr[809],
							   ptr[810], ptr[811], ptr[812], ptr[813], ptr[814],
							   ptr[815], ptr[816], ptr[817], ptr[818], ptr[819],
							   ptr[820], ptr[821], ptr[822], ptr[823], ptr[824],
							   ptr[825], ptr[826], ptr[827], ptr[828], ptr[829],
							   ptr[830], ptr[831], ptr[832], ptr[833], ptr[834],
							   ptr[835], ptr[836], ptr[837], ptr[838], ptr[839],
							   ptr[840], ptr[841], ptr[842], ptr[843], ptr[844],
							   ptr[845], ptr[846], ptr[847], ptr[848], ptr[849],
							   ptr[850], ptr[851], ptr[852], ptr[853], ptr[854],
							   ptr[855], ptr[856], ptr[857], ptr[858], ptr[859],
							   ptr[860], ptr[861], ptr[862], ptr[863], ptr[864],
							   ptr[865], ptr[866], ptr[867], ptr[868], ptr[869],
							   ptr[870], ptr[871], ptr[872], ptr[873], ptr[874],
							   ptr[875], ptr[876], ptr[877], ptr[878], ptr[879],
							   ptr[880], ptr[881], ptr[882], ptr[883], ptr[884],
							   ptr[885], ptr[886], ptr[887], ptr[888], ptr[889],
							   ptr[890], ptr[891], ptr[892], ptr[893], ptr[894],
							   ptr[895], ptr[896], ptr[897], ptr[898], ptr[899],
							   ptr[900], ptr[901], ptr[902], ptr[903], ptr[904],
							   ptr[905], ptr[906], ptr[907], ptr[908], ptr[909],
							   ptr[910], ptr[911], ptr[912], ptr[913], ptr[914],
							   ptr[915], ptr[916], ptr[917], ptr[918], ptr[919],
							   ptr[920], ptr[921], ptr[922], ptr[923], ptr[924],
							   ptr[925], ptr[926], ptr[927], ptr[928], ptr[929],
							   ptr[930], ptr[931], ptr[932], ptr[933], ptr[934],
							   ptr[935], ptr[936], ptr[937], ptr[938], ptr[939],
							   ptr[940], ptr[941], ptr[942], ptr[943], ptr[944],
							   ptr[945], ptr[946], ptr[947], ptr[948], ptr[949],
							   ptr[950], ptr[951], ptr[952], ptr[953], ptr[954],
							   ptr[955], ptr[956], ptr[957], ptr[958], ptr[959],
							   ptr[960], ptr[961], ptr[962], ptr[963], ptr[964],
							   ptr[965], ptr[966], ptr[967], ptr[968], ptr[969],
							   ptr[970], ptr[971], ptr[972], ptr[973], ptr[974],
							   ptr[975], ptr[976], ptr[977], ptr[978], ptr[979],
							   ptr[980], ptr[981], ptr[982], ptr[983], ptr[984],
							   ptr[985], ptr[986], ptr[987], ptr[988], ptr[989],
							   ptr[990], ptr[991], ptr[992], ptr[993], ptr[994],
							   ptr[995], ptr[996], ptr[997], ptr[998], ptr[999],
							   ptr[1000], ptr[1001], ptr[1002], ptr[1003], ptr[1004],
							   ptr[1005], ptr[1006], ptr[1007], ptr[1008], ptr[1009],
							   ptr[1010], ptr[1011], ptr[1012], ptr[1013], ptr[1014],
							   ptr[1015], ptr[1016], ptr[1017], ptr[1018], ptr[1019],
							   ptr[1020], ptr[1021], ptr[1022], ptr[1023], ptr[1024],
							   ptr[1025], ptr[1026], ptr[1027], ptr[1028], ptr[1029],
							   ptr[1030], ptr[1031], ptr[1032], ptr[1033], ptr[1034],
							   ptr[1035], ptr[1036], ptr[1037], ptr[1038], ptr[1039],
							   ptr[1040], ptr[1041], ptr[1042], ptr[1043], ptr[1044],
							   ptr[1045], ptr[1046], ptr[1047], ptr[1048], ptr[1049],
							   ptr[1050], ptr[1051], ptr[1052], ptr[1053], ptr[1054],
							   ptr[1055], ptr[1056], ptr[1057], ptr[1058], ptr[1059],
							   ptr[1060], ptr[1061], ptr[1062], ptr[1063], ptr[1064],
							   ptr[1065], ptr[1066], ptr[1067], ptr[1068], ptr[1069],
							   ptr[1070], ptr[1071], ptr[1072], ptr[1073], ptr[1074],
							   ptr[1075], ptr[1076], ptr[1077], ptr[1078], ptr[1079],
							   ptr[1080], ptr[1081], ptr[1082], ptr[1083], ptr[1084],
							   ptr[1085], ptr[1086], ptr[1087], ptr[1088], ptr[1089],
							   ptr[1090], ptr[1091], ptr[1092], ptr[1093], ptr[1094],
							   ptr[1095], ptr[1096], ptr[1097], ptr[1098], ptr[1099],
							   ptr[1100], ptr[1101], ptr[1102], ptr[1103], ptr[1104],
							   ptr[1105], ptr[1106], ptr[1107], ptr[1108], ptr[1109],
							   ptr[1110], ptr[1111], ptr[1112], ptr[1113], ptr[1114],
							   ptr[1115], ptr[1116], ptr[1117], ptr[1118], ptr[1119],
							   ptr[1120], ptr[1121], ptr[1122], ptr[1123], ptr[1124],
							   ptr[1125], ptr[1126], ptr[1127], ptr[1128], ptr[1129],
							   ptr[1130], ptr[1131], ptr[1132], ptr[1133], ptr[1134],
							   ptr[1135], ptr[1136], ptr[1137], ptr[1138], ptr[1139],
							   ptr[1140], ptr[1141], ptr[1142], ptr[1143], ptr[1144],
							   ptr[1145], ptr[1146], ptr[1147], ptr[1148], ptr[1149],
							   ptr[1150], ptr[1151], ptr[1152], ptr[1153], ptr[1154],
							   ptr[1155], ptr[1156], ptr[1157], ptr[1158], ptr[1159],
							   ptr[1160], ptr[1161], ptr[1162], ptr[1163], ptr[1164],
							   ptr[1165], ptr[1166], ptr[1167], ptr[1168], ptr[1169],
							   ptr[1170], ptr[1171], ptr[1172], ptr[1173], ptr[1174],
							   ptr[1175], ptr[1176], ptr[1177], ptr[1178], ptr[1179],
							   ptr[1180], ptr[1181], ptr[1182], ptr[1183], ptr[1184],
							   ptr[1185], ptr[1186], ptr[1187], ptr[1188], ptr[1189],
							   ptr[1190], ptr[1191], ptr[1192], ptr[1193], ptr[1194],
							   ptr[1195], ptr[1196], ptr[1197], ptr[1198], ptr[1199],
							   ptr[1200], ptr[1201], ptr[1202], ptr[1203], ptr[1204],
							   ptr[1205], ptr[1206], ptr[1207], ptr[1208], ptr[1209],
							   ptr[1210], ptr[1211], ptr[1212], ptr[1213], ptr[1214],
							   ptr[1215], ptr[1216], ptr[1217], ptr[1218], ptr[1219],
							   ptr[1220], ptr[1221], ptr[1222], ptr[1223], ptr[1224],
							   ptr[1225], ptr[1226], ptr[1227], ptr[1228], ptr[1229],
							   ptr[1230], ptr[1231], ptr[1232], ptr[1233], ptr[1234],
							   ptr[1235], ptr[1236], ptr[1237], ptr[1238], ptr[1239],
							   ptr[1240], ptr[1241], ptr[1242], ptr[1243], ptr[1244],
							   ptr[1245], ptr[1246], ptr[1247], ptr[1248], ptr[1249],
							   ptr[1250], ptr[1251], ptr[1252], ptr[1253], ptr[1254],
							   ptr[1255], ptr[1256], ptr[1257], ptr[1258], ptr[1259],
							   ptr[1260], ptr[1261], ptr[1262], ptr[1263], ptr[1264],
							   ptr[1265], ptr[1266], ptr[1267], ptr[1268], ptr[1269],
							   ptr[1270], ptr[1271], ptr[1272], ptr[1273], ptr[1274],
							   ptr[1275], ptr[1276], ptr[1277], ptr[1278], ptr[1279],
							   ptr[1280], ptr[1281], ptr[1282], ptr[1283], ptr[1284],
							   ptr[1285], ptr[1286], ptr[1287], ptr[1288], ptr[1289],
							   ptr[1290], ptr[1291], ptr[1292], ptr[1293], ptr[1294],
							   ptr[1295], ptr[1296], ptr[1297], ptr[1298], ptr[1299],
							   ptr[1300], ptr[1301], ptr[1302], ptr[1303], ptr[1304],
							   ptr[1305], ptr[1306], ptr[1307], ptr[1308], ptr[1309],
							   ptr[1310], ptr[1311], ptr[1312], ptr[1313], ptr[1314],
							   ptr[1315], ptr[1316], ptr[1317], ptr[1318], ptr[1319],
							   ptr[1320], ptr[1321], ptr[1322], ptr[1323], ptr[1324],
							   ptr[1325], ptr[1326], ptr[1327], ptr[1328], ptr[1329],
							   ptr[1330], ptr[1331], ptr[1332], ptr[1333], ptr[1334],
							   ptr[1335], ptr[1336], ptr[1337], ptr[1338], ptr[1339],
							   ptr[1340], ptr[1341], ptr[1342], ptr[1343], ptr[1344],
							   ptr[1345], ptr[1346], ptr[1347], ptr[1348], ptr[1349],
							   ptr[1350], ptr[1351], ptr[1352], ptr[1353], ptr[1354],
							   ptr[1355], ptr[1356], ptr[1357], ptr[1358], ptr[1359],
							   ptr[1360], ptr[1361], ptr[1362], ptr[1363], ptr[1364],
							   ptr[1365], ptr[1366], ptr[1367], ptr[1368], ptr[1369],
							   ptr[1370], ptr[1371], ptr[1372], ptr[1373], ptr[1374],
							   ptr[1375], ptr[1376], ptr[1377], ptr[1378], ptr[1379],
							   ptr[1380], ptr[1381], ptr[1382], ptr[1383], ptr[1384],
							   ptr[1385], ptr[1386], ptr[1387], ptr[1388], ptr[1389],
							   ptr[1390], ptr[1391], ptr[1392], ptr[1393], ptr[1394],
							   ptr[1395], ptr[1396], ptr[1397], ptr[1398], ptr[1399],
							   ptr[1400], ptr[1401], ptr[1402], ptr[1403], ptr[1404],
							   ptr[1405], ptr[1406], ptr[1407], ptr[1408], ptr[1409],
							   ptr[1410], ptr[1411], ptr[1412], ptr[1413], ptr[1414],
							   ptr[1415], ptr[1416], ptr[1417], ptr[1418], ptr[1419],
							   ptr[1420], ptr[1421], ptr[1422], ptr[1423], ptr[1424],
							   ptr[1425], ptr[1426], ptr[1427], ptr[1428], ptr[1429],
							   ptr[1430], ptr[1431], ptr[1432], ptr[1433], ptr[1434],
							   ptr[1435], ptr[1436], ptr[1437], ptr[1438], ptr[1439],
							   ptr[1440], ptr[1441], ptr[1442], ptr[1443], ptr[1444],
							   ptr[1445], ptr[1446], ptr[1447], ptr[1448], ptr[1449],
							   ptr[1450], ptr[1451], ptr[1452], ptr[1453], ptr[1454],
							   ptr[1455], ptr[1456], ptr[1457], ptr[1458], ptr[1459],
							   ptr[1460], ptr[1461], ptr[1462], ptr[1463], ptr[1464],
							   ptr[1465], ptr[1466], ptr[1467], ptr[1468], ptr[1469],
							   ptr[1470], ptr[1471], ptr[1472], ptr[1473], ptr[1474],
							   ptr[1475], ptr[1476], ptr[1477], ptr[1478], ptr[1479],
							   ptr[1480], ptr[1481], ptr[1482], ptr[1483], ptr[1484],
							   ptr[1485], ptr[1486], ptr[1487], ptr[1488], ptr[1489],
							   ptr[1490], ptr[1491], ptr[1492], ptr[1493], ptr[1494],
							   ptr[1495], ptr[1496], ptr[1497], ptr[1498], ptr[1499]);
	    } else {
		comp[ci].gui_ptr = NULL;
	    }
	    if (comp_type[i].aui_create) {
		comp[ci].aui_ptr = comp_type[i].aui_create(comp[ci].name,
							   ptr[0], ptr[1], ptr[2], ptr[3], ptr[4],
							   ptr[5], ptr[6], ptr[7], ptr[8], ptr[9],
							   ptr[10], ptr[11], ptr[12], ptr[13], ptr[14],
							   ptr[15], ptr[16], ptr[17], ptr[18], ptr[19],
							   ptr[20], ptr[21], ptr[22], ptr[23], ptr[24],
							   ptr[25], ptr[26], ptr[27], ptr[28], ptr[29],
							   ptr[30], ptr[31], ptr[32], ptr[33], ptr[34],
							   ptr[35], ptr[36], ptr[37], ptr[38], ptr[39],
							   ptr[40], ptr[41], ptr[42], ptr[43], ptr[44],
							   ptr[45], ptr[46], ptr[47], ptr[48], ptr[49],
							   ptr[50], ptr[51], ptr[52], ptr[53], ptr[54],
							   ptr[55], ptr[56], ptr[57], ptr[58], ptr[59],
							   ptr[60], ptr[61], ptr[62], ptr[63], ptr[64],
							   ptr[65], ptr[66], ptr[67], ptr[68], ptr[69],
							   ptr[70], ptr[71], ptr[72], ptr[73], ptr[74],
							   ptr[75], ptr[76], ptr[77], ptr[78], ptr[79],
							   ptr[80], ptr[81], ptr[82], ptr[83], ptr[84],
							   ptr[85], ptr[86], ptr[87], ptr[88], ptr[89],
							   ptr[90], ptr[91], ptr[92], ptr[93], ptr[94],
							   ptr[95], ptr[96], ptr[97], ptr[98], ptr[99],
							   ptr[100], ptr[101], ptr[102], ptr[103], ptr[104],
							   ptr[105], ptr[106], ptr[107], ptr[108], ptr[109],
							   ptr[110], ptr[111], ptr[112], ptr[113], ptr[114],
							   ptr[115], ptr[116], ptr[117], ptr[118], ptr[119],
							   ptr[120], ptr[121], ptr[122], ptr[123], ptr[124],
							   ptr[125], ptr[126], ptr[127], ptr[128], ptr[129],
							   ptr[130], ptr[131], ptr[132], ptr[133], ptr[134],
							   ptr[135], ptr[136], ptr[137], ptr[138], ptr[139],
							   ptr[140], ptr[141], ptr[142], ptr[143], ptr[144],
							   ptr[145], ptr[146], ptr[147], ptr[148], ptr[149],
							   ptr[150], ptr[151], ptr[152], ptr[153], ptr[154],
							   ptr[155], ptr[156], ptr[157], ptr[158], ptr[159],
							   ptr[160], ptr[161], ptr[162], ptr[163], ptr[164],
							   ptr[165], ptr[166], ptr[167], ptr[168], ptr[169],
							   ptr[170], ptr[171], ptr[172], ptr[173], ptr[174],
							   ptr[175], ptr[176], ptr[177], ptr[178], ptr[179],
							   ptr[180], ptr[181], ptr[182], ptr[183], ptr[184],
							   ptr[185], ptr[186], ptr[187], ptr[188], ptr[189],
							   ptr[190], ptr[191], ptr[192], ptr[193], ptr[194],
							   ptr[195], ptr[196], ptr[197], ptr[198], ptr[199],
							   ptr[200], ptr[201], ptr[202], ptr[203], ptr[204],
							   ptr[205], ptr[206], ptr[207], ptr[208], ptr[209],
							   ptr[210], ptr[211], ptr[212], ptr[213], ptr[214],
							   ptr[215], ptr[216], ptr[217], ptr[218], ptr[219],
							   ptr[220], ptr[221], ptr[222], ptr[223], ptr[224],
							   ptr[225], ptr[226], ptr[227], ptr[228], ptr[229],
							   ptr[230], ptr[231], ptr[232], ptr[233], ptr[234],
							   ptr[235], ptr[236], ptr[237], ptr[238], ptr[239],
							   ptr[240], ptr[241], ptr[242], ptr[243], ptr[244],
							   ptr[245], ptr[246], ptr[247], ptr[248], ptr[249],
							   ptr[250], ptr[251], ptr[252], ptr[253], ptr[254],
							   ptr[255], ptr[256], ptr[257], ptr[258], ptr[259],
							   ptr[260], ptr[261], ptr[262], ptr[263], ptr[264],
							   ptr[265], ptr[266], ptr[267], ptr[268], ptr[269],
							   ptr[270], ptr[271], ptr[272], ptr[273], ptr[274],
							   ptr[275], ptr[276], ptr[277], ptr[278], ptr[279],
							   ptr[280], ptr[281], ptr[282], ptr[283], ptr[284],
							   ptr[285], ptr[286], ptr[287], ptr[288], ptr[289],
							   ptr[290], ptr[291], ptr[292], ptr[293], ptr[294],
							   ptr[295], ptr[296], ptr[297], ptr[298], ptr[299],
							   ptr[300], ptr[301], ptr[302], ptr[303], ptr[304],
							   ptr[305], ptr[306], ptr[307], ptr[308], ptr[309],
							   ptr[310], ptr[311], ptr[312], ptr[313], ptr[314],
							   ptr[315], ptr[316], ptr[317], ptr[318], ptr[319],
							   ptr[320], ptr[321], ptr[322], ptr[323], ptr[324],
							   ptr[325], ptr[326], ptr[327], ptr[328], ptr[329],
							   ptr[330], ptr[331], ptr[332], ptr[333], ptr[334],
							   ptr[335], ptr[336], ptr[337], ptr[338], ptr[339],
							   ptr[340], ptr[341], ptr[342], ptr[343], ptr[344],
							   ptr[345], ptr[346], ptr[347], ptr[348], ptr[349],
							   ptr[350], ptr[351], ptr[352], ptr[353], ptr[354],
							   ptr[355], ptr[356], ptr[357], ptr[358], ptr[359],
							   ptr[360], ptr[361], ptr[362], ptr[363], ptr[364],
							   ptr[365], ptr[366], ptr[367], ptr[368], ptr[369],
							   ptr[370], ptr[371], ptr[372], ptr[373], ptr[374],
							   ptr[375], ptr[376], ptr[377], ptr[378], ptr[379],
							   ptr[380], ptr[381], ptr[382], ptr[383], ptr[384],
							   ptr[385], ptr[386], ptr[387], ptr[388], ptr[389],
							   ptr[390], ptr[391], ptr[392], ptr[393], ptr[394],
							   ptr[395], ptr[396], ptr[397], ptr[398], ptr[399],
							   ptr[400], ptr[401], ptr[402], ptr[403], ptr[404],
							   ptr[405], ptr[406], ptr[407], ptr[408], ptr[409],
							   ptr[410], ptr[411], ptr[412], ptr[413], ptr[414],
							   ptr[415], ptr[416], ptr[417], ptr[418], ptr[419],
							   ptr[420], ptr[421], ptr[422], ptr[423], ptr[424],
							   ptr[425], ptr[426], ptr[427], ptr[428], ptr[429],
							   ptr[430], ptr[431], ptr[432], ptr[433], ptr[434],
							   ptr[435], ptr[436], ptr[437], ptr[438], ptr[439],
							   ptr[440], ptr[441], ptr[442], ptr[443], ptr[444],
							   ptr[445], ptr[446], ptr[447], ptr[448], ptr[449],
							   ptr[450], ptr[451], ptr[452], ptr[453], ptr[454],
							   ptr[455], ptr[456], ptr[457], ptr[458], ptr[459],
							   ptr[460], ptr[461], ptr[462], ptr[463], ptr[464],
							   ptr[465], ptr[466], ptr[467], ptr[468], ptr[469],
							   ptr[470], ptr[471], ptr[472], ptr[473], ptr[474],
							   ptr[475], ptr[476], ptr[477], ptr[478], ptr[479],
							   ptr[480], ptr[481], ptr[482], ptr[483], ptr[484],
							   ptr[485], ptr[486], ptr[487], ptr[488], ptr[489],
							   ptr[490], ptr[491], ptr[492], ptr[493], ptr[494],
							   ptr[495], ptr[496], ptr[497], ptr[498], ptr[499],
							   ptr[500], ptr[501], ptr[502], ptr[503], ptr[504],
							   ptr[505], ptr[506], ptr[507], ptr[508], ptr[509],
							   ptr[510], ptr[511], ptr[512], ptr[513], ptr[514],
							   ptr[515], ptr[516], ptr[517], ptr[518], ptr[519],
							   ptr[520], ptr[521], ptr[522], ptr[523], ptr[524],
							   ptr[525], ptr[526], ptr[527], ptr[528], ptr[529],
							   ptr[530], ptr[531], ptr[532], ptr[533], ptr[534],
							   ptr[535], ptr[536], ptr[537], ptr[538], ptr[539],
							   ptr[540], ptr[541], ptr[542], ptr[543], ptr[544],
							   ptr[545], ptr[546], ptr[547], ptr[548], ptr[549],
							   ptr[550], ptr[551], ptr[552], ptr[553], ptr[554],
							   ptr[555], ptr[556], ptr[557], ptr[558], ptr[559],
							   ptr[560], ptr[561], ptr[562], ptr[563], ptr[564],
							   ptr[565], ptr[566], ptr[567], ptr[568], ptr[569],
							   ptr[570], ptr[571], ptr[572], ptr[573], ptr[574],
							   ptr[575], ptr[576], ptr[577], ptr[578], ptr[579],
							   ptr[580], ptr[581], ptr[582], ptr[583], ptr[584],
							   ptr[585], ptr[586], ptr[587], ptr[588], ptr[589],
							   ptr[590], ptr[591], ptr[592], ptr[593], ptr[594],
							   ptr[595], ptr[596], ptr[597], ptr[598], ptr[599],
							   ptr[600], ptr[601], ptr[602], ptr[603], ptr[604],
							   ptr[605], ptr[606], ptr[607], ptr[608], ptr[609],
							   ptr[610], ptr[611], ptr[612], ptr[613], ptr[614],
							   ptr[615], ptr[616], ptr[617], ptr[618], ptr[619],
							   ptr[620], ptr[621], ptr[622], ptr[623], ptr[624],
							   ptr[625], ptr[626], ptr[627], ptr[628], ptr[629],
							   ptr[630], ptr[631], ptr[632], ptr[633], ptr[634],
							   ptr[635], ptr[636], ptr[637], ptr[638], ptr[639],
							   ptr[640], ptr[641], ptr[642], ptr[643], ptr[644],
							   ptr[645], ptr[646], ptr[647], ptr[648], ptr[649],
							   ptr[650], ptr[651], ptr[652], ptr[653], ptr[654],
							   ptr[655], ptr[656], ptr[657], ptr[658], ptr[659],
							   ptr[660], ptr[661], ptr[662], ptr[663], ptr[664],
							   ptr[665], ptr[666], ptr[667], ptr[668], ptr[669],
							   ptr[670], ptr[671], ptr[672], ptr[673], ptr[674],
							   ptr[675], ptr[676], ptr[677], ptr[678], ptr[679],
							   ptr[680], ptr[681], ptr[682], ptr[683], ptr[684],
							   ptr[685], ptr[686], ptr[687], ptr[688], ptr[689],
							   ptr[690], ptr[691], ptr[692], ptr[693], ptr[694],
							   ptr[695], ptr[696], ptr[697], ptr[698], ptr[699],
							   ptr[700], ptr[701], ptr[702], ptr[703], ptr[704],
							   ptr[705], ptr[706], ptr[707], ptr[708], ptr[709],
							   ptr[710], ptr[711], ptr[712], ptr[713], ptr[714],
							   ptr[715], ptr[716], ptr[717], ptr[718], ptr[719],
							   ptr[720], ptr[721], ptr[722], ptr[723], ptr[724],
							   ptr[725], ptr[726], ptr[727], ptr[728], ptr[729],
							   ptr[730], ptr[731], ptr[732], ptr[733], ptr[734],
							   ptr[735], ptr[736], ptr[737], ptr[738], ptr[739],
							   ptr[740], ptr[741], ptr[742], ptr[743], ptr[744],
							   ptr[745], ptr[746], ptr[747], ptr[748], ptr[749],
							   ptr[750], ptr[751], ptr[752], ptr[753], ptr[754],
							   ptr[755], ptr[756], ptr[757], ptr[758], ptr[759],
							   ptr[760], ptr[761], ptr[762], ptr[763], ptr[764],
							   ptr[765], ptr[766], ptr[767], ptr[768], ptr[769],
							   ptr[770], ptr[771], ptr[772], ptr[773], ptr[774],
							   ptr[775], ptr[776], ptr[777], ptr[778], ptr[779],
							   ptr[780], ptr[781], ptr[782], ptr[783], ptr[784],
							   ptr[785], ptr[786], ptr[787], ptr[788], ptr[789],
							   ptr[790], ptr[791], ptr[792], ptr[793], ptr[794],
							   ptr[795], ptr[796], ptr[797], ptr[798], ptr[799],
							   ptr[800], ptr[801], ptr[802], ptr[803], ptr[804],
							   ptr[805], ptr[806], ptr[807], ptr[808], ptr[809],
							   ptr[810], ptr[811], ptr[812], ptr[813], ptr[814],
							   ptr[815], ptr[816], ptr[817], ptr[818], ptr[819],
							   ptr[820], ptr[821], ptr[822], ptr[823], ptr[824],
							   ptr[825], ptr[826], ptr[827], ptr[828], ptr[829],
							   ptr[830], ptr[831], ptr[832], ptr[833], ptr[834],
							   ptr[835], ptr[836], ptr[837], ptr[838], ptr[839],
							   ptr[840], ptr[841], ptr[842], ptr[843], ptr[844],
							   ptr[845], ptr[846], ptr[847], ptr[848], ptr[849],
							   ptr[850], ptr[851], ptr[852], ptr[853], ptr[854],
							   ptr[855], ptr[856], ptr[857], ptr[858], ptr[859],
							   ptr[860], ptr[861], ptr[862], ptr[863], ptr[864],
							   ptr[865], ptr[866], ptr[867], ptr[868], ptr[869],
							   ptr[870], ptr[871], ptr[872], ptr[873], ptr[874],
							   ptr[875], ptr[876], ptr[877], ptr[878], ptr[879],
							   ptr[880], ptr[881], ptr[882], ptr[883], ptr[884],
							   ptr[885], ptr[886], ptr[887], ptr[888], ptr[889],
							   ptr[890], ptr[891], ptr[892], ptr[893], ptr[894],
							   ptr[895], ptr[896], ptr[897], ptr[898], ptr[899],
							   ptr[900], ptr[901], ptr[902], ptr[903], ptr[904],
							   ptr[905], ptr[906], ptr[907], ptr[908], ptr[909],
							   ptr[910], ptr[911], ptr[912], ptr[913], ptr[914],
							   ptr[915], ptr[916], ptr[917], ptr[918], ptr[919],
							   ptr[920], ptr[921], ptr[922], ptr[923], ptr[924],
							   ptr[925], ptr[926], ptr[927], ptr[928], ptr[929],
							   ptr[930], ptr[931], ptr[932], ptr[933], ptr[934],
							   ptr[935], ptr[936], ptr[937], ptr[938], ptr[939],
							   ptr[940], ptr[941], ptr[942], ptr[943], ptr[944],
							   ptr[945], ptr[946], ptr[947], ptr[948], ptr[949],
							   ptr[950], ptr[951], ptr[952], ptr[953], ptr[954],
							   ptr[955], ptr[956], ptr[957], ptr[958], ptr[959],
							   ptr[960], ptr[961], ptr[962], ptr[963], ptr[964],
							   ptr[965], ptr[966], ptr[967], ptr[968], ptr[969],
							   ptr[970], ptr[971], ptr[972], ptr[973], ptr[974],
							   ptr[975], ptr[976], ptr[977], ptr[978], ptr[979],
							   ptr[980], ptr[981], ptr[982], ptr[983], ptr[984],
							   ptr[985], ptr[986], ptr[987], ptr[988], ptr[989],
							   ptr[990], ptr[991], ptr[992], ptr[993], ptr[994],
							   ptr[995], ptr[996], ptr[997], ptr[998], ptr[999],
							   ptr[1000], ptr[1001], ptr[1002], ptr[1003], ptr[1004],
							   ptr[1005], ptr[1006], ptr[1007], ptr[1008], ptr[1009],
							   ptr[1010], ptr[1011], ptr[1012], ptr[1013], ptr[1014],
							   ptr[1015], ptr[1016], ptr[1017], ptr[1018], ptr[1019],
							   ptr[1020], ptr[1021], ptr[1022], ptr[1023], ptr[1024],
							   ptr[1025], ptr[1026], ptr[1027], ptr[1028], ptr[1029],
							   ptr[1030], ptr[1031], ptr[1032], ptr[1033], ptr[1034],
							   ptr[1035], ptr[1036], ptr[1037], ptr[1038], ptr[1039],
							   ptr[1040], ptr[1041], ptr[1042], ptr[1043], ptr[1044],
							   ptr[1045], ptr[1046], ptr[1047], ptr[1048], ptr[1049],
							   ptr[1050], ptr[1051], ptr[1052], ptr[1053], ptr[1054],
							   ptr[1055], ptr[1056], ptr[1057], ptr[1058], ptr[1059],
							   ptr[1060], ptr[1061], ptr[1062], ptr[1063], ptr[1064],
							   ptr[1065], ptr[1066], ptr[1067], ptr[1068], ptr[1069],
							   ptr[1070], ptr[1071], ptr[1072], ptr[1073], ptr[1074],
							   ptr[1075], ptr[1076], ptr[1077], ptr[1078], ptr[1079],
							   ptr[1080], ptr[1081], ptr[1082], ptr[1083], ptr[1084],
							   ptr[1085], ptr[1086], ptr[1087], ptr[1088], ptr[1089],
							   ptr[1090], ptr[1091], ptr[1092], ptr[1093], ptr[1094],
							   ptr[1095], ptr[1096], ptr[1097], ptr[1098], ptr[1099],
							   ptr[1100], ptr[1101], ptr[1102], ptr[1103], ptr[1104],
							   ptr[1105], ptr[1106], ptr[1107], ptr[1108], ptr[1109],
							   ptr[1110], ptr[1111], ptr[1112], ptr[1113], ptr[1114],
							   ptr[1115], ptr[1116], ptr[1117], ptr[1118], ptr[1119],
							   ptr[1120], ptr[1121], ptr[1122], ptr[1123], ptr[1124],
							   ptr[1125], ptr[1126], ptr[1127], ptr[1128], ptr[1129],
							   ptr[1130], ptr[1131], ptr[1132], ptr[1133], ptr[1134],
							   ptr[1135], ptr[1136], ptr[1137], ptr[1138], ptr[1139],
							   ptr[1140], ptr[1141], ptr[1142], ptr[1143], ptr[1144],
							   ptr[1145], ptr[1146], ptr[1147], ptr[1148], ptr[1149],
							   ptr[1150], ptr[1151], ptr[1152], ptr[1153], ptr[1154],
							   ptr[1155], ptr[1156], ptr[1157], ptr[1158], ptr[1159],
							   ptr[1160], ptr[1161], ptr[1162], ptr[1163], ptr[1164],
							   ptr[1165], ptr[1166], ptr[1167], ptr[1168], ptr[1169],
							   ptr[1170], ptr[1171], ptr[1172], ptr[1173], ptr[1174],
							   ptr[1175], ptr[1176], ptr[1177], ptr[1178], ptr[1179],
							   ptr[1180], ptr[1181], ptr[1182], ptr[1183], ptr[1184],
							   ptr[1185], ptr[1186], ptr[1187], ptr[1188], ptr[1189],
							   ptr[1190], ptr[1191], ptr[1192], ptr[1193], ptr[1194],
							   ptr[1195], ptr[1196], ptr[1197], ptr[1198], ptr[1199],
							   ptr[1200], ptr[1201], ptr[1202], ptr[1203], ptr[1204],
							   ptr[1205], ptr[1206], ptr[1207], ptr[1208], ptr[1209],
							   ptr[1210], ptr[1211], ptr[1212], ptr[1213], ptr[1214],
							   ptr[1215], ptr[1216], ptr[1217], ptr[1218], ptr[1219],
							   ptr[1220], ptr[1221], ptr[1222], ptr[1223], ptr[1224],
							   ptr[1225], ptr[1226], ptr[1227], ptr[1228], ptr[1229],
							   ptr[1230], ptr[1231], ptr[1232], ptr[1233], ptr[1234],
							   ptr[1235], ptr[1236], ptr[1237], ptr[1238], ptr[1239],
							   ptr[1240], ptr[1241], ptr[1242], ptr[1243], ptr[1244],
							   ptr[1245], ptr[1246], ptr[1247], ptr[1248], ptr[1249],
							   ptr[1250], ptr[1251], ptr[1252], ptr[1253], ptr[1254],
							   ptr[1255], ptr[1256], ptr[1257], ptr[1258], ptr[1259],
							   ptr[1260], ptr[1261], ptr[1262], ptr[1263], ptr[1264],
							   ptr[1265], ptr[1266], ptr[1267], ptr[1268], ptr[1269],
							   ptr[1270], ptr[1271], ptr[1272], ptr[1273], ptr[1274],
							   ptr[1275], ptr[1276], ptr[1277], ptr[1278], ptr[1279],
							   ptr[1280], ptr[1281], ptr[1282], ptr[1283], ptr[1284],
							   ptr[1285], ptr[1286], ptr[1287], ptr[1288], ptr[1289],
							   ptr[1290], ptr[1291], ptr[1292], ptr[1293], ptr[1294],
							   ptr[1295], ptr[1296], ptr[1297], ptr[1298], ptr[1299],
							   ptr[1300], ptr[1301], ptr[1302], ptr[1303], ptr[1304],
							   ptr[1305], ptr[1306], ptr[1307], ptr[1308], ptr[1309],
							   ptr[1310], ptr[1311], ptr[1312], ptr[1313], ptr[1314],
							   ptr[1315], ptr[1316], ptr[1317], ptr[1318], ptr[1319],
							   ptr[1320], ptr[1321], ptr[1322], ptr[1323], ptr[1324],
							   ptr[1325], ptr[1326], ptr[1327], ptr[1328], ptr[1329],
							   ptr[1330], ptr[1331], ptr[1332], ptr[1333], ptr[1334],
							   ptr[1335], ptr[1336], ptr[1337], ptr[1338], ptr[1339],
							   ptr[1340], ptr[1341], ptr[1342], ptr[1343], ptr[1344],
							   ptr[1345], ptr[1346], ptr[1347], ptr[1348], ptr[1349],
							   ptr[1350], ptr[1351], ptr[1352], ptr[1353], ptr[1354],
							   ptr[1355], ptr[1356], ptr[1357], ptr[1358], ptr[1359],
							   ptr[1360], ptr[1361], ptr[1362], ptr[1363], ptr[1364],
							   ptr[1365], ptr[1366], ptr[1367], ptr[1368], ptr[1369],
							   ptr[1370], ptr[1371], ptr[1372], ptr[1373], ptr[1374],
							   ptr[1375], ptr[1376], ptr[1377], ptr[1378], ptr[1379],
							   ptr[1380], ptr[1381], ptr[1382], ptr[1383], ptr[1384],
							   ptr[1385], ptr[1386], ptr[1387], ptr[1388], ptr[1389],
							   ptr[1390], ptr[1391], ptr[1392], ptr[1393], ptr[1394],
							   ptr[1395], ptr[1396], ptr[1397], ptr[1398], ptr[1399],
							   ptr[1400], ptr[1401], ptr[1402], ptr[1403], ptr[1404],
							   ptr[1405], ptr[1406], ptr[1407], ptr[1408], ptr[1409],
							   ptr[1410], ptr[1411], ptr[1412], ptr[1413], ptr[1414],
							   ptr[1415], ptr[1416], ptr[1417], ptr[1418], ptr[1419],
							   ptr[1420], ptr[1421], ptr[1422], ptr[1423], ptr[1424],
							   ptr[1425], ptr[1426], ptr[1427], ptr[1428], ptr[1429],
							   ptr[1430], ptr[1431], ptr[1432], ptr[1433], ptr[1434],
							   ptr[1435], ptr[1436], ptr[1437], ptr[1438], ptr[1439],
							   ptr[1440], ptr[1441], ptr[1442], ptr[1443], ptr[1444],
							   ptr[1445], ptr[1446], ptr[1447], ptr[1448], ptr[1449],
							   ptr[1450], ptr[1451], ptr[1452], ptr[1453], ptr[1454],
							   ptr[1455], ptr[1456], ptr[1457], ptr[1458], ptr[1459],
							   ptr[1460], ptr[1461], ptr[1462], ptr[1463], ptr[1464],
							   ptr[1465], ptr[1466], ptr[1467], ptr[1468], ptr[1469],
							   ptr[1470], ptr[1471], ptr[1472], ptr[1473], ptr[1474],
							   ptr[1475], ptr[1476], ptr[1477], ptr[1478], ptr[1479],
							   ptr[1480], ptr[1481], ptr[1482], ptr[1483], ptr[1484],
							   ptr[1485], ptr[1486], ptr[1487], ptr[1488], ptr[1489],
							   ptr[1490], ptr[1491], ptr[1492], ptr[1493], ptr[1494],
							   ptr[1495], ptr[1496], ptr[1497], ptr[1498], ptr[1499]);
	    } else {
		comp[ci].aui_ptr = NULL;
	    }
	    break;
	}
    }

    if (strcasecmp(comp[ci].type, "power_supply") == 0) {
	sig_boolean_connect_out(sig_lookup(comp_id, "power_230v", 0),
				cpssp, 0);
	sig_boolean_connect_out(sig_lookup(comp_id, "mech_power_switch", 0),
				cpssp, 0);
	sig_boolean_set(sig_lookup(comp_id, "power_230v", 0),
			cpssp, 1);
	sig_boolean_set(sig_lookup(comp_id, "mech_power_switch", 0),
			cpssp, 1);

    } else if (strcasecmp(comp[ci].type, "power_supply_at") == 0) {
	sig_boolean_connect_out(sig_lookup(comp_id, "power_230v", 0),
				cpssp, 0);
	sig_boolean_connect_out(sig_lookup(comp_id, "mech_power_switch", 0),
				cpssp, 0);
	sig_boolean_set(sig_lookup(comp_id, "power_230v", 0),
			cpssp, 1);

    } else if (strcasecmp(comp[ci].type, "monitor") == 0) {
	sig_boolean_connect_out(sig_lookup(comp_id, "power_230v", 0),
				cpssp, 1);
	sig_boolean_set(sig_lookup(comp_id, "power_230v", 0),
			cpssp, 1);

    } else if (strcasecmp(comp[ci].type, "telephone_isp") == 0) {
	sig_boolean_connect_out(sig_lookup(comp_id, "switch", 0), cpssp, 0);
	sig_boolean_set(sig_lookup(comp_id, "switch", 0), cpssp, 1);

    } else if (strcasecmp(comp[ci].type, "telephone_switch") == 0) {
	sig_boolean_connect_out(sig_lookup(comp_id, "switch", 0), cpssp, 0);
	sig_boolean_set(sig_lookup(comp_id, "switch", 0), cpssp, 1);
    }

    return 0;
}

int
system_comp_exit(unsigned int comp_id)
{
    unsigned int ci;

    for (ci = 0; ; ci++) {
	if (ci == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (! comp[ci].type
	    || ! comp[ci].name) {
	    continue;
	}
	if (comp[ci].id == comp_id) {
	    /* Component found. */
	    break;
	}
    }

    /* Nothing to do, jet. */

    return 0;
}

int
system_comp_destroy(unsigned int comp_id)
{
    unsigned int ci;
    unsigned int i;

    for (ci = 0; ; ci++) {
	if (ci == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (comp[ci].id == comp_id
	    && comp[ci].type
	    && comp[ci].name) {
	    /* Component found. */
	    break;
	}
    }

    for (i = 0; ; i++) {
	if (i == sizeof(comp_type) / sizeof(comp_type[0])) {
	    fprintf(stderr, "%s\n", comp[ci].type);
	    assert(0); /* FIXME */
	}
	if (strcasecmp(comp[ci].type, comp_type[i].type) == 0) {
	    if (comp_type[i].destroy) {
		comp_type[i].destroy(comp[ci].ptr);
	    }
	    if (comp_type[i].gui_destroy) {
		comp_type[i].gui_destroy(comp[ci].gui_ptr);
	    }
	    if (comp_type[i].aui_destroy) {
		comp_type[i].aui_destroy(comp[ci].aui_ptr);
	    }
	    break;
	}
    }

    free(comp[ci].type);
    comp[ci].type = NULL;

    free(comp[ci].name);
    comp[ci].name = NULL;

    return 0;
}

int
system_comp_info(
		 unsigned int comp_id,
		 char *type,
		 char *name,
		 unsigned int *nodep,
		 unsigned int *pagep
		)
{
    unsigned int ci;

    for (ci = 0; ; ci++) {
	if (ci == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    assert(0); /* FIXME */
	    return -1;
	}
	if (! comp[ci].type
	    || ! comp[ci].name) {
	    continue;
	}
	if (comp[ci].id == comp_id) {
	    /* Component found. */
	    break;
	}
    }

    strcpy(type, comp[ci].type);
    strcpy(name, comp[ci].name);
    *nodep = comp[ci].node;
    *pagep = comp[ci].page;

    return 0;
}

int
system_comp_generic_info(
			 unsigned int comp_id,
			 unsigned int generic_id,
			 char *type,
			 char *name,
			 char *value
			)
{
    unsigned int id;

    for (id = 0; ; id++) {
	if (id == sizeof(generic) / sizeof(generic[0])) {
	    /* Not found. */
	    return -1;
	}
	if (! generic[id].name
	    || ! generic[id].value) {
	    continue;
	}
	if (generic[id].comp_id == comp_id) {
	    if (generic_id == 0) {
		strcpy(type, generic[id].type);
		strcpy(name, generic[id].name);
		strcpy(value, generic[id].value);
		return 0;
	    } else {
		generic_id--;
	    }
	}
    }
}

int
system_comp_port_info(
		      unsigned int comp_id,
		      unsigned int port_id,
		      char *port,
		      unsigned int *sigidp
		     )
{
    unsigned int id;

    for (id = 0; ; id++) {
	if (id == sizeof(conn) / sizeof(conn[0])) {
	    /* Not found. */
	    return -1;
	}
	if (! conn[id].port) {
	    continue;
	}
	if (conn[id].comp_id == comp_id) {
	    if (port_id == 0) {
		strcpy(port, conn[id].port);
		*sigidp = conn[id].sig_id;
		return 0;
	    } else {
		port_id--;
	    }
	}
    }
}

int
system_arch_create(
		   const char *type,
		   const char *name,
		   unsigned int node,
		   unsigned int page
		  )
{
    return system_comp_create(type, name, node, page);
}

int
system_arch_generic_set(
			unsigned int id,
			const char *t,
			const char *n,
			const char *v
		       )
{
    return system_comp_generic_set(id, t, n, v);
}

int
system_arch_port_connect(
			 unsigned int arch_id,
			 const char *port,
			 unsigned int sig_id
			)
{
    return system_comp_port_connect(arch_id, port, sig_id);
}

int
system_arch_init(unsigned int id)
{
    return system_comp_init(id);
}

int
system_arch_exit(unsigned int id)
{
    return system_comp_exit(id);
}

int
system_arch_destroy(unsigned int id)
{
    return system_comp_destroy(id);
}

void
system_comp_connect(unsigned int comp_id, const char *port, unsigned int sig_id)
{
    struct sig_manage *sig_manage;
    void *sig_ptr;

    sig_manage = sig_lookup(comp_id, "manage", 0);
    assert(sig_manage);

    sig_ptr = system_sig_get(sig_id);
    assert(sig_ptr);

    sig_manage_connect_port(sig_manage, port, sig_ptr);

    /* FIXME */
    // ret = system_sig_unget(sig_ptr);
    // assert(0 <= ret);
}

void
system_comp_disconnect(unsigned int comp_id, const char *port)
{
    struct sig_manage *sig_manage;

    sig_manage = sig_lookup(comp_id, "manage", 0);
    assert(sig_manage);

    sig_manage_disconnect_port(sig_manage, port);
}

int
system_comp_lookup(const char *name)
{
    unsigned int id;

    for (id = 0; id < sizeof(comp) / sizeof(comp[0]); id++) {
	if (comp[id].name == NULL) {
	    /* past last entry */
	    return -1;
	}

	if (strcasecmp(comp[id].name, name) == 0) {
	    return comp[id].id;
	}
    }

    return -1;
}

int
system_sig_lookup(const char *name)
{
    unsigned int si;

    for (si = 0; ; si++) {
	if (si == sizeof(sig) / sizeof(sig[0])) {
	    /* Signal not found. */
	    return -1;
	}

	if (sig[si].name
	    && strcasecmp(sig[si].name, name) == 0) {
	    break;
	}
    }

    return sig[si].id;
}

int
system_port_lookup(
		   const char *type,
		   enum system_gender gender,
		   unsigned int n,
		   const char **comp_name,
		   const char **port_name
		  )
{
    unsigned int conn_id;
    unsigned int comp_id;
    unsigned int sig_id;

    for (conn_id = 0; ; conn_id++) {
	if (conn_id == sizeof(conn) / sizeof(conn[0])) {
	    return -1;
	}
	if (! conn[conn_id].port) {
	    /* Empty slot. */
	    continue;
	}
	if (conn[conn_id].gender != gender) {
	    /* Wrong gender. */
	    continue;
	}
	for (sig_id = 0; ; sig_id++) {
	    assert(sig_id < sizeof(sig) / sizeof(sig[0]));
	    if (! sig[sig_id].type
		|| ! sig[sig_id].name) {
		continue;
	    }
	    if (sig[sig_id].id == conn[conn_id].sig_id) {
		break;
	    }
	}
	if (strcasecmp(sig[sig_id].type, type) != 0) {
	    /* Wrong type. */
	    continue;
	}
	for (comp_id = 0; ; comp_id++) {
	    assert(comp_id < sizeof(comp) / sizeof(comp[0]));
	    if (! comp[comp_id].type
		|| ! comp[comp_id].name) {
		continue;
	    }
	    if (comp[comp_id].id == conn[conn_id].comp_id) {
		break;
	    }
	}

	if (n == 0) {
	    *comp_name = comp[comp_id].name;
	    *port_name = conn[conn_id].port;
	    return 1;
	} else {
	    n--;
	}
    }
}

int
system_port_connect(
		    const char *comp_name0,
		    const char *port_name0,
		    const char *comp_name1,
		    const char *port_name1
		   )
{
    unsigned int comp_id0;
    unsigned int comp_id1;
    unsigned int conn_id0;
    unsigned int conn_id1;
    unsigned int sig_id0;
    unsigned int sig_id1;
    unsigned int type_id;

    /*
     * Lookup component 0.
     */
    for (comp_id0 = 0; ; comp_id0++) {
	if (comp_id0 == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    return -1;
	}
	if (! comp[comp_id0].type
	    || ! comp[comp_id0].name) {
	    /* Empty slot. */
	    continue;
	}
	if (strcasecmp(comp[comp_id0].name, comp_name0) == 0) {
	    /* Component found. */
	    break;
	}
    }

    /*
     * Lookup component 1.
     */
    for (comp_id1 = 0; ; comp_id1++) {
	if (comp_id1 == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    return -1;
	}
	if (! comp[comp_id1].type
	    || ! comp[comp_id1].name) {
	    /* Empty slot. */
	    continue;
	}
	if (strcasecmp(comp[comp_id1].name, comp_name1) == 0) {
	    /* Component found. */
	    break;
	}
    }

    /*
     * Lookup port 0.
     */
    for (conn_id0 = 0; ; conn_id0++) {
	if (conn_id0 == sizeof(conn) / sizeof(conn[0])) {
	    /* Connection not found. */
	    return -1;
	}
	if (! conn[conn_id0].port) {
	    /* Empty slot. */
	    continue;
	}
	if (conn[conn_id0].comp_id == comp[comp_id0].id
	    && strcasecmp(conn[conn_id0].port, port_name0) == 0) {
	    /* Connection found. */
	    break;
	}
    }

    /*
     * Lookup port 1.
     */
    for (conn_id1 = 0; ; conn_id1++) {
	if (conn_id1 == sizeof(conn) / sizeof(conn[0])) {
	    /* Connection not found. */
	    return -1;
	}
	if (! conn[conn_id1].port) {
	    /* Empty slot. */
	    continue;
	}
	if (conn[conn_id1].comp_id == comp[comp_id1].id
	    && strcasecmp(conn[conn_id1].port, port_name1) == 0) {
	    /* Connection found. */
	    break;
	}
    }

    /*
     * Lookup signal 0.
     */
    for (sig_id0 = 0; ; sig_id0++) {
	if (sig_id0 == sizeof(sig) / sizeof(sig[0])) {
	    /* Signal not found. */
	    assert(0); /* Mustn't happen. */
	}
	if (! sig[sig_id0].type
	    || ! sig[sig_id0].name) {
	    /* Empty slot. */
	    continue;
	}
	if (sig[sig_id0].id == conn[conn_id0].sig_id) {
	    /* Signal found. */
	    break;
	}
    }

    /*
     * Lookup signal 1.
     */
    for (sig_id1 = 0; ; sig_id1++) {
	if (sig_id1 == sizeof(sig) / sizeof(sig[0])) {
	    /* Signal not found. */
	    assert(0); /* Mustn't happen. */
	}
	if (! sig[sig_id1].type
	    || ! sig[sig_id1].name) {
	    /* Empty slot. */
	    continue;
	}
	if (sig[sig_id1].id == conn[conn_id1].sig_id) {
	    /* Signal found. */
	    break;
	}
    }

    /*
     * Lookup signal type.
     */
    for (type_id = 0; ; type_id++) {
	if (type_id == sizeof(sig_type) / sizeof(sig_type[0])) {
	    /* Signal type not found. */
	    assert(0); /* Mustn't happen. */
	}
	if (strcasecmp(sig_type[type_id].type, sig[sig_id0].type) == 0) {
	    /* Signal type found. */
	    break;
	}
    }

    /*
     * Check if signals connectable.
     */
    if (conn[conn_id0].peer != -1
	|| conn[conn_id1].peer != -1) {
	/* Port already connected. */
	return -1;
    }
    if (strcasecmp(sig[sig_id0].type, sig[sig_id1].type) != 0) {
	/* Signals of different type. */
	return -1;
    }
    if ((conn[conn_id0].gender | conn[conn_id1].gender) != 0
	&& (conn[conn_id0].gender | conn[conn_id1].gender) != 3) {
	/* Wrong genders. */
	return -1;
    }

    /*
     * Connect signals.
     */
    assert(conn[conn_id0].sig_ptr); /* FIXME */
    assert(conn[conn_id1].sig_ptr); /* FIXME */
    assert(! conn[conn_id0].merge);
    assert(! conn[conn_id1].merge);
    assert(conn[conn_id0].peer == -1);
    assert(conn[conn_id1].peer == -1);

    conn[conn_id0].peer = conn_id1;
    conn[conn_id1].peer = conn_id0;

    conn[conn_id0].merge =
	conn[conn_id1].merge = (*sig_type[type_id].merge)(
							  conn[conn_id0].sig_ptr, conn[conn_id1].sig_ptr);

    return 0;
}

int
system_port_disconnect(
		       const char *comp_name0,
		       const char *port_name0
		      )
{
    unsigned int comp_id0;
    unsigned int conn_id0;
    unsigned int conn_id1;
    unsigned int sig_id0;
    unsigned int type_id;

    /*
     * Lookup component 0.
     */
    for (comp_id0 = 0; ; comp_id0++) {
	if (comp_id0 == sizeof(comp) / sizeof(comp[0])) {
	    /* Component not found. */
	    return -1;
	}
	if (! comp[comp_id0].type
	    || ! comp[comp_id0].name) {
	    /* Empty slot. */
	    continue;
	}
	if (strcasecmp(comp[comp_id0].name, comp_name0) == 0) {
	    /* Component found. */
	    break;
	}
    }

    /*
     * Lookup port 0.
     */
    for (conn_id0 = 0; ; conn_id0++) {
	if (conn_id0 == sizeof(conn) / sizeof(conn[0])) {
	    /* Connection not found. */
	    return -1;
	}
	if (! conn[conn_id0].port) {
	    /* Empty slot. */
	    continue;
	}
	if (conn[conn_id0].comp_id == comp[comp_id0].id
	    && strcasecmp(conn[conn_id0].port, port_name0) == 0) {
	    /* Connection found. */
	    break;
	}
    }

    /*
     * Lookup signal 0.
     */
    for (sig_id0 = 0; ; sig_id0++) {
	if (sig_id0 == sizeof(sig) / sizeof(sig[0])) {
	    /* Signal not found. */
	    assert(0); /* Mustn't happen. */
	}
	if (! sig[sig_id0].type
	    || ! sig[sig_id0].name) {
	    /* Empty slot. */
	    continue;
	}
	if (sig[sig_id0].id == conn[conn_id0].sig_id) {
	    /* Signal found. */
	    break;
	}
    }

    /*
     * Lookup signal type.
     */
    for (type_id = 0; ; type_id++) {
	if (type_id == sizeof(sig_type) / sizeof(sig_type[0])) {
	    /* Signal type not found. */
	    assert(0); /* Mustn't happen. */
	}
	if (strcasecmp(sig_type[type_id].type, sig[sig_id0].type) == 0) {
	    /* Signal type found. */
	    break;
	}
    }

    /*
     * Checks if signal disconnectable.
     */
    if (conn[conn_id0].peer == -1) {
	/* Not connected. */
	return -1;
    }

    /*
     * Disconnect.
     */
    conn_id1 = conn[conn_id0].peer;
    assert(conn[conn_id1].peer == conn_id0);

    assert(conn_id0 < sizeof(conn) / sizeof(conn[0]));
    assert(conn_id1 < sizeof(conn) / sizeof(conn[0]));
    assert(conn[conn_id0].merge);
    assert(conn[conn_id1].merge);

    (*sig_type[type_id].split)(conn[conn_id0].merge);

    conn[conn_id0].merge = NULL;
    conn[conn_id0].peer = -1;
    conn[conn_id1].merge = NULL;
    conn[conn_id1].peer = -1;

    return 0;
}

void 
suspend_components(FILE *fComp)
{
    int i, j;
    char compname[100];
    int component_found;	

    for (i = 0; i < sizeof(comp)/sizeof(comp[0]) ; i++) {

	if (!comp[i].name){
	    continue;
	}

	component_found = 0;

	for (j = 0; j < sizeof(comp_type)/sizeof(comp_type[0]); j++) {

	    if (strcasecmp(comp[i].type, comp_type[j].type) == 0) {
		strcpy(compname, comp[i].name);
		fwrite(compname, sizeof(compname), 1, fComp);
		memset(&compname[0], 0, sizeof(compname));

		if (comp_type[j].suspend) {
		    fprintf(stderr, "\t\tSuspend %s at %p\n", comp_type[j].type, comp[i].ptr);
		    comp_type[j].suspend(comp[i].ptr, fComp);
		}

		if (comp_type[j].gui_suspend) {
		    fprintf(stderr, "\t\tSuspend GUI of %s at %p\n", comp_type[j].type, comp[i].gui_ptr);
		    comp_type[j].gui_suspend(comp[i].gui_ptr, fComp);
		}

		if (comp_type[j].aui_suspend) {
		    fprintf(stderr, "\t\tSuspend AUI of %s at %p\n", comp_type[j].type, comp[i].aui_ptr);
		    comp_type[j].aui_suspend(comp[i].aui_ptr, fComp);
		}

		component_found = 1;
		break;
	    }	
	}

	if (!component_found){
	    fprintf(stderr, "Type %s of component %s not found... aborting\n", comp[i].type, comp[i].name);
	    assert(0);
	}
    }

    strcpy(compname, "SUSP_END");
    fwrite(compname, sizeof(compname), 1, fComp);
}

void 
resume_components(FILE *fComp)
{
    int i, j;
    int read_chars;
    char compname[100];	

    while (1)
    {
	read_chars = fread(compname, sizeof(compname), 1, fComp);
	if (strcasecmp("SUSP_END", compname) == 0) {
	    break;
	}

	for (i = 0; i < sizeof(comp)/sizeof(comp[0]); i++) {

	    if (strcasecmp(comp[i].name, compname) == 0) {

		for (j = 0; j < (sizeof(comp_type)/sizeof(comp_type[0])); j++) {

		    if (strcasecmp(comp[i].type, comp_type[j].type) == 0) {

			if (comp_type[j].resume) {

			    fprintf(stderr, "\t\tResume %s at %p\n", comp_type[j].type, comp[i].ptr);

			    comp_type[j].resume(comp[i].ptr, fComp);
			}
			if (comp_type[j].gui_resume) {

			    fprintf(stderr, "\t\tResume GUI of %s at %p\n", comp_type[j].type, comp[i].gui_ptr);

			    comp_type[j].gui_resume(comp[i].gui_ptr, fComp);
			}
			if (comp_type[j].aui_resume) {

			    fprintf(stderr, "\t\tResume AUI of %s at %p\n", comp_type[j].type, comp[i].aui_ptr);

			    comp_type[j].aui_resume(comp[i].aui_ptr, fComp);
			}
			break;
		    }
		}
		break;
	    }
	}
    }
}

void 
suspend_signals(FILE *fSig)
{
    int i, j;
    char signame[100];
    int signal_found;	

    for (i = 0; i < sizeof(sig)/sizeof(sig[0]) ; i++) {

	if (!sig[i].name){
	    continue;
	}

	signal_found = 0;

	for (j = 0; j < sizeof(sig_type)/sizeof(sig_type[0]); j++) {

	    if (strcasecmp(sig[i].type, sig_type[j].type) == 0) {
		strcpy(signame, sig[i].name);
		fwrite(signame, sizeof(signame), 1, fSig);
		memset(&signame[0], 0, sizeof(signame));

		if (sig_type[j].suspend) {
		    fprintf(stderr, "\t\tSuspend %s at %p\n", sig_type[j].type, sig[i].ptr);
		    sig_type[j].suspend(sig[i].ptr, fSig);
		}				
		signal_found = 1;
		break;
	    }	
	}

	if (!signal_found){
	    fprintf(stderr, "Type %s of signal %s not found... aborting\n", sig[i].type, sig[i].name);
	    assert(0);
	}
    }

    strcpy(signame, "SUSP_END");
    fwrite(signame, sizeof(signame), 1, fSig);
}

void
resume_signals(FILE *fSig)
{
    int i, j;
    int read_chars;
    char signame[100];	

    while (1)
    {
	read_chars = fread(signame, sizeof(signame), 1, fSig);
	if (strcasecmp("SUSP_END", signame) == 0) {
	    break;
	}

	for (i = 0; i < sizeof(sig)/sizeof(sig[0]); i++) {

	    if (strcasecmp(sig[i].name, signame) == 0) {

		for (j = 0; j < (sizeof(sig_type)/sizeof(sig_type[0])); j++) {

		    if (strcasecmp(sig[i].type, sig_type[j].type) == 0) {

			if (sig_type[j].resume) {

			    fprintf(stderr, "\t\tResume %s at %p\n", sig_type[j].type, sig[i].ptr);

			    sig_type[j].resume(sig[i].ptr, fSig);
			}
			break;
		    }
		}
		break;
	    }
	}
    }
}

void 
suspend_connections(FILE *fConn)
{
    int i;
    size_t writecheck;

    for (i = 0; i < sizeof(conn)/sizeof(conn[0]) ; i++) {

	writecheck = fwrite(&conn[i].comp_id, sizeof(conn[i].comp_id), 1, fConn);
	writecheck += fwrite(&conn[i].sig_id, sizeof(conn[i].sig_id), 1, fConn);
	writecheck += fwrite(&conn[i].gender, sizeof(conn[i].gender), 1, fConn);
	writecheck += fwrite(&conn[i].peer, sizeof(conn[i].peer), 1, fConn);

	if (writecheck != 4){
	    fprintf(stderr, "fwrite in suspend_connections failed\n");
	    return;
	}
    }
}

void 
resume_connections(FILE *fConn)
{
    int i, j;
    size_t readcheck;
    unsigned int comp_id;
    unsigned int sig_id;
    enum system_gender gender;
    int peer;


    for (i = 0; i < sizeof(conn)/sizeof(conn[0]) ; i++) {

	readcheck = fread(&comp_id, sizeof(conn[0].comp_id), 1, fConn);
	readcheck += fread(&sig_id, sizeof(conn[0].sig_id), 1, fConn);
	readcheck += fread(&gender, sizeof(conn[0].gender), 1, fConn);
	readcheck += fread(&peer, sizeof(conn[0].peer), 1, fConn);

	if (readcheck != 4){
	    fprintf(stderr, "fread in resume_connections failed\n");
	    return;
	}



	if (peer != conn[i].peer && sig[sig_id].type){
	    assert(conn[i].merge == 0);

	    for (j = 0; j < (sizeof(sig_type)/sizeof(sig_type[0])); j++) {

		if (strcasecmp(sig[sig_id].type, sig_type[j].type) == 0) {

		    fprintf(stderr, "\t\tMerge %s \n", sig_type[j].type);

		    conn[i].peer = peer;
		    conn[i].merge = (*sig_type[j].merge)(
							 conn[i].sig_ptr, conn[peer].sig_ptr);

		    conn[peer].peer = i;
		    conn[peer].merge = conn[i].merge;
		    break;
		}
	    }
	}

	if (comp_id != conn[i].comp_id ||
	    sig_id != conn[i].sig_id ||
	    gender != conn[i].gender ||
	    peer != conn[i].peer){

	    fprintf(stderr, "Connection difference detected\n\n");
	    fprintf(stderr, "comp_id = %u conn[%d].comp_id = %u\n", comp_id, i, conn[i].comp_id);
	    fprintf(stderr, "sig_id = %u conn[%d].sig_id = %u\n", sig_id, i, conn[i].sig_id);
	    fprintf(stderr, "gender = %d conn[%d].gender = %d\n", gender, i, conn[i].gender);
	    fprintf(stderr, "peer = %d conn[%d].peer = %d\n", peer, i, conn[i].peer);
	    fprintf(stderr, "conn[%d].port = %s\n", i, conn[i].port);
	    fprintf(stderr, "conn[%d].sig_ptr = %p\n", i, conn[i].sig_ptr);
	    fprintf(stderr, "conn[%d].merge = %p\n", i, conn[i].merge);
	}
    }
}

void
system_suspend(void)
{
    FILE *fComp;
    FILE *fSig;
    FILE *fConn;
    FILE *fSched;

    fComp = fopen("./Components.suspend", "wb");
    fSig = fopen("./Signals.suspend", "wb");
    fConn = fopen("./Connections.suspend", "wb");
    fSched = fopen("./Schedules.suspend", "wb");

    if (fComp == NULL){
	fprintf(stderr, "\nCreating Components.suspend failed\n");
	return;
    }
    if (fSig == NULL){
	fprintf(stderr, "\nCreating Signals.suspend failed\n");
	return;
    }
    if (fConn == NULL){
	fprintf(stderr, "\nCreating Connections.suspend failed\n");
	return;
    }
    if (fSched == NULL){
	fprintf(stderr, "\nCreating Schedules.suspend failed\n");
	return;
    }

    suspend_components(fComp);
    suspend_signals(fSig);
    suspend_connections(fConn);
    suspend_schedules(fSched);

    fclose(fComp);
    fclose(fSig);
    fclose(fConn);
    fclose(fSched);
}

void
system_resume(void)
{
    FILE *fComp;
    FILE *fSig;
    FILE *fConn;
    FILE *fSched;

    fComp = fopen("./Components.suspend", "rb");
    fSig = fopen("./Signals.suspend", "rb");
    fConn = fopen("./Connections.suspend", "rb");
    fSched = fopen("./Schedules.suspend", "rb");

    if (fComp == NULL){
	fprintf(stderr, "\nOpening Components.suspend failed\n");
	return;
    }

    if (fSig == NULL){
	fprintf(stderr, "\nOpening Signals.suspend failed\n");
	return;
    }
    if (fConn == NULL){
	fprintf(stderr, "\nOpening Connections.suspend failed\n");
	return;
    }

    if (fSched == NULL){
	fprintf(stderr, "\nOpening Schedules.suspend failed\n");
	return;
    }

    resume_components(fComp);
    fprintf(stderr, "\nResume components complete\n");
    resume_signals(fSig);
    fprintf(stderr, "\nResume signals complete\n");
    resume_connections(fConn);
    fprintf(stderr, "\nResume connections complete\n");
    resume_schedules(fSched);
    fprintf(stderr, "\nResume schedules complete\n");
    fprintf(stderr, "\nResume complete\n");

    fclose(fComp);
    fclose(fSig);
    fclose(fConn);
    fclose(fSched);
}
