/*
 * $Id: sig_string.h,v 1.2 2013-05-15 13:29:49 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_STRING_H_INCLUDED
#define __SIG_STRING_H_INCLUDED

#include "sig_gen.h"

struct sig_string_funcs {
	void (*set)(void *s, const char *str);
};

struct sig_string {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_string_funcs *f;
	} member[10];
	unsigned int member_count;
};

struct sig_string_merge {
	struct sig_string *s0;
	struct sig_string *s1;
};

extern void
sig_string_set(struct sig_string *b, void *s, const char *str);

extern void
sig_string_connect(struct sig_string *b,
		void *s, const struct sig_string_funcs *f);

extern struct sig_string_merge *
sig_string_merge(struct sig_string *s0, struct sig_string *s1);
extern void
sig_string_split(struct sig_string_merge *m);

extern struct sig_string *
sig_string_create(const char *name);
extern void
sig_string_destroy(struct sig_string *sig);

extern void
sig_string_suspend(struct sig_string *b, FILE *fSig);
extern void
sig_string_resume(struct sig_string *b, FILE *fSig);

#endif /* __SIG_STRING_H_INCLUDED */
