/*
 * $Id: sig_serial.c,v 1.18 2013-05-09 21:05:27 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_serial.h"

void
sig_serial_send(
	struct sig_serial *b,
	void *s,
	uint8_t c
)
{
	unsigned int nr;

	for (nr = 0; ; nr++) {
		if (nr == b->nmembers) {
			return;
		}
		if (b->member[nr].s == s) {
			continue;
		}
		b->member[nr].f->recv(b->member[nr].s, c);
	}
}

void
sig_serial_connect(
	struct sig_serial *b,
	void *s,
	const struct sig_serial_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_SERIAL);
	assert(b->nmembers < sizeof(b->member) / sizeof(b->member[0]));

	b->member[b->nmembers].s = s;
	b->member[b->nmembers].f = f;
	b->nmembers++;
}

static void
sig_serial_s0_recv(void *_f, uint8_t byte)
{
	struct sig_serial_merge *f = _f;

	sig_serial_send(f->s1, f, byte);
}

static void
sig_serial_s1_recv(void *_f, uint8_t byte)
{
	struct sig_serial_merge *f = _f;

	sig_serial_send(f->s0, f, byte);
}

struct sig_serial_merge *
sig_serial_merge(struct sig_serial *s0, struct sig_serial *s1)
{
	static const struct sig_serial_funcs s0_funcs = {
		.recv = sig_serial_s0_recv,
	};
	static const struct sig_serial_funcs s1_funcs = {
		.recv = sig_serial_s1_recv,
	};
	struct sig_serial_merge *m;

	m = shm_alloc(sizeof(*m));
	assert(m);

	m->s0 = s0;
	sig_serial_connect(s0, m, &s0_funcs);
	m->s1 = s1;
	sig_serial_connect(s1, m, &s1_funcs);

	return m;
}

void
sig_serial_split(struct sig_serial_merge *m)
{
	fixme();
}

struct sig_serial *
sig_serial_create(const char *name)
{
	struct sig_serial *sig;

	sig = shm_alloc(sizeof(*sig));
	assert(sig);

	sig->type = SIG_GEN_SERIAL;
	sig->nmembers = 0;

	return sig;
}

void
sig_serial_destroy(struct sig_serial *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_SERIAL);

	shm_free(sig);
}

void
sig_serial_suspend(struct sig_serial *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_serial_resume(struct sig_serial *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
