/*
 * $Id: sig_scsi_bus.h,v 1.14 2013-05-10 07:20:18 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_SCSI_BUS_H_INCLUDED
#define __SIG_SCSI_BUS_H_INCLUDED

#include <inttypes.h>
#include "sig_gen.h"

struct sig_scsi_bus_funcs {
	int (*phase_select)(void *s, uint32_t id);
	int (*phase_reselect)(void *s, uint32_t id);
	void (*phase_msg_out)(void *s);
	void (*phase_msg_in)(void *s);
	void (*phase_command)(void *s);
	void (*phase_data_out)(void *s);
	void (*phase_data_in)(void *s);
	void (*phase_status)(void *s);
	void (*phase_free)(void *s);

	void (*atn_set)(void *s, unsigned int val);

	void (*want_recv)(void *s, unsigned long count);
	unsigned long (*send)(void *s,
			const uint8_t *buf, unsigned long bufsize);
	void (*want_send)(void *s, unsigned long count);
	unsigned long (*recv)(void *s,
			uint8_t *buf, unsigned long bufsize);
};

struct sig_scsi_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_scsi_bus_funcs *f;
	} member[32];
	unsigned int member_count;
	enum {
		SIG_SCSI_BUS_PHASE_FREE = 1,
		SIG_SCSI_BUS_PHASE_MSG_IN,
		SIG_SCSI_BUS_PHASE_MSG_OUT,
		SIG_SCSI_BUS_PHASE_COMMAND,
		SIG_SCSI_BUS_PHASE_STATUS,
		SIG_SCSI_BUS_PHASE_DATA_IN,
		SIG_SCSI_BUS_PHASE_DATA_OUT,
	} state;
};

extern int
sig_scsi_bus_phase_reselect(struct sig_scsi_bus *b, void *s, uint32_t id);
extern int
sig_scsi_bus_phase_select(struct sig_scsi_bus *b, void *s, uint32_t id);
extern void
sig_scsi_bus_phase_msg_out(struct sig_scsi_bus *b, void *s);
extern void
sig_scsi_bus_phase_msg_in(struct sig_scsi_bus *b, void *s);
extern void
sig_scsi_bus_phase_command(struct sig_scsi_bus *b, void *s);
extern void
sig_scsi_bus_phase_data_out(struct sig_scsi_bus *b, void *s);
extern void
sig_scsi_bus_phase_data_in(struct sig_scsi_bus *b, void *s);
extern void
sig_scsi_bus_phase_status(struct sig_scsi_bus *b, void *s);
extern void
sig_scsi_bus_phase_free(struct sig_scsi_bus *b, void *s);

extern void
sig_scsi_bus_atn_set(struct sig_scsi_bus *b, void *s, unsigned int val);

extern void
sig_scsi_bus_want_recv(struct sig_scsi_bus *b, void *s,
		unsigned long count);
extern unsigned long
sig_scsi_bus_send(struct sig_scsi_bus *b, void *s,
		const uint8_t *buf, unsigned long bufsize);
extern void
sig_scsi_bus_want_send(struct sig_scsi_bus *b, void *s,
		unsigned long count);
extern unsigned long
sig_scsi_bus_recv(struct sig_scsi_bus *b, void *s,
		uint8_t *buf, unsigned long bufsize);

extern void
sig_scsi_bus_connect(struct sig_scsi_bus *b, void *s, const struct sig_scsi_bus_funcs *f);

extern struct sig_scsi_bus_merge *
sig_scsi_bus_merge(struct sig_scsi_bus *s0, struct sig_scsi_bus *s1);
extern void
sig_scsi_bus_split(struct sig_scsi_bus_merge *m);

extern struct sig_scsi_bus *
sig_scsi_bus_create(const char *name);
extern void
sig_scsi_bus_destroy(struct sig_scsi_bus *sig);

extern void
sig_scsi_bus_suspend(struct sig_scsi_bus *b, FILE *fSig);
extern void
sig_scsi_bus_resume(struct sig_scsi_bus *b, FILE *fSig);

#endif /* ! __SIG_SCSI_BUS_H_INCLUDED */
