/*
 * $Id: sig_sata_bus.h,v 1.2 2013/06/06 06:57:01 vrsieh Exp $
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_SATA_BUS_H_INCLUDED
#define __SIG_SATA_BUS_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_sata_bus_funcs {
	/* Controller -> Device */
	void (*reset)(void *cpssp, unsigned int val);
	int (*inw)(void *cpssp, uint16_t port, uint16_t *valp);
	void (*outw)(void *cpssp, uint16_t port, uint16_t val);
	int (*dmainw)(void *cpssp, uint16_t *valp);
	void (*dmaoutw)(void *cpssp, uint16_t val);
	/* Device -> Controller */
	void (*irq)(void *c, unsigned int val);
	void (*dmarq_set)(void *c, unsigned int val);

	void (*comreset)(void *cpssp);
	void (*hold)(void *cpssp);
	void (*r_ip)(void *cpssp);

	void (*h2d_register)(void *_cpssp,
			int c, uint8_t command, uint16_t features,
			uint16_t sector_number, uint32_t cyl, uint8_t dev_head,
			uint16_t sector_count, uint8_t control);
	void (*h2d_data)(void *_cpssp,
			uint16_t *buf, unsigned int bufcnt);
	void (*d2h_register)(void *_cpssp,
			int i, uint8_t status, uint8_t error,
			uint16_t sector_number, uint32_t cyl, uint8_t dev_head,
			uint16_t sector_count);
	void (*d2h_set_device_bits)(void *_cpssp,
			uint8_t error, uint8_t status);
	void (*d2h_dma_activate)(void *_cpssp);
	void (*d2h_pio_setup)(void *_cpssp,
			int d, int i, uint8_t status, uint8_t error,
			uint16_t sector_number, uint32_t cyl, uint8_t dev_head,
			uint16_t sector_count, uint8_t e_status,
			uint16_t transfer_count);
	void (*d2h_data)(void *_cpssp,
			uint16_t *buf, unsigned int bufcnt);
};

struct sig_sata_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_sata_bus_funcs *funcs;
		int irq_state;
	} member[3];
	unsigned int nmembers;
};

extern void
sig_sata_bus_reset(struct sig_sata_bus *b, unsigned int val);

extern void
sig_sata_bus_inw(struct sig_sata_bus *b, uint16_t port, uint16_t *valp);
extern void
sig_sata_bus_outw(struct sig_sata_bus *b, uint16_t port, uint16_t val);

extern void
sig_sata_bus_dmainw(struct sig_sata_bus *b, uint16_t *valp);
extern void
sig_sata_bus_dmaoutw(struct sig_sata_bus *b, uint16_t val);

extern void
sig_sata_bus_irq(struct sig_sata_bus *b, void *s, unsigned int val);
extern void
sig_sata_bus_dmarq_set(struct sig_sata_bus *b, unsigned int val);

extern void
sig_sata_bus_h2d_register(struct sig_sata_bus *b, void *_cpssp,
		int c, uint8_t command, uint16_t features,
		uint16_t sector_number, uint32_t cyl, uint8_t dev_head,
		uint16_t sector_count, uint8_t control);

extern void
sig_sata_bus_h2d_data(struct sig_sata_bus *b, void *_cpssp, 
		uint16_t *buf, unsigned int bufcnt);

extern void
sig_sata_bus_d2h_register(struct sig_sata_bus *b, void *_cpssp, 
		int i, uint8_t status, uint8_t error,
		uint16_t sector_number, uint32_t cyl, uint8_t dev_head,
		uint16_t sector_count);
extern void
sig_sata_bus_d2h_set_device_bits(struct sig_sata_bus *b, void *_cpssp, 
		uint8_t error, uint8_t status);
extern void
sig_sata_bus_d2h_dma_activate(struct sig_sata_bus *b, void *_cpssp);
extern void
sig_sata_bus_d2h_pio_setup(struct sig_sata_bus *b, void *_cpssp, 
		int d, int i, uint8_t status, uint8_t error,
		uint16_t sector_number, uint32_t cyl, uint8_t dev_head,
		uint16_t sector_count, uint8_t e_status,
		uint16_t transfer_count);
extern void
sig_sata_bus_d2h_data(struct sig_sata_bus *b, void *_cpssp, 
		uint16_t *buf, unsigned int bufcnt);

extern void
sig_sata_bus_connect(
	struct sig_sata_bus *b,
	void *s,
	const struct sig_sata_bus_funcs *funcs
);

extern struct sig_sata_bus_merge *
sig_sata_bus_merge(struct sig_sata_bus *s0, struct sig_sata_bus *s1);
extern void
sig_sata_bus_split(struct sig_sata_bus_merge *m);

extern struct sig_sata_bus *
sig_sata_bus_create(const char *name);
extern void
sig_sata_bus_destroy(struct sig_sata_bus *sig);

extern void
sig_sata_bus_suspend(struct sig_sata_bus *b, FILE *fSig);
extern void
sig_sata_bus_resume(struct sig_sata_bus *b, FILE *fSig);

#endif /* __SIG_SATA_BUS_H_INCLUDED*/
