/*
 * $Id: sig_mdi.h,v 1.1 2013-04-03 20:33:55 vrsieh Exp $ 
 *
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_MDI_H_INCLUDED
#define __SIG_MDI_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_mdi_funcs {
	void (*read)(void *s, unsigned int reg, uint16_t *valp);
	void (*write)(void *s, unsigned int reg, uint16_t val);

	void (*recv)(void *s, const void *buf, unsigned int buflen);
};

struct sig_mdi {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_mdi_funcs *f;
	} member[2];
	int nmembers;
};

extern void
sig_mdi_read(struct sig_mdi *b, void *s,
		unsigned int reg, uint16_t *valp);
extern void
sig_mdi_write(struct sig_mdi *b, void *s,
		unsigned int reg, uint16_t val);

extern void
sig_mdi_send(struct sig_mdi *b, void *s,
		const void *buf, unsigned int buflen);

extern void
sig_mdi_connect(struct sig_mdi *b, void *s, const struct sig_mdi_funcs *f);

extern struct sig_mdi *
sig_mdi_create(const char *name);
extern void
sig_mdi_destroy(struct sig_mdi *bus);

extern void
sig_mdi_suspend(struct sig_mdi *b, FILE *fSig);
extern void
sig_mdi_resume(struct sig_mdi *b, FILE *fSig);

#endif /* __SIG_MDI_H_INCLUDED */
