/*
 * $Id: sig_isa_dma.h,v 1.2 2013-04-16 06:57:01 vrsieh Exp $
 * 
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_ISA_DMA_H_INCLUDED
#define __SIG_ISA_DMA_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_isa_dma_funcs {
	/* Slave -> DMA Controller. */
	int (*req)(void *s);

	/* Controller -> Glue. */
	int (*ack_in)(void *s, uint32_t addr, unsigned int tc);
	int (*ack_out)(void *s, uint32_t addr, unsigned int tc);
	int (*ack_verify)(void *s, unsigned int tc);

	/* Glue -> Slave. */
	int (*ack_inb)(void *s, unsigned int tc, unsigned char *val);
	int (*ack_inw)(void *s, unsigned int tc, unsigned short *val);
	int (*ack_outb)(void *s, unsigned int tc, unsigned char val);
	int (*ack_outw)(void *s, unsigned int tc, unsigned short val);
	int (*ack_verifyb)(void *s, unsigned int tc);
	int (*ack_verifyw)(void *s, unsigned int tc);
};

struct sig_isa_dma {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_isa_dma_funcs *f;
	} member[16];
	int member_count;
};

struct sig_isa_dma_merge {
	struct sig_isa_dma *s0;
	struct sig_isa_dma *s1;
};

extern int
sig_isa_dma_ack_in(struct sig_isa_dma *d, void *s,
		uint32_t addr, unsigned int tc);
extern int
sig_isa_dma_ack_out(struct sig_isa_dma *d, void *s,
		uint32_t addr, unsigned int tc);
extern int
sig_isa_dma_ack_verify(struct sig_isa_dma *d, void *s,
		unsigned int tc);

extern int
sig_isa_dma_ack_inb(struct sig_isa_dma *d, void *s,
		unsigned int tc, uint8_t *valp);
extern int
sig_isa_dma_ack_inw(struct sig_isa_dma *d, void *s,
		unsigned int tc, uint16_t *valp);
extern int
sig_isa_dma_ack_outb(struct sig_isa_dma *d, void *s,
		unsigned int tc, uint8_t val);
extern int
sig_isa_dma_ack_outw(struct sig_isa_dma *d, void *s,
		unsigned int tc, uint16_t val);
extern int
sig_isa_dma_ack_verifyb(struct sig_isa_dma *d, void *s,
		unsigned int tc);
extern int
sig_isa_dma_ack_verifyw(struct sig_isa_dma *d, void *s,
		unsigned int tc);

extern int
sig_isa_dma_req(struct sig_isa_dma *b, void *s);

extern void
sig_isa_dma_connect(struct sig_isa_dma *b,
		void *s, const struct sig_isa_dma_funcs *f);

extern struct sig_isa_dma_merge *
sig_isa_dma_merge(
	struct sig_isa_dma *s0,
	struct sig_isa_dma *s1
);
extern void
sig_isa_dma_split(struct sig_isa_dma_merge *m);

extern struct sig_isa_dma *
sig_isa_dma_create(const char *name);
extern void
sig_isa_dma_destroy(struct sig_isa_dma *sig);

extern void
sig_isa_dma_suspend(struct sig_isa_dma *b, FILE *fSig);
extern void
sig_isa_dma_resume(struct sig_isa_dma *b, FILE *fSig);

#endif /* __SIG_ISA_DMA_H_INCLUDED */
