/*
 * $Id: sig_ide_bus.h,v 1.2 2013-06-05 12:56:28 vrsieh Exp $
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __SIG_IDE_BUS_H_INCLUDED
#define __SIG_IDE_BUS_H_INCLUDED

#include <inttypes.h>

#include "sig_gen.h"

struct sig_ide_bus_funcs {
	/* Controller -> Device */
	void (*reset)(void *cpssp, unsigned int val);
	int (*inw)(void *cpssp, uint16_t port, uint16_t *valp);
	void (*outw)(void *cpssp, uint16_t port, uint16_t val);
	int (*dmainw)(void *cpssp, uint16_t *valp);
	void (*dmaoutw)(void *cpssp, uint16_t val);
	/* Device -> Controller */
	void (*irq)(void *c, unsigned int val);
	void (*dmarq_set)(void *c, unsigned int val);
};

struct sig_ide_bus {
	enum sig_gen_type type;
	struct {
		void *s;
		const struct sig_ide_bus_funcs *funcs;
		int irq_state;
	} member[3];
	unsigned int nmembers;
};

extern void
sig_ide_bus_reset(struct sig_ide_bus *b, unsigned int val);

extern void
sig_ide_bus_inw(struct sig_ide_bus *b, uint16_t port, uint16_t *valp);
extern void
sig_ide_bus_outw(struct sig_ide_bus *b, uint16_t port, uint16_t val);

extern void
sig_ide_bus_dmainw(struct sig_ide_bus *b, uint16_t *valp);
extern void
sig_ide_bus_dmaoutw(struct sig_ide_bus *b, uint16_t val);

extern void
sig_ide_bus_irq(struct sig_ide_bus *b, void *s, unsigned int val);
extern void
sig_ide_bus_dmarq_set(struct sig_ide_bus *b, unsigned int val);

extern void
sig_ide_bus_connect(
	struct sig_ide_bus *b,
	void *s,
	const struct sig_ide_bus_funcs *funcs
);

extern struct sig_ide_bus_merge *
sig_ide_bus_merge(struct sig_ide_bus *s0, struct sig_ide_bus *s1);
extern void
sig_ide_bus_split(struct sig_ide_bus_merge *m);

extern struct sig_ide_bus *
sig_ide_bus_create(const char *name);
extern void
sig_ide_bus_destroy(struct sig_ide_bus *sig);

extern void
sig_ide_bus_suspend(struct sig_ide_bus *b, FILE *fSig);
extern void
sig_ide_bus_resume(struct sig_ide_bus *b, FILE *fSig);

#endif /* __SIG_IDE_BUS_H_INCLUDED*/
