#!/bin/sh
#
# $Id$
#
# Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.

obj=${1}

lastnum=0
laststart=0
lastname=""

objdump -d ${obj} \
| grep '^[0-9a-f].* <.*>:$' \
| sed -e 's/<//' \
| sed -e 's/>://' \
| while read _start name ; do
	start=`echo ${_start} | tr 'a-f' 'A-F'`
	if [ "${lastname}" != "" ] ; then
		size=`echo "ibase=16; ${start}-${laststart}" | bc`
		if [ '(' 4 -le ${size} ')' -a '(' ${size} -lt 10000 ')' ] ; then
			echo ${size} ${lastname}
		fi
	fi
	laststart=${start}
	lastname=${name}
done \
| sort -n \
| while read size name ; do
	echo "${lastnum} ${size} ${name}"
	lastnum=`expr ${lastnum} + 1`
done
