/* $Id$ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define HASH_SIZE	(4096*1024)

struct entry {
	struct entry *prev;
	struct entry *next;

	uint64_t addr;
	unsigned int last;
};

struct entry *first[HASH_SIZE];
struct entry *last[HASH_SIZE];


static unsigned int
hash(uint64_t addr)
{
	addr /= 32;
	return addr % HASH_SIZE;
}

static struct entry *
entry_get(uint64_t addr)
{
	unsigned int h;
	struct entry *t;

	h = hash(addr);

	for (t = first[h]; ; t = t->next) {
		if (! t) {
			t = malloc(sizeof(*t));
			assert(t);
			memset(t, 0, sizeof(*t));

			t->addr = addr;

			t->prev = last[h];
			t->next = NULL;
			if (t->prev) {
				t->prev->next = t;
			} else {
				first[h] = t;
			}
			last[h] = t;
			break;
		}
		if (t->addr == addr) {
			break;
		}
	}

	return t;
}


int
main(void)
{
	unsigned int lineno;
	char line[1024];
	unsigned int h;
	struct entry *t;

	lineno = 1;
	while (fgets(line, sizeof(line) - 1, stdin)) {
		uint64_t addr;

		addr = strtoull(line, NULL, 16);
		entry_get(addr)->last = lineno;
		lineno++;

		if (lineno % (1024*128) == 0) {
			fprintf(stderr, "Line %d\n", lineno);
		}
	}

	for (h = 0; h < HASH_SIZE; h++) {
		for (t = first[h]; t; t = t->next) {
			printf("%u %016llx\n",
					t->last, (unsigned long long) t->addr);
		}
	}

	return 0;
}
