/*
 * $Id: isa_gen_ne2000_gui.c,v 1.1 2013-05-13 18:03:42 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "isa_gen_ne2000_gui.h"

#ifdef HAVE_GTK
#include "isa_gen_ne2000_gui_gtk.h"
#endif

void *
isa_gen_ne2000_gui_create(
	unsigned int page,
	const char *name,
	const char *irq,
	const char *ioaddr,
	const char *mac,
	struct sig_manage *port_manage,
	struct sig_isa_conn *port_isa,
	struct sig_eth_conn *port_eth,
	struct sig_boolean *port_opt_busy_led
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return isa_gen_ne2000_gui_gtk_create(
				page,
				name,
				irq,
				ioaddr,
				mac,
				port_manage,
				port_isa,
				port_eth,
				port_opt_busy_led);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
isa_gen_ne2000_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		isa_gen_ne2000_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
isa_gen_ne2000_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		isa_gen_ne2000_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
isa_gen_ne2000_gui_resume(void *_cpssp, FILE *fComp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		isa_gen_ne2000_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
