/*
 * $Id: head.S,v 1.2 2013/05/22 14:09:16 vrsieh Exp $
 *
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "compiler.h"

/*
 * Format of the header:
 *
 * 0x00: 0xaa55		Magic
 * 0x02: 		Length / 512; patched by scripts/bin2bios
 * 0x03: jmp init	Near JMP to init procedure
 * 0x06:		ROM Program Name List
 *	0x00: strlen(name0)
 *	0x01: name0
 *	    : jmp name0_prog
 *	    : strlen(name1)
 *	    : name1
 *	    : jmp name1_prog
 *	...
 *	    : 0x00
 *
 * Names are searched by DOS on int 0x21, ax=0x4b00 if name of called
 * binary contains no ':' and no '\'.
 */

.code16
	.text
stext: .globl stext
.org 0x00000000
	.word	0xaa55	/* magic */
	.byte	0	/* length / 512; patched by scripts/bin2bios */

.org 0x00000003
	jmp .l
.org 0x00000006
	.byte 0	/* No Names, No Entry Points */
.l:
	ex_lcall video_init
	lretw
