#!/usr/bin/perl -w
#
# $Id: preasm_proc.pl,v 1.4 2012-02-20 09:02:11 vrsieh Exp $
#
# Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.
#

$in_file = $ARGV[0];
$out_file = $ARGV[1];

open(IN, $in_file) 
	|| die "$PROGRAM: unable to open input file \"$in_file\" ($!)";

open(OUT, ">$out_file") 
	|| die "$PROGRAM: unable to open output file \"$out_file\" ($!)";

while (defined($line = <IN>)) {
	if ($line =~ /\s*ex_lcall\b\s*\b([\w\.]*)(;|\s)*.*/) {
		$tar_label = $1;
		print OUT "\t.byte 0x9a\n";
		print OUT "\t.word OFF_$tar_label, SEG_$tar_label\n";

	}elsif ($line =~ /\s*ex_ljmp\b\s*\b([\w\.]*)(;|\s)*.*/) {
		$tar_label = $1;
		print OUT "\t.byte 0xea\n";
		print OUT "\t.word OFF_$tar_label, SEG_$tar_label\n";

	} else {
		print OUT "$line\n";
	}
}

close(IN) 
	|| die "$PROGRAM: unable to close input file \"$in_file\" ($!)";

close(OUT) 
	|| die "$PROGRAM: unable to close output file \"$out_file\" ($!)";
