/*
 * $Id: gen.c,v 1.1 2013-04-22 08:08:16 vrsieh Exp $
 *
 * Copyright (C) 2013 FAUmachine Team <info@faumachine.org>.
 *
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <unistd.h>

int
main(void)
{
	static const unsigned char edidblock[128] = {
		/* EDID Header */
		0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00,
		/* Vendor Information */
		0x05, 0xb4, /* Manufacturer ID */
		0x30, 0x55, /* Product Code */
		0xbb, 0x02, 0x00, 0x00, /* Serial No. */
		0x29, 0x09, /* Week, Year-1990 */
		/* EDID Structure Versioning */
		0x01, 0x01, /* Version, Revision */
		/* Basic Display Parameters */
		0x1e, /* Video Input Definition: analog */
		36, 27, /* X,Y Size in cm */
		0x78, 0xe8, /* Gamma, Supported Features */
		/* Color Characteristics */
		0x07, 0xb3, 0xa0, 0x57, 0x4a, 0x9a, 0x26, 0x11, 0x48, 0x4f,
		/* Established Timings */
		0xbc, 0xe7, 0x80,
		/* Standard Timing Identification */
		/* First byte
		 *   Horizontal resolution.  Multiply by 8, then add 248 for actual value.
		 * Second byte
		 *   bit 7-6: Aspect ratio.  00=16:10, 01=4:3, 10=5:4, 11=16:9
		 *   bit 5-0: Vertical frequeny.  Add 60 to get actual value.
		 */
		0xa9, 0x4f, /* 1600x1200 75 Hz */
		0xa9, 0x4a, /* 1600x1200 70 Hz */
		0x61, 0x59, /* 1024x768 85 Hz */
		0x31, 0x59, /* 640x480 85 Hz */
		0x45, 0x59, /* 800x600 85 Hz */
		0x31, 0x4a, /* 640x480 70 Hz */
		0xa9, 0x45, /* 1600x1200 65 Hz */
		0x01, 0x01, /* unused */
		/* Detailed Timing Description #1 */
		0x1a, 0x4f, 0x40, 0x30, 0x62, 0xb0, 0x32, 0x40, 0x40, 0xc0,
		0x13, 0x00, 0x8e, 0x2b, 0x11, 0x00, 0x00, 0x1e,
		/* Detailed Timing Description #2 */
		0xd4, 0x49, 0x40, 0x30, 0x62, 0xb0, 0x32, 0x40, 0x40, 0xc0,
		0x13, 0x00, 0x8e, 0x2b, 0x11, 0x00, 0x00, 0x1e,
		/* Detailed Timing Description #3 */
		0xea, 0x24, 0x00, 0x60, 0x41, 0x00, 0x28, 0x30, 0x30, 0x60,
		0x13, 0x00, 0x8e, 0x2b, 0x11, 0x00, 0x00, 0x1e,
		/* Detailed Timing Description #4 */
		0x40, 0x1f, 0x00, 0x30, 0x41, 0x00, 0x24, 0x30, 0x20, 0x60,
		0x33, 0x00, 0x8e, 0x2b, 0x11, 0x00, 0x00, 0x02,
		/* Extension Flag */
		0x00,
		/* Checksum: 1-byte sum of all 128 bytes in block must be 0 */
		0xc3
		/* rest is not set */
	};

	write(1, edidblock, 128);

	return 0;
}
