/* $Id: stdio.h,v 1.1 2013-04-22 16:24:23 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef _STDIO_H_INCLUDED
#define _STDIO_H_INCLUDED

#include "build_config.h"

#include "stdarg.h"

#define vsprintf	MODE_PREFIX(vsprintf)
#define dprintf	MODE_PREFIX(dprintf)
#define putcstr	MODE_PREFIX(putcstr)

#define skip_atoi	MODE_PREFIX(skip_atoi)
#define number	MODE_PREFIX(number)

extern void
dprintf(const char *fmt, ...);

extern int
vsprintf(char *buf, const char *fmt, va_list args);

extern void
putcstr(const char *str);

#define bprintf		MODE_PREFIX(bprintf)
#define puthex		MODE_PREFIX(puthex)

extern void
bprintf(const char *fmt, ...);

extern void
puthex(int ndigits, unsigned int n);

#endif /* _STDIO_H_INCLUDED */
