/*
 * $Id: setup.c,v 1.1 2013-05-13 08:45:12 vrsieh Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include "build_config.h"

#include "setup.h"
#include "cmos.h"
#include "video.h"
#include "video.h"
#include "stdio.h"
#include "cmos.h"
#include "kbd.h"
#include "debug.h"
#include "pci.h"
#include "segment.h"
#include "const.h"

/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

CODE16;

#include "setup_inc.c"

static inline unsigned int
abs(int x)
{
	if (x < 0) {
		return -x;
	} else {
		return x;
	}
}

static unsigned int
var_get(unsigned int entry)
{
	uint8_t mask;
	uint8_t byte;
	uint8_t val;

	mask = (1 << (const_get(data[entry].bit_first) - const_get(data[entry].bit_last) + 1)) - 1;

	byte = cmos_readb(const_get(data[entry].cmos_reg));
	val = byte;
	val >>= const_get(data[entry].bit_last);
	val &= mask;

	return val;
}

static void
var_set(unsigned int entry, unsigned int val)
{
	uint8_t mask;
	uint8_t byte;

	mask = (1 << (const_get(data[entry].bit_first) - const_get(data[entry].bit_last) + 1)) - 1;

	byte = cmos_readb(const_get(data[entry].cmos_reg));
	byte &= ~(mask << const_get(data[entry].bit_last));
	byte |= val << const_get(data[entry].bit_last);
	cmos_writeb(const_get(data[entry].cmos_reg), byte);
}

int
setup_defaults(void)
{
	unsigned int var;
	unsigned short i;

	if (cmos_ext_get(initialized)) {
		return 0;
	}
	
	for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
		if (const_get(data[var].choice_count) == 1) {
			continue;
		}
		var_set(var, const_get(choice[const_get(data[var].choice_nr)].val));
	}

	/* clear old values */
	for (i = 0; i < 128; i++) {
		cmos_ext_write(i, 0);
	}

	cmos_ext_put(initialized, 1);
	cmos_ext_put(apm, 0);

	return 1;
}

static void
show(unsigned int y, unsigned int x, char c, int mode)
{
	uint8_t attr;

	if (mode == 0) {
		/* Entry */
		attr = 0x1e; /* Yellow/Blue */

	} else if (mode == 1) {
		/* Selected Entry */
		attr = 0x4f; /* White/Red */

	} else { assert(mode == 2);
		/* Mask */
		attr = 0x1f; /* White/Blue */
	}

	put_byte(0xb800, (y * 80 + x) * 2 + 0, c);
	put_byte(0xb800, (y * 80 + x) * 2 + 1, attr);
}

void
setup_init(void)
{
	unsigned int m;
	unsigned int entry;
	unsigned int best;
	unsigned int var;
	unsigned int x;
	unsigned int y;
	unsigned short key;

	/* Turn off cursor. */
	/* FIXME */

	m = 0;
new_menu:;
	/* Lookup top/left entry. */
	entry = 0xffff;
	for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
		if (const_get(data[var].menu_nr) != m) {
			continue;
		}
		if (entry == 0xffff
		 || const_get(data[var].pos_y) < const_get(data[entry].pos_y)
		 || (const_get(data[var].pos_y) == const_get(data[entry].pos_y)
		  && const_get(data[var].pos_x) < const_get(data[entry].pos_x))) {
			entry = var;
		}
	}

	/* Print menu mask. */
	for (y = 0; y < 25; y++) {
		for (x = 0; x < 80; x++) {
			const char *page_str;

			page_str = string[page[m][y]];
			show(y, x, const_get(page_str[x]), 2);
		}
	}

	while (1) {
		/* Print menu entries. */
		for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
			const char *choice_str;
			unsigned int val;
			unsigned int c;

			if (const_get(data[var].menu_nr) != m) {
				continue;
			}

			if (2 <= const_get(data[var].choice_count)) {
				val = var_get(var);
			} else {
				val = 0;
			}

			for (c = 0; ; c++) {
				if (c == const_get(data[var].choice_nr)) {
					/* Not found. */
					c = 0;
					break;
				}
				if (const_get(choice[const_get(data[var].choice_nr) + c].val) == val) {
					/* Found */
					break;
				}
			}

			choice_str = (const char *) const_get(string[const_get(choice[const_get(data[var].choice_nr) + c].str)]);

			for (x = 0; choice_str[x]; x++) {
				show(const_get(data[var].pos_y), const_get(data[var].pos_x) + x,
						const_get(choice_str[x]),
						var == entry);
			}
		}
	
		while (! key_available()) {
		}

		key = key_get();

		if (key == 0x4800) {
			/* Cursor Up */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || const_get(data[var].menu_nr) != m
				 || const_get(data[entry].pos_y) <= const_get(data[var].pos_y)) {
					continue;
				}
				if (best == 0xffff
				 || const_get(data[best].pos_y) < const_get(data[var].pos_y)
				 || (const_get(data[best].pos_y) == const_get(data[var].pos_y)
				  && abs(const_get(data[var].pos_x) - const_get(data[entry].pos_x))
				   < abs(const_get(data[best].pos_x) - const_get(data[entry].pos_x)))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x5000) {
			/* Cursor Down */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || const_get(data[var].menu_nr) != m
				 || const_get(data[var].pos_y) <= const_get(data[entry].pos_y)) {
					continue;
				}
				if (best == 0xffff
				 || const_get(data[var].pos_y) < const_get(data[best].pos_y)
				 || (const_get(data[var].pos_y) == const_get(data[best].pos_y)
				  && abs(const_get(data[var].pos_x) - const_get(data[entry].pos_x))
				   < abs(const_get(data[best].pos_x) - const_get(data[entry].pos_x)))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x4B00) {
			/* Cursor Left */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || const_get(data[var].menu_nr) != m
				 || const_get(data[entry].pos_x) <= const_get(data[var].pos_x)) {
					continue;
				}
				if (best == 0xffff
				 || const_get(data[best].pos_x) < const_get(data[var].pos_x)
				 || (const_get(data[best].pos_x) == const_get(data[var].pos_x)
				  && abs(const_get(data[var].pos_y) - const_get(data[entry].pos_y))
				   < abs(const_get(data[best].pos_y) - const_get(data[entry].pos_y)))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x4d00) {
			/* Cursor Right */
			best = 0xffff;
			for (var = 0; var < sizeof(data) / sizeof(data[0]); var++) {
				if (var == entry
				 || const_get(data[var].menu_nr) != m
				 || const_get(data[var].pos_x) <= const_get(data[entry].pos_x)) {
					continue;
				}
				if (best == 0xffff
				 || const_get(data[var].pos_x) < const_get(data[best].pos_x)
				 || (const_get(data[var].pos_x) == const_get(data[best].pos_x)
				  && abs(const_get(data[var].pos_y) - const_get(data[entry].pos_y))
				   < abs(const_get(data[best].pos_y) - const_get(data[entry].pos_y)))) {
					best = var;
				}
			}
			if (best != 0xffff) {
				entry = best;
			}

		} else if (key == 0x4900
			|| key == 0x0d2b) {
			/* Page Up / + */
			unsigned int val;

			/* Get value. */
			val = var_get(entry);

			/* Lookup choice. */
			for (var = 0; ; var++) {
				if (var == const_get(data[entry].choice_count)) {
					/* Not found. */
					var = 0;
					break;
				}
				if (const_get(choice[const_get(data[entry].choice_nr) + var].val) == val) {
					/* Found */
					break;
				}
			}

			assert(0 <= var && var < const_get(data[entry].choice_count));

			/* Select previous choice. */
			if (0 < var) {
				var--;
			} else {
				var = const_get(data[entry].choice_count) - 1;
			}

			/* Set value. */
			var_set(entry, const_get(choice[const_get(data[entry].choice_nr) + var].val));

		} else if (key == 0x5100
			|| key == 0x0c2d) {
			/* Page Down / - */
			unsigned int val;

			/* Get value. */
			val = var_get(entry);

			/* Lookup choice. */
			for (var = 0; ; var++) {
				if (var == const_get(data[entry].choice_count)) {
					/* Not found. */
					var = 0;
					break;
				}
				if (const_get(choice[const_get(data[entry].choice_nr) + var].val) == val) {
					/* Found */
					break;
				}
			}

			assert(0 <= var && var < const_get(data[entry].choice_count));

			/* Select next choice. */
			if (var < const_get(data[entry].choice_count) - 1) {
				var++;
			} else {
				var = 0;
			}

			/* Set value. */
			var_set(entry, const_get(choice[const_get(data[entry].choice_nr) + var].val));

		} else if (key == 0x3b00) {
			/* F1 */

		} else if (key == 0x3c00) {
			/* F2 */

		} else if (key == 0x3f00) {
			/* F5 */

		} else if (key == 0x4100) {
			/* F7 */

		} else if (key == 0x4400) {
			/* F10 */

		} else if (key == 0x1c0d) {
			/* Return */
			if (const_get(data[entry].choice_count) == 1) {
				if (const_get(data[entry].bit_last) == 0) {
					/* New Menu */
					m = const_get(data[entry].bit_first);
					goto new_menu;
				} else {
					/* Do Dialog */
					/* FIXME */
					return;
				}
			}

		} else if (key == 0x011b) {
			/* Escape */
			m = 0;
			goto new_menu;

		} else {
			dprintf("Key 0x%04x pressed.\n", key);
		}
	}
}

void
setup_exit(void)
{
	uint16_t sum;
	unsigned int reg;

	sum = 0;
	for (reg = 0x10; reg < 0x2e; reg++) {
		sum += cmos_readb(reg);
	}
	cmos_writeb(0x2e, (sum >> 8) & 0xff);
	cmos_writeb(0x2f, (sum >> 0) & 0xff);

	sum = 0;
	for (reg = 0x40; reg < 0x7d; reg++) {
		sum += cmos_readb(reg);
	}
	cmos_writeb(0x7d, (sum >> 8) & 0xff);
	cmos_writeb(0x7e, (sum >> 0) & 0xff);
}

#endif /* INIT_RM */
