/*
 * $Id: memcpy.S,v 1.1 2013-04-22 16:24:22 vrsieh Exp $
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "build_config.h"
#include "libsys.h"
#include "compiler.h"

#ifdef INIT_RM

	.code16gcc

segr8: .globl segr8
	pushw %ds

	/* Get segment/offset. */
	movl 2+4(%esp), %edx
	movl %edx, %ecx
	shrl $4, %edx
	andl $0b1111, %ecx

	/* Read byte. */
	movw %dx, %ds
	movzbl (%ecx), %eax

	popw %ds
	lretw

segr16: .globl segr16
	pushw %ds

	/* Get segment/offset. */
	movl 2+4(%esp), %edx
	movl %edx, %ecx
	shrl $4, %edx
	andl $0b1111, %ecx

	/* Read word. */
	movw %dx, %ds
	movzwl (%ecx), %eax

	popw %ds
	lretw

segr32: .globl segr32
	pushw %ds

	/* Get segment/offset. */
	movl 2+4(%esp), %edx
	movl %edx, %ecx
	shrl $4, %edx
	andl $0b1111, %ecx

	/* Read long. */
	movw %dx, %ds
	movl (%ecx), %eax

	popw %ds
	lretw

segw8: .globl segw8
	pushw %ds

	/* Get segment/offset. */
	movl 2+4(%esp), %edx
	movl %edx, %ecx
	shrl $4, %edx
	andl $0b1111, %ecx

	/* Get value. */
	movl 2+8(%esp), %eax

	/* Write byte. */
	movw %dx, %ds
	movb %al, (%ecx)

	popw %ds
	lretw

segw16: .globl segw16
	pushw %ds

	/* Get segment/offset. */
	movl 2+4(%esp), %edx
	movl %edx, %ecx
	shrl $4, %edx
	andl $0b1111, %ecx

	/* Get value. */
	movl 2+8(%esp), %eax

	/* Write word. */
	movw %dx, %ds
	movw %ax, (%ecx)

	popw %ds
	lretw

segw32: .globl segw32
	pushw %ds

	/* Get segment/offset. */
	movl 2+4(%esp), %edx
	movl %edx, %ecx
	shrl $4, %edx
	andl $0b1111, %ecx

	/* Get value. */
	movl 2+8(%esp), %eax

	/* Write long. */
	movw %dx, %ds
	movl %eax, (%ecx)

	popw %ds
	lretw

mem4Gcpy: .globl mem4Gcpy
	pushl %edi
	pushl %esi
	pushfl
	cli
	pushw %ds
	pushw %es

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %ax
	movw %ax, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %eax
	orl $1, %eax
	movl %eax, %cr0

	movw $8, %ax
	movw %ax, %ds	/* Load base 0 and limit 4G. */
	movw %ax, %es	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 16+4(%esp), %edi	/* dst */
	movl 16+8(%esp), %esi	/* src */
	movl 16+12(%esp), %ecx	/* count */

	jmp .L2
.L1:
	movb (%esi), %al
	movb %al, (%edi)
	addl $1, %edi
	addl $1, %esi
	subl $1, %ecx
.L2:
	cmpl $0, %ecx
	jne .L1

	/* Switch back to real-mode. */
	movl %cr0, %eax
	andl $~1, %eax
	movl %eax, %cr0

	popw %es
	popw %ds
	popfl
	popl %esi
	popl %edi
	lretw

linr8: .globl linr8
	pushfl
	cli
	pushw %ds

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %dx
	movw %dx, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %edx
	orl $1, %edx
	movl %edx, %cr0

	movw $8, %dx
	movw %dx, %ds	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 6+4(%esp), %edx

	movzbl (%edx), %eax

	/* Switch back to real-mode. */
	movl %cr0, %edx
	andl $~1, %edx
	movl %edx, %cr0

	popw %ds
	popfl
	lretw

linr16: .globl linr16
	pushfl
	cli
	pushw %ds

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %dx
	movw %dx, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %edx
	orl $1, %edx
	movl %edx, %cr0

	movw $8, %dx
	movw %dx, %ds	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 6+4(%esp), %edx

	movzwl (%edx), %eax

	/* Switch back to real-mode. */
	movl %cr0, %edx
	andl $~1, %edx
	movl %edx, %cr0

	popw %ds
	popfl
	lretw

linr32: .globl linr32
	pushfl
	cli
	pushw %ds

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %dx
	movw %dx, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %edx
	orl $1, %edx
	movl %edx, %cr0

	movw $8, %dx
	movw %dx, %ds	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 6+4(%esp), %edx

	movl (%edx), %eax

	/* Switch back to real-mode. */
	movl %cr0, %edx
	andl $~1, %edx
	movl %edx, %cr0

	popw %ds
	popfl
	lretw

linw8: .globl linw8
	pushfl
	cli
	pushw %ds

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %dx
	movw %dx, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %edx
	orl $1, %edx
	movl %edx, %cr0

	movw $8, %dx
	movw %dx, %ds	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 6+4(%esp), %edx
	movl 6+8(%esp), %eax

	movb %al, (%edx)

	/* Switch back to real-mode. */
	movl %cr0, %edx
	andl $~1, %edx
	movl %edx, %cr0

	popw %ds
	popfl
	lretw

linw16: .globl linw16
	pushfl
	cli
	pushw %ds

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %dx
	movw %dx, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %edx
	orl $1, %edx
	movl %edx, %cr0

	movw $8, %dx
	movw %dx, %ds	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 6+4(%esp), %edx
	movl 6+8(%esp), %eax

	movw %ax, (%edx)

	/* Switch back to real-mode. */
	movl %cr0, %edx
	andl $~1, %edx
	movl %edx, %cr0

	popw %ds
	popfl
	lretw

linw32: .globl linw32
	pushfl
	cli
	pushw %ds

	/* Switch to protected mode */
	movw $SEG_prot_gdt, %dx
	movw %dx, %ds
	lgdt %ds:OFF_prot_gdt

	movl %cr0, %edx
	orl $1, %edx
	movl %edx, %cr0

	movw $8, %dx
	movw %dx, %ds	/* Load base 0 and limit 4G. */

	/* Copy bytes. */
	movl 6+4(%esp), %edx
	movl 6+8(%esp), %eax

	movl %eax, (%edx)

	/* Switch back to real-mode. */
	movl %cr0, %edx
	andl $~1, %edx
	movl %edx, %cr0

	popw %ds
	popfl
	lretw

        /* .section .rodata -- Problem with ldscript_patcher.pl -- FIXME */
prot_gdt: .globl prot_gdt
        /* Null descriptor/GDT descriptor */
        .word 3 * 8 - 1
        .long prot_gdt
        .word 0

        /* Data descriptor */
        .word 0xffff            /* Limit 15:0 */
        .word 0x0000            /* Base 15:0 */
        .word (1 << 15)         /* Present */ \
            | (0 << 13)         /* DPL */ \
            | (1 << 12)         /* Code/Data */ \
            | (0x3 << 8)        /* Data+Accessed */ \
            | 0x00              /* Base 23:16 */
        .word (0x00 << (24-16)) /* Base 31:24 */ \
            | (1 << (23-16))    /* Granularity */ \
            | (0 << (22-16))    /* 16bit Data */ \
            | (0 << (21-16))    /* Unused */ \
            | (0 << (20-16))    /* Available */ \
            | (0xf << (16-16))  /* Limit 19:16 */

#endif /* INIT_RM */
