/* $Id: dmi_data.S,v 1.1 2013-04-22 16:24:22 vrsieh Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#if 0

#ifdef CONFIG_DMI_SUPPORT
#ifdef RUNTIME_RM

	.section .rodata.table.dmi
	.align 16

	.byte '_', 'D', 'M', 'I', '_'
	.byte 0				/* Checksum */
	.word dmi_end - dmi_start	/* Length */
	.long dmi_start			/* Base Address of Tables */
	.word 1+1+1+2+1+1+4+2+7+3+4	/* Number of Entries in Table */
	.byte (2<<4)|(0<<0)		/* Version 2.0 */

	.section .rodata
dmi_start:

bios_info:
	.byte 0				/* Type: BIOS Information */
	.byte bios_info_end-bios_info
	.word 0x000			/* Handle */
	.byte 1				/* Vendor (String) */
	.byte 2				/* BIOS Version (String) */
	.word 0xe000			/* Start Segment of BIOS */
	.byte 3				/* BIOS Release Date (String) */
	.byte 1				/* BIOS ROM Size (64k*(1+1)) */
	.long 0 /* FIXME */
	.long 0 /* FIXME */
bios_info_end:
	.string "University Erlangen-Nuremberg"
	.string PACKAGE_VERSION
	.string "12/29/97"		/* FIXME */
	.byte 0

system_info:
	.byte 1				/* Type: System Information */
	.byte system_info_end-system_info
	.word 0x100			/* Handle */
	.byte 1				/* Manufacturer */
	.byte 2				/* Product Name */
	.byte 3				/* Version */
	.byte 4				/* Serial Number */
system_info_end:
	.string " "
	.string " "
	.string " "
	.string " "
	.byte 0

board_info:
	.byte 2				/* Type: Board Information */
	.byte board_info_end-board_info
	.word 0x200			/* Handle */
	.byte 1				/* Manufacturer */
	.byte 2				/* Product Name */
	.byte 3				/* Version */
	.byte 4				/* Serial Number */
board_info_end:
	.string "University Erlangen-Nuremberg"
	.string "i440LX-8661"
	.string " "
	.string " "
	.byte 0

chassis_info:
	.byte 3				/* Type: Chassis Information */
	.byte chassis_info_end-chassis_info
	.word 0x300			/* Handle */
	.byte 1				/* Manufacturer */
	.byte 2				/* Type (Unknown) */
	.byte 2				/* Version */
	.byte 3				/* Serial Number */
	.byte 4				/* Asset Tag Number */
chassis_info_end:
	.string " "
	.string " "
	.string " "
	.string " "
	.byte 0

cpu_info_0:
	.byte 4				/* Type: Processor Information */
	.byte cpu_info_0_end-cpu_info_0
	.word 0x400
	.byte 1				/* Socket Designation */
	.byte 3				/* Processor Type (Central Proc.) */
	.byte 0x31			/* Processor Family (?) */
	.byte 2				/* Processor Manufacturer */
	.long 0, 0			/* Processor ID (FIXME) */
	.byte 3				/* Processor Version */
	.byte (1<<1)			/* Voltage (3.3V) */
	.word 50			/* External Clock Freq. (50MHz) */
	.word 400			/* Max Clock Freq. (400MHz) */
	.word 250			/* Current Clock Freq. (250MHz) */
	.byte (1<<6)|(1<<0)		/* Status (Socket Populated/Enabled) */
	.byte 8				/* Processor Upgrade (?) */
cpu_info_0_end:
	.string "Slot 1"
	.string "Intel"
	.string "Pentium II"
	.byte 0

cpu_info_1:
	.byte 4				/* Type: Processor Information */
	.byte cpu_info_1_end-cpu_info_1
	.word 0x401
	.byte 1				/* Socket Designation */
	.byte 3				/* Processor Type (Central Proc.) */
	.byte 2				/* Processor Family (Unknown) */
	.byte 2				/* Processor Manufacturer */
	.long 0, 0			/* Processor ID (FIXME) */
	.byte 3				/* Processor Version */
	.byte (1<<1)			/* Voltage (3.3V) */
	.word 50			/* External Clock Freq. (50MHz) */
	.word 400			/* Max Clock Freq. (400MHz) */
	.word 250			/* Current Clock Freq. (250MHz) */
	.byte (1<<6)|(1<<0)		/* Status (Socket Populated/Enabled) */
	.byte 8				/* Processor Upgrade (?) */
cpu_info_1_end:
	.string "Slot 2"
	.string ""
	.string ""
	.byte 0

mem_controller_info:
	.byte 5				/* Type: Memory Controller */
	.byte mem_controller_info_end-mem_controller_info
	.word 0x500			/* Handle */
	.byte 4				/* Error Detection Method (8bit Par.) */
	.byte (1<<2)			/* Error Correcting Cap. (none) */
	.byte 3				/* Supported Interleave (One Way) */
	.byte 3				/* Current Interleave (One Way) */
	.byte 5				/* Max Memory Module Size (32MB) */
	.word (1<<3)|(1<<2)		/* Memory Speed (60ns/70ns) */
	.word (1<<9)|(1<<4)|(1<<3)|(1<<2) /* Mem Type (?/EDO/FastPage/Standard) */
	.byte (1<<0)			/* Memory Module Voltage (5.0V) */
	.byte 4				/* Number of Associated Memory Slots */
	.word 0x600			/* Handle of Memory 0 */
	.word 0x601			/* Handle of Memory 1 */
	.word 0x602			/* Handle of Memory 2 */
	.word 0x603			/* Handle of Memory 3 */
mem_controller_info_end:
	.byte 0, 0			/* Correct? FIXME */

mem_module_info_0:
	.byte 6				/* Type: Memory Module Information */
	.byte mem_module_info_0_end-mem_module_info_0
	.word 0x600			/* Handle */
	.byte 1				/* Socket Designation */
	.byte (0<<4)|(1<<0)		/* Bank Connections (RAS0/RAS1) */
	.byte 60			/* Current Speed (60ns) */
	.word (1<<8)|(1<<4)		/* Current Memory Type (DIMM/EDO) */
	.byte 7				/* Installed Size (128MB) */
	.byte 7				/* Enabled Size (128MB) */
	.byte 0				/* Error Status (No Error) */
mem_module_info_0_end:
	.string "MEM-0"
	.byte 0

mem_module_info_1:
	.byte 6				/* Type: Memory Module Information */
	.byte mem_module_info_1_end-mem_module_info_1
	.word 0x601			/* Handle */
	.byte 1				/* Socket Designation */
	.byte (2<<4)|(3<<0)		/* Bank Connections (RAS2/RAS3) */
	.byte 60			/* Current Speed (60ns) */
	.word (1<<8)|(1<<4)		/* Current Memory Type (DIMM/EDO) */
	.byte 7				/* Installed Size (128MB) */
	.byte 7				/* Enabled Size (128MB) */
	.byte 0				/* Error Status (No Error) */
mem_module_info_1_end:
	.string "MEM-1"
	.byte 0

mem_module_info_2:
	.byte 6				/* Type: Memory Module Information */
	.byte mem_module_info_2_end-mem_module_info_2
	.word 0x602			/* Handle */
	.byte 1				/* Socket Designation */
	.byte (4<<4)|(5<<0)		/* Bank Connections (RAS4/RAS5) */
	.byte 60			/* Current Speed (60ns) */
	.word (1<<8)|(1<<4)		/* Current Memory Type (DIMM/EDO) */
	.byte 7				/* Installed Size (128MB) */
	.byte 7				/* Enabled Size (128MB) */
	.byte 0				/* Error Status (No Error) */
mem_module_info_2_end:
	.string "MEM-2"
	.byte 0

mem_module_info_3:
	.byte 6				/* Type: Memory Module Information */
	.byte mem_module_info_3_end-mem_module_info_3
	.word 0x603			/* Handle */
	.byte 1				/* Socket Designation */
	.byte (6<<4)|(7<<0)		/* Bank Connections (RAS6/RAS7) */
	.byte 60			/* Current Speed (60ns) */
	.word (1<<8)|(1<<4)		/* Current Memory Type (DIMM/EDO) */
	.byte 7				/* Installed Size (128MB) */
	.byte 7				/* Enabled Size (128MB) */
	.byte 0				/* Error Status (No Error) */
mem_module_info_3_end:
	.string "MEM-3"
	.byte 0

cache_info_0:
	.byte 7				/* Type: Cache Info */
	.byte cache_info_0_end-cache_info_0
	.byte 0x700			/* Handle */
	.byte 1				/* Socket Designation */
	.word (1<<8)|(1<<7)|(0<<5)|(0<<3)|((1-1)<<0) /* Cache Config */
					/* (Write Back/Enabled/Internal/ */
					/* Not Socketed/Level 1) */
	.word (0<<15)|16		/* Max Cache Size (16KB) */
	.word (0<<15)|16		/* Installed Cache Size (16KB) */
	.word (1<<5)			/* Supported SRAM Type (Synchronous) */
	.word (1<<5)			/* Installed SRAM Type (Synchronous) */
cache_info_0_end:
	.string "Internal Cache"
	.byte 0

cache_info_1:
	.byte 7				/* Type: Cache Info */
	.byte cache_info_1_end-cache_info_1
	.byte 0x701			/* Handle */
	.byte 1				/* Socket Designation */
	.word (1<<8)|(1<<7)|(1<<5)|(0<<3)|((2-1)<<0) /* Cache Config */
					/* (Write Back/Enabled/External/ */
					/* Not Socketed/Level 2) */
	.word (0<<15)|512		/* Max Cache Size (512KB) */
	.word (0<<15)|512		/* Installed Cache Size (512KB) */
	.word (1<<5)			/* Supported SRAM Type (Synchronous) */
	.word (1<<5)			/* Installed SRAM Type (Synchronous) */
cache_info_1_end:
	.string "External Cache"
	.byte 0

conn_info_ide0:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_ide0_end-conn_info_ide0
	.word 0x800			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0x16			/* Internal Conn. Type (Int. IDE) */
	.byte 2				/* External Reference Designator */
	.byte 0				/* External Conn. Type (None) */
	.byte 0xff			/* Port Type (Other) */
conn_info_ide0_end:
	.string "PRIMARY IDE"
	.string " "
	.byte 0

conn_info_ide1:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_ide1_end-conn_info_ide1
	.word 0x801			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0x16			/* Internal Conn. Type (Int. IDE) */
	.byte 2				/* External Reference Designator */
	.byte 0				/* External Conn. Type (None) */
	.byte 0xff			/* Port Type (Other) */
conn_info_ide1_end:
	.string "SECONDARY IDE"
	.string " "
	.byte 0

conn_info_fdd:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_fdd_end-conn_info_fdd
	.word 0x802			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0x17			/* Internal Conn. Type (Int. FDD) */
	.byte 2				/* External Reference Designator */
	.byte 0x00			/* External Conn. Type (None) */
	.byte 0xa1			/* Port Type (8251 FIFO Comp.) */
conn_info_fdd_end:
	.string "FDD"
	.string " "
	.byte 0

conn_info_com1:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_com1_end-conn_info_com1
	.word 0x803			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0x18			/* Internal Conn. Type (9DIL) */
	.byte 2				/* External Reference Designator */
	.byte 0x08			/* External Conn. (DB9 pin male) */
	.byte 0xa1			/* Port Type (Serial 16540) */
conn_info_com1_end:
	.string "COM1"
	.string " "
	.byte 0

conn_info_com2:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_com2_end-conn_info_com2
	.word 0x804			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0x18			/* Internal Conn. Type (9DIL) */
	.byte 2				/* External Reference Designator */
	.byte 0x08			/* External Conn. (DB9 pin male) */
	.byte 0xa1			/* Port Type (Serial 16540) */
conn_info_com2_end:
	.string "COM2"
	.string " "
	.byte 0

conn_info_lpt1:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_lpt1_end-conn_info_lpt1
	.word 0x805			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0x05			/* Internal Conn. Type (DB25 female) */
	.byte 2				/* External Reference Designator */
	.byte 0x05			/* External Conn. Type (DB25 female) */
	.byte 0x05			/* Port Type (Parallel ECP/EPP) */
conn_info_lpt1_end:
	.string "LPT1"
	.string " "
	.byte 0

conn_info_keyboard:
	.byte 8				/* Type: Port Connector Information */
	.byte conn_info_keyboard_end-conn_info_keyboard
	.word 0x806			/* Handle */
	.byte 1				/* Internal Reference Designator */
	.byte 0xff			/* Internal Conn. Type (Other) */
	.byte 2				/* External Reference Designator */
	.byte 0x0f			/* External Conn. Type (PS/2) */
	.byte 0x0d			/* Port Type (Keyboard Port) */
conn_info_keyboard_end:
	.string "Keyboard"
	.string " "
	.byte 0

system_slot_info_isa0:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_isa0_end-system_slot_info_isa0
	.word 0x900
	.byte 1				/* Slot Designation */
	.byte 3				/* Slot Type (ISA) */
	.byte 4				/* Slot Data Bus Width (16bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 0				/* Slot ID (unused for ISA) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_isa0_end:
	.string "ISA-0"
	.byte 0

system_slot_info_isa1:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_isa1_end-system_slot_info_isa1
	.word 0x901
	.byte 1				/* Slot Designation */
	.byte 3				/* Slot Type (ISA) */
	.byte 4				/* Slot Data Bus Width (16bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 0				/* Slot ID (unused for ISA) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_isa1_end:
	.string "ISA-1"
	.byte 0

system_slot_info_isa2:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_isa2_end-system_slot_info_isa2
	.word 0x902
	.byte 1				/* Slot Designation */
	.byte 3				/* Slot Type (ISA) */
	.byte 4				/* Slot Data Bus Width (16bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 0				/* Slot ID (unused for ISA) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_isa2_end:
	.string "ISA-2"
	.byte 0

system_slot_info_pci0:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_pci0_end-system_slot_info_pci0
	.word 0x910
	.byte 1				/* Slot Designation */
	.byte 6				/* Slot Type (ISA) */
	.byte 5				/* Slot Data Bus Width (32bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 8				/* Slot ID (FIXME) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_pci0_end:
	.string "PCI-0"
	.byte 0

system_slot_info_pci1:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_pci1_end-system_slot_info_pci1
	.word 0x911
	.byte 1				/* Slot Designation */
	.byte 6				/* Slot Type (ISA) */
	.byte 5				/* Slot Data Bus Width (32bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 9				/* Slot ID (FIXME) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_pci1_end:
	.string "PCI-1"
	.byte 0

system_slot_info_pci2:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_pci2_end-system_slot_info_pci2
	.word 0x912
	.byte 1				/* Slot Designation */
	.byte 6				/* Slot Type (ISA) */
	.byte 5				/* Slot Data Bus Width (32bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 10			/* Slot ID (FIXME) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_pci2_end:
	.string "PCI-2"
	.byte 0

system_slot_info_pci3:
	.byte 9				/* Type: System Slot Information */
	.byte system_slot_info_pci3_end-system_slot_info_pci3
	.word 0x913
	.byte 1				/* Slot Designation */
	.byte 6				/* Slot Type (ISA) */
	.byte 5				/* Slot Data Bus Width (32bit) */
	.byte 2				/* Current Usage (unknown) */
	.byte 4				/* Slot Length (full length) */
	.word 11			/* Slot ID (FIXME) */
	.byte (1 << 1) 			/* Characteristic (5.0V) */
system_slot_info_pci3_end:
	.string "PCI-3"
	.byte 0

dmi_end:

#endif

#endif /* RUNTIME_RM */
#endif /* CONFIG_DMI_SUPPORT */
