/* $Id: list.c,v 1.2 2009-01-27 17:06:41 potyra Exp $ 
 *
 * Copyright (C) 2002-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef	LIST_H
#define	LIST_H

#define list_Foreach(list, iter)	for ((iter) = ((void *)(list)->first); iter; (iter) = (void *)(((struct list_node *)(iter))->succeder))
#define list_rForeach(list, iter)	for ((iter) = ((void *)(list)->last); iter; (iter) = (void *)(((struct list_node *)(iter))->preceder))
#define list_Remove(list, iter)		do { \
						struct list_node *my_list_node_to_remove = (struct list_node *)iter; \
						if (my_list_node_to_remove->preceder) { \
							my_list_node_to_remove->preceder->succeder = my_list_node_to_remove->succeder; \
						} else { \
							(list)->first = my_list_node_to_remove->succeder; \
						} \
						if (my_list_node_to_remove->succeder) { \
							my_list_node_to_remove->succeder->preceder = my_list_node_to_remove->preceder; \
						} else { \
							(list)->last = my_list_node_to_remove->preceder; \
						} \
						(list)->num--; \
					} while (0)
#define list_AddBefore(list, ref, node)	do { \
						struct list_node *my_internal_list_node_ref = (struct list_node *)(ref); \
						struct list_node *my_internal_list_node_new = (struct list_node *)(node); \
						if (my_internal_list_node_ref) { \
							my_internal_list_node_new->preceder = my_internal_list_node_ref->preceder; \
							my_internal_list_node_new->succeder = my_internal_list_node_ref; \
							if (my_internal_list_node_new->preceder) { \
								my_internal_list_node_new->preceder->succeder = my_internal_list_node_new; \
							} else { \
								(list)->first = my_internal_list_node_new; \
							} \
							my_internal_list_node_new->succeder->preceder = my_internal_list_node_new; \
							(list)->num++; \
						} else { \
							list_push(list, node); \
						} \
					} while (0)

struct list_node {
	struct list_node	*preceder, *succeder;
};

struct list_dnode {
	struct list_node	node;
	void *data;
};

struct list_data {
	struct list_node	node;
	void			*data;
};

struct list_header {
	struct list_node	*first, *last;
	int	num;
};

extern void list_init(struct list_header *);
extern struct list_header *list_new(void);
extern void list_free(struct list_header*);

extern int list_unshift(struct list_header *list, void *node);
extern void *list_shift(struct list_header *);
extern int list_push(struct list_header *list, void *node);
extern void *list_pop(struct list_header *);

extern struct list_dnode *list_new_dnode(struct list_header*, void *);
extern void list_remove_dnode(struct list_header *list, void *ref);
extern struct list_dnode *list_find_dnode(struct list_header *list, void *ref);

#endif
