/* $Id: list.c,v 1.2 2009-01-27 17:06:41 potyra Exp $ 
 *
 * Copyright (C) 2002-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include	"config.h"

#include	<assert.h>
#include	<stdio.h>

#include	"glue.h"

#include	"list.h"

void list_init(struct list_header *list)
{
	list->first = (void*)0;
	list->last = (void*)0;
	list->num = 0;
}

struct list_header *list_new(void)
{
	struct list_header	*list;

	list = MEM_NEW(struct list_header);
	list_init(list);
	return list;
}

void list_free(struct list_header *list)
{
	assert(list->num==0);
	MEM_FREE(list);
}

void *list_shift(struct list_header *list)
{
	struct list_node	*node;

	node=list->first;
	if(node) {
		list->first=node->succeder;
		if(node->succeder) {
			node->succeder->preceder=(void*)0;
		} else {
			list->last=(void*)0;
		}
		list->num--;
	}
	return node;
}

void *list_pop(struct list_header *list)
{
	struct list_node	*node;

	node=list->last;
	if(node) {
		if(node->preceder) {
			node->preceder->succeder=(void*)0;
		} else {
			list->first=(void*)0;
		}
		list->last=node->preceder;
		list->num--;
	}
	return node;
}

int list_push(struct list_header *list, void *data_node)
{
	struct list_node *node = data_node;
	node->preceder = list->last;
	node->succeder = (void*)0;
	if(list->last) {
		list->last->succeder = node;
	} else {
		list->first = node;
	}
	list->num++;
	list->last=node;
	return list->num;
}

int list_unshift(struct list_header *list, void *data_node)
{
	struct list_node *node=data_node;
	node->preceder = (void*)0;
	node->succeder = list->first;
	if(list->first) {
		list->first->preceder = node;
	} else {
		list->last = node;
	}
	list->num++;
	list->first = node;
	return list->num;
}

struct list_dnode *list_new_dnode(struct list_header *list, void *data)
{
	struct list_dnode *dnode;

	dnode=MEM_NEW(struct list_dnode);
	dnode->data=data;
	if(list) {
		list_push(list, dnode);
	}
	return dnode;
}

struct list_dnode *
list_find_dnode(struct list_header *list, void *ref)
{
	struct list_dnode *dnode;

	list_Foreach(list, dnode) {
		if (dnode->data == ref) return dnode;
	}
	return NULL;
}

void
list_remove_dnode(struct list_header *list, void *ref)
{
	struct list_dnode *dnode;

	dnode = list_find_dnode(list, ref);
	assert(dnode);
	list_Remove(list, dnode);
	MEM_FREE(dnode);
}
