/*
 * $Id: glue-trace.c,v 1.3 2013-03-07 11:33:20 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2013 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* #include <assert.h> */
#include <stdio.h>

#include "glue-trace.h"

struct log_buf log_buf[LOG_SIZE];
unsigned int log_count;

void
log_dump(void)
{
	unsigned int pos;
	unsigned int i;

	pos = log_count;
	for (i = 0; i < LOG_SIZE; i++) {
		pos &= LOG_SIZE - 1;
		if (i % 4 == 0) {
			fprintf(stderr, "%6d:", i);
		}
		fprintf(stderr, " %s:%d (%lx,%lx)", log_buf[pos].file, log_buf[pos].line, log_buf[pos].p0, log_buf[pos].p1);
		if (i % 4 == 3) {
			fprintf(stderr, "\n");
		}
		pos++;
	}
}
