/* $Id: glue-suspend.c,v 1.3 2012-02-27 13:45:41 siflkres Exp $ 
 *
 * Copyright (C) 2007-2011 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <sys/types.h>
#include <sys/wait.h>
#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "system.h"

#include "glue-suspend.h"

#ifndef PATTERN_TEST
void
sim_suspend_do(void)
{
	system_suspend();
}

void
sim_resume_do(void)
{
	system_resume();
}
#endif

void
generic_suspend(void *_cpssp, size_t size, FILE *fHandle)
{
	if (!_cpssp) {
		fprintf(stderr, "Warning: data pointer is NULL... omitting\n");
		return;
	}
	
	if (fwrite(_cpssp, size, 1, fHandle) != 1) {
		fprintf(stderr, "fwrite error\n");
	}
}

void
generic_resume(void *_cpssp, size_t size, FILE *fHandle)
{
	if (!_cpssp) {
		fprintf(stderr, "Warning: data pointer is NULL... omitting\n");
		return;
	}
	if (fread(_cpssp, size, 1, fHandle) != 1) {
		fprintf(stderr, "fread error\n");
	}
}
