/* $Id: glue-spinlock.h,v 1.2 2013-02-07 11:42:56 vrsieh Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_SPINLOCK_H_INCLUDED
#define __GLUE_SPINLOCK_H_INCLUDED

#include "config.h"
#include <stdint.h>

struct spinlock
{
    volatile uint8_t lock;
};
typedef struct spinlock spinlock_t;

static inline void __attribute__((__always_inline__))
init_spinlock(spinlock_t *lock)
{
	lock->lock = 0;
}

static inline int __attribute__((__always_inline__))
try_spinlock(spinlock_t *lock)
{
	return __sync_lock_test_and_set(&lock->lock, 1) == 0;
}

static inline void __attribute__((__always_inline__))
lock_spinlock(spinlock_t *lock)
{
	for (;;) {
		if (lock->lock == 0) {
			if (__sync_lock_test_and_set(&lock->lock, 1) == 0) {
				break;
			}
		}
	}
	/* Lock is now locked for us */
}

static inline void __attribute__((__always_inline__))
unlock_spinlock(spinlock_t *lock)
{
	__sync_lock_release(&lock->lock);
}

#endif
