/* $Id: glue-main.h,v 1.38 2013-02-19 11:21:22 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_MAIN_H_INCLUDED
#define __GLUE_MAIN_H_INCLUDED

#define TIME_HZ		(1ULL << 32)
#define TIME_INTERVAL	(TIME_HZ / 1024)

/* Set this to 1 to activate pThreads */
#define USE_PTHREAD	0

#include <inttypes.h>
#include <stdio.h>

/* FIXME:
 * This is needed because all modules that use processes include glue-main.h
 * instead of glue-scheduler.h at the moment.
 */
#include "glue-scheduler.h"
#include "glue-spinlock.h"

struct schedules {
	struct schedules *prev;
	struct schedules *next;

	unsigned long long time;
	void (*func)(void *);
	void *data;
};

extern const char *progname;
extern const char *basedir;
extern int loglevel;
extern int slave;

extern int failure;

/** Get real time.
 *  @return real time in TIME_HZ ticks.
 */
extern unsigned long long
time_real(void);

/** Get virtual time.
 *  @return virtual time in TIME_HZ ticks.
 */
extern unsigned long long
time_virt(void);

/** Stop time.
 *  Used while simulation is stalled/continued.
 */
extern void
time_stop(void);

/** Continue time.
 *  Used while simulation is stalled/continued.
 */
extern void
time_cont(void);

/** Register a timer to call func with parameter data as soon as the
 *  real time tsc is reached.
 *  @param tsc real timestamp counter, 1 second == 1 * TIME_HZ.
 *  @param func callback that will be called.
 *  @param data parameter to the callback.
 */
extern void
time_real_event_add(unsigned long long tsc, void (*func)(void *data), void *data);

/** delete a registered timer from time_real_event_add.
 *  @param func callback that would have been called.
 *  @param data data that would have been the argument (must match
 *         data from time_call_at/time_call_after).
 *  @return 0 for success, 1 if the timer was not found.
 */
extern int
time_real_event_del(void (*func)(void *), void *data);

/** Register a timer to call func with parameter data as soon as the
 *  simulation time tsc is reached.
 *  @param tsc virtual timestamp counter, 1 second == 1 * TIME_HZ.
 *  @param func callback that will be called.
 *  @param data parameter to the callback.
 */
extern void
time_call_at(unsigned long long tsc, void (*func)(void *data), void *data);

/** Register a timer to call func with parameter data after interval delay
 *  has passed (simulation time).
 *  @param delay delay before func gets called, 1 second == 1 * TIME_HZ.
 *  @param func callback that will be called.
 *  @param data paramter to the callback.
 */
extern void
time_call_after(unsigned long long delay, void (*func)(void *data), void *data);

/** delete a registered timer from time_call_at/time_call_after.
 *  @param func callback that would have been called.
 *  @param data data that would have been the argument (must match
 *         data from time_call_at/time_call_after).
 *  @return 0 for success, 1 if the timer was not found.
 */
extern int
time_call_delete(void (*func)(void *), void *data);

extern void
time_advance(struct process **proc_list, int proc_count);

/** Stop simulation node.
 */
extern void
sim_exit(void);

extern void
sim_stop(void);
extern void
sim_cont(void);

extern void
sim_suspend(void);
extern void
sim_resume(void);

extern void
sim_suspendresume(void);

extern void
clear_schedules(void);

extern void
suspend_schedules(FILE *fSched);

extern void
resume_schedules(FILE *fSched);

#endif /* __GLUE_MAIN_H_INCLUDED */
