/*
 * $Id: glue-gui.c,v 1.14 2009-10-29 16:18:21 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "config.h"

#include "glue-log.h"
#include "glue-gui.h"

#ifdef HAVE_GTK
#include "glue-gui-gtk.h"
#endif

#include "simsetup.h"

enum gui_kind selected_gui = GUI_UNSET;

static const char *locale;

/* the following functions are called even before gui_create */
void
gui_usage(void)
{
	fprintf(stderr, "\t-g <gui>: set the gui to use to one of\n");
#ifdef HAVE_GTK
	fprintf(stderr, "\t          gtk:  GTK2-based gui\n");
#endif
	fprintf(stderr, "\t          null: don't do any gui output\n");
	fprintf(stderr, "\t-k <keymap>: set the key translation map to <keymap>\n");
}

int
gui_handle_args(int *argcp, char ***argvp)
{
        int i;
        char **current_arg;
	const char *gui = getenv("FAUM_GUI");

	locale = "en-us";

        /* check for -k keymap */
        i = *argcp;
        for (current_arg = *argvp; i && strcmp(*current_arg, "-k"); current_arg++) {
                i--;
        }

        if (i && strcmp(*current_arg, "-k") == 0 && *argcp > i) {
                /* remember locale */
                locale = current_arg[1];

                /* remove -k keymap from argument list */
                while (current_arg[2]) {
                        current_arg[0] = current_arg[2];
                        current_arg++;
                }
                current_arg[0] = NULL;
                *argcp -= 2;
        }

        /* check for -g gui */
        i = *argcp;
        for (current_arg = *argvp; i && strcmp(*current_arg, "-g"); current_arg++) {
                i--;
        }

        if (i && strcmp(*current_arg, "-g") == 0 && *argcp > i) {
                /* remember gui */
                gui = current_arg[1];

                /* remove -g gui from argument list */
                while (current_arg[2]) {
                        current_arg[0] = current_arg[2];
                        current_arg++;
                }
                current_arg[0] = NULL;
                *argcp -= 2;
        }

	/* check which gui was selected */

	if (gui == NULL) {
#ifdef HAVE_GTK
		gui = "gtk";
#else
		gui = "null";
#endif
	}

#ifdef HAVE_GTK
	if (strcmp("gtk", gui) == 0) {
		selected_gui = GUI_GTK;
		gtk_parse_args(argcp, argvp);

	} else
#endif
	if (strcmp("null", gui) == 0) {
		selected_gui = GUI_NULL;

	} else {
		faum_log(FAUM_LOG_ERROR, "", "",
				"Unknown gui \"%s\".\n", gui);
		assert(0);
	}

	return 0;
}

void
gui_handle_simsetup(void)
{
	if (simsetup.gui == NULL) {
		return;
	}

	if (strcmp(simsetup.gui, "gtk") == 0) {
		selected_gui = GUI_GTK;
	} else if (strcmp(simsetup.gui, "null") == 0) {
		selected_gui = GUI_NULL;
	}
}

const char *
gui_locale(void)
{
	return locale;
}

/* the main interface */

void
gui_page_add(unsigned int page_id, const char *name)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		gui_gtk_page_add(page_id, name);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
gui_init(void)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		gui_gtk_init();
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
gui_exit(void)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		gui_gtk_exit();
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
gui_create(void)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		gui_gtk_create();
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
gui_destroy(void)
{
}
