/* $Id: glue-gui-gtk.h,v 1.30 2009-05-25 09:27:57 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_GUI_GTK_H_INCLUDED
#define __GLUE_GUI_GTK_H_INCLUDED

#include <inttypes.h>

#include <gtk/gtk.h>

extern void
gui_gtk_comp_add(
	unsigned int page,
	const char *comp_type,
	const char *comp_name,
	GtkWidget *main,
	int expand,
	int fill,
	GtkWidget *fi
);

extern void
gui_gtk_flush(void);

extern void
gui_gtk_page_add(unsigned int page_id, const char *name);

extern void
gui_gtk_create(void);
extern void
gui_gtk_destroy(void);

extern void
gui_gtk_init(void);
extern void
gui_gtk_exit(void);

extern gboolean
key_press_event(GtkWidget *widget, GdkEventKey *key_event, gpointer user_data);
extern gboolean
key_release_event(GtkWidget *widget, GdkEventKey *key_event, gpointer user_data);
extern gboolean
pointer_motion_event(GtkWidget *widget, GdkEventMotion *event, gpointer user_data);
extern gboolean
pointer_press_event(GtkWidget *widget, GdkEventButton *event, gpointer user_data);
extern gboolean
pointer_scroll_event(GtkWidget *widget, GdkEventScroll *event, gpointer user_data);

#endif /* __GLUE_GUI_GTK_H_INCLUDED */
