/*
 * $Id: glue-gui-gtk-media-gen-floppy-create.c,v 1.1 2009-10-16 06:15:32 vrsieh Exp $
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"

static GtkWidget *cont_blank;
static GtkWidget *cont_image;
static GtkWidget *image_frame;
static GtkWidget *file_image;
static GtkWidget *media_name;

static void
cont_callback(GtkWidget *w, gpointer dummy)
{
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_blank))) {
		gtk_widget_hide(image_frame);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_image))) {
		gtk_widget_show(image_frame);
	} else {
		assert(0); /* Cannot happen. */
	}
}

GtkWidget *
gui_gtk_media_gen_floppy_create_new(void)
{
	GtkWidget *v;
	GtkWidget *v2;
	GtkWidget *h;
	GtkWidget *f;

	v = gtk_vbox_new(FALSE, 1);

	h = gtk_hbox_new(FALSE, 1);

	f = gtk_frame_new("Contents");

	v2 = gtk_vbox_new(FALSE, 1);

	cont_blank = gtk_radio_button_new_with_label(NULL, "Empty");
	g_signal_connect(G_OBJECT(cont_blank), "toggled",
			G_CALLBACK(cont_callback), NULL);
	gtk_widget_show(cont_blank);
	gtk_box_pack_start(GTK_BOX(v2), cont_blank, FALSE, FALSE, 1);

	cont_image = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(cont_blank), "Image");
	g_signal_connect(G_OBJECT(cont_image), "toggled",
			G_CALLBACK(cont_callback), NULL);
	gtk_widget_show(cont_image);
	gtk_box_pack_start(GTK_BOX(v2), cont_image, FALSE, FALSE, 1);

	gtk_widget_show(v2);
	gtk_container_add(GTK_CONTAINER(f), v2);

	gtk_widget_show(f);
	gtk_box_pack_start(GTK_BOX(h), f, TRUE, TRUE, 1);

	gtk_widget_show(h);
	gtk_box_pack_start(GTK_BOX(v), h, FALSE, FALSE, 1);

	image_frame = gtk_frame_new("Image");

	file_image = gtk_file_chooser_widget_new(GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_widget_show(file_image);
	gtk_container_add(GTK_CONTAINER(image_frame), file_image);

	gtk_widget_show(image_frame);
	gtk_box_pack_start(GTK_BOX(v), image_frame, TRUE, TRUE, 1);

	h = gtk_frame_new("Media Name");

	media_name = gtk_entry_new();
	gtk_widget_show(media_name);
	gtk_container_add(GTK_CONTAINER(h), media_name);

	gtk_widget_show(h);
	gtk_box_pack_start(GTK_BOX(v), h, FALSE, FALSE, 1);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cont_image), TRUE);

	return v;
}

static void
on_create_create_floppy_dialog(GtkWidget *w, gpointer _dialog)
{
        GtkWidget *dialog = (GtkWidget *) _dialog;
	const char *name;
	char *image;
	char signame[1024];
	char compname[1024];
	int manage_id;
	int sig_id;
	int page_id;
	int comp_id;

	/* name */
	name = gtk_entry_get_text(GTK_ENTRY(media_name));

	/* image */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_image))) {
		image = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(file_image));
	} else {
		image = NULL;
	}

	strcpy(signame, ":");
	strcat(signame, name);
	strcat(signame, "_port");
	strcpy(compname, ":");
	strcat(compname, name);

	manage_id = system_sig_create("manage", compname);
	assert(0 <= manage_id);
	sig_id = system_sig_create("floppy", signame);
	assert(0 <= sig_id);
	page_id = system_page_lookup("default");
	assert(0 <= page_id);
	comp_id = system_comp_create("media_gen_floppy", compname, 0, page_id);
	assert(0 <= comp_id); /* FIXME */
	system_comp_generic_set(comp_id, "integer", "size", "2880");
	system_comp_generic_set(comp_id, "string", "image", image);
	system_comp_port_connect(comp_id, "manage", manage_id);
	system_comp_port_connect(comp_id, "connect", sig_id);
	system_comp_init(comp_id);

	g_free(image);

	gtk_widget_hide(dialog);
}

static void
on_close_create_floppy_dialog(GtkWidget *w, gpointer _dialog)
{
        GtkWidget *dialog = (GtkWidget *) _dialog;

	gtk_widget_hide(dialog);
}

GtkWidget *
gui_gtk_media_gen_floppy_create_dialog_new(void)
{
	GtkWidget *dialog;
	GtkWidget *cont;
	GtkWidget *button;

	dialog = gtk_dialog_new();
	g_signal_connect((gpointer) dialog, "delete-event",
			G_CALLBACK(on_close_create_floppy_dialog), dialog);

	cont = gui_gtk_media_gen_floppy_create_new();
	gtk_widget_show(cont);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), cont,
			TRUE, TRUE, 1);

	button = gtk_button_new_with_label("Create");
	g_signal_connect((gpointer) button, "clicked",
			G_CALLBACK(on_create_create_floppy_dialog), dialog);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button,
			FALSE, FALSE, 1);

	button = gtk_button_new_with_label("Cancel");
	g_signal_connect((gpointer) button, "clicked",
			G_CALLBACK(on_close_create_floppy_dialog), dialog);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button,
			FALSE, FALSE, 1);

	return dialog;
}
