/*
 * $Id: glue-gui-gtk-media-gen-cd-create.c,v 1.17 2009-10-13 07:30:36 vrsieh Exp $
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include <gtk/gtk.h>

#include "system.h"

static GtkWidget *type_cd_rom;
static GtkWidget *type_cd_r;
static GtkWidget *type_cd_rw;
static GtkWidget *size_21;
static GtkWidget *size_70;
static GtkWidget *size_80;
static GtkWidget *size_90;
static GtkWidget *cont_blank;
static GtkWidget *cont_iso;
static GtkWidget *cont_cue;
static GtkWidget *iso_image_frame;
static GtkWidget *iso_image;
static GtkWidget *cue_sheet_frame;
static GtkWidget *cue_sheet;
static GtkWidget *media_name;

static void
cont_callback(GtkWidget *w, gpointer dummy)
{
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_blank))) {
		gtk_widget_hide(iso_image_frame);
		gtk_widget_hide(cue_sheet_frame);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_iso))) {
		gtk_widget_show(iso_image_frame);
		gtk_widget_hide(cue_sheet_frame);
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_cue))) {
		gtk_widget_hide(iso_image_frame);
		gtk_widget_show(cue_sheet_frame);
	} else {
		assert(0); /* Cannot happen. */
	}
}

GtkWidget *
gui_gtk_media_gen_cd_create_new(void)
{
	GtkWidget *v;
	GtkWidget *v2;
	GtkWidget *h;
	GtkWidget *f;

	v = gtk_vbox_new(FALSE, 1);

	h = gtk_hbox_new(FALSE, 1);

	f = gtk_frame_new("Type");

	v2 = gtk_vbox_new(FALSE, 1);

	type_cd_rom = gtk_radio_button_new_with_label(NULL, "CD-ROM");
	gtk_widget_show(type_cd_rom);
	gtk_box_pack_start(GTK_BOX(v2), type_cd_rom, FALSE, FALSE, 1);

	type_cd_r = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(type_cd_rom), "CD-R");
	gtk_widget_show(type_cd_r);
	gtk_box_pack_start(GTK_BOX(v2), type_cd_r, FALSE, FALSE, 1);

	type_cd_rw = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(type_cd_rom), "CD-RW");
	gtk_widget_show(type_cd_rw);
	gtk_box_pack_start(GTK_BOX(v2), type_cd_rw, FALSE, FALSE, 1);

	gtk_widget_show(v2);
	gtk_container_add(GTK_CONTAINER(f), v2);

	gtk_widget_show(f);
	gtk_box_pack_start(GTK_BOX(h), f, TRUE, TRUE, 1);

	f = gtk_frame_new("Size");

	v2 = gtk_vbox_new(FALSE, 1);

	size_21 = gtk_radio_button_new_with_label(NULL, "21min/184MB");
	gtk_widget_show(size_21);
	gtk_box_pack_start(GTK_BOX(v2), size_21, FALSE, FALSE, 1);

	size_70 = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(size_21), "70min/615MB");
	gtk_widget_show(size_70);
	gtk_box_pack_start(GTK_BOX(v2), size_70, FALSE, FALSE, 1);

	size_80 = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(size_21), "80min/703MB");
	gtk_widget_show(size_80);
	gtk_box_pack_start(GTK_BOX(v2), size_80, FALSE, FALSE, 1);

	size_90 = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(size_21), "90min/791MB");
	gtk_widget_show(size_90);
	gtk_box_pack_start(GTK_BOX(v2), size_90, FALSE, FALSE, 1);

	gtk_widget_show(v2);
	gtk_container_add(GTK_CONTAINER(f), v2);

	gtk_widget_show(f);
	gtk_box_pack_start(GTK_BOX(h), f, TRUE, TRUE, 1);

	f = gtk_frame_new("Contents");

	v2 = gtk_vbox_new(FALSE, 1);

	cont_blank = gtk_radio_button_new_with_label(NULL, "Empty");
	g_signal_connect(G_OBJECT(cont_blank), "toggled",
			G_CALLBACK(cont_callback), NULL);
	gtk_widget_show(cont_blank);
	gtk_box_pack_start(GTK_BOX(v2), cont_blank, FALSE, FALSE, 1);

	cont_iso = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(cont_blank), "ISO-Image");
	g_signal_connect(G_OBJECT(cont_iso), "toggled",
			G_CALLBACK(cont_callback), NULL);
	gtk_widget_show(cont_iso);
	gtk_box_pack_start(GTK_BOX(v2), cont_iso, FALSE, FALSE, 1);

	cont_cue = gtk_radio_button_new_with_label_from_widget(
			GTK_RADIO_BUTTON(cont_blank), "CUE-Sheet");
	g_signal_connect(G_OBJECT(cont_cue), "toggled",
			G_CALLBACK(cont_callback), NULL);
	gtk_widget_show(cont_cue);
	gtk_box_pack_start(GTK_BOX(v2), cont_cue, FALSE, FALSE, 1);

	gtk_widget_show(v2);
	gtk_container_add(GTK_CONTAINER(f), v2);

	gtk_widget_show(f);
	gtk_box_pack_start(GTK_BOX(h), f, TRUE, TRUE, 1);

	gtk_widget_show(h);
	gtk_box_pack_start(GTK_BOX(v), h, FALSE, FALSE, 1);

	iso_image_frame = gtk_frame_new("ISO Image");

	iso_image = gtk_file_chooser_widget_new(GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_widget_show(iso_image);
	gtk_container_add(GTK_CONTAINER(iso_image_frame), iso_image);

	gtk_widget_show(iso_image_frame);
	gtk_box_pack_start(GTK_BOX(v), iso_image_frame, TRUE, TRUE, 1);

	cue_sheet_frame = gtk_frame_new("CUE Sheet");

	cue_sheet = gtk_file_chooser_widget_new(GTK_FILE_CHOOSER_ACTION_OPEN);
	gtk_widget_show(cue_sheet);
	gtk_container_add(GTK_CONTAINER(cue_sheet_frame), cue_sheet);

	gtk_widget_show(cue_sheet_frame);
	gtk_box_pack_start(GTK_BOX(v), cue_sheet_frame, TRUE, TRUE, 1);

	h = gtk_frame_new("Media Name");

	media_name = gtk_entry_new();
	gtk_widget_show(media_name);
	gtk_container_add(GTK_CONTAINER(h), media_name);

	gtk_widget_show(h);
	gtk_box_pack_start(GTK_BOX(v), h, FALSE, FALSE, 1);

	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(type_cd_rom), TRUE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(size_80), TRUE);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(cont_iso), TRUE);

	return v;
}

static void
on_create_create_cd_dialog(GtkWidget *w, gpointer _dialog)
{
        GtkWidget *dialog = (GtkWidget *) _dialog;
	const char *name;
	const char *media;
	const char *size;
	char *iso;
	char *cue;
	char signame[1024];
	char compname[1024];
	int manage_id;
	int sig_id;
	int page_id;
	int comp_id;

	/* name */
	name = gtk_entry_get_text(GTK_ENTRY(media_name));

	/* media */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(type_cd_rom))) {
		media = "CD-ROM";
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(type_cd_r))) {
		media = "CD-R";
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(type_cd_rw))) {
		media = "CD-RW";
	} else {
		assert(0); /* Mustn't happen. */
	}

	/* size */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(size_21))) {
		size = "94500"; /* 21 * 60 * 75 */
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(size_70))) {
		size = "315000"; /* 70 * 60 * 75 */
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(size_80))) {
		size = "360000"; /* 80 * 60 * 75 */
	} else if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(size_90))) {
		size = "405000"; /* 90 * 60 * 75 */
	} else {
		assert(0); /* Mustn't happen. */
	}

	/* iso */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_iso))) {
		iso = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(iso_image));
	} else {
		iso = NULL;
	}

	/* cue */
	if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(cont_cue))) {
		cue = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(cue_sheet));
	} else {
		cue = NULL;
	}

	strcpy(signame, ":");
	strcat(signame, name);
	strcat(signame, "_port");
	strcpy(compname, ":");
	strcat(compname, name);

	manage_id = system_sig_create("manage", compname);
	assert(0 <= manage_id);
	sig_id = system_sig_create("magneto_optical", signame);
	assert(0 <= sig_id);
	page_id = system_page_lookup("default");
	assert(0 <= page_id);
	comp_id = system_comp_create("media_gen_cd", compname, 0, page_id);
	assert(0 <= comp_id); /* FIXME */
	system_comp_generic_set(comp_id, "string", "media", media);
	system_comp_generic_set(comp_id, "integer", "size", size);
	system_comp_generic_set(comp_id, "string", "iso", iso);
	system_comp_generic_set(comp_id, "string", "cue", cue);
	system_comp_port_connect(comp_id, "manage", manage_id);
	system_comp_port_connect(comp_id, "connect", sig_id);
	system_comp_init(comp_id);

	g_free(cue);
	g_free(iso);

	gtk_widget_hide(dialog);
}

static void
on_close_create_cd_dialog(GtkWidget *w, gpointer _dialog)
{
        GtkWidget *dialog = (GtkWidget *) _dialog;

	gtk_widget_hide(dialog);
}

GtkWidget *
gui_gtk_media_gen_cd_create_dialog_new(void)
{
	GtkWidget *dialog;
	GtkWidget *cont;
	GtkWidget *button;

	dialog = gtk_dialog_new();
	g_signal_connect((gpointer) dialog, "delete-event",
			G_CALLBACK(on_close_create_cd_dialog), dialog);

	cont = gui_gtk_media_gen_cd_create_new();
	gtk_widget_show(cont);

	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), cont,
			TRUE, TRUE, 1);

	button = gtk_button_new_with_label("Create");
	g_signal_connect((gpointer) button, "clicked",
			G_CALLBACK(on_create_create_cd_dialog), dialog);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button,
			FALSE, FALSE, 1);

	button = gtk_button_new_with_label("Cancel");
	g_signal_connect((gpointer) button, "clicked",
			G_CALLBACK(on_close_create_cd_dialog), dialog);
	gtk_widget_show(button);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area), button,
			FALSE, FALSE, 1);

	return dialog;
}
