/*
 * $Id: glue-aui-gen.c,v 1.3 2013-05-11 17:14:04 vrsieh Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue-audio.h"

#include "glue-aui-gen.h"

/* FIXME */
#define SIG_SOUND_PROCESS_FREQ  100
#define SIG_SOUND_RATE          44100

static int16_t left[SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ];
static unsigned int left_count;
static int16_t middle[SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ];
static unsigned int middle_count;
static int16_t right[SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ];
static unsigned int right_count;

AuiGenChannel *
aui_gen_channel_new(const char *type)
{
	if (strcmp(type, "left") == 0) {
		return (AuiGenChannel *) left;
	} else if (strcmp(type, "middle") == 0) {
		return (AuiGenChannel *) middle;
	} else { assert(strcmp(type, "right") == 0);
		return (AuiGenChannel *) right;
	}
}

void
aui_gen_channel_play(AuiGenChannel *channel, int16_t *samples)
{
	if (channel == (AuiGenChannel *) left) {
		assert(left_count == 0);
		memcpy(left, samples, sizeof(left));
		left_count = sizeof(left) / sizeof(left[0]);
	} else if (channel == (AuiGenChannel *) middle) {
		assert(middle_count == 0);
		memcpy(middle, samples, sizeof(middle));
		middle_count = sizeof(middle) / sizeof(middle[0]);
	} else { assert(channel == (AuiGenChannel *) right);
		assert(right_count == 0);
		memcpy(right, samples, sizeof(right));
		right_count = sizeof(right) / sizeof(right[0]);
	}
	if (0 < left_count
	 && 0 < right_count) {
		int16_t buf[SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ * 2];
		int i;

		for (i = 0; i < SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ; i++) {
			buf[i * 2 + 0] = left[i];
			buf[i * 2 + 1] = right[i];
		}
		audio_play(buf);

		left_count = 0;
		right_count = 0;
	}
	if (0 < middle_count) {
		int16_t buf[SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ * 2];
		int i;

		for (i = 0; i < SIG_SOUND_RATE / SIG_SOUND_PROCESS_FREQ; i++) {
			buf[i * 2 + 0] = middle[i];
			buf[i * 2 + 1] = middle[i];
		}

		audio_play(buf);

		middle_count = 0;
	}
}
