/* $Id$ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_AUDIO_DRIVER_H
#define __GLUE_AUDIO_DRIVER_H

typedef struct ao_info_s
{
        const char *name;
        const char *short_name;
        const char *author;
        const char *comment;
} ao_info_t;

/* interface towards glue-audio.c */
typedef struct ao_functions_s
{
	ao_info_t *info;
        int   (*init)      (void);
        void  (*uninit)    (int immed);
        int   (*play)      (void* data,int len);
        int   (*get_space) (void);
        float (*get_delay) (void);
} ao_functions_t;

#endif /* __GLUE_AUDIO_DRIVER_H */
