/* $Id$ 
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <stdio.h>
#include <stdlib.h>

#include "fixme.h"

int __faum_fixme_dummy = 0;

void
__faum_fixme(const char *file, unsigned int line, const char *function)
{
	fprintf(stderr, "%s:%d: %s: FIXME\n", file, line, function);

	/*
	 * Use strange "if" below to fool gcc.
	 * Otherwise gcc will complain that
	 * __faum_fixme should have noreturn attribute.
	 */
	if (! __faum_fixme_dummy) {
		abort();
	}
}
