--
-- $Id: test_bench.vhdl,v 1.4 2012-11-30 14:08:08 vrsieh Exp $
--
-- Copyright (C) 2012 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ls_change : cstring;
	signal ls_drive : magneto_optical;
	signal ls_media0 : magneto_optical;
	signal ls_media1 : magneto_optical;
begin
	system : zuse23_system
		port map (
			ls_change => ls_change,
			ls_media => ls_drive
		);
	grundprogramm : media_gen_lochstreifen
		generic map (
			size => 80395,
			image => "vorstreifen+grundprogramm.ls"
		)
		port map (
			connect => ls_media0
		);
	test : media_gen_lochstreifen
		generic map (
			size => 100000,
			image => "test.ls"
		)
		port map (
			connect => ls_media1
		);
end structural;
