/* $Id: setup_comp.S,v 1.6 2009-05-21 15:45:38 potyra Exp $
 *
 * Setup the keyboard controller (connected to irq1) so that it produces
 * interrupts.
 *
 * Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

.text

/* keyboard controller is irq1
 * io: 0x0060, 0x0064
 */

wait_controller_ready0:
	/* fetch status */
	inb $0x0064, %al
	andb $0x01, %al
	jz wait_controller_ready0
	ret

.globl setup_controller
setup_controller:
	/* setup for read mode */
	movb $0x20, %al
	outb %al, $0x0064

	call wait_controller_ready0

	/* read old mode into al */
	inb $0x0060, %al

	/* setup for write mode (and save old mode in ah) */
	movb %al, %ah
	movb $0x60, %al
	outb %al, $0x0064

wait_controller_ready1:
	/* fetch status */
	inb $0x0064, %al
	andb $0x01, %al
	jnz wait_controller_ready1

	/* enable interrupts */
	orb $0x01, %ah
	movb %ah, %al
	outb %al, $0x0060

	call wait_controller_ready0

	/* all done */
	movl $str_ready, %edx
	call libs_puts

	ret

.globl release_comp_irq
release_comp_irq:
	/* FIXME that's quite wrong, but will do for now */
	pusha
	call wait_controller_ready0
	inb $0x0060, %al
	call libs_printc
	call wait_controller_ready0
	popa
	ret

.data
str_ready:
	.ascii "Keyboard controller programmed.\0"
