-- $Id: ton_count_v12.vhd,v 1.1 2010-02-12 18:06:09 potyra Exp $
-- vim:tabstop=2:
--
-- Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


-- J.STELZNER
-- IMMD3 LABOR
-- 11.02.2010
-- File: TON_COUNT_V11.VHD

library ieee ;
use ieee.std_logic_1164.all ;
use ieee.std_logic_unsigned.all;

entity TON_COUNT_V12 is

	port
	(
	TON_IN_0	:in		std_logic;
	TON_IN_1	:in		std_logic;
	TON_IN_2	:in		std_logic;
	TON_IN_3	:in		std_logic;
	TON_IN_4	:in		std_logic;
	TON_IN_5	:in		std_logic;
	TON_IN_6	:in		std_logic;
	TON_IN_7	:in		std_logic;
	TON_IN_8	:in		std_logic;
	TON_IN_9	:in		std_logic;
	TON_IN_10	:in		std_logic;
	TON_IN_11	:in		std_logic;
	TON_IN_12	:in		std_logic;
	TON_IN_13	:in		std_logic;
	TON_IN_14	:in		std_logic;
	TON_IN_15	:in		std_logic;
	PCI_CLOCK	:in		std_logic;
	RSTn			:in		std_logic;
	RC_TIME_0	:out	std_logic;
	RC_TIME_1	:out	std_logic;
	RC_TIME_2	:out	std_logic;
	RC_TIME_3	:out	std_logic;
	VOLUME_0	:out	std_logic;
	VOLUME_1	:out	std_logic;
	VOLUME_2	:out	std_logic;
	VOLUME_3	:out	std_logic;	
	TON_OUT		:out	std_logic
	);

end entity TON_COUNT_V12 ;


--RC_TIME(0) = 0.5 ms
--RC_TIME(1) = 1.0 ms 
--RC_TIME(2) = 2.0 ms
--RC_TIME(3) = 4.0 ms

-- c  264 Hz
------------33
-- d  297 Hz
------------33
-- e  330 Hz
------------22
-- f  352 Hz
------------44
-- g  396 Hz
------------44
-- a  440 Hz
------------55
-- h  495 Hz
------------33
-- c' 528 Hz

-- c_0	132,0	Hz	7,575757 ms		ist	132		
-- d_0	148,5	Hz	6,734006 ms		ist	148,381	
-- e_0	165,0	Hz	6,060606 ms		ist 165
-- f_0	176,0	Hz  5,681818 ms		ist	175,906
-- g_0	198,0	Hz  5,050505 ms		ist 197,841 
-- a_0	220,0	Hz  4,545454 ms		ist 220	 
-- h_0	247,5	Hz	4,040404 ms		ist	247,747
-- c_x	264,0 Hz	3,787878 ms		ist	264,423		

-- c_1	264,0	Hz	3,787878 ms 
-- d_1	297,0	Hz	3,367003 ms	
-- e_1	330,0	Hz	3,030303 ms	
-- f_1	352,0	Hz	2,840909 ms	
-- g_1	396,0	Hz	2,525252 ms
-- a_1	440,0	Hz	2,272727 ms	
-- h_1	495,0	Hz	2,020202 ms

-- c_2	528,0	Hz	1,893939 ms
-- d_2	594,0	Hz	1,683501 ms
-- e_2	660,0	Hz	1,515151 ms
-- f_2	704,0	Hz	1,420454 ms
-- g_2	792,0	Hz	1,262626 ms
-- a_2	880,0	Hz	1,136363 ms
-- h_2	990,0	Hz	1,010101 ms

-- c_3 1056,0	Hz	0,946960 ms		
-- d_3 1188,0	Hz	0,841750 ms	
-- e_3 1320,0	Hz	0,757575 ms
-- f_3 1408,0	Hz	0,710227 ms	
-- g_3 1584,0	Hz	0,631313 ms
-- a_3 1760,0	Hz	0,568181 ms
-- h_3 1980,0	Hz	0,505050 ms


--33 MHz : 200 =  165 KHz	6,060606 us 
--33 MHz : 100 =  330 KHz	3,030303 us
--33 MHz :  50 =  660 KHz	1,515151 us
--33 MHz :  25 = 1320 KHz	0,757575 us


architecture TON_COUNT_V12_DESIGN of TON_COUNT_V12 is

	signal		SIG_CNT_OKT					:integer range 0 to 255;
	signal		SIG_CNT_OKT_RESET		:std_logic;
	signal		SIG_CNT_OKT_SELECT	:std_logic_vector (1 downto 0);	

	signal		SIG_CNT_TON					:integer range 0 to 1023;
	signal		SIG_CNT_TON_RESET		:std_logic;
	signal		SIG_CNT_TON_SELECT	:std_logic_vector (2 downto 0);	

	signal		SIG_TON_OUT					:std_logic;	

	signal		SIG_1_2_TON					:std_logic;	

	signal		SIG_TON_ON					:std_logic;	

	signal		SIG_GENERATOR_ON		:std_logic;	

	signal		RESET								:std_logic;	

	signal		TON_IN							:std_logic_vector (15 downto 0);		
	signal		RC_TIME							:std_logic_vector (3 downto 0);
	signal		VOLUME							:std_logic_vector (3 downto 0);


	constant	TEILER_C	:integer	:=	625 -	2;
	constant	TEILER_D	:integer	:=	556 -	2;
	constant	TEILER_E	:integer	:= 	500	-	2;
	constant	TEILER_F	:integer	:=  469	-	2;
	constant	TEILER_G	:integer	:= 	417	-	2; 
	constant	TEILER_A	:integer	:= 	375	-	2;
	constant	TEILER_H	:integer	:=	333	-	2;  
	constant	TEILER_Cx	:integer	:=	313	-	2;  


	constant	OKT_3			:integer 	:=	 25	-	2;--Fmax
	constant	OKT_2			:integer 	:=	 50	-	2;
	constant	OKT_1			:integer 	:=	100	-	2;
	constant	OKT_0			:integer 	:=	200	-	2;--Fmin 

begin


	RESET	<=	not RSTn;

	SIG_GENERATOR_ON	<=	TON_IN(7);


	TON_IN	<=	TON_IN_15 & TON_IN_14 & TON_IN_13 & TON_IN_12 & TON_IN_11 & TON_IN_10 & TON_IN_9 & TON_IN_8 &  	
							TON_IN_7  & TON_IN_6  & TON_IN_5  & TON_IN_4  & TON_IN_3  & TON_IN_2  & TON_IN_1 & TON_IN_0; 



	

	process (PCI_CLOCK)
	begin
		if (PCI_CLOCK'event and PCI_CLOCK = '1') then

			if	RESET	=	'1'	then

				SIG_CNT_TON_SELECT	<=	"000";	--TON_IN(2 downto 0);	
				SIG_1_2_TON					<=	'0';		--TON_IN(3);
				SIG_CNT_OKT_SELECT	<=	"00";		--TON_IN(5 downto 4);	
				SIG_TON_ON					<=	'0';		--TON_IN(6);

			elsif	SIG_CNT_TON_RESET	= '1'	then
  
				SIG_CNT_TON_SELECT	<=	TON_IN(2 downto 0);	
				SIG_1_2_TON					<=	TON_IN(3);
				SIG_CNT_OKT_SELECT	<=	TON_IN(5 downto 4);	
				SIG_TON_ON					<=	TON_IN(6);
			
			end if;

		end if;
	end process;


--*******************************************************************
--***                       SIG_CNT_OKT                    ****
--*******************************************************************

--Teiler 200; 100; 50; 25

	process (PCI_CLOCK)
	begin
		if (PCI_CLOCK'event and PCI_CLOCK = '1') then

			if		RESET							=	'1'	then	SIG_CNT_OKT	<=	0;
			elsif	SIG_CNT_OKT_RESET = '1'	then	SIG_CNT_OKT	<=	0;			
			elsif	SIG_GENERATOR_ON	= '0'	then	SIG_CNT_OKT	<=	0;
			else																SIG_CNT_OKT	<=	(SIG_CNT_OKT	+	1) mod 256;
			end if;

		end if;
	end process;

	process (PCI_CLOCK)
	begin
		if (PCI_CLOCK'event and PCI_CLOCK = '1') then

			if		SIG_CNT_OKT_SELECT	=	"11"	then	

				if 		SIG_CNT_OKT				=	OKT_3 then	SIG_CNT_OKT_RESET	<=	'1';--Fmax
				else																	SIG_CNT_OKT_RESET	<=	'0';				
				end if;	
		
			elsif	SIG_CNT_OKT_SELECT	=	"10" then

				if 		SIG_CNT_OKT				=	OKT_2 then	SIG_CNT_OKT_RESET	<=	'1';
				else																	SIG_CNT_OKT_RESET	<=	'0';				
				end if;	

			elsif	SIG_CNT_OKT_SELECT	=	"01" then

				if 		SIG_CNT_OKT				=	OKT_1 then	SIG_CNT_OKT_RESET	<=	'1';
				else																	SIG_CNT_OKT_RESET	<=	'0';				
				end if;	
	
			elsif	SIG_CNT_OKT_SELECT	=	"00" then

				if 		SIG_CNT_OKT				=	OKT_0 then	SIG_CNT_OKT_RESET	<=	'1';--Fmin
				else																	SIG_CNT_OKT_RESET	<=	'0';				
				end if;

			end if;
		end if;
	end process;

--*******************************************************************
--***                    SIG_CNT_TON	                           ****
--*******************************************************************

	process (PCI_CLOCK)
	begin
		if (PCI_CLOCK'event and PCI_CLOCK = '1') then

			if			RESET							=	'1'	then	SIG_CNT_TON	<=	0;

			elsif		SIG_CNT_OKT_RESET = '1'	then	

				if		SIG_CNT_TON_RESET = '1' then	SIG_CNT_TON	<=	0;
				elsif	SIG_CNT_TON_RESET = '0' then	SIG_CNT_TON	<= (SIG_CNT_TON + 1) mod 1024;
				end if;

			end if;
		end if;
	end process;

	process (PCI_CLOCK)
	begin
		if (PCI_CLOCK'event and PCI_CLOCK = '1') then

			if	SIG_CNT_OKT_RESET	= '1'	then	 

				if			SIG_CNT_TON_SELECT	=	"000"			then

					if		SIG_CNT_TON					=	TEILER_C	then	SIG_CNT_TON_RESET	<=	'1';--Fmin
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;	

				elsif		SIG_CNT_TON_SELECT	=	"001"			then	

					if		SIG_CNT_TON					=	TEILER_D	then	SIG_CNT_TON_RESET	<=	'1';
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;	
		
				elsif		SIG_CNT_TON_SELECT	=	"010"			then	

					if		SIG_CNT_TON					=	TEILER_E	then	SIG_CNT_TON_RESET	<=	'1';
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;			

				elsif		SIG_CNT_TON_SELECT	=	"011"			then	

					if		SIG_CNT_TON					=	TEILER_F	then	SIG_CNT_TON_RESET	<=	'1';
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;			

				elsif		SIG_CNT_TON_SELECT	=	"100"			then	
	
					if		SIG_CNT_TON					=	TEILER_G	then	SIG_CNT_TON_RESET	<=	'1';
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;			

				elsif		SIG_CNT_TON_SELECT	=	"101"			then	

					if		SIG_CNT_TON					=	TEILER_A	then	SIG_CNT_TON_RESET	<=	'1';
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;			

				elsif		SIG_CNT_TON_SELECT	=	"110"			then	

					if		SIG_CNT_TON					=	TEILER_H	then	SIG_CNT_TON_RESET	<=	'1';
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;			

				elsif		SIG_CNT_TON_SELECT	=	"111"			then	

					if		SIG_CNT_TON					=	TEILER_H	then	SIG_CNT_TON_RESET	<=	'1';--Fmax
					else																				SIG_CNT_TON_RESET	<=	'0';				
					end if;					

				end if;
			end if;			
		end if;
	end process;


--*******************************************************************
--***                    TON_OUT    	                           ****
--*******************************************************************

	process (PCI_CLOCK)
	begin
		if (PCI_CLOCK'event and PCI_CLOCK = '1') then

			if		RESET							=	'1'	then	SIG_TON_OUT	<=	'0';

			elsif	SIG_CNT_OKT_RESET		= '1'	and
						SIG_TON_ON					=	'1'	then 
 
				if	SIG_CNT_TON_RESET		=	'1'	then	SIG_TON_OUT	<=	not SIG_TON_OUT;
				else																SIG_TON_OUT	<=			SIG_TON_OUT;
				end if;

			end if;
		end if;
	end process;


	process (TON_IN(9 downto 8))
	begin

		if		TON_IN(9 downto 8)	=	"00" then	VOLUME	<=	"0ZZZ";--Vmin 
		elsif	TON_IN(9 downto 8)	=	"01" then	VOLUME	<=	"Z0ZZ";--		  
		elsif	TON_IN(9 downto 8)	=	"10" then	VOLUME	<=	"ZZ0Z";--     	
		elsif	TON_IN(9 downto 8)	=	"11" then	VOLUME	<=	"ZZZ0";--Vmax 

	end if;
	end process;

	VOLUME_3	<=	VOLUME(3);	
	VOLUME_2	<=	VOLUME(2);
	VOLUME_1	<=	VOLUME(1);	
	VOLUME_0	<=	VOLUME(0);




	process (TON_IN(5 downto 4))
	begin

		if		TON_IN(5 downto 4)	=	"00" then	RC_TIME	<=	"0ZZZ";--Fmin 
		elsif	TON_IN(5 downto 4)	=	"01" then	RC_TIME	<=	"Z0ZZ";--		  
		elsif	TON_IN(5 downto 4)	=	"10" then	RC_TIME	<=	"ZZ0Z";--     	
		elsif	TON_IN(5 downto 4)	=	"11" then	RC_TIME	<=	"ZZZ0";--Fmax 

	end if;
	end process;


	RC_TIME_3	<=	RC_TIME(3);
	RC_TIME_2	<=	RC_TIME(2);	
	RC_TIME_1	<=	RC_TIME(1);
	RC_TIME_0	<=	RC_TIME(0);	


	TON_OUT		<=	SIG_TON_OUT;	

 end architecture TON_COUNT_V12_DESIGN;
