-- $Id: pcicard.vhdl,v 1.136 2010-02-19 20:03:30 potyra Exp $
--
-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.


library ieee;
use ieee.std_logic_1164.all;
ENTITY pcicard IS
	PORT (
		irdy_n	: IN std_logic;
		cbe_n_0 : IN std_logic;
		cbe_n_1 : IN std_logic;
		cbe_n_2 : IN std_logic;
		cbe_n_3 : IN std_logic;
		ad_0 : INOUT std_logic;
		ad_1 : INOUT std_logic;
		ad_2 : INOUT std_logic;
		ad_3 : INOUT std_logic;
		ad_4 : INOUT std_logic;
		ad_5 : INOUT std_logic;
		ad_6 : INOUT std_logic;
		ad_7 : INOUT std_logic;
		ad_8 : INOUT std_logic;
		ad_9 : INOUT std_logic;
		ad_10 : INOUT std_logic;
		ad_11 : INOUT std_logic;
		ad_12 : INOUT std_logic;
		ad_13 : INOUT std_logic;
		ad_14 : INOUT std_logic;
		ad_15 : INOUT std_logic;
		ad_16 : INOUT std_logic;
		ad_17 : INOUT std_logic;
		ad_18 : INOUT std_logic;
		ad_19 : INOUT std_logic;
		ad_20 : INOUT std_logic;
		ad_21 : INOUT std_logic;
		ad_22 : INOUT std_logic;
		ad_23 : INOUT std_logic;
		ad_24 : INOUT std_logic;
		ad_25 : INOUT std_logic;
		ad_26 : INOUT std_logic;
		ad_27 : INOUT std_logic;
		ad_28 : INOUT std_logic;
		ad_29 : INOUT std_logic;
		ad_30 : INOUT std_logic;
		ad_31 : INOUT std_logic;
		par : OUT std_logic;
		frame_n : IN std_logic;
		trdy_n : OUT std_logic;
		devsel_n : OUT std_logic;
		idsel : IN std_logic;
		clk : IN std_logic;
		rst_n : IN std_logic;
		reg_out_xx0_0 : out std_logic;
		reg_out_xx0_1 : out std_logic;
		reg_out_xx0_2 : out std_logic;
		reg_out_xx0_3 : out std_logic;
		reg_out_xx0_4 : out std_logic;
		reg_out_xx0_5 : out std_logic;
		reg_out_xx0_6 : out std_logic;
		reg_out_xx0_7 : out std_logic;
		reg_out_xx1_0 : out std_logic;
		reg_out_xx1_1 : out std_logic;
		reg_out_xx1_2 : out std_logic;
		reg_out_xx1_3 : out std_logic;
		reg_out_xx1_4 : out std_logic;
		reg_out_xx1_5 : out std_logic;
		reg_out_xx1_6 : out std_logic;
		reg_out_xx1_7 : out std_logic
	);
END ENTITY;

ARCHITECTURE pcicard_impl of pcicard is
	signal reg_bus_data : std_logic_vector(31 downto 0);
	signal bus_data_wr : std_logic_vector(31 downto 0);
	signal bus_command : std_logic_vector(3 downto 0);

	signal is_cycle_start : std_logic;

	signal reg_frame_n : std_logic;
	signal reg_reg_frame_n : std_logic;
	signal reg_idsel : std_logic;

	signal reg_parity : std_logic;

	-- configuration space address register (10h)
	-- 0: hardwired to 1 (io)
	-- 1: hardwired to 0 (must be 0 for io)
	-- 2-3: hardwired to 0 (want 4 io ports)
	signal conf_addr : std_logic_vector(31 downto 4);
	-- status / command (04h), bit 0
	-- (others: hardwired to 0)
	signal conf_status_io : std_logic;

	-- set to 1 if data from bus_data should get put on the bus.
	signal write_data_to_bus : std_logic;

	signal conf_sel_00 : std_logic;
	signal conf_sel_04 : std_logic;
	signal conf_sel_08 : std_logic;
	signal conf_sel_0c : std_logic;
	signal conf_sel_10 : std_logic;

	signal conf_sel_04_reg : std_logic;
	signal conf_sel_10_reg : std_logic;

	signal io_sel_00 : std_logic;
	signal io_sel_00_reg : std_logic;

	signal parity_0 : std_logic;
	signal parity_1 : std_logic;
	signal parity_2 : std_logic;
	signal parity_3 : std_logic;
	signal parity_4 : std_logic;
	signal parity_5 : std_logic;
	signal parity_6 : std_logic;
	signal parity_7 : std_logic;
	signal parity_8 : std_logic;
	signal parity_9 : std_logic;
	signal parity_10 : std_logic;

	signal match_addr_0 : std_logic;
	signal match_addr_1 : std_logic;
	signal match_addr_2 : std_logic;
	signal match_addr_3 : std_logic;
	signal match_addr_4 : std_logic;
	signal match_addr_5 : std_logic;
	signal match_addr_6 : std_logic;
	signal match_addr_7 : std_logic;

	signal IO_READ : std_logic;
	signal IO_WRITE : std_logic;
	signal CONF_READ : std_logic;
	signal CONF_WRITE : std_logic;

	attribute SYN_KEEP : integer;
	attribute SYN_KEEP of 	parity_8,
				parity_9,
				parity_10 : signal is 1;
	
	attribute OPT : string;
	attribute OPT of 	parity_8,
				parity_9,
				parity_10 : signal is "KEEP";

	-- COMM_FSM process
	constant ST_IDLE_COMM : std_logic_vector(3 downto 0) := "0000";
	constant ST_CONF_WRITE : std_logic_vector(3 downto 0) := "0001";
	constant ST_IO_WRITE : std_logic_vector(3 downto 0) := "0010";
	constant ST_CONF_READ : std_logic_vector(3 downto 0) := "0100";
	constant ST_IO_READ : std_logic_vector(3 downto 0) := "1000";

	signal COMM_STATE : std_logic_vector(3 downto 0);

	attribute syn_state_machine : boolean;
	attribute syn_state_machine of COMM_STATE : signal is false;

	-- CONT_FSM
	constant ST_IDLE : std_logic_vector(9 downto 0) :=      "0100111000";
	constant ST_READ_1 : std_logic_vector(9 downto 0) :=    "0100110011";
	constant ST_READ_2 : std_logic_vector(9 downto 0) :=    "0100000111";
	constant ST_READ_3 : std_logic_vector (9 downto 0) :=   "0100111111";
	constant ST_RD_FIFO_1 : std_logic_vector(9 downto 0) := "0000110011";
	constant ST_RD_FIFO_2 : std_logic_vector(9 downto 0) := "1000110011";
	constant ST_WRITE_1 : std_logic_vector(9 downto 0) :=   "0111110010";
	constant ST_WRITE_2 : std_logic_vector(9 downto 0) :=   "0110000010";
	constant ST_WRITE_3 : std_logic_vector(9 downto 0) :=   "0110111010";

	signal CONTROL_STATE : std_logic_vector(9 downto 0);
	attribute syn_state_machine of CONTROL_STATE : signal is false;

	-- FIXME needs cleanup
	constant FIFO_READ : std_logic := '0';

	-- mapping
	-- COMM_DEC.START = is_cycle_start
	-- CONTROL_STATE(2) -> OE_PCI_PAR
	-- READ_SEL(1) -> pci_ad_oe

	signal io_reg_xx0_0 : std_logic;
	signal io_reg_xx0_1 : std_logic;
	signal io_reg_xx0_2 : std_logic;
	signal io_reg_xx0_3 : std_logic;
	signal io_reg_xx0_4 : std_logic;
	signal io_reg_xx0_5 : std_logic;
	signal io_reg_xx0_6 : std_logic;
	signal io_reg_xx0_7 : std_logic;

	signal io_reg_xx1_0 : std_logic;
	signal io_reg_xx1_1 : std_logic;
	signal io_reg_xx1_2 : std_logic;
	signal io_reg_xx1_3 : std_logic;
	signal io_reg_xx1_4 : std_logic;
	signal io_reg_xx1_5 : std_logic;
	signal io_reg_xx1_6 : std_logic;
	signal io_reg_xx1_7 : std_logic;

	-- FIXME config space 06:
	-- base: 04h, sub: 01h, if: 00h

BEGIN
	match_addr_0 <= '1' 
			when reg_bus_data(31) = conf_addr(31) 
				and reg_bus_data(30) = conf_addr(30)
				and reg_bus_data(29) = conf_addr(29)
				and reg_bus_data(28) = conf_addr(28) 
			else '0';

	match_addr_1 <= '1' 
			when reg_bus_data(27) = conf_addr(27)
				and reg_bus_data(26) = conf_addr(26)
				and reg_bus_data(25) = conf_addr(25)
				and reg_bus_data(24) = conf_addr(24)
			else '0';
	
	match_addr_2 <= '1'
			when reg_bus_data(23) = conf_addr(23)
				and reg_bus_data(22) = conf_addr(22)
				and reg_bus_data(21) = conf_addr(21)
				and reg_bus_data(20) = conf_addr(20)
			else '0';

	match_addr_3 <= '1'
			when reg_bus_data(19) = conf_addr(19)
				and reg_bus_data(18) = conf_addr(18)
				and reg_bus_data(17) = conf_addr(17)
				and reg_bus_data(16) = conf_addr(16)
			else '0';

	match_addr_4 <= '1'
			when reg_bus_data(15) = conf_addr(15)
				and reg_bus_data(14) = conf_addr(14)
				and reg_bus_data(13) = conf_addr(13)
				and reg_bus_data(12) = conf_addr(12)
			else '0';

	match_addr_5 <= '1' 
			when reg_bus_data(11) = conf_addr(11)
				and reg_bus_data(10) = conf_addr(10)
				and reg_bus_data(9) = conf_addr(9)
				and reg_bus_data(8) = conf_addr(8)
			else '0';

	match_addr_6 <= '1'
			when reg_bus_data(7) = conf_addr(7)
				and reg_bus_data(6) = conf_addr(6)
				and reg_bus_data(5) = conf_addr(5)
				and reg_bus_data(4) = conf_addr(4)
			else '0';

	match_addr_7 <= match_addr_6 
			and match_addr_5
			and match_addr_4
			and match_addr_3
			and match_addr_2
			and match_addr_1
			and match_addr_0;

	conf_access_write_04 : process(clk, rst_n)
	begin
		if rst_n = '0' then
			conf_status_io <= '0';
		elsif clk = '1' and clk'event then
			if (conf_sel_04_reg and COMM_STATE(0)) = '1' then

				if bus_command(0) = '0' then
					conf_status_io <= reg_bus_data(0);
				end if;
				-- discard others (FIXME?)
			end if;
		end if;
	end process;

	conf_access_write_10 : process(clk, rst_n)
	begin
		if rst_n = '0' then
			for i in conf_addr'range loop
				conf_addr(i) <= '0';
			end loop;
		elsif clk = '1' and clk'event then
			if (conf_sel_10_reg and COMM_STATE(0)) = '1' then
				if bus_command(0) = '0' then
					-- conf space 10 (config address)
					conf_addr(4) <= reg_bus_data(4);
					conf_addr(5) <= reg_bus_data(5);
					conf_addr(6) <= reg_bus_data(6);
					conf_addr(7) <= reg_bus_data(7);
				end if;

				if bus_command(1) = '0' then
					conf_addr(8) <= reg_bus_data(8);
					conf_addr(9) <= reg_bus_data(9);
					conf_addr(10) <= reg_bus_data(10);
					conf_addr(11) <= reg_bus_data(11);
					conf_addr(12) <= reg_bus_data(12);
					conf_addr(13) <= reg_bus_data(13);
					conf_addr(14) <= reg_bus_data(14);
					conf_addr(15) <= reg_bus_data(15);
				end if;
				if bus_command(2) = '0' then
					conf_addr(16) <= reg_bus_data(16);
					conf_addr(17) <= reg_bus_data(17);
					conf_addr(18) <= reg_bus_data(18);
					conf_addr(19) <= reg_bus_data(19);
					conf_addr(20) <= reg_bus_data(20);
					conf_addr(21) <= reg_bus_data(21);
					conf_addr(22) <= reg_bus_data(22);
					conf_addr(23) <= reg_bus_data(23);
				end if;

				if bus_command(3) = '0' then
					conf_addr(24) <= reg_bus_data(24);
					conf_addr(25) <= reg_bus_data(25);
					conf_addr(26) <= reg_bus_data(26);
					conf_addr(27) <= reg_bus_data(27);
					conf_addr(28) <= reg_bus_data(28);
					conf_addr(29) <= reg_bus_data(29);
					conf_addr(30) <= reg_bus_data(30);
					conf_addr(31) <= reg_bus_data(31);
				end if;
			end if;
		end if;
	end process;

	io_write_xx0 : process(clk, rst_n)
	begin
		if rst_n = '0' then
			io_reg_xx0_0 <= '0';
			io_reg_xx0_1 <= '0';
			io_reg_xx0_2 <= '0';
			io_reg_xx0_3 <= '0';
			io_reg_xx0_4 <= '0';
			io_reg_xx0_5 <= '0';
			io_reg_xx0_6 <= '0';
			io_reg_xx0_7 <= '0';

			io_reg_xx1_0 <= '0';
			io_reg_xx1_1 <= '0';
			io_reg_xx1_2 <= '0';
			io_reg_xx1_3 <= '0';
			io_reg_xx1_4 <= '0';
			io_reg_xx1_5 <= '0';
			io_reg_xx1_6 <= '0';
			io_reg_xx1_7 <= '0';

		elsif clk = '1' and clk'event then
			if (io_sel_00_reg and COMM_STATE(1)) = '1' then
				if bus_command(0) = '0' then
					io_reg_xx0_0 <= reg_bus_data(0);
					io_reg_xx0_1 <= reg_bus_data(1);
					io_reg_xx0_2 <= reg_bus_data(2);
					io_reg_xx0_3 <= reg_bus_data(3);
					io_reg_xx0_4 <= reg_bus_data(4);
					io_reg_xx0_5 <= reg_bus_data(5);
					io_reg_xx0_6 <= reg_bus_data(6);
					io_reg_xx0_7 <= reg_bus_data(7);
				end if;

				if bus_command(1) = '0' then
					io_reg_xx1_0 <= reg_bus_data(8);
					io_reg_xx1_1 <= reg_bus_data(9);
					io_reg_xx1_2 <= reg_bus_data(10);
					io_reg_xx1_3 <= reg_bus_data(11);
					io_reg_xx1_4 <= reg_bus_data(12);
					io_reg_xx1_5 <= reg_bus_data(13);
					io_reg_xx1_6 <= reg_bus_data(14);
					io_reg_xx1_7 <= reg_bus_data(15);
				end if;
			end if;
		end if;
	end process;


	bus_write_mux : process(clk)
	begin
		
		if clk = '1' and clk'event then
			-- type 0, function 0
			if (conf_sel_00	and CONF_READ) = '1' then
				-- decode configuration space address

				-- 00h -> device / vendor
				bus_data_wr(0) <= '1';
				bus_data_wr(1) <= '1';
				bus_data_wr(2) <= '1';
				bus_data_wr(3) <= '1';

				bus_data_wr(4) <= '0';
				bus_data_wr(5) <= '1';
				bus_data_wr(6) <= '0';
				bus_data_wr(7) <= '1';

				bus_data_wr(8) <= '0';
				bus_data_wr(9) <= '1';
				bus_data_wr(10) <= '1';
				bus_data_wr(11) <= '1';

				bus_data_wr(12) <= '1';
				bus_data_wr(13) <= '1';
				bus_data_wr(14) <= '0';
				bus_data_wr(15) <= '1';

				bus_data_wr(16) <= '1';
				bus_data_wr(17) <= '0';
				bus_data_wr(18) <= '1';
				bus_data_wr(19) <= '1';

				bus_data_wr(20) <= '0';
				bus_data_wr(21) <= '1';
				bus_data_wr(22) <= '0';
				bus_data_wr(23) <= '1';

				bus_data_wr(24) <= '0';
				bus_data_wr(25) <= '1';
				bus_data_wr(26) <= '1';
				bus_data_wr(27) <= '1';

				bus_data_wr(28) <= '1';
				bus_data_wr(29) <= '0';
				bus_data_wr(30) <= '1';
				bus_data_wr(31) <= '1';

			elsif (conf_sel_04 and CONF_READ) = '1' then
				-- 04h -> status / command
				bus_data_wr(0) <= conf_status_io;
				bus_data_wr(1) <= '0';
				bus_data_wr(2) <= '0';
				bus_data_wr(3) <= '0';
				bus_data_wr(4) <= '0';
				bus_data_wr(5) <= '0';
				bus_data_wr(6) <= '0';
				bus_data_wr(7) <= '0';
				bus_data_wr(8) <= '0';
				bus_data_wr(9) <= '0';
				bus_data_wr(10) <= '0';
				bus_data_wr(11) <= '0';
				bus_data_wr(12) <= '0';
				bus_data_wr(13) <= '0';
				bus_data_wr(14) <= '0';
				bus_data_wr(15) <= '0';
				bus_data_wr(16) <= '0';
				bus_data_wr(17) <= '0';
				bus_data_wr(18) <= '0';
				bus_data_wr(19) <= '0';
				bus_data_wr(20) <= '0';
				bus_data_wr(21) <= '0';
				bus_data_wr(22) <= '0';
				bus_data_wr(23) <= '0';
				bus_data_wr(24) <= '0';
				bus_data_wr(25) <= '1';
				bus_data_wr(26) <= '0';
				bus_data_wr(27) <= '0';
				bus_data_wr(28) <= '0';
				bus_data_wr(29) <= '0';
				bus_data_wr(30) <= '0';
				bus_data_wr(31) <= '0';

			elsif (conf_sel_08 and CONF_READ) = '1' then
				-- 08 -> revision id, class code

				-- revision id
				bus_data_wr(0) <= '0';
				bus_data_wr(1) <= '0';
				bus_data_wr(2) <= '0';
				bus_data_wr(3) <= '0';
				bus_data_wr(4) <= '0';
				bus_data_wr(5) <= '0';
				bus_data_wr(6) <= '0';
				bus_data_wr(7) <= '0';

				-- class code: 04 01 00 (multimedia/audio)
				bus_data_wr(8) <= '0';
				bus_data_wr(9) <= '0';
				bus_data_wr(10) <= '0';
				bus_data_wr(11) <= '0';
				bus_data_wr(12) <= '0';
				bus_data_wr(13) <= '0';
				bus_data_wr(14) <= '0';
				bus_data_wr(15) <= '0';

				bus_data_wr(16) <= '1';
				bus_data_wr(17) <= '0';
				bus_data_wr(18) <= '0';
				bus_data_wr(19) <= '0';
				bus_data_wr(20) <= '0';
				bus_data_wr(21) <= '0';
				bus_data_wr(22) <= '0';
				bus_data_wr(23) <= '0';

				bus_data_wr(24) <= '0';
				bus_data_wr(25) <= '0';
				bus_data_wr(26) <= '1';
				bus_data_wr(27) <= '0';
				bus_data_wr(28) <= '0';
				bus_data_wr(29) <= '0';
				bus_data_wr(30) <= '0';
				bus_data_wr(31) <= '0';

			elsif (conf_sel_0c and CONF_READ) = '1' then
				-- 0c -> cache line size, latency timer, header
				--       type and builtin self test. 
				-- Hardwired to ground.

				bus_data_wr(0) <= '0';
				bus_data_wr(1) <= '0';
				bus_data_wr(2) <= '0';
				bus_data_wr(3) <= '0';
				bus_data_wr(4) <= '0';
				bus_data_wr(5) <= '0';
				bus_data_wr(6) <= '0';
				bus_data_wr(7) <= '0';
				bus_data_wr(8) <= '0';
				bus_data_wr(9) <= '0';
				bus_data_wr(10) <= '0';
				bus_data_wr(11) <= '0';
				bus_data_wr(12) <= '0';
				bus_data_wr(13) <= '0';
				bus_data_wr(14) <= '0';
				bus_data_wr(15) <= '0';
				bus_data_wr(16) <= '0';
				bus_data_wr(17) <= '0';
				bus_data_wr(18) <= '0';
				bus_data_wr(19) <= '0';
				bus_data_wr(20) <= '0';
				bus_data_wr(21) <= '0';
				bus_data_wr(22) <= '0';
				bus_data_wr(23) <= '0';
				bus_data_wr(24) <= '0';
				bus_data_wr(25) <= '0';
				bus_data_wr(26) <= '0';
				bus_data_wr(27) <= '0';
				bus_data_wr(28) <= '0';
				bus_data_wr(29) <= '0';
				bus_data_wr(30) <= '0';
				bus_data_wr(31) <= '0';

			elsif (conf_sel_10 and CONF_READ) = '1' then
				-- 10h -> base address 0
				bus_data_wr(0) <= '1'; -- hardwired io
				bus_data_wr(1) <= '0'; -- hardwired io
				-- want 16 ports 
				bus_data_wr(2) <= '0'; 
				bus_data_wr(3) <= '0';

				bus_data_wr(4) <= conf_addr(4);
				bus_data_wr(5) <= conf_addr(5);
				bus_data_wr(6) <= conf_addr(6);
				bus_data_wr(7) <= conf_addr(7);
				bus_data_wr(8) <= conf_addr(8);
				bus_data_wr(9) <= conf_addr(9);
				bus_data_wr(10) <= conf_addr(10);
				bus_data_wr(11) <= conf_addr(11);
				bus_data_wr(12) <= conf_addr(12);
				bus_data_wr(13) <= conf_addr(13);
				bus_data_wr(14) <= conf_addr(14);
				bus_data_wr(15) <= conf_addr(15);
				bus_data_wr(16) <= conf_addr(16);
				bus_data_wr(17) <= conf_addr(17);
				bus_data_wr(18) <= conf_addr(18);
				bus_data_wr(19) <= conf_addr(19);
				bus_data_wr(20) <= conf_addr(20);
				bus_data_wr(21) <= conf_addr(21);
				bus_data_wr(22) <= conf_addr(22);
				bus_data_wr(23) <= conf_addr(23);
				bus_data_wr(24) <= conf_addr(24);
				bus_data_wr(25) <= conf_addr(25);
				bus_data_wr(26) <= conf_addr(26);
				bus_data_wr(27) <= conf_addr(27);
				bus_data_wr(28) <= conf_addr(28);
				bus_data_wr(29) <= conf_addr(29);
				bus_data_wr(30) <= conf_addr(30);
				bus_data_wr(31) <= conf_addr(31);

			elsif (io_sel_00 and IO_READ) = '1' then
				bus_data_wr(0) <= io_reg_xx0_0;
				bus_data_wr(1) <= io_reg_xx0_1;
				bus_data_wr(2) <= io_reg_xx0_2;
				bus_data_wr(3) <= io_reg_xx0_3;
				bus_data_wr(4) <= io_reg_xx0_4;
				bus_data_wr(5) <= io_reg_xx0_5;
				bus_data_wr(6) <= io_reg_xx0_6;
				bus_data_wr(7) <= io_reg_xx0_7;
				bus_data_wr(8) <= io_reg_xx1_0;
				bus_data_wr(9) <= io_reg_xx1_1;
				bus_data_wr(10) <= io_reg_xx1_2;
				bus_data_wr(11) <= io_reg_xx1_3;
				bus_data_wr(12) <= io_reg_xx1_4;
				bus_data_wr(13) <= io_reg_xx1_5;
				bus_data_wr(14) <= io_reg_xx1_6;
				bus_data_wr(15) <= io_reg_xx1_7;

				bus_data_wr(16) <= '0';
				bus_data_wr(17) <= '0';
				bus_data_wr(18) <= '0';
				bus_data_wr(19) <= '0';
				bus_data_wr(20) <= '0';
				bus_data_wr(21) <= '0';
				bus_data_wr(22) <= '0';
				bus_data_wr(23) <= '0';
				bus_data_wr(24) <= '0';
				bus_data_wr(25) <= '0';
				bus_data_wr(26) <= '0';
				bus_data_wr(27) <= '0';
				bus_data_wr(28) <= '0';
				bus_data_wr(29) <= '0';
				bus_data_wr(30) <= '0';
				bus_data_wr(31) <= '0';

			elsif is_cycle_start = '1' then
				bus_data_wr(0) <= '0';
				bus_data_wr(1) <= '0';
				bus_data_wr(2) <= '0';
				bus_data_wr(3) <= '0';
				bus_data_wr(4) <= '0';
				bus_data_wr(5) <= '0';
				bus_data_wr(6) <= '0';
				bus_data_wr(7) <= '0';
				bus_data_wr(8) <= '0';
				bus_data_wr(9) <= '0';
				bus_data_wr(10) <= '0';
				bus_data_wr(11) <= '0';
				bus_data_wr(12) <= '0';
				bus_data_wr(13) <= '0';
				bus_data_wr(14) <= '0';
				bus_data_wr(15) <= '0';
				bus_data_wr(16) <= '0';
				bus_data_wr(17) <= '0';
				bus_data_wr(18) <= '0';
				bus_data_wr(19) <= '0';
				bus_data_wr(20) <= '0';
				bus_data_wr(21) <= '0';
				bus_data_wr(22) <= '0';
				bus_data_wr(23) <= '0';
				bus_data_wr(24) <= '0';
				bus_data_wr(25) <= '0';
				bus_data_wr(26) <= '0';
				bus_data_wr(27) <= '0';
				bus_data_wr(28) <= '0';
				bus_data_wr(29) <= '0';
				bus_data_wr(30) <= '0';
				bus_data_wr(31) <= '0';
			end if;
		end if;
	end process;

	drive_bus_ad : process(write_data_to_bus, bus_data_wr)
	begin
		if write_data_to_bus = '1' then
			ad_31 <= bus_data_wr(31);
			ad_30 <= bus_data_wr(30);
			ad_29 <= bus_data_wr(29);
			ad_28 <= bus_data_wr(28);
			ad_27 <= bus_data_wr(27);
			ad_26 <= bus_data_wr(26);
			ad_25 <= bus_data_wr(25);
			ad_24 <= bus_data_wr(24);
			ad_23 <= bus_data_wr(23);
			ad_22 <= bus_data_wr(22);
			ad_21 <= bus_data_wr(21);
			ad_20 <= bus_data_wr(20);
			ad_19 <= bus_data_wr(19);
			ad_18 <= bus_data_wr(18);
			ad_17 <= bus_data_wr(17);
			ad_16 <= bus_data_wr(16);
			ad_15 <= bus_data_wr(15);
			ad_14 <= bus_data_wr(14);
			ad_13 <= bus_data_wr(13);
			ad_12 <= bus_data_wr(12);
			ad_11 <= bus_data_wr(11);
			ad_10 <= bus_data_wr(10);
			ad_9 <= bus_data_wr(9);
			ad_8 <= bus_data_wr(8);
			ad_7 <= bus_data_wr(7);
			ad_6 <= bus_data_wr(6);
			ad_5 <= bus_data_wr(5);
			ad_4 <= bus_data_wr(4);
			ad_3 <= bus_data_wr(3);
			ad_2 <= bus_data_wr(2);
			ad_1 <= bus_data_wr(1);
			ad_0 <= bus_data_wr(0);
		else
			ad_31 <= 'Z';
			ad_30 <= 'Z';
			ad_29 <= 'Z';
			ad_28 <= 'Z';
			ad_27 <= 'Z';
			ad_26 <= 'Z';
			ad_25 <= 'Z';
			ad_24 <= 'Z';
			ad_23 <= 'Z';
			ad_22 <= 'Z';
			ad_21 <= 'Z';
			ad_20 <= 'Z';
			ad_19 <= 'Z';
			ad_18 <= 'Z';
			ad_17 <= 'Z';
			ad_16 <= 'Z';
			ad_15 <= 'Z';
			ad_14 <= 'Z';
			ad_13 <= 'Z';
			ad_12 <= 'Z';
			ad_11 <= 'Z';
			ad_10 <= 'Z';
			ad_9 <= 'Z';
			ad_8 <= 'Z';
			ad_7 <= 'Z';
			ad_6 <= 'Z';
			ad_5 <= 'Z';
			ad_4 <= 'Z';
			ad_3 <= 'Z';
			ad_2 <= 'Z';
			ad_1 <= 'Z';
			ad_0 <= 'Z';
		end if;
	end process;

	parity_0 <= bus_data_wr(0)
		xor bus_data_wr(1)
		xor bus_data_wr(2)
		xor bus_data_wr(3);

	parity_1 <= bus_data_wr(4)
		xor bus_data_wr(5)
		xor bus_data_wr(6)
		xor bus_data_wr(7);

	parity_2 <= bus_data_wr(8)
		xor bus_data_wr(9)
		xor bus_data_wr(10)
		xor bus_data_wr(11);
	
	parity_3 <= bus_data_wr(12)
		xor bus_data_wr(13)
		xor bus_data_wr(14)
		xor bus_data_wr(15);

	parity_4 <= bus_data_wr(16)
		xor bus_data_wr(17)
		xor bus_data_wr(18)
		xor bus_data_wr(19);

	parity_5 <= bus_data_wr(20)
		xor bus_data_wr(21)
		xor bus_data_wr(22)
		xor bus_data_wr(23);

	parity_6 <= bus_data_wr(24)
		xor bus_data_wr(25)
		xor bus_data_wr(26)
		xor bus_data_wr(27);

	parity_7 <= bus_data_wr(28)
		xor bus_data_wr(29)
		xor bus_data_wr(30)
		xor bus_data_wr(31);

	parity_8 <= bus_command(0)
		xor bus_command(1)
		xor bus_command(2)
		xor bus_command(3);

	parity_9 <= parity_0
		xor parity_1
		xor parity_2
		xor parity_3;

	parity_10 <= parity_4 
		xor parity_5
		xor parity_6
		xor parity_7;

	gen_reg_parity : process(clk, rst_n, parity_8, parity_9, parity_10)
	begin
		if rst_n = '0' then
			reg_parity <= '0';
		elsif clk = '1' and clk'event then
			reg_parity <= parity_8 xor parity_9 xor parity_10;
		end if;
	end process;

	gen_reg_frame_n : process(clk, rst_n)
	begin
		if rst_n = '0' then 
			reg_frame_n <= '1';
		elsif clk = '1' and clk'event then
			reg_frame_n <= frame_n;
		end if;
	end process;

	gen_reg_reg_frame_n : process(clk, rst_n)
	begin
		if rst_n = '0' then 
			reg_reg_frame_n <= '1';
		elsif clk = '1' and clk'event then
			reg_reg_frame_n <= reg_frame_n;
		end if;
	end process;


	gen_reg_idsel : process(clk, rst_n)
	begin
		if rst_n = '0' then 
			reg_idsel <= '1';
		elsif clk = '1' and clk'event then
			reg_idsel <= idsel;
		end if;
	end process;

	is_cycle_start <= reg_reg_frame_n and (not reg_frame_n);

	store_bus_data_reg : process(clk)
	begin
		if clk = '1' and clk'event then
			reg_bus_data(31) <= ad_31;
			reg_bus_data(30) <= ad_30;
			reg_bus_data(29) <= ad_29;
			reg_bus_data(28) <= ad_28;
			reg_bus_data(27) <= ad_27;
			reg_bus_data(26) <= ad_26;
			reg_bus_data(25) <= ad_25;
			reg_bus_data(24) <= ad_24;
			reg_bus_data(23) <= ad_23;
			reg_bus_data(22) <= ad_22;
			reg_bus_data(21) <= ad_21;
			reg_bus_data(20) <= ad_20;
			reg_bus_data(19) <= ad_19;
			reg_bus_data(18) <= ad_18;
			reg_bus_data(17) <= ad_17;
			reg_bus_data(16) <= ad_16;
			reg_bus_data(15) <= ad_15;
			reg_bus_data(14) <= ad_14;
			reg_bus_data(13) <= ad_13;
			reg_bus_data(12) <= ad_12;
			reg_bus_data(11) <= ad_11;
			reg_bus_data(10) <= ad_10;
			reg_bus_data(9) <= ad_9;
			reg_bus_data(8) <= ad_8;
			reg_bus_data(7) <= ad_7;
			reg_bus_data(6) <= ad_6;
			reg_bus_data(5) <= ad_5;
			reg_bus_data(4) <= ad_4;
			reg_bus_data(3) <= ad_3;
			reg_bus_data(2) <= ad_2;
			reg_bus_data(1) <= ad_1;
			reg_bus_data(0) <= ad_0;
		end if;
	end process;

	store_bus_command : process(clk)
	begin
		if clk = '1' and clk'event then
			bus_command(0) <= cbe_n_0;
			bus_command(1) <= cbe_n_1;
			bus_command(2) <= cbe_n_2;
			bus_command(3) <= cbe_n_3;
		end if;
	end process;

	gen_conf_sel : process(rst_n, reg_bus_data)
	begin
		if rst_n = '0' then
			conf_sel_00 <= '0';
			conf_sel_04 <= '0';
			conf_sel_08 <= '0';
			conf_sel_0c <= '0';
			conf_sel_10 <= '0';

		elsif reg_bus_data(0) = '0' 
			and reg_bus_data(1) = '0'
			and reg_bus_data(7) = '0'
			and reg_bus_data(6) = '0'
			and reg_bus_data(5) = '0'
			and reg_bus_data(4) = '0'
			and reg_bus_data(3) = '0'
			and reg_bus_data(2) = '0' then

			conf_sel_00 <= '1';
			conf_sel_04 <= '0';
			conf_sel_08 <= '0';
			conf_sel_0c <= '0';
			conf_sel_10 <= '0';

		elsif   reg_bus_data(0) = '0' 
			and reg_bus_data(1) = '0'
			and reg_bus_data(7) = '0'
			and reg_bus_data(6) = '0'
			and reg_bus_data(5) = '0'
			and reg_bus_data(4) = '0'
			and reg_bus_data(3) = '0'
			and reg_bus_data(2) = '1' then

			-- config space 04h
			conf_sel_00 <= '0';
			conf_sel_04 <= '1';
			conf_sel_08 <= '0';
			conf_sel_0c <= '0';
			conf_sel_10 <= '0';

		elsif  reg_bus_data(0) = '0' 
			and reg_bus_data(1) = '0'
			and reg_bus_data(2) = '0'
			and reg_bus_data(3) = '1'
			and reg_bus_data(4) = '0'
			and reg_bus_data(5) = '0'
			and reg_bus_data(6) = '0'
			and reg_bus_data(7) = '0' then

			conf_sel_00 <= '0';
			conf_sel_04 <= '0';
			conf_sel_08 <= '1';
			conf_sel_0c <= '0';
			conf_sel_10 <= '0';

		elsif  reg_bus_data(0) = '0' 
			and reg_bus_data(1) = '0'
			and reg_bus_data(2) = '0'
			and reg_bus_data(3) = '1'
			and reg_bus_data(4) = '1'
			and reg_bus_data(5) = '0'
			and reg_bus_data(6) = '0'
			and reg_bus_data(7) = '0' then

			conf_sel_00 <= '0';
			conf_sel_04 <= '0';
			conf_sel_08 <= '0';
			conf_sel_0c <= '1';
			conf_sel_10 <= '0';

		elsif  reg_bus_data(0) = '0' 
			and reg_bus_data(1) = '0'
			and reg_bus_data(7) = '0'
			and reg_bus_data(6) = '0'
			and reg_bus_data(5) = '0'
			and reg_bus_data(4) = '1'
			and reg_bus_data(3) = '0'
			and reg_bus_data(2) = '0' then

			conf_sel_00 <= '0';
			conf_sel_04 <= '0';
			conf_sel_08 <= '0';
			conf_sel_0c <= '0';
			conf_sel_10 <= '1';

		else
			conf_sel_00 <= '0';
			conf_sel_04 <= '0';
			conf_sel_08 <= '0';
			conf_sel_0c <= '0';
			conf_sel_10 <= '0';
		end if;
	end process;

	gen_conf_sel_reg : process(clk, rst_n)
	begin
		if rst_n = '0' then
			conf_sel_04_reg <= '0';
			conf_sel_10_reg <= '0';
		elsif clk = '1' and clk'event then
			conf_sel_04_reg <= conf_sel_04;
			conf_sel_10_reg <= conf_sel_10;
		end if;
	end process;

	gen_io_sel : process(rst_n, reg_bus_data)
	begin
		if rst_n = '0' then
			io_sel_00 <= '0';

		elsif (     (not reg_bus_data(0)) 
			and (not reg_bus_data(1))
			and (not reg_bus_data(2))
			and (not reg_bus_data(3))) = '1' then

			io_sel_00 <= '1';
		else
			io_sel_00 <= '0';
		end if;
	end process;

	gen_io_sel_reg : process(rst_n, clk)
	begin
		if rst_n = '0' then
			io_sel_00_reg <= '0';
		elsif clk = '1' and clk'event then
			io_sel_00_reg <= io_sel_00;
		end if;
	end process;

	-- COMM_FSM
	process (clk, rst_n)
	begin
		if rst_n = '0' then
			COMM_STATE <= "0000";
		elsif (clk = '1' and clk'event) then
			-- ST_IDLE_COMM (0000)
			if         ((not COMM_STATE(3)) 
				and (not COMM_STATE(2)) 
				and (not COMM_STATE(1)) 
				and (not COMM_STATE(0))) = '1' then
				
				if IO_READ = '1' then
					COMM_STATE <= ST_IO_READ;
				elsif CONF_READ = '1' then
					COMM_STATE <= ST_CONF_READ;
				elsif IO_WRITE = '1' then
					COMM_STATE <= ST_IO_WRITE;
				elsif CONF_WRITE = '1' then
					COMM_STATE <= ST_CONF_WRITE;
				else 
					COMM_STATE <= ST_IDLE_COMM;
				end if;

			-- ST_IO_READ (1000)
			elsif      (COMM_STATE(3)
				and (not COMM_STATE(2))
				and (not COMM_STATE(1))
				and (not COMM_STATE(0))) = '1' then
			
				if CONTROL_STATE(3) = '1' then
					COMM_STATE <= ST_IDLE_COMM;
				end if;

			-- ST_CONF_READ (0100)
			elsif       ((not COMM_STATE(3))
				and COMM_STATE(2)
				and (not COMM_STATE(1))
				and (not COMM_STATE(0))) = '1' then

				if CONTROL_STATE(3) = '1' then
					COMM_STATE <= ST_IDLE_COMM;
				end if;

			-- ST_IO_WRITE (0010)
			elsif       ((not COMM_STATE(3))
				and (not COMM_STATE(2))
				and COMM_STATE(1)
				and (not COMM_STATE(0))) = '1' then

				if CONTROL_STATE(3) = '1' then
					COMM_STATE <= ST_IDLE_COMM;
				end if;

			-- ST_CONF_WRITE (0001)
			elsif       ((not COMM_STATE(3))
				and (not COMM_STATE(2))
				and (not COMM_STATE(1))
				and COMM_STATE(0)) = '1' then

				if CONTROL_STATE(3) = '1' then
					COMM_STATE <= ST_IDLE_COMM;
				end if;
			else
				COMM_STATE <= ST_IDLE_COMM;
			end if;
		end if;
	end process;

	process (clk, rst_n) 
	begin
		if rst_n = '0' then 
			CONTROL_STATE <= ST_IDLE;
		elsif clk = '1' and clk'event then
			-- ST_IDLE
			if     ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (not CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (    CONTROL_STATE(5))
			    and (    CONTROL_STATE(4))
			    and (    CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (not CONTROL_STATE(1))
			    and (not CONTROL_STATE(0))) = '1' then

				if IO_READ = '1' then
					CONTROL_STATE <= ST_READ_1;
	  		  	elsif CONF_READ	= '1' then
					CONTROL_STATE <= ST_READ_1; 
				elsif IO_WRITE = '1' then
					CONTROL_STATE <= ST_WRITE_1;   
			    	elsif CONF_WRITE = '1' then
					CONTROL_STATE <= ST_WRITE_1;
   		    		else
					CONTROL_STATE <= ST_IDLE;
				end if;

			-- ST_READ_1
			elsif  ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (not CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (    CONTROL_STATE(5))
			    and (    CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (    CONTROL_STATE(0))) = '1' then

				if FIFO_READ = '1' then
					CONTROL_STATE <= ST_RD_FIFO_1;
				else
					CONTROL_STATE <= ST_READ_2;
				end if;	

			-- ST_READ_2
			elsif  ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (not CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (not CONTROL_STATE(5))
			    and (not CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (    CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (    CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_READ_3;

			-- ST_READ_3
			elsif  ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (not CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (not CONTROL_STATE(5))
			    and (not CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (    CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (    CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_IDLE;

			-- ST_RD_FIFO_1
			elsif  ((not CONTROL_STATE(9))
			    and (not CONTROL_STATE(8))
			    and (not CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (    CONTROL_STATE(5))
			    and (    CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (    CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_RD_FIFO_2;

			-- ST_RD_FIFO_2
			elsif  ((    CONTROL_STATE(9))
			    and (not CONTROL_STATE(8))
			    and (not CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (    CONTROL_STATE(5))
			    and (    CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (    CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_READ_2;

			-- ST_WRITE_1
			elsif  ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (    CONTROL_STATE(7))
			    and (    CONTROL_STATE(6))
			    and (    CONTROL_STATE(5))
			    and (    CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (not CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_WRITE_2;

			-- ST_WRITE_2
			elsif  ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (    CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (not CONTROL_STATE(5))
			    and (not CONTROL_STATE(4))
			    and (not CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (not CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_WRITE_3;
			
			-- ST_WRITE_3
			elsif  ((not CONTROL_STATE(9))
			    and (    CONTROL_STATE(8))
			    and (    CONTROL_STATE(7))
			    and (not CONTROL_STATE(6))
			    and (    CONTROL_STATE(5))
			    and (    CONTROL_STATE(4))
			    and (    CONTROL_STATE(3))
			    and (not CONTROL_STATE(2))
			    and (    CONTROL_STATE(1))
			    and (not CONTROL_STATE(0))) = '1' then

				CONTROL_STATE <= ST_IDLE;

			else
				CONTROL_STATE <= ST_IDLE; 
 			end if;
		end if;
	end process;


	devsel_n <= CONTROL_STATE(3) when CONTROL_STATE(1) = '1' else 'Z';
	trdy_n <= CONTROL_STATE(5) when CONTROL_STATE(1) = '1' else 'Z';
	par <= reg_parity when CONTROL_STATE(2) = '1' else 'Z';

	IO_READ	<= '1' when is_cycle_start = '1'
			and conf_status_io = '1'
			and bus_command(0) = '0'
			and bus_command(1) = '1'
			and bus_command(2) = '0'
			and bus_command(3) = '0'
			and match_addr_7 = '1'
		else '0'; 

	IO_WRITE <= '1' when is_cycle_start = '1'
			and conf_status_io = '1'
			and bus_command(0) = '1'
			and bus_command(1) = '1'
			and bus_command(2) = '0'
			and bus_command(3) = '0'
			and match_addr_7 = '1'
		else '0';

	CONF_READ <= '1' when is_cycle_start = '1'
			and reg_bus_data(0) = '0'
			and reg_bus_data(1) = '0'
			and bus_command(0) = '0'
			and bus_command(1) = '1'
			and bus_command(2) = '0'
			and bus_command(3) = '1'
			and reg_idsel = '1'
			else '0';

	CONF_WRITE <= '1' when is_cycle_start = '1'
			and reg_bus_data(0) = '0'
			and reg_bus_data(1) = '0'
			and bus_command(0) = '1'
			and bus_command(1) = '1'
			and bus_command(2) = '0'
			and bus_command(3) = '1'
			and reg_idsel = '1'
			else '0';

	write_data_to_bus <= CONTROL_STATE(0);

	reg_out_xx0_0 <= io_reg_xx0_0;
	reg_out_xx0_1 <= io_reg_xx0_1;
	reg_out_xx0_2 <= io_reg_xx0_2;
	reg_out_xx0_3 <= io_reg_xx0_3;
	reg_out_xx0_4 <= io_reg_xx0_4;
	reg_out_xx0_5 <= io_reg_xx0_5;
	reg_out_xx0_6 <= io_reg_xx0_6;
	reg_out_xx0_7 <= io_reg_xx0_7;

	reg_out_xx1_0 <= io_reg_xx1_0;
	reg_out_xx1_1 <= io_reg_xx1_1;
	reg_out_xx1_2 <= io_reg_xx1_2;
	reg_out_xx1_3 <= io_reg_xx1_3;
	reg_out_xx1_4 <= io_reg_xx1_4;
	reg_out_xx1_5 <= io_reg_xx1_5;
	reg_out_xx1_6 <= io_reg_xx1_6;
	reg_out_xx1_7 <= io_reg_xx1_7;

END ARCHITECTURE pcicard_impl;
