--
-- $Id: test_bench.vhdl,v 1.3 2013-05-10 13:27:52 vrsieh Exp $
--
-- Copyright (C) 2007-2011 FAUmachine Team <info@faumachine.org>.
--
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.
--

library expect;
use expect.types.all;
use expect.procedures.all;
library ieee;
use ieee.std_logic_1164.ALL;

entity test_bench is
end test_bench;

architecture structural of test_bench is
	signal ext_net : eth_conn;
	signal ext_eth : eth_conn;
	signal ext_usb0 : usb_conn;
	signal ext_usb1 : usb_conn;
	signal ext_par : parallel;
	signal ext_ser0 : serial;
	signal ext_ser1 : serial;

	signal power_switch : boolean;
	signal power_button : boolean;
	signal reset_button : boolean;

	signal media_floppy : floppy;
	signal floppy : cstring;
	signal media_cd : magneto_optical;
	signal cdrom : cstring;
	signal media_image : opt_rgb;
	signal image : cstring;
	signal floppy_conn : floppy_array(1 to 20);
	signal cddvd_conn : magneto_optical_array(1 to 20);
	signal image_conn : image_array(1 to 20);

	signal key : boolean_array(0 to 127);

	signal mouse_dx : integer;
	signal mouse_dy : integer;
	signal mouse_dz : integer;
	signal mouse_button1 : boolean;
	signal mouse_button2 : boolean;
	signal mouse_button3 : boolean;
	signal mouse_button4 : boolean;
	signal mouse_button5 : boolean;

	signal screen_shot : boolean;
	signal rec : boolean;

	signal opt_screen : opt_rgb;
	signal console : serial;

	signal ext_card0 : cardbus_conn;
	signal ext_card1 : cardbus_conn;
begin
	pc : pc_standard
		port map(
			ext_usb0 => ext_usb0,
			ext_usb1 => ext_usb1,
			ext_par => ext_par,
			ext_ser0 => ext_ser0,
			ext_ser1 => ext_ser1,
			power_switch => power_switch,
			power_button => power_button,
			reset_button => reset_button,
			media_floppy => media_floppy,
			floppy => floppy,
			media_cd => media_cd,
			cdrom => cdrom,
			media_image => media_image,
			image => image,
			key => key,
			mouse_dx => mouse_dx,
			mouse_dy => mouse_dy,
			mouse_dz => mouse_dz,
			mouse_button1 => mouse_button1,
			mouse_button2 => mouse_button2,
			mouse_button3 => mouse_button3,
			mouse_button4 => mouse_button4,
			mouse_button5 => mouse_button5,
			screen_shot => screen_shot,
			rec => rec,
			opt_screen => opt_screen,
			ext_card0 => ext_card0,
			ext_card1 => ext_card1
		);
	cable : network_cable
		port map(
			end0 => ext_eth,
			end1 => ext_net
		);
	bridge : network_router
		port map(
			eth => ext_net,
			console => console
		);
	user : user
		port map(
			power_switch => power_switch,
			power_button => power_button,
			reset_button => reset_button,
			floppy => floppy,
			cdrom => cdrom,
			image => image,
			key => key,
			mouse_dx => mouse_dx,
			mouse_dy => mouse_dy,
			mouse_dz => mouse_dz,
			mouse_button1 => mouse_button1,
			mouse_button2 => mouse_button2,
			mouse_button3 => mouse_button3,
			mouse_button4 => mouse_button4,
			mouse_button5 => mouse_button5,
			screen_shot => screen_shot,
			rec => rec,
			opt_screen => opt_screen
		);

	cb_intel_eepro100 : cb_intel_eepro100
		port map(
			card => ext_card0,
			network => ext_eth
		);

	-- generated media image components will be inserted here
	-- @MEDIA_IMAGE_COMPS@
end structural;
