/*
 * Copyright (C) 2014 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "glue-gui-gtk.h"
#include "glue-gui-gtk-monitor.h"

#include "glue.h"

#include "zusetest_gui_gtk.h"

#define COMP_(x) zusetest_ ## x
#define DEBUG 1

struct cpssp {
	GtkWidget *gui;
/* colors */
	GdkColor gdk_red;
	GdkColor gdk_green;
	GdkColor gdk_blue;
	GdkColor gdk_black;
/* ports */
	/* two ints per signal, so changes are detectable lateron */
	unsigned int oldport_Uhr1;
	unsigned int port_Uhr1;
	unsigned int oldport_Uhr2;
	unsigned int port_Uhr2;
	unsigned int oldport_Imp1;
	unsigned int port_Imp1;
	unsigned int oldport_Imp2;
	unsigned int port_Imp2;
	unsigned int oldport_22I1;
	unsigned int port_22I1;
	unsigned int oldport_22I2;
	unsigned int port_22I2;
	unsigned int oldport_22I3;
	unsigned int port_22I3;
	unsigned int oldport_22I4;
	unsigned int port_22I4;
	unsigned int oldport_22I5;
	unsigned int port_22I5;
	unsigned int oldport_22I6;
	unsigned int port_22I6;
	unsigned int oldport_22I7;
	unsigned int port_22I7;
	unsigned int oldport_22I8;
	unsigned int port_22I8;
	unsigned int oldport_22I9;
	unsigned int port_22I9;
	unsigned int oldport_22I0;
	unsigned int port_22I0;
	unsigned int oldport_22II1;
	unsigned int port_22II1;
	unsigned int oldport_22II2;
	unsigned int port_22II2;
	unsigned int oldport_22II3;
	unsigned int port_22II3;
	unsigned int oldport_22II4;
	unsigned int port_22II4;
	unsigned int oldport_22II5;
	unsigned int port_22II5;
	unsigned int oldport_22II6;
	unsigned int port_22II6;
	unsigned int oldport_22II7;
	unsigned int port_22II7;
	unsigned int oldport_22II8;
	unsigned int port_22II8;
	unsigned int oldport_22II9;
	unsigned int port_22II9;
	unsigned int oldport_22II0;
	unsigned int port_22II0;
	unsigned int oldport_22III1;
	unsigned int port_22III1;
	unsigned int oldport_22III2;
	unsigned int port_22III2;
	unsigned int oldport_22III3;
	unsigned int port_22III3;
	unsigned int oldport_22III4;
	unsigned int port_22III4;
	unsigned int oldport_22III5;
	unsigned int port_22III5;
	unsigned int oldport_22III6;
	unsigned int port_22III6;
	unsigned int oldport_22III7;
	unsigned int port_22III7;
	unsigned int oldport_22III8;
	unsigned int port_22III8;
	unsigned int oldport_22III9;
	unsigned int port_22III9;
	unsigned int oldport_22III0;
	unsigned int port_22III0;
	unsigned int oldport_30I1;
	unsigned int port_30I1;
	unsigned int oldport_30I2;
	unsigned int port_30I2;
	unsigned int oldport_30I3;
	unsigned int port_30I3;
	unsigned int oldport_30I4;
	unsigned int port_30I4;
	unsigned int oldport_30I5;
	unsigned int port_30I5;
	unsigned int oldport_30I6;
	unsigned int port_30I6;
	unsigned int oldport_30I7;
	unsigned int port_30I7;
	unsigned int oldport_30I8;
	unsigned int port_30I8;
	unsigned int oldport_30I9;
	unsigned int port_30I9;
	unsigned int oldport_30I0;
	unsigned int port_30I0;
	unsigned int oldport_30II1;
	unsigned int port_30II1;
	unsigned int oldport_30II2;
	unsigned int port_30II2;
	unsigned int oldport_30II3;
	unsigned int port_30II3;
	unsigned int oldport_30II4;
	unsigned int port_30II4;
	unsigned int oldport_30II5;
	unsigned int port_30II5;
	unsigned int oldport_30II6;
	unsigned int port_30II6;
	unsigned int oldport_30II7;
	unsigned int port_30II7;
	unsigned int oldport_30II8;
	unsigned int port_30II8;
	unsigned int oldport_30II9;
	unsigned int port_30II9;
	unsigned int oldport_30II0;
	unsigned int port_30II0;
	unsigned int oldport_30III1;
	unsigned int port_30III1;
	unsigned int oldport_30III2;
	unsigned int port_30III2;
	unsigned int oldport_30III3;
	unsigned int port_30III3;
	unsigned int oldport_30III4;
	unsigned int port_30III4;
	unsigned int oldport_30III5;
	unsigned int port_30III5;
	unsigned int oldport_30III6;
	unsigned int port_30III6;
	unsigned int oldport_30III7;
	unsigned int port_30III7;
	unsigned int oldport_30III8;
	unsigned int port_30III8;
	unsigned int oldport_30III9;
	unsigned int port_30III9;
	unsigned int oldport_30III0;
	unsigned int port_30III0;
/* gui ports */
	unsigned int oldport_0x1bb8760;
	unsigned int port_0x1bb8760;
	unsigned int oldport_0x1bb9650;
	unsigned int port_0x1bb9650;
	unsigned int oldport_0x1bb9630;
	unsigned int port_0x1bb9630;
	unsigned int oldport_0x1bb69a0;
	unsigned int port_0x1bb69a0;
	unsigned int oldport_0x1bb82f0;
	unsigned int port_0x1bb82f0;
	unsigned int oldport_0x1bb81b0;
	unsigned int port_0x1bb81b0;
	unsigned int oldport_0x1bb8f00;
	unsigned int port_0x1bb8f00;
	unsigned int oldport_0x1bb3b20;
	unsigned int port_0x1bb3b20;
	unsigned int oldport_0x1bb6a40;
	unsigned int port_0x1bb6a40;
	unsigned int oldport_0x1bb8550;
	unsigned int port_0x1bb8550;
	unsigned int oldport_0x1bb6980;
	unsigned int port_0x1bb6980;
	unsigned int oldport_0x1bb8190;
	unsigned int port_0x1bb8190;
	unsigned int oldport_0x1bb6640;
	unsigned int port_0x1bb6640;
	unsigned int oldport_0x1bbe9b0;
	unsigned int port_0x1bbe9b0;
	unsigned int oldport_0x1bbe9d0;
	unsigned int port_0x1bbe9d0;
	unsigned int oldport_0x1bbe9f0;
	unsigned int port_0x1bbe9f0;
	unsigned int oldport_0x1bbea10;
	unsigned int port_0x1bbea10;
	unsigned int oldport_0x1bbea30;
	unsigned int port_0x1bbea30;
	unsigned int oldport_0x1bbea50;
	unsigned int port_0x1bbea50;
	unsigned int oldport_0x1bbea70;
	unsigned int port_0x1bbea70;
	unsigned int oldport_0x1bbea90;
	unsigned int port_0x1bbea90;
	unsigned int oldport_0x1bbeab0;
	unsigned int port_0x1bbeab0;
	unsigned int oldport_0x1bbead0;
	unsigned int port_0x1bbead0;
	unsigned int oldport_0x1bbeaf0;
	unsigned int port_0x1bbeaf0;
	unsigned int oldport_0x1bbeb10;
	unsigned int port_0x1bbeb10;
	unsigned int oldport_0x1bbeb30;
	unsigned int port_0x1bbeb30;
	unsigned int oldport_0x1bbeb50;
	unsigned int port_0x1bbeb50;
	unsigned int oldport_0x1bbeb70;
	unsigned int port_0x1bbeb70;
	unsigned int oldport_0x1bbeb90;
	unsigned int port_0x1bbeb90;
	unsigned int oldport_0x1bbebb0;
	unsigned int port_0x1bbebb0;
	unsigned int oldport_0x1bbebd0;
	unsigned int port_0x1bbebd0;
	unsigned int oldport_0x1bbebf0;
	unsigned int port_0x1bbebf0;
	unsigned int oldport_0x1bbec10;
	unsigned int port_0x1bbec10;
	unsigned int oldport_0x1bbec30;
	unsigned int port_0x1bbec30;
	unsigned int oldport_0x1bbec50;
	unsigned int port_0x1bbec50;
	unsigned int oldport_0x1bbec70;
	unsigned int port_0x1bbec70;
	unsigned int oldport_0x1bbec90;
	unsigned int port_0x1bbec90;
	unsigned int oldport_0x1bbecb0;
	unsigned int port_0x1bbecb0;
	unsigned int oldport_0x1bbecd0;
	unsigned int port_0x1bbecd0;
	unsigned int oldport_0x1bbecf0;
	unsigned int port_0x1bbecf0;
	unsigned int oldport_0x1bbed10;
	unsigned int port_0x1bbed10;
	unsigned int oldport_0x1bbed30;
	unsigned int port_0x1bbed30;
	unsigned int oldport_0x1bbed50;
	unsigned int port_0x1bbed50;
	unsigned int oldport_0x1bbed70;
	unsigned int port_0x1bbed70;
	unsigned int oldport_0x1bbed90;
	unsigned int port_0x1bbed90;
	unsigned int oldport_0x1bbedb0;
	unsigned int port_0x1bbedb0;
	unsigned int oldport_0x1bbedd0;
	unsigned int port_0x1bbedd0;
	unsigned int oldport_0x1bbedf0;
	unsigned int port_0x1bbedf0;
	unsigned int oldport_0x1bbee10;
	unsigned int port_0x1bbee10;
	unsigned int oldport_0x1bbee30;
	unsigned int port_0x1bbee30;
	unsigned int oldport_0x1bbee50;
	unsigned int port_0x1bbee50;
	unsigned int oldport_0x1bbee70;
	unsigned int port_0x1bbee70;
	unsigned int oldport_0x1bbee90;
	unsigned int port_0x1bbee90;
	unsigned int oldport_0x1bbeeb0;
	unsigned int port_0x1bbeeb0;
	unsigned int oldport_0x1bbeed0;
	unsigned int port_0x1bbeed0;
	unsigned int oldport_0x1bbeef0;
	unsigned int port_0x1bbeef0;
	unsigned int oldport_0x1bbef10;
	unsigned int port_0x1bbef10;
	unsigned int oldport_0x1bbef30;
	unsigned int port_0x1bbef30;
	unsigned int oldport_0x1bbef50;
	unsigned int port_0x1bbef50;
	unsigned int oldport_0x1bbef70;
	unsigned int port_0x1bbef70;
	unsigned int oldport_0x1bbef90;
	unsigned int port_0x1bbef90;
	unsigned int oldport_0x1bbefb0;
	unsigned int port_0x1bbefb0;
	unsigned int oldport_0x1bbefd0;
	unsigned int port_0x1bbefd0;
	unsigned int oldport_0x1bbeff0;
	unsigned int port_0x1bbeff0;
	unsigned int oldport_0x1bbf010;
	unsigned int port_0x1bbf010;
	unsigned int oldport_0x1bbf030;
	unsigned int port_0x1bbf030;
	unsigned int oldport_0x1bbf050;
	unsigned int port_0x1bbf050;
	unsigned int oldport_0x1bbf070;
	unsigned int port_0x1bbf070;
	unsigned int oldport_0x1bbf090;
	unsigned int port_0x1bbf090;
	unsigned int oldport_0x1bbf0b0;
	unsigned int port_0x1bbf0b0;
	unsigned int oldport_0x1bbf0d0;
	unsigned int port_0x1bbf0d0;
	unsigned int oldport_0x1bbf0f0;
	unsigned int port_0x1bbf0f0;
	unsigned int oldport_0x1bbf110;
	unsigned int port_0x1bbf110;
	unsigned int oldport_0x1bbf130;
	unsigned int port_0x1bbf130;
	unsigned int oldport_0x1bbf150;
	unsigned int port_0x1bbf150;
	unsigned int oldport_0x1bbf170;
	unsigned int port_0x1bbf170;
	unsigned int oldport_0x1bbf190;
	unsigned int port_0x1bbf190;
	unsigned int oldport_0x1bbf1b0;
	unsigned int port_0x1bbf1b0;
	unsigned int oldport_0x1bbf1d0;
	unsigned int port_0x1bbf1d0;
	unsigned int oldport_0x1bbf1f0;
	unsigned int port_0x1bbf1f0;
	unsigned int oldport_0x1bbf210;
	unsigned int port_0x1bbf210;
	unsigned int oldport_0x1bbf230;
	unsigned int port_0x1bbf230;
	unsigned int oldport_0x1bbf250;
	unsigned int port_0x1bbf250;
	unsigned int oldport_0x1bbf270;
	unsigned int port_0x1bbf270;
	unsigned int oldport_0x1bbf290;
	unsigned int port_0x1bbf290;
	unsigned int oldport_0x1bbf2b0;
	unsigned int port_0x1bbf2b0;
	unsigned int oldport_0x1bbf2d0;
	unsigned int port_0x1bbf2d0;
	unsigned int oldport_0x1bbf2f0;
	unsigned int port_0x1bbf2f0;
	unsigned int oldport_0x1bbf310;
	unsigned int port_0x1bbf310;
	unsigned int oldport_0x1bbf330;
	unsigned int port_0x1bbf330;
	unsigned int oldport_0x1bbf350;
	unsigned int port_0x1bbf350;
	unsigned int oldport_0x1bbf370;
	unsigned int port_0x1bbf370;
	unsigned int oldport_0x1bbf390;
	unsigned int port_0x1bbf390;
	unsigned int oldport_0x1bbf3b0;
	unsigned int port_0x1bbf3b0;
	unsigned int oldport_0x1bbf3d0;
	unsigned int port_0x1bbf3d0;
	unsigned int oldport_0x1bbf3f0;
	unsigned int port_0x1bbf3f0;
	unsigned int oldport_0x1bbf410;
	unsigned int port_0x1bbf410;
	unsigned int oldport_0x1bbf430;
	unsigned int port_0x1bbf430;
	unsigned int oldport_0x1bbf450;
	unsigned int port_0x1bbf450;
	unsigned int oldport_0x1bbf470;
	unsigned int port_0x1bbf470;
	unsigned int oldport_0x1bbf490;
	unsigned int port_0x1bbf490;
	unsigned int oldport_0x1bbf4b0;
	unsigned int port_0x1bbf4b0;
	unsigned int oldport_0x1bbf4d0;
	unsigned int port_0x1bbf4d0;
	unsigned int oldport_0x1bbf4f0;
	unsigned int port_0x1bbf4f0;
	unsigned int oldport_0x1bbf510;
	unsigned int port_0x1bbf510;
	unsigned int oldport_0x1bbf530;
	unsigned int port_0x1bbf530;
	unsigned int oldport_0x1bbf550;
	unsigned int port_0x1bbf550;
	unsigned int oldport_0x1bbf570;
	unsigned int port_0x1bbf570;
	unsigned int oldport_0x1bbf590;
	unsigned int port_0x1bbf590;
	unsigned int oldport_0x1bbf5b0;
	unsigned int port_0x1bbf5b0;
	unsigned int oldport_0x1bbf5d0;
	unsigned int port_0x1bbf5d0;
	unsigned int oldport_0x1bbf5f0;
	unsigned int port_0x1bbf5f0;
	unsigned int oldport_0x1bbf610;
	unsigned int port_0x1bbf610;
	unsigned int oldport_0x1bbf630;
	unsigned int port_0x1bbf630;
	unsigned int oldport_0x1bbf650;
	unsigned int port_0x1bbf650;
	unsigned int oldport_0x1bbf670;
	unsigned int port_0x1bbf670;
	unsigned int oldport_0x1bbf690;
	unsigned int port_0x1bbf690;
	unsigned int oldport_0x1bbf6b0;
	unsigned int port_0x1bbf6b0;
	unsigned int oldport_0x1bbf6d0;
	unsigned int port_0x1bbf6d0;
	unsigned int oldport_0x1bbf6f0;
	unsigned int port_0x1bbf6f0;
	unsigned int oldport_0x1bbf710;
	unsigned int port_0x1bbf710;
	unsigned int oldport_0x1bbf730;
	unsigned int port_0x1bbf730;
	unsigned int oldport_0x1bbf750;
	unsigned int port_0x1bbf750;
	unsigned int oldport_0x1bc05f0;
	unsigned int port_0x1bc05f0;
	unsigned int oldport_0x1bc0740;
	unsigned int port_0x1bc0740;
	unsigned int oldport_0x1bc0890;
	unsigned int port_0x1bc0890;
	unsigned int oldport_0x1bc09e0;
	unsigned int port_0x1bc09e0;
	unsigned int oldport_0x1bc0b30;
	unsigned int port_0x1bc0b30;
	unsigned int oldport_0x1bc0c80;
	unsigned int port_0x1bc0c80;
	unsigned int oldport_0x1bc0dd0;
	unsigned int port_0x1bc0dd0;
	unsigned int oldport_0x1bc0f20;
	unsigned int port_0x1bc0f20;
	unsigned int oldport_0x1bc1070;
	unsigned int port_0x1bc1070;
	unsigned int oldport_0x1bc11c0;
	unsigned int port_0x1bc11c0;
	unsigned int oldport_0x1bc1310;
	unsigned int port_0x1bc1310;
	unsigned int oldport_0x1bc1460;
	unsigned int port_0x1bc1460;
	unsigned int oldport_0x1bc15b0;
	unsigned int port_0x1bc15b0;
	unsigned int oldport_0x1bc1700;
	unsigned int port_0x1bc1700;
	unsigned int oldport_0x1bc1850;
	unsigned int port_0x1bc1850;
	unsigned int oldport_0x1bc19a0;
	unsigned int port_0x1bc19a0;
	unsigned int oldport_0x1bc1af0;
	unsigned int port_0x1bc1af0;
	unsigned int oldport_0x1bc1c40;
	unsigned int port_0x1bc1c40;
	unsigned int oldport_0x1bc1d90;
	unsigned int port_0x1bc1d90;
	unsigned int oldport_0x1bc1ee0;
	unsigned int port_0x1bc1ee0;
	unsigned int oldport_0x1bc2030;
	unsigned int port_0x1bc2030;
	unsigned int oldport_0x1bc2180;
	unsigned int port_0x1bc2180;
	unsigned int oldport_0x1bc22d0;
	unsigned int port_0x1bc22d0;
	unsigned int oldport_0x1bc2420;
	unsigned int port_0x1bc2420;
	unsigned int oldport_0x1bc2570;
	unsigned int port_0x1bc2570;
	unsigned int oldport_0x1bc26c0;
	unsigned int port_0x1bc26c0;
	unsigned int oldport_0x1bc2810;
	unsigned int port_0x1bc2810;
	unsigned int oldport_0x1bc2960;
	unsigned int port_0x1bc2960;
	unsigned int oldport_0x1bc2ab0;
	unsigned int port_0x1bc2ab0;
	unsigned int oldport_0x1bc2c00;
	unsigned int port_0x1bc2c00;
	unsigned int oldport_0x1bc2d50;
	unsigned int port_0x1bc2d50;
	unsigned int oldport_0x1bc2ea0;
	unsigned int port_0x1bc2ea0;
	unsigned int oldport_0x1bc2ff0;
	unsigned int port_0x1bc2ff0;
	unsigned int oldport_0x1bc3140;
	unsigned int port_0x1bc3140;
	unsigned int oldport_0x1bc3290;
	unsigned int port_0x1bc3290;
	unsigned int oldport_0x1bc33e0;
	unsigned int port_0x1bc33e0;
	unsigned int oldport_0x1bc3530;
	unsigned int port_0x1bc3530;
	unsigned int oldport_0x1bc3680;
	unsigned int port_0x1bc3680;
	unsigned int oldport_0x1bc37d0;
	unsigned int port_0x1bc37d0;
	unsigned int oldport_0x1bc3920;
	unsigned int port_0x1bc3920;
	unsigned int oldport_0x1bc3a70;
	unsigned int port_0x1bc3a70;
	unsigned int oldport_0x1bc3bc0;
	unsigned int port_0x1bc3bc0;
	unsigned int oldport_0x1bc3d10;
	unsigned int port_0x1bc3d10;
	unsigned int oldport_0x1bc3e60;
	unsigned int port_0x1bc3e60;
	unsigned int oldport_0x1bc3fb0;
	unsigned int port_0x1bc3fb0;
	unsigned int oldport_0x1bc4100;
	unsigned int port_0x1bc4100;
	unsigned int oldport_0x1bc4250;
	unsigned int port_0x1bc4250;
	unsigned int oldport_0x1bc43a0;
	unsigned int port_0x1bc43a0;
	unsigned int oldport_0x1bc44f0;
	unsigned int port_0x1bc44f0;
	unsigned int oldport_0x1bc4640;
	unsigned int port_0x1bc4640;
	unsigned int oldport_0x1bc4790;
	unsigned int port_0x1bc4790;
	unsigned int oldport_0x1bc48e0;
	unsigned int port_0x1bc48e0;
	unsigned int oldport_0x1bc4a30;
	unsigned int port_0x1bc4a30;
	unsigned int oldport_0x1bc4b80;
	unsigned int port_0x1bc4b80;
	unsigned int oldport_0x1bc4cd0;
	unsigned int port_0x1bc4cd0;
	unsigned int oldport_0x1bc4e20;
	unsigned int port_0x1bc4e20;
	unsigned int oldport_0x1bc4f70;
	unsigned int port_0x1bc4f70;
	unsigned int oldport_0x1bc50c0;
	unsigned int port_0x1bc50c0;
	unsigned int oldport_0x1bc5210;
	unsigned int port_0x1bc5210;
	unsigned int oldport_0x1bc5360;
	unsigned int port_0x1bc5360;
	unsigned int oldport_0x1bc54b0;
	unsigned int port_0x1bc54b0;
	unsigned int oldport_0x1bc5600;
	unsigned int port_0x1bc5600;
	unsigned int oldport_0x1bc5750;
	unsigned int port_0x1bc5750;
	unsigned int oldport_0x1bc58a0;
	unsigned int port_0x1bc58a0;
	unsigned int oldport_0x1bc59f0;
	unsigned int port_0x1bc59f0;
	unsigned int oldport_0x1bc5b40;
	unsigned int port_0x1bc5b40;
	unsigned int oldport_0x1bc5c90;
	unsigned int port_0x1bc5c90;
	unsigned int oldport_0x1bc5de0;
	unsigned int port_0x1bc5de0;
	unsigned int oldport_0x1bc5f30;
	unsigned int port_0x1bc5f30;
	unsigned int oldport_0x1bc6080;
	unsigned int port_0x1bc6080;
	unsigned int oldport_0x1bc61d0;
	unsigned int port_0x1bc61d0;
	unsigned int oldport_0x1bc6320;
	unsigned int port_0x1bc6320;
	unsigned int oldport_0x1bc6470;
	unsigned int port_0x1bc6470;
	unsigned int oldport_0x1bc65c0;
	unsigned int port_0x1bc65c0;
	unsigned int oldport_0x1bc6710;
	unsigned int port_0x1bc6710;
	unsigned int oldport_0x1bc6860;
	unsigned int port_0x1bc6860;
	unsigned int oldport_0x1bc69b0;
	unsigned int port_0x1bc69b0;
	unsigned int oldport_0x1bc6b00;
	unsigned int port_0x1bc6b00;
	unsigned int oldport_0x1bc6c50;
	unsigned int port_0x1bc6c50;
	unsigned int oldport_0x1bc6da0;
	unsigned int port_0x1bc6da0;
	unsigned int oldport_0x1bc6ef0;
	unsigned int port_0x1bc6ef0;
	unsigned int oldport_0x1bc7040;
	unsigned int port_0x1bc7040;
	unsigned int oldport_0x1bc7190;
	unsigned int port_0x1bc7190;
	unsigned int oldport_0x1bc72e0;
	unsigned int port_0x1bc72e0;
	unsigned int oldport_0x1bc7430;
	unsigned int port_0x1bc7430;
	unsigned int oldport_0x1bc7580;
	unsigned int port_0x1bc7580;
	unsigned int oldport_0x1bc76d0;
	unsigned int port_0x1bc76d0;
	unsigned int oldport_0x1bc7820;
	unsigned int port_0x1bc7820;
	unsigned int oldport_0x1bc7970;
	unsigned int port_0x1bc7970;
	unsigned int oldport_0x1bc7ac0;
	unsigned int port_0x1bc7ac0;
	unsigned int oldport_0x1bc7c10;
	unsigned int port_0x1bc7c10;
	unsigned int oldport_0x1bc7d60;
	unsigned int port_0x1bc7d60;
	unsigned int oldport_0x1bc7eb0;
	unsigned int port_0x1bc7eb0;
	unsigned int oldport_0x1bc8000;
	unsigned int port_0x1bc8000;
	unsigned int oldport_0x1bc8150;
	unsigned int port_0x1bc8150;
	unsigned int oldport_0x1bc82a0;
	unsigned int port_0x1bc82a0;
	unsigned int oldport_0x1bc83f0;
	unsigned int port_0x1bc83f0;
	unsigned int oldport_0x1bc8540;
	unsigned int port_0x1bc8540;
	unsigned int oldport_0x1bc8690;
	unsigned int port_0x1bc8690;
	unsigned int oldport_0x1bc87e0;
	unsigned int port_0x1bc87e0;
	unsigned int oldport_0x1bc8930;
	unsigned int port_0x1bc8930;
	unsigned int oldport_0x1bc8a80;
	unsigned int port_0x1bc8a80;
	unsigned int oldport_0x1bc8bd0;
	unsigned int port_0x1bc8bd0;
	unsigned int oldport_0x1bc8d20;
	unsigned int port_0x1bc8d20;
	unsigned int oldport_0x1bc8e70;
	unsigned int port_0x1bc8e70;
	unsigned int oldport_0x1bc8fc0;
	unsigned int port_0x1bc8fc0;
	unsigned int oldport_0x1bb6b50;
	unsigned int port_0x1bb6b50;
	unsigned int oldport_0x1bb8250;
	unsigned int port_0x1bb8250;
	unsigned int oldport_0x1bb82b0;
	unsigned int port_0x1bb82b0;
	unsigned int oldport_0x1bc91c0;
	unsigned int port_0x1bc91c0;
	unsigned int oldport_0x1bc9310;
	unsigned int port_0x1bc9310;
	unsigned int oldport_0x1bc9460;
	unsigned int port_0x1bc9460;
	unsigned int oldport_0x1bc95b0;
	unsigned int port_0x1bc95b0;
	unsigned int oldport_0x1bc9700;
	unsigned int port_0x1bc9700;
	unsigned int oldport_0x1bc9850;
	unsigned int port_0x1bc9850;
	unsigned int oldport_0x1bc99a0;
	unsigned int port_0x1bc99a0;
	unsigned int oldport_0x1bc9af0;
	unsigned int port_0x1bc9af0;
	unsigned int oldport_0x1bc9c40;
	unsigned int port_0x1bc9c40;
	unsigned int oldport_0x1bc9d90;
	unsigned int port_0x1bc9d90;
	unsigned int oldport_0x1bc9ee0;
	unsigned int port_0x1bc9ee0;
	unsigned int oldport_0x1bca030;
	unsigned int port_0x1bca030;
	unsigned int oldport_0x1bca180;
	unsigned int port_0x1bca180;
	unsigned int oldport_0x1bca2d0;
	unsigned int port_0x1bca2d0;
	unsigned int oldport_0x1bca420;
	unsigned int port_0x1bca420;
	unsigned int oldport_0x1bca570;
	unsigned int port_0x1bca570;
	unsigned int oldport_0x1bca6c0;
	unsigned int port_0x1bca6c0;
	unsigned int oldport_0x1bca810;
	unsigned int port_0x1bca810;
	unsigned int oldport_0x1bca960;
	unsigned int port_0x1bca960;
	unsigned int oldport_0x1bcaab0;
	unsigned int port_0x1bcaab0;
	unsigned int oldport_0x1bcac00;
	unsigned int port_0x1bcac00;
	unsigned int oldport_0x1bcad50;
	unsigned int port_0x1bcad50;
	unsigned int oldport_0x1bcaea0;
	unsigned int port_0x1bcaea0;
	unsigned int oldport_0x1bcaff0;
	unsigned int port_0x1bcaff0;
	unsigned int oldport_0x1bcb140;
	unsigned int port_0x1bcb140;
	unsigned int oldport_0x1bcb290;
	unsigned int port_0x1bcb290;
	unsigned int oldport_0x1bcb3e0;
	unsigned int port_0x1bcb3e0;
	unsigned int oldport_0x1bcb530;
	unsigned int port_0x1bcb530;
	unsigned int oldport_0x1bcb680;
	unsigned int port_0x1bcb680;
	unsigned int oldport_0x1bcb7d0;
	unsigned int port_0x1bcb7d0;
	unsigned int oldport_0x1bcb920;
	unsigned int port_0x1bcb920;
	unsigned int oldport_0x1bcba70;
	unsigned int port_0x1bcba70;
	unsigned int oldport_0x1bcbbc0;
	unsigned int port_0x1bcbbc0;
	unsigned int oldport_0x1bcbd10;
	unsigned int port_0x1bcbd10;
	unsigned int oldport_0x1bcbe60;
	unsigned int port_0x1bcbe60;
	unsigned int oldport_0x1bcbfb0;
	unsigned int port_0x1bcbfb0;
	unsigned int oldport_0x1bcc100;
	unsigned int port_0x1bcc100;
	unsigned int oldport_0x1bcc250;
	unsigned int port_0x1bcc250;
	unsigned int oldport_0x1bcc3a0;
	unsigned int port_0x1bcc3a0;
	unsigned int oldport_0x1bcc4f0;
	unsigned int port_0x1bcc4f0;
	unsigned int oldport_0x1bcc640;
	unsigned int port_0x1bcc640;
	unsigned int oldport_0x1bcc790;
	unsigned int port_0x1bcc790;
	unsigned int oldport_0x1bcc8e0;
	unsigned int port_0x1bcc8e0;
	unsigned int oldport_0x1bcca30;
	unsigned int port_0x1bcca30;
	unsigned int oldport_0x1bccb80;
	unsigned int port_0x1bccb80;
	unsigned int oldport_0x1bcccd0;
	unsigned int port_0x1bcccd0;
	unsigned int oldport_0x1bcce20;
	unsigned int port_0x1bcce20;
	unsigned int oldport_0x1bccf70;
	unsigned int port_0x1bccf70;
	unsigned int oldport_0x1bcd0c0;
	unsigned int port_0x1bcd0c0;
	unsigned int oldport_0x1bcd210;
	unsigned int port_0x1bcd210;
	unsigned int oldport_0x1bcd360;
	unsigned int port_0x1bcd360;
	unsigned int oldport_0x1bcd4b0;
	unsigned int port_0x1bcd4b0;
	unsigned int oldport_0x1bcd600;
	unsigned int port_0x1bcd600;
	unsigned int oldport_0x1bcd750;
	unsigned int port_0x1bcd750;
	unsigned int oldport_0x1bcd8a0;
	unsigned int port_0x1bcd8a0;
	unsigned int oldport_0x1bcd9f0;
	unsigned int port_0x1bcd9f0;
	unsigned int oldport_0x1bcdb40;
	unsigned int port_0x1bcdb40;
	unsigned int oldport_0x1bcdc90;
	unsigned int port_0x1bcdc90;
	unsigned int oldport_0x1bcdde0;
	unsigned int port_0x1bcdde0;
	unsigned int oldport_0x1bcdf30;
	unsigned int port_0x1bcdf30;
	unsigned int oldport_0x1bce080;
	unsigned int port_0x1bce080;
	unsigned int oldport_0x1bce1d0;
	unsigned int port_0x1bce1d0;
	unsigned int oldport_0x1bce320;
	unsigned int port_0x1bce320;
	unsigned int oldport_0x1bce470;
	unsigned int port_0x1bce470;
	unsigned int oldport_0x1bce5c0;
	unsigned int port_0x1bce5c0;
	unsigned int oldport_0x1bce710;
	unsigned int port_0x1bce710;
	unsigned int oldport_0x1bce860;
	unsigned int port_0x1bce860;
	unsigned int oldport_0x1bce9b0;
	unsigned int port_0x1bce9b0;
	unsigned int oldport_0x1bceb00;
	unsigned int port_0x1bceb00;
	unsigned int oldport_0x1bcec50;
	unsigned int port_0x1bcec50;
	unsigned int oldport_0x1bceda0;
	unsigned int port_0x1bceda0;
	unsigned int oldport_0x1bceef0;
	unsigned int port_0x1bceef0;
	unsigned int oldport_0x1bcf040;
	unsigned int port_0x1bcf040;
	unsigned int oldport_0x1bcf190;
	unsigned int port_0x1bcf190;
	unsigned int oldport_0x1bcf2e0;
	unsigned int port_0x1bcf2e0;
	unsigned int oldport_0x1bcf430;
	unsigned int port_0x1bcf430;
	unsigned int oldport_0x1bcf580;
	unsigned int port_0x1bcf580;
	unsigned int oldport_0x1bcf6d0;
	unsigned int port_0x1bcf6d0;
	unsigned int oldport_0x1bcf820;
	unsigned int port_0x1bcf820;
	unsigned int oldport_0x1bcf970;
	unsigned int port_0x1bcf970;
	unsigned int oldport_0x1bcfac0;
	unsigned int port_0x1bcfac0;
	unsigned int oldport_0x1bcfc10;
	unsigned int port_0x1bcfc10;
	unsigned int oldport_0x1bcfd60;
	unsigned int port_0x1bcfd60;
	unsigned int oldport_0x1bcfeb0;
	unsigned int port_0x1bcfeb0;
};

/* Backing pixmap for drawing area */
static GdkPixmap *pixmap;
/* drawing are */
static GtkWidget *darea;

#ifdef DEBUG
static void
printlogic(unsigned int val)
{
	char c;

	switch (val) {
		case SIG_STD_LOGIC_U: c = 'U'; break;
		case SIG_STD_LOGIC_X: c = 'X'; break;
		case SIG_STD_LOGIC_0: c = '0'; break;
		case SIG_STD_LOGIC_1: c = '1'; break;
		case SIG_STD_LOGIC_Z: c = 'Z'; break;
		case SIG_STD_LOGIC_W: c = 'W'; break;
		case SIG_STD_LOGIC_L: c = 'L'; break;
		case SIG_STD_LOGIC_H: c = 'H'; break;
		default: c = '?'; break;
	};

	fprintf(stderr, "%c\n", c);
}
#endif /* DEBUG */

/* Create a new backing pixmap of the appropriate size */
static gboolean
create_pixmap(GtkWidget *widget)
{
	pixmap = gdk_pixmap_new(widget->window,
				widget->allocation.width,
				widget->allocation.height,
				-1);
	/* clear screen */
	gdk_draw_rectangle (pixmap,
				widget->style->white_gc,
				TRUE,
				0, 0,
				widget->allocation.width,
				widget->allocation.height);

	return TRUE;
}

static void
draw_line(struct cpssp *cpssp, GtkWidget *widget, int x1, int y1, int x2, int y2, unsigned int val)
{
	/* set color */
	GdkColor color;
	if (val == SIG_STD_LOGIC_1){
		color = cpssp->gdk_green;
	} else if(val == SIG_STD_LOGIC_0) {
		color = cpssp->gdk_red;
	} else if(val == SIG_STD_LOGIC_Z) {
		color = cpssp->gdk_blue;
	} else {
		color = cpssp->gdk_black;
	}
	gtk_widget_modify_fg (widget, GTK_STATE_NORMAL, &color);

	/* draw a line acoording to the color set */
	gdk_draw_line (pixmap,
				widget->style->fg_gc[gtk_widget_get_state (widget)],
				x1,
				y1,
				x2,
				y2);
}

static void
draw_text(GtkWidget *widget, int x, int y, const char* text) {

	gdk_draw_text (pixmap,
				/* https://wiki.archlinux.org/index.php/X_Logical_Font_Description XLFD-stye
				 * annotation*/
				gdk_fontset_load("-adobe-helvetica-bold-r-normal--12-120-75-75-p-70-iso8859-1"),
				widget->style->fg_gc[gtk_widget_get_state (widget)],
				x,
				y,
				text,
				strlen(text));
}

static void
draw_box(struct cpssp *cpssp, GtkWidget *widget, int x0, int y0, int x1, int y1) {

	GdkColor color = cpssp->gdk_black;
	gtk_widget_modify_fg (widget, GTK_STATE_NORMAL, &color);
	gdk_draw_rectangle (pixmap,
				widget->style->fg_gc[gtk_widget_get_state (widget)],
				FALSE,
				x0,
				y0,
				x1 - x0,
				y1 - y0);
}

static void
draw_circle(struct cpssp *cpssp, GtkWidget *widget, int x, int y, int r, gboolean filled) {

	GdkColor color = cpssp->gdk_black;
	gtk_widget_modify_fg (widget, GTK_STATE_NORMAL, &color);
	gdk_draw_arc (pixmap,
				widget->style->fg_gc[gtk_widget_get_state (widget)],
				filled,
				x - r,
				y - r,
				2 * r,
				2 * r,
				0,
				64 * 360);
}

/* draw ports */
static void
COMP_(draw_Uhr1)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 354.105160, 436.645650, 354.105160, 436.645650, val);
}

static void
COMP_(draw_Uhr2)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 354.105160, 468.632970, 354.105160, 468.632970, val);
}

static void
COMP_(draw_Imp1)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 360.839330, 618.468270, 360.839330, 618.468270, val);
}

static void
COMP_(draw_Imp2)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 362.522870, 661.679200, 362.522870, 661.679200, val);
}

static void
COMP_(draw_22I1)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I2)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I3)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I4)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I5)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I6)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I7)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I8)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I9)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22I0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II1)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II2)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II3)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II4)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 874.144440, 3971.765800, 874.144440, 3971.765800, val);
}

static void
COMP_(draw_22II5)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II6)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 876.228210, 4020.734500, 876.228210, 4020.734500, val);
}

static void
COMP_(draw_22II7)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II8)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 875.186320, 4067.619500, 875.186320, 4067.619500, val);
}

static void
COMP_(draw_22II9)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22II0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 874.144440, 3929.048300, 874.144440, 3929.048300, val);
}

static void
COMP_(draw_22III1)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III2)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III3)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III4)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III5)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III6)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III7)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III8)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III9)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_22III0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 874.144440, 4107.211300, 874.144440, 4107.211300, val);
}

static void
COMP_(draw_30I1)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30I2)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30I3)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 914.108710, 639.316250, 914.108710, 639.316250, val);
}

static void
COMP_(draw_30I4)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1649.769100, 608.555830, 1649.769100, 608.555830, val);
}

static void
COMP_(draw_30I5)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1648.415700, 462.390890, 1648.415700, 462.390890, val);
}

static void
COMP_(draw_30I6)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1444.970600, 324.113770, 1444.970600, 324.113770, val);
}

static void
COMP_(draw_30I7)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 733.489490, 3499.790300, 733.489490, 3499.790300, val);
}

static void
COMP_(draw_30I8)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 729.321940, 1976.549300, 729.321940, 1976.549300, val);
	draw_line(cpssp, darea, 734.531380, 2741.295500, 734.531380, 2741.295500, val);
}

static void
COMP_(draw_30I9)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30I0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 717.861160, 1207.635600, 717.861160, 1207.635600, val);
}

static void
COMP_(draw_30II1)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 872.060660, 3602.937200, 872.060660, 3602.937200, val);
	draw_line(cpssp, darea, 1205.041600, 4398.026400, 1205.041600, 4398.026400, val);
}

static void
COMP_(draw_30II2)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 3136.084300, 921.116290, 3136.084300, 921.116290, val);
	draw_line(cpssp, darea, 872.060660, 3646.696600, 872.060660, 3646.696600, val);
}

static void
COMP_(draw_30II3)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 875.186320, 3696.707200, 875.186320, 3696.707200, val);
}

static void
COMP_(draw_30II4)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 875.186320, 3744.634100, 875.186320, 3744.634100, val);
	draw_line(cpssp, darea, 1838.869100, 567.654730, 1838.869100, 567.654730, val);
}

static void
COMP_(draw_30II5)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 872.060660, 3784.225800, 872.060660, 3784.225800, val);
	draw_line(cpssp, darea, 2247.015600, 882.973630, 2247.015600, 882.973630, val);
}

static void
COMP_(draw_30II6)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 875.186320, 3831.110800, 875.186320, 3831.110800, val);
}

static void
COMP_(draw_30II7)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 733.489490, 3122.626700, 733.489490, 3122.626700, val);
}

static void
COMP_(draw_30II8)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 724.112490, 1598.343800, 724.112490, 1598.343800, val);
	draw_line(cpssp, darea, 731.405710, 2361.006200, 731.405710, 2361.006200, val);
}

static void
COMP_(draw_30II9)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30II0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 3034.812400, 4500.377700, 3034.812400, 4500.377700, val);
}

static void
COMP_(draw_30III1)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30III2)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30III3)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30III4)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30III5)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30III6)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2271.606900, 1732.118500, 2271.606900, 1732.118500, val);
}

static void
COMP_(draw_30III7)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2565.541400, 4765.911700, 2565.541400, 4765.911700, val);
}

static void
COMP_(draw_30III8)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 3171.508500, 1237.850400, 3171.508500, 1237.850400, val);
}

static void
COMP_(draw_30III9)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_30III0)(void *_cpssp, unsigned int val) {
	return;
}

/* draw gui ports */
static void
COMP_(draw_0x1bb8760)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 3106.038500, 521.977690, 3312.321875, 524.924597, val);
	draw_line(cpssp, darea, 3312.321875, 524.924597, 3397.171900, 523.272380, val);
	draw_line(cpssp, darea, 3312.321875, 524.924597, 3305.912200, 1342.039200, val);
	draw_line(cpssp, darea, 3305.912200, 1342.039200, 2849.565000, 1339.955500, val);
	draw_line(cpssp, darea, 2849.565000, 1339.955500, 2850.606900, 1283.693500, val);
	draw_line(cpssp, darea, 2898.533800, 916.948740, 3136.084300, 921.116290, val);
	draw_line(cpssp, darea, 878.311990, 3875.912000, 937.115975, 3877.029737, val);
	draw_line(cpssp, darea, 937.115975, 3877.029737, 1034.363855, 3877.029737, val);
	draw_line(cpssp, darea, 1123.155800, 3756.094800, 1035.637200, 3755.053000, val);
	draw_line(cpssp, darea, 1035.637200, 3755.053000, 1034.363855, 3877.029737, val);
	draw_line(cpssp, darea, 1034.363855, 3877.029737, 1037.720900, 3998.854900, val);
	draw_line(cpssp, darea, 1037.720900, 3998.854900, 1126.281400, 3996.771100, val);
	draw_line(cpssp, darea, 872.060660, 3602.937200, 938.741520, 3603.979100, val);
	draw_line(cpssp, darea, 938.741520, 3603.979100, 935.642515, 3641.277337, val);
	draw_line(cpssp, darea, 935.642515, 3641.277337, 938.589425, 3695.795037, val);
	draw_line(cpssp, darea, 938.589425, 3695.795037, 935.642515, 3744.419037, val);
	draw_line(cpssp, darea, 935.642515, 3744.419037, 937.115975, 3785.675737, val);
	draw_line(cpssp, darea, 937.115975, 3785.675737, 938.589425, 3828.405837, val);
	draw_line(cpssp, darea, 938.589425, 3828.405837, 937.115975, 3877.029737, val);
	draw_line(cpssp, darea, 937.115975, 3877.029737, 938.589425, 3928.600637, val);
	draw_line(cpssp, darea, 938.589425, 3928.600637, 937.115975, 3971.330737, val);
	draw_line(cpssp, darea, 937.115975, 3971.330737, 938.589425, 4018.481237, val);
	draw_line(cpssp, darea, 938.589425, 4018.481237, 938.589425, 4065.631737, val);
	draw_line(cpssp, darea, 938.589425, 4065.631737, 940.825300, 4109.295000, val);
	draw_line(cpssp, darea, 940.825300, 4109.295000, 874.144440, 4107.211300, val);
	draw_line(cpssp, darea, 872.060660, 3646.696600, 935.642515, 3641.277337, val);
	draw_line(cpssp, darea, 875.186320, 3696.707200, 938.589425, 3695.795037, val);
	draw_line(cpssp, darea, 875.186320, 3744.634100, 935.642515, 3744.419037, val);
	draw_line(cpssp, darea, 872.060660, 3784.225800, 937.115975, 3785.675737, val);
	draw_line(cpssp, darea, 875.186320, 3831.110800, 938.589425, 3828.405837, val);
	draw_line(cpssp, darea, 874.144440, 3929.048300, 938.589425, 3928.600637, val);
	draw_line(cpssp, darea, 874.144440, 3971.765800, 937.115975, 3971.330737, val);
	draw_line(cpssp, darea, 876.228210, 4020.734500, 938.589425, 4018.481237, val);
	draw_line(cpssp, darea, 875.186320, 4067.619500, 938.589425, 4065.631737, val);
	draw_line(cpssp, darea, 2337.997800, 518.947340, 2446.354200, 518.947340, val);
	draw_line(cpssp, darea, 2448.878600, 885.920540, 2247.015600, 882.973630, val);
	draw_line(cpssp, darea, 1838.869100, 567.654730, 1844.762900, 692.898220, val);
	draw_line(cpssp, darea, 1205.041600, 4398.026400, 1292.909300, 4396.095200, val);
}

static void
COMP_(draw_0x1bb9650)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 3093.366900, 1238.892300, 3171.508500, 1237.850400, val);
}

static void
COMP_(draw_0x1bb9630)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 717.861160, 1207.635600, 1019.629325, 1213.027067, val);
	draw_line(cpssp, darea, 1105.443700, 1096.153600, 1017.925000, 1094.069800, val);
	draw_line(cpssp, darea, 1017.925000, 1094.069800, 1019.629325, 1213.027067, val);
	draw_line(cpssp, darea, 1019.629325, 1213.027067, 1023.134500, 1339.955500, val);
	draw_line(cpssp, darea, 1023.134500, 1339.955500, 1110.653100, 1339.955500, val);
}

static void
COMP_(draw_0x1bb69a0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1176.292100, 1342.039200, 1294.025500, 1340.997300, val);
}

static void
COMP_(draw_0x1bb82f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1171.082700, 1097.195400, 1294.025500, 1097.195400, val);
}

static void
COMP_(draw_0x1bb81b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1355.496900, 1097.195400, 1596.173200, 1103.446800, val);
}

static void
COMP_(draw_0x1bb8f00)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1538.869300, 1027.388900, 1606.592000, 1081.567100, val);
}

static void
COMP_(draw_0x1bb3b20)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1538.869300, 1268.065200, 1608.675800, 1328.494700, val);
}

static void
COMP_(draw_0x1bb6a40)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1602.424500, 1344.123000, 1353.413100, 1344.123000, val);
}

static void
COMP_(draw_0x1bb8550)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1110.653100, 1477.484700, 1023.134500, 1477.484700, val);
	draw_line(cpssp, darea, 1023.134500, 1477.484700, 1021.102785, 1600.545157, val);
	draw_line(cpssp, darea, 1021.102785, 1600.545157, 1026.260200, 1720.244800, val);
	draw_line(cpssp, darea, 1026.260200, 1720.244800, 1112.736900, 1719.202900, val);
	draw_line(cpssp, darea, 1021.102785, 1600.545157, 724.112490, 1598.343800, val);
	draw_line(cpssp, darea, 731.405710, 2361.006200, 1028.470045, 2356.426437, val);
	draw_line(cpssp, darea, 1118.988200, 2241.189000, 1029.385800, 2238.063300, val);
	draw_line(cpssp, darea, 1029.385800, 2238.063300, 1028.470045, 2356.426437, val);
	draw_line(cpssp, darea, 1028.470045, 2356.426437, 1028.343900, 2480.823300, val);
	draw_line(cpssp, darea, 1028.343900, 2480.823300, 1117.946300, 2484.990900, val);
}

static void
COMP_(draw_0x1bb6980)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1175.250200, 1719.202900, 1299.234900, 1721.286600, val);
}

static void
COMP_(draw_0x1bb8190)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1174.208300, 1477.484700, 1292.983600, 1481.652300, val);
}

static void
COMP_(draw_0x1bb6640)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1601.382600, 1479.568500, 1355.496900, 1476.442800, val);
}

static void
COMP_(draw_0x1bbe9b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1544.078700, 1405.594400, 1611.801500, 1459.772600, val);
}

static void
COMP_(draw_0x1bbe9d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1543.036800, 1649.396300, 1609.717700, 1703.574500, val);
}

static void
COMP_(draw_0x1bbe9f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1355.496900, 1722.328500, 1599.298800, 1722.328500, val);
}

static void
COMP_(draw_0x1bbea10)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 729.321940, 1976.549300, 1028.470045, 1976.275637, val);
	draw_line(cpssp, darea, 1114.820700, 1858.815900, 1027.302000, 1858.815900, val);
	draw_line(cpssp, darea, 1027.302000, 1858.815900, 1028.470045, 1976.275637, val);
	draw_line(cpssp, darea, 1028.470045, 1976.275637, 1027.302000, 2098.450300, val);
	draw_line(cpssp, darea, 1027.302000, 2098.450300, 1114.820700, 2100.534100, val);
	draw_line(cpssp, darea, 1118.988200, 2621.478300, 1031.469600, 2620.436400, val);
	draw_line(cpssp, darea, 1031.469600, 2620.436400, 1028.470045, 2736.577237, val);
	draw_line(cpssp, darea, 1028.470045, 2736.577237, 1033.553400, 2861.112600, val);
	draw_line(cpssp, darea, 1033.553400, 2861.112600, 1118.988200, 2862.154500, val);
	draw_line(cpssp, darea, 1028.470045, 2736.577237, 734.531380, 2741.295500, val);
}

static void
COMP_(draw_0x1bbea30)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1181.501500, 2100.534100, 1302.360600, 2097.408400, val);
}

static void
COMP_(draw_0x1bbea50)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1177.334000, 1856.732100, 1296.109300, 1858.815900, val);
}

static void
COMP_(draw_0x1bbea70)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1357.580700, 1859.857800, 1602.424500, 1859.857800, val);
}

static void
COMP_(draw_0x1bbea90)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1610.759600, 1844.229500, 1540.953100, 1784.841800, val);
}

static void
COMP_(draw_0x1bbeab0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1612.843400, 2081.780100, 1546.162500, 2027.601900, val);
}

static void
COMP_(draw_0x1bbead0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1604.508300, 2101.575900, 1357.580700, 2099.492200, val);
}

static void
COMP_(draw_0x1bbeaf0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1176.292100, 2479.781500, 1299.234900, 2480.823300, val);
}

static void
COMP_(draw_0x1bbeb10)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1180.459600, 2238.063300, 1301.318700, 2239.105200, val);
}

static void
COMP_(draw_0x1bbeb30)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1358.622600, 2240.147100, 1607.633900, 2241.189000, val);
}

static void
COMP_(draw_0x1bbeb50)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1614.927100, 2221.393100, 1541.995000, 2162.005500, val);
}

static void
COMP_(draw_0x1bbeb70)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1543.036800, 2403.723600, 1611.801500, 2463.111200, val);
}

static void
COMP_(draw_0x1bbeb90)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1604.508300, 2481.865200, 1361.748200, 2479.781500, val);
}

static void
COMP_(draw_0x1bbebb0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1545.120600, 2547.504200, 1615.969000, 2600.640500, val);
}

static void
COMP_(draw_0x1bbebd0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1360.706400, 2618.352600, 1608.675800, 2617.310700, val);
}

static void
COMP_(draw_0x1bbebf0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1300.276800, 2619.394500, 1188.794800, 2619.394500, val);
}

static void
COMP_(draw_0x1bbec10)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1186.711000, 2857.987000, 1300.276800, 2857.987000, val);
}

static void
COMP_(draw_0x1bbec30)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1363.832000, 2859.028900, 1608.675800, 2856.945100, val);
}

static void
COMP_(draw_0x1bbec50)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1613.885300, 2836.107300, 1549.288200, 2784.012900, val);
}

static void
COMP_(draw_0x1bbec70)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 733.489490, 3122.626700, 1031.416955, 3118.201537, val);
	draw_line(cpssp, darea, 1120.030100, 2997.600000, 1030.427700, 2996.558100, val);
	draw_line(cpssp, darea, 1030.427700, 2996.558100, 1031.416955, 3118.201537, val);
	draw_line(cpssp, darea, 1031.416955, 3118.201537, 1031.469600, 3243.485700, val);
	draw_line(cpssp, darea, 1031.469600, 3243.485700, 1124.197700, 3240.360000, val);
}

static void
COMP_(draw_0x1bbec90)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1186.711000, 3241.401900, 1307.570000, 3239.318200, val);
}

static void
COMP_(draw_0x1bbecb0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1180.459600, 2992.390600, 1302.360600, 2996.558100, val);
}

static void
COMP_(draw_0x1bbecd0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1362.790100, 2994.474400, 1608.675800, 2993.432500, val);
}

static void
COMP_(draw_0x1bbecf0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1613.885300, 2973.636600, 1545.120600, 2917.374600, val);
}

static void
COMP_(draw_0x1bbed10)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1547.204400, 3158.050900, 1617.300100, 3218.132900, val);
}

static void
COMP_(draw_0x1bbed30)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1363.832000, 3237.234400, 1611.280300, 3236.829200, val);
}

static void
COMP_(draw_0x1bbed50)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 733.489490, 3499.790300, 1031.416955, 3496.878937, val);
	draw_line(cpssp, darea, 1122.113900, 3377.889300, 1035.637200, 3378.931200, val);
	draw_line(cpssp, darea, 1035.637200, 3378.931200, 1031.416955, 3496.878937, val);
	draw_line(cpssp, darea, 1031.416955, 3496.878937, 1033.553400, 3620.649300, val);
	draw_line(cpssp, darea, 1033.553400, 3620.649300, 1116.904500, 3617.523700, val);
}

static void
COMP_(draw_0x1bbed70)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1181.501500, 3618.565600, 1305.486300, 3619.607500, val);
}

static void
COMP_(draw_0x1bbed90)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1186.711000, 3372.679900, 1303.402500, 3373.721800, val);
}

static void
COMP_(draw_0x1bbedb0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1364.873900, 3374.763700, 1612.843400, 3371.638000, val);
}

static void
COMP_(draw_0x1bbedd0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1548.246300, 3295.580100, 1618.110500, 3352.536600, val);
}

static void
COMP_(draw_0x1bbedf0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1549.288200, 3538.340200, 1618.110500, 3596.338500, val);
}

static void
COMP_(draw_0x1bbee10)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1550.330100, 3676.911300, 1617.300100, 3734.041400, val);
}

static void
COMP_(draw_0x1bbee30)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1364.179500, 3615.439900, 1612.495900, 3614.687200, val);
}

static void
COMP_(draw_0x1bbee50)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1183.585300, 3995.729200, 1306.528200, 3993.645400, val);
}

static void
COMP_(draw_0x1bbee70)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1367.999600, 3992.603500, 1613.190300, 3990.519800, val);
}

static void
COMP_(draw_0x1bbee90)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1551.371900, 3914.461900, 1618.515700, 3972.460200, val);
}

static void
COMP_(draw_0x1bbeeb0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1189.836600, 3752.969200, 1303.402500, 3752.969200, val);
}

static void
COMP_(draw_0x1bbeed0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1369.041500, 3750.885400, 1613.421800, 3746.717900, val);
}

static void
COMP_(draw_0x1bbeef0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1670.089500, 3989.709400, 1911.865400, 3982.184600, val);
}

static void
COMP_(draw_0x1bbef10)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1666.963800, 3749.033100, 1905.614000, 3743.592200, val);
}

static void
COMP_(draw_0x1bbef30)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1971.253000, 3744.634100, 2086.409175, 3739.998637, val);
	draw_line(cpssp, darea, 2084.935715, 3605.914437, 1968.127300, 3607.104800, val);
	draw_line(cpssp, darea, 2086.409175, 3362.794737, 1966.043600, 3366.428600, val);
	draw_line(cpssp, darea, 1967.085500, 3232.024900, 2084.935715, 3228.710537, val);
	draw_line(cpssp, darea, 1965.001700, 2991.348700, 2083.462265, 2985.590837, val);
	draw_line(cpssp, darea, 1969.169200, 2855.903200, 2084.935715, 2854.453537, val);
	draw_line(cpssp, darea, 1965.001700, 2619.394500, 2083.462265, 2612.807237, val);
	draw_line(cpssp, darea, 1965.001700, 2478.739600, 2083.462265, 2478.723037, val);
	draw_line(cpssp, darea, 2084.935715, 2241.497137, 1963.959800, 2237.021400, val);
	draw_line(cpssp, darea, 1966.043600, 2102.617800, 2083.462265, 2102.992537, val);
	draw_line(cpssp, darea, 1962.639200, 1861.346300, 2083.462265, 1859.872847, val);
	draw_line(cpssp, darea, 2084.935715, 1722.841737, 1960.429000, 1722.841700, val);
	draw_line(cpssp, darea, 1964.849300, 1483.405700, 2083.462265, 1481.195477, val);
	draw_line(cpssp, darea, 1963.375900, 1347.848000, 2081.988815, 1350.058177, val);
	draw_line(cpssp, darea, 2086.409175, 1109.885367, 2081.988815, 1350.058177, val);
	draw_line(cpssp, darea, 2081.988815, 1350.058177, 2083.462265, 1481.195477, val);
	draw_line(cpssp, darea, 2083.462265, 1481.195477, 2084.935715, 1722.841737, val);
	draw_line(cpssp, darea, 2084.935715, 1722.841737, 2083.462265, 1859.872847, val);
	draw_line(cpssp, darea, 2083.462265, 1859.872847, 2083.462265, 2102.992537, val);
	draw_line(cpssp, darea, 2083.462265, 2102.992537, 2084.935715, 2241.497137, val);
	draw_line(cpssp, darea, 2084.935715, 2241.497137, 2083.462265, 2478.723037, val);
	draw_line(cpssp, darea, 2083.462265, 2478.723037, 2083.462265, 2612.807237, val);
	draw_line(cpssp, darea, 2083.462265, 2612.807237, 2084.935715, 2854.453537, val);
	draw_line(cpssp, darea, 2084.935715, 2854.453537, 2083.462265, 2985.590837, val);
	draw_line(cpssp, darea, 2083.462265, 2985.590837, 2084.935715, 3228.710537, val);
	draw_line(cpssp, darea, 2084.935715, 3228.710537, 2086.409175, 3362.794737, val);
	draw_line(cpssp, darea, 2086.409175, 3362.794737, 2084.935715, 3605.914437, val);
	draw_line(cpssp, darea, 2084.935715, 3605.914437, 2086.409175, 3739.998637, val);
	draw_line(cpssp, darea, 2086.409175, 3739.998637, 2090.074900, 3981.644500, val);
	draw_line(cpssp, darea, 2090.074900, 3981.644500, 1973.690100, 3982.381700, val);
	draw_line(cpssp, darea, 1962.639200, 1106.938500, 2086.409175, 1109.885367, val);
	draw_line(cpssp, darea, 2086.409175, 1109.885367, 2490.135300, 1109.885400, val);
	draw_line(cpssp, darea, 2490.135300, 1109.885400, 2490.135300, 1162.929700, val);
}

static void
COMP_(draw_0x1bbef50)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1910.823500, 3606.062900, 1668.063500, 3611.272300, val);
}

static void
COMP_(draw_0x1bbef70)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1908.739700, 3368.512300, 1668.063500, 3366.428600, val);
}

static void
COMP_(draw_0x1bbef90)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1907.697800, 3234.108700, 1664.243400, 3234.745400, val);
}

static void
COMP_(draw_0x1bbefb0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1665.979700, 2994.474400, 1905.614000, 2991.348700, val);
}

static void
COMP_(draw_0x1bbefd0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1664.937800, 2857.987000, 1907.697800, 2854.861300, val);
}

static void
COMP_(draw_0x1bbeff0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1665.979700, 2617.310700, 1903.530300, 2618.352600, val);
}

static void
COMP_(draw_0x1bbf010)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1662.854000, 2480.823300, 1901.446500, 2477.697700, val);
}

static void
COMP_(draw_0x1bbf030)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1904.572100, 2240.147100, 1663.895900, 2239.105200, val);
}

static void
COMP_(draw_0x1bbf050)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1904.572100, 2099.492200, 1667.021600, 2101.575900, val);
}

static void
COMP_(draw_0x1bbf070)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1662.854000, 1859.857800, 1904.437800, 1859.872800, val);
}

static void
COMP_(draw_0x1bbf090)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1901.490900, 1723.578500, 1662.054800, 1724.315200, val);
}

static void
COMP_(draw_0x1bbf0b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1659.844600, 1483.405700, 1905.174500, 1483.405700, val);
}

static void
COMP_(draw_0x1bbf0d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1662.791500, 1344.164400, 1902.227600, 1347.111300, val);
}

static void
COMP_(draw_0x1bbf0f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1656.161000, 1100.307900, 1903.701000, 1106.938500, val);
}

static void
COMP_(draw_0x1bbf110)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 354.105160, 436.645650, 445.016460, 438.329200, val);
}

static void
COMP_(draw_0x1bbf130)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 354.105160, 468.632970, 445.577650, 472.000050, val);
}

static void
COMP_(draw_0x1bbf150)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 360.839330, 618.468270, 447.261190, 620.712990, val);
}

static void
COMP_(draw_0x1bbf170)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 362.522870, 661.679200, 447.822370, 663.923920, val);
}

static void
COMP_(draw_0x1bbf190)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2540.232700, 517.557330, 2854.078075, 519.030787, val);
	draw_line(cpssp, darea, 2854.078075, 519.030787, 3008.790700, 523.451140, val);
	draw_line(cpssp, darea, 2855.551600, 436.517430, 2854.078075, 519.030787, val);
	draw_line(cpssp, darea, 2854.078075, 519.030787, 2855.551600, 869.712550, val);
	draw_line(cpssp, darea, 2919.908600, 4562.174700, 3034.812400, 4557.346800, val);
}

static void
COMP_(draw_0x1bbf1b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2537.285800, 884.447080, 2806.927600, 885.920540, val);
}

static void
COMP_(draw_0x1bbf1d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2538.759200, 1173.243800, 2849.657800, 1174.717300, val);
	draw_line(cpssp, darea, 2849.657800, 1174.717300, 2852.604700, 964.013540, val);
}

static void
COMP_(draw_0x1bbf1f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2898.281700, 1238.075800, 2999.949900, 1241.022700, val);
}

static void
COMP_(draw_0x1bbf210)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2808.401100, 1236.602300, 2538.759200, 1235.128900, val);
}

static void
COMP_(draw_0x1bbf230)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2382.573200, 1238.075800, 2270.590800, 1238.075800, val);
	draw_line(cpssp, darea, 2270.590800, 1238.075800, 2272.064200, 1403.102500, val);
}

static void
COMP_(draw_0x1bbf250)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1841.816000, 818.141710, 1840.342555, 1027.372007, val);
	draw_line(cpssp, darea, 1840.342555, 1027.372007, 1843.289455, 1273.438627, val);
	draw_line(cpssp, darea, 1843.289455, 1273.438627, 1843.289455, 1410.469737, val);
	draw_line(cpssp, darea, 1843.289455, 1410.469737, 1841.816005, 1650.642547, val);
	draw_line(cpssp, darea, 1841.816005, 1650.642547, 1846.236365, 1789.147117, val);
	draw_line(cpssp, darea, 1846.236365, 1789.147117, 1843.289455, 2029.319937, val);
	draw_line(cpssp, darea, 1843.289455, 2029.319937, 1843.289455, 2169.297937, val);
	draw_line(cpssp, darea, 1843.289455, 2169.297937, 1847.709815, 2406.523837, val);
	draw_line(cpssp, darea, 1847.709815, 2406.523837, 1847.709815, 2552.395637, val);
	draw_line(cpssp, darea, 1847.709815, 2552.395637, 1844.762905, 2780.780837, val);
	draw_line(cpssp, darea, 1844.762905, 2780.780837, 1847.709815, 2923.705837, val);
	draw_line(cpssp, darea, 1847.709815, 2923.705837, 1847.709815, 3159.458237, val);
	draw_line(cpssp, darea, 1847.709815, 3159.458237, 1849.183265, 3296.489337, val);
	draw_line(cpssp, darea, 1849.183265, 3296.489337, 1847.709815, 3532.241837, val);
	draw_line(cpssp, darea, 1847.709815, 3532.241837, 1850.656725, 3678.113637, val);
	draw_line(cpssp, darea, 1850.656725, 3678.113637, 1852.130200, 3909.445700, val);
	draw_line(cpssp, darea, 1852.130200, 3909.445700, 1922.855900, 3965.436900, val);
	draw_line(cpssp, darea, 1850.656725, 3678.113637, 1919.909000, 3725.264100, val);
	draw_line(cpssp, darea, 1847.709815, 3532.241837, 1918.435600, 3591.179900, val);
	draw_line(cpssp, darea, 1849.183265, 3296.489337, 1918.435600, 3348.060200, val);
	draw_line(cpssp, darea, 1847.709815, 3159.458237, 1916.962100, 3212.502500, val);
	draw_line(cpssp, darea, 1912.541800, 2975.276600, 1847.709815, 2923.705837, val);
	draw_line(cpssp, darea, 1844.762905, 2780.780837, 1918.435600, 2838.245500, val);
	draw_line(cpssp, darea, 1847.709815, 2552.395637, 1916.962100, 2603.966500, val);
	draw_line(cpssp, darea, 1847.709815, 2406.523837, 1916.962100, 2463.988500, val);
	draw_line(cpssp, darea, 1843.289455, 2169.297937, 1912.541800, 2222.342200, val);
	draw_line(cpssp, darea, 1843.289455, 2029.319937, 1915.488700, 2083.837700, val);
	draw_line(cpssp, darea, 1846.236365, 1789.147117, 1911.068300, 1843.664900, val);
	draw_line(cpssp, darea, 1841.816005, 1650.642547, 1912.541800, 1708.107200, val);
	draw_line(cpssp, darea, 1843.289455, 1410.469737, 1914.015200, 1469.407900, val);
	draw_line(cpssp, darea, 1843.289455, 1273.438627, 1909.594900, 1332.376700, val);
	draw_line(cpssp, darea, 1840.342555, 1027.372007, 1912.541800, 1086.310100, val);
}

static void
COMP_(draw_0x1bbf270)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2272.622300, 1490.436600, 2272.622300, 1549.333900, val);
}

static void
COMP_(draw_0x1bbf290)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2273.637800, 1643.772600, 2271.606900, 1732.118500, val);
}

static void
COMP_(draw_0x1bbf2b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1386.570400, 4393.198500, 1535.269400, 4391.267300, val);
}

static void
COMP_(draw_0x1bbf2d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1683.968500, 4372.921400, 1748.662200, 4374.852500, val);
	draw_line(cpssp, darea, 1748.662200, 4374.852500, 1749.424255, 4425.375737, val);
	draw_line(cpssp, darea, 1749.424255, 4425.375737, 1755.214915, 5070.713137, val);
	draw_line(cpssp, darea, 1749.424255, 4425.375737, 1685.899600, 4424.097000, val);
	draw_line(cpssp, darea, 2327.043600, 5000.547200, 2565.908075, 4996.077937, val);
	draw_line(cpssp, darea, 2566.507000, 4918.473100, 2565.908075, 4996.077937, val);
	draw_line(cpssp, darea, 2565.908075, 4996.077937, 2569.403700, 5054.619600, val);
	draw_line(cpssp, darea, 2569.403700, 5054.619600, 1755.214915, 5070.713137, val);
	draw_line(cpssp, darea, 1755.214915, 5070.713137, 1641.483000, 5072.965600, val);
	draw_line(cpssp, darea, 1641.483000, 5072.965600, 1636.655100, 4685.768700, val);
}

static void
COMP_(draw_0x1bbf2f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1683.002900, 4619.143800, 1932.122100, 4617.212600, val);
}

static void
COMP_(draw_0x1bbf310)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1684.934000, 4447.270900, 1915.707200, 4442.443000, val);
}

static void
COMP_(draw_0x1bbf330)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1686.865200, 4401.888700, 1911.844900, 4397.060800, val);
}

static void
COMP_(draw_0x1bbf350)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2060.544000, 4370.024600, 2368.563400, 4367.127900, val);
}

static void
COMP_(draw_0x1bbf370)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2061.509500, 4423.131400, 2200.552800, 4421.200300, val);
}

static void
COMP_(draw_0x1bbf390)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2288.420400, 4463.685700, 2601.267800, 4460.789000, val);
	draw_line(cpssp, darea, 2601.267800, 4460.789000, 2604.164500, 4517.758100, val);
}

static void
COMP_(draw_0x1bbf3b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2412.014400, 4432.787200, 2410.083300, 4501.343300, val);
	draw_line(cpssp, darea, 2410.083300, 4501.343300, 2400.427500, 4500.377700, val);
}

static void
COMP_(draw_0x1bbf3d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2451.603200, 4417.338000, 2607.061300, 4418.303500, val);
}

static void
COMP_(draw_0x1bbf3f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2605.130100, 4355.540900, 2533.677300, 4359.403300, val);
	draw_line(cpssp, darea, 2533.677300, 4359.403300, 2535.608500, 4522.586000, val);
	draw_line(cpssp, darea, 2535.608500, 4522.586000, 2249.797300, 4531.276200, val);
	draw_line(cpssp, darea, 2249.797300, 4531.276200, 2245.935000, 4485.894000, val);
}

static void
COMP_(draw_0x1bbf410)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2561.679100, 4565.071400, 2412.980000, 4565.071400, val);
	draw_line(cpssp, darea, 2412.980000, 4565.071400, 2412.980000, 4599.832200, val);
}

static void
COMP_(draw_0x1bbf430)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2367.597800, 4655.835800, 2047.991400, 4661.629200, val);
}

static void
COMP_(draw_0x1bbf450)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2412.014400, 4694.458900, 2416.842300, 4844.123500, val);
	draw_line(cpssp, darea, 2416.842300, 4844.123500, 2053.784900, 4852.813700, val);
}

static void
COMP_(draw_0x1bbf470)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1929.225300, 4859.572800, 1802.734600, 4862.469500, val);
	draw_line(cpssp, darea, 1802.734600, 4862.469500, 1797.906700, 5023.721100, val);
	draw_line(cpssp, darea, 1797.906700, 5023.721100, 2233.382500, 5017.927600, val);
}

static void
COMP_(draw_0x1bbf490)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2565.541400, 4765.911700, 2566.507000, 4820.949700, val);
}

static void
COMP_(draw_0x1bbf4b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2655.340200, 4426.993700, 2654.374600, 4533.207300, val);
	draw_line(cpssp, darea, 2654.374600, 4533.207300, 2827.213100, 4533.207300, val);
}

static void
COMP_(draw_0x1bbf4d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2918.943000, 4503.274400, 3034.812400, 4500.377700, val);
}

static void
COMP_(draw_0x1bbf4f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2720.033900, 4414.441200, 3015.500800, 4409.613300, val);
}

static void
COMP_(draw_0x1bbf510)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2720.999500, 4351.678600, 3015.500800, 4343.954000, val);
}

static void
COMP_(draw_0x1bbf530)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1952.008600, 4688.920500, 1953.794500, 4720.174100, val);
}

static void
COMP_(draw_0x1bbf550)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2032.374900, 4687.134600, 2032.374900, 4719.281200, val);
}

static void
COMP_(draw_0x1bbf570)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 2026.124200, 4927.340600, 2027.017200, 4960.380100, val);
}

static void
COMP_(draw_0x1bbf590)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1960.045200, 4928.233600, 1960.045200, 4961.273100, val);
}

static void
COMP_(draw_0x1bbf5b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, -672.637760, 473.879940, -674.239240, 647.543310, val);
}

static void
COMP_(draw_0x1bbf5d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 688.328120, 632.525860, 574.685140, 633.034190, val);
}

static void
COMP_(draw_0x1bbf5f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 914.108710, 639.316250, 781.792150, 636.429390, val);
}

static void
COMP_(draw_0x1bbf610)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 821.589590, 483.137190, 575.533930, 476.855130, val);
}

static void
COMP_(draw_0x1bbf630)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 821.589590, 445.790030, 575.533930, 441.205570, val);
}

static void
COMP_(draw_0x1bbf650)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1183.178100, 508.601170, 948.277010, 502.723470, val);
}

static void
COMP_(draw_0x1bbf670)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1444.970600, 324.113770, 1335.385100, 322.359810, val);
}

static void
COMP_(draw_0x1bbf690)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1459.931700, 459.168850, 1340.641600, 458.223600, val);
}

static void
COMP_(draw_0x1bbf6b0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1339.168600, 499.608810, 1398.040600, 500.285500, val);
	draw_line(cpssp, darea, 1398.040600, 500.285500, 1398.717300, 606.525760, val);
	draw_line(cpssp, darea, 1398.717300, 606.525760, 1462.326100, 607.879140, val);
}

static void
COMP_(draw_0x1bbf6d0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1554.355900, 606.525760, 1649.769100, 608.555830, val);
}

static void
COMP_(draw_0x1bbf6f0)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1553.679200, 460.360820, 1648.415700, 462.390890, val);
}

static void
COMP_(draw_0x1bbf710)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 949.395420, 429.233100, 1138.191776, 432.616547, val);
	draw_line(cpssp, darea, 1138.191776, 432.616547, 1184.206700, 435.323310, val);
	draw_line(cpssp, darea, 1138.191776, 432.616547, 1138.868500, 486.075020, val);
	draw_line(cpssp, darea, 1138.868500, 486.075020, 1182.176600, 486.751710, val);
}

static void
COMP_(draw_0x1bbf730)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 1182.176600, 460.360820, 1092.176900, 458.330750, val);
	draw_line(cpssp, darea, 1092.176900, 458.330750, 1092.853600, 485.398330, val);
	draw_line(cpssp, darea, 1092.853600, 485.398330, 945.335280, 482.691570, val);
}

static void
COMP_(draw_0x1bbf750)(void *_cpssp, unsigned int val) {
	struct cpssp *cpssp= _cpssp;
	draw_line(cpssp, darea, 948.521300, 451.095280, 1028.819400, 452.349940, val);
	draw_line(cpssp, darea, 1028.819400, 452.349940, 1028.819400, 316.846900, val);
	draw_line(cpssp, darea, 1028.819400, 316.846900, 1242.111200, 319.356210, val);
}

static void
COMP_(draw_0x1bc05f0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc0740)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc0890)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc09e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc0b30)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc0c80)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc0dd0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc0f20)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1070)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc11c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1310)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1460)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc15b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1700)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1850)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc19a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1af0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1c40)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1d90)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc1ee0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2030)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2180)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc22d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2420)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2570)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc26c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2810)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2960)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2ab0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2c00)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2d50)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2ea0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc2ff0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3140)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3290)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc33e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3530)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3680)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc37d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3920)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3a70)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3bc0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3d10)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3e60)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc3fb0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4100)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4250)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc43a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc44f0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4640)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4790)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc48e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4a30)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4b80)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4cd0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4e20)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc4f70)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc50c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5210)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5360)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc54b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5600)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5750)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc58a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc59f0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5b40)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5c90)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5de0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc5f30)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6080)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc61d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6320)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6470)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc65c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6710)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6860)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc69b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6b00)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6c50)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6da0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc6ef0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7040)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7190)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc72e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7430)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7580)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc76d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7820)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7970)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7ac0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7c10)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7d60)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc7eb0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8000)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8150)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc82a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc83f0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8540)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8690)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc87e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8930)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8a80)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8bd0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8d20)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8e70)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc8fc0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bb6b50)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bb8250)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bb82b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc91c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9310)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9460)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc95b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9700)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9850)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc99a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9af0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9c40)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9d90)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bc9ee0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca030)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca180)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca2d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca420)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca570)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca6c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca810)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bca960)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcaab0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcac00)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcad50)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcaea0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcaff0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb140)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb290)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb3e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb530)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb680)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb7d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcb920)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcba70)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcbbc0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcbd10)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcbe60)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcbfb0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc100)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc250)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc3a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc4f0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc640)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc790)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcc8e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcca30)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bccb80)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcccd0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcce20)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bccf70)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd0c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd210)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd360)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd4b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd600)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd750)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd8a0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcd9f0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcdb40)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcdc90)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcdde0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcdf30)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce080)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce1d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce320)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce470)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce5c0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce710)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce860)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bce9b0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bceb00)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcec50)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bceda0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bceef0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf040)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf190)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf2e0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf430)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf580)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf6d0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf820)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcf970)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcfac0)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcfc10)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcfd60)(void *_cpssp, unsigned int val) {
	return;
}

static void
COMP_(draw_0x1bcfeb0)(void *_cpssp, unsigned int val) {
	return;
}

static void
refresh_monitor(void* _cpssp)
{
	struct cpssp *cpssp = _cpssp;
	/* redraw ports if something changed */
	if (cpssp->oldport_Uhr1 != cpssp->port_Uhr1) {
		COMP_(draw_Uhr1)((void* ) cpssp, cpssp->port_Uhr1);
		cpssp->oldport_Uhr1 = cpssp->port_Uhr1;
	}
	if (cpssp->oldport_Uhr2 != cpssp->port_Uhr2) {
		COMP_(draw_Uhr2)((void* ) cpssp, cpssp->port_Uhr2);
		cpssp->oldport_Uhr2 = cpssp->port_Uhr2;
	}
	if (cpssp->oldport_Imp1 != cpssp->port_Imp1) {
		COMP_(draw_Imp1)((void* ) cpssp, cpssp->port_Imp1);
		cpssp->oldport_Imp1 = cpssp->port_Imp1;
	}
	if (cpssp->oldport_Imp2 != cpssp->port_Imp2) {
		COMP_(draw_Imp2)((void* ) cpssp, cpssp->port_Imp2);
		cpssp->oldport_Imp2 = cpssp->port_Imp2;
	}
	if (cpssp->oldport_22I1 != cpssp->port_22I1) {
		COMP_(draw_22I1)((void* ) cpssp, cpssp->port_22I1);
		cpssp->oldport_22I1 = cpssp->port_22I1;
	}
	if (cpssp->oldport_22I2 != cpssp->port_22I2) {
		COMP_(draw_22I2)((void* ) cpssp, cpssp->port_22I2);
		cpssp->oldport_22I2 = cpssp->port_22I2;
	}
	if (cpssp->oldport_22I3 != cpssp->port_22I3) {
		COMP_(draw_22I3)((void* ) cpssp, cpssp->port_22I3);
		cpssp->oldport_22I3 = cpssp->port_22I3;
	}
	if (cpssp->oldport_22I4 != cpssp->port_22I4) {
		COMP_(draw_22I4)((void* ) cpssp, cpssp->port_22I4);
		cpssp->oldport_22I4 = cpssp->port_22I4;
	}
	if (cpssp->oldport_22I5 != cpssp->port_22I5) {
		COMP_(draw_22I5)((void* ) cpssp, cpssp->port_22I5);
		cpssp->oldport_22I5 = cpssp->port_22I5;
	}
	if (cpssp->oldport_22I6 != cpssp->port_22I6) {
		COMP_(draw_22I6)((void* ) cpssp, cpssp->port_22I6);
		cpssp->oldport_22I6 = cpssp->port_22I6;
	}
	if (cpssp->oldport_22I7 != cpssp->port_22I7) {
		COMP_(draw_22I7)((void* ) cpssp, cpssp->port_22I7);
		cpssp->oldport_22I7 = cpssp->port_22I7;
	}
	if (cpssp->oldport_22I8 != cpssp->port_22I8) {
		COMP_(draw_22I8)((void* ) cpssp, cpssp->port_22I8);
		cpssp->oldport_22I8 = cpssp->port_22I8;
	}
	if (cpssp->oldport_22I9 != cpssp->port_22I9) {
		COMP_(draw_22I9)((void* ) cpssp, cpssp->port_22I9);
		cpssp->oldport_22I9 = cpssp->port_22I9;
	}
	if (cpssp->oldport_22I0 != cpssp->port_22I0) {
		COMP_(draw_22I0)((void* ) cpssp, cpssp->port_22I0);
		cpssp->oldport_22I0 = cpssp->port_22I0;
	}
	if (cpssp->oldport_22II1 != cpssp->port_22II1) {
		COMP_(draw_22II1)((void* ) cpssp, cpssp->port_22II1);
		cpssp->oldport_22II1 = cpssp->port_22II1;
	}
	if (cpssp->oldport_22II2 != cpssp->port_22II2) {
		COMP_(draw_22II2)((void* ) cpssp, cpssp->port_22II2);
		cpssp->oldport_22II2 = cpssp->port_22II2;
	}
	if (cpssp->oldport_22II3 != cpssp->port_22II3) {
		COMP_(draw_22II3)((void* ) cpssp, cpssp->port_22II3);
		cpssp->oldport_22II3 = cpssp->port_22II3;
	}
	if (cpssp->oldport_22II4 != cpssp->port_22II4) {
		COMP_(draw_22II4)((void* ) cpssp, cpssp->port_22II4);
		cpssp->oldport_22II4 = cpssp->port_22II4;
	}
	if (cpssp->oldport_22II5 != cpssp->port_22II5) {
		COMP_(draw_22II5)((void* ) cpssp, cpssp->port_22II5);
		cpssp->oldport_22II5 = cpssp->port_22II5;
	}
	if (cpssp->oldport_22II6 != cpssp->port_22II6) {
		COMP_(draw_22II6)((void* ) cpssp, cpssp->port_22II6);
		cpssp->oldport_22II6 = cpssp->port_22II6;
	}
	if (cpssp->oldport_22II7 != cpssp->port_22II7) {
		COMP_(draw_22II7)((void* ) cpssp, cpssp->port_22II7);
		cpssp->oldport_22II7 = cpssp->port_22II7;
	}
	if (cpssp->oldport_22II8 != cpssp->port_22II8) {
		COMP_(draw_22II8)((void* ) cpssp, cpssp->port_22II8);
		cpssp->oldport_22II8 = cpssp->port_22II8;
	}
	if (cpssp->oldport_22II9 != cpssp->port_22II9) {
		COMP_(draw_22II9)((void* ) cpssp, cpssp->port_22II9);
		cpssp->oldport_22II9 = cpssp->port_22II9;
	}
	if (cpssp->oldport_22II0 != cpssp->port_22II0) {
		COMP_(draw_22II0)((void* ) cpssp, cpssp->port_22II0);
		cpssp->oldport_22II0 = cpssp->port_22II0;
	}
	if (cpssp->oldport_22III1 != cpssp->port_22III1) {
		COMP_(draw_22III1)((void* ) cpssp, cpssp->port_22III1);
		cpssp->oldport_22III1 = cpssp->port_22III1;
	}
	if (cpssp->oldport_22III2 != cpssp->port_22III2) {
		COMP_(draw_22III2)((void* ) cpssp, cpssp->port_22III2);
		cpssp->oldport_22III2 = cpssp->port_22III2;
	}
	if (cpssp->oldport_22III3 != cpssp->port_22III3) {
		COMP_(draw_22III3)((void* ) cpssp, cpssp->port_22III3);
		cpssp->oldport_22III3 = cpssp->port_22III3;
	}
	if (cpssp->oldport_22III4 != cpssp->port_22III4) {
		COMP_(draw_22III4)((void* ) cpssp, cpssp->port_22III4);
		cpssp->oldport_22III4 = cpssp->port_22III4;
	}
	if (cpssp->oldport_22III5 != cpssp->port_22III5) {
		COMP_(draw_22III5)((void* ) cpssp, cpssp->port_22III5);
		cpssp->oldport_22III5 = cpssp->port_22III5;
	}
	if (cpssp->oldport_22III6 != cpssp->port_22III6) {
		COMP_(draw_22III6)((void* ) cpssp, cpssp->port_22III6);
		cpssp->oldport_22III6 = cpssp->port_22III6;
	}
	if (cpssp->oldport_22III7 != cpssp->port_22III7) {
		COMP_(draw_22III7)((void* ) cpssp, cpssp->port_22III7);
		cpssp->oldport_22III7 = cpssp->port_22III7;
	}
	if (cpssp->oldport_22III8 != cpssp->port_22III8) {
		COMP_(draw_22III8)((void* ) cpssp, cpssp->port_22III8);
		cpssp->oldport_22III8 = cpssp->port_22III8;
	}
	if (cpssp->oldport_22III9 != cpssp->port_22III9) {
		COMP_(draw_22III9)((void* ) cpssp, cpssp->port_22III9);
		cpssp->oldport_22III9 = cpssp->port_22III9;
	}
	if (cpssp->oldport_22III0 != cpssp->port_22III0) {
		COMP_(draw_22III0)((void* ) cpssp, cpssp->port_22III0);
		cpssp->oldport_22III0 = cpssp->port_22III0;
	}
	if (cpssp->oldport_30I1 != cpssp->port_30I1) {
		COMP_(draw_30I1)((void* ) cpssp, cpssp->port_30I1);
		cpssp->oldport_30I1 = cpssp->port_30I1;
	}
	if (cpssp->oldport_30I2 != cpssp->port_30I2) {
		COMP_(draw_30I2)((void* ) cpssp, cpssp->port_30I2);
		cpssp->oldport_30I2 = cpssp->port_30I2;
	}
	if (cpssp->oldport_30I3 != cpssp->port_30I3) {
		COMP_(draw_30I3)((void* ) cpssp, cpssp->port_30I3);
		cpssp->oldport_30I3 = cpssp->port_30I3;
	}
	if (cpssp->oldport_30I4 != cpssp->port_30I4) {
		COMP_(draw_30I4)((void* ) cpssp, cpssp->port_30I4);
		cpssp->oldport_30I4 = cpssp->port_30I4;
	}
	if (cpssp->oldport_30I5 != cpssp->port_30I5) {
		COMP_(draw_30I5)((void* ) cpssp, cpssp->port_30I5);
		cpssp->oldport_30I5 = cpssp->port_30I5;
	}
	if (cpssp->oldport_30I6 != cpssp->port_30I6) {
		COMP_(draw_30I6)((void* ) cpssp, cpssp->port_30I6);
		cpssp->oldport_30I6 = cpssp->port_30I6;
	}
	if (cpssp->oldport_30I7 != cpssp->port_30I7) {
		COMP_(draw_30I7)((void* ) cpssp, cpssp->port_30I7);
		cpssp->oldport_30I7 = cpssp->port_30I7;
	}
	if (cpssp->oldport_30I8 != cpssp->port_30I8) {
		COMP_(draw_30I8)((void* ) cpssp, cpssp->port_30I8);
		cpssp->oldport_30I8 = cpssp->port_30I8;
	}
	if (cpssp->oldport_30I9 != cpssp->port_30I9) {
		COMP_(draw_30I9)((void* ) cpssp, cpssp->port_30I9);
		cpssp->oldport_30I9 = cpssp->port_30I9;
	}
	if (cpssp->oldport_30I0 != cpssp->port_30I0) {
		COMP_(draw_30I0)((void* ) cpssp, cpssp->port_30I0);
		cpssp->oldport_30I0 = cpssp->port_30I0;
	}
	if (cpssp->oldport_30II1 != cpssp->port_30II1) {
		COMP_(draw_30II1)((void* ) cpssp, cpssp->port_30II1);
		cpssp->oldport_30II1 = cpssp->port_30II1;
	}
	if (cpssp->oldport_30II2 != cpssp->port_30II2) {
		COMP_(draw_30II2)((void* ) cpssp, cpssp->port_30II2);
		cpssp->oldport_30II2 = cpssp->port_30II2;
	}
	if (cpssp->oldport_30II3 != cpssp->port_30II3) {
		COMP_(draw_30II3)((void* ) cpssp, cpssp->port_30II3);
		cpssp->oldport_30II3 = cpssp->port_30II3;
	}
	if (cpssp->oldport_30II4 != cpssp->port_30II4) {
		COMP_(draw_30II4)((void* ) cpssp, cpssp->port_30II4);
		cpssp->oldport_30II4 = cpssp->port_30II4;
	}
	if (cpssp->oldport_30II5 != cpssp->port_30II5) {
		COMP_(draw_30II5)((void* ) cpssp, cpssp->port_30II5);
		cpssp->oldport_30II5 = cpssp->port_30II5;
	}
	if (cpssp->oldport_30II6 != cpssp->port_30II6) {
		COMP_(draw_30II6)((void* ) cpssp, cpssp->port_30II6);
		cpssp->oldport_30II6 = cpssp->port_30II6;
	}
	if (cpssp->oldport_30II7 != cpssp->port_30II7) {
		COMP_(draw_30II7)((void* ) cpssp, cpssp->port_30II7);
		cpssp->oldport_30II7 = cpssp->port_30II7;
	}
	if (cpssp->oldport_30II8 != cpssp->port_30II8) {
		COMP_(draw_30II8)((void* ) cpssp, cpssp->port_30II8);
		cpssp->oldport_30II8 = cpssp->port_30II8;
	}
	if (cpssp->oldport_30II9 != cpssp->port_30II9) {
		COMP_(draw_30II9)((void* ) cpssp, cpssp->port_30II9);
		cpssp->oldport_30II9 = cpssp->port_30II9;
	}
	if (cpssp->oldport_30II0 != cpssp->port_30II0) {
		COMP_(draw_30II0)((void* ) cpssp, cpssp->port_30II0);
		cpssp->oldport_30II0 = cpssp->port_30II0;
	}
	if (cpssp->oldport_30III1 != cpssp->port_30III1) {
		COMP_(draw_30III1)((void* ) cpssp, cpssp->port_30III1);
		cpssp->oldport_30III1 = cpssp->port_30III1;
	}
	if (cpssp->oldport_30III2 != cpssp->port_30III2) {
		COMP_(draw_30III2)((void* ) cpssp, cpssp->port_30III2);
		cpssp->oldport_30III2 = cpssp->port_30III2;
	}
	if (cpssp->oldport_30III3 != cpssp->port_30III3) {
		COMP_(draw_30III3)((void* ) cpssp, cpssp->port_30III3);
		cpssp->oldport_30III3 = cpssp->port_30III3;
	}
	if (cpssp->oldport_30III4 != cpssp->port_30III4) {
		COMP_(draw_30III4)((void* ) cpssp, cpssp->port_30III4);
		cpssp->oldport_30III4 = cpssp->port_30III4;
	}
	if (cpssp->oldport_30III5 != cpssp->port_30III5) {
		COMP_(draw_30III5)((void* ) cpssp, cpssp->port_30III5);
		cpssp->oldport_30III5 = cpssp->port_30III5;
	}
	if (cpssp->oldport_30III6 != cpssp->port_30III6) {
		COMP_(draw_30III6)((void* ) cpssp, cpssp->port_30III6);
		cpssp->oldport_30III6 = cpssp->port_30III6;
	}
	if (cpssp->oldport_30III7 != cpssp->port_30III7) {
		COMP_(draw_30III7)((void* ) cpssp, cpssp->port_30III7);
		cpssp->oldport_30III7 = cpssp->port_30III7;
	}
	if (cpssp->oldport_30III8 != cpssp->port_30III8) {
		COMP_(draw_30III8)((void* ) cpssp, cpssp->port_30III8);
		cpssp->oldport_30III8 = cpssp->port_30III8;
	}
	if (cpssp->oldport_30III9 != cpssp->port_30III9) {
		COMP_(draw_30III9)((void* ) cpssp, cpssp->port_30III9);
		cpssp->oldport_30III9 = cpssp->port_30III9;
	}
	if (cpssp->oldport_30III0 != cpssp->port_30III0) {
		COMP_(draw_30III0)((void* ) cpssp, cpssp->port_30III0);
		cpssp->oldport_30III0 = cpssp->port_30III0;
	}
	/* redraw gui ports if something changed */
	if (cpssp->oldport_0x1bb8760 != cpssp->port_0x1bb8760) {
		COMP_(draw_0x1bb8760)((void* ) cpssp, cpssp->port_0x1bb8760);
		cpssp->oldport_0x1bb8760 = cpssp->port_0x1bb8760;
	}
	if (cpssp->oldport_0x1bb9650 != cpssp->port_0x1bb9650) {
		COMP_(draw_0x1bb9650)((void* ) cpssp, cpssp->port_0x1bb9650);
		cpssp->oldport_0x1bb9650 = cpssp->port_0x1bb9650;
	}
	if (cpssp->oldport_0x1bb9630 != cpssp->port_0x1bb9630) {
		COMP_(draw_0x1bb9630)((void* ) cpssp, cpssp->port_0x1bb9630);
		cpssp->oldport_0x1bb9630 = cpssp->port_0x1bb9630;
	}
	if (cpssp->oldport_0x1bb69a0 != cpssp->port_0x1bb69a0) {
		COMP_(draw_0x1bb69a0)((void* ) cpssp, cpssp->port_0x1bb69a0);
		cpssp->oldport_0x1bb69a0 = cpssp->port_0x1bb69a0;
	}
	if (cpssp->oldport_0x1bb82f0 != cpssp->port_0x1bb82f0) {
		COMP_(draw_0x1bb82f0)((void* ) cpssp, cpssp->port_0x1bb82f0);
		cpssp->oldport_0x1bb82f0 = cpssp->port_0x1bb82f0;
	}
	if (cpssp->oldport_0x1bb81b0 != cpssp->port_0x1bb81b0) {
		COMP_(draw_0x1bb81b0)((void* ) cpssp, cpssp->port_0x1bb81b0);
		cpssp->oldport_0x1bb81b0 = cpssp->port_0x1bb81b0;
	}
	if (cpssp->oldport_0x1bb8f00 != cpssp->port_0x1bb8f00) {
		COMP_(draw_0x1bb8f00)((void* ) cpssp, cpssp->port_0x1bb8f00);
		cpssp->oldport_0x1bb8f00 = cpssp->port_0x1bb8f00;
	}
	if (cpssp->oldport_0x1bb3b20 != cpssp->port_0x1bb3b20) {
		COMP_(draw_0x1bb3b20)((void* ) cpssp, cpssp->port_0x1bb3b20);
		cpssp->oldport_0x1bb3b20 = cpssp->port_0x1bb3b20;
	}
	if (cpssp->oldport_0x1bb6a40 != cpssp->port_0x1bb6a40) {
		COMP_(draw_0x1bb6a40)((void* ) cpssp, cpssp->port_0x1bb6a40);
		cpssp->oldport_0x1bb6a40 = cpssp->port_0x1bb6a40;
	}
	if (cpssp->oldport_0x1bb8550 != cpssp->port_0x1bb8550) {
		COMP_(draw_0x1bb8550)((void* ) cpssp, cpssp->port_0x1bb8550);
		cpssp->oldport_0x1bb8550 = cpssp->port_0x1bb8550;
	}
	if (cpssp->oldport_0x1bb6980 != cpssp->port_0x1bb6980) {
		COMP_(draw_0x1bb6980)((void* ) cpssp, cpssp->port_0x1bb6980);
		cpssp->oldport_0x1bb6980 = cpssp->port_0x1bb6980;
	}
	if (cpssp->oldport_0x1bb8190 != cpssp->port_0x1bb8190) {
		COMP_(draw_0x1bb8190)((void* ) cpssp, cpssp->port_0x1bb8190);
		cpssp->oldport_0x1bb8190 = cpssp->port_0x1bb8190;
	}
	if (cpssp->oldport_0x1bb6640 != cpssp->port_0x1bb6640) {
		COMP_(draw_0x1bb6640)((void* ) cpssp, cpssp->port_0x1bb6640);
		cpssp->oldport_0x1bb6640 = cpssp->port_0x1bb6640;
	}
	if (cpssp->oldport_0x1bbe9b0 != cpssp->port_0x1bbe9b0) {
		COMP_(draw_0x1bbe9b0)((void* ) cpssp, cpssp->port_0x1bbe9b0);
		cpssp->oldport_0x1bbe9b0 = cpssp->port_0x1bbe9b0;
	}
	if (cpssp->oldport_0x1bbe9d0 != cpssp->port_0x1bbe9d0) {
		COMP_(draw_0x1bbe9d0)((void* ) cpssp, cpssp->port_0x1bbe9d0);
		cpssp->oldport_0x1bbe9d0 = cpssp->port_0x1bbe9d0;
	}
	if (cpssp->oldport_0x1bbe9f0 != cpssp->port_0x1bbe9f0) {
		COMP_(draw_0x1bbe9f0)((void* ) cpssp, cpssp->port_0x1bbe9f0);
		cpssp->oldport_0x1bbe9f0 = cpssp->port_0x1bbe9f0;
	}
	if (cpssp->oldport_0x1bbea10 != cpssp->port_0x1bbea10) {
		COMP_(draw_0x1bbea10)((void* ) cpssp, cpssp->port_0x1bbea10);
		cpssp->oldport_0x1bbea10 = cpssp->port_0x1bbea10;
	}
	if (cpssp->oldport_0x1bbea30 != cpssp->port_0x1bbea30) {
		COMP_(draw_0x1bbea30)((void* ) cpssp, cpssp->port_0x1bbea30);
		cpssp->oldport_0x1bbea30 = cpssp->port_0x1bbea30;
	}
	if (cpssp->oldport_0x1bbea50 != cpssp->port_0x1bbea50) {
		COMP_(draw_0x1bbea50)((void* ) cpssp, cpssp->port_0x1bbea50);
		cpssp->oldport_0x1bbea50 = cpssp->port_0x1bbea50;
	}
	if (cpssp->oldport_0x1bbea70 != cpssp->port_0x1bbea70) {
		COMP_(draw_0x1bbea70)((void* ) cpssp, cpssp->port_0x1bbea70);
		cpssp->oldport_0x1bbea70 = cpssp->port_0x1bbea70;
	}
	if (cpssp->oldport_0x1bbea90 != cpssp->port_0x1bbea90) {
		COMP_(draw_0x1bbea90)((void* ) cpssp, cpssp->port_0x1bbea90);
		cpssp->oldport_0x1bbea90 = cpssp->port_0x1bbea90;
	}
	if (cpssp->oldport_0x1bbeab0 != cpssp->port_0x1bbeab0) {
		COMP_(draw_0x1bbeab0)((void* ) cpssp, cpssp->port_0x1bbeab0);
		cpssp->oldport_0x1bbeab0 = cpssp->port_0x1bbeab0;
	}
	if (cpssp->oldport_0x1bbead0 != cpssp->port_0x1bbead0) {
		COMP_(draw_0x1bbead0)((void* ) cpssp, cpssp->port_0x1bbead0);
		cpssp->oldport_0x1bbead0 = cpssp->port_0x1bbead0;
	}
	if (cpssp->oldport_0x1bbeaf0 != cpssp->port_0x1bbeaf0) {
		COMP_(draw_0x1bbeaf0)((void* ) cpssp, cpssp->port_0x1bbeaf0);
		cpssp->oldport_0x1bbeaf0 = cpssp->port_0x1bbeaf0;
	}
	if (cpssp->oldport_0x1bbeb10 != cpssp->port_0x1bbeb10) {
		COMP_(draw_0x1bbeb10)((void* ) cpssp, cpssp->port_0x1bbeb10);
		cpssp->oldport_0x1bbeb10 = cpssp->port_0x1bbeb10;
	}
	if (cpssp->oldport_0x1bbeb30 != cpssp->port_0x1bbeb30) {
		COMP_(draw_0x1bbeb30)((void* ) cpssp, cpssp->port_0x1bbeb30);
		cpssp->oldport_0x1bbeb30 = cpssp->port_0x1bbeb30;
	}
	if (cpssp->oldport_0x1bbeb50 != cpssp->port_0x1bbeb50) {
		COMP_(draw_0x1bbeb50)((void* ) cpssp, cpssp->port_0x1bbeb50);
		cpssp->oldport_0x1bbeb50 = cpssp->port_0x1bbeb50;
	}
	if (cpssp->oldport_0x1bbeb70 != cpssp->port_0x1bbeb70) {
		COMP_(draw_0x1bbeb70)((void* ) cpssp, cpssp->port_0x1bbeb70);
		cpssp->oldport_0x1bbeb70 = cpssp->port_0x1bbeb70;
	}
	if (cpssp->oldport_0x1bbeb90 != cpssp->port_0x1bbeb90) {
		COMP_(draw_0x1bbeb90)((void* ) cpssp, cpssp->port_0x1bbeb90);
		cpssp->oldport_0x1bbeb90 = cpssp->port_0x1bbeb90;
	}
	if (cpssp->oldport_0x1bbebb0 != cpssp->port_0x1bbebb0) {
		COMP_(draw_0x1bbebb0)((void* ) cpssp, cpssp->port_0x1bbebb0);
		cpssp->oldport_0x1bbebb0 = cpssp->port_0x1bbebb0;
	}
	if (cpssp->oldport_0x1bbebd0 != cpssp->port_0x1bbebd0) {
		COMP_(draw_0x1bbebd0)((void* ) cpssp, cpssp->port_0x1bbebd0);
		cpssp->oldport_0x1bbebd0 = cpssp->port_0x1bbebd0;
	}
	if (cpssp->oldport_0x1bbebf0 != cpssp->port_0x1bbebf0) {
		COMP_(draw_0x1bbebf0)((void* ) cpssp, cpssp->port_0x1bbebf0);
		cpssp->oldport_0x1bbebf0 = cpssp->port_0x1bbebf0;
	}
	if (cpssp->oldport_0x1bbec10 != cpssp->port_0x1bbec10) {
		COMP_(draw_0x1bbec10)((void* ) cpssp, cpssp->port_0x1bbec10);
		cpssp->oldport_0x1bbec10 = cpssp->port_0x1bbec10;
	}
	if (cpssp->oldport_0x1bbec30 != cpssp->port_0x1bbec30) {
		COMP_(draw_0x1bbec30)((void* ) cpssp, cpssp->port_0x1bbec30);
		cpssp->oldport_0x1bbec30 = cpssp->port_0x1bbec30;
	}
	if (cpssp->oldport_0x1bbec50 != cpssp->port_0x1bbec50) {
		COMP_(draw_0x1bbec50)((void* ) cpssp, cpssp->port_0x1bbec50);
		cpssp->oldport_0x1bbec50 = cpssp->port_0x1bbec50;
	}
	if (cpssp->oldport_0x1bbec70 != cpssp->port_0x1bbec70) {
		COMP_(draw_0x1bbec70)((void* ) cpssp, cpssp->port_0x1bbec70);
		cpssp->oldport_0x1bbec70 = cpssp->port_0x1bbec70;
	}
	if (cpssp->oldport_0x1bbec90 != cpssp->port_0x1bbec90) {
		COMP_(draw_0x1bbec90)((void* ) cpssp, cpssp->port_0x1bbec90);
		cpssp->oldport_0x1bbec90 = cpssp->port_0x1bbec90;
	}
	if (cpssp->oldport_0x1bbecb0 != cpssp->port_0x1bbecb0) {
		COMP_(draw_0x1bbecb0)((void* ) cpssp, cpssp->port_0x1bbecb0);
		cpssp->oldport_0x1bbecb0 = cpssp->port_0x1bbecb0;
	}
	if (cpssp->oldport_0x1bbecd0 != cpssp->port_0x1bbecd0) {
		COMP_(draw_0x1bbecd0)((void* ) cpssp, cpssp->port_0x1bbecd0);
		cpssp->oldport_0x1bbecd0 = cpssp->port_0x1bbecd0;
	}
	if (cpssp->oldport_0x1bbecf0 != cpssp->port_0x1bbecf0) {
		COMP_(draw_0x1bbecf0)((void* ) cpssp, cpssp->port_0x1bbecf0);
		cpssp->oldport_0x1bbecf0 = cpssp->port_0x1bbecf0;
	}
	if (cpssp->oldport_0x1bbed10 != cpssp->port_0x1bbed10) {
		COMP_(draw_0x1bbed10)((void* ) cpssp, cpssp->port_0x1bbed10);
		cpssp->oldport_0x1bbed10 = cpssp->port_0x1bbed10;
	}
	if (cpssp->oldport_0x1bbed30 != cpssp->port_0x1bbed30) {
		COMP_(draw_0x1bbed30)((void* ) cpssp, cpssp->port_0x1bbed30);
		cpssp->oldport_0x1bbed30 = cpssp->port_0x1bbed30;
	}
	if (cpssp->oldport_0x1bbed50 != cpssp->port_0x1bbed50) {
		COMP_(draw_0x1bbed50)((void* ) cpssp, cpssp->port_0x1bbed50);
		cpssp->oldport_0x1bbed50 = cpssp->port_0x1bbed50;
	}
	if (cpssp->oldport_0x1bbed70 != cpssp->port_0x1bbed70) {
		COMP_(draw_0x1bbed70)((void* ) cpssp, cpssp->port_0x1bbed70);
		cpssp->oldport_0x1bbed70 = cpssp->port_0x1bbed70;
	}
	if (cpssp->oldport_0x1bbed90 != cpssp->port_0x1bbed90) {
		COMP_(draw_0x1bbed90)((void* ) cpssp, cpssp->port_0x1bbed90);
		cpssp->oldport_0x1bbed90 = cpssp->port_0x1bbed90;
	}
	if (cpssp->oldport_0x1bbedb0 != cpssp->port_0x1bbedb0) {
		COMP_(draw_0x1bbedb0)((void* ) cpssp, cpssp->port_0x1bbedb0);
		cpssp->oldport_0x1bbedb0 = cpssp->port_0x1bbedb0;
	}
	if (cpssp->oldport_0x1bbedd0 != cpssp->port_0x1bbedd0) {
		COMP_(draw_0x1bbedd0)((void* ) cpssp, cpssp->port_0x1bbedd0);
		cpssp->oldport_0x1bbedd0 = cpssp->port_0x1bbedd0;
	}
	if (cpssp->oldport_0x1bbedf0 != cpssp->port_0x1bbedf0) {
		COMP_(draw_0x1bbedf0)((void* ) cpssp, cpssp->port_0x1bbedf0);
		cpssp->oldport_0x1bbedf0 = cpssp->port_0x1bbedf0;
	}
	if (cpssp->oldport_0x1bbee10 != cpssp->port_0x1bbee10) {
		COMP_(draw_0x1bbee10)((void* ) cpssp, cpssp->port_0x1bbee10);
		cpssp->oldport_0x1bbee10 = cpssp->port_0x1bbee10;
	}
	if (cpssp->oldport_0x1bbee30 != cpssp->port_0x1bbee30) {
		COMP_(draw_0x1bbee30)((void* ) cpssp, cpssp->port_0x1bbee30);
		cpssp->oldport_0x1bbee30 = cpssp->port_0x1bbee30;
	}
	if (cpssp->oldport_0x1bbee50 != cpssp->port_0x1bbee50) {
		COMP_(draw_0x1bbee50)((void* ) cpssp, cpssp->port_0x1bbee50);
		cpssp->oldport_0x1bbee50 = cpssp->port_0x1bbee50;
	}
	if (cpssp->oldport_0x1bbee70 != cpssp->port_0x1bbee70) {
		COMP_(draw_0x1bbee70)((void* ) cpssp, cpssp->port_0x1bbee70);
		cpssp->oldport_0x1bbee70 = cpssp->port_0x1bbee70;
	}
	if (cpssp->oldport_0x1bbee90 != cpssp->port_0x1bbee90) {
		COMP_(draw_0x1bbee90)((void* ) cpssp, cpssp->port_0x1bbee90);
		cpssp->oldport_0x1bbee90 = cpssp->port_0x1bbee90;
	}
	if (cpssp->oldport_0x1bbeeb0 != cpssp->port_0x1bbeeb0) {
		COMP_(draw_0x1bbeeb0)((void* ) cpssp, cpssp->port_0x1bbeeb0);
		cpssp->oldport_0x1bbeeb0 = cpssp->port_0x1bbeeb0;
	}
	if (cpssp->oldport_0x1bbeed0 != cpssp->port_0x1bbeed0) {
		COMP_(draw_0x1bbeed0)((void* ) cpssp, cpssp->port_0x1bbeed0);
		cpssp->oldport_0x1bbeed0 = cpssp->port_0x1bbeed0;
	}
	if (cpssp->oldport_0x1bbeef0 != cpssp->port_0x1bbeef0) {
		COMP_(draw_0x1bbeef0)((void* ) cpssp, cpssp->port_0x1bbeef0);
		cpssp->oldport_0x1bbeef0 = cpssp->port_0x1bbeef0;
	}
	if (cpssp->oldport_0x1bbef10 != cpssp->port_0x1bbef10) {
		COMP_(draw_0x1bbef10)((void* ) cpssp, cpssp->port_0x1bbef10);
		cpssp->oldport_0x1bbef10 = cpssp->port_0x1bbef10;
	}
	if (cpssp->oldport_0x1bbef30 != cpssp->port_0x1bbef30) {
		COMP_(draw_0x1bbef30)((void* ) cpssp, cpssp->port_0x1bbef30);
		cpssp->oldport_0x1bbef30 = cpssp->port_0x1bbef30;
	}
	if (cpssp->oldport_0x1bbef50 != cpssp->port_0x1bbef50) {
		COMP_(draw_0x1bbef50)((void* ) cpssp, cpssp->port_0x1bbef50);
		cpssp->oldport_0x1bbef50 = cpssp->port_0x1bbef50;
	}
	if (cpssp->oldport_0x1bbef70 != cpssp->port_0x1bbef70) {
		COMP_(draw_0x1bbef70)((void* ) cpssp, cpssp->port_0x1bbef70);
		cpssp->oldport_0x1bbef70 = cpssp->port_0x1bbef70;
	}
	if (cpssp->oldport_0x1bbef90 != cpssp->port_0x1bbef90) {
		COMP_(draw_0x1bbef90)((void* ) cpssp, cpssp->port_0x1bbef90);
		cpssp->oldport_0x1bbef90 = cpssp->port_0x1bbef90;
	}
	if (cpssp->oldport_0x1bbefb0 != cpssp->port_0x1bbefb0) {
		COMP_(draw_0x1bbefb0)((void* ) cpssp, cpssp->port_0x1bbefb0);
		cpssp->oldport_0x1bbefb0 = cpssp->port_0x1bbefb0;
	}
	if (cpssp->oldport_0x1bbefd0 != cpssp->port_0x1bbefd0) {
		COMP_(draw_0x1bbefd0)((void* ) cpssp, cpssp->port_0x1bbefd0);
		cpssp->oldport_0x1bbefd0 = cpssp->port_0x1bbefd0;
	}
	if (cpssp->oldport_0x1bbeff0 != cpssp->port_0x1bbeff0) {
		COMP_(draw_0x1bbeff0)((void* ) cpssp, cpssp->port_0x1bbeff0);
		cpssp->oldport_0x1bbeff0 = cpssp->port_0x1bbeff0;
	}
	if (cpssp->oldport_0x1bbf010 != cpssp->port_0x1bbf010) {
		COMP_(draw_0x1bbf010)((void* ) cpssp, cpssp->port_0x1bbf010);
		cpssp->oldport_0x1bbf010 = cpssp->port_0x1bbf010;
	}
	if (cpssp->oldport_0x1bbf030 != cpssp->port_0x1bbf030) {
		COMP_(draw_0x1bbf030)((void* ) cpssp, cpssp->port_0x1bbf030);
		cpssp->oldport_0x1bbf030 = cpssp->port_0x1bbf030;
	}
	if (cpssp->oldport_0x1bbf050 != cpssp->port_0x1bbf050) {
		COMP_(draw_0x1bbf050)((void* ) cpssp, cpssp->port_0x1bbf050);
		cpssp->oldport_0x1bbf050 = cpssp->port_0x1bbf050;
	}
	if (cpssp->oldport_0x1bbf070 != cpssp->port_0x1bbf070) {
		COMP_(draw_0x1bbf070)((void* ) cpssp, cpssp->port_0x1bbf070);
		cpssp->oldport_0x1bbf070 = cpssp->port_0x1bbf070;
	}
	if (cpssp->oldport_0x1bbf090 != cpssp->port_0x1bbf090) {
		COMP_(draw_0x1bbf090)((void* ) cpssp, cpssp->port_0x1bbf090);
		cpssp->oldport_0x1bbf090 = cpssp->port_0x1bbf090;
	}
	if (cpssp->oldport_0x1bbf0b0 != cpssp->port_0x1bbf0b0) {
		COMP_(draw_0x1bbf0b0)((void* ) cpssp, cpssp->port_0x1bbf0b0);
		cpssp->oldport_0x1bbf0b0 = cpssp->port_0x1bbf0b0;
	}
	if (cpssp->oldport_0x1bbf0d0 != cpssp->port_0x1bbf0d0) {
		COMP_(draw_0x1bbf0d0)((void* ) cpssp, cpssp->port_0x1bbf0d0);
		cpssp->oldport_0x1bbf0d0 = cpssp->port_0x1bbf0d0;
	}
	if (cpssp->oldport_0x1bbf0f0 != cpssp->port_0x1bbf0f0) {
		COMP_(draw_0x1bbf0f0)((void* ) cpssp, cpssp->port_0x1bbf0f0);
		cpssp->oldport_0x1bbf0f0 = cpssp->port_0x1bbf0f0;
	}
	if (cpssp->oldport_0x1bbf110 != cpssp->port_0x1bbf110) {
		COMP_(draw_0x1bbf110)((void* ) cpssp, cpssp->port_0x1bbf110);
		cpssp->oldport_0x1bbf110 = cpssp->port_0x1bbf110;
	}
	if (cpssp->oldport_0x1bbf130 != cpssp->port_0x1bbf130) {
		COMP_(draw_0x1bbf130)((void* ) cpssp, cpssp->port_0x1bbf130);
		cpssp->oldport_0x1bbf130 = cpssp->port_0x1bbf130;
	}
	if (cpssp->oldport_0x1bbf150 != cpssp->port_0x1bbf150) {
		COMP_(draw_0x1bbf150)((void* ) cpssp, cpssp->port_0x1bbf150);
		cpssp->oldport_0x1bbf150 = cpssp->port_0x1bbf150;
	}
	if (cpssp->oldport_0x1bbf170 != cpssp->port_0x1bbf170) {
		COMP_(draw_0x1bbf170)((void* ) cpssp, cpssp->port_0x1bbf170);
		cpssp->oldport_0x1bbf170 = cpssp->port_0x1bbf170;
	}
	if (cpssp->oldport_0x1bbf190 != cpssp->port_0x1bbf190) {
		COMP_(draw_0x1bbf190)((void* ) cpssp, cpssp->port_0x1bbf190);
		cpssp->oldport_0x1bbf190 = cpssp->port_0x1bbf190;
	}
	if (cpssp->oldport_0x1bbf1b0 != cpssp->port_0x1bbf1b0) {
		COMP_(draw_0x1bbf1b0)((void* ) cpssp, cpssp->port_0x1bbf1b0);
		cpssp->oldport_0x1bbf1b0 = cpssp->port_0x1bbf1b0;
	}
	if (cpssp->oldport_0x1bbf1d0 != cpssp->port_0x1bbf1d0) {
		COMP_(draw_0x1bbf1d0)((void* ) cpssp, cpssp->port_0x1bbf1d0);
		cpssp->oldport_0x1bbf1d0 = cpssp->port_0x1bbf1d0;
	}
	if (cpssp->oldport_0x1bbf1f0 != cpssp->port_0x1bbf1f0) {
		COMP_(draw_0x1bbf1f0)((void* ) cpssp, cpssp->port_0x1bbf1f0);
		cpssp->oldport_0x1bbf1f0 = cpssp->port_0x1bbf1f0;
	}
	if (cpssp->oldport_0x1bbf210 != cpssp->port_0x1bbf210) {
		COMP_(draw_0x1bbf210)((void* ) cpssp, cpssp->port_0x1bbf210);
		cpssp->oldport_0x1bbf210 = cpssp->port_0x1bbf210;
	}
	if (cpssp->oldport_0x1bbf230 != cpssp->port_0x1bbf230) {
		COMP_(draw_0x1bbf230)((void* ) cpssp, cpssp->port_0x1bbf230);
		cpssp->oldport_0x1bbf230 = cpssp->port_0x1bbf230;
	}
	if (cpssp->oldport_0x1bbf250 != cpssp->port_0x1bbf250) {
		COMP_(draw_0x1bbf250)((void* ) cpssp, cpssp->port_0x1bbf250);
		cpssp->oldport_0x1bbf250 = cpssp->port_0x1bbf250;
	}
	if (cpssp->oldport_0x1bbf270 != cpssp->port_0x1bbf270) {
		COMP_(draw_0x1bbf270)((void* ) cpssp, cpssp->port_0x1bbf270);
		cpssp->oldport_0x1bbf270 = cpssp->port_0x1bbf270;
	}
	if (cpssp->oldport_0x1bbf290 != cpssp->port_0x1bbf290) {
		COMP_(draw_0x1bbf290)((void* ) cpssp, cpssp->port_0x1bbf290);
		cpssp->oldport_0x1bbf290 = cpssp->port_0x1bbf290;
	}
	if (cpssp->oldport_0x1bbf2b0 != cpssp->port_0x1bbf2b0) {
		COMP_(draw_0x1bbf2b0)((void* ) cpssp, cpssp->port_0x1bbf2b0);
		cpssp->oldport_0x1bbf2b0 = cpssp->port_0x1bbf2b0;
	}
	if (cpssp->oldport_0x1bbf2d0 != cpssp->port_0x1bbf2d0) {
		COMP_(draw_0x1bbf2d0)((void* ) cpssp, cpssp->port_0x1bbf2d0);
		cpssp->oldport_0x1bbf2d0 = cpssp->port_0x1bbf2d0;
	}
	if (cpssp->oldport_0x1bbf2f0 != cpssp->port_0x1bbf2f0) {
		COMP_(draw_0x1bbf2f0)((void* ) cpssp, cpssp->port_0x1bbf2f0);
		cpssp->oldport_0x1bbf2f0 = cpssp->port_0x1bbf2f0;
	}
	if (cpssp->oldport_0x1bbf310 != cpssp->port_0x1bbf310) {
		COMP_(draw_0x1bbf310)((void* ) cpssp, cpssp->port_0x1bbf310);
		cpssp->oldport_0x1bbf310 = cpssp->port_0x1bbf310;
	}
	if (cpssp->oldport_0x1bbf330 != cpssp->port_0x1bbf330) {
		COMP_(draw_0x1bbf330)((void* ) cpssp, cpssp->port_0x1bbf330);
		cpssp->oldport_0x1bbf330 = cpssp->port_0x1bbf330;
	}
	if (cpssp->oldport_0x1bbf350 != cpssp->port_0x1bbf350) {
		COMP_(draw_0x1bbf350)((void* ) cpssp, cpssp->port_0x1bbf350);
		cpssp->oldport_0x1bbf350 = cpssp->port_0x1bbf350;
	}
	if (cpssp->oldport_0x1bbf370 != cpssp->port_0x1bbf370) {
		COMP_(draw_0x1bbf370)((void* ) cpssp, cpssp->port_0x1bbf370);
		cpssp->oldport_0x1bbf370 = cpssp->port_0x1bbf370;
	}
	if (cpssp->oldport_0x1bbf390 != cpssp->port_0x1bbf390) {
		COMP_(draw_0x1bbf390)((void* ) cpssp, cpssp->port_0x1bbf390);
		cpssp->oldport_0x1bbf390 = cpssp->port_0x1bbf390;
	}
	if (cpssp->oldport_0x1bbf3b0 != cpssp->port_0x1bbf3b0) {
		COMP_(draw_0x1bbf3b0)((void* ) cpssp, cpssp->port_0x1bbf3b0);
		cpssp->oldport_0x1bbf3b0 = cpssp->port_0x1bbf3b0;
	}
	if (cpssp->oldport_0x1bbf3d0 != cpssp->port_0x1bbf3d0) {
		COMP_(draw_0x1bbf3d0)((void* ) cpssp, cpssp->port_0x1bbf3d0);
		cpssp->oldport_0x1bbf3d0 = cpssp->port_0x1bbf3d0;
	}
	if (cpssp->oldport_0x1bbf3f0 != cpssp->port_0x1bbf3f0) {
		COMP_(draw_0x1bbf3f0)((void* ) cpssp, cpssp->port_0x1bbf3f0);
		cpssp->oldport_0x1bbf3f0 = cpssp->port_0x1bbf3f0;
	}
	if (cpssp->oldport_0x1bbf410 != cpssp->port_0x1bbf410) {
		COMP_(draw_0x1bbf410)((void* ) cpssp, cpssp->port_0x1bbf410);
		cpssp->oldport_0x1bbf410 = cpssp->port_0x1bbf410;
	}
	if (cpssp->oldport_0x1bbf430 != cpssp->port_0x1bbf430) {
		COMP_(draw_0x1bbf430)((void* ) cpssp, cpssp->port_0x1bbf430);
		cpssp->oldport_0x1bbf430 = cpssp->port_0x1bbf430;
	}
	if (cpssp->oldport_0x1bbf450 != cpssp->port_0x1bbf450) {
		COMP_(draw_0x1bbf450)((void* ) cpssp, cpssp->port_0x1bbf450);
		cpssp->oldport_0x1bbf450 = cpssp->port_0x1bbf450;
	}
	if (cpssp->oldport_0x1bbf470 != cpssp->port_0x1bbf470) {
		COMP_(draw_0x1bbf470)((void* ) cpssp, cpssp->port_0x1bbf470);
		cpssp->oldport_0x1bbf470 = cpssp->port_0x1bbf470;
	}
	if (cpssp->oldport_0x1bbf490 != cpssp->port_0x1bbf490) {
		COMP_(draw_0x1bbf490)((void* ) cpssp, cpssp->port_0x1bbf490);
		cpssp->oldport_0x1bbf490 = cpssp->port_0x1bbf490;
	}
	if (cpssp->oldport_0x1bbf4b0 != cpssp->port_0x1bbf4b0) {
		COMP_(draw_0x1bbf4b0)((void* ) cpssp, cpssp->port_0x1bbf4b0);
		cpssp->oldport_0x1bbf4b0 = cpssp->port_0x1bbf4b0;
	}
	if (cpssp->oldport_0x1bbf4d0 != cpssp->port_0x1bbf4d0) {
		COMP_(draw_0x1bbf4d0)((void* ) cpssp, cpssp->port_0x1bbf4d0);
		cpssp->oldport_0x1bbf4d0 = cpssp->port_0x1bbf4d0;
	}
	if (cpssp->oldport_0x1bbf4f0 != cpssp->port_0x1bbf4f0) {
		COMP_(draw_0x1bbf4f0)((void* ) cpssp, cpssp->port_0x1bbf4f0);
		cpssp->oldport_0x1bbf4f0 = cpssp->port_0x1bbf4f0;
	}
	if (cpssp->oldport_0x1bbf510 != cpssp->port_0x1bbf510) {
		COMP_(draw_0x1bbf510)((void* ) cpssp, cpssp->port_0x1bbf510);
		cpssp->oldport_0x1bbf510 = cpssp->port_0x1bbf510;
	}
	if (cpssp->oldport_0x1bbf530 != cpssp->port_0x1bbf530) {
		COMP_(draw_0x1bbf530)((void* ) cpssp, cpssp->port_0x1bbf530);
		cpssp->oldport_0x1bbf530 = cpssp->port_0x1bbf530;
	}
	if (cpssp->oldport_0x1bbf550 != cpssp->port_0x1bbf550) {
		COMP_(draw_0x1bbf550)((void* ) cpssp, cpssp->port_0x1bbf550);
		cpssp->oldport_0x1bbf550 = cpssp->port_0x1bbf550;
	}
	if (cpssp->oldport_0x1bbf570 != cpssp->port_0x1bbf570) {
		COMP_(draw_0x1bbf570)((void* ) cpssp, cpssp->port_0x1bbf570);
		cpssp->oldport_0x1bbf570 = cpssp->port_0x1bbf570;
	}
	if (cpssp->oldport_0x1bbf590 != cpssp->port_0x1bbf590) {
		COMP_(draw_0x1bbf590)((void* ) cpssp, cpssp->port_0x1bbf590);
		cpssp->oldport_0x1bbf590 = cpssp->port_0x1bbf590;
	}
	if (cpssp->oldport_0x1bbf5b0 != cpssp->port_0x1bbf5b0) {
		COMP_(draw_0x1bbf5b0)((void* ) cpssp, cpssp->port_0x1bbf5b0);
		cpssp->oldport_0x1bbf5b0 = cpssp->port_0x1bbf5b0;
	}
	if (cpssp->oldport_0x1bbf5d0 != cpssp->port_0x1bbf5d0) {
		COMP_(draw_0x1bbf5d0)((void* ) cpssp, cpssp->port_0x1bbf5d0);
		cpssp->oldport_0x1bbf5d0 = cpssp->port_0x1bbf5d0;
	}
	if (cpssp->oldport_0x1bbf5f0 != cpssp->port_0x1bbf5f0) {
		COMP_(draw_0x1bbf5f0)((void* ) cpssp, cpssp->port_0x1bbf5f0);
		cpssp->oldport_0x1bbf5f0 = cpssp->port_0x1bbf5f0;
	}
	if (cpssp->oldport_0x1bbf610 != cpssp->port_0x1bbf610) {
		COMP_(draw_0x1bbf610)((void* ) cpssp, cpssp->port_0x1bbf610);
		cpssp->oldport_0x1bbf610 = cpssp->port_0x1bbf610;
	}
	if (cpssp->oldport_0x1bbf630 != cpssp->port_0x1bbf630) {
		COMP_(draw_0x1bbf630)((void* ) cpssp, cpssp->port_0x1bbf630);
		cpssp->oldport_0x1bbf630 = cpssp->port_0x1bbf630;
	}
	if (cpssp->oldport_0x1bbf650 != cpssp->port_0x1bbf650) {
		COMP_(draw_0x1bbf650)((void* ) cpssp, cpssp->port_0x1bbf650);
		cpssp->oldport_0x1bbf650 = cpssp->port_0x1bbf650;
	}
	if (cpssp->oldport_0x1bbf670 != cpssp->port_0x1bbf670) {
		COMP_(draw_0x1bbf670)((void* ) cpssp, cpssp->port_0x1bbf670);
		cpssp->oldport_0x1bbf670 = cpssp->port_0x1bbf670;
	}
	if (cpssp->oldport_0x1bbf690 != cpssp->port_0x1bbf690) {
		COMP_(draw_0x1bbf690)((void* ) cpssp, cpssp->port_0x1bbf690);
		cpssp->oldport_0x1bbf690 = cpssp->port_0x1bbf690;
	}
	if (cpssp->oldport_0x1bbf6b0 != cpssp->port_0x1bbf6b0) {
		COMP_(draw_0x1bbf6b0)((void* ) cpssp, cpssp->port_0x1bbf6b0);
		cpssp->oldport_0x1bbf6b0 = cpssp->port_0x1bbf6b0;
	}
	if (cpssp->oldport_0x1bbf6d0 != cpssp->port_0x1bbf6d0) {
		COMP_(draw_0x1bbf6d0)((void* ) cpssp, cpssp->port_0x1bbf6d0);
		cpssp->oldport_0x1bbf6d0 = cpssp->port_0x1bbf6d0;
	}
	if (cpssp->oldport_0x1bbf6f0 != cpssp->port_0x1bbf6f0) {
		COMP_(draw_0x1bbf6f0)((void* ) cpssp, cpssp->port_0x1bbf6f0);
		cpssp->oldport_0x1bbf6f0 = cpssp->port_0x1bbf6f0;
	}
	if (cpssp->oldport_0x1bbf710 != cpssp->port_0x1bbf710) {
		COMP_(draw_0x1bbf710)((void* ) cpssp, cpssp->port_0x1bbf710);
		cpssp->oldport_0x1bbf710 = cpssp->port_0x1bbf710;
	}
	if (cpssp->oldport_0x1bbf730 != cpssp->port_0x1bbf730) {
		COMP_(draw_0x1bbf730)((void* ) cpssp, cpssp->port_0x1bbf730);
		cpssp->oldport_0x1bbf730 = cpssp->port_0x1bbf730;
	}
	if (cpssp->oldport_0x1bbf750 != cpssp->port_0x1bbf750) {
		COMP_(draw_0x1bbf750)((void* ) cpssp, cpssp->port_0x1bbf750);
		cpssp->oldport_0x1bbf750 = cpssp->port_0x1bbf750;
	}
	if (cpssp->oldport_0x1bc05f0 != cpssp->port_0x1bc05f0) {
		COMP_(draw_0x1bc05f0)((void* ) cpssp, cpssp->port_0x1bc05f0);
		cpssp->oldport_0x1bc05f0 = cpssp->port_0x1bc05f0;
	}
	if (cpssp->oldport_0x1bc0740 != cpssp->port_0x1bc0740) {
		COMP_(draw_0x1bc0740)((void* ) cpssp, cpssp->port_0x1bc0740);
		cpssp->oldport_0x1bc0740 = cpssp->port_0x1bc0740;
	}
	if (cpssp->oldport_0x1bc0890 != cpssp->port_0x1bc0890) {
		COMP_(draw_0x1bc0890)((void* ) cpssp, cpssp->port_0x1bc0890);
		cpssp->oldport_0x1bc0890 = cpssp->port_0x1bc0890;
	}
	if (cpssp->oldport_0x1bc09e0 != cpssp->port_0x1bc09e0) {
		COMP_(draw_0x1bc09e0)((void* ) cpssp, cpssp->port_0x1bc09e0);
		cpssp->oldport_0x1bc09e0 = cpssp->port_0x1bc09e0;
	}
	if (cpssp->oldport_0x1bc0b30 != cpssp->port_0x1bc0b30) {
		COMP_(draw_0x1bc0b30)((void* ) cpssp, cpssp->port_0x1bc0b30);
		cpssp->oldport_0x1bc0b30 = cpssp->port_0x1bc0b30;
	}
	if (cpssp->oldport_0x1bc0c80 != cpssp->port_0x1bc0c80) {
		COMP_(draw_0x1bc0c80)((void* ) cpssp, cpssp->port_0x1bc0c80);
		cpssp->oldport_0x1bc0c80 = cpssp->port_0x1bc0c80;
	}
	if (cpssp->oldport_0x1bc0dd0 != cpssp->port_0x1bc0dd0) {
		COMP_(draw_0x1bc0dd0)((void* ) cpssp, cpssp->port_0x1bc0dd0);
		cpssp->oldport_0x1bc0dd0 = cpssp->port_0x1bc0dd0;
	}
	if (cpssp->oldport_0x1bc0f20 != cpssp->port_0x1bc0f20) {
		COMP_(draw_0x1bc0f20)((void* ) cpssp, cpssp->port_0x1bc0f20);
		cpssp->oldport_0x1bc0f20 = cpssp->port_0x1bc0f20;
	}
	if (cpssp->oldport_0x1bc1070 != cpssp->port_0x1bc1070) {
		COMP_(draw_0x1bc1070)((void* ) cpssp, cpssp->port_0x1bc1070);
		cpssp->oldport_0x1bc1070 = cpssp->port_0x1bc1070;
	}
	if (cpssp->oldport_0x1bc11c0 != cpssp->port_0x1bc11c0) {
		COMP_(draw_0x1bc11c0)((void* ) cpssp, cpssp->port_0x1bc11c0);
		cpssp->oldport_0x1bc11c0 = cpssp->port_0x1bc11c0;
	}
	if (cpssp->oldport_0x1bc1310 != cpssp->port_0x1bc1310) {
		COMP_(draw_0x1bc1310)((void* ) cpssp, cpssp->port_0x1bc1310);
		cpssp->oldport_0x1bc1310 = cpssp->port_0x1bc1310;
	}
	if (cpssp->oldport_0x1bc1460 != cpssp->port_0x1bc1460) {
		COMP_(draw_0x1bc1460)((void* ) cpssp, cpssp->port_0x1bc1460);
		cpssp->oldport_0x1bc1460 = cpssp->port_0x1bc1460;
	}
	if (cpssp->oldport_0x1bc15b0 != cpssp->port_0x1bc15b0) {
		COMP_(draw_0x1bc15b0)((void* ) cpssp, cpssp->port_0x1bc15b0);
		cpssp->oldport_0x1bc15b0 = cpssp->port_0x1bc15b0;
	}
	if (cpssp->oldport_0x1bc1700 != cpssp->port_0x1bc1700) {
		COMP_(draw_0x1bc1700)((void* ) cpssp, cpssp->port_0x1bc1700);
		cpssp->oldport_0x1bc1700 = cpssp->port_0x1bc1700;
	}
	if (cpssp->oldport_0x1bc1850 != cpssp->port_0x1bc1850) {
		COMP_(draw_0x1bc1850)((void* ) cpssp, cpssp->port_0x1bc1850);
		cpssp->oldport_0x1bc1850 = cpssp->port_0x1bc1850;
	}
	if (cpssp->oldport_0x1bc19a0 != cpssp->port_0x1bc19a0) {
		COMP_(draw_0x1bc19a0)((void* ) cpssp, cpssp->port_0x1bc19a0);
		cpssp->oldport_0x1bc19a0 = cpssp->port_0x1bc19a0;
	}
	if (cpssp->oldport_0x1bc1af0 != cpssp->port_0x1bc1af0) {
		COMP_(draw_0x1bc1af0)((void* ) cpssp, cpssp->port_0x1bc1af0);
		cpssp->oldport_0x1bc1af0 = cpssp->port_0x1bc1af0;
	}
	if (cpssp->oldport_0x1bc1c40 != cpssp->port_0x1bc1c40) {
		COMP_(draw_0x1bc1c40)((void* ) cpssp, cpssp->port_0x1bc1c40);
		cpssp->oldport_0x1bc1c40 = cpssp->port_0x1bc1c40;
	}
	if (cpssp->oldport_0x1bc1d90 != cpssp->port_0x1bc1d90) {
		COMP_(draw_0x1bc1d90)((void* ) cpssp, cpssp->port_0x1bc1d90);
		cpssp->oldport_0x1bc1d90 = cpssp->port_0x1bc1d90;
	}
	if (cpssp->oldport_0x1bc1ee0 != cpssp->port_0x1bc1ee0) {
		COMP_(draw_0x1bc1ee0)((void* ) cpssp, cpssp->port_0x1bc1ee0);
		cpssp->oldport_0x1bc1ee0 = cpssp->port_0x1bc1ee0;
	}
	if (cpssp->oldport_0x1bc2030 != cpssp->port_0x1bc2030) {
		COMP_(draw_0x1bc2030)((void* ) cpssp, cpssp->port_0x1bc2030);
		cpssp->oldport_0x1bc2030 = cpssp->port_0x1bc2030;
	}
	if (cpssp->oldport_0x1bc2180 != cpssp->port_0x1bc2180) {
		COMP_(draw_0x1bc2180)((void* ) cpssp, cpssp->port_0x1bc2180);
		cpssp->oldport_0x1bc2180 = cpssp->port_0x1bc2180;
	}
	if (cpssp->oldport_0x1bc22d0 != cpssp->port_0x1bc22d0) {
		COMP_(draw_0x1bc22d0)((void* ) cpssp, cpssp->port_0x1bc22d0);
		cpssp->oldport_0x1bc22d0 = cpssp->port_0x1bc22d0;
	}
	if (cpssp->oldport_0x1bc2420 != cpssp->port_0x1bc2420) {
		COMP_(draw_0x1bc2420)((void* ) cpssp, cpssp->port_0x1bc2420);
		cpssp->oldport_0x1bc2420 = cpssp->port_0x1bc2420;
	}
	if (cpssp->oldport_0x1bc2570 != cpssp->port_0x1bc2570) {
		COMP_(draw_0x1bc2570)((void* ) cpssp, cpssp->port_0x1bc2570);
		cpssp->oldport_0x1bc2570 = cpssp->port_0x1bc2570;
	}
	if (cpssp->oldport_0x1bc26c0 != cpssp->port_0x1bc26c0) {
		COMP_(draw_0x1bc26c0)((void* ) cpssp, cpssp->port_0x1bc26c0);
		cpssp->oldport_0x1bc26c0 = cpssp->port_0x1bc26c0;
	}
	if (cpssp->oldport_0x1bc2810 != cpssp->port_0x1bc2810) {
		COMP_(draw_0x1bc2810)((void* ) cpssp, cpssp->port_0x1bc2810);
		cpssp->oldport_0x1bc2810 = cpssp->port_0x1bc2810;
	}
	if (cpssp->oldport_0x1bc2960 != cpssp->port_0x1bc2960) {
		COMP_(draw_0x1bc2960)((void* ) cpssp, cpssp->port_0x1bc2960);
		cpssp->oldport_0x1bc2960 = cpssp->port_0x1bc2960;
	}
	if (cpssp->oldport_0x1bc2ab0 != cpssp->port_0x1bc2ab0) {
		COMP_(draw_0x1bc2ab0)((void* ) cpssp, cpssp->port_0x1bc2ab0);
		cpssp->oldport_0x1bc2ab0 = cpssp->port_0x1bc2ab0;
	}
	if (cpssp->oldport_0x1bc2c00 != cpssp->port_0x1bc2c00) {
		COMP_(draw_0x1bc2c00)((void* ) cpssp, cpssp->port_0x1bc2c00);
		cpssp->oldport_0x1bc2c00 = cpssp->port_0x1bc2c00;
	}
	if (cpssp->oldport_0x1bc2d50 != cpssp->port_0x1bc2d50) {
		COMP_(draw_0x1bc2d50)((void* ) cpssp, cpssp->port_0x1bc2d50);
		cpssp->oldport_0x1bc2d50 = cpssp->port_0x1bc2d50;
	}
	if (cpssp->oldport_0x1bc2ea0 != cpssp->port_0x1bc2ea0) {
		COMP_(draw_0x1bc2ea0)((void* ) cpssp, cpssp->port_0x1bc2ea0);
		cpssp->oldport_0x1bc2ea0 = cpssp->port_0x1bc2ea0;
	}
	if (cpssp->oldport_0x1bc2ff0 != cpssp->port_0x1bc2ff0) {
		COMP_(draw_0x1bc2ff0)((void* ) cpssp, cpssp->port_0x1bc2ff0);
		cpssp->oldport_0x1bc2ff0 = cpssp->port_0x1bc2ff0;
	}
	if (cpssp->oldport_0x1bc3140 != cpssp->port_0x1bc3140) {
		COMP_(draw_0x1bc3140)((void* ) cpssp, cpssp->port_0x1bc3140);
		cpssp->oldport_0x1bc3140 = cpssp->port_0x1bc3140;
	}
	if (cpssp->oldport_0x1bc3290 != cpssp->port_0x1bc3290) {
		COMP_(draw_0x1bc3290)((void* ) cpssp, cpssp->port_0x1bc3290);
		cpssp->oldport_0x1bc3290 = cpssp->port_0x1bc3290;
	}
	if (cpssp->oldport_0x1bc33e0 != cpssp->port_0x1bc33e0) {
		COMP_(draw_0x1bc33e0)((void* ) cpssp, cpssp->port_0x1bc33e0);
		cpssp->oldport_0x1bc33e0 = cpssp->port_0x1bc33e0;
	}
	if (cpssp->oldport_0x1bc3530 != cpssp->port_0x1bc3530) {
		COMP_(draw_0x1bc3530)((void* ) cpssp, cpssp->port_0x1bc3530);
		cpssp->oldport_0x1bc3530 = cpssp->port_0x1bc3530;
	}
	if (cpssp->oldport_0x1bc3680 != cpssp->port_0x1bc3680) {
		COMP_(draw_0x1bc3680)((void* ) cpssp, cpssp->port_0x1bc3680);
		cpssp->oldport_0x1bc3680 = cpssp->port_0x1bc3680;
	}
	if (cpssp->oldport_0x1bc37d0 != cpssp->port_0x1bc37d0) {
		COMP_(draw_0x1bc37d0)((void* ) cpssp, cpssp->port_0x1bc37d0);
		cpssp->oldport_0x1bc37d0 = cpssp->port_0x1bc37d0;
	}
	if (cpssp->oldport_0x1bc3920 != cpssp->port_0x1bc3920) {
		COMP_(draw_0x1bc3920)((void* ) cpssp, cpssp->port_0x1bc3920);
		cpssp->oldport_0x1bc3920 = cpssp->port_0x1bc3920;
	}
	if (cpssp->oldport_0x1bc3a70 != cpssp->port_0x1bc3a70) {
		COMP_(draw_0x1bc3a70)((void* ) cpssp, cpssp->port_0x1bc3a70);
		cpssp->oldport_0x1bc3a70 = cpssp->port_0x1bc3a70;
	}
	if (cpssp->oldport_0x1bc3bc0 != cpssp->port_0x1bc3bc0) {
		COMP_(draw_0x1bc3bc0)((void* ) cpssp, cpssp->port_0x1bc3bc0);
		cpssp->oldport_0x1bc3bc0 = cpssp->port_0x1bc3bc0;
	}
	if (cpssp->oldport_0x1bc3d10 != cpssp->port_0x1bc3d10) {
		COMP_(draw_0x1bc3d10)((void* ) cpssp, cpssp->port_0x1bc3d10);
		cpssp->oldport_0x1bc3d10 = cpssp->port_0x1bc3d10;
	}
	if (cpssp->oldport_0x1bc3e60 != cpssp->port_0x1bc3e60) {
		COMP_(draw_0x1bc3e60)((void* ) cpssp, cpssp->port_0x1bc3e60);
		cpssp->oldport_0x1bc3e60 = cpssp->port_0x1bc3e60;
	}
	if (cpssp->oldport_0x1bc3fb0 != cpssp->port_0x1bc3fb0) {
		COMP_(draw_0x1bc3fb0)((void* ) cpssp, cpssp->port_0x1bc3fb0);
		cpssp->oldport_0x1bc3fb0 = cpssp->port_0x1bc3fb0;
	}
	if (cpssp->oldport_0x1bc4100 != cpssp->port_0x1bc4100) {
		COMP_(draw_0x1bc4100)((void* ) cpssp, cpssp->port_0x1bc4100);
		cpssp->oldport_0x1bc4100 = cpssp->port_0x1bc4100;
	}
	if (cpssp->oldport_0x1bc4250 != cpssp->port_0x1bc4250) {
		COMP_(draw_0x1bc4250)((void* ) cpssp, cpssp->port_0x1bc4250);
		cpssp->oldport_0x1bc4250 = cpssp->port_0x1bc4250;
	}
	if (cpssp->oldport_0x1bc43a0 != cpssp->port_0x1bc43a0) {
		COMP_(draw_0x1bc43a0)((void* ) cpssp, cpssp->port_0x1bc43a0);
		cpssp->oldport_0x1bc43a0 = cpssp->port_0x1bc43a0;
	}
	if (cpssp->oldport_0x1bc44f0 != cpssp->port_0x1bc44f0) {
		COMP_(draw_0x1bc44f0)((void* ) cpssp, cpssp->port_0x1bc44f0);
		cpssp->oldport_0x1bc44f0 = cpssp->port_0x1bc44f0;
	}
	if (cpssp->oldport_0x1bc4640 != cpssp->port_0x1bc4640) {
		COMP_(draw_0x1bc4640)((void* ) cpssp, cpssp->port_0x1bc4640);
		cpssp->oldport_0x1bc4640 = cpssp->port_0x1bc4640;
	}
	if (cpssp->oldport_0x1bc4790 != cpssp->port_0x1bc4790) {
		COMP_(draw_0x1bc4790)((void* ) cpssp, cpssp->port_0x1bc4790);
		cpssp->oldport_0x1bc4790 = cpssp->port_0x1bc4790;
	}
	if (cpssp->oldport_0x1bc48e0 != cpssp->port_0x1bc48e0) {
		COMP_(draw_0x1bc48e0)((void* ) cpssp, cpssp->port_0x1bc48e0);
		cpssp->oldport_0x1bc48e0 = cpssp->port_0x1bc48e0;
	}
	if (cpssp->oldport_0x1bc4a30 != cpssp->port_0x1bc4a30) {
		COMP_(draw_0x1bc4a30)((void* ) cpssp, cpssp->port_0x1bc4a30);
		cpssp->oldport_0x1bc4a30 = cpssp->port_0x1bc4a30;
	}
	if (cpssp->oldport_0x1bc4b80 != cpssp->port_0x1bc4b80) {
		COMP_(draw_0x1bc4b80)((void* ) cpssp, cpssp->port_0x1bc4b80);
		cpssp->oldport_0x1bc4b80 = cpssp->port_0x1bc4b80;
	}
	if (cpssp->oldport_0x1bc4cd0 != cpssp->port_0x1bc4cd0) {
		COMP_(draw_0x1bc4cd0)((void* ) cpssp, cpssp->port_0x1bc4cd0);
		cpssp->oldport_0x1bc4cd0 = cpssp->port_0x1bc4cd0;
	}
	if (cpssp->oldport_0x1bc4e20 != cpssp->port_0x1bc4e20) {
		COMP_(draw_0x1bc4e20)((void* ) cpssp, cpssp->port_0x1bc4e20);
		cpssp->oldport_0x1bc4e20 = cpssp->port_0x1bc4e20;
	}
	if (cpssp->oldport_0x1bc4f70 != cpssp->port_0x1bc4f70) {
		COMP_(draw_0x1bc4f70)((void* ) cpssp, cpssp->port_0x1bc4f70);
		cpssp->oldport_0x1bc4f70 = cpssp->port_0x1bc4f70;
	}
	if (cpssp->oldport_0x1bc50c0 != cpssp->port_0x1bc50c0) {
		COMP_(draw_0x1bc50c0)((void* ) cpssp, cpssp->port_0x1bc50c0);
		cpssp->oldport_0x1bc50c0 = cpssp->port_0x1bc50c0;
	}
	if (cpssp->oldport_0x1bc5210 != cpssp->port_0x1bc5210) {
		COMP_(draw_0x1bc5210)((void* ) cpssp, cpssp->port_0x1bc5210);
		cpssp->oldport_0x1bc5210 = cpssp->port_0x1bc5210;
	}
	if (cpssp->oldport_0x1bc5360 != cpssp->port_0x1bc5360) {
		COMP_(draw_0x1bc5360)((void* ) cpssp, cpssp->port_0x1bc5360);
		cpssp->oldport_0x1bc5360 = cpssp->port_0x1bc5360;
	}
	if (cpssp->oldport_0x1bc54b0 != cpssp->port_0x1bc54b0) {
		COMP_(draw_0x1bc54b0)((void* ) cpssp, cpssp->port_0x1bc54b0);
		cpssp->oldport_0x1bc54b0 = cpssp->port_0x1bc54b0;
	}
	if (cpssp->oldport_0x1bc5600 != cpssp->port_0x1bc5600) {
		COMP_(draw_0x1bc5600)((void* ) cpssp, cpssp->port_0x1bc5600);
		cpssp->oldport_0x1bc5600 = cpssp->port_0x1bc5600;
	}
	if (cpssp->oldport_0x1bc5750 != cpssp->port_0x1bc5750) {
		COMP_(draw_0x1bc5750)((void* ) cpssp, cpssp->port_0x1bc5750);
		cpssp->oldport_0x1bc5750 = cpssp->port_0x1bc5750;
	}
	if (cpssp->oldport_0x1bc58a0 != cpssp->port_0x1bc58a0) {
		COMP_(draw_0x1bc58a0)((void* ) cpssp, cpssp->port_0x1bc58a0);
		cpssp->oldport_0x1bc58a0 = cpssp->port_0x1bc58a0;
	}
	if (cpssp->oldport_0x1bc59f0 != cpssp->port_0x1bc59f0) {
		COMP_(draw_0x1bc59f0)((void* ) cpssp, cpssp->port_0x1bc59f0);
		cpssp->oldport_0x1bc59f0 = cpssp->port_0x1bc59f0;
	}
	if (cpssp->oldport_0x1bc5b40 != cpssp->port_0x1bc5b40) {
		COMP_(draw_0x1bc5b40)((void* ) cpssp, cpssp->port_0x1bc5b40);
		cpssp->oldport_0x1bc5b40 = cpssp->port_0x1bc5b40;
	}
	if (cpssp->oldport_0x1bc5c90 != cpssp->port_0x1bc5c90) {
		COMP_(draw_0x1bc5c90)((void* ) cpssp, cpssp->port_0x1bc5c90);
		cpssp->oldport_0x1bc5c90 = cpssp->port_0x1bc5c90;
	}
	if (cpssp->oldport_0x1bc5de0 != cpssp->port_0x1bc5de0) {
		COMP_(draw_0x1bc5de0)((void* ) cpssp, cpssp->port_0x1bc5de0);
		cpssp->oldport_0x1bc5de0 = cpssp->port_0x1bc5de0;
	}
	if (cpssp->oldport_0x1bc5f30 != cpssp->port_0x1bc5f30) {
		COMP_(draw_0x1bc5f30)((void* ) cpssp, cpssp->port_0x1bc5f30);
		cpssp->oldport_0x1bc5f30 = cpssp->port_0x1bc5f30;
	}
	if (cpssp->oldport_0x1bc6080 != cpssp->port_0x1bc6080) {
		COMP_(draw_0x1bc6080)((void* ) cpssp, cpssp->port_0x1bc6080);
		cpssp->oldport_0x1bc6080 = cpssp->port_0x1bc6080;
	}
	if (cpssp->oldport_0x1bc61d0 != cpssp->port_0x1bc61d0) {
		COMP_(draw_0x1bc61d0)((void* ) cpssp, cpssp->port_0x1bc61d0);
		cpssp->oldport_0x1bc61d0 = cpssp->port_0x1bc61d0;
	}
	if (cpssp->oldport_0x1bc6320 != cpssp->port_0x1bc6320) {
		COMP_(draw_0x1bc6320)((void* ) cpssp, cpssp->port_0x1bc6320);
		cpssp->oldport_0x1bc6320 = cpssp->port_0x1bc6320;
	}
	if (cpssp->oldport_0x1bc6470 != cpssp->port_0x1bc6470) {
		COMP_(draw_0x1bc6470)((void* ) cpssp, cpssp->port_0x1bc6470);
		cpssp->oldport_0x1bc6470 = cpssp->port_0x1bc6470;
	}
	if (cpssp->oldport_0x1bc65c0 != cpssp->port_0x1bc65c0) {
		COMP_(draw_0x1bc65c0)((void* ) cpssp, cpssp->port_0x1bc65c0);
		cpssp->oldport_0x1bc65c0 = cpssp->port_0x1bc65c0;
	}
	if (cpssp->oldport_0x1bc6710 != cpssp->port_0x1bc6710) {
		COMP_(draw_0x1bc6710)((void* ) cpssp, cpssp->port_0x1bc6710);
		cpssp->oldport_0x1bc6710 = cpssp->port_0x1bc6710;
	}
	if (cpssp->oldport_0x1bc6860 != cpssp->port_0x1bc6860) {
		COMP_(draw_0x1bc6860)((void* ) cpssp, cpssp->port_0x1bc6860);
		cpssp->oldport_0x1bc6860 = cpssp->port_0x1bc6860;
	}
	if (cpssp->oldport_0x1bc69b0 != cpssp->port_0x1bc69b0) {
		COMP_(draw_0x1bc69b0)((void* ) cpssp, cpssp->port_0x1bc69b0);
		cpssp->oldport_0x1bc69b0 = cpssp->port_0x1bc69b0;
	}
	if (cpssp->oldport_0x1bc6b00 != cpssp->port_0x1bc6b00) {
		COMP_(draw_0x1bc6b00)((void* ) cpssp, cpssp->port_0x1bc6b00);
		cpssp->oldport_0x1bc6b00 = cpssp->port_0x1bc6b00;
	}
	if (cpssp->oldport_0x1bc6c50 != cpssp->port_0x1bc6c50) {
		COMP_(draw_0x1bc6c50)((void* ) cpssp, cpssp->port_0x1bc6c50);
		cpssp->oldport_0x1bc6c50 = cpssp->port_0x1bc6c50;
	}
	if (cpssp->oldport_0x1bc6da0 != cpssp->port_0x1bc6da0) {
		COMP_(draw_0x1bc6da0)((void* ) cpssp, cpssp->port_0x1bc6da0);
		cpssp->oldport_0x1bc6da0 = cpssp->port_0x1bc6da0;
	}
	if (cpssp->oldport_0x1bc6ef0 != cpssp->port_0x1bc6ef0) {
		COMP_(draw_0x1bc6ef0)((void* ) cpssp, cpssp->port_0x1bc6ef0);
		cpssp->oldport_0x1bc6ef0 = cpssp->port_0x1bc6ef0;
	}
	if (cpssp->oldport_0x1bc7040 != cpssp->port_0x1bc7040) {
		COMP_(draw_0x1bc7040)((void* ) cpssp, cpssp->port_0x1bc7040);
		cpssp->oldport_0x1bc7040 = cpssp->port_0x1bc7040;
	}
	if (cpssp->oldport_0x1bc7190 != cpssp->port_0x1bc7190) {
		COMP_(draw_0x1bc7190)((void* ) cpssp, cpssp->port_0x1bc7190);
		cpssp->oldport_0x1bc7190 = cpssp->port_0x1bc7190;
	}
	if (cpssp->oldport_0x1bc72e0 != cpssp->port_0x1bc72e0) {
		COMP_(draw_0x1bc72e0)((void* ) cpssp, cpssp->port_0x1bc72e0);
		cpssp->oldport_0x1bc72e0 = cpssp->port_0x1bc72e0;
	}
	if (cpssp->oldport_0x1bc7430 != cpssp->port_0x1bc7430) {
		COMP_(draw_0x1bc7430)((void* ) cpssp, cpssp->port_0x1bc7430);
		cpssp->oldport_0x1bc7430 = cpssp->port_0x1bc7430;
	}
	if (cpssp->oldport_0x1bc7580 != cpssp->port_0x1bc7580) {
		COMP_(draw_0x1bc7580)((void* ) cpssp, cpssp->port_0x1bc7580);
		cpssp->oldport_0x1bc7580 = cpssp->port_0x1bc7580;
	}
	if (cpssp->oldport_0x1bc76d0 != cpssp->port_0x1bc76d0) {
		COMP_(draw_0x1bc76d0)((void* ) cpssp, cpssp->port_0x1bc76d0);
		cpssp->oldport_0x1bc76d0 = cpssp->port_0x1bc76d0;
	}
	if (cpssp->oldport_0x1bc7820 != cpssp->port_0x1bc7820) {
		COMP_(draw_0x1bc7820)((void* ) cpssp, cpssp->port_0x1bc7820);
		cpssp->oldport_0x1bc7820 = cpssp->port_0x1bc7820;
	}
	if (cpssp->oldport_0x1bc7970 != cpssp->port_0x1bc7970) {
		COMP_(draw_0x1bc7970)((void* ) cpssp, cpssp->port_0x1bc7970);
		cpssp->oldport_0x1bc7970 = cpssp->port_0x1bc7970;
	}
	if (cpssp->oldport_0x1bc7ac0 != cpssp->port_0x1bc7ac0) {
		COMP_(draw_0x1bc7ac0)((void* ) cpssp, cpssp->port_0x1bc7ac0);
		cpssp->oldport_0x1bc7ac0 = cpssp->port_0x1bc7ac0;
	}
	if (cpssp->oldport_0x1bc7c10 != cpssp->port_0x1bc7c10) {
		COMP_(draw_0x1bc7c10)((void* ) cpssp, cpssp->port_0x1bc7c10);
		cpssp->oldport_0x1bc7c10 = cpssp->port_0x1bc7c10;
	}
	if (cpssp->oldport_0x1bc7d60 != cpssp->port_0x1bc7d60) {
		COMP_(draw_0x1bc7d60)((void* ) cpssp, cpssp->port_0x1bc7d60);
		cpssp->oldport_0x1bc7d60 = cpssp->port_0x1bc7d60;
	}
	if (cpssp->oldport_0x1bc7eb0 != cpssp->port_0x1bc7eb0) {
		COMP_(draw_0x1bc7eb0)((void* ) cpssp, cpssp->port_0x1bc7eb0);
		cpssp->oldport_0x1bc7eb0 = cpssp->port_0x1bc7eb0;
	}
	if (cpssp->oldport_0x1bc8000 != cpssp->port_0x1bc8000) {
		COMP_(draw_0x1bc8000)((void* ) cpssp, cpssp->port_0x1bc8000);
		cpssp->oldport_0x1bc8000 = cpssp->port_0x1bc8000;
	}
	if (cpssp->oldport_0x1bc8150 != cpssp->port_0x1bc8150) {
		COMP_(draw_0x1bc8150)((void* ) cpssp, cpssp->port_0x1bc8150);
		cpssp->oldport_0x1bc8150 = cpssp->port_0x1bc8150;
	}
	if (cpssp->oldport_0x1bc82a0 != cpssp->port_0x1bc82a0) {
		COMP_(draw_0x1bc82a0)((void* ) cpssp, cpssp->port_0x1bc82a0);
		cpssp->oldport_0x1bc82a0 = cpssp->port_0x1bc82a0;
	}
	if (cpssp->oldport_0x1bc83f0 != cpssp->port_0x1bc83f0) {
		COMP_(draw_0x1bc83f0)((void* ) cpssp, cpssp->port_0x1bc83f0);
		cpssp->oldport_0x1bc83f0 = cpssp->port_0x1bc83f0;
	}
	if (cpssp->oldport_0x1bc8540 != cpssp->port_0x1bc8540) {
		COMP_(draw_0x1bc8540)((void* ) cpssp, cpssp->port_0x1bc8540);
		cpssp->oldport_0x1bc8540 = cpssp->port_0x1bc8540;
	}
	if (cpssp->oldport_0x1bc8690 != cpssp->port_0x1bc8690) {
		COMP_(draw_0x1bc8690)((void* ) cpssp, cpssp->port_0x1bc8690);
		cpssp->oldport_0x1bc8690 = cpssp->port_0x1bc8690;
	}
	if (cpssp->oldport_0x1bc87e0 != cpssp->port_0x1bc87e0) {
		COMP_(draw_0x1bc87e0)((void* ) cpssp, cpssp->port_0x1bc87e0);
		cpssp->oldport_0x1bc87e0 = cpssp->port_0x1bc87e0;
	}
	if (cpssp->oldport_0x1bc8930 != cpssp->port_0x1bc8930) {
		COMP_(draw_0x1bc8930)((void* ) cpssp, cpssp->port_0x1bc8930);
		cpssp->oldport_0x1bc8930 = cpssp->port_0x1bc8930;
	}
	if (cpssp->oldport_0x1bc8a80 != cpssp->port_0x1bc8a80) {
		COMP_(draw_0x1bc8a80)((void* ) cpssp, cpssp->port_0x1bc8a80);
		cpssp->oldport_0x1bc8a80 = cpssp->port_0x1bc8a80;
	}
	if (cpssp->oldport_0x1bc8bd0 != cpssp->port_0x1bc8bd0) {
		COMP_(draw_0x1bc8bd0)((void* ) cpssp, cpssp->port_0x1bc8bd0);
		cpssp->oldport_0x1bc8bd0 = cpssp->port_0x1bc8bd0;
	}
	if (cpssp->oldport_0x1bc8d20 != cpssp->port_0x1bc8d20) {
		COMP_(draw_0x1bc8d20)((void* ) cpssp, cpssp->port_0x1bc8d20);
		cpssp->oldport_0x1bc8d20 = cpssp->port_0x1bc8d20;
	}
	if (cpssp->oldport_0x1bc8e70 != cpssp->port_0x1bc8e70) {
		COMP_(draw_0x1bc8e70)((void* ) cpssp, cpssp->port_0x1bc8e70);
		cpssp->oldport_0x1bc8e70 = cpssp->port_0x1bc8e70;
	}
	if (cpssp->oldport_0x1bc8fc0 != cpssp->port_0x1bc8fc0) {
		COMP_(draw_0x1bc8fc0)((void* ) cpssp, cpssp->port_0x1bc8fc0);
		cpssp->oldport_0x1bc8fc0 = cpssp->port_0x1bc8fc0;
	}
	if (cpssp->oldport_0x1bb6b50 != cpssp->port_0x1bb6b50) {
		COMP_(draw_0x1bb6b50)((void* ) cpssp, cpssp->port_0x1bb6b50);
		cpssp->oldport_0x1bb6b50 = cpssp->port_0x1bb6b50;
	}
	if (cpssp->oldport_0x1bb8250 != cpssp->port_0x1bb8250) {
		COMP_(draw_0x1bb8250)((void* ) cpssp, cpssp->port_0x1bb8250);
		cpssp->oldport_0x1bb8250 = cpssp->port_0x1bb8250;
	}
	if (cpssp->oldport_0x1bb82b0 != cpssp->port_0x1bb82b0) {
		COMP_(draw_0x1bb82b0)((void* ) cpssp, cpssp->port_0x1bb82b0);
		cpssp->oldport_0x1bb82b0 = cpssp->port_0x1bb82b0;
	}
	if (cpssp->oldport_0x1bc91c0 != cpssp->port_0x1bc91c0) {
		COMP_(draw_0x1bc91c0)((void* ) cpssp, cpssp->port_0x1bc91c0);
		cpssp->oldport_0x1bc91c0 = cpssp->port_0x1bc91c0;
	}
	if (cpssp->oldport_0x1bc9310 != cpssp->port_0x1bc9310) {
		COMP_(draw_0x1bc9310)((void* ) cpssp, cpssp->port_0x1bc9310);
		cpssp->oldport_0x1bc9310 = cpssp->port_0x1bc9310;
	}
	if (cpssp->oldport_0x1bc9460 != cpssp->port_0x1bc9460) {
		COMP_(draw_0x1bc9460)((void* ) cpssp, cpssp->port_0x1bc9460);
		cpssp->oldport_0x1bc9460 = cpssp->port_0x1bc9460;
	}
	if (cpssp->oldport_0x1bc95b0 != cpssp->port_0x1bc95b0) {
		COMP_(draw_0x1bc95b0)((void* ) cpssp, cpssp->port_0x1bc95b0);
		cpssp->oldport_0x1bc95b0 = cpssp->port_0x1bc95b0;
	}
	if (cpssp->oldport_0x1bc9700 != cpssp->port_0x1bc9700) {
		COMP_(draw_0x1bc9700)((void* ) cpssp, cpssp->port_0x1bc9700);
		cpssp->oldport_0x1bc9700 = cpssp->port_0x1bc9700;
	}
	if (cpssp->oldport_0x1bc9850 != cpssp->port_0x1bc9850) {
		COMP_(draw_0x1bc9850)((void* ) cpssp, cpssp->port_0x1bc9850);
		cpssp->oldport_0x1bc9850 = cpssp->port_0x1bc9850;
	}
	if (cpssp->oldport_0x1bc99a0 != cpssp->port_0x1bc99a0) {
		COMP_(draw_0x1bc99a0)((void* ) cpssp, cpssp->port_0x1bc99a0);
		cpssp->oldport_0x1bc99a0 = cpssp->port_0x1bc99a0;
	}
	if (cpssp->oldport_0x1bc9af0 != cpssp->port_0x1bc9af0) {
		COMP_(draw_0x1bc9af0)((void* ) cpssp, cpssp->port_0x1bc9af0);
		cpssp->oldport_0x1bc9af0 = cpssp->port_0x1bc9af0;
	}
	if (cpssp->oldport_0x1bc9c40 != cpssp->port_0x1bc9c40) {
		COMP_(draw_0x1bc9c40)((void* ) cpssp, cpssp->port_0x1bc9c40);
		cpssp->oldport_0x1bc9c40 = cpssp->port_0x1bc9c40;
	}
	if (cpssp->oldport_0x1bc9d90 != cpssp->port_0x1bc9d90) {
		COMP_(draw_0x1bc9d90)((void* ) cpssp, cpssp->port_0x1bc9d90);
		cpssp->oldport_0x1bc9d90 = cpssp->port_0x1bc9d90;
	}
	if (cpssp->oldport_0x1bc9ee0 != cpssp->port_0x1bc9ee0) {
		COMP_(draw_0x1bc9ee0)((void* ) cpssp, cpssp->port_0x1bc9ee0);
		cpssp->oldport_0x1bc9ee0 = cpssp->port_0x1bc9ee0;
	}
	if (cpssp->oldport_0x1bca030 != cpssp->port_0x1bca030) {
		COMP_(draw_0x1bca030)((void* ) cpssp, cpssp->port_0x1bca030);
		cpssp->oldport_0x1bca030 = cpssp->port_0x1bca030;
	}
	if (cpssp->oldport_0x1bca180 != cpssp->port_0x1bca180) {
		COMP_(draw_0x1bca180)((void* ) cpssp, cpssp->port_0x1bca180);
		cpssp->oldport_0x1bca180 = cpssp->port_0x1bca180;
	}
	if (cpssp->oldport_0x1bca2d0 != cpssp->port_0x1bca2d0) {
		COMP_(draw_0x1bca2d0)((void* ) cpssp, cpssp->port_0x1bca2d0);
		cpssp->oldport_0x1bca2d0 = cpssp->port_0x1bca2d0;
	}
	if (cpssp->oldport_0x1bca420 != cpssp->port_0x1bca420) {
		COMP_(draw_0x1bca420)((void* ) cpssp, cpssp->port_0x1bca420);
		cpssp->oldport_0x1bca420 = cpssp->port_0x1bca420;
	}
	if (cpssp->oldport_0x1bca570 != cpssp->port_0x1bca570) {
		COMP_(draw_0x1bca570)((void* ) cpssp, cpssp->port_0x1bca570);
		cpssp->oldport_0x1bca570 = cpssp->port_0x1bca570;
	}
	if (cpssp->oldport_0x1bca6c0 != cpssp->port_0x1bca6c0) {
		COMP_(draw_0x1bca6c0)((void* ) cpssp, cpssp->port_0x1bca6c0);
		cpssp->oldport_0x1bca6c0 = cpssp->port_0x1bca6c0;
	}
	if (cpssp->oldport_0x1bca810 != cpssp->port_0x1bca810) {
		COMP_(draw_0x1bca810)((void* ) cpssp, cpssp->port_0x1bca810);
		cpssp->oldport_0x1bca810 = cpssp->port_0x1bca810;
	}
	if (cpssp->oldport_0x1bca960 != cpssp->port_0x1bca960) {
		COMP_(draw_0x1bca960)((void* ) cpssp, cpssp->port_0x1bca960);
		cpssp->oldport_0x1bca960 = cpssp->port_0x1bca960;
	}
	if (cpssp->oldport_0x1bcaab0 != cpssp->port_0x1bcaab0) {
		COMP_(draw_0x1bcaab0)((void* ) cpssp, cpssp->port_0x1bcaab0);
		cpssp->oldport_0x1bcaab0 = cpssp->port_0x1bcaab0;
	}
	if (cpssp->oldport_0x1bcac00 != cpssp->port_0x1bcac00) {
		COMP_(draw_0x1bcac00)((void* ) cpssp, cpssp->port_0x1bcac00);
		cpssp->oldport_0x1bcac00 = cpssp->port_0x1bcac00;
	}
	if (cpssp->oldport_0x1bcad50 != cpssp->port_0x1bcad50) {
		COMP_(draw_0x1bcad50)((void* ) cpssp, cpssp->port_0x1bcad50);
		cpssp->oldport_0x1bcad50 = cpssp->port_0x1bcad50;
	}
	if (cpssp->oldport_0x1bcaea0 != cpssp->port_0x1bcaea0) {
		COMP_(draw_0x1bcaea0)((void* ) cpssp, cpssp->port_0x1bcaea0);
		cpssp->oldport_0x1bcaea0 = cpssp->port_0x1bcaea0;
	}
	if (cpssp->oldport_0x1bcaff0 != cpssp->port_0x1bcaff0) {
		COMP_(draw_0x1bcaff0)((void* ) cpssp, cpssp->port_0x1bcaff0);
		cpssp->oldport_0x1bcaff0 = cpssp->port_0x1bcaff0;
	}
	if (cpssp->oldport_0x1bcb140 != cpssp->port_0x1bcb140) {
		COMP_(draw_0x1bcb140)((void* ) cpssp, cpssp->port_0x1bcb140);
		cpssp->oldport_0x1bcb140 = cpssp->port_0x1bcb140;
	}
	if (cpssp->oldport_0x1bcb290 != cpssp->port_0x1bcb290) {
		COMP_(draw_0x1bcb290)((void* ) cpssp, cpssp->port_0x1bcb290);
		cpssp->oldport_0x1bcb290 = cpssp->port_0x1bcb290;
	}
	if (cpssp->oldport_0x1bcb3e0 != cpssp->port_0x1bcb3e0) {
		COMP_(draw_0x1bcb3e0)((void* ) cpssp, cpssp->port_0x1bcb3e0);
		cpssp->oldport_0x1bcb3e0 = cpssp->port_0x1bcb3e0;
	}
	if (cpssp->oldport_0x1bcb530 != cpssp->port_0x1bcb530) {
		COMP_(draw_0x1bcb530)((void* ) cpssp, cpssp->port_0x1bcb530);
		cpssp->oldport_0x1bcb530 = cpssp->port_0x1bcb530;
	}
	if (cpssp->oldport_0x1bcb680 != cpssp->port_0x1bcb680) {
		COMP_(draw_0x1bcb680)((void* ) cpssp, cpssp->port_0x1bcb680);
		cpssp->oldport_0x1bcb680 = cpssp->port_0x1bcb680;
	}
	if (cpssp->oldport_0x1bcb7d0 != cpssp->port_0x1bcb7d0) {
		COMP_(draw_0x1bcb7d0)((void* ) cpssp, cpssp->port_0x1bcb7d0);
		cpssp->oldport_0x1bcb7d0 = cpssp->port_0x1bcb7d0;
	}
	if (cpssp->oldport_0x1bcb920 != cpssp->port_0x1bcb920) {
		COMP_(draw_0x1bcb920)((void* ) cpssp, cpssp->port_0x1bcb920);
		cpssp->oldport_0x1bcb920 = cpssp->port_0x1bcb920;
	}
	if (cpssp->oldport_0x1bcba70 != cpssp->port_0x1bcba70) {
		COMP_(draw_0x1bcba70)((void* ) cpssp, cpssp->port_0x1bcba70);
		cpssp->oldport_0x1bcba70 = cpssp->port_0x1bcba70;
	}
	if (cpssp->oldport_0x1bcbbc0 != cpssp->port_0x1bcbbc0) {
		COMP_(draw_0x1bcbbc0)((void* ) cpssp, cpssp->port_0x1bcbbc0);
		cpssp->oldport_0x1bcbbc0 = cpssp->port_0x1bcbbc0;
	}
	if (cpssp->oldport_0x1bcbd10 != cpssp->port_0x1bcbd10) {
		COMP_(draw_0x1bcbd10)((void* ) cpssp, cpssp->port_0x1bcbd10);
		cpssp->oldport_0x1bcbd10 = cpssp->port_0x1bcbd10;
	}
	if (cpssp->oldport_0x1bcbe60 != cpssp->port_0x1bcbe60) {
		COMP_(draw_0x1bcbe60)((void* ) cpssp, cpssp->port_0x1bcbe60);
		cpssp->oldport_0x1bcbe60 = cpssp->port_0x1bcbe60;
	}
	if (cpssp->oldport_0x1bcbfb0 != cpssp->port_0x1bcbfb0) {
		COMP_(draw_0x1bcbfb0)((void* ) cpssp, cpssp->port_0x1bcbfb0);
		cpssp->oldport_0x1bcbfb0 = cpssp->port_0x1bcbfb0;
	}
	if (cpssp->oldport_0x1bcc100 != cpssp->port_0x1bcc100) {
		COMP_(draw_0x1bcc100)((void* ) cpssp, cpssp->port_0x1bcc100);
		cpssp->oldport_0x1bcc100 = cpssp->port_0x1bcc100;
	}
	if (cpssp->oldport_0x1bcc250 != cpssp->port_0x1bcc250) {
		COMP_(draw_0x1bcc250)((void* ) cpssp, cpssp->port_0x1bcc250);
		cpssp->oldport_0x1bcc250 = cpssp->port_0x1bcc250;
	}
	if (cpssp->oldport_0x1bcc3a0 != cpssp->port_0x1bcc3a0) {
		COMP_(draw_0x1bcc3a0)((void* ) cpssp, cpssp->port_0x1bcc3a0);
		cpssp->oldport_0x1bcc3a0 = cpssp->port_0x1bcc3a0;
	}
	if (cpssp->oldport_0x1bcc4f0 != cpssp->port_0x1bcc4f0) {
		COMP_(draw_0x1bcc4f0)((void* ) cpssp, cpssp->port_0x1bcc4f0);
		cpssp->oldport_0x1bcc4f0 = cpssp->port_0x1bcc4f0;
	}
	if (cpssp->oldport_0x1bcc640 != cpssp->port_0x1bcc640) {
		COMP_(draw_0x1bcc640)((void* ) cpssp, cpssp->port_0x1bcc640);
		cpssp->oldport_0x1bcc640 = cpssp->port_0x1bcc640;
	}
	if (cpssp->oldport_0x1bcc790 != cpssp->port_0x1bcc790) {
		COMP_(draw_0x1bcc790)((void* ) cpssp, cpssp->port_0x1bcc790);
		cpssp->oldport_0x1bcc790 = cpssp->port_0x1bcc790;
	}
	if (cpssp->oldport_0x1bcc8e0 != cpssp->port_0x1bcc8e0) {
		COMP_(draw_0x1bcc8e0)((void* ) cpssp, cpssp->port_0x1bcc8e0);
		cpssp->oldport_0x1bcc8e0 = cpssp->port_0x1bcc8e0;
	}
	if (cpssp->oldport_0x1bcca30 != cpssp->port_0x1bcca30) {
		COMP_(draw_0x1bcca30)((void* ) cpssp, cpssp->port_0x1bcca30);
		cpssp->oldport_0x1bcca30 = cpssp->port_0x1bcca30;
	}
	if (cpssp->oldport_0x1bccb80 != cpssp->port_0x1bccb80) {
		COMP_(draw_0x1bccb80)((void* ) cpssp, cpssp->port_0x1bccb80);
		cpssp->oldport_0x1bccb80 = cpssp->port_0x1bccb80;
	}
	if (cpssp->oldport_0x1bcccd0 != cpssp->port_0x1bcccd0) {
		COMP_(draw_0x1bcccd0)((void* ) cpssp, cpssp->port_0x1bcccd0);
		cpssp->oldport_0x1bcccd0 = cpssp->port_0x1bcccd0;
	}
	if (cpssp->oldport_0x1bcce20 != cpssp->port_0x1bcce20) {
		COMP_(draw_0x1bcce20)((void* ) cpssp, cpssp->port_0x1bcce20);
		cpssp->oldport_0x1bcce20 = cpssp->port_0x1bcce20;
	}
	if (cpssp->oldport_0x1bccf70 != cpssp->port_0x1bccf70) {
		COMP_(draw_0x1bccf70)((void* ) cpssp, cpssp->port_0x1bccf70);
		cpssp->oldport_0x1bccf70 = cpssp->port_0x1bccf70;
	}
	if (cpssp->oldport_0x1bcd0c0 != cpssp->port_0x1bcd0c0) {
		COMP_(draw_0x1bcd0c0)((void* ) cpssp, cpssp->port_0x1bcd0c0);
		cpssp->oldport_0x1bcd0c0 = cpssp->port_0x1bcd0c0;
	}
	if (cpssp->oldport_0x1bcd210 != cpssp->port_0x1bcd210) {
		COMP_(draw_0x1bcd210)((void* ) cpssp, cpssp->port_0x1bcd210);
		cpssp->oldport_0x1bcd210 = cpssp->port_0x1bcd210;
	}
	if (cpssp->oldport_0x1bcd360 != cpssp->port_0x1bcd360) {
		COMP_(draw_0x1bcd360)((void* ) cpssp, cpssp->port_0x1bcd360);
		cpssp->oldport_0x1bcd360 = cpssp->port_0x1bcd360;
	}
	if (cpssp->oldport_0x1bcd4b0 != cpssp->port_0x1bcd4b0) {
		COMP_(draw_0x1bcd4b0)((void* ) cpssp, cpssp->port_0x1bcd4b0);
		cpssp->oldport_0x1bcd4b0 = cpssp->port_0x1bcd4b0;
	}
	if (cpssp->oldport_0x1bcd600 != cpssp->port_0x1bcd600) {
		COMP_(draw_0x1bcd600)((void* ) cpssp, cpssp->port_0x1bcd600);
		cpssp->oldport_0x1bcd600 = cpssp->port_0x1bcd600;
	}
	if (cpssp->oldport_0x1bcd750 != cpssp->port_0x1bcd750) {
		COMP_(draw_0x1bcd750)((void* ) cpssp, cpssp->port_0x1bcd750);
		cpssp->oldport_0x1bcd750 = cpssp->port_0x1bcd750;
	}
	if (cpssp->oldport_0x1bcd8a0 != cpssp->port_0x1bcd8a0) {
		COMP_(draw_0x1bcd8a0)((void* ) cpssp, cpssp->port_0x1bcd8a0);
		cpssp->oldport_0x1bcd8a0 = cpssp->port_0x1bcd8a0;
	}
	if (cpssp->oldport_0x1bcd9f0 != cpssp->port_0x1bcd9f0) {
		COMP_(draw_0x1bcd9f0)((void* ) cpssp, cpssp->port_0x1bcd9f0);
		cpssp->oldport_0x1bcd9f0 = cpssp->port_0x1bcd9f0;
	}
	if (cpssp->oldport_0x1bcdb40 != cpssp->port_0x1bcdb40) {
		COMP_(draw_0x1bcdb40)((void* ) cpssp, cpssp->port_0x1bcdb40);
		cpssp->oldport_0x1bcdb40 = cpssp->port_0x1bcdb40;
	}
	if (cpssp->oldport_0x1bcdc90 != cpssp->port_0x1bcdc90) {
		COMP_(draw_0x1bcdc90)((void* ) cpssp, cpssp->port_0x1bcdc90);
		cpssp->oldport_0x1bcdc90 = cpssp->port_0x1bcdc90;
	}
	if (cpssp->oldport_0x1bcdde0 != cpssp->port_0x1bcdde0) {
		COMP_(draw_0x1bcdde0)((void* ) cpssp, cpssp->port_0x1bcdde0);
		cpssp->oldport_0x1bcdde0 = cpssp->port_0x1bcdde0;
	}
	if (cpssp->oldport_0x1bcdf30 != cpssp->port_0x1bcdf30) {
		COMP_(draw_0x1bcdf30)((void* ) cpssp, cpssp->port_0x1bcdf30);
		cpssp->oldport_0x1bcdf30 = cpssp->port_0x1bcdf30;
	}
	if (cpssp->oldport_0x1bce080 != cpssp->port_0x1bce080) {
		COMP_(draw_0x1bce080)((void* ) cpssp, cpssp->port_0x1bce080);
		cpssp->oldport_0x1bce080 = cpssp->port_0x1bce080;
	}
	if (cpssp->oldport_0x1bce1d0 != cpssp->port_0x1bce1d0) {
		COMP_(draw_0x1bce1d0)((void* ) cpssp, cpssp->port_0x1bce1d0);
		cpssp->oldport_0x1bce1d0 = cpssp->port_0x1bce1d0;
	}
	if (cpssp->oldport_0x1bce320 != cpssp->port_0x1bce320) {
		COMP_(draw_0x1bce320)((void* ) cpssp, cpssp->port_0x1bce320);
		cpssp->oldport_0x1bce320 = cpssp->port_0x1bce320;
	}
	if (cpssp->oldport_0x1bce470 != cpssp->port_0x1bce470) {
		COMP_(draw_0x1bce470)((void* ) cpssp, cpssp->port_0x1bce470);
		cpssp->oldport_0x1bce470 = cpssp->port_0x1bce470;
	}
	if (cpssp->oldport_0x1bce5c0 != cpssp->port_0x1bce5c0) {
		COMP_(draw_0x1bce5c0)((void* ) cpssp, cpssp->port_0x1bce5c0);
		cpssp->oldport_0x1bce5c0 = cpssp->port_0x1bce5c0;
	}
	if (cpssp->oldport_0x1bce710 != cpssp->port_0x1bce710) {
		COMP_(draw_0x1bce710)((void* ) cpssp, cpssp->port_0x1bce710);
		cpssp->oldport_0x1bce710 = cpssp->port_0x1bce710;
	}
	if (cpssp->oldport_0x1bce860 != cpssp->port_0x1bce860) {
		COMP_(draw_0x1bce860)((void* ) cpssp, cpssp->port_0x1bce860);
		cpssp->oldport_0x1bce860 = cpssp->port_0x1bce860;
	}
	if (cpssp->oldport_0x1bce9b0 != cpssp->port_0x1bce9b0) {
		COMP_(draw_0x1bce9b0)((void* ) cpssp, cpssp->port_0x1bce9b0);
		cpssp->oldport_0x1bce9b0 = cpssp->port_0x1bce9b0;
	}
	if (cpssp->oldport_0x1bceb00 != cpssp->port_0x1bceb00) {
		COMP_(draw_0x1bceb00)((void* ) cpssp, cpssp->port_0x1bceb00);
		cpssp->oldport_0x1bceb00 = cpssp->port_0x1bceb00;
	}
	if (cpssp->oldport_0x1bcec50 != cpssp->port_0x1bcec50) {
		COMP_(draw_0x1bcec50)((void* ) cpssp, cpssp->port_0x1bcec50);
		cpssp->oldport_0x1bcec50 = cpssp->port_0x1bcec50;
	}
	if (cpssp->oldport_0x1bceda0 != cpssp->port_0x1bceda0) {
		COMP_(draw_0x1bceda0)((void* ) cpssp, cpssp->port_0x1bceda0);
		cpssp->oldport_0x1bceda0 = cpssp->port_0x1bceda0;
	}
	if (cpssp->oldport_0x1bceef0 != cpssp->port_0x1bceef0) {
		COMP_(draw_0x1bceef0)((void* ) cpssp, cpssp->port_0x1bceef0);
		cpssp->oldport_0x1bceef0 = cpssp->port_0x1bceef0;
	}
	if (cpssp->oldport_0x1bcf040 != cpssp->port_0x1bcf040) {
		COMP_(draw_0x1bcf040)((void* ) cpssp, cpssp->port_0x1bcf040);
		cpssp->oldport_0x1bcf040 = cpssp->port_0x1bcf040;
	}
	if (cpssp->oldport_0x1bcf190 != cpssp->port_0x1bcf190) {
		COMP_(draw_0x1bcf190)((void* ) cpssp, cpssp->port_0x1bcf190);
		cpssp->oldport_0x1bcf190 = cpssp->port_0x1bcf190;
	}
	if (cpssp->oldport_0x1bcf2e0 != cpssp->port_0x1bcf2e0) {
		COMP_(draw_0x1bcf2e0)((void* ) cpssp, cpssp->port_0x1bcf2e0);
		cpssp->oldport_0x1bcf2e0 = cpssp->port_0x1bcf2e0;
	}
	if (cpssp->oldport_0x1bcf430 != cpssp->port_0x1bcf430) {
		COMP_(draw_0x1bcf430)((void* ) cpssp, cpssp->port_0x1bcf430);
		cpssp->oldport_0x1bcf430 = cpssp->port_0x1bcf430;
	}
	if (cpssp->oldport_0x1bcf580 != cpssp->port_0x1bcf580) {
		COMP_(draw_0x1bcf580)((void* ) cpssp, cpssp->port_0x1bcf580);
		cpssp->oldport_0x1bcf580 = cpssp->port_0x1bcf580;
	}
	if (cpssp->oldport_0x1bcf6d0 != cpssp->port_0x1bcf6d0) {
		COMP_(draw_0x1bcf6d0)((void* ) cpssp, cpssp->port_0x1bcf6d0);
		cpssp->oldport_0x1bcf6d0 = cpssp->port_0x1bcf6d0;
	}
	if (cpssp->oldport_0x1bcf820 != cpssp->port_0x1bcf820) {
		COMP_(draw_0x1bcf820)((void* ) cpssp, cpssp->port_0x1bcf820);
		cpssp->oldport_0x1bcf820 = cpssp->port_0x1bcf820;
	}
	if (cpssp->oldport_0x1bcf970 != cpssp->port_0x1bcf970) {
		COMP_(draw_0x1bcf970)((void* ) cpssp, cpssp->port_0x1bcf970);
		cpssp->oldport_0x1bcf970 = cpssp->port_0x1bcf970;
	}
	if (cpssp->oldport_0x1bcfac0 != cpssp->port_0x1bcfac0) {
		COMP_(draw_0x1bcfac0)((void* ) cpssp, cpssp->port_0x1bcfac0);
		cpssp->oldport_0x1bcfac0 = cpssp->port_0x1bcfac0;
	}
	if (cpssp->oldport_0x1bcfc10 != cpssp->port_0x1bcfc10) {
		COMP_(draw_0x1bcfc10)((void* ) cpssp, cpssp->port_0x1bcfc10);
		cpssp->oldport_0x1bcfc10 = cpssp->port_0x1bcfc10;
	}
	if (cpssp->oldport_0x1bcfd60 != cpssp->port_0x1bcfd60) {
		COMP_(draw_0x1bcfd60)((void* ) cpssp, cpssp->port_0x1bcfd60);
		cpssp->oldport_0x1bcfd60 = cpssp->port_0x1bcfd60;
	}
	if (cpssp->oldport_0x1bcfeb0 != cpssp->port_0x1bcfeb0) {
		COMP_(draw_0x1bcfeb0)((void* ) cpssp, cpssp->port_0x1bcfeb0);
		cpssp->oldport_0x1bcfeb0 = cpssp->port_0x1bcfeb0;
	}
	/* redraw the full size */
	gdk_draw_drawable(darea->window,
				darea->style->fg_gc[gtk_widget_get_state (darea)],
				pixmap,
				0, 0,
				0, 0,
				-1, -1);
	gui_gtk_flush();
	time_call_after(TIME_HZ / 4, refresh_monitor, cpssp);
}

gboolean
expose_event_callback (GtkWidget *widget, GdkEventExpose *event, gpointer data)
{

	/* redraw the full size */
	gdk_draw_drawable(widget->window,
				widget->style->fg_gc[gtk_widget_get_state (widget)],
				pixmap,
				event->area.x, event->area.y,
				event->area.x, event->area.y,
				event->area.width, event->area.height);

	gui_gtk_flush();
	return TRUE;
}

/* ports */
static void
COMP_(port_Uhr1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_Uhr1 = val;
#if DEBUG
	fprintf(stderr, "gui port Uhr1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_Uhr2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_Uhr2 = val;
#if DEBUG
	fprintf(stderr, "gui port Uhr2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_Imp1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_Imp1 = val;
#if DEBUG
	fprintf(stderr, "gui port Imp1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_Imp2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_Imp2 = val;
#if DEBUG
	fprintf(stderr, "gui port Imp2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I1 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I2 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I3 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I3 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I4 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I4 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I5 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I5 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I6 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I6 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I7 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I7 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I8 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I8 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I9 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I9 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22I0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22I0 = val;
#if DEBUG
	fprintf(stderr, "gui port 22I0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II1 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II2 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II3 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II3 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II4 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II4 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II5 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II5 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II6 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II6 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II7 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II7 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II8 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II8 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II9 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II9 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22II0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22II0 = val;
#if DEBUG
	fprintf(stderr, "gui port 22II0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III1 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III2 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III3 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III3 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III4 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III4 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III5 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III5 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III6 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III6 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III7 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III7 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III8 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III8 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III9 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III9 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_22III0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_22III0 = val;
#if DEBUG
	fprintf(stderr, "gui port 22III0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I1 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I2 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I3 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I3 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I4 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I4 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I5 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I5 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I6 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I6 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I7 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I7 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I8 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I8 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I9 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I9 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30I0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30I0 = val;
#if DEBUG
	fprintf(stderr, "gui port 30I0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II1 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II2 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II3 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II3 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II4 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II4 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II5 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II5 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II6 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II6 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II7 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II7 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II8 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II8 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II9 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II9 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30II0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30II0 = val;
#if DEBUG
	fprintf(stderr, "gui port 30II0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III1 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III1 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III2 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III2 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III3 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III3 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III4 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III4 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III5 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III5 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III6 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III6 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III7 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III7 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III8 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III8 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III9 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III9 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* ports */
static void
COMP_(port_30III0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_30III0 = val;
#if DEBUG
	fprintf(stderr, "gui port 30III0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb8760_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb8760 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb8760 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb9650_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb9650 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb9650 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb9630_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb9630 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb9630 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb69a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb69a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb69a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb82f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb82f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb82f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb81b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb81b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb81b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb8f00_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb8f00 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb8f00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb3b20_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb3b20 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb3b20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb6a40_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb6a40 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb6a40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb8550_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb8550 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb8550 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb6980_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb6980 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb6980 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb8190_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb8190 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb8190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb6640_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb6640 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb6640 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbe9b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbe9b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbe9b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbe9d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbe9d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbe9d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbe9f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbe9f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbe9f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbea10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbea10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbea10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbea30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbea30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbea30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbea50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbea50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbea50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbea70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbea70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbea70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbea90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbea90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbea90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeab0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeab0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeab0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbead0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbead0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbead0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeaf0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeaf0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeaf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeb10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeb10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeb10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeb30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeb30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeb30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeb50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeb50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeb50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeb70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeb70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeb70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeb90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeb90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeb90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbebb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbebb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbebb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbebd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbebd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbebd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbebf0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbebf0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbebf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbec10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbec10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbec10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbec30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbec30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbec30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbec50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbec50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbec50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbec70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbec70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbec70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbec90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbec90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbec90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbecb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbecb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbecb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbecd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbecd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbecd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbecf0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbecf0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbecf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbed10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbed10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbed10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbed30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbed30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbed30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbed50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbed50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbed50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbed70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbed70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbed70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbed90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbed90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbed90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbedb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbedb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbedb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbedd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbedd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbedd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbedf0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbedf0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbedf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbee10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbee10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbee10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbee30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbee30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbee30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbee50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbee50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbee50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbee70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbee70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbee70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbee90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbee90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbee90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeeb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeeb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeeb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeed0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeed0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeed0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeef0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeef0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeef0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbef10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbef10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbef10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbef30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbef30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbef30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbef50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbef50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbef50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbef70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbef70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbef70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbef90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbef90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbef90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbefb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbefb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbefb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbefd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbefd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbefd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbeff0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbeff0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbeff0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf010_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf010 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf010 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf030_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf030 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf030 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf050_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf050 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf050 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf070_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf070 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf070 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf090_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf090 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf090 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf0b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf0b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf0b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf0d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf0d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf0d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf0f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf0f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf0f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf110_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf110 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf110 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf130_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf130 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf130 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf150_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf150 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf150 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf170_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf170 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf170 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf190_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf190 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf1b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf1b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf1b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf1d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf1d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf1d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf1f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf1f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf1f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf210_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf210 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf210 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf230_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf230 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf230 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf250_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf250 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf270_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf270 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf270 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf290_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf290 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf290 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf2b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf2b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf2b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf2d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf2d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf2d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf2f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf2f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf2f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf310_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf310 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf310 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf330_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf330 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf330 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf350_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf350 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf350 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf370_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf370 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf370 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf390_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf390 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf390 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf3b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf3b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf3b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf3d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf3d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf3d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf3f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf3f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf3f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf410_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf410 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf410 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf430_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf430 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf430 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf450_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf450 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf450 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf470_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf470 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf470 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf490_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf490 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf490 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf4b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf4b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf4b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf4d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf4d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf4d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf4f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf4f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf4f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf510_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf510 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf510 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf530_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf530 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf530 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf550_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf550 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf550 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf570_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf570 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf570 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf590_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf590 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf590 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf5b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf5b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf5b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf5d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf5d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf5d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf5f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf5f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf5f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf610_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf610 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf610 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf630_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf630 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf630 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf650_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf650 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf650 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf670_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf670 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf670 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf690_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf690 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf690 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf6b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf6b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf6b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf6d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf6d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf6d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf6f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf6f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf6f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf710_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf710 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf710 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf730_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf730 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf730 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bbf750_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bbf750 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bbf750 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc05f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc05f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc05f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc0740_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc0740 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc0740 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc0890_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc0890 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc0890 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc09e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc09e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc09e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc0b30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc0b30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc0b30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc0c80_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc0c80 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc0c80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc0dd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc0dd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc0dd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc0f20_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc0f20 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc0f20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1070_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1070 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1070 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc11c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc11c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc11c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1310_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1310 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1310 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1460_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1460 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1460 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc15b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc15b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc15b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1700_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1700 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1700 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1850_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1850 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1850 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc19a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc19a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc19a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1af0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1af0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1af0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1c40_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1c40 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1c40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1d90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1d90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1d90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc1ee0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc1ee0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc1ee0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2030_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2030 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2030 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2180_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2180 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2180 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc22d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc22d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc22d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2420_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2420 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2420 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2570_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2570 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2570 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc26c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc26c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc26c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2810_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2810 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2810 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2960_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2960 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2960 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2ab0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2ab0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2ab0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2c00_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2c00 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2c00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2d50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2d50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2d50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2ea0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2ea0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2ea0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc2ff0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc2ff0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc2ff0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3140_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3140 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3140 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3290_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3290 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3290 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc33e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc33e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc33e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3530_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3530 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3530 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3680_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3680 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3680 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc37d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc37d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc37d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3920_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3920 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3920 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3a70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3a70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3a70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3bc0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3bc0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3bc0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3d10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3d10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3d10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3e60_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3e60 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3e60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc3fb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc3fb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc3fb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4100_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4100 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4100 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4250_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4250 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc43a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc43a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc43a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc44f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc44f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc44f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4640_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4640 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4640 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4790_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4790 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4790 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc48e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc48e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc48e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4a30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4a30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4a30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4b80_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4b80 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4b80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4cd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4cd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4cd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4e20_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4e20 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4e20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc4f70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc4f70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc4f70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc50c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc50c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc50c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5210_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5210 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5210 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5360_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5360 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5360 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc54b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc54b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc54b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5600_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5600 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5600 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5750_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5750 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5750 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc58a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc58a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc58a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc59f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc59f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc59f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5b40_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5b40 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5b40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5c90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5c90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5c90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5de0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5de0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5de0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc5f30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc5f30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc5f30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6080_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6080 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6080 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc61d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc61d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc61d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6320_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6320 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6320 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6470_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6470 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6470 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc65c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc65c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc65c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6710_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6710 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6710 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6860_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6860 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6860 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc69b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc69b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc69b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6b00_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6b00 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6b00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6c50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6c50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6c50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6da0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6da0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6da0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc6ef0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc6ef0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc6ef0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7040_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7040 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7040 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7190_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7190 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc72e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc72e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc72e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7430_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7430 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7430 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7580_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7580 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7580 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc76d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc76d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc76d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7820_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7820 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7820 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7970_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7970 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7970 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7ac0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7ac0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7ac0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7c10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7c10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7c10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7d60_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7d60 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7d60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc7eb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc7eb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc7eb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8000_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8000 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8000 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8150_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8150 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8150 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc82a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc82a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc82a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc83f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc83f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc83f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8540_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8540 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8540 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8690_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8690 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8690 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc87e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc87e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc87e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8930_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8930 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8930 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8a80_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8a80 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8a80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8bd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8bd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8bd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8d20_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8d20 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8d20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8e70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8e70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8e70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc8fc0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc8fc0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc8fc0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb6b50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb6b50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb6b50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb8250_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb8250 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb8250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bb82b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bb82b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bb82b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc91c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc91c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc91c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9310_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9310 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9310 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9460_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9460 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9460 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc95b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc95b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc95b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9700_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9700 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9700 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9850_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9850 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9850 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc99a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc99a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc99a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9af0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9af0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9af0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9c40_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9c40 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9c40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9d90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9d90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9d90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bc9ee0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bc9ee0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bc9ee0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca030_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca030 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca030 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca180_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca180 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca180 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca2d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca2d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca2d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca420_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca420 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca420 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca570_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca570 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca570 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca6c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca6c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca6c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca810_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca810 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca810 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bca960_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bca960 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bca960 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcaab0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcaab0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcaab0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcac00_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcac00 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcac00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcad50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcad50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcad50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcaea0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcaea0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcaea0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcaff0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcaff0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcaff0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb140_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb140 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb140 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb290_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb290 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb290 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb3e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb3e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb3e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb530_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb530 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb530 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb680_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb680 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb680 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb7d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb7d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb7d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcb920_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcb920 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcb920 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcba70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcba70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcba70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcbbc0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcbbc0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcbbc0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcbd10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcbd10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcbd10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcbe60_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcbe60 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcbe60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcbfb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcbfb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcbfb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc100_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc100 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc100 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc250_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc250 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc3a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc3a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc3a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc4f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc4f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc4f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc640_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc640 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc640 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc790_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc790 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc790 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcc8e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcc8e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcc8e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcca30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcca30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcca30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bccb80_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bccb80 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bccb80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcccd0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcccd0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcccd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcce20_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcce20 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcce20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bccf70_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bccf70 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bccf70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd0c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd0c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd0c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd210_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd210 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd210 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd360_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd360 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd360 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd4b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd4b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd4b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd600_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd600 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd600 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd750_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd750 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd750 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd8a0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd8a0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd8a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcd9f0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcd9f0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcd9f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcdb40_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcdb40 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcdb40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcdc90_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcdc90 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcdc90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcdde0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcdde0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcdde0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcdf30_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcdf30 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcdf30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce080_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce080 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce080 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce1d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce1d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce1d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce320_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce320 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce320 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce470_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce470 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce470 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce5c0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce5c0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce5c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce710_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce710 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce710 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce860_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce860 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce860 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bce9b0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bce9b0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bce9b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bceb00_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bceb00 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bceb00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcec50_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcec50 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcec50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bceda0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bceda0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bceda0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bceef0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bceef0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bceef0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf040_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf040 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf040 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf190_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf190 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf2e0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf2e0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf2e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf430_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf430 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf430 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf580_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf580 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf580 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf6d0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf6d0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf6d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf820_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf820 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf820 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcf970_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcf970 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcf970 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcfac0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcfac0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcfac0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcfc10_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcfc10 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcfc10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcfd60_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcfd60 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcfd60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* gui ports */
static void
COMP_(gui_port_0x1bcfeb0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	cpssp->port_0x1bcfeb0 = val;
#if DEBUG
	fprintf(stderr, "gui signal 0x1bcfeb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
/* create */
void *
COMP_(gui_gtk_create)(
			unsigned int page,
			const char *name,
			struct sig_manage *port_manage,
			struct sig_std_logic *port_Uhr1,
			struct sig_std_logic *port_Uhr2,
			struct sig_std_logic *port_Imp1,
			struct sig_std_logic *port_Imp2,
			struct sig_std_logic *port_22I1,
			struct sig_std_logic *port_22I2,
			struct sig_std_logic *port_22I3,
			struct sig_std_logic *port_22I4,
			struct sig_std_logic *port_22I5,
			struct sig_std_logic *port_22I6,
			struct sig_std_logic *port_22I7,
			struct sig_std_logic *port_22I8,
			struct sig_std_logic *port_22I9,
			struct sig_std_logic *port_22I0,
			struct sig_std_logic *port_22II1,
			struct sig_std_logic *port_22II2,
			struct sig_std_logic *port_22II3,
			struct sig_std_logic *port_22II4,
			struct sig_std_logic *port_22II5,
			struct sig_std_logic *port_22II6,
			struct sig_std_logic *port_22II7,
			struct sig_std_logic *port_22II8,
			struct sig_std_logic *port_22II9,
			struct sig_std_logic *port_22II0,
			struct sig_std_logic *port_22III1,
			struct sig_std_logic *port_22III2,
			struct sig_std_logic *port_22III3,
			struct sig_std_logic *port_22III4,
			struct sig_std_logic *port_22III5,
			struct sig_std_logic *port_22III6,
			struct sig_std_logic *port_22III7,
			struct sig_std_logic *port_22III8,
			struct sig_std_logic *port_22III9,
			struct sig_std_logic *port_22III0,
			struct sig_std_logic *port_30I1,
			struct sig_std_logic *port_30I2,
			struct sig_std_logic *port_30I3,
			struct sig_std_logic *port_30I4,
			struct sig_std_logic *port_30I5,
			struct sig_std_logic *port_30I6,
			struct sig_std_logic *port_30I7,
			struct sig_std_logic *port_30I8,
			struct sig_std_logic *port_30I9,
			struct sig_std_logic *port_30I0,
			struct sig_std_logic *port_30II1,
			struct sig_std_logic *port_30II2,
			struct sig_std_logic *port_30II3,
			struct sig_std_logic *port_30II4,
			struct sig_std_logic *port_30II5,
			struct sig_std_logic *port_30II6,
			struct sig_std_logic *port_30II7,
			struct sig_std_logic *port_30II8,
			struct sig_std_logic *port_30II9,
			struct sig_std_logic *port_30II0,
			struct sig_std_logic *port_30III1,
			struct sig_std_logic *port_30III2,
			struct sig_std_logic *port_30III3,
			struct sig_std_logic *port_30III4,
			struct sig_std_logic *port_30III5,
			struct sig_std_logic *port_30III6,
			struct sig_std_logic *port_30III7,
			struct sig_std_logic *port_30III8,
			struct sig_std_logic *port_30III9,
			struct sig_std_logic *port_30III0,
			struct sig_std_logic *gui_port_0x1bb8760,
			struct sig_std_logic *gui_port_0x1bb9650,
			struct sig_std_logic *gui_port_0x1bb9630,
			struct sig_std_logic *gui_port_0x1bb69a0,
			struct sig_std_logic *gui_port_0x1bb82f0,
			struct sig_std_logic *gui_port_0x1bb81b0,
			struct sig_std_logic *gui_port_0x1bb8f00,
			struct sig_std_logic *gui_port_0x1bb3b20,
			struct sig_std_logic *gui_port_0x1bb6a40,
			struct sig_std_logic *gui_port_0x1bb8550,
			struct sig_std_logic *gui_port_0x1bb6980,
			struct sig_std_logic *gui_port_0x1bb8190,
			struct sig_std_logic *gui_port_0x1bb6640,
			struct sig_std_logic *gui_port_0x1bbe9b0,
			struct sig_std_logic *gui_port_0x1bbe9d0,
			struct sig_std_logic *gui_port_0x1bbe9f0,
			struct sig_std_logic *gui_port_0x1bbea10,
			struct sig_std_logic *gui_port_0x1bbea30,
			struct sig_std_logic *gui_port_0x1bbea50,
			struct sig_std_logic *gui_port_0x1bbea70,
			struct sig_std_logic *gui_port_0x1bbea90,
			struct sig_std_logic *gui_port_0x1bbeab0,
			struct sig_std_logic *gui_port_0x1bbead0,
			struct sig_std_logic *gui_port_0x1bbeaf0,
			struct sig_std_logic *gui_port_0x1bbeb10,
			struct sig_std_logic *gui_port_0x1bbeb30,
			struct sig_std_logic *gui_port_0x1bbeb50,
			struct sig_std_logic *gui_port_0x1bbeb70,
			struct sig_std_logic *gui_port_0x1bbeb90,
			struct sig_std_logic *gui_port_0x1bbebb0,
			struct sig_std_logic *gui_port_0x1bbebd0,
			struct sig_std_logic *gui_port_0x1bbebf0,
			struct sig_std_logic *gui_port_0x1bbec10,
			struct sig_std_logic *gui_port_0x1bbec30,
			struct sig_std_logic *gui_port_0x1bbec50,
			struct sig_std_logic *gui_port_0x1bbec70,
			struct sig_std_logic *gui_port_0x1bbec90,
			struct sig_std_logic *gui_port_0x1bbecb0,
			struct sig_std_logic *gui_port_0x1bbecd0,
			struct sig_std_logic *gui_port_0x1bbecf0,
			struct sig_std_logic *gui_port_0x1bbed10,
			struct sig_std_logic *gui_port_0x1bbed30,
			struct sig_std_logic *gui_port_0x1bbed50,
			struct sig_std_logic *gui_port_0x1bbed70,
			struct sig_std_logic *gui_port_0x1bbed90,
			struct sig_std_logic *gui_port_0x1bbedb0,
			struct sig_std_logic *gui_port_0x1bbedd0,
			struct sig_std_logic *gui_port_0x1bbedf0,
			struct sig_std_logic *gui_port_0x1bbee10,
			struct sig_std_logic *gui_port_0x1bbee30,
			struct sig_std_logic *gui_port_0x1bbee50,
			struct sig_std_logic *gui_port_0x1bbee70,
			struct sig_std_logic *gui_port_0x1bbee90,
			struct sig_std_logic *gui_port_0x1bbeeb0,
			struct sig_std_logic *gui_port_0x1bbeed0,
			struct sig_std_logic *gui_port_0x1bbeef0,
			struct sig_std_logic *gui_port_0x1bbef10,
			struct sig_std_logic *gui_port_0x1bbef30,
			struct sig_std_logic *gui_port_0x1bbef50,
			struct sig_std_logic *gui_port_0x1bbef70,
			struct sig_std_logic *gui_port_0x1bbef90,
			struct sig_std_logic *gui_port_0x1bbefb0,
			struct sig_std_logic *gui_port_0x1bbefd0,
			struct sig_std_logic *gui_port_0x1bbeff0,
			struct sig_std_logic *gui_port_0x1bbf010,
			struct sig_std_logic *gui_port_0x1bbf030,
			struct sig_std_logic *gui_port_0x1bbf050,
			struct sig_std_logic *gui_port_0x1bbf070,
			struct sig_std_logic *gui_port_0x1bbf090,
			struct sig_std_logic *gui_port_0x1bbf0b0,
			struct sig_std_logic *gui_port_0x1bbf0d0,
			struct sig_std_logic *gui_port_0x1bbf0f0,
			struct sig_std_logic *gui_port_0x1bbf110,
			struct sig_std_logic *gui_port_0x1bbf130,
			struct sig_std_logic *gui_port_0x1bbf150,
			struct sig_std_logic *gui_port_0x1bbf170,
			struct sig_std_logic *gui_port_0x1bbf190,
			struct sig_std_logic *gui_port_0x1bbf1b0,
			struct sig_std_logic *gui_port_0x1bbf1d0,
			struct sig_std_logic *gui_port_0x1bbf1f0,
			struct sig_std_logic *gui_port_0x1bbf210,
			struct sig_std_logic *gui_port_0x1bbf230,
			struct sig_std_logic *gui_port_0x1bbf250,
			struct sig_std_logic *gui_port_0x1bbf270,
			struct sig_std_logic *gui_port_0x1bbf290,
			struct sig_std_logic *gui_port_0x1bbf2b0,
			struct sig_std_logic *gui_port_0x1bbf2d0,
			struct sig_std_logic *gui_port_0x1bbf2f0,
			struct sig_std_logic *gui_port_0x1bbf310,
			struct sig_std_logic *gui_port_0x1bbf330,
			struct sig_std_logic *gui_port_0x1bbf350,
			struct sig_std_logic *gui_port_0x1bbf370,
			struct sig_std_logic *gui_port_0x1bbf390,
			struct sig_std_logic *gui_port_0x1bbf3b0,
			struct sig_std_logic *gui_port_0x1bbf3d0,
			struct sig_std_logic *gui_port_0x1bbf3f0,
			struct sig_std_logic *gui_port_0x1bbf410,
			struct sig_std_logic *gui_port_0x1bbf430,
			struct sig_std_logic *gui_port_0x1bbf450,
			struct sig_std_logic *gui_port_0x1bbf470,
			struct sig_std_logic *gui_port_0x1bbf490,
			struct sig_std_logic *gui_port_0x1bbf4b0,
			struct sig_std_logic *gui_port_0x1bbf4d0,
			struct sig_std_logic *gui_port_0x1bbf4f0,
			struct sig_std_logic *gui_port_0x1bbf510,
			struct sig_std_logic *gui_port_0x1bbf530,
			struct sig_std_logic *gui_port_0x1bbf550,
			struct sig_std_logic *gui_port_0x1bbf570,
			struct sig_std_logic *gui_port_0x1bbf590,
			struct sig_std_logic *gui_port_0x1bbf5b0,
			struct sig_std_logic *gui_port_0x1bbf5d0,
			struct sig_std_logic *gui_port_0x1bbf5f0,
			struct sig_std_logic *gui_port_0x1bbf610,
			struct sig_std_logic *gui_port_0x1bbf630,
			struct sig_std_logic *gui_port_0x1bbf650,
			struct sig_std_logic *gui_port_0x1bbf670,
			struct sig_std_logic *gui_port_0x1bbf690,
			struct sig_std_logic *gui_port_0x1bbf6b0,
			struct sig_std_logic *gui_port_0x1bbf6d0,
			struct sig_std_logic *gui_port_0x1bbf6f0,
			struct sig_std_logic *gui_port_0x1bbf710,
			struct sig_std_logic *gui_port_0x1bbf730,
			struct sig_std_logic *gui_port_0x1bbf750,
			struct sig_std_logic *gui_port_0x1bc05f0,
			struct sig_std_logic *gui_port_0x1bc0740,
			struct sig_std_logic *gui_port_0x1bc0890,
			struct sig_std_logic *gui_port_0x1bc09e0,
			struct sig_std_logic *gui_port_0x1bc0b30,
			struct sig_std_logic *gui_port_0x1bc0c80,
			struct sig_std_logic *gui_port_0x1bc0dd0,
			struct sig_std_logic *gui_port_0x1bc0f20,
			struct sig_std_logic *gui_port_0x1bc1070,
			struct sig_std_logic *gui_port_0x1bc11c0,
			struct sig_std_logic *gui_port_0x1bc1310,
			struct sig_std_logic *gui_port_0x1bc1460,
			struct sig_std_logic *gui_port_0x1bc15b0,
			struct sig_std_logic *gui_port_0x1bc1700,
			struct sig_std_logic *gui_port_0x1bc1850,
			struct sig_std_logic *gui_port_0x1bc19a0,
			struct sig_std_logic *gui_port_0x1bc1af0,
			struct sig_std_logic *gui_port_0x1bc1c40,
			struct sig_std_logic *gui_port_0x1bc1d90,
			struct sig_std_logic *gui_port_0x1bc1ee0,
			struct sig_std_logic *gui_port_0x1bc2030,
			struct sig_std_logic *gui_port_0x1bc2180,
			struct sig_std_logic *gui_port_0x1bc22d0,
			struct sig_std_logic *gui_port_0x1bc2420,
			struct sig_std_logic *gui_port_0x1bc2570,
			struct sig_std_logic *gui_port_0x1bc26c0,
			struct sig_std_logic *gui_port_0x1bc2810,
			struct sig_std_logic *gui_port_0x1bc2960,
			struct sig_std_logic *gui_port_0x1bc2ab0,
			struct sig_std_logic *gui_port_0x1bc2c00,
			struct sig_std_logic *gui_port_0x1bc2d50,
			struct sig_std_logic *gui_port_0x1bc2ea0,
			struct sig_std_logic *gui_port_0x1bc2ff0,
			struct sig_std_logic *gui_port_0x1bc3140,
			struct sig_std_logic *gui_port_0x1bc3290,
			struct sig_std_logic *gui_port_0x1bc33e0,
			struct sig_std_logic *gui_port_0x1bc3530,
			struct sig_std_logic *gui_port_0x1bc3680,
			struct sig_std_logic *gui_port_0x1bc37d0,
			struct sig_std_logic *gui_port_0x1bc3920,
			struct sig_std_logic *gui_port_0x1bc3a70,
			struct sig_std_logic *gui_port_0x1bc3bc0,
			struct sig_std_logic *gui_port_0x1bc3d10,
			struct sig_std_logic *gui_port_0x1bc3e60,
			struct sig_std_logic *gui_port_0x1bc3fb0,
			struct sig_std_logic *gui_port_0x1bc4100,
			struct sig_std_logic *gui_port_0x1bc4250,
			struct sig_std_logic *gui_port_0x1bc43a0,
			struct sig_std_logic *gui_port_0x1bc44f0,
			struct sig_std_logic *gui_port_0x1bc4640,
			struct sig_std_logic *gui_port_0x1bc4790,
			struct sig_std_logic *gui_port_0x1bc48e0,
			struct sig_std_logic *gui_port_0x1bc4a30,
			struct sig_std_logic *gui_port_0x1bc4b80,
			struct sig_std_logic *gui_port_0x1bc4cd0,
			struct sig_std_logic *gui_port_0x1bc4e20,
			struct sig_std_logic *gui_port_0x1bc4f70,
			struct sig_std_logic *gui_port_0x1bc50c0,
			struct sig_std_logic *gui_port_0x1bc5210,
			struct sig_std_logic *gui_port_0x1bc5360,
			struct sig_std_logic *gui_port_0x1bc54b0,
			struct sig_std_logic *gui_port_0x1bc5600,
			struct sig_std_logic *gui_port_0x1bc5750,
			struct sig_std_logic *gui_port_0x1bc58a0,
			struct sig_std_logic *gui_port_0x1bc59f0,
			struct sig_std_logic *gui_port_0x1bc5b40,
			struct sig_std_logic *gui_port_0x1bc5c90,
			struct sig_std_logic *gui_port_0x1bc5de0,
			struct sig_std_logic *gui_port_0x1bc5f30,
			struct sig_std_logic *gui_port_0x1bc6080,
			struct sig_std_logic *gui_port_0x1bc61d0,
			struct sig_std_logic *gui_port_0x1bc6320,
			struct sig_std_logic *gui_port_0x1bc6470,
			struct sig_std_logic *gui_port_0x1bc65c0,
			struct sig_std_logic *gui_port_0x1bc6710,
			struct sig_std_logic *gui_port_0x1bc6860,
			struct sig_std_logic *gui_port_0x1bc69b0,
			struct sig_std_logic *gui_port_0x1bc6b00,
			struct sig_std_logic *gui_port_0x1bc6c50,
			struct sig_std_logic *gui_port_0x1bc6da0,
			struct sig_std_logic *gui_port_0x1bc6ef0,
			struct sig_std_logic *gui_port_0x1bc7040,
			struct sig_std_logic *gui_port_0x1bc7190,
			struct sig_std_logic *gui_port_0x1bc72e0,
			struct sig_std_logic *gui_port_0x1bc7430,
			struct sig_std_logic *gui_port_0x1bc7580,
			struct sig_std_logic *gui_port_0x1bc76d0,
			struct sig_std_logic *gui_port_0x1bc7820,
			struct sig_std_logic *gui_port_0x1bc7970,
			struct sig_std_logic *gui_port_0x1bc7ac0,
			struct sig_std_logic *gui_port_0x1bc7c10,
			struct sig_std_logic *gui_port_0x1bc7d60,
			struct sig_std_logic *gui_port_0x1bc7eb0,
			struct sig_std_logic *gui_port_0x1bc8000,
			struct sig_std_logic *gui_port_0x1bc8150,
			struct sig_std_logic *gui_port_0x1bc82a0,
			struct sig_std_logic *gui_port_0x1bc83f0,
			struct sig_std_logic *gui_port_0x1bc8540,
			struct sig_std_logic *gui_port_0x1bc8690,
			struct sig_std_logic *gui_port_0x1bc87e0,
			struct sig_std_logic *gui_port_0x1bc8930,
			struct sig_std_logic *gui_port_0x1bc8a80,
			struct sig_std_logic *gui_port_0x1bc8bd0,
			struct sig_std_logic *gui_port_0x1bc8d20,
			struct sig_std_logic *gui_port_0x1bc8e70,
			struct sig_std_logic *gui_port_0x1bc8fc0,
			struct sig_std_logic *gui_port_0x1bb6b50,
			struct sig_std_logic *gui_port_0x1bb8250,
			struct sig_std_logic *gui_port_0x1bb82b0,
			struct sig_std_logic *gui_port_0x1bc91c0,
			struct sig_std_logic *gui_port_0x1bc9310,
			struct sig_std_logic *gui_port_0x1bc9460,
			struct sig_std_logic *gui_port_0x1bc95b0,
			struct sig_std_logic *gui_port_0x1bc9700,
			struct sig_std_logic *gui_port_0x1bc9850,
			struct sig_std_logic *gui_port_0x1bc99a0,
			struct sig_std_logic *gui_port_0x1bc9af0,
			struct sig_std_logic *gui_port_0x1bc9c40,
			struct sig_std_logic *gui_port_0x1bc9d90,
			struct sig_std_logic *gui_port_0x1bc9ee0,
			struct sig_std_logic *gui_port_0x1bca030,
			struct sig_std_logic *gui_port_0x1bca180,
			struct sig_std_logic *gui_port_0x1bca2d0,
			struct sig_std_logic *gui_port_0x1bca420,
			struct sig_std_logic *gui_port_0x1bca570,
			struct sig_std_logic *gui_port_0x1bca6c0,
			struct sig_std_logic *gui_port_0x1bca810,
			struct sig_std_logic *gui_port_0x1bca960,
			struct sig_std_logic *gui_port_0x1bcaab0,
			struct sig_std_logic *gui_port_0x1bcac00,
			struct sig_std_logic *gui_port_0x1bcad50,
			struct sig_std_logic *gui_port_0x1bcaea0,
			struct sig_std_logic *gui_port_0x1bcaff0,
			struct sig_std_logic *gui_port_0x1bcb140,
			struct sig_std_logic *gui_port_0x1bcb290,
			struct sig_std_logic *gui_port_0x1bcb3e0,
			struct sig_std_logic *gui_port_0x1bcb530,
			struct sig_std_logic *gui_port_0x1bcb680,
			struct sig_std_logic *gui_port_0x1bcb7d0,
			struct sig_std_logic *gui_port_0x1bcb920,
			struct sig_std_logic *gui_port_0x1bcba70,
			struct sig_std_logic *gui_port_0x1bcbbc0,
			struct sig_std_logic *gui_port_0x1bcbd10,
			struct sig_std_logic *gui_port_0x1bcbe60,
			struct sig_std_logic *gui_port_0x1bcbfb0,
			struct sig_std_logic *gui_port_0x1bcc100,
			struct sig_std_logic *gui_port_0x1bcc250,
			struct sig_std_logic *gui_port_0x1bcc3a0,
			struct sig_std_logic *gui_port_0x1bcc4f0,
			struct sig_std_logic *gui_port_0x1bcc640,
			struct sig_std_logic *gui_port_0x1bcc790,
			struct sig_std_logic *gui_port_0x1bcc8e0,
			struct sig_std_logic *gui_port_0x1bcca30,
			struct sig_std_logic *gui_port_0x1bccb80,
			struct sig_std_logic *gui_port_0x1bcccd0,
			struct sig_std_logic *gui_port_0x1bcce20,
			struct sig_std_logic *gui_port_0x1bccf70,
			struct sig_std_logic *gui_port_0x1bcd0c0,
			struct sig_std_logic *gui_port_0x1bcd210,
			struct sig_std_logic *gui_port_0x1bcd360,
			struct sig_std_logic *gui_port_0x1bcd4b0,
			struct sig_std_logic *gui_port_0x1bcd600,
			struct sig_std_logic *gui_port_0x1bcd750,
			struct sig_std_logic *gui_port_0x1bcd8a0,
			struct sig_std_logic *gui_port_0x1bcd9f0,
			struct sig_std_logic *gui_port_0x1bcdb40,
			struct sig_std_logic *gui_port_0x1bcdc90,
			struct sig_std_logic *gui_port_0x1bcdde0,
			struct sig_std_logic *gui_port_0x1bcdf30,
			struct sig_std_logic *gui_port_0x1bce080,
			struct sig_std_logic *gui_port_0x1bce1d0,
			struct sig_std_logic *gui_port_0x1bce320,
			struct sig_std_logic *gui_port_0x1bce470,
			struct sig_std_logic *gui_port_0x1bce5c0,
			struct sig_std_logic *gui_port_0x1bce710,
			struct sig_std_logic *gui_port_0x1bce860,
			struct sig_std_logic *gui_port_0x1bce9b0,
			struct sig_std_logic *gui_port_0x1bceb00,
			struct sig_std_logic *gui_port_0x1bcec50,
			struct sig_std_logic *gui_port_0x1bceda0,
			struct sig_std_logic *gui_port_0x1bceef0,
			struct sig_std_logic *gui_port_0x1bcf040,
			struct sig_std_logic *gui_port_0x1bcf190,
			struct sig_std_logic *gui_port_0x1bcf2e0,
			struct sig_std_logic *gui_port_0x1bcf430,
			struct sig_std_logic *gui_port_0x1bcf580,
			struct sig_std_logic *gui_port_0x1bcf6d0,
			struct sig_std_logic *gui_port_0x1bcf820,
			struct sig_std_logic *gui_port_0x1bcf970,
			struct sig_std_logic *gui_port_0x1bcfac0,
			struct sig_std_logic *gui_port_0x1bcfc10,
			struct sig_std_logic *gui_port_0x1bcfd60,
			struct sig_std_logic *gui_port_0x1bcfeb0)
{
	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* parse colors */
	gdk_color_parse ("red", &cpssp->gdk_red);
	gdk_color_parse ("green", &cpssp->gdk_green);
	gdk_color_parse ("blue", &cpssp->gdk_blue);
	gdk_color_parse ("black", &cpssp->gdk_black);

	/* main window */
	cpssp->gui = gui_gtk_monitor_new("VGA", 1600, 1200);
	gtk_widget_show(cpssp->gui);
	
	/* sync it once, initially */
	gui_gtk_monitor_sync(GUI_GTK_MONITOR(cpssp->gui));

	gui_gtk_comp_add(page, name, name, cpssp->gui, TRUE, TRUE, NULL);

	gui_gtk_monitor_grab_focus(GUI_GTK_MONITOR(cpssp->gui));

	/* drawing area */
	darea = (GUI_GTK_MONITOR(cpssp->gui))->screen;
	GTK_WIDGET_SET_FLAGS(darea, GTK_CAN_FOCUS);
	gtk_widget_set_size_request (darea, 3429, 5092);
	g_signal_connect(darea, "expose-event",
			G_CALLBACK(expose_event_callback), cpssp->gui);

	gui_gtk_monitor_sync(GUI_GTK_MONITOR(cpssp->gui));
	/* underlying pixmap */
	create_pixmap(darea);
	/* draw comps */
	draw_text(darea, 1704.062100, 751.786800, "20AII");
	draw_box(cpssp, darea, 1804.252137, 697.472181, 1885.569838, 817.725676);
	draw_text(darea, 1266.752700, 255.349720, "6AI");
	draw_box(cpssp, darea, 1243.195590, 274.886830, 1335.195514, 365.900288);
	draw_text(darea, 1485.736000, 396.372250, "6AII");
	draw_box(cpssp, darea, 1460.997570, 422.223470, 1552.997494, 513.236928);
	draw_text(darea, 1487.767000, 690.858640, "6AIII");
	draw_box(cpssp, darea, 1462.599050, 563.154162, 1554.598974, 654.167620);
	draw_text(darea, 708.662230, 588.494810, "6AIV");
	draw_box(cpssp, darea, 687.480240, 612.800202, 779.480164, 703.813660);
	draw_text(darea, 2344.369900, 1604.781900, "32BIV");
	draw_box(cpssp, darea, 2223.304530, 1551.270500, 2315.304454, 1642.283958);
	draw_text(darea, 2343.958700, 1452.473000, "32BIII");
	draw_box(cpssp, darea, 2221.703030, 1400.730900, 2313.702954, 1491.744358);
	draw_text(darea, 2469.824000, 813.730530, "16AI");
	draw_box(cpssp, darea, 2445.910930, 840.211090, 2537.910854, 931.224548);
	draw_text(darea, 2473.885700, 443.083890, "16AII");
	draw_box(cpssp, darea, 2447.512430, 473.471000, 2539.512354, 564.484458);
	draw_text(darea, 3032.394500, 447.145780, "16AIII");
	draw_box(cpssp, darea, 3011.235130, 476.673960, 3103.235054, 567.687418);
	draw_text(darea, 3019.246600, 1172.203200, "16AIV");
	draw_box(cpssp, darea, 3001.626230, 1192.537830, 3093.626154, 1283.551288);
	draw_text(darea, 2762.279500, 812.715030, "17AI");
	draw_box(cpssp, darea, 2804.945720, 869.121690, 2899.544414, 963.170388);
	draw_text(darea, 2907.544900, 1167.125900, "18AI");
	draw_box(cpssp, darea, 2806.210620, 1193.076520, 2895.076480, 1279.809598);
	draw_text(darea, 2395.747800, 1143.770000, "19A");
	draw_box(cpssp, darea, 2383.227460, 1163.194960, 2539.737820, 1258.443640);
	draw_text(darea, 1242.183500, 416.761750, "5A");
	draw_box(cpssp, darea, 1183.715120, 431.316250, 1340.225480, 526.564930);
	draw_text(darea, 1931.086700, 1169.145100, "22AVIII");
	draw_circle(cpssp, darea, 1934.470765, 1107.604320, 25.269140, FALSE);
	draw_text(darea, 1959.519800, 1288.970600, "22AVII");
	draw_circle(cpssp, darea, 1932.439765, 1349.286230, 25.269140, FALSE);
	draw_text(darea, 1937.179400, 1546.900000, "22AVI");
	draw_circle(cpssp, darea, 1935.486165, 1484.343770, 25.269140, FALSE);
	draw_text(darea, 1951.396100, 1664.694500, "22AV");
	draw_circle(cpssp, darea, 1934.470765, 1722.979268, 25.269140, FALSE);
	draw_text(darea, 1939.210400, 1919.577500, "22AIV");
	draw_circle(cpssp, darea, 1932.439765, 1858.036810, 25.269140, FALSE);
	draw_text(darea, 1947.334200, 2032.294800, "22AIII");
	draw_circle(cpssp, darea, 1934.470765, 2102.765130, 25.269140, FALSE);
	draw_text(darea, 1939.210300, 2304.440700, "22AII");
	draw_circle(cpssp, darea, 1936.501665, 2240.869070, 25.269140, FALSE);
	draw_text(darea, 1952.411500, 2421.219700, "22AI");
	draw_circle(cpssp, darea, 1936.501665, 2478.489100, 25.269140, FALSE);
	draw_text(darea, 1936.164100, 2679.149400, "21AVIII");
	draw_circle(cpssp, darea, 1936.501665, 2619.639460, 25.269140, FALSE);
	draw_text(darea, 1947.334100, 2795.928200, "21AVII");
	draw_circle(cpssp, darea, 1939.548065, 2853.197570, 25.269140, FALSE);
	draw_text(darea, 1945.303200, 3168.606000, "21AV");
	draw_circle(cpssp, darea, 1938.532665, 3229.937070, 25.269140, FALSE);
	draw_text(darea, 1944.287700, 3545.345200, "21AIII");
	draw_circle(cpssp, darea, 1941.579065, 3607.691970, 25.269140, FALSE);
	draw_text(darea, 1929.055700, 3804.290300, "21AII");
	draw_circle(cpssp, darea, 1940.563565, 3740.718570, 25.269140, FALSE);
	draw_text(darea, 1943.272200, 3930.208500, "21AI");
	draw_circle(cpssp, darea, 1941.579065, 3982.400470, 25.269140, FALSE);
	draw_text(darea, 1319.773600, 1162.036900, "31AIV");
	draw_circle(cpssp, darea, 1326.204085, 1097.449620, 25.269140, FALSE);
	draw_text(darea, 1307.587900, 1282.877700, "31AIII");
	draw_circle(cpssp, darea, 1321.126735, 1339.131530, 25.269140, FALSE);
	draw_text(darea, 1302.510500, 1541.822800, "31AII");
	draw_circle(cpssp, darea, 1326.204085, 1480.281890, 25.269140, FALSE);
	draw_text(darea, 1311.649800, 1660.632700, "31AI");
	draw_circle(cpssp, darea, 1328.235025, 1720.948328, 25.269140, FALSE);
	draw_text(darea, 1319.773600, 1919.577500, "30AVI");
	draw_circle(cpssp, darea, 1328.235025, 1857.021340, 25.269140, FALSE);
	draw_text(darea, 1311.649800, 2031.279300, "30AV");
	draw_circle(cpssp, darea, 1329.250505, 2099.718710, 25.269140, FALSE);
	draw_text(darea, 1322.819900, 2305.456300, "30AIV");
	draw_circle(cpssp, darea, 1327.219555, 2236.807190, 25.269140, FALSE);
	draw_text(darea, 1324.850800, 2420.204300, "30AIII");
	draw_circle(cpssp, darea, 1332.296915, 2478.489100, 25.269140, FALSE);
	draw_text(darea, 1313.680800, 2680.164800, "30AII");
	draw_circle(cpssp, darea, 1331.281445, 2617.608520, 25.269140, FALSE);
	draw_text(darea, 1318.758200, 2796.943800, "30AI");
	draw_circle(cpssp, darea, 1335.343325, 2856.243970, 25.269140, FALSE);
	draw_text(darea, 1320.789100, 3057.919700, "29AVI");
	draw_circle(cpssp, darea, 1333.312385, 2992.317070, 25.269140, FALSE);
	draw_text(darea, 1326.881800, 3171.652300, "29AV");
	draw_circle(cpssp, darea, 1334.327855, 3236.029870, 25.269140, FALSE);
	draw_text(darea, 1330.943700, 3433.643800, "29AIV");
	draw_circle(cpssp, darea, 1334.327855, 3372.102870, 25.269140, FALSE);
	draw_text(darea, 1329.928200, 3555.500000, "29AIII");
	draw_circle(cpssp, darea, 1334.327855, 3615.815770, 25.269140, FALSE);
	draw_text(darea, 1328.912800, 3811.398400, "29AII");
	draw_circle(cpssp, darea, 1340.420675, 3750.873270, 25.269140, FALSE);
	draw_text(darea, 1328.912700, 3939.347700, "29AI");
	draw_circle(cpssp, darea, 1339.405205, 3989.508770, 25.269140, FALSE);
	draw_text(darea, 2209.319600, 4342.944800, "12AI");
	draw_box(cpssp, darea, 2202.656550, 4396.769981, 2291.375632, 4487.879570);
	draw_text(darea, 2375.318400, 4321.357900, "17AII");
	draw_box(cpssp, darea, 2369.036436, 4345.638892, 2452.855840, 4433.809371);
	draw_text(darea, 2271.086700, 4585.154800, "12AII");
	draw_box(cpssp, darea, 2370.057836, 4604.025031, 2453.877240, 4691.215808);
	draw_text(darea, 1583.287400, 4356.394500, "15AII");
	draw_box(cpssp, darea, 1536.172000, 4369.847674, 1683.444736, 4460.615230);
	draw_text(darea, 1954.069500, 4330.324200, "15AI");
	draw_box(cpssp, darea, 1914.689585, 4362.662685, 2062.812720, 4448.378718);
	draw_text(darea, 1607.426900, 4582.339800, "18AII");
	draw_box(cpssp, darea, 1594.325280, 4597.550580, 1683.191140, 4684.283658);
	draw_text(darea, 1945.379300, 4572.684100, "14A");
	draw_box(cpssp, darea, 1931.256200, 4595.970766, 2051.347945, 4686.642088);
	draw_text(darea, 1965.656400, 4814.078600, "13A");
	draw_box(cpssp, darea, 1933.152243, 4841.050575, 2052.313863, 4928.060010);
	draw_text(darea, 871.965820, 408.355770, "3A");
	draw_box(cpssp, darea, 825.364930, 418.528050, 947.504800, 513.421910);
	draw_text(darea, 502.708800, 397.132140, "2A");
	draw_box(cpssp, darea, 448.020970, 410.929290, 572.951570, 504.712943);
	draw_text(darea, 504.392330, 586.811280, "4A");
	draw_box(cpssp, darea, 451.479130, 600.143070, 574.735300, 691.156528);
	draw_text(darea, 1618.321900, 1165.083300, "23AII");
	draw_circle(cpssp, darea, 1627.349665, 1102.310870, 25.269140, FALSE);
	draw_text(darea, 1641.677600, 1286.939600, "24AIII");
	draw_circle(cpssp, darea, 1631.169765, 1343.611940, 25.269140, FALSE);
	draw_text(darea, 1617.306300, 1543.853500, "24AII");
	draw_circle(cpssp, darea, 1632.443165, 1479.861100, 25.269140, FALSE);
	draw_text(darea, 1634.569300, 1661.648200, "24AI");
	draw_circle(cpssp, darea, 1629.896465, 1723.072204, 25.269140, FALSE);
	draw_text(darea, 1622.383700, 1919.577500, "25AIII");
	draw_circle(cpssp, darea, 1633.716465, 1859.958040, 25.269140, FALSE);
	draw_text(darea, 1626.445600, 2031.279300, "25AII");
	draw_circle(cpssp, darea, 1634.989865, 2101.895790, 25.269140, FALSE);
	draw_text(darea, 1630.507600, 2304.440900, "25AI");
	draw_circle(cpssp, darea, 1634.989865, 2236.234910, 25.269140, FALSE);
	draw_text(darea, 1649.801400, 2420.204300, "26AIII");
	draw_circle(cpssp, darea, 1634.353165, 2479.446010, 25.269140, FALSE);
	draw_text(darea, 1638.631100, 2680.164800, "26AII");
	draw_circle(cpssp, darea, 1636.263165, 2618.878560, 25.269140, FALSE);
	draw_text(darea, 1653.863300, 2795.928500, "26AI");
	draw_circle(cpssp, darea, 1635.626565, 2854.449570, 25.269140, FALSE);
	draw_text(darea, 1634.569300, 3057.919700, "27AIII");
	draw_circle(cpssp, darea, 1638.809965, 2990.061970, 25.269140, FALSE);
	draw_text(darea, 1642.693100, 3171.652300, "27AII");
	draw_circle(cpssp, darea, 1636.899865, 3232.636470, 25.269140, FALSE);
	draw_text(darea, 1623.399200, 3428.566400, "27AI");
	draw_circle(cpssp, darea, 1640.719965, 3366.338870, 25.269140, FALSE);
	draw_text(darea, 1636.600200, 3549.407200, "28AIII");
	draw_circle(cpssp, darea, 1640.083265, 3608.913270, 25.269140, FALSE);
	draw_text(darea, 1626.445600, 3807.336700, "28AII");
	draw_circle(cpssp, darea, 1640.083265, 3743.252370, 25.269140, FALSE);
	draw_text(darea, 1658.940600, 3931.223900, "28AI");
	draw_circle(cpssp, darea, 1642.629965, 3987.736870, 25.269140, FALSE);
	draw_text(darea, 1928.040200, 3054.873300, "21AVI");
	draw_circle(cpssp, darea, 1937.823065, 2991.985470, 25.269140, FALSE);
	draw_text(darea, 1933.117600, 3425.520000, "21AIV");
	draw_circle(cpssp, darea, 1938.056465, 3366.958770, 25.269140, FALSE);
	draw_text(darea, 1121.756800, 3947.471700, "S0");
	draw_box(cpssp, darea, 1123.543000, 3955.963100, 1188.742448, 4031.342952);
	draw_text(darea, 1120.741300, 3793.120100, "S1");
	draw_box(cpssp, darea, 1125.686890, 3712.897850, 1190.886338, 3788.277702);
	draw_text(darea, 1121.756800, 3577.840600, "S2");
	draw_box(cpssp, darea, 1118.242314, 3578.895490, 1183.441762, 3654.275342);
	draw_text(darea, 1124.803200, 3416.380600, "S3");
	draw_box(cpssp, darea, 1121.220144, 3336.202320, 1186.419592, 3411.582172);
	draw_text(darea, 1120.741500, 3190.946300, "S4");
	draw_box(cpssp, darea, 1122.709060, 3199.966590, 1187.908508, 3275.346442);
	draw_text(darea, 1128.865200, 3050.811500, "S5");
	draw_box(cpssp, darea, 1118.242314, 2954.295600, 1183.441762, 3029.675452);
	draw_text(darea, 1121.756800, 2809.129400, "S6");
	draw_box(cpssp, darea, 1121.964602, 2818.804300, 1187.164050, 2894.184152);
	draw_text(darea, 1124.803300, 2688.288600, "S7");
	draw_box(cpssp, darea, 1119.731229, 2582.066800, 1184.930677, 2657.446652);
	draw_text(darea, 1119.726000, 2433.405500, "S8");
	draw_box(cpssp, darea, 1117.497857, 2442.108800, 1182.697305, 2517.488652);
	draw_text(darea, 1121.756800, 2293.270800, "S9");
	draw_box(cpssp, darea, 1118.242314, 2200.904500, 1183.441762, 2276.284352);
	draw_text(darea, 1115.664100, 2050.573200, "S10");
	draw_box(cpssp, darea, 1118.242314, 2061.691000, 1183.441762, 2137.070852);
	draw_text(darea, 1108.555700, 1901.299100, "S11");
	draw_box(cpssp, darea, 1116.008941, 1818.997800, 1181.208390, 1894.377652);
	draw_text(darea, 1111.602200, 1672.818200, "S12");
	draw_box(cpssp, darea, 1113.775569, 1680.528700, 1178.975017, 1755.908552);
	draw_text(darea, 1112.617600, 1532.683300, "S13");
	draw_box(cpssp, darea, 1113.031111, 1437.835500, 1178.230559, 1513.215352);
	draw_text(darea, 1104.493900, 1289.986100, "S14");
	draw_box(cpssp, darea, 1113.775569, 1300.855300, 1178.975017, 1376.235152);
	draw_text(darea, 1111.602200, 1135.634500, "S15");
	draw_box(cpssp, darea, 1109.308823, 1056.673200, 1174.508271, 1132.053052);
	draw_text(darea, 2854.186300, 4465.639200, "15BI");
	draw_box(cpssp, darea, 2828.806870, 4485.898780, 2917.672730, 4572.631858);
	draw_text(darea, 1306.439600, 4312.041500, "16AVI");
	draw_box(cpssp, darea, 1293.514860, 4339.711500, 1385.514784, 4430.724958);
	draw_text(darea, 2258.652600, 4944.889200, "6AV");
	draw_box(cpssp, darea, 2232.764730, 4956.006000, 2324.764654, 5047.019458);
	draw_text(darea, 2632.681400, 4879.835000, "16AV");
	draw_box(cpssp, darea, 2520.507030, 4827.584200, 2612.506954, 4918.597658);
	draw_text(darea, 2636.541700, 4320.070800, "17B");
	draw_box(cpssp, darea, 2608.605200, 4338.117700, 2717.896020, 4423.581590);
	draw_text(darea, 2577.209000, 4636.627000, "6AVI");
	draw_box(cpssp, darea, 2558.929000, 4519.442900, 2641.675468, 4604.906790);
/* draw ports */
	draw_text(darea, 289.558290, 427.769100, "Uhr1");
	draw_line(cpssp, darea, 354.105160, 436.645650, 354.105160, 436.645650, 1);
	draw_text(darea, 289.666750, 483.044770, "Uhr2");
	draw_line(cpssp, darea, 354.105160, 468.632970, 354.105160, 468.632970, 1);
	draw_text(darea, 292.288880, 621.912110, "Imp1");
	draw_line(cpssp, darea, 360.839330, 618.468270, 360.839330, 618.468270, 1);
	draw_text(darea, 290.397340, 677.187740, "Imp2");
	draw_line(cpssp, darea, 362.522870, 661.679200, 362.522870, 661.679200, 1);
	draw_text(darea, 778.550780, 3982.117400, "22II4");
	draw_line(cpssp, darea, 874.144440, 3971.765800, 874.144440, 3971.765800, 1);
	draw_text(darea, 780.152220, 4030.162100, "22II6");
	draw_line(cpssp, darea, 876.228210, 4020.734500, 876.228210, 4020.734500, 1);
	draw_text(darea, 778.550780, 4076.605200, "22II8");
	draw_line(cpssp, darea, 875.186320, 4067.619500, 875.186320, 4067.619500, 1);
	draw_text(darea, 778.550780, 3935.674600, "22II0");
	draw_line(cpssp, darea, 874.144440, 3929.048300, 874.144440, 3929.048300, 1);
	draw_text(darea, 780.152280, 4118.243700, "22III0");
	draw_line(cpssp, darea, 874.144440, 4107.211300, 874.144440, 4107.211300, 1);
	draw_text(darea, 956.139160, 638.946230, "30I3");
	draw_line(cpssp, darea, 914.108710, 639.316250, 914.108710, 639.316250, 1);
	draw_text(darea, 1663.279700, 614.585390, "30I4");
	draw_line(cpssp, darea, 1649.769100, 608.555830, 1649.769100, 608.555830, 1);
	draw_text(darea, 1668.693200, 465.713680, "30I5");
	draw_line(cpssp, darea, 1648.415700, 462.390890, 1648.415700, 462.390890, 1);
	draw_text(darea, 1467.039800, 331.052490, "30I6");
	draw_line(cpssp, darea, 1444.970600, 324.113770, 1444.970600, 324.113770, 1);
	draw_text(darea, 695.273560, 3476.048100, "30I7");
	draw_line(cpssp, darea, 733.489490, 3499.790300, 733.489490, 3499.790300, 1);
	draw_text(darea, 685.664610, 1956.238800, "30I8");
	draw_line(cpssp, darea, 729.321940, 1976.549300, 729.321940, 1976.549300, 1);
	draw_text(darea, 685.664670, 2715.342800, "30I8");
	draw_line(cpssp, darea, 734.531380, 2741.295500, 734.531380, 2741.295500, 1);
	draw_text(darea, 679.258730, 1189.127300, "30I0");
	draw_line(cpssp, darea, 717.861160, 1207.635600, 717.861160, 1207.635600, 1);
	draw_text(darea, 767.340390, 3612.174300, "30II1");
	draw_line(cpssp, darea, 872.060660, 3602.937200, 872.060660, 3602.937200, 1);
	draw_text(darea, 1107.571900, 4397.607900, "30II1");
	draw_line(cpssp, darea, 1205.041600, 4398.026400, 1205.041600, 4398.026400, 1);
	draw_text(darea, 3178.334000, 942.906190, "30II2");
	draw_line(cpssp, darea, 3136.084300, 921.116290, 3136.084300, 921.116290, 1);
	draw_text(darea, 765.738890, 3653.813000, "30II2");
	draw_line(cpssp, darea, 872.060660, 3646.696600, 872.060660, 3646.696600, 1);
	draw_text(darea, 767.340390, 3709.865200, "30II3");
	draw_line(cpssp, darea, 875.186320, 3696.707200, 875.186320, 3696.707200, 1);
	draw_text(darea, 768.941830, 3753.105000, "30II4");
	draw_line(cpssp, darea, 875.186320, 3744.634100, 875.186320, 3744.634100, 1);
	draw_text(darea, 1815.534900, 555.713380, "30II4");
	draw_line(cpssp, darea, 1838.869100, 567.654730, 1838.869100, 567.654730, 1);
	draw_text(darea, 770.543400, 3794.743700, "30II5");
	draw_line(cpssp, darea, 872.060660, 3784.225800, 872.060660, 3784.225800, 1);
	draw_text(darea, 2156.750700, 894.968140, "30II5");
	draw_line(cpssp, darea, 2247.015600, 882.973630, 2247.015600, 882.973630, 1);
	draw_text(darea, 775.347840, 3841.186800, "30II6");
	draw_line(cpssp, darea, 875.186320, 3831.110800, 875.186320, 3831.110800, 1);
	draw_text(darea, 712.889890, 3082.082800, "30II7");
	draw_line(cpssp, darea, 733.489490, 3122.626700, 733.489490, 3122.626700, 1);
	draw_text(darea, 687.266110, 1565.476400, "30II8");
	draw_line(cpssp, darea, 724.112490, 1598.343800, 724.112490, 1598.343800, 1);
	draw_text(darea, 698.476500, 2330.986300, "30II8");
	draw_line(cpssp, darea, 731.405710, 2361.006200, 731.405710, 2361.006200, 1);
	draw_text(darea, 3064.816700, 4505.700200, "30II0");
	draw_line(cpssp, darea, 3034.812400, 4500.377700, 3034.812400, 4500.377700, 1);
	draw_text(darea, 2241.686800, 1785.705400, "30III6");
	draw_line(cpssp, darea, 2271.606900, 1732.118500, 2271.606900, 1732.118500, 1);
	draw_text(darea, 2543.657000, 4739.900400, "30III7");
	draw_line(cpssp, darea, 2565.541400, 4765.911700, 2565.541400, 4765.911700, 1);
	draw_text(darea, 3195.426500, 1248.351800, "30III8");
	draw_line(cpssp, darea, 3171.508500, 1237.850400, 3171.508500, 1237.850400, 1);
/* draw signals */
	draw_text(darea, 3409.861300, 539.764530, "SW ohne W1");
	draw_text(darea, 3166.148200, 908.380190, "Zum Stop");
	draw_text(darea, 815.462590, 3884.455600, "0V");
	draw_text(darea, 2227.833700, 521.275150, "Ps42");
	draw_text(darea, 2124.255900, 490.811000, "SW ohne W1");
	draw_text(darea, 2155.735400, 838.101810, "Ps45,5");
	draw_text(darea, 1818.918200, 497.518100, "Ps42");
	draw_text(darea, 1071.541000, 4364.150900, "_Lese-Imp_");
	draw_line(cpssp, darea, 3106.038500, 521.977690, 3312.321875, 524.924597, 1);
	draw_line(cpssp, darea, 3312.321875, 524.924597, 3397.171900, 523.272380, 1);
	draw_line(cpssp, darea, 3312.321875, 524.924597, 3305.912200, 1342.039200, 1);
	draw_line(cpssp, darea, 3305.912200, 1342.039200, 2849.565000, 1339.955500, 1);
	draw_line(cpssp, darea, 2849.565000, 1339.955500, 2850.606900, 1283.693500, 1);
	draw_line(cpssp, darea, 2898.533800, 916.948740, 3136.084300, 921.116290, 1);
	draw_line(cpssp, darea, 878.311990, 3875.912000, 937.115975, 3877.029737, 1);
	draw_line(cpssp, darea, 937.115975, 3877.029737, 1034.363855, 3877.029737, 1);
	draw_line(cpssp, darea, 1123.155800, 3756.094800, 1035.637200, 3755.053000, 1);
	draw_line(cpssp, darea, 1035.637200, 3755.053000, 1034.363855, 3877.029737, 1);
	draw_line(cpssp, darea, 1034.363855, 3877.029737, 1037.720900, 3998.854900, 1);
	draw_line(cpssp, darea, 1037.720900, 3998.854900, 1126.281400, 3996.771100, 1);
	draw_line(cpssp, darea, 872.060660, 3602.937200, 938.741520, 3603.979100, 1);
	draw_line(cpssp, darea, 938.741520, 3603.979100, 935.642515, 3641.277337, 1);
	draw_line(cpssp, darea, 935.642515, 3641.277337, 938.589425, 3695.795037, 1);
	draw_line(cpssp, darea, 938.589425, 3695.795037, 935.642515, 3744.419037, 1);
	draw_line(cpssp, darea, 935.642515, 3744.419037, 937.115975, 3785.675737, 1);
	draw_line(cpssp, darea, 937.115975, 3785.675737, 938.589425, 3828.405837, 1);
	draw_line(cpssp, darea, 938.589425, 3828.405837, 937.115975, 3877.029737, 1);
	draw_line(cpssp, darea, 937.115975, 3877.029737, 938.589425, 3928.600637, 1);
	draw_line(cpssp, darea, 938.589425, 3928.600637, 937.115975, 3971.330737, 1);
	draw_line(cpssp, darea, 937.115975, 3971.330737, 938.589425, 4018.481237, 1);
	draw_line(cpssp, darea, 938.589425, 4018.481237, 938.589425, 4065.631737, 1);
	draw_line(cpssp, darea, 938.589425, 4065.631737, 940.825300, 4109.295000, 1);
	draw_line(cpssp, darea, 940.825300, 4109.295000, 874.144440, 4107.211300, 1);
	draw_line(cpssp, darea, 872.060660, 3646.696600, 935.642515, 3641.277337, 1);
	draw_line(cpssp, darea, 875.186320, 3696.707200, 938.589425, 3695.795037, 1);
	draw_line(cpssp, darea, 875.186320, 3744.634100, 935.642515, 3744.419037, 1);
	draw_line(cpssp, darea, 872.060660, 3784.225800, 937.115975, 3785.675737, 1);
	draw_line(cpssp, darea, 875.186320, 3831.110800, 938.589425, 3828.405837, 1);
	draw_line(cpssp, darea, 874.144440, 3929.048300, 938.589425, 3928.600637, 1);
	draw_line(cpssp, darea, 874.144440, 3971.765800, 937.115975, 3971.330737, 1);
	draw_line(cpssp, darea, 876.228210, 4020.734500, 938.589425, 4018.481237, 1);
	draw_line(cpssp, darea, 875.186320, 4067.619500, 938.589425, 4065.631737, 1);
	draw_line(cpssp, darea, 2337.997800, 518.947340, 2446.354200, 518.947340, 1);
	draw_line(cpssp, darea, 2448.878600, 885.920540, 2247.015600, 882.973630, 1);
	draw_line(cpssp, darea, 1838.869100, 567.654730, 1844.762900, 692.898220, 1);
	draw_line(cpssp, darea, 1205.041600, 4398.026400, 1292.909300, 4396.095200, 1);
	draw_text(darea, 3155.823000, 1212.810300, "Blocksperre v _SW_");
	draw_line(cpssp, darea, 3093.366900, 1238.892300, 3171.508500, 1237.850400, 1);
	draw_line(cpssp, darea, 717.861160, 1207.635600, 1019.629325, 1213.027067, 1);
	draw_line(cpssp, darea, 1105.443700, 1096.153600, 1017.925000, 1094.069800, 1);
	draw_line(cpssp, darea, 1017.925000, 1094.069800, 1019.629325, 1213.027067, 1);
	draw_line(cpssp, darea, 1019.629325, 1213.027067, 1023.134500, 1339.955500, 1);
	draw_line(cpssp, darea, 1023.134500, 1339.955500, 1110.653100, 1339.955500, 1);
	draw_line(cpssp, darea, 1176.292100, 1342.039200, 1294.025500, 1340.997300, 1);
	draw_line(cpssp, darea, 1171.082700, 1097.195400, 1294.025500, 1097.195400, 1);
	draw_line(cpssp, darea, 1355.496900, 1097.195400, 1596.173200, 1103.446800, 1);
	draw_text(darea, 1489.284100, 1019.871000, "15'");
	draw_line(cpssp, darea, 1538.869300, 1027.388900, 1606.592000, 1081.567100, 1);
	draw_text(darea, 1493.345900, 1269.676600, "14'");
	draw_line(cpssp, darea, 1538.869300, 1268.065200, 1608.675800, 1328.494700, 1);
	draw_line(cpssp, darea, 1602.424500, 1344.123000, 1353.413100, 1344.123000, 1);
	draw_line(cpssp, darea, 1110.653100, 1477.484700, 1023.134500, 1477.484700, 1);
	draw_line(cpssp, darea, 1023.134500, 1477.484700, 1021.102785, 1600.545157, 1);
	draw_line(cpssp, darea, 1021.102785, 1600.545157, 1026.260200, 1720.244800, 1);
	draw_line(cpssp, darea, 1026.260200, 1720.244800, 1112.736900, 1719.202900, 1);
	draw_line(cpssp, darea, 1021.102785, 1600.545157, 724.112490, 1598.343800, 1);
	draw_line(cpssp, darea, 731.405710, 2361.006200, 1028.470045, 2356.426437, 1);
	draw_line(cpssp, darea, 1118.988200, 2241.189000, 1029.385800, 2238.063300, 1);
	draw_line(cpssp, darea, 1029.385800, 2238.063300, 1028.470045, 2356.426437, 1);
	draw_line(cpssp, darea, 1028.470045, 2356.426437, 1028.343900, 2480.823300, 1);
	draw_line(cpssp, darea, 1028.343900, 2480.823300, 1117.946300, 2484.990900, 1);
	draw_line(cpssp, darea, 1175.250200, 1719.202900, 1299.234900, 1721.286600, 1);
	draw_line(cpssp, darea, 1174.208300, 1477.484700, 1292.983600, 1481.652300, 1);
	draw_line(cpssp, darea, 1601.382600, 1479.568500, 1355.496900, 1476.442800, 1);
	draw_text(darea, 1496.392300, 1419.966200, "13'");
	draw_line(cpssp, darea, 1544.078700, 1405.594400, 1611.801500, 1459.772600, 1);
	draw_text(darea, 1497.407800, 1660.632600, "12'");
	draw_line(cpssp, darea, 1543.036800, 1649.396300, 1609.717700, 1703.574500, 1);
	draw_line(cpssp, darea, 1355.496900, 1722.328500, 1599.298800, 1722.328500, 1);
	draw_line(cpssp, darea, 729.321940, 1976.549300, 1028.470045, 1976.275637, 1);
	draw_line(cpssp, darea, 1114.820700, 1858.815900, 1027.302000, 1858.815900, 1);
	draw_line(cpssp, darea, 1027.302000, 1858.815900, 1028.470045, 1976.275637, 1);
	draw_line(cpssp, darea, 1028.470045, 1976.275637, 1027.302000, 2098.450300, 1);
	draw_line(cpssp, darea, 1027.302000, 2098.450300, 1114.820700, 2100.534100, 1);
	draw_line(cpssp, darea, 1118.988200, 2621.478300, 1031.469600, 2620.436400, 1);
	draw_line(cpssp, darea, 1031.469600, 2620.436400, 1028.470045, 2736.577237, 1);
	draw_line(cpssp, darea, 1028.470045, 2736.577237, 1033.553400, 2861.112600, 1);
	draw_line(cpssp, darea, 1033.553400, 2861.112600, 1118.988200, 2862.154500, 1);
	draw_line(cpssp, darea, 1028.470045, 2736.577237, 734.531380, 2741.295500, 1);
	draw_line(cpssp, darea, 1181.501500, 2100.534100, 1302.360600, 2097.408400, 1);
	draw_line(cpssp, darea, 1177.334000, 1856.732100, 1296.109300, 1858.815900, 1);
	draw_line(cpssp, darea, 1357.580700, 1859.857800, 1602.424500, 1859.857800, 1);
	draw_text(darea, 1497.407800, 1793.659300, "11'");
	draw_line(cpssp, darea, 1610.759600, 1844.229500, 1540.953100, 1784.841800, 1);
	draw_text(darea, 1499.438700, 2027.217400, "10'");
	draw_line(cpssp, darea, 1612.843400, 2081.780100, 1546.162500, 2027.601900, 1);
	draw_line(cpssp, darea, 1604.508300, 2101.575900, 1357.580700, 2099.492200, 1);
	draw_line(cpssp, darea, 1176.292100, 2479.781500, 1299.234900, 2480.823300, 1);
	draw_line(cpssp, darea, 1180.459600, 2238.063300, 1301.318700, 2239.105200, 1);
	draw_line(cpssp, darea, 1358.622600, 2240.147100, 1607.633900, 2241.189000, 1);
	draw_text(darea, 1507.562500, 2172.429700, "9'");
	draw_line(cpssp, darea, 1614.927100, 2221.393100, 1541.995000, 2162.005500, 1);
	draw_text(darea, 1511.624400, 2415.127200, "8'");
	draw_line(cpssp, darea, 1543.036800, 2403.723600, 1611.801500, 2463.111200, 1);
	draw_line(cpssp, darea, 1604.508300, 2481.865200, 1361.748200, 2479.781500, 1);
	draw_text(darea, 1511.624400, 2557.292700, "7'");
	draw_line(cpssp, darea, 1545.120600, 2547.504200, 1615.969000, 2600.640500, 1);
	draw_line(cpssp, darea, 1360.706400, 2618.352600, 1608.675800, 2617.310700, 1);
	draw_line(cpssp, darea, 1300.276800, 2619.394500, 1188.794800, 2619.394500, 1);
	draw_line(cpssp, darea, 1186.711000, 2857.987000, 1300.276800, 2857.987000, 1);
	draw_line(cpssp, darea, 1363.832000, 2859.028900, 1608.675800, 2856.945100, 1);
	draw_text(darea, 1510.609000, 2786.789300, "6'");
	draw_line(cpssp, darea, 1613.885300, 2836.107300, 1549.288200, 2784.012900, 1);
	draw_line(cpssp, darea, 733.489490, 3122.626700, 1031.416955, 3118.201537, 1);
	draw_line(cpssp, darea, 1120.030100, 2997.600000, 1030.427700, 2996.558100, 1);
	draw_line(cpssp, darea, 1030.427700, 2996.558100, 1031.416955, 3118.201537, 1);
	draw_line(cpssp, darea, 1031.416955, 3118.201537, 1031.469600, 3243.485700, 1);
	draw_line(cpssp, darea, 1031.469600, 3243.485700, 1124.197700, 3240.360000, 1);
	draw_line(cpssp, darea, 1186.711000, 3241.401900, 1307.570000, 3239.318200, 1);
	draw_line(cpssp, darea, 1180.459600, 2992.390600, 1302.360600, 2996.558100, 1);
	draw_line(cpssp, darea, 1362.790100, 2994.474400, 1608.675800, 2993.432500, 1);
	draw_text(darea, 1507.562600, 2929.970500, "5'");
	draw_line(cpssp, darea, 1613.885300, 2973.636600, 1545.120600, 2917.374600, 1);
	draw_text(darea, 1505.531600, 3167.590300, "4'");
	draw_line(cpssp, darea, 1547.204400, 3158.050900, 1617.300100, 3218.132900, 1);
	draw_line(cpssp, darea, 1363.832000, 3237.234400, 1611.280300, 3236.829200, 1);
	draw_line(cpssp, darea, 733.489490, 3499.790300, 1031.416955, 3496.878937, 1);
	draw_line(cpssp, darea, 1122.113900, 3377.889300, 1035.637200, 3378.931200, 1);
	draw_line(cpssp, darea, 1035.637200, 3378.931200, 1031.416955, 3496.878937, 1);
	draw_line(cpssp, darea, 1031.416955, 3496.878937, 1033.553400, 3620.649300, 1);
	draw_line(cpssp, darea, 1033.553400, 3620.649300, 1116.904500, 3617.523700, 1);
	draw_line(cpssp, darea, 1181.501500, 3618.565600, 1305.486300, 3619.607500, 1);
	draw_line(cpssp, darea, 1186.711000, 3372.679900, 1303.402500, 3373.721800, 1);
	draw_line(cpssp, darea, 1364.873900, 3374.763700, 1612.843400, 3371.638000, 1);
	draw_text(darea, 1510.608900, 3300.616900, "3'");
	draw_line(cpssp, darea, 1548.246300, 3295.580100, 1618.110500, 3352.536600, 1);
	draw_text(darea, 1510.609000, 3544.330100, "2'");
	draw_line(cpssp, darea, 1549.288200, 3538.340200, 1618.110500, 3596.338500, 1);
	draw_text(darea, 1510.609000, 3683.449200, "1'");
	draw_line(cpssp, darea, 1550.330100, 3676.911300, 1617.300100, 3734.041400, 1);
	draw_line(cpssp, darea, 1364.179500, 3615.439900, 1612.495900, 3614.687200, 1);
	draw_line(cpssp, darea, 1183.585300, 3995.729200, 1306.528200, 3993.645400, 1);
	draw_line(cpssp, darea, 1367.999600, 3992.603500, 1613.190300, 3990.519800, 1);
	draw_text(darea, 1513.655300, 3915.992200, "0'");
	draw_line(cpssp, darea, 1551.371900, 3914.461900, 1618.515700, 3972.460200, 1);
	draw_line(cpssp, darea, 1189.836600, 3752.969200, 1303.402500, 3752.969200, 1);
	draw_line(cpssp, darea, 1369.041500, 3750.885400, 1613.421800, 3746.717900, 1);
	draw_line(cpssp, darea, 1670.089500, 3989.709400, 1911.865400, 3982.184600, 1);
	draw_line(cpssp, darea, 1666.963800, 3749.033100, 1905.614000, 3743.592200, 1);
	draw_line(cpssp, darea, 1971.253000, 3744.634100, 2086.409175, 3739.998637, 1);
	draw_line(cpssp, darea, 2084.935715, 3605.914437, 1968.127300, 3607.104800, 1);
	draw_line(cpssp, darea, 2086.409175, 3362.794737, 1966.043600, 3366.428600, 1);
	draw_line(cpssp, darea, 1967.085500, 3232.024900, 2084.935715, 3228.710537, 1);
	draw_line(cpssp, darea, 1965.001700, 2991.348700, 2083.462265, 2985.590837, 1);
	draw_line(cpssp, darea, 1969.169200, 2855.903200, 2084.935715, 2854.453537, 1);
	draw_line(cpssp, darea, 1965.001700, 2619.394500, 2083.462265, 2612.807237, 1);
	draw_line(cpssp, darea, 1965.001700, 2478.739600, 2083.462265, 2478.723037, 1);
	draw_line(cpssp, darea, 2084.935715, 2241.497137, 1963.959800, 2237.021400, 1);
	draw_line(cpssp, darea, 1966.043600, 2102.617800, 2083.462265, 2102.992537, 1);
	draw_line(cpssp, darea, 1962.639200, 1861.346300, 2083.462265, 1859.872847, 1);
	draw_line(cpssp, darea, 2084.935715, 1722.841737, 1960.429000, 1722.841700, 1);
	draw_line(cpssp, darea, 1964.849300, 1483.405700, 2083.462265, 1481.195477, 1);
	draw_line(cpssp, darea, 1963.375900, 1347.848000, 2081.988815, 1350.058177, 1);
	draw_line(cpssp, darea, 2086.409175, 1109.885367, 2081.988815, 1350.058177, 1);
	draw_line(cpssp, darea, 2081.988815, 1350.058177, 2083.462265, 1481.195477, 1);
	draw_line(cpssp, darea, 2083.462265, 1481.195477, 2084.935715, 1722.841737, 1);
	draw_line(cpssp, darea, 2084.935715, 1722.841737, 2083.462265, 1859.872847, 1);
	draw_line(cpssp, darea, 2083.462265, 1859.872847, 2083.462265, 2102.992537, 1);
	draw_line(cpssp, darea, 2083.462265, 2102.992537, 2084.935715, 2241.497137, 1);
	draw_line(cpssp, darea, 2084.935715, 2241.497137, 2083.462265, 2478.723037, 1);
	draw_line(cpssp, darea, 2083.462265, 2478.723037, 2083.462265, 2612.807237, 1);
	draw_line(cpssp, darea, 2083.462265, 2612.807237, 2084.935715, 2854.453537, 1);
	draw_line(cpssp, darea, 2084.935715, 2854.453537, 2083.462265, 2985.590837, 1);
	draw_line(cpssp, darea, 2083.462265, 2985.590837, 2084.935715, 3228.710537, 1);
	draw_line(cpssp, darea, 2084.935715, 3228.710537, 2086.409175, 3362.794737, 1);
	draw_line(cpssp, darea, 2086.409175, 3362.794737, 2084.935715, 3605.914437, 1);
	draw_line(cpssp, darea, 2084.935715, 3605.914437, 2086.409175, 3739.998637, 1);
	draw_line(cpssp, darea, 2086.409175, 3739.998637, 2090.074900, 3981.644500, 1);
	draw_line(cpssp, darea, 2090.074900, 3981.644500, 1973.690100, 3982.381700, 1);
	draw_line(cpssp, darea, 1962.639200, 1106.938500, 2086.409175, 1109.885367, 1);
	draw_line(cpssp, darea, 2086.409175, 1109.885367, 2490.135300, 1109.885400, 1);
	draw_line(cpssp, darea, 2490.135300, 1109.885400, 2490.135300, 1162.929700, 1);
	draw_line(cpssp, darea, 1910.823500, 3606.062900, 1668.063500, 3611.272300, 1);
	draw_line(cpssp, darea, 1908.739700, 3368.512300, 1668.063500, 3366.428600, 1);
	draw_line(cpssp, darea, 1907.697800, 3234.108700, 1664.243400, 3234.745400, 1);
	draw_line(cpssp, darea, 1665.979700, 2994.474400, 1905.614000, 2991.348700, 1);
	draw_line(cpssp, darea, 1664.937800, 2857.987000, 1907.697800, 2854.861300, 1);
	draw_line(cpssp, darea, 1665.979700, 2617.310700, 1903.530300, 2618.352600, 1);
	draw_line(cpssp, darea, 1662.854000, 2480.823300, 1901.446500, 2477.697700, 1);
	draw_line(cpssp, darea, 1904.572100, 2240.147100, 1663.895900, 2239.105200, 1);
	draw_line(cpssp, darea, 1904.572100, 2099.492200, 1667.021600, 2101.575900, 1);
	draw_line(cpssp, darea, 1662.854000, 1859.857800, 1904.437800, 1859.872800, 1);
	draw_line(cpssp, darea, 1901.490900, 1723.578500, 1662.054800, 1724.315200, 1);
	draw_line(cpssp, darea, 1659.844600, 1483.405700, 1905.174500, 1483.405700, 1);
	draw_line(cpssp, darea, 1662.791500, 1344.164400, 1902.227600, 1347.111300, 1);
	draw_line(cpssp, darea, 1656.161000, 1100.307900, 1903.701000, 1106.938500, 1);
	draw_line(cpssp, darea, 354.105160, 436.645650, 445.016460, 438.329200, 1);
	draw_line(cpssp, darea, 354.105160, 468.632970, 445.577650, 472.000050, 1);
	draw_line(cpssp, darea, 360.839330, 618.468270, 447.261190, 620.712990, 1);
	draw_line(cpssp, darea, 362.522870, 661.679200, 447.822370, 663.923920, 1);
	draw_text(darea, 2777.203100, 409.573360, "_SW ohne W1_");
	draw_text(darea, 3060.956300, 4564.894000, "_SW ohne W1_");
	draw_line(cpssp, darea, 2540.232700, 517.557330, 2854.078075, 519.030787, 1);
	draw_line(cpssp, darea, 2854.078075, 519.030787, 3008.790700, 523.451140, 1);
	draw_line(cpssp, darea, 2855.551600, 436.517430, 2854.078075, 519.030787, 1);
	draw_line(cpssp, darea, 2854.078075, 519.030787, 2855.551600, 869.712550, 1);
	draw_line(cpssp, darea, 2919.908600, 4562.174700, 3034.812400, 4557.346800, 1);
	draw_line(cpssp, darea, 2537.285800, 884.447080, 2806.927600, 885.920540, 1);
	draw_line(cpssp, darea, 2538.759200, 1173.243800, 2849.657800, 1174.717300, 1);
	draw_line(cpssp, darea, 2849.657800, 1174.717300, 2852.604700, 964.013540, 1);
	draw_line(cpssp, darea, 2898.281700, 1238.075800, 2999.949900, 1241.022700, 1);
	draw_line(cpssp, darea, 2808.401100, 1236.602300, 2538.759200, 1235.128900, 1);
	draw_line(cpssp, darea, 2382.573200, 1238.075800, 2270.590800, 1238.075800, 1);
	draw_line(cpssp, darea, 2270.590800, 1238.075800, 2272.064200, 1403.102500, 1);
	draw_line(cpssp, darea, 1841.816000, 818.141710, 1840.342555, 1027.372007, 1);
	draw_line(cpssp, darea, 1840.342555, 1027.372007, 1843.289455, 1273.438627, 1);
	draw_line(cpssp, darea, 1843.289455, 1273.438627, 1843.289455, 1410.469737, 1);
	draw_line(cpssp, darea, 1843.289455, 1410.469737, 1841.816005, 1650.642547, 1);
	draw_line(cpssp, darea, 1841.816005, 1650.642547, 1846.236365, 1789.147117, 1);
	draw_line(cpssp, darea, 1846.236365, 1789.147117, 1843.289455, 2029.319937, 1);
	draw_line(cpssp, darea, 1843.289455, 2029.319937, 1843.289455, 2169.297937, 1);
	draw_line(cpssp, darea, 1843.289455, 2169.297937, 1847.709815, 2406.523837, 1);
	draw_line(cpssp, darea, 1847.709815, 2406.523837, 1847.709815, 2552.395637, 1);
	draw_line(cpssp, darea, 1847.709815, 2552.395637, 1844.762905, 2780.780837, 1);
	draw_line(cpssp, darea, 1844.762905, 2780.780837, 1847.709815, 2923.705837, 1);
	draw_line(cpssp, darea, 1847.709815, 2923.705837, 1847.709815, 3159.458237, 1);
	draw_line(cpssp, darea, 1847.709815, 3159.458237, 1849.183265, 3296.489337, 1);
	draw_line(cpssp, darea, 1849.183265, 3296.489337, 1847.709815, 3532.241837, 1);
	draw_line(cpssp, darea, 1847.709815, 3532.241837, 1850.656725, 3678.113637, 1);
	draw_line(cpssp, darea, 1850.656725, 3678.113637, 1852.130200, 3909.445700, 1);
	draw_line(cpssp, darea, 1852.130200, 3909.445700, 1922.855900, 3965.436900, 1);
	draw_line(cpssp, darea, 1850.656725, 3678.113637, 1919.909000, 3725.264100, 1);
	draw_line(cpssp, darea, 1847.709815, 3532.241837, 1918.435600, 3591.179900, 1);
	draw_line(cpssp, darea, 1849.183265, 3296.489337, 1918.435600, 3348.060200, 1);
	draw_line(cpssp, darea, 1847.709815, 3159.458237, 1916.962100, 3212.502500, 1);
	draw_line(cpssp, darea, 1912.541800, 2975.276600, 1847.709815, 2923.705837, 1);
	draw_line(cpssp, darea, 1844.762905, 2780.780837, 1918.435600, 2838.245500, 1);
	draw_line(cpssp, darea, 1847.709815, 2552.395637, 1916.962100, 2603.966500, 1);
	draw_line(cpssp, darea, 1847.709815, 2406.523837, 1916.962100, 2463.988500, 1);
	draw_line(cpssp, darea, 1843.289455, 2169.297937, 1912.541800, 2222.342200, 1);
	draw_line(cpssp, darea, 1843.289455, 2029.319937, 1915.488700, 2083.837700, 1);
	draw_line(cpssp, darea, 1846.236365, 1789.147117, 1911.068300, 1843.664900, 1);
	draw_line(cpssp, darea, 1841.816005, 1650.642547, 1912.541800, 1708.107200, 1);
	draw_line(cpssp, darea, 1843.289455, 1410.469737, 1914.015200, 1469.407900, 1);
	draw_line(cpssp, darea, 1843.289455, 1273.438627, 1909.594900, 1332.376700, 1);
	draw_line(cpssp, darea, 1840.342555, 1027.372007, 1912.541800, 1086.310100, 1);
	draw_line(cpssp, darea, 2272.622300, 1490.436600, 2272.622300, 1549.333900, 1);
	draw_text(darea, 2255.903300, 1819.215900, "Ps40");
	draw_line(cpssp, darea, 2273.637800, 1643.772600, 2271.606900, 1732.118500, 1);
	draw_line(cpssp, darea, 1386.570400, 4393.198500, 1535.269400, 4391.267300, 1);
	draw_line(cpssp, darea, 1683.968500, 4372.921400, 1748.662200, 4374.852500, 1);
	draw_line(cpssp, darea, 1748.662200, 4374.852500, 1749.424255, 4425.375737, 1);
	draw_line(cpssp, darea, 1749.424255, 4425.375737, 1755.214915, 5070.713137, 1);
	draw_line(cpssp, darea, 1749.424255, 4425.375737, 1685.899600, 4424.097000, 1);
	draw_line(cpssp, darea, 2327.043600, 5000.547200, 2565.908075, 4996.077937, 1);
	draw_line(cpssp, darea, 2566.507000, 4918.473100, 2565.908075, 4996.077937, 1);
	draw_line(cpssp, darea, 2565.908075, 4996.077937, 2569.403700, 5054.619600, 1);
	draw_line(cpssp, darea, 2569.403700, 5054.619600, 1755.214915, 5070.713137, 1);
	draw_line(cpssp, darea, 1755.214915, 5070.713137, 1641.483000, 5072.965600, 1);
	draw_line(cpssp, darea, 1641.483000, 5072.965600, 1636.655100, 4685.768700, 1);
	draw_line(cpssp, darea, 1683.002900, 4619.143800, 1932.122100, 4617.212600, 1);
	draw_line(cpssp, darea, 1684.934000, 4447.270900, 1915.707200, 4442.443000, 1);
	draw_line(cpssp, darea, 1686.865200, 4401.888700, 1911.844900, 4397.060800, 1);
	draw_line(cpssp, darea, 2060.544000, 4370.024600, 2368.563400, 4367.127900, 1);
	draw_line(cpssp, darea, 2061.509500, 4423.131400, 2200.552800, 4421.200300, 1);
	draw_line(cpssp, darea, 2288.420400, 4463.685700, 2601.267800, 4460.789000, 1);
	draw_line(cpssp, darea, 2601.267800, 4460.789000, 2604.164500, 4517.758100, 1);
	draw_line(cpssp, darea, 2412.014400, 4432.787200, 2410.083300, 4501.343300, 1);
	draw_line(cpssp, darea, 2410.083300, 4501.343300, 2400.427500, 4500.377700, 1);
	draw_line(cpssp, darea, 2451.603200, 4417.338000, 2607.061300, 4418.303500, 1);
	draw_line(cpssp, darea, 2605.130100, 4355.540900, 2533.677300, 4359.403300, 1);
	draw_line(cpssp, darea, 2533.677300, 4359.403300, 2535.608500, 4522.586000, 1);
	draw_line(cpssp, darea, 2535.608500, 4522.586000, 2249.797300, 4531.276200, 1);
	draw_line(cpssp, darea, 2249.797300, 4531.276200, 2245.935000, 4485.894000, 1);
	draw_line(cpssp, darea, 2561.679100, 4565.071400, 2412.980000, 4565.071400, 1);
	draw_line(cpssp, darea, 2412.980000, 4565.071400, 2412.980000, 4599.832200, 1);
	draw_line(cpssp, darea, 2367.597800, 4655.835800, 2047.991400, 4661.629200, 1);
	draw_line(cpssp, darea, 2412.014400, 4694.458900, 2416.842300, 4844.123500, 1);
	draw_line(cpssp, darea, 2416.842300, 4844.123500, 2053.784900, 4852.813700, 1);
	draw_line(cpssp, darea, 1929.225300, 4859.572800, 1802.734600, 4862.469500, 1);
	draw_line(cpssp, darea, 1802.734600, 4862.469500, 1797.906700, 5023.721100, 1);
	draw_line(cpssp, darea, 1797.906700, 5023.721100, 2233.382500, 5017.927600, 1);
	draw_text(darea, 2546.230500, 4706.443400, "_S0_");
	draw_line(cpssp, darea, 2565.541400, 4765.911700, 2566.507000, 4820.949700, 1);
	draw_line(cpssp, darea, 2655.340200, 4426.993700, 2654.374600, 4533.207300, 1);
	draw_line(cpssp, darea, 2654.374600, 4533.207300, 2827.213100, 4533.207300, 1);
	draw_text(darea, 3143.173100, 4505.530300, "_P40,5%42,5_");
	draw_line(cpssp, darea, 2918.943000, 4503.274400, 3034.812400, 4500.377700, 1);
	draw_text(darea, 3027.499000, 4415.623500, "(2)");
	draw_line(cpssp, darea, 2720.033900, 4414.441200, 3015.500800, 4409.613300, 1);
	draw_text(darea, 3027.499000, 4351.282700, "(1)");
	draw_line(cpssp, darea, 2720.999500, 4351.678600, 3015.500800, 4343.954000, 1);
	draw_line(cpssp, darea, 1952.008600, 4688.920500, 1953.794500, 4720.174100, 1);
	draw_line(cpssp, darea, 2032.374900, 4687.134600, 2032.374900, 4719.281200, 1);
	draw_line(cpssp, darea, 2026.124200, 4927.340600, 2027.017200, 4960.380100, 1);
	draw_line(cpssp, darea, 1960.045200, 4928.233600, 1960.045200, 4961.273100, 1);
	draw_line(cpssp, darea, -672.637760, 473.879940, -674.239240, 647.543310, 1);
	draw_line(cpssp, darea, 688.328120, 632.525860, 574.685140, 633.034190, 1);
	draw_text(darea, 929.071530, 668.043880, "_E.-Imp._");
	draw_line(cpssp, darea, 914.108710, 639.316250, 781.792150, 636.429390, 1);
	draw_line(cpssp, darea, 821.589590, 483.137190, 575.533930, 476.855130, 1);
	draw_line(cpssp, darea, 821.589590, 445.790030, 575.533930, 441.205570, 1);
	draw_line(cpssp, darea, 1183.178100, 508.601170, 948.277010, 502.723470, 1);
	draw_line(cpssp, darea, 1444.970600, 324.113770, 1335.385100, 322.359810, 1);
	draw_line(cpssp, darea, 1459.931700, 459.168850, 1340.641600, 458.223600, 1);
	draw_line(cpssp, darea, 1339.168600, 499.608810, 1398.040600, 500.285500, 1);
	draw_line(cpssp, darea, 1398.040600, 500.285500, 1398.717300, 606.525760, 1);
	draw_line(cpssp, darea, 1398.717300, 606.525760, 1462.326100, 607.879140, 1);
	draw_line(cpssp, darea, 1554.355900, 606.525760, 1649.769100, 608.555830, 1);
	draw_line(cpssp, darea, 1553.679200, 460.360820, 1648.415700, 462.390890, 1);
	draw_line(cpssp, darea, 949.395420, 429.233100, 1138.191776, 432.616547, 1);
	draw_line(cpssp, darea, 1138.191776, 432.616547, 1184.206700, 435.323310, 1);
	draw_line(cpssp, darea, 1138.191776, 432.616547, 1138.868500, 486.075020, 1);
	draw_line(cpssp, darea, 1138.868500, 486.075020, 1182.176600, 486.751710, 1);
	draw_line(cpssp, darea, 1182.176600, 460.360820, 1092.176900, 458.330750, 1);
	draw_line(cpssp, darea, 1092.176900, 458.330750, 1092.853600, 485.398330, 1);
	draw_line(cpssp, darea, 1092.853600, 485.398330, 945.335280, 482.691570, 1);
	draw_line(cpssp, darea, 948.521300, 451.095280, 1028.819400, 452.349940, 1);
	draw_line(cpssp, darea, 1028.819400, 452.349940, 1028.819400, 316.846900, 1);
	draw_line(cpssp, darea, 1028.819400, 316.846900, 1242.111200, 319.356210, 1);

	/* draw connectors between signals */
	draw_circle(cpssp, darea, 3312.321875, 524.924597, 3, TRUE);
	draw_circle(cpssp, darea, 1034.363855, 3877.029737, 3, TRUE);
	draw_circle(cpssp, darea, 937.115975, 3877.029737, 3, TRUE);
	draw_circle(cpssp, darea, 935.642515, 3641.277337, 3, TRUE);
	draw_circle(cpssp, darea, 938.589425, 3695.795037, 3, TRUE);
	draw_circle(cpssp, darea, 935.642515, 3744.419037, 3, TRUE);
	draw_circle(cpssp, darea, 937.115975, 3785.675737, 3, TRUE);
	draw_circle(cpssp, darea, 938.589425, 3828.405837, 3, TRUE);
	draw_circle(cpssp, darea, 938.589425, 3928.600637, 3, TRUE);
	draw_circle(cpssp, darea, 937.115975, 3971.330737, 3, TRUE);
	draw_circle(cpssp, darea, 938.589425, 4018.481237, 3, TRUE);
	draw_circle(cpssp, darea, 938.589425, 4065.631737, 3, TRUE);
	draw_circle(cpssp, darea, 1019.629325, 1213.027067, 3, TRUE);
	draw_circle(cpssp, darea, 1021.102785, 1600.545157, 3, TRUE);
	draw_circle(cpssp, darea, 1028.470045, 2356.426437, 3, TRUE);
	draw_circle(cpssp, darea, 1028.470045, 1976.275637, 3, TRUE);
	draw_circle(cpssp, darea, 1028.470045, 2736.577237, 3, TRUE);
	draw_circle(cpssp, darea, 1031.416955, 3118.201537, 3, TRUE);
	draw_circle(cpssp, darea, 1031.416955, 3496.878937, 3, TRUE);
	draw_circle(cpssp, darea, 2081.988815, 1350.058177, 3, TRUE);
	draw_circle(cpssp, darea, 2083.462265, 1481.195477, 3, TRUE);
	draw_circle(cpssp, darea, 2084.935715, 1722.841737, 3, TRUE);
	draw_circle(cpssp, darea, 2083.462265, 1859.872847, 3, TRUE);
	draw_circle(cpssp, darea, 2083.462265, 2102.992537, 3, TRUE);
	draw_circle(cpssp, darea, 2084.935715, 2241.497137, 3, TRUE);
	draw_circle(cpssp, darea, 2083.462265, 2478.723037, 3, TRUE);
	draw_circle(cpssp, darea, 2083.462265, 2612.807237, 3, TRUE);
	draw_circle(cpssp, darea, 2084.935715, 2854.453537, 3, TRUE);
	draw_circle(cpssp, darea, 2083.462265, 2985.590837, 3, TRUE);
	draw_circle(cpssp, darea, 2084.935715, 3228.710537, 3, TRUE);
	draw_circle(cpssp, darea, 2086.409175, 3362.794737, 3, TRUE);
	draw_circle(cpssp, darea, 2084.935715, 3605.914437, 3, TRUE);
	draw_circle(cpssp, darea, 2086.409175, 3739.998637, 3, TRUE);
	draw_circle(cpssp, darea, 2086.409175, 1109.885367, 3, TRUE);
	draw_circle(cpssp, darea, 2854.078075, 519.030787, 3, TRUE);
	draw_circle(cpssp, darea, 1850.656725, 3678.113637, 3, TRUE);
	draw_circle(cpssp, darea, 1847.709815, 3532.241837, 3, TRUE);
	draw_circle(cpssp, darea, 1849.183265, 3296.489337, 3, TRUE);
	draw_circle(cpssp, darea, 1847.709815, 3159.458237, 3, TRUE);
	draw_circle(cpssp, darea, 1847.709815, 2923.705837, 3, TRUE);
	draw_circle(cpssp, darea, 1844.762905, 2780.780837, 3, TRUE);
	draw_circle(cpssp, darea, 1847.709815, 2552.395637, 3, TRUE);
	draw_circle(cpssp, darea, 1847.709815, 2406.523837, 3, TRUE);
	draw_circle(cpssp, darea, 1843.289455, 2169.297937, 3, TRUE);
	draw_circle(cpssp, darea, 1843.289455, 2029.319937, 3, TRUE);
	draw_circle(cpssp, darea, 1846.236365, 1789.147117, 3, TRUE);
	draw_circle(cpssp, darea, 1841.816005, 1650.642547, 3, TRUE);
	draw_circle(cpssp, darea, 1843.289455, 1410.469737, 3, TRUE);
	draw_circle(cpssp, darea, 1843.289455, 1273.438627, 3, TRUE);
	draw_circle(cpssp, darea, 1840.342555, 1027.372007, 3, TRUE);
	draw_circle(cpssp, darea, 1749.424255, 4425.375737, 3, TRUE);
	draw_circle(cpssp, darea, 2565.908075, 4996.077937, 3, TRUE);
	draw_circle(cpssp, darea, 1755.214915, 5070.713137, 3, TRUE);
	draw_circle(cpssp, darea, 1138.191776, 432.616547, 3, TRUE);

/* port std_logic funcs */
	static const struct sig_std_logic_funcs port_func_Uhr1 = {
		.std_logic_set = COMP_(port_Uhr1_set),
	};
	static const struct sig_std_logic_funcs port_func_Uhr2 = {
		.std_logic_set = COMP_(port_Uhr2_set),
	};
	static const struct sig_std_logic_funcs port_func_Imp1 = {
		.std_logic_set = COMP_(port_Imp1_set),
	};
	static const struct sig_std_logic_funcs port_func_Imp2 = {
		.std_logic_set = COMP_(port_Imp2_set),
	};
	static const struct sig_std_logic_funcs port_func_22I1 = {
		.std_logic_set = COMP_(port_22I1_set),
	};
	static const struct sig_std_logic_funcs port_func_22I2 = {
		.std_logic_set = COMP_(port_22I2_set),
	};
	static const struct sig_std_logic_funcs port_func_22I3 = {
		.std_logic_set = COMP_(port_22I3_set),
	};
	static const struct sig_std_logic_funcs port_func_22I4 = {
		.std_logic_set = COMP_(port_22I4_set),
	};
	static const struct sig_std_logic_funcs port_func_22I5 = {
		.std_logic_set = COMP_(port_22I5_set),
	};
	static const struct sig_std_logic_funcs port_func_22I6 = {
		.std_logic_set = COMP_(port_22I6_set),
	};
	static const struct sig_std_logic_funcs port_func_22I7 = {
		.std_logic_set = COMP_(port_22I7_set),
	};
	static const struct sig_std_logic_funcs port_func_22I8 = {
		.std_logic_set = COMP_(port_22I8_set),
	};
	static const struct sig_std_logic_funcs port_func_22I9 = {
		.std_logic_set = COMP_(port_22I9_set),
	};
	static const struct sig_std_logic_funcs port_func_22I0 = {
		.std_logic_set = COMP_(port_22I0_set),
	};
	static const struct sig_std_logic_funcs port_func_22II1 = {
		.std_logic_set = COMP_(port_22II1_set),
	};
	static const struct sig_std_logic_funcs port_func_22II2 = {
		.std_logic_set = COMP_(port_22II2_set),
	};
	static const struct sig_std_logic_funcs port_func_22II3 = {
		.std_logic_set = COMP_(port_22II3_set),
	};
	static const struct sig_std_logic_funcs port_func_22II4 = {
		.std_logic_set = COMP_(port_22II4_set),
	};
	static const struct sig_std_logic_funcs port_func_22II5 = {
		.std_logic_set = COMP_(port_22II5_set),
	};
	static const struct sig_std_logic_funcs port_func_22II6 = {
		.std_logic_set = COMP_(port_22II6_set),
	};
	static const struct sig_std_logic_funcs port_func_22II7 = {
		.std_logic_set = COMP_(port_22II7_set),
	};
	static const struct sig_std_logic_funcs port_func_22II8 = {
		.std_logic_set = COMP_(port_22II8_set),
	};
	static const struct sig_std_logic_funcs port_func_22II9 = {
		.std_logic_set = COMP_(port_22II9_set),
	};
	static const struct sig_std_logic_funcs port_func_22II0 = {
		.std_logic_set = COMP_(port_22II0_set),
	};
	static const struct sig_std_logic_funcs port_func_22III1 = {
		.std_logic_set = COMP_(port_22III1_set),
	};
	static const struct sig_std_logic_funcs port_func_22III2 = {
		.std_logic_set = COMP_(port_22III2_set),
	};
	static const struct sig_std_logic_funcs port_func_22III3 = {
		.std_logic_set = COMP_(port_22III3_set),
	};
	static const struct sig_std_logic_funcs port_func_22III4 = {
		.std_logic_set = COMP_(port_22III4_set),
	};
	static const struct sig_std_logic_funcs port_func_22III5 = {
		.std_logic_set = COMP_(port_22III5_set),
	};
	static const struct sig_std_logic_funcs port_func_22III6 = {
		.std_logic_set = COMP_(port_22III6_set),
	};
	static const struct sig_std_logic_funcs port_func_22III7 = {
		.std_logic_set = COMP_(port_22III7_set),
	};
	static const struct sig_std_logic_funcs port_func_22III8 = {
		.std_logic_set = COMP_(port_22III8_set),
	};
	static const struct sig_std_logic_funcs port_func_22III9 = {
		.std_logic_set = COMP_(port_22III9_set),
	};
	static const struct sig_std_logic_funcs port_func_22III0 = {
		.std_logic_set = COMP_(port_22III0_set),
	};
	static const struct sig_std_logic_funcs port_func_30I1 = {
		.std_logic_set = COMP_(port_30I1_set),
	};
	static const struct sig_std_logic_funcs port_func_30I2 = {
		.std_logic_set = COMP_(port_30I2_set),
	};
	static const struct sig_std_logic_funcs port_func_30I3 = {
		.std_logic_set = COMP_(port_30I3_set),
	};
	static const struct sig_std_logic_funcs port_func_30I4 = {
		.std_logic_set = COMP_(port_30I4_set),
	};
	static const struct sig_std_logic_funcs port_func_30I5 = {
		.std_logic_set = COMP_(port_30I5_set),
	};
	static const struct sig_std_logic_funcs port_func_30I6 = {
		.std_logic_set = COMP_(port_30I6_set),
	};
	static const struct sig_std_logic_funcs port_func_30I7 = {
		.std_logic_set = COMP_(port_30I7_set),
	};
	static const struct sig_std_logic_funcs port_func_30I8 = {
		.std_logic_set = COMP_(port_30I8_set),
	};
	static const struct sig_std_logic_funcs port_func_30I9 = {
		.std_logic_set = COMP_(port_30I9_set),
	};
	static const struct sig_std_logic_funcs port_func_30I0 = {
		.std_logic_set = COMP_(port_30I0_set),
	};
	static const struct sig_std_logic_funcs port_func_30II1 = {
		.std_logic_set = COMP_(port_30II1_set),
	};
	static const struct sig_std_logic_funcs port_func_30II2 = {
		.std_logic_set = COMP_(port_30II2_set),
	};
	static const struct sig_std_logic_funcs port_func_30II3 = {
		.std_logic_set = COMP_(port_30II3_set),
	};
	static const struct sig_std_logic_funcs port_func_30II4 = {
		.std_logic_set = COMP_(port_30II4_set),
	};
	static const struct sig_std_logic_funcs port_func_30II5 = {
		.std_logic_set = COMP_(port_30II5_set),
	};
	static const struct sig_std_logic_funcs port_func_30II6 = {
		.std_logic_set = COMP_(port_30II6_set),
	};
	static const struct sig_std_logic_funcs port_func_30II7 = {
		.std_logic_set = COMP_(port_30II7_set),
	};
	static const struct sig_std_logic_funcs port_func_30II8 = {
		.std_logic_set = COMP_(port_30II8_set),
	};
	static const struct sig_std_logic_funcs port_func_30II9 = {
		.std_logic_set = COMP_(port_30II9_set),
	};
	static const struct sig_std_logic_funcs port_func_30II0 = {
		.std_logic_set = COMP_(port_30II0_set),
	};
	static const struct sig_std_logic_funcs port_func_30III1 = {
		.std_logic_set = COMP_(port_30III1_set),
	};
	static const struct sig_std_logic_funcs port_func_30III2 = {
		.std_logic_set = COMP_(port_30III2_set),
	};
	static const struct sig_std_logic_funcs port_func_30III3 = {
		.std_logic_set = COMP_(port_30III3_set),
	};
	static const struct sig_std_logic_funcs port_func_30III4 = {
		.std_logic_set = COMP_(port_30III4_set),
	};
	static const struct sig_std_logic_funcs port_func_30III5 = {
		.std_logic_set = COMP_(port_30III5_set),
	};
	static const struct sig_std_logic_funcs port_func_30III6 = {
		.std_logic_set = COMP_(port_30III6_set),
	};
	static const struct sig_std_logic_funcs port_func_30III7 = {
		.std_logic_set = COMP_(port_30III7_set),
	};
	static const struct sig_std_logic_funcs port_func_30III8 = {
		.std_logic_set = COMP_(port_30III8_set),
	};
	static const struct sig_std_logic_funcs port_func_30III9 = {
		.std_logic_set = COMP_(port_30III9_set),
	};
	static const struct sig_std_logic_funcs port_func_30III0 = {
		.std_logic_set = COMP_(port_30III0_set),
	};

/* gui port std_logic funcs */
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8760 = {
		.std_logic_set = COMP_(gui_port_0x1bb8760_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb9650 = {
		.std_logic_set = COMP_(gui_port_0x1bb9650_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb9630 = {
		.std_logic_set = COMP_(gui_port_0x1bb9630_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb69a0 = {
		.std_logic_set = COMP_(gui_port_0x1bb69a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb82f0 = {
		.std_logic_set = COMP_(gui_port_0x1bb82f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb81b0 = {
		.std_logic_set = COMP_(gui_port_0x1bb81b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8f00 = {
		.std_logic_set = COMP_(gui_port_0x1bb8f00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb3b20 = {
		.std_logic_set = COMP_(gui_port_0x1bb3b20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6a40 = {
		.std_logic_set = COMP_(gui_port_0x1bb6a40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8550 = {
		.std_logic_set = COMP_(gui_port_0x1bb8550_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6980 = {
		.std_logic_set = COMP_(gui_port_0x1bb6980_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8190 = {
		.std_logic_set = COMP_(gui_port_0x1bb8190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6640 = {
		.std_logic_set = COMP_(gui_port_0x1bb6640_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbe9b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbe9b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbe9d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbe9d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbe9f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbe9f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea10 = {
		.std_logic_set = COMP_(gui_port_0x1bbea10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea30 = {
		.std_logic_set = COMP_(gui_port_0x1bbea30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea50 = {
		.std_logic_set = COMP_(gui_port_0x1bbea50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea70 = {
		.std_logic_set = COMP_(gui_port_0x1bbea70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea90 = {
		.std_logic_set = COMP_(gui_port_0x1bbea90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeab0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeab0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbead0 = {
		.std_logic_set = COMP_(gui_port_0x1bbead0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeaf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeaf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb10 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb30 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb50 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb70 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb90 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbebb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbebb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbebd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbebd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbebf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbebf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec10 = {
		.std_logic_set = COMP_(gui_port_0x1bbec10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec30 = {
		.std_logic_set = COMP_(gui_port_0x1bbec30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec50 = {
		.std_logic_set = COMP_(gui_port_0x1bbec50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec70 = {
		.std_logic_set = COMP_(gui_port_0x1bbec70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec90 = {
		.std_logic_set = COMP_(gui_port_0x1bbec90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbecb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbecb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbecd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbecd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbecf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbecf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed10 = {
		.std_logic_set = COMP_(gui_port_0x1bbed10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed30 = {
		.std_logic_set = COMP_(gui_port_0x1bbed30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed50 = {
		.std_logic_set = COMP_(gui_port_0x1bbed50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed70 = {
		.std_logic_set = COMP_(gui_port_0x1bbed70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed90 = {
		.std_logic_set = COMP_(gui_port_0x1bbed90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbedb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbedb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbedd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbedd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbedf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbedf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee10 = {
		.std_logic_set = COMP_(gui_port_0x1bbee10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee30 = {
		.std_logic_set = COMP_(gui_port_0x1bbee30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee50 = {
		.std_logic_set = COMP_(gui_port_0x1bbee50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee70 = {
		.std_logic_set = COMP_(gui_port_0x1bbee70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee90 = {
		.std_logic_set = COMP_(gui_port_0x1bbee90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeeb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeeb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeed0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeed0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeef0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeef0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef10 = {
		.std_logic_set = COMP_(gui_port_0x1bbef10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef30 = {
		.std_logic_set = COMP_(gui_port_0x1bbef30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef50 = {
		.std_logic_set = COMP_(gui_port_0x1bbef50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef70 = {
		.std_logic_set = COMP_(gui_port_0x1bbef70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef90 = {
		.std_logic_set = COMP_(gui_port_0x1bbef90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbefb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbefb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbefd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbefd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeff0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeff0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf010 = {
		.std_logic_set = COMP_(gui_port_0x1bbf010_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf030 = {
		.std_logic_set = COMP_(gui_port_0x1bbf030_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf050 = {
		.std_logic_set = COMP_(gui_port_0x1bbf050_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf070 = {
		.std_logic_set = COMP_(gui_port_0x1bbf070_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf090 = {
		.std_logic_set = COMP_(gui_port_0x1bbf090_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf0b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf0b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf0d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf0d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf0f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf0f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf110 = {
		.std_logic_set = COMP_(gui_port_0x1bbf110_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf130 = {
		.std_logic_set = COMP_(gui_port_0x1bbf130_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf150 = {
		.std_logic_set = COMP_(gui_port_0x1bbf150_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf170 = {
		.std_logic_set = COMP_(gui_port_0x1bbf170_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf190 = {
		.std_logic_set = COMP_(gui_port_0x1bbf190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf1b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf1b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf1d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf1d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf1f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf1f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf210 = {
		.std_logic_set = COMP_(gui_port_0x1bbf210_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf230 = {
		.std_logic_set = COMP_(gui_port_0x1bbf230_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf250 = {
		.std_logic_set = COMP_(gui_port_0x1bbf250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf270 = {
		.std_logic_set = COMP_(gui_port_0x1bbf270_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf290 = {
		.std_logic_set = COMP_(gui_port_0x1bbf290_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf2b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf2b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf2d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf2d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf2f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf2f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf310 = {
		.std_logic_set = COMP_(gui_port_0x1bbf310_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf330 = {
		.std_logic_set = COMP_(gui_port_0x1bbf330_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf350 = {
		.std_logic_set = COMP_(gui_port_0x1bbf350_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf370 = {
		.std_logic_set = COMP_(gui_port_0x1bbf370_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf390 = {
		.std_logic_set = COMP_(gui_port_0x1bbf390_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf3b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf3b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf3d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf3d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf3f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf3f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf410 = {
		.std_logic_set = COMP_(gui_port_0x1bbf410_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf430 = {
		.std_logic_set = COMP_(gui_port_0x1bbf430_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf450 = {
		.std_logic_set = COMP_(gui_port_0x1bbf450_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf470 = {
		.std_logic_set = COMP_(gui_port_0x1bbf470_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf490 = {
		.std_logic_set = COMP_(gui_port_0x1bbf490_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf4b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf4b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf4d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf4d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf4f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf4f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf510 = {
		.std_logic_set = COMP_(gui_port_0x1bbf510_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf530 = {
		.std_logic_set = COMP_(gui_port_0x1bbf530_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf550 = {
		.std_logic_set = COMP_(gui_port_0x1bbf550_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf570 = {
		.std_logic_set = COMP_(gui_port_0x1bbf570_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf590 = {
		.std_logic_set = COMP_(gui_port_0x1bbf590_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf5b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf5b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf5d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf5d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf5f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf5f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf610 = {
		.std_logic_set = COMP_(gui_port_0x1bbf610_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf630 = {
		.std_logic_set = COMP_(gui_port_0x1bbf630_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf650 = {
		.std_logic_set = COMP_(gui_port_0x1bbf650_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf670 = {
		.std_logic_set = COMP_(gui_port_0x1bbf670_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf690 = {
		.std_logic_set = COMP_(gui_port_0x1bbf690_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf6b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf6b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf6d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf6d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf6f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf6f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf710 = {
		.std_logic_set = COMP_(gui_port_0x1bbf710_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf730 = {
		.std_logic_set = COMP_(gui_port_0x1bbf730_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf750 = {
		.std_logic_set = COMP_(gui_port_0x1bbf750_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc05f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc05f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0740 = {
		.std_logic_set = COMP_(gui_port_0x1bc0740_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0890 = {
		.std_logic_set = COMP_(gui_port_0x1bc0890_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc09e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc09e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0b30 = {
		.std_logic_set = COMP_(gui_port_0x1bc0b30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0c80 = {
		.std_logic_set = COMP_(gui_port_0x1bc0c80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0dd0 = {
		.std_logic_set = COMP_(gui_port_0x1bc0dd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0f20 = {
		.std_logic_set = COMP_(gui_port_0x1bc0f20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1070 = {
		.std_logic_set = COMP_(gui_port_0x1bc1070_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc11c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc11c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1310 = {
		.std_logic_set = COMP_(gui_port_0x1bc1310_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1460 = {
		.std_logic_set = COMP_(gui_port_0x1bc1460_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc15b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc15b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1700 = {
		.std_logic_set = COMP_(gui_port_0x1bc1700_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1850 = {
		.std_logic_set = COMP_(gui_port_0x1bc1850_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc19a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc19a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1af0 = {
		.std_logic_set = COMP_(gui_port_0x1bc1af0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1c40 = {
		.std_logic_set = COMP_(gui_port_0x1bc1c40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1d90 = {
		.std_logic_set = COMP_(gui_port_0x1bc1d90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1ee0 = {
		.std_logic_set = COMP_(gui_port_0x1bc1ee0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2030 = {
		.std_logic_set = COMP_(gui_port_0x1bc2030_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2180 = {
		.std_logic_set = COMP_(gui_port_0x1bc2180_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc22d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc22d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2420 = {
		.std_logic_set = COMP_(gui_port_0x1bc2420_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2570 = {
		.std_logic_set = COMP_(gui_port_0x1bc2570_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc26c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc26c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2810 = {
		.std_logic_set = COMP_(gui_port_0x1bc2810_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2960 = {
		.std_logic_set = COMP_(gui_port_0x1bc2960_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2ab0 = {
		.std_logic_set = COMP_(gui_port_0x1bc2ab0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2c00 = {
		.std_logic_set = COMP_(gui_port_0x1bc2c00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2d50 = {
		.std_logic_set = COMP_(gui_port_0x1bc2d50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2ea0 = {
		.std_logic_set = COMP_(gui_port_0x1bc2ea0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2ff0 = {
		.std_logic_set = COMP_(gui_port_0x1bc2ff0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3140 = {
		.std_logic_set = COMP_(gui_port_0x1bc3140_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3290 = {
		.std_logic_set = COMP_(gui_port_0x1bc3290_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc33e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc33e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3530 = {
		.std_logic_set = COMP_(gui_port_0x1bc3530_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3680 = {
		.std_logic_set = COMP_(gui_port_0x1bc3680_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc37d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc37d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3920 = {
		.std_logic_set = COMP_(gui_port_0x1bc3920_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3a70 = {
		.std_logic_set = COMP_(gui_port_0x1bc3a70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3bc0 = {
		.std_logic_set = COMP_(gui_port_0x1bc3bc0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3d10 = {
		.std_logic_set = COMP_(gui_port_0x1bc3d10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3e60 = {
		.std_logic_set = COMP_(gui_port_0x1bc3e60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3fb0 = {
		.std_logic_set = COMP_(gui_port_0x1bc3fb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4100 = {
		.std_logic_set = COMP_(gui_port_0x1bc4100_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4250 = {
		.std_logic_set = COMP_(gui_port_0x1bc4250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc43a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc43a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc44f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc44f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4640 = {
		.std_logic_set = COMP_(gui_port_0x1bc4640_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4790 = {
		.std_logic_set = COMP_(gui_port_0x1bc4790_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc48e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc48e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4a30 = {
		.std_logic_set = COMP_(gui_port_0x1bc4a30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4b80 = {
		.std_logic_set = COMP_(gui_port_0x1bc4b80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4cd0 = {
		.std_logic_set = COMP_(gui_port_0x1bc4cd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4e20 = {
		.std_logic_set = COMP_(gui_port_0x1bc4e20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4f70 = {
		.std_logic_set = COMP_(gui_port_0x1bc4f70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc50c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc50c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5210 = {
		.std_logic_set = COMP_(gui_port_0x1bc5210_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5360 = {
		.std_logic_set = COMP_(gui_port_0x1bc5360_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc54b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc54b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5600 = {
		.std_logic_set = COMP_(gui_port_0x1bc5600_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5750 = {
		.std_logic_set = COMP_(gui_port_0x1bc5750_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc58a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc58a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc59f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc59f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5b40 = {
		.std_logic_set = COMP_(gui_port_0x1bc5b40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5c90 = {
		.std_logic_set = COMP_(gui_port_0x1bc5c90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5de0 = {
		.std_logic_set = COMP_(gui_port_0x1bc5de0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5f30 = {
		.std_logic_set = COMP_(gui_port_0x1bc5f30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6080 = {
		.std_logic_set = COMP_(gui_port_0x1bc6080_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc61d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc61d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6320 = {
		.std_logic_set = COMP_(gui_port_0x1bc6320_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6470 = {
		.std_logic_set = COMP_(gui_port_0x1bc6470_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc65c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc65c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6710 = {
		.std_logic_set = COMP_(gui_port_0x1bc6710_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6860 = {
		.std_logic_set = COMP_(gui_port_0x1bc6860_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc69b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc69b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6b00 = {
		.std_logic_set = COMP_(gui_port_0x1bc6b00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6c50 = {
		.std_logic_set = COMP_(gui_port_0x1bc6c50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6da0 = {
		.std_logic_set = COMP_(gui_port_0x1bc6da0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6ef0 = {
		.std_logic_set = COMP_(gui_port_0x1bc6ef0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7040 = {
		.std_logic_set = COMP_(gui_port_0x1bc7040_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7190 = {
		.std_logic_set = COMP_(gui_port_0x1bc7190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc72e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc72e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7430 = {
		.std_logic_set = COMP_(gui_port_0x1bc7430_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7580 = {
		.std_logic_set = COMP_(gui_port_0x1bc7580_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc76d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc76d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7820 = {
		.std_logic_set = COMP_(gui_port_0x1bc7820_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7970 = {
		.std_logic_set = COMP_(gui_port_0x1bc7970_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7ac0 = {
		.std_logic_set = COMP_(gui_port_0x1bc7ac0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7c10 = {
		.std_logic_set = COMP_(gui_port_0x1bc7c10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7d60 = {
		.std_logic_set = COMP_(gui_port_0x1bc7d60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7eb0 = {
		.std_logic_set = COMP_(gui_port_0x1bc7eb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8000 = {
		.std_logic_set = COMP_(gui_port_0x1bc8000_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8150 = {
		.std_logic_set = COMP_(gui_port_0x1bc8150_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc82a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc82a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc83f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc83f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8540 = {
		.std_logic_set = COMP_(gui_port_0x1bc8540_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8690 = {
		.std_logic_set = COMP_(gui_port_0x1bc8690_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc87e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc87e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8930 = {
		.std_logic_set = COMP_(gui_port_0x1bc8930_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8a80 = {
		.std_logic_set = COMP_(gui_port_0x1bc8a80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8bd0 = {
		.std_logic_set = COMP_(gui_port_0x1bc8bd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8d20 = {
		.std_logic_set = COMP_(gui_port_0x1bc8d20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8e70 = {
		.std_logic_set = COMP_(gui_port_0x1bc8e70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8fc0 = {
		.std_logic_set = COMP_(gui_port_0x1bc8fc0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6b50 = {
		.std_logic_set = COMP_(gui_port_0x1bb6b50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8250 = {
		.std_logic_set = COMP_(gui_port_0x1bb8250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb82b0 = {
		.std_logic_set = COMP_(gui_port_0x1bb82b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc91c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc91c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9310 = {
		.std_logic_set = COMP_(gui_port_0x1bc9310_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9460 = {
		.std_logic_set = COMP_(gui_port_0x1bc9460_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc95b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc95b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9700 = {
		.std_logic_set = COMP_(gui_port_0x1bc9700_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9850 = {
		.std_logic_set = COMP_(gui_port_0x1bc9850_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc99a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc99a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9af0 = {
		.std_logic_set = COMP_(gui_port_0x1bc9af0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9c40 = {
		.std_logic_set = COMP_(gui_port_0x1bc9c40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9d90 = {
		.std_logic_set = COMP_(gui_port_0x1bc9d90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9ee0 = {
		.std_logic_set = COMP_(gui_port_0x1bc9ee0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca030 = {
		.std_logic_set = COMP_(gui_port_0x1bca030_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca180 = {
		.std_logic_set = COMP_(gui_port_0x1bca180_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca2d0 = {
		.std_logic_set = COMP_(gui_port_0x1bca2d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca420 = {
		.std_logic_set = COMP_(gui_port_0x1bca420_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca570 = {
		.std_logic_set = COMP_(gui_port_0x1bca570_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca6c0 = {
		.std_logic_set = COMP_(gui_port_0x1bca6c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca810 = {
		.std_logic_set = COMP_(gui_port_0x1bca810_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca960 = {
		.std_logic_set = COMP_(gui_port_0x1bca960_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcaab0 = {
		.std_logic_set = COMP_(gui_port_0x1bcaab0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcac00 = {
		.std_logic_set = COMP_(gui_port_0x1bcac00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcad50 = {
		.std_logic_set = COMP_(gui_port_0x1bcad50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcaea0 = {
		.std_logic_set = COMP_(gui_port_0x1bcaea0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcaff0 = {
		.std_logic_set = COMP_(gui_port_0x1bcaff0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb140 = {
		.std_logic_set = COMP_(gui_port_0x1bcb140_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb290 = {
		.std_logic_set = COMP_(gui_port_0x1bcb290_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb3e0 = {
		.std_logic_set = COMP_(gui_port_0x1bcb3e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb530 = {
		.std_logic_set = COMP_(gui_port_0x1bcb530_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb680 = {
		.std_logic_set = COMP_(gui_port_0x1bcb680_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb7d0 = {
		.std_logic_set = COMP_(gui_port_0x1bcb7d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb920 = {
		.std_logic_set = COMP_(gui_port_0x1bcb920_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcba70 = {
		.std_logic_set = COMP_(gui_port_0x1bcba70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbbc0 = {
		.std_logic_set = COMP_(gui_port_0x1bcbbc0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbd10 = {
		.std_logic_set = COMP_(gui_port_0x1bcbd10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbe60 = {
		.std_logic_set = COMP_(gui_port_0x1bcbe60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbfb0 = {
		.std_logic_set = COMP_(gui_port_0x1bcbfb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc100 = {
		.std_logic_set = COMP_(gui_port_0x1bcc100_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc250 = {
		.std_logic_set = COMP_(gui_port_0x1bcc250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc3a0 = {
		.std_logic_set = COMP_(gui_port_0x1bcc3a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc4f0 = {
		.std_logic_set = COMP_(gui_port_0x1bcc4f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc640 = {
		.std_logic_set = COMP_(gui_port_0x1bcc640_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc790 = {
		.std_logic_set = COMP_(gui_port_0x1bcc790_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc8e0 = {
		.std_logic_set = COMP_(gui_port_0x1bcc8e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcca30 = {
		.std_logic_set = COMP_(gui_port_0x1bcca30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bccb80 = {
		.std_logic_set = COMP_(gui_port_0x1bccb80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcccd0 = {
		.std_logic_set = COMP_(gui_port_0x1bcccd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcce20 = {
		.std_logic_set = COMP_(gui_port_0x1bcce20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bccf70 = {
		.std_logic_set = COMP_(gui_port_0x1bccf70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd0c0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd0c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd210 = {
		.std_logic_set = COMP_(gui_port_0x1bcd210_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd360 = {
		.std_logic_set = COMP_(gui_port_0x1bcd360_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd4b0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd4b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd600 = {
		.std_logic_set = COMP_(gui_port_0x1bcd600_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd750 = {
		.std_logic_set = COMP_(gui_port_0x1bcd750_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd8a0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd8a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd9f0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd9f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdb40 = {
		.std_logic_set = COMP_(gui_port_0x1bcdb40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdc90 = {
		.std_logic_set = COMP_(gui_port_0x1bcdc90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdde0 = {
		.std_logic_set = COMP_(gui_port_0x1bcdde0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdf30 = {
		.std_logic_set = COMP_(gui_port_0x1bcdf30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce080 = {
		.std_logic_set = COMP_(gui_port_0x1bce080_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce1d0 = {
		.std_logic_set = COMP_(gui_port_0x1bce1d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce320 = {
		.std_logic_set = COMP_(gui_port_0x1bce320_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce470 = {
		.std_logic_set = COMP_(gui_port_0x1bce470_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce5c0 = {
		.std_logic_set = COMP_(gui_port_0x1bce5c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce710 = {
		.std_logic_set = COMP_(gui_port_0x1bce710_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce860 = {
		.std_logic_set = COMP_(gui_port_0x1bce860_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce9b0 = {
		.std_logic_set = COMP_(gui_port_0x1bce9b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bceb00 = {
		.std_logic_set = COMP_(gui_port_0x1bceb00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcec50 = {
		.std_logic_set = COMP_(gui_port_0x1bcec50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bceda0 = {
		.std_logic_set = COMP_(gui_port_0x1bceda0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bceef0 = {
		.std_logic_set = COMP_(gui_port_0x1bceef0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf040 = {
		.std_logic_set = COMP_(gui_port_0x1bcf040_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf190 = {
		.std_logic_set = COMP_(gui_port_0x1bcf190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf2e0 = {
		.std_logic_set = COMP_(gui_port_0x1bcf2e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf430 = {
		.std_logic_set = COMP_(gui_port_0x1bcf430_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf580 = {
		.std_logic_set = COMP_(gui_port_0x1bcf580_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf6d0 = {
		.std_logic_set = COMP_(gui_port_0x1bcf6d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf820 = {
		.std_logic_set = COMP_(gui_port_0x1bcf820_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf970 = {
		.std_logic_set = COMP_(gui_port_0x1bcf970_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfac0 = {
		.std_logic_set = COMP_(gui_port_0x1bcfac0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfc10 = {
		.std_logic_set = COMP_(gui_port_0x1bcfc10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfd60 = {
		.std_logic_set = COMP_(gui_port_0x1bcfd60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfeb0 = {
		.std_logic_set = COMP_(gui_port_0x1bcfeb0_set),
	};

	/* connect ports as in */
	sig_std_logic_connect_in(port_Uhr1, cpssp, &port_func_Uhr1);
	sig_std_logic_connect_in(port_Uhr2, cpssp, &port_func_Uhr2);
	sig_std_logic_connect_in(port_Imp1, cpssp, &port_func_Imp1);
	sig_std_logic_connect_in(port_Imp2, cpssp, &port_func_Imp2);
	sig_std_logic_connect_in(port_22I1, cpssp, &port_func_22I1);
	sig_std_logic_connect_in(port_22I2, cpssp, &port_func_22I2);
	sig_std_logic_connect_in(port_22I3, cpssp, &port_func_22I3);
	sig_std_logic_connect_in(port_22I4, cpssp, &port_func_22I4);
	sig_std_logic_connect_in(port_22I5, cpssp, &port_func_22I5);
	sig_std_logic_connect_in(port_22I6, cpssp, &port_func_22I6);
	sig_std_logic_connect_in(port_22I7, cpssp, &port_func_22I7);
	sig_std_logic_connect_in(port_22I8, cpssp, &port_func_22I8);
	sig_std_logic_connect_in(port_22I9, cpssp, &port_func_22I9);
	sig_std_logic_connect_in(port_22I0, cpssp, &port_func_22I0);
	sig_std_logic_connect_in(port_22II1, cpssp, &port_func_22II1);
	sig_std_logic_connect_in(port_22II2, cpssp, &port_func_22II2);
	sig_std_logic_connect_in(port_22II3, cpssp, &port_func_22II3);
	sig_std_logic_connect_in(port_22II4, cpssp, &port_func_22II4);
	sig_std_logic_connect_in(port_22II5, cpssp, &port_func_22II5);
	sig_std_logic_connect_in(port_22II6, cpssp, &port_func_22II6);
	sig_std_logic_connect_in(port_22II7, cpssp, &port_func_22II7);
	sig_std_logic_connect_in(port_22II8, cpssp, &port_func_22II8);
	sig_std_logic_connect_in(port_22II9, cpssp, &port_func_22II9);
	sig_std_logic_connect_in(port_22II0, cpssp, &port_func_22II0);
	sig_std_logic_connect_in(port_22III1, cpssp, &port_func_22III1);
	sig_std_logic_connect_in(port_22III2, cpssp, &port_func_22III2);
	sig_std_logic_connect_in(port_22III3, cpssp, &port_func_22III3);
	sig_std_logic_connect_in(port_22III4, cpssp, &port_func_22III4);
	sig_std_logic_connect_in(port_22III5, cpssp, &port_func_22III5);
	sig_std_logic_connect_in(port_22III6, cpssp, &port_func_22III6);
	sig_std_logic_connect_in(port_22III7, cpssp, &port_func_22III7);
	sig_std_logic_connect_in(port_22III8, cpssp, &port_func_22III8);
	sig_std_logic_connect_in(port_22III9, cpssp, &port_func_22III9);
	sig_std_logic_connect_in(port_22III0, cpssp, &port_func_22III0);
	sig_std_logic_connect_in(port_30I1, cpssp, &port_func_30I1);
	sig_std_logic_connect_in(port_30I2, cpssp, &port_func_30I2);
	sig_std_logic_connect_in(port_30I3, cpssp, &port_func_30I3);
	sig_std_logic_connect_in(port_30I4, cpssp, &port_func_30I4);
	sig_std_logic_connect_in(port_30I5, cpssp, &port_func_30I5);
	sig_std_logic_connect_in(port_30I6, cpssp, &port_func_30I6);
	sig_std_logic_connect_in(port_30I7, cpssp, &port_func_30I7);
	sig_std_logic_connect_in(port_30I8, cpssp, &port_func_30I8);
	sig_std_logic_connect_in(port_30I9, cpssp, &port_func_30I9);
	sig_std_logic_connect_in(port_30I0, cpssp, &port_func_30I0);
	sig_std_logic_connect_in(port_30II1, cpssp, &port_func_30II1);
	sig_std_logic_connect_in(port_30II2, cpssp, &port_func_30II2);
	sig_std_logic_connect_in(port_30II3, cpssp, &port_func_30II3);
	sig_std_logic_connect_in(port_30II4, cpssp, &port_func_30II4);
	sig_std_logic_connect_in(port_30II5, cpssp, &port_func_30II5);
	sig_std_logic_connect_in(port_30II6, cpssp, &port_func_30II6);
	sig_std_logic_connect_in(port_30II7, cpssp, &port_func_30II7);
	sig_std_logic_connect_in(port_30II8, cpssp, &port_func_30II8);
	sig_std_logic_connect_in(port_30II9, cpssp, &port_func_30II9);
	sig_std_logic_connect_in(port_30II0, cpssp, &port_func_30II0);
	sig_std_logic_connect_in(port_30III1, cpssp, &port_func_30III1);
	sig_std_logic_connect_in(port_30III2, cpssp, &port_func_30III2);
	sig_std_logic_connect_in(port_30III3, cpssp, &port_func_30III3);
	sig_std_logic_connect_in(port_30III4, cpssp, &port_func_30III4);
	sig_std_logic_connect_in(port_30III5, cpssp, &port_func_30III5);
	sig_std_logic_connect_in(port_30III6, cpssp, &port_func_30III6);
	sig_std_logic_connect_in(port_30III7, cpssp, &port_func_30III7);
	sig_std_logic_connect_in(port_30III8, cpssp, &port_func_30III8);
	sig_std_logic_connect_in(port_30III9, cpssp, &port_func_30III9);
	sig_std_logic_connect_in(port_30III0, cpssp, &port_func_30III0);

	/* connect gui ports as in */
	sig_std_logic_connect_in(gui_port_0x1bb8760, cpssp, &gui_port_func_0x1bb8760);
	sig_std_logic_connect_in(gui_port_0x1bb9650, cpssp, &gui_port_func_0x1bb9650);
	sig_std_logic_connect_in(gui_port_0x1bb9630, cpssp, &gui_port_func_0x1bb9630);
	sig_std_logic_connect_in(gui_port_0x1bb69a0, cpssp, &gui_port_func_0x1bb69a0);
	sig_std_logic_connect_in(gui_port_0x1bb82f0, cpssp, &gui_port_func_0x1bb82f0);
	sig_std_logic_connect_in(gui_port_0x1bb81b0, cpssp, &gui_port_func_0x1bb81b0);
	sig_std_logic_connect_in(gui_port_0x1bb8f00, cpssp, &gui_port_func_0x1bb8f00);
	sig_std_logic_connect_in(gui_port_0x1bb3b20, cpssp, &gui_port_func_0x1bb3b20);
	sig_std_logic_connect_in(gui_port_0x1bb6a40, cpssp, &gui_port_func_0x1bb6a40);
	sig_std_logic_connect_in(gui_port_0x1bb8550, cpssp, &gui_port_func_0x1bb8550);
	sig_std_logic_connect_in(gui_port_0x1bb6980, cpssp, &gui_port_func_0x1bb6980);
	sig_std_logic_connect_in(gui_port_0x1bb8190, cpssp, &gui_port_func_0x1bb8190);
	sig_std_logic_connect_in(gui_port_0x1bb6640, cpssp, &gui_port_func_0x1bb6640);
	sig_std_logic_connect_in(gui_port_0x1bbe9b0, cpssp, &gui_port_func_0x1bbe9b0);
	sig_std_logic_connect_in(gui_port_0x1bbe9d0, cpssp, &gui_port_func_0x1bbe9d0);
	sig_std_logic_connect_in(gui_port_0x1bbe9f0, cpssp, &gui_port_func_0x1bbe9f0);
	sig_std_logic_connect_in(gui_port_0x1bbea10, cpssp, &gui_port_func_0x1bbea10);
	sig_std_logic_connect_in(gui_port_0x1bbea30, cpssp, &gui_port_func_0x1bbea30);
	sig_std_logic_connect_in(gui_port_0x1bbea50, cpssp, &gui_port_func_0x1bbea50);
	sig_std_logic_connect_in(gui_port_0x1bbea70, cpssp, &gui_port_func_0x1bbea70);
	sig_std_logic_connect_in(gui_port_0x1bbea90, cpssp, &gui_port_func_0x1bbea90);
	sig_std_logic_connect_in(gui_port_0x1bbeab0, cpssp, &gui_port_func_0x1bbeab0);
	sig_std_logic_connect_in(gui_port_0x1bbead0, cpssp, &gui_port_func_0x1bbead0);
	sig_std_logic_connect_in(gui_port_0x1bbeaf0, cpssp, &gui_port_func_0x1bbeaf0);
	sig_std_logic_connect_in(gui_port_0x1bbeb10, cpssp, &gui_port_func_0x1bbeb10);
	sig_std_logic_connect_in(gui_port_0x1bbeb30, cpssp, &gui_port_func_0x1bbeb30);
	sig_std_logic_connect_in(gui_port_0x1bbeb50, cpssp, &gui_port_func_0x1bbeb50);
	sig_std_logic_connect_in(gui_port_0x1bbeb70, cpssp, &gui_port_func_0x1bbeb70);
	sig_std_logic_connect_in(gui_port_0x1bbeb90, cpssp, &gui_port_func_0x1bbeb90);
	sig_std_logic_connect_in(gui_port_0x1bbebb0, cpssp, &gui_port_func_0x1bbebb0);
	sig_std_logic_connect_in(gui_port_0x1bbebd0, cpssp, &gui_port_func_0x1bbebd0);
	sig_std_logic_connect_in(gui_port_0x1bbebf0, cpssp, &gui_port_func_0x1bbebf0);
	sig_std_logic_connect_in(gui_port_0x1bbec10, cpssp, &gui_port_func_0x1bbec10);
	sig_std_logic_connect_in(gui_port_0x1bbec30, cpssp, &gui_port_func_0x1bbec30);
	sig_std_logic_connect_in(gui_port_0x1bbec50, cpssp, &gui_port_func_0x1bbec50);
	sig_std_logic_connect_in(gui_port_0x1bbec70, cpssp, &gui_port_func_0x1bbec70);
	sig_std_logic_connect_in(gui_port_0x1bbec90, cpssp, &gui_port_func_0x1bbec90);
	sig_std_logic_connect_in(gui_port_0x1bbecb0, cpssp, &gui_port_func_0x1bbecb0);
	sig_std_logic_connect_in(gui_port_0x1bbecd0, cpssp, &gui_port_func_0x1bbecd0);
	sig_std_logic_connect_in(gui_port_0x1bbecf0, cpssp, &gui_port_func_0x1bbecf0);
	sig_std_logic_connect_in(gui_port_0x1bbed10, cpssp, &gui_port_func_0x1bbed10);
	sig_std_logic_connect_in(gui_port_0x1bbed30, cpssp, &gui_port_func_0x1bbed30);
	sig_std_logic_connect_in(gui_port_0x1bbed50, cpssp, &gui_port_func_0x1bbed50);
	sig_std_logic_connect_in(gui_port_0x1bbed70, cpssp, &gui_port_func_0x1bbed70);
	sig_std_logic_connect_in(gui_port_0x1bbed90, cpssp, &gui_port_func_0x1bbed90);
	sig_std_logic_connect_in(gui_port_0x1bbedb0, cpssp, &gui_port_func_0x1bbedb0);
	sig_std_logic_connect_in(gui_port_0x1bbedd0, cpssp, &gui_port_func_0x1bbedd0);
	sig_std_logic_connect_in(gui_port_0x1bbedf0, cpssp, &gui_port_func_0x1bbedf0);
	sig_std_logic_connect_in(gui_port_0x1bbee10, cpssp, &gui_port_func_0x1bbee10);
	sig_std_logic_connect_in(gui_port_0x1bbee30, cpssp, &gui_port_func_0x1bbee30);
	sig_std_logic_connect_in(gui_port_0x1bbee50, cpssp, &gui_port_func_0x1bbee50);
	sig_std_logic_connect_in(gui_port_0x1bbee70, cpssp, &gui_port_func_0x1bbee70);
	sig_std_logic_connect_in(gui_port_0x1bbee90, cpssp, &gui_port_func_0x1bbee90);
	sig_std_logic_connect_in(gui_port_0x1bbeeb0, cpssp, &gui_port_func_0x1bbeeb0);
	sig_std_logic_connect_in(gui_port_0x1bbeed0, cpssp, &gui_port_func_0x1bbeed0);
	sig_std_logic_connect_in(gui_port_0x1bbeef0, cpssp, &gui_port_func_0x1bbeef0);
	sig_std_logic_connect_in(gui_port_0x1bbef10, cpssp, &gui_port_func_0x1bbef10);
	sig_std_logic_connect_in(gui_port_0x1bbef30, cpssp, &gui_port_func_0x1bbef30);
	sig_std_logic_connect_in(gui_port_0x1bbef50, cpssp, &gui_port_func_0x1bbef50);
	sig_std_logic_connect_in(gui_port_0x1bbef70, cpssp, &gui_port_func_0x1bbef70);
	sig_std_logic_connect_in(gui_port_0x1bbef90, cpssp, &gui_port_func_0x1bbef90);
	sig_std_logic_connect_in(gui_port_0x1bbefb0, cpssp, &gui_port_func_0x1bbefb0);
	sig_std_logic_connect_in(gui_port_0x1bbefd0, cpssp, &gui_port_func_0x1bbefd0);
	sig_std_logic_connect_in(gui_port_0x1bbeff0, cpssp, &gui_port_func_0x1bbeff0);
	sig_std_logic_connect_in(gui_port_0x1bbf010, cpssp, &gui_port_func_0x1bbf010);
	sig_std_logic_connect_in(gui_port_0x1bbf030, cpssp, &gui_port_func_0x1bbf030);
	sig_std_logic_connect_in(gui_port_0x1bbf050, cpssp, &gui_port_func_0x1bbf050);
	sig_std_logic_connect_in(gui_port_0x1bbf070, cpssp, &gui_port_func_0x1bbf070);
	sig_std_logic_connect_in(gui_port_0x1bbf090, cpssp, &gui_port_func_0x1bbf090);
	sig_std_logic_connect_in(gui_port_0x1bbf0b0, cpssp, &gui_port_func_0x1bbf0b0);
	sig_std_logic_connect_in(gui_port_0x1bbf0d0, cpssp, &gui_port_func_0x1bbf0d0);
	sig_std_logic_connect_in(gui_port_0x1bbf0f0, cpssp, &gui_port_func_0x1bbf0f0);
	sig_std_logic_connect_in(gui_port_0x1bbf110, cpssp, &gui_port_func_0x1bbf110);
	sig_std_logic_connect_in(gui_port_0x1bbf130, cpssp, &gui_port_func_0x1bbf130);
	sig_std_logic_connect_in(gui_port_0x1bbf150, cpssp, &gui_port_func_0x1bbf150);
	sig_std_logic_connect_in(gui_port_0x1bbf170, cpssp, &gui_port_func_0x1bbf170);
	sig_std_logic_connect_in(gui_port_0x1bbf190, cpssp, &gui_port_func_0x1bbf190);
	sig_std_logic_connect_in(gui_port_0x1bbf1b0, cpssp, &gui_port_func_0x1bbf1b0);
	sig_std_logic_connect_in(gui_port_0x1bbf1d0, cpssp, &gui_port_func_0x1bbf1d0);
	sig_std_logic_connect_in(gui_port_0x1bbf1f0, cpssp, &gui_port_func_0x1bbf1f0);
	sig_std_logic_connect_in(gui_port_0x1bbf210, cpssp, &gui_port_func_0x1bbf210);
	sig_std_logic_connect_in(gui_port_0x1bbf230, cpssp, &gui_port_func_0x1bbf230);
	sig_std_logic_connect_in(gui_port_0x1bbf250, cpssp, &gui_port_func_0x1bbf250);
	sig_std_logic_connect_in(gui_port_0x1bbf270, cpssp, &gui_port_func_0x1bbf270);
	sig_std_logic_connect_in(gui_port_0x1bbf290, cpssp, &gui_port_func_0x1bbf290);
	sig_std_logic_connect_in(gui_port_0x1bbf2b0, cpssp, &gui_port_func_0x1bbf2b0);
	sig_std_logic_connect_in(gui_port_0x1bbf2d0, cpssp, &gui_port_func_0x1bbf2d0);
	sig_std_logic_connect_in(gui_port_0x1bbf2f0, cpssp, &gui_port_func_0x1bbf2f0);
	sig_std_logic_connect_in(gui_port_0x1bbf310, cpssp, &gui_port_func_0x1bbf310);
	sig_std_logic_connect_in(gui_port_0x1bbf330, cpssp, &gui_port_func_0x1bbf330);
	sig_std_logic_connect_in(gui_port_0x1bbf350, cpssp, &gui_port_func_0x1bbf350);
	sig_std_logic_connect_in(gui_port_0x1bbf370, cpssp, &gui_port_func_0x1bbf370);
	sig_std_logic_connect_in(gui_port_0x1bbf390, cpssp, &gui_port_func_0x1bbf390);
	sig_std_logic_connect_in(gui_port_0x1bbf3b0, cpssp, &gui_port_func_0x1bbf3b0);
	sig_std_logic_connect_in(gui_port_0x1bbf3d0, cpssp, &gui_port_func_0x1bbf3d0);
	sig_std_logic_connect_in(gui_port_0x1bbf3f0, cpssp, &gui_port_func_0x1bbf3f0);
	sig_std_logic_connect_in(gui_port_0x1bbf410, cpssp, &gui_port_func_0x1bbf410);
	sig_std_logic_connect_in(gui_port_0x1bbf430, cpssp, &gui_port_func_0x1bbf430);
	sig_std_logic_connect_in(gui_port_0x1bbf450, cpssp, &gui_port_func_0x1bbf450);
	sig_std_logic_connect_in(gui_port_0x1bbf470, cpssp, &gui_port_func_0x1bbf470);
	sig_std_logic_connect_in(gui_port_0x1bbf490, cpssp, &gui_port_func_0x1bbf490);
	sig_std_logic_connect_in(gui_port_0x1bbf4b0, cpssp, &gui_port_func_0x1bbf4b0);
	sig_std_logic_connect_in(gui_port_0x1bbf4d0, cpssp, &gui_port_func_0x1bbf4d0);
	sig_std_logic_connect_in(gui_port_0x1bbf4f0, cpssp, &gui_port_func_0x1bbf4f0);
	sig_std_logic_connect_in(gui_port_0x1bbf510, cpssp, &gui_port_func_0x1bbf510);
	sig_std_logic_connect_in(gui_port_0x1bbf530, cpssp, &gui_port_func_0x1bbf530);
	sig_std_logic_connect_in(gui_port_0x1bbf550, cpssp, &gui_port_func_0x1bbf550);
	sig_std_logic_connect_in(gui_port_0x1bbf570, cpssp, &gui_port_func_0x1bbf570);
	sig_std_logic_connect_in(gui_port_0x1bbf590, cpssp, &gui_port_func_0x1bbf590);
	sig_std_logic_connect_in(gui_port_0x1bbf5b0, cpssp, &gui_port_func_0x1bbf5b0);
	sig_std_logic_connect_in(gui_port_0x1bbf5d0, cpssp, &gui_port_func_0x1bbf5d0);
	sig_std_logic_connect_in(gui_port_0x1bbf5f0, cpssp, &gui_port_func_0x1bbf5f0);
	sig_std_logic_connect_in(gui_port_0x1bbf610, cpssp, &gui_port_func_0x1bbf610);
	sig_std_logic_connect_in(gui_port_0x1bbf630, cpssp, &gui_port_func_0x1bbf630);
	sig_std_logic_connect_in(gui_port_0x1bbf650, cpssp, &gui_port_func_0x1bbf650);
	sig_std_logic_connect_in(gui_port_0x1bbf670, cpssp, &gui_port_func_0x1bbf670);
	sig_std_logic_connect_in(gui_port_0x1bbf690, cpssp, &gui_port_func_0x1bbf690);
	sig_std_logic_connect_in(gui_port_0x1bbf6b0, cpssp, &gui_port_func_0x1bbf6b0);
	sig_std_logic_connect_in(gui_port_0x1bbf6d0, cpssp, &gui_port_func_0x1bbf6d0);
	sig_std_logic_connect_in(gui_port_0x1bbf6f0, cpssp, &gui_port_func_0x1bbf6f0);
	sig_std_logic_connect_in(gui_port_0x1bbf710, cpssp, &gui_port_func_0x1bbf710);
	sig_std_logic_connect_in(gui_port_0x1bbf730, cpssp, &gui_port_func_0x1bbf730);
	sig_std_logic_connect_in(gui_port_0x1bbf750, cpssp, &gui_port_func_0x1bbf750);
	sig_std_logic_connect_in(gui_port_0x1bc05f0, cpssp, &gui_port_func_0x1bc05f0);
	sig_std_logic_connect_in(gui_port_0x1bc0740, cpssp, &gui_port_func_0x1bc0740);
	sig_std_logic_connect_in(gui_port_0x1bc0890, cpssp, &gui_port_func_0x1bc0890);
	sig_std_logic_connect_in(gui_port_0x1bc09e0, cpssp, &gui_port_func_0x1bc09e0);
	sig_std_logic_connect_in(gui_port_0x1bc0b30, cpssp, &gui_port_func_0x1bc0b30);
	sig_std_logic_connect_in(gui_port_0x1bc0c80, cpssp, &gui_port_func_0x1bc0c80);
	sig_std_logic_connect_in(gui_port_0x1bc0dd0, cpssp, &gui_port_func_0x1bc0dd0);
	sig_std_logic_connect_in(gui_port_0x1bc0f20, cpssp, &gui_port_func_0x1bc0f20);
	sig_std_logic_connect_in(gui_port_0x1bc1070, cpssp, &gui_port_func_0x1bc1070);
	sig_std_logic_connect_in(gui_port_0x1bc11c0, cpssp, &gui_port_func_0x1bc11c0);
	sig_std_logic_connect_in(gui_port_0x1bc1310, cpssp, &gui_port_func_0x1bc1310);
	sig_std_logic_connect_in(gui_port_0x1bc1460, cpssp, &gui_port_func_0x1bc1460);
	sig_std_logic_connect_in(gui_port_0x1bc15b0, cpssp, &gui_port_func_0x1bc15b0);
	sig_std_logic_connect_in(gui_port_0x1bc1700, cpssp, &gui_port_func_0x1bc1700);
	sig_std_logic_connect_in(gui_port_0x1bc1850, cpssp, &gui_port_func_0x1bc1850);
	sig_std_logic_connect_in(gui_port_0x1bc19a0, cpssp, &gui_port_func_0x1bc19a0);
	sig_std_logic_connect_in(gui_port_0x1bc1af0, cpssp, &gui_port_func_0x1bc1af0);
	sig_std_logic_connect_in(gui_port_0x1bc1c40, cpssp, &gui_port_func_0x1bc1c40);
	sig_std_logic_connect_in(gui_port_0x1bc1d90, cpssp, &gui_port_func_0x1bc1d90);
	sig_std_logic_connect_in(gui_port_0x1bc1ee0, cpssp, &gui_port_func_0x1bc1ee0);
	sig_std_logic_connect_in(gui_port_0x1bc2030, cpssp, &gui_port_func_0x1bc2030);
	sig_std_logic_connect_in(gui_port_0x1bc2180, cpssp, &gui_port_func_0x1bc2180);
	sig_std_logic_connect_in(gui_port_0x1bc22d0, cpssp, &gui_port_func_0x1bc22d0);
	sig_std_logic_connect_in(gui_port_0x1bc2420, cpssp, &gui_port_func_0x1bc2420);
	sig_std_logic_connect_in(gui_port_0x1bc2570, cpssp, &gui_port_func_0x1bc2570);
	sig_std_logic_connect_in(gui_port_0x1bc26c0, cpssp, &gui_port_func_0x1bc26c0);
	sig_std_logic_connect_in(gui_port_0x1bc2810, cpssp, &gui_port_func_0x1bc2810);
	sig_std_logic_connect_in(gui_port_0x1bc2960, cpssp, &gui_port_func_0x1bc2960);
	sig_std_logic_connect_in(gui_port_0x1bc2ab0, cpssp, &gui_port_func_0x1bc2ab0);
	sig_std_logic_connect_in(gui_port_0x1bc2c00, cpssp, &gui_port_func_0x1bc2c00);
	sig_std_logic_connect_in(gui_port_0x1bc2d50, cpssp, &gui_port_func_0x1bc2d50);
	sig_std_logic_connect_in(gui_port_0x1bc2ea0, cpssp, &gui_port_func_0x1bc2ea0);
	sig_std_logic_connect_in(gui_port_0x1bc2ff0, cpssp, &gui_port_func_0x1bc2ff0);
	sig_std_logic_connect_in(gui_port_0x1bc3140, cpssp, &gui_port_func_0x1bc3140);
	sig_std_logic_connect_in(gui_port_0x1bc3290, cpssp, &gui_port_func_0x1bc3290);
	sig_std_logic_connect_in(gui_port_0x1bc33e0, cpssp, &gui_port_func_0x1bc33e0);
	sig_std_logic_connect_in(gui_port_0x1bc3530, cpssp, &gui_port_func_0x1bc3530);
	sig_std_logic_connect_in(gui_port_0x1bc3680, cpssp, &gui_port_func_0x1bc3680);
	sig_std_logic_connect_in(gui_port_0x1bc37d0, cpssp, &gui_port_func_0x1bc37d0);
	sig_std_logic_connect_in(gui_port_0x1bc3920, cpssp, &gui_port_func_0x1bc3920);
	sig_std_logic_connect_in(gui_port_0x1bc3a70, cpssp, &gui_port_func_0x1bc3a70);
	sig_std_logic_connect_in(gui_port_0x1bc3bc0, cpssp, &gui_port_func_0x1bc3bc0);
	sig_std_logic_connect_in(gui_port_0x1bc3d10, cpssp, &gui_port_func_0x1bc3d10);
	sig_std_logic_connect_in(gui_port_0x1bc3e60, cpssp, &gui_port_func_0x1bc3e60);
	sig_std_logic_connect_in(gui_port_0x1bc3fb0, cpssp, &gui_port_func_0x1bc3fb0);
	sig_std_logic_connect_in(gui_port_0x1bc4100, cpssp, &gui_port_func_0x1bc4100);
	sig_std_logic_connect_in(gui_port_0x1bc4250, cpssp, &gui_port_func_0x1bc4250);
	sig_std_logic_connect_in(gui_port_0x1bc43a0, cpssp, &gui_port_func_0x1bc43a0);
	sig_std_logic_connect_in(gui_port_0x1bc44f0, cpssp, &gui_port_func_0x1bc44f0);
	sig_std_logic_connect_in(gui_port_0x1bc4640, cpssp, &gui_port_func_0x1bc4640);
	sig_std_logic_connect_in(gui_port_0x1bc4790, cpssp, &gui_port_func_0x1bc4790);
	sig_std_logic_connect_in(gui_port_0x1bc48e0, cpssp, &gui_port_func_0x1bc48e0);
	sig_std_logic_connect_in(gui_port_0x1bc4a30, cpssp, &gui_port_func_0x1bc4a30);
	sig_std_logic_connect_in(gui_port_0x1bc4b80, cpssp, &gui_port_func_0x1bc4b80);
	sig_std_logic_connect_in(gui_port_0x1bc4cd0, cpssp, &gui_port_func_0x1bc4cd0);
	sig_std_logic_connect_in(gui_port_0x1bc4e20, cpssp, &gui_port_func_0x1bc4e20);
	sig_std_logic_connect_in(gui_port_0x1bc4f70, cpssp, &gui_port_func_0x1bc4f70);
	sig_std_logic_connect_in(gui_port_0x1bc50c0, cpssp, &gui_port_func_0x1bc50c0);
	sig_std_logic_connect_in(gui_port_0x1bc5210, cpssp, &gui_port_func_0x1bc5210);
	sig_std_logic_connect_in(gui_port_0x1bc5360, cpssp, &gui_port_func_0x1bc5360);
	sig_std_logic_connect_in(gui_port_0x1bc54b0, cpssp, &gui_port_func_0x1bc54b0);
	sig_std_logic_connect_in(gui_port_0x1bc5600, cpssp, &gui_port_func_0x1bc5600);
	sig_std_logic_connect_in(gui_port_0x1bc5750, cpssp, &gui_port_func_0x1bc5750);
	sig_std_logic_connect_in(gui_port_0x1bc58a0, cpssp, &gui_port_func_0x1bc58a0);
	sig_std_logic_connect_in(gui_port_0x1bc59f0, cpssp, &gui_port_func_0x1bc59f0);
	sig_std_logic_connect_in(gui_port_0x1bc5b40, cpssp, &gui_port_func_0x1bc5b40);
	sig_std_logic_connect_in(gui_port_0x1bc5c90, cpssp, &gui_port_func_0x1bc5c90);
	sig_std_logic_connect_in(gui_port_0x1bc5de0, cpssp, &gui_port_func_0x1bc5de0);
	sig_std_logic_connect_in(gui_port_0x1bc5f30, cpssp, &gui_port_func_0x1bc5f30);
	sig_std_logic_connect_in(gui_port_0x1bc6080, cpssp, &gui_port_func_0x1bc6080);
	sig_std_logic_connect_in(gui_port_0x1bc61d0, cpssp, &gui_port_func_0x1bc61d0);
	sig_std_logic_connect_in(gui_port_0x1bc6320, cpssp, &gui_port_func_0x1bc6320);
	sig_std_logic_connect_in(gui_port_0x1bc6470, cpssp, &gui_port_func_0x1bc6470);
	sig_std_logic_connect_in(gui_port_0x1bc65c0, cpssp, &gui_port_func_0x1bc65c0);
	sig_std_logic_connect_in(gui_port_0x1bc6710, cpssp, &gui_port_func_0x1bc6710);
	sig_std_logic_connect_in(gui_port_0x1bc6860, cpssp, &gui_port_func_0x1bc6860);
	sig_std_logic_connect_in(gui_port_0x1bc69b0, cpssp, &gui_port_func_0x1bc69b0);
	sig_std_logic_connect_in(gui_port_0x1bc6b00, cpssp, &gui_port_func_0x1bc6b00);
	sig_std_logic_connect_in(gui_port_0x1bc6c50, cpssp, &gui_port_func_0x1bc6c50);
	sig_std_logic_connect_in(gui_port_0x1bc6da0, cpssp, &gui_port_func_0x1bc6da0);
	sig_std_logic_connect_in(gui_port_0x1bc6ef0, cpssp, &gui_port_func_0x1bc6ef0);
	sig_std_logic_connect_in(gui_port_0x1bc7040, cpssp, &gui_port_func_0x1bc7040);
	sig_std_logic_connect_in(gui_port_0x1bc7190, cpssp, &gui_port_func_0x1bc7190);
	sig_std_logic_connect_in(gui_port_0x1bc72e0, cpssp, &gui_port_func_0x1bc72e0);
	sig_std_logic_connect_in(gui_port_0x1bc7430, cpssp, &gui_port_func_0x1bc7430);
	sig_std_logic_connect_in(gui_port_0x1bc7580, cpssp, &gui_port_func_0x1bc7580);
	sig_std_logic_connect_in(gui_port_0x1bc76d0, cpssp, &gui_port_func_0x1bc76d0);
	sig_std_logic_connect_in(gui_port_0x1bc7820, cpssp, &gui_port_func_0x1bc7820);
	sig_std_logic_connect_in(gui_port_0x1bc7970, cpssp, &gui_port_func_0x1bc7970);
	sig_std_logic_connect_in(gui_port_0x1bc7ac0, cpssp, &gui_port_func_0x1bc7ac0);
	sig_std_logic_connect_in(gui_port_0x1bc7c10, cpssp, &gui_port_func_0x1bc7c10);
	sig_std_logic_connect_in(gui_port_0x1bc7d60, cpssp, &gui_port_func_0x1bc7d60);
	sig_std_logic_connect_in(gui_port_0x1bc7eb0, cpssp, &gui_port_func_0x1bc7eb0);
	sig_std_logic_connect_in(gui_port_0x1bc8000, cpssp, &gui_port_func_0x1bc8000);
	sig_std_logic_connect_in(gui_port_0x1bc8150, cpssp, &gui_port_func_0x1bc8150);
	sig_std_logic_connect_in(gui_port_0x1bc82a0, cpssp, &gui_port_func_0x1bc82a0);
	sig_std_logic_connect_in(gui_port_0x1bc83f0, cpssp, &gui_port_func_0x1bc83f0);
	sig_std_logic_connect_in(gui_port_0x1bc8540, cpssp, &gui_port_func_0x1bc8540);
	sig_std_logic_connect_in(gui_port_0x1bc8690, cpssp, &gui_port_func_0x1bc8690);
	sig_std_logic_connect_in(gui_port_0x1bc87e0, cpssp, &gui_port_func_0x1bc87e0);
	sig_std_logic_connect_in(gui_port_0x1bc8930, cpssp, &gui_port_func_0x1bc8930);
	sig_std_logic_connect_in(gui_port_0x1bc8a80, cpssp, &gui_port_func_0x1bc8a80);
	sig_std_logic_connect_in(gui_port_0x1bc8bd0, cpssp, &gui_port_func_0x1bc8bd0);
	sig_std_logic_connect_in(gui_port_0x1bc8d20, cpssp, &gui_port_func_0x1bc8d20);
	sig_std_logic_connect_in(gui_port_0x1bc8e70, cpssp, &gui_port_func_0x1bc8e70);
	sig_std_logic_connect_in(gui_port_0x1bc8fc0, cpssp, &gui_port_func_0x1bc8fc0);
	sig_std_logic_connect_in(gui_port_0x1bb6b50, cpssp, &gui_port_func_0x1bb6b50);
	sig_std_logic_connect_in(gui_port_0x1bb8250, cpssp, &gui_port_func_0x1bb8250);
	sig_std_logic_connect_in(gui_port_0x1bb82b0, cpssp, &gui_port_func_0x1bb82b0);
	sig_std_logic_connect_in(gui_port_0x1bc91c0, cpssp, &gui_port_func_0x1bc91c0);
	sig_std_logic_connect_in(gui_port_0x1bc9310, cpssp, &gui_port_func_0x1bc9310);
	sig_std_logic_connect_in(gui_port_0x1bc9460, cpssp, &gui_port_func_0x1bc9460);
	sig_std_logic_connect_in(gui_port_0x1bc95b0, cpssp, &gui_port_func_0x1bc95b0);
	sig_std_logic_connect_in(gui_port_0x1bc9700, cpssp, &gui_port_func_0x1bc9700);
	sig_std_logic_connect_in(gui_port_0x1bc9850, cpssp, &gui_port_func_0x1bc9850);
	sig_std_logic_connect_in(gui_port_0x1bc99a0, cpssp, &gui_port_func_0x1bc99a0);
	sig_std_logic_connect_in(gui_port_0x1bc9af0, cpssp, &gui_port_func_0x1bc9af0);
	sig_std_logic_connect_in(gui_port_0x1bc9c40, cpssp, &gui_port_func_0x1bc9c40);
	sig_std_logic_connect_in(gui_port_0x1bc9d90, cpssp, &gui_port_func_0x1bc9d90);
	sig_std_logic_connect_in(gui_port_0x1bc9ee0, cpssp, &gui_port_func_0x1bc9ee0);
	sig_std_logic_connect_in(gui_port_0x1bca030, cpssp, &gui_port_func_0x1bca030);
	sig_std_logic_connect_in(gui_port_0x1bca180, cpssp, &gui_port_func_0x1bca180);
	sig_std_logic_connect_in(gui_port_0x1bca2d0, cpssp, &gui_port_func_0x1bca2d0);
	sig_std_logic_connect_in(gui_port_0x1bca420, cpssp, &gui_port_func_0x1bca420);
	sig_std_logic_connect_in(gui_port_0x1bca570, cpssp, &gui_port_func_0x1bca570);
	sig_std_logic_connect_in(gui_port_0x1bca6c0, cpssp, &gui_port_func_0x1bca6c0);
	sig_std_logic_connect_in(gui_port_0x1bca810, cpssp, &gui_port_func_0x1bca810);
	sig_std_logic_connect_in(gui_port_0x1bca960, cpssp, &gui_port_func_0x1bca960);
	sig_std_logic_connect_in(gui_port_0x1bcaab0, cpssp, &gui_port_func_0x1bcaab0);
	sig_std_logic_connect_in(gui_port_0x1bcac00, cpssp, &gui_port_func_0x1bcac00);
	sig_std_logic_connect_in(gui_port_0x1bcad50, cpssp, &gui_port_func_0x1bcad50);
	sig_std_logic_connect_in(gui_port_0x1bcaea0, cpssp, &gui_port_func_0x1bcaea0);
	sig_std_logic_connect_in(gui_port_0x1bcaff0, cpssp, &gui_port_func_0x1bcaff0);
	sig_std_logic_connect_in(gui_port_0x1bcb140, cpssp, &gui_port_func_0x1bcb140);
	sig_std_logic_connect_in(gui_port_0x1bcb290, cpssp, &gui_port_func_0x1bcb290);
	sig_std_logic_connect_in(gui_port_0x1bcb3e0, cpssp, &gui_port_func_0x1bcb3e0);
	sig_std_logic_connect_in(gui_port_0x1bcb530, cpssp, &gui_port_func_0x1bcb530);
	sig_std_logic_connect_in(gui_port_0x1bcb680, cpssp, &gui_port_func_0x1bcb680);
	sig_std_logic_connect_in(gui_port_0x1bcb7d0, cpssp, &gui_port_func_0x1bcb7d0);
	sig_std_logic_connect_in(gui_port_0x1bcb920, cpssp, &gui_port_func_0x1bcb920);
	sig_std_logic_connect_in(gui_port_0x1bcba70, cpssp, &gui_port_func_0x1bcba70);
	sig_std_logic_connect_in(gui_port_0x1bcbbc0, cpssp, &gui_port_func_0x1bcbbc0);
	sig_std_logic_connect_in(gui_port_0x1bcbd10, cpssp, &gui_port_func_0x1bcbd10);
	sig_std_logic_connect_in(gui_port_0x1bcbe60, cpssp, &gui_port_func_0x1bcbe60);
	sig_std_logic_connect_in(gui_port_0x1bcbfb0, cpssp, &gui_port_func_0x1bcbfb0);
	sig_std_logic_connect_in(gui_port_0x1bcc100, cpssp, &gui_port_func_0x1bcc100);
	sig_std_logic_connect_in(gui_port_0x1bcc250, cpssp, &gui_port_func_0x1bcc250);
	sig_std_logic_connect_in(gui_port_0x1bcc3a0, cpssp, &gui_port_func_0x1bcc3a0);
	sig_std_logic_connect_in(gui_port_0x1bcc4f0, cpssp, &gui_port_func_0x1bcc4f0);
	sig_std_logic_connect_in(gui_port_0x1bcc640, cpssp, &gui_port_func_0x1bcc640);
	sig_std_logic_connect_in(gui_port_0x1bcc790, cpssp, &gui_port_func_0x1bcc790);
	sig_std_logic_connect_in(gui_port_0x1bcc8e0, cpssp, &gui_port_func_0x1bcc8e0);
	sig_std_logic_connect_in(gui_port_0x1bcca30, cpssp, &gui_port_func_0x1bcca30);
	sig_std_logic_connect_in(gui_port_0x1bccb80, cpssp, &gui_port_func_0x1bccb80);
	sig_std_logic_connect_in(gui_port_0x1bcccd0, cpssp, &gui_port_func_0x1bcccd0);
	sig_std_logic_connect_in(gui_port_0x1bcce20, cpssp, &gui_port_func_0x1bcce20);
	sig_std_logic_connect_in(gui_port_0x1bccf70, cpssp, &gui_port_func_0x1bccf70);
	sig_std_logic_connect_in(gui_port_0x1bcd0c0, cpssp, &gui_port_func_0x1bcd0c0);
	sig_std_logic_connect_in(gui_port_0x1bcd210, cpssp, &gui_port_func_0x1bcd210);
	sig_std_logic_connect_in(gui_port_0x1bcd360, cpssp, &gui_port_func_0x1bcd360);
	sig_std_logic_connect_in(gui_port_0x1bcd4b0, cpssp, &gui_port_func_0x1bcd4b0);
	sig_std_logic_connect_in(gui_port_0x1bcd600, cpssp, &gui_port_func_0x1bcd600);
	sig_std_logic_connect_in(gui_port_0x1bcd750, cpssp, &gui_port_func_0x1bcd750);
	sig_std_logic_connect_in(gui_port_0x1bcd8a0, cpssp, &gui_port_func_0x1bcd8a0);
	sig_std_logic_connect_in(gui_port_0x1bcd9f0, cpssp, &gui_port_func_0x1bcd9f0);
	sig_std_logic_connect_in(gui_port_0x1bcdb40, cpssp, &gui_port_func_0x1bcdb40);
	sig_std_logic_connect_in(gui_port_0x1bcdc90, cpssp, &gui_port_func_0x1bcdc90);
	sig_std_logic_connect_in(gui_port_0x1bcdde0, cpssp, &gui_port_func_0x1bcdde0);
	sig_std_logic_connect_in(gui_port_0x1bcdf30, cpssp, &gui_port_func_0x1bcdf30);
	sig_std_logic_connect_in(gui_port_0x1bce080, cpssp, &gui_port_func_0x1bce080);
	sig_std_logic_connect_in(gui_port_0x1bce1d0, cpssp, &gui_port_func_0x1bce1d0);
	sig_std_logic_connect_in(gui_port_0x1bce320, cpssp, &gui_port_func_0x1bce320);
	sig_std_logic_connect_in(gui_port_0x1bce470, cpssp, &gui_port_func_0x1bce470);
	sig_std_logic_connect_in(gui_port_0x1bce5c0, cpssp, &gui_port_func_0x1bce5c0);
	sig_std_logic_connect_in(gui_port_0x1bce710, cpssp, &gui_port_func_0x1bce710);
	sig_std_logic_connect_in(gui_port_0x1bce860, cpssp, &gui_port_func_0x1bce860);
	sig_std_logic_connect_in(gui_port_0x1bce9b0, cpssp, &gui_port_func_0x1bce9b0);
	sig_std_logic_connect_in(gui_port_0x1bceb00, cpssp, &gui_port_func_0x1bceb00);
	sig_std_logic_connect_in(gui_port_0x1bcec50, cpssp, &gui_port_func_0x1bcec50);
	sig_std_logic_connect_in(gui_port_0x1bceda0, cpssp, &gui_port_func_0x1bceda0);
	sig_std_logic_connect_in(gui_port_0x1bceef0, cpssp, &gui_port_func_0x1bceef0);
	sig_std_logic_connect_in(gui_port_0x1bcf040, cpssp, &gui_port_func_0x1bcf040);
	sig_std_logic_connect_in(gui_port_0x1bcf190, cpssp, &gui_port_func_0x1bcf190);
	sig_std_logic_connect_in(gui_port_0x1bcf2e0, cpssp, &gui_port_func_0x1bcf2e0);
	sig_std_logic_connect_in(gui_port_0x1bcf430, cpssp, &gui_port_func_0x1bcf430);
	sig_std_logic_connect_in(gui_port_0x1bcf580, cpssp, &gui_port_func_0x1bcf580);
	sig_std_logic_connect_in(gui_port_0x1bcf6d0, cpssp, &gui_port_func_0x1bcf6d0);
	sig_std_logic_connect_in(gui_port_0x1bcf820, cpssp, &gui_port_func_0x1bcf820);
	sig_std_logic_connect_in(gui_port_0x1bcf970, cpssp, &gui_port_func_0x1bcf970);
	sig_std_logic_connect_in(gui_port_0x1bcfac0, cpssp, &gui_port_func_0x1bcfac0);
	sig_std_logic_connect_in(gui_port_0x1bcfc10, cpssp, &gui_port_func_0x1bcfc10);
	sig_std_logic_connect_in(gui_port_0x1bcfd60, cpssp, &gui_port_func_0x1bcfd60);
	sig_std_logic_connect_in(gui_port_0x1bcfeb0, cpssp, &gui_port_func_0x1bcfeb0);

	refresh_monitor((void *) cpssp);

	return cpssp;
}
void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
