/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */
#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "zusetest.h"

#define COMP_(x)		zusetest_ ## x
#define DEBUG 1
#if DEBUG
static void
printlogic(unsigned int val)
{
	char c;

	switch (val) {
	case SIG_STD_LOGIC_U: c = 'U'; break;
	case SIG_STD_LOGIC_X: c = 'X'; break;
	case SIG_STD_LOGIC_0: c = '0'; break;
	case SIG_STD_LOGIC_1: c = '1'; break;
	case SIG_STD_LOGIC_Z: c = 'Z'; break;
	case SIG_STD_LOGIC_W: c = 'W'; break;
	case SIG_STD_LOGIC_L: c = 'L'; break;
	case SIG_STD_LOGIC_H: c = 'H'; break;
	default: c = '?'; break;
};

	fprintf(stderr, "%c\n", c);
}
#endif /* DEBUG */

struct cpssp {
/* pins */
	unsigned int pin_20AII_5;
	unsigned int pin_20AII_7;
	unsigned int pin_6AI_4;
	unsigned int pin_6AI_3;
	unsigned int pin_6AII_03;
	unsigned int pin_6AII_6;
	unsigned int pin_6AIII_7;
	unsigned int pin_6AIII_06;
	unsigned int pin_6AIV_11;
	unsigned int pin_6AIV_013;
	unsigned int pin_32BIV_013;
	unsigned int pin_32BIV_11;
	unsigned int pin_32BIII_06;
	unsigned int pin_32BIII_7;
	unsigned int pin_16AI_4;
	unsigned int pin_16AI_3;
	unsigned int pin_16AII_03;
	unsigned int pin_16AII_6;
	unsigned int pin_16AIII_06;
	unsigned int pin_16AIII_7;
	unsigned int pin_16AIV_013;
	unsigned int pin_16AIV_11;
	unsigned int pin_17AI_11;
	unsigned int pin_17AI_13;
	unsigned int pin_17AI_14;
	unsigned int pin_17AI_15;
	unsigned int pin_17AI_12;
	unsigned int pin_18AI_14;
	unsigned int pin_18AI_10;
	unsigned int pin_18AI_12;
	unsigned int pin_18AI_11;
	unsigned int pin_18AI_15;
	unsigned int pin_19A_4;
	unsigned int pin_19A_5;
	unsigned int pin_19A_8;
	unsigned int pin_19A_13;
	unsigned int pin_19A_6;
	unsigned int pin_19A_7;
	unsigned int pin_19A_9;
	unsigned int pin_19A_10;
	unsigned int pin_19A_11;
	unsigned int pin_19A_12;
	unsigned int pin_19A_14;
	unsigned int pin_19A_15;
	unsigned int pin_5A_9;
	unsigned int pin_5A_4;
	unsigned int pin_5A_5;
	unsigned int pin_5A_12;
	unsigned int pin_5A_8;
	unsigned int pin_5A_14;
	unsigned int pin_5A_6;
	unsigned int pin_5A_7;
	unsigned int pin_5A_10;
	unsigned int pin_5A_11;
	unsigned int pin_5A_13;
	unsigned int pin_5A_15;
	unsigned int pin_22AVIII_015;
	unsigned int pin_22AVIII_014;
	unsigned int pin_22AVIII_013;
	unsigned int pin_22AVII_15;
	unsigned int pin_22AVII_14;
	unsigned int pin_22AVII_13;
	unsigned int pin_22AVI_012;
	unsigned int pin_22AVI_011;
	unsigned int pin_22AVI_010;
	unsigned int pin_22AV_11;
	unsigned int pin_22AV_12;
	unsigned int pin_22AV_10;
	unsigned int pin_22AIV_09;
	unsigned int pin_22AIV_08;
	unsigned int pin_22AIV_07;
	unsigned int pin_22AIII_9;
	unsigned int pin_22AIII_8;
	unsigned int pin_22AIII_7;
	unsigned int pin_22AII_05;
	unsigned int pin_22AII_06;
	unsigned int pin_22AII_04;
	unsigned int pin_22AI_6;
	unsigned int pin_22AI_5;
	unsigned int pin_22AI_4;
	unsigned int pin_21AVIII_015;
	unsigned int pin_21AVIII_014;
	unsigned int pin_21AVIII_013;
	unsigned int pin_21AVII_15;
	unsigned int pin_21AVII_14;
	unsigned int pin_21AVII_13;
	unsigned int pin_21AV_12;
	unsigned int pin_21AV_11;
	unsigned int pin_21AV_10;
	unsigned int pin_21AIII_8;
	unsigned int pin_21AIII_9;
	unsigned int pin_21AIII_7;
	unsigned int pin_21AII_06;
	unsigned int pin_21AII_05;
	unsigned int pin_21AII_04;
	unsigned int pin_21AI_6;
	unsigned int pin_21AI_5;
	unsigned int pin_21AI_4;
	unsigned int pin_31AIV_10;
	unsigned int pin_31AIV_9;
	unsigned int pin_31AIII_8;
	unsigned int pin_31AIII_7;
	unsigned int pin_31AII_6;
	unsigned int pin_31AII_5;
	unsigned int pin_31AI_4;
	unsigned int pin_31AI_3;
	unsigned int pin_30AVI_15;
	unsigned int pin_30AVI_13;
	unsigned int pin_30AV_12;
	unsigned int pin_30AV_11;
	unsigned int pin_30AIV_10;
	unsigned int pin_30AIV_9;
	unsigned int pin_30AIII_8;
	unsigned int pin_30AIII_7;
	unsigned int pin_30AII_5;
	unsigned int pin_30AII_6;
	unsigned int pin_30AI_4;
	unsigned int pin_30AI_3;
	unsigned int pin_29AVI_15;
	unsigned int pin_29AVI_13;
	unsigned int pin_29AV_12;
	unsigned int pin_29AV_11;
	unsigned int pin_29AIV_10;
	unsigned int pin_29AIV_9;
	unsigned int pin_29AIII_8;
	unsigned int pin_29AIII_7;
	unsigned int pin_29AII_5;
	unsigned int pin_29AII_6;
	unsigned int pin_29AI_4;
	unsigned int pin_29AI_3;
	unsigned int pin_12AI_11;
	unsigned int pin_12AI_13;
	unsigned int pin_12AI_14;
	unsigned int pin_12AI_12;
	unsigned int pin_12AI_15;
	unsigned int pin_17AII_8;
	unsigned int pin_17AII_3;
	unsigned int pin_17AII_5;
	unsigned int pin_17AII_4;
	unsigned int pin_17AII_7;
	unsigned int pin_12AII_8;
	unsigned int pin_12AII_5;
	unsigned int pin_12AII_3;
	unsigned int pin_12AII_4;
	unsigned int pin_12AII_7;
	unsigned int pin_15AII_011;
	unsigned int pin_15AII_12;
	unsigned int pin_15AII_13;
	unsigned int pin_15AII_013;
	unsigned int pin_15AII_012;
	unsigned int pin_15AII_10;
	unsigned int pin_15AII_11;
	unsigned int pin_15AII_14;
	unsigned int pin_15AII_15;
	unsigned int pin_15AII_010;
	unsigned int pin_15AII_014;
	unsigned int pin_15AII_015;
	unsigned int pin_15AI_09;
	unsigned int pin_15AI_9;
	unsigned int pin_15AI_5;
	unsigned int pin_15AI_7;
	unsigned int pin_15AI_4;
	unsigned int pin_15AI_6;
	unsigned int pin_15AI_8;
	unsigned int pin_15AI_04;
	unsigned int pin_15AI_05;
	unsigned int pin_15AI_06;
	unsigned int pin_15AI_07;
	unsigned int pin_15AI_08;
	unsigned int pin_18AII_7;
	unsigned int pin_18AII_4;
	unsigned int pin_18AII_3;
	unsigned int pin_18AII_5;
	unsigned int pin_18AII_6;
	unsigned int pin_14A_15;
	unsigned int pin_14A_6;
	unsigned int pin_14A_8;
	unsigned int pin_14A_10;
	unsigned int pin_14A_4;
	unsigned int pin_14A_5;
	unsigned int pin_14A_7;
	unsigned int pin_14A_12;
	unsigned int pin_14A_13;
	unsigned int pin_14A_14;
	unsigned int pin_13A_5;
	unsigned int pin_13A_15;
	unsigned int pin_13A_10;
	unsigned int pin_13A_8;
	unsigned int pin_13A_4;
	unsigned int pin_13A_6;
	unsigned int pin_13A_7;
	unsigned int pin_13A_12;
	unsigned int pin_13A_13;
	unsigned int pin_13A_14;
	unsigned int pin_3A_5;
	unsigned int pin_3A_14;
	unsigned int pin_3A_9;
	unsigned int pin_3A_10;
	unsigned int pin_3A_7;
	unsigned int pin_3A_12;
	unsigned int pin_2A_14;
	unsigned int pin_2A_15;
	unsigned int pin_2A_13;
	unsigned int pin_2A_5;
	unsigned int pin_4A_11;
	unsigned int pin_4A_13;
	unsigned int pin_4A_7;
	unsigned int pin_23AII_14;
	unsigned int pin_23AII_13;
	unsigned int pin_23AII_12;
	unsigned int pin_24AIII_4;
	unsigned int pin_24AIII_5;
	unsigned int pin_24AIII_3;
	unsigned int pin_24AIII_6;
	unsigned int pin_24AII_14;
	unsigned int pin_24AII_13;
	unsigned int pin_24AII_12;
	unsigned int pin_24AI_9;
	unsigned int pin_24AI_10;
	unsigned int pin_24AI_8;
	unsigned int pin_25AIII_5;
	unsigned int pin_25AIII_4;
	unsigned int pin_25AIII_3;
	unsigned int pin_25AIII_6;
	unsigned int pin_25AII_13;
	unsigned int pin_25AII_14;
	unsigned int pin_25AII_12;
	unsigned int pin_25AI_10;
	unsigned int pin_25AI_9;
	unsigned int pin_25AI_8;
	unsigned int pin_26AIII_4;
	unsigned int pin_26AIII_5;
	unsigned int pin_26AIII_3;
	unsigned int pin_26AIII_6;
	unsigned int pin_26AII_13;
	unsigned int pin_26AII_14;
	unsigned int pin_26AII_12;
	unsigned int pin_26AI_10;
	unsigned int pin_26AI_9;
	unsigned int pin_26AI_8;
	unsigned int pin_27AIII_5;
	unsigned int pin_27AIII_4;
	unsigned int pin_27AIII_3;
	unsigned int pin_27AIII_6;
	unsigned int pin_27AII_13;
	unsigned int pin_27AII_14;
	unsigned int pin_27AII_12;
	unsigned int pin_27AI_10;
	unsigned int pin_27AI_9;
	unsigned int pin_27AI_8;
	unsigned int pin_28AIII_4;
	unsigned int pin_28AIII_5;
	unsigned int pin_28AIII_3;
	unsigned int pin_28AIII_6;
	unsigned int pin_28AII_13;
	unsigned int pin_28AII_14;
	unsigned int pin_28AII_12;
	unsigned int pin_28AI_10;
	unsigned int pin_28AI_9;
	unsigned int pin_28AI_8;
	unsigned int pin_21AVI_012;
	unsigned int pin_21AVI_011;
	unsigned int pin_21AVI_010;
	unsigned int pin_21AIV_08;
	unsigned int pin_21AIV_09;
	unsigned int pin_21AIV_07;
	unsigned int pin_S0_2;
	unsigned int pin_S0_1;
	unsigned int pin_S0_3;
	unsigned int pin_S0_4;
	unsigned int pin_S0_5;
	unsigned int pin_S0_6;
	unsigned int pin_S0_7;
	unsigned int pin_S0_8;
	unsigned int pin_S1_2;
	unsigned int pin_S1_1;
	unsigned int pin_S1_3;
	unsigned int pin_S1_4;
	unsigned int pin_S1_5;
	unsigned int pin_S1_6;
	unsigned int pin_S1_7;
	unsigned int pin_S1_8;
	unsigned int pin_S2_2;
	unsigned int pin_S2_1;
	unsigned int pin_S2_3;
	unsigned int pin_S2_4;
	unsigned int pin_S2_5;
	unsigned int pin_S2_6;
	unsigned int pin_S2_7;
	unsigned int pin_S2_8;
	unsigned int pin_S3_2;
	unsigned int pin_S3_1;
	unsigned int pin_S3_3;
	unsigned int pin_S3_4;
	unsigned int pin_S3_5;
	unsigned int pin_S3_6;
	unsigned int pin_S3_7;
	unsigned int pin_S3_8;
	unsigned int pin_S4_2;
	unsigned int pin_S4_1;
	unsigned int pin_S4_3;
	unsigned int pin_S4_4;
	unsigned int pin_S4_5;
	unsigned int pin_S4_6;
	unsigned int pin_S4_7;
	unsigned int pin_S4_8;
	unsigned int pin_S5_2;
	unsigned int pin_S5_1;
	unsigned int pin_S5_3;
	unsigned int pin_S5_4;
	unsigned int pin_S5_5;
	unsigned int pin_S5_6;
	unsigned int pin_S5_7;
	unsigned int pin_S5_8;
	unsigned int pin_S6_2;
	unsigned int pin_S6_1;
	unsigned int pin_S6_3;
	unsigned int pin_S6_4;
	unsigned int pin_S6_5;
	unsigned int pin_S6_6;
	unsigned int pin_S6_7;
	unsigned int pin_S6_8;
	unsigned int pin_S7_1;
	unsigned int pin_S7_2;
	unsigned int pin_S7_3;
	unsigned int pin_S7_4;
	unsigned int pin_S7_5;
	unsigned int pin_S7_6;
	unsigned int pin_S7_7;
	unsigned int pin_S7_8;
	unsigned int pin_S8_2;
	unsigned int pin_S8_1;
	unsigned int pin_S8_3;
	unsigned int pin_S8_4;
	unsigned int pin_S8_5;
	unsigned int pin_S8_6;
	unsigned int pin_S8_7;
	unsigned int pin_S8_8;
	unsigned int pin_S9_2;
	unsigned int pin_S9_1;
	unsigned int pin_S9_3;
	unsigned int pin_S9_4;
	unsigned int pin_S9_5;
	unsigned int pin_S9_6;
	unsigned int pin_S9_7;
	unsigned int pin_S9_8;
	unsigned int pin_S10_2;
	unsigned int pin_S10_1;
	unsigned int pin_S10_3;
	unsigned int pin_S10_4;
	unsigned int pin_S10_5;
	unsigned int pin_S10_6;
	unsigned int pin_S10_7;
	unsigned int pin_S10_8;
	unsigned int pin_S11_2;
	unsigned int pin_S11_1;
	unsigned int pin_S11_3;
	unsigned int pin_S11_4;
	unsigned int pin_S11_5;
	unsigned int pin_S11_6;
	unsigned int pin_S11_7;
	unsigned int pin_S11_8;
	unsigned int pin_S12_2;
	unsigned int pin_S12_1;
	unsigned int pin_S12_3;
	unsigned int pin_S12_4;
	unsigned int pin_S12_5;
	unsigned int pin_S12_6;
	unsigned int pin_S12_7;
	unsigned int pin_S12_8;
	unsigned int pin_S13_2;
	unsigned int pin_S13_1;
	unsigned int pin_S13_3;
	unsigned int pin_S13_4;
	unsigned int pin_S13_5;
	unsigned int pin_S13_6;
	unsigned int pin_S13_7;
	unsigned int pin_S13_8;
	unsigned int pin_S14_2;
	unsigned int pin_S14_1;
	unsigned int pin_S14_3;
	unsigned int pin_S14_4;
	unsigned int pin_S14_5;
	unsigned int pin_S14_6;
	unsigned int pin_S14_7;
	unsigned int pin_S14_8;
	unsigned int pin_S15_2;
	unsigned int pin_S15_1;
	unsigned int pin_S15_3;
	unsigned int pin_S15_4;
	unsigned int pin_S15_5;
	unsigned int pin_S15_6;
	unsigned int pin_S15_7;
	unsigned int pin_S15_8;
	unsigned int pin_15BI_10;
	unsigned int pin_15BI_12;
	unsigned int pin_15BI_14;
	unsigned int pin_15BI_11;
	unsigned int pin_15BI_15;
	unsigned int pin_16AVI_14;
	unsigned int pin_16AVI_15;
	unsigned int pin_6AV_13;
	unsigned int pin_6AV_015;
	unsigned int pin_16AV_13;
	unsigned int pin_16AV_015;
	unsigned int pin_17B_5;
	unsigned int pin_17B_4;
	unsigned int pin_17B_13;
	unsigned int pin_17B_15;
	unsigned int pin_17B_12;
	unsigned int pin_6AVI_14;
	unsigned int pin_6AVI_15;
	unsigned int pin_Uhr1;
	unsigned int pin_Uhr2;
	unsigned int pin_Imp1;
	unsigned int pin_Imp2;
	unsigned int pin_22I1;
	unsigned int pin_22I2;
	unsigned int pin_22I3;
	unsigned int pin_22I4;
	unsigned int pin_22I5;
	unsigned int pin_22I6;
	unsigned int pin_22I7;
	unsigned int pin_22I8;
	unsigned int pin_22I9;
	unsigned int pin_22I0;
	unsigned int pin_22II1;
	unsigned int pin_22II2;
	unsigned int pin_22II3;
	unsigned int pin_22II4;
	unsigned int pin_22II5;
	unsigned int pin_22II6;
	unsigned int pin_22II7;
	unsigned int pin_22II8;
	unsigned int pin_22II9;
	unsigned int pin_22II0;
	unsigned int pin_22III1;
	unsigned int pin_22III2;
	unsigned int pin_22III3;
	unsigned int pin_22III4;
	unsigned int pin_22III5;
	unsigned int pin_22III6;
	unsigned int pin_22III7;
	unsigned int pin_22III8;
	unsigned int pin_22III9;
	unsigned int pin_22III0;
	unsigned int pin_30I1;
	unsigned int pin_30I2;
	unsigned int pin_30I3;
	unsigned int pin_30I4;
	unsigned int pin_30I5;
	unsigned int pin_30I6;
	unsigned int pin_30I7;
	unsigned int pin_30I8;
	unsigned int pin_30I9;
	unsigned int pin_30I0;
	unsigned int pin_30II1;
	unsigned int pin_30II2;
	unsigned int pin_30II3;
	unsigned int pin_30II4;
	unsigned int pin_30II5;
	unsigned int pin_30II6;
	unsigned int pin_30II7;
	unsigned int pin_30II8;
	unsigned int pin_30II9;
	unsigned int pin_30II0;
	unsigned int pin_30III1;
	unsigned int pin_30III2;
	unsigned int pin_30III3;
	unsigned int pin_30III4;
	unsigned int pin_30III5;
	unsigned int pin_30III6;
	unsigned int pin_30III7;
	unsigned int pin_30III8;
	unsigned int pin_30III9;
	unsigned int pin_30III0;
/* elements */
#define STATE
#define NAME xml2c_20AII
#define NAME_(x)		xml2c_20AII_ ## x
#include "zuse_Ts333II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_6AI
#define NAME_(x)		xml2c_6AI_ ## x
#include "zuse_Ts701I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_6AII
#define NAME_(x)		xml2c_6AII_ ## x
#include "zuse_Ts701II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_6AIII
#define NAME_(x)		xml2c_6AIII_ ## x
#include "zuse_Ts701III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_6AIV
#define NAME_(x)		xml2c_6AIV_ ## x
#include "zuse_Ts701IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_32BIV
#define NAME_(x)		xml2c_32BIV_ ## x
#include "zuse_Ts701IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_32BIII
#define NAME_(x)		xml2c_32BIII_ ## x
#include "zuse_Ts701III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_16AI
#define NAME_(x)		xml2c_16AI_ ## x
#include "zuse_Ts701I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_16AII
#define NAME_(x)		xml2c_16AII_ ## x
#include "zuse_Ts701II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_16AIII
#define NAME_(x)		xml2c_16AIII_ ## x
#include "zuse_Ts701III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_16AIV
#define NAME_(x)		xml2c_16AIV_ ## x
#include "zuse_Ts701IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_17AI
#define NAME_(x)		xml2c_17AI_ ## x
#include "zuse_Ts235I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_18AI
#define NAME_(x)		xml2c_18AI_ ## x
#include "zuse_Ts230I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_19A
#define NAME_(x)		xml2c_19A_ ## x
#include "zuse_Ts100.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_5A
#define NAME_(x)		xml2c_5A_ ## x
#include "zuse_Ts100.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AVIII
#define NAME_(x)		xml2c_22AVIII_ ## x
#include "zuse_Ts560VIII.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AVII
#define NAME_(x)		xml2c_22AVII_ ## x
#include "zuse_Ts560VII.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AVI
#define NAME_(x)		xml2c_22AVI_ ## x
#include "zuse_Ts560VI.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AV
#define NAME_(x)		xml2c_22AV_ ## x
#include "zuse_Ts560V.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AIV
#define NAME_(x)		xml2c_22AIV_ ## x
#include "zuse_Ts560IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AIII
#define NAME_(x)		xml2c_22AIII_ ## x
#include "zuse_Ts560III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AII
#define NAME_(x)		xml2c_22AII_ ## x
#include "zuse_Ts560II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_22AI
#define NAME_(x)		xml2c_22AI_ ## x
#include "zuse_Ts560I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AVIII
#define NAME_(x)		xml2c_21AVIII_ ## x
#include "zuse_Ts560VIII.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AVII
#define NAME_(x)		xml2c_21AVII_ ## x
#include "zuse_Ts560VII.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AV
#define NAME_(x)		xml2c_21AV_ ## x
#include "zuse_Ts560V.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AIII
#define NAME_(x)		xml2c_21AIII_ ## x
#include "zuse_Ts560III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AII
#define NAME_(x)		xml2c_21AII_ ## x
#include "zuse_Ts560II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AI
#define NAME_(x)		xml2c_21AI_ ## x
#include "zuse_Ts560I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_31AIV
#define NAME_(x)		xml2c_31AIV_ ## x
#include "zuse_Ts500IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_31AIII
#define NAME_(x)		xml2c_31AIII_ ## x
#include "zuse_Ts500III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_31AII
#define NAME_(x)		xml2c_31AII_ ## x
#include "zuse_Ts500II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_31AI
#define NAME_(x)		xml2c_31AI_ ## x
#include "zuse_Ts500I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_30AVI
#define NAME_(x)		xml2c_30AVI_ ## x
#include "zuse_Ts500VI.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_30AV
#define NAME_(x)		xml2c_30AV_ ## x
#include "zuse_Ts500V.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_30AIV
#define NAME_(x)		xml2c_30AIV_ ## x
#include "zuse_Ts500IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_30AIII
#define NAME_(x)		xml2c_30AIII_ ## x
#include "zuse_Ts500III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_30AII
#define NAME_(x)		xml2c_30AII_ ## x
#include "zuse_Ts500II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_30AI
#define NAME_(x)		xml2c_30AI_ ## x
#include "zuse_Ts500I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_29AVI
#define NAME_(x)		xml2c_29AVI_ ## x
#include "zuse_Ts500VI.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_29AV
#define NAME_(x)		xml2c_29AV_ ## x
#include "zuse_Ts500V.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_29AIV
#define NAME_(x)		xml2c_29AIV_ ## x
#include "zuse_Ts500IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_29AIII
#define NAME_(x)		xml2c_29AIII_ ## x
#include "zuse_Ts500III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_29AII
#define NAME_(x)		xml2c_29AII_ ## x
#include "zuse_Ts500II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_29AI
#define NAME_(x)		xml2c_29AI_ ## x
#include "zuse_Ts500I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_12AI
#define NAME_(x)		xml2c_12AI_ ## x
#include "zuse_Ts235I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_17AII
#define NAME_(x)		xml2c_17AII_ ## x
#include "zuse_Ts235II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_12AII
#define NAME_(x)		xml2c_12AII_ ## x
#include "zuse_Ts235II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_15AII
#define NAME_(x)		xml2c_15AII_ ## x
#include "zuse_Ts101II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_15AI
#define NAME_(x)		xml2c_15AI_ ## x
#include "zuse_Ts101I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_18AII
#define NAME_(x)		xml2c_18AII_ ## x
#include "zuse_Ts230II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_14A
#define NAME_(x)		xml2c_14A_ ## x
#include "zuse_Ts106.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_13A
#define NAME_(x)		xml2c_13A_ ## x
#include "zuse_Ts106.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_3A
#define NAME_(x)		xml2c_3A_ ## x
#include "zuse_Ts630.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_2A
#define NAME_(x)		xml2c_2A_ ## x
#include "zuse_Ts600.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_4A
#define NAME_(x)		xml2c_4A_ ## x
#include "zuse_Ts601.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_23AII
#define NAME_(x)		xml2c_23AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_24AIII
#define NAME_(x)		xml2c_24AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_24AII
#define NAME_(x)		xml2c_24AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_24AI
#define NAME_(x)		xml2c_24AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_25AIII
#define NAME_(x)		xml2c_25AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_25AII
#define NAME_(x)		xml2c_25AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_25AI
#define NAME_(x)		xml2c_25AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_26AIII
#define NAME_(x)		xml2c_26AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_26AII
#define NAME_(x)		xml2c_26AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_26AI
#define NAME_(x)		xml2c_26AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_27AIII
#define NAME_(x)		xml2c_27AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_27AII
#define NAME_(x)		xml2c_27AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_27AI
#define NAME_(x)		xml2c_27AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_28AIII
#define NAME_(x)		xml2c_28AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_28AII
#define NAME_(x)		xml2c_28AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_28AI
#define NAME_(x)		xml2c_28AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AVI
#define NAME_(x)		xml2c_21AVI_ ## x
#include "zuse_Ts560VI.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_21AIV
#define NAME_(x)		xml2c_21AIV_ ## x
#include "zuse_Ts560IV.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S0
#define NAME_(x)		xml2c_S0_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S1
#define NAME_(x)		xml2c_S1_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S2
#define NAME_(x)		xml2c_S2_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S3
#define NAME_(x)		xml2c_S3_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S4
#define NAME_(x)		xml2c_S4_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S5
#define NAME_(x)		xml2c_S5_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S6
#define NAME_(x)		xml2c_S6_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S7
#define NAME_(x)		xml2c_S7_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S8
#define NAME_(x)		xml2c_S8_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S9
#define NAME_(x)		xml2c_S9_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S10
#define NAME_(x)		xml2c_S10_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S11
#define NAME_(x)		xml2c_S11_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S12
#define NAME_(x)		xml2c_S12_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S13
#define NAME_(x)		xml2c_S13_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S14
#define NAME_(x)		xml2c_S14_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_S15
#define NAME_(x)		xml2c_S15_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_15BI
#define NAME_(x)		xml2c_15BI_ ## x
#include "zuse_Ts230I.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_16AVI
#define NAME_(x)		xml2c_16AVI_ ## x
#include "zuse_Ts701VI.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_6AV
#define NAME_(x)		xml2c_6AV_ ## x
#include "zuse_Ts701V.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_16AV
#define NAME_(x)		xml2c_16AV_ ## x
#include "zuse_Ts701V.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_17B
#define NAME_(x)		xml2c_17B_ ## x
#include "zuse_Ts632.c"
#undef NAME
#undef NAME_
#undef STATE

#define STATE
#define NAME xml2c_6AVI
#define NAME_(x)		xml2c_6AVI_ ## x
#include "zuse_Ts701VIH.c"
#undef NAME
#undef NAME_
#undef STATE

/* ports */
	struct sig_std_logic *port_Uhr1;
	struct sig_std_logic *port_Uhr2;
	struct sig_std_logic *port_Imp1;
	struct sig_std_logic *port_Imp2;
	struct sig_std_logic *port_22I1;
	struct sig_std_logic *port_22I2;
	struct sig_std_logic *port_22I3;
	struct sig_std_logic *port_22I4;
	struct sig_std_logic *port_22I5;
	struct sig_std_logic *port_22I6;
	struct sig_std_logic *port_22I7;
	struct sig_std_logic *port_22I8;
	struct sig_std_logic *port_22I9;
	struct sig_std_logic *port_22I0;
	struct sig_std_logic *port_22II1;
	struct sig_std_logic *port_22II2;
	struct sig_std_logic *port_22II3;
	struct sig_std_logic *port_22II4;
	struct sig_std_logic *port_22II5;
	struct sig_std_logic *port_22II6;
	struct sig_std_logic *port_22II7;
	struct sig_std_logic *port_22II8;
	struct sig_std_logic *port_22II9;
	struct sig_std_logic *port_22II0;
	struct sig_std_logic *port_22III1;
	struct sig_std_logic *port_22III2;
	struct sig_std_logic *port_22III3;
	struct sig_std_logic *port_22III4;
	struct sig_std_logic *port_22III5;
	struct sig_std_logic *port_22III6;
	struct sig_std_logic *port_22III7;
	struct sig_std_logic *port_22III8;
	struct sig_std_logic *port_22III9;
	struct sig_std_logic *port_22III0;
	struct sig_std_logic *port_30I1;
	struct sig_std_logic *port_30I2;
	struct sig_std_logic *port_30I3;
	struct sig_std_logic *port_30I4;
	struct sig_std_logic *port_30I5;
	struct sig_std_logic *port_30I6;
	struct sig_std_logic *port_30I7;
	struct sig_std_logic *port_30I8;
	struct sig_std_logic *port_30I9;
	struct sig_std_logic *port_30I0;
	struct sig_std_logic *port_30II1;
	struct sig_std_logic *port_30II2;
	struct sig_std_logic *port_30II3;
	struct sig_std_logic *port_30II4;
	struct sig_std_logic *port_30II5;
	struct sig_std_logic *port_30II6;
	struct sig_std_logic *port_30II7;
	struct sig_std_logic *port_30II8;
	struct sig_std_logic *port_30II9;
	struct sig_std_logic *port_30II0;
	struct sig_std_logic *port_30III1;
	struct sig_std_logic *port_30III2;
	struct sig_std_logic *port_30III3;
	struct sig_std_logic *port_30III4;
	struct sig_std_logic *port_30III5;
	struct sig_std_logic *port_30III6;
	struct sig_std_logic *port_30III7;
	struct sig_std_logic *port_30III8;
	struct sig_std_logic *port_30III9;
	struct sig_std_logic *port_30III0;
	struct sig_std_logic *gui_port_0x1bb8760;
	struct sig_std_logic *gui_port_0x1bb9650;
	struct sig_std_logic *gui_port_0x1bb9630;
	struct sig_std_logic *gui_port_0x1bb69a0;
	struct sig_std_logic *gui_port_0x1bb82f0;
	struct sig_std_logic *gui_port_0x1bb81b0;
	struct sig_std_logic *gui_port_0x1bb8f00;
	struct sig_std_logic *gui_port_0x1bb3b20;
	struct sig_std_logic *gui_port_0x1bb6a40;
	struct sig_std_logic *gui_port_0x1bb8550;
	struct sig_std_logic *gui_port_0x1bb6980;
	struct sig_std_logic *gui_port_0x1bb8190;
	struct sig_std_logic *gui_port_0x1bb6640;
	struct sig_std_logic *gui_port_0x1bbe9b0;
	struct sig_std_logic *gui_port_0x1bbe9d0;
	struct sig_std_logic *gui_port_0x1bbe9f0;
	struct sig_std_logic *gui_port_0x1bbea10;
	struct sig_std_logic *gui_port_0x1bbea30;
	struct sig_std_logic *gui_port_0x1bbea50;
	struct sig_std_logic *gui_port_0x1bbea70;
	struct sig_std_logic *gui_port_0x1bbea90;
	struct sig_std_logic *gui_port_0x1bbeab0;
	struct sig_std_logic *gui_port_0x1bbead0;
	struct sig_std_logic *gui_port_0x1bbeaf0;
	struct sig_std_logic *gui_port_0x1bbeb10;
	struct sig_std_logic *gui_port_0x1bbeb30;
	struct sig_std_logic *gui_port_0x1bbeb50;
	struct sig_std_logic *gui_port_0x1bbeb70;
	struct sig_std_logic *gui_port_0x1bbeb90;
	struct sig_std_logic *gui_port_0x1bbebb0;
	struct sig_std_logic *gui_port_0x1bbebd0;
	struct sig_std_logic *gui_port_0x1bbebf0;
	struct sig_std_logic *gui_port_0x1bbec10;
	struct sig_std_logic *gui_port_0x1bbec30;
	struct sig_std_logic *gui_port_0x1bbec50;
	struct sig_std_logic *gui_port_0x1bbec70;
	struct sig_std_logic *gui_port_0x1bbec90;
	struct sig_std_logic *gui_port_0x1bbecb0;
	struct sig_std_logic *gui_port_0x1bbecd0;
	struct sig_std_logic *gui_port_0x1bbecf0;
	struct sig_std_logic *gui_port_0x1bbed10;
	struct sig_std_logic *gui_port_0x1bbed30;
	struct sig_std_logic *gui_port_0x1bbed50;
	struct sig_std_logic *gui_port_0x1bbed70;
	struct sig_std_logic *gui_port_0x1bbed90;
	struct sig_std_logic *gui_port_0x1bbedb0;
	struct sig_std_logic *gui_port_0x1bbedd0;
	struct sig_std_logic *gui_port_0x1bbedf0;
	struct sig_std_logic *gui_port_0x1bbee10;
	struct sig_std_logic *gui_port_0x1bbee30;
	struct sig_std_logic *gui_port_0x1bbee50;
	struct sig_std_logic *gui_port_0x1bbee70;
	struct sig_std_logic *gui_port_0x1bbee90;
	struct sig_std_logic *gui_port_0x1bbeeb0;
	struct sig_std_logic *gui_port_0x1bbeed0;
	struct sig_std_logic *gui_port_0x1bbeef0;
	struct sig_std_logic *gui_port_0x1bbef10;
	struct sig_std_logic *gui_port_0x1bbef30;
	struct sig_std_logic *gui_port_0x1bbef50;
	struct sig_std_logic *gui_port_0x1bbef70;
	struct sig_std_logic *gui_port_0x1bbef90;
	struct sig_std_logic *gui_port_0x1bbefb0;
	struct sig_std_logic *gui_port_0x1bbefd0;
	struct sig_std_logic *gui_port_0x1bbeff0;
	struct sig_std_logic *gui_port_0x1bbf010;
	struct sig_std_logic *gui_port_0x1bbf030;
	struct sig_std_logic *gui_port_0x1bbf050;
	struct sig_std_logic *gui_port_0x1bbf070;
	struct sig_std_logic *gui_port_0x1bbf090;
	struct sig_std_logic *gui_port_0x1bbf0b0;
	struct sig_std_logic *gui_port_0x1bbf0d0;
	struct sig_std_logic *gui_port_0x1bbf0f0;
	struct sig_std_logic *gui_port_0x1bbf110;
	struct sig_std_logic *gui_port_0x1bbf130;
	struct sig_std_logic *gui_port_0x1bbf150;
	struct sig_std_logic *gui_port_0x1bbf170;
	struct sig_std_logic *gui_port_0x1bbf190;
	struct sig_std_logic *gui_port_0x1bbf1b0;
	struct sig_std_logic *gui_port_0x1bbf1d0;
	struct sig_std_logic *gui_port_0x1bbf1f0;
	struct sig_std_logic *gui_port_0x1bbf210;
	struct sig_std_logic *gui_port_0x1bbf230;
	struct sig_std_logic *gui_port_0x1bbf250;
	struct sig_std_logic *gui_port_0x1bbf270;
	struct sig_std_logic *gui_port_0x1bbf290;
	struct sig_std_logic *gui_port_0x1bbf2b0;
	struct sig_std_logic *gui_port_0x1bbf2d0;
	struct sig_std_logic *gui_port_0x1bbf2f0;
	struct sig_std_logic *gui_port_0x1bbf310;
	struct sig_std_logic *gui_port_0x1bbf330;
	struct sig_std_logic *gui_port_0x1bbf350;
	struct sig_std_logic *gui_port_0x1bbf370;
	struct sig_std_logic *gui_port_0x1bbf390;
	struct sig_std_logic *gui_port_0x1bbf3b0;
	struct sig_std_logic *gui_port_0x1bbf3d0;
	struct sig_std_logic *gui_port_0x1bbf3f0;
	struct sig_std_logic *gui_port_0x1bbf410;
	struct sig_std_logic *gui_port_0x1bbf430;
	struct sig_std_logic *gui_port_0x1bbf450;
	struct sig_std_logic *gui_port_0x1bbf470;
	struct sig_std_logic *gui_port_0x1bbf490;
	struct sig_std_logic *gui_port_0x1bbf4b0;
	struct sig_std_logic *gui_port_0x1bbf4d0;
	struct sig_std_logic *gui_port_0x1bbf4f0;
	struct sig_std_logic *gui_port_0x1bbf510;
	struct sig_std_logic *gui_port_0x1bbf530;
	struct sig_std_logic *gui_port_0x1bbf550;
	struct sig_std_logic *gui_port_0x1bbf570;
	struct sig_std_logic *gui_port_0x1bbf590;
	struct sig_std_logic *gui_port_0x1bbf5b0;
	struct sig_std_logic *gui_port_0x1bbf5d0;
	struct sig_std_logic *gui_port_0x1bbf5f0;
	struct sig_std_logic *gui_port_0x1bbf610;
	struct sig_std_logic *gui_port_0x1bbf630;
	struct sig_std_logic *gui_port_0x1bbf650;
	struct sig_std_logic *gui_port_0x1bbf670;
	struct sig_std_logic *gui_port_0x1bbf690;
	struct sig_std_logic *gui_port_0x1bbf6b0;
	struct sig_std_logic *gui_port_0x1bbf6d0;
	struct sig_std_logic *gui_port_0x1bbf6f0;
	struct sig_std_logic *gui_port_0x1bbf710;
	struct sig_std_logic *gui_port_0x1bbf730;
	struct sig_std_logic *gui_port_0x1bbf750;
	struct sig_std_logic *gui_port_0x1bc05f0;
	struct sig_std_logic *gui_port_0x1bc0740;
	struct sig_std_logic *gui_port_0x1bc0890;
	struct sig_std_logic *gui_port_0x1bc09e0;
	struct sig_std_logic *gui_port_0x1bc0b30;
	struct sig_std_logic *gui_port_0x1bc0c80;
	struct sig_std_logic *gui_port_0x1bc0dd0;
	struct sig_std_logic *gui_port_0x1bc0f20;
	struct sig_std_logic *gui_port_0x1bc1070;
	struct sig_std_logic *gui_port_0x1bc11c0;
	struct sig_std_logic *gui_port_0x1bc1310;
	struct sig_std_logic *gui_port_0x1bc1460;
	struct sig_std_logic *gui_port_0x1bc15b0;
	struct sig_std_logic *gui_port_0x1bc1700;
	struct sig_std_logic *gui_port_0x1bc1850;
	struct sig_std_logic *gui_port_0x1bc19a0;
	struct sig_std_logic *gui_port_0x1bc1af0;
	struct sig_std_logic *gui_port_0x1bc1c40;
	struct sig_std_logic *gui_port_0x1bc1d90;
	struct sig_std_logic *gui_port_0x1bc1ee0;
	struct sig_std_logic *gui_port_0x1bc2030;
	struct sig_std_logic *gui_port_0x1bc2180;
	struct sig_std_logic *gui_port_0x1bc22d0;
	struct sig_std_logic *gui_port_0x1bc2420;
	struct sig_std_logic *gui_port_0x1bc2570;
	struct sig_std_logic *gui_port_0x1bc26c0;
	struct sig_std_logic *gui_port_0x1bc2810;
	struct sig_std_logic *gui_port_0x1bc2960;
	struct sig_std_logic *gui_port_0x1bc2ab0;
	struct sig_std_logic *gui_port_0x1bc2c00;
	struct sig_std_logic *gui_port_0x1bc2d50;
	struct sig_std_logic *gui_port_0x1bc2ea0;
	struct sig_std_logic *gui_port_0x1bc2ff0;
	struct sig_std_logic *gui_port_0x1bc3140;
	struct sig_std_logic *gui_port_0x1bc3290;
	struct sig_std_logic *gui_port_0x1bc33e0;
	struct sig_std_logic *gui_port_0x1bc3530;
	struct sig_std_logic *gui_port_0x1bc3680;
	struct sig_std_logic *gui_port_0x1bc37d0;
	struct sig_std_logic *gui_port_0x1bc3920;
	struct sig_std_logic *gui_port_0x1bc3a70;
	struct sig_std_logic *gui_port_0x1bc3bc0;
	struct sig_std_logic *gui_port_0x1bc3d10;
	struct sig_std_logic *gui_port_0x1bc3e60;
	struct sig_std_logic *gui_port_0x1bc3fb0;
	struct sig_std_logic *gui_port_0x1bc4100;
	struct sig_std_logic *gui_port_0x1bc4250;
	struct sig_std_logic *gui_port_0x1bc43a0;
	struct sig_std_logic *gui_port_0x1bc44f0;
	struct sig_std_logic *gui_port_0x1bc4640;
	struct sig_std_logic *gui_port_0x1bc4790;
	struct sig_std_logic *gui_port_0x1bc48e0;
	struct sig_std_logic *gui_port_0x1bc4a30;
	struct sig_std_logic *gui_port_0x1bc4b80;
	struct sig_std_logic *gui_port_0x1bc4cd0;
	struct sig_std_logic *gui_port_0x1bc4e20;
	struct sig_std_logic *gui_port_0x1bc4f70;
	struct sig_std_logic *gui_port_0x1bc50c0;
	struct sig_std_logic *gui_port_0x1bc5210;
	struct sig_std_logic *gui_port_0x1bc5360;
	struct sig_std_logic *gui_port_0x1bc54b0;
	struct sig_std_logic *gui_port_0x1bc5600;
	struct sig_std_logic *gui_port_0x1bc5750;
	struct sig_std_logic *gui_port_0x1bc58a0;
	struct sig_std_logic *gui_port_0x1bc59f0;
	struct sig_std_logic *gui_port_0x1bc5b40;
	struct sig_std_logic *gui_port_0x1bc5c90;
	struct sig_std_logic *gui_port_0x1bc5de0;
	struct sig_std_logic *gui_port_0x1bc5f30;
	struct sig_std_logic *gui_port_0x1bc6080;
	struct sig_std_logic *gui_port_0x1bc61d0;
	struct sig_std_logic *gui_port_0x1bc6320;
	struct sig_std_logic *gui_port_0x1bc6470;
	struct sig_std_logic *gui_port_0x1bc65c0;
	struct sig_std_logic *gui_port_0x1bc6710;
	struct sig_std_logic *gui_port_0x1bc6860;
	struct sig_std_logic *gui_port_0x1bc69b0;
	struct sig_std_logic *gui_port_0x1bc6b00;
	struct sig_std_logic *gui_port_0x1bc6c50;
	struct sig_std_logic *gui_port_0x1bc6da0;
	struct sig_std_logic *gui_port_0x1bc6ef0;
	struct sig_std_logic *gui_port_0x1bc7040;
	struct sig_std_logic *gui_port_0x1bc7190;
	struct sig_std_logic *gui_port_0x1bc72e0;
	struct sig_std_logic *gui_port_0x1bc7430;
	struct sig_std_logic *gui_port_0x1bc7580;
	struct sig_std_logic *gui_port_0x1bc76d0;
	struct sig_std_logic *gui_port_0x1bc7820;
	struct sig_std_logic *gui_port_0x1bc7970;
	struct sig_std_logic *gui_port_0x1bc7ac0;
	struct sig_std_logic *gui_port_0x1bc7c10;
	struct sig_std_logic *gui_port_0x1bc7d60;
	struct sig_std_logic *gui_port_0x1bc7eb0;
	struct sig_std_logic *gui_port_0x1bc8000;
	struct sig_std_logic *gui_port_0x1bc8150;
	struct sig_std_logic *gui_port_0x1bc82a0;
	struct sig_std_logic *gui_port_0x1bc83f0;
	struct sig_std_logic *gui_port_0x1bc8540;
	struct sig_std_logic *gui_port_0x1bc8690;
	struct sig_std_logic *gui_port_0x1bc87e0;
	struct sig_std_logic *gui_port_0x1bc8930;
	struct sig_std_logic *gui_port_0x1bc8a80;
	struct sig_std_logic *gui_port_0x1bc8bd0;
	struct sig_std_logic *gui_port_0x1bc8d20;
	struct sig_std_logic *gui_port_0x1bc8e70;
	struct sig_std_logic *gui_port_0x1bc8fc0;
	struct sig_std_logic *gui_port_0x1bb6b50;
	struct sig_std_logic *gui_port_0x1bb8250;
	struct sig_std_logic *gui_port_0x1bb82b0;
	struct sig_std_logic *gui_port_0x1bc91c0;
	struct sig_std_logic *gui_port_0x1bc9310;
	struct sig_std_logic *gui_port_0x1bc9460;
	struct sig_std_logic *gui_port_0x1bc95b0;
	struct sig_std_logic *gui_port_0x1bc9700;
	struct sig_std_logic *gui_port_0x1bc9850;
	struct sig_std_logic *gui_port_0x1bc99a0;
	struct sig_std_logic *gui_port_0x1bc9af0;
	struct sig_std_logic *gui_port_0x1bc9c40;
	struct sig_std_logic *gui_port_0x1bc9d90;
	struct sig_std_logic *gui_port_0x1bc9ee0;
	struct sig_std_logic *gui_port_0x1bca030;
	struct sig_std_logic *gui_port_0x1bca180;
	struct sig_std_logic *gui_port_0x1bca2d0;
	struct sig_std_logic *gui_port_0x1bca420;
	struct sig_std_logic *gui_port_0x1bca570;
	struct sig_std_logic *gui_port_0x1bca6c0;
	struct sig_std_logic *gui_port_0x1bca810;
	struct sig_std_logic *gui_port_0x1bca960;
	struct sig_std_logic *gui_port_0x1bcaab0;
	struct sig_std_logic *gui_port_0x1bcac00;
	struct sig_std_logic *gui_port_0x1bcad50;
	struct sig_std_logic *gui_port_0x1bcaea0;
	struct sig_std_logic *gui_port_0x1bcaff0;
	struct sig_std_logic *gui_port_0x1bcb140;
	struct sig_std_logic *gui_port_0x1bcb290;
	struct sig_std_logic *gui_port_0x1bcb3e0;
	struct sig_std_logic *gui_port_0x1bcb530;
	struct sig_std_logic *gui_port_0x1bcb680;
	struct sig_std_logic *gui_port_0x1bcb7d0;
	struct sig_std_logic *gui_port_0x1bcb920;
	struct sig_std_logic *gui_port_0x1bcba70;
	struct sig_std_logic *gui_port_0x1bcbbc0;
	struct sig_std_logic *gui_port_0x1bcbd10;
	struct sig_std_logic *gui_port_0x1bcbe60;
	struct sig_std_logic *gui_port_0x1bcbfb0;
	struct sig_std_logic *gui_port_0x1bcc100;
	struct sig_std_logic *gui_port_0x1bcc250;
	struct sig_std_logic *gui_port_0x1bcc3a0;
	struct sig_std_logic *gui_port_0x1bcc4f0;
	struct sig_std_logic *gui_port_0x1bcc640;
	struct sig_std_logic *gui_port_0x1bcc790;
	struct sig_std_logic *gui_port_0x1bcc8e0;
	struct sig_std_logic *gui_port_0x1bcca30;
	struct sig_std_logic *gui_port_0x1bccb80;
	struct sig_std_logic *gui_port_0x1bcccd0;
	struct sig_std_logic *gui_port_0x1bcce20;
	struct sig_std_logic *gui_port_0x1bccf70;
	struct sig_std_logic *gui_port_0x1bcd0c0;
	struct sig_std_logic *gui_port_0x1bcd210;
	struct sig_std_logic *gui_port_0x1bcd360;
	struct sig_std_logic *gui_port_0x1bcd4b0;
	struct sig_std_logic *gui_port_0x1bcd600;
	struct sig_std_logic *gui_port_0x1bcd750;
	struct sig_std_logic *gui_port_0x1bcd8a0;
	struct sig_std_logic *gui_port_0x1bcd9f0;
	struct sig_std_logic *gui_port_0x1bcdb40;
	struct sig_std_logic *gui_port_0x1bcdc90;
	struct sig_std_logic *gui_port_0x1bcdde0;
	struct sig_std_logic *gui_port_0x1bcdf30;
	struct sig_std_logic *gui_port_0x1bce080;
	struct sig_std_logic *gui_port_0x1bce1d0;
	struct sig_std_logic *gui_port_0x1bce320;
	struct sig_std_logic *gui_port_0x1bce470;
	struct sig_std_logic *gui_port_0x1bce5c0;
	struct sig_std_logic *gui_port_0x1bce710;
	struct sig_std_logic *gui_port_0x1bce860;
	struct sig_std_logic *gui_port_0x1bce9b0;
	struct sig_std_logic *gui_port_0x1bceb00;
	struct sig_std_logic *gui_port_0x1bcec50;
	struct sig_std_logic *gui_port_0x1bceda0;
	struct sig_std_logic *gui_port_0x1bceef0;
	struct sig_std_logic *gui_port_0x1bcf040;
	struct sig_std_logic *gui_port_0x1bcf190;
	struct sig_std_logic *gui_port_0x1bcf2e0;
	struct sig_std_logic *gui_port_0x1bcf430;
	struct sig_std_logic *gui_port_0x1bcf580;
	struct sig_std_logic *gui_port_0x1bcf6d0;
	struct sig_std_logic *gui_port_0x1bcf820;
	struct sig_std_logic *gui_port_0x1bcf970;
	struct sig_std_logic *gui_port_0x1bcfac0;
	struct sig_std_logic *gui_port_0x1bcfc10;
	struct sig_std_logic *gui_port_0x1bcfd60;
	struct sig_std_logic *gui_port_0x1bcfeb0;
};

static void xml2c_20AII_7_out_set(struct cpssp *, unsigned int);
static void xml2c_6AI_4_out_set(struct cpssp *, unsigned int);
static void xml2c_6AII_6_out_set(struct cpssp *, unsigned int);
static void xml2c_6AIII_06_out_set(struct cpssp *, unsigned int);
static void xml2c_6AIV_013_out_set(struct cpssp *, unsigned int);
static void xml2c_32BIV_013_out_set(struct cpssp *, unsigned int);
static void xml2c_32BIII_06_out_set(struct cpssp *, unsigned int);
static void xml2c_16AI_4_out_set(struct cpssp *, unsigned int);
static void xml2c_16AII_6_out_set(struct cpssp *, unsigned int);
static void xml2c_16AIII_06_out_set(struct cpssp *, unsigned int);
static void xml2c_16AIV_013_out_set(struct cpssp *, unsigned int);
static void xml2c_17AI_11_out_set(struct cpssp *, unsigned int);
static void xml2c_18AI_10_out_set(struct cpssp *, unsigned int);
static void xml2c_19A_4_out_set(struct cpssp *, unsigned int);
static void xml2c_19A_5_out_set(struct cpssp *, unsigned int);
static void xml2c_5A_4_out_set(struct cpssp *, unsigned int);
static void xml2c_5A_5_out_set(struct cpssp *, unsigned int);
static void xml2c_22AVIII_014_out_set(struct cpssp *, unsigned int);
static void xml2c_22AVII_14_out_set(struct cpssp *, unsigned int);
static void xml2c_22AVI_011_out_set(struct cpssp *, unsigned int);
static void xml2c_22AV_11_out_set(struct cpssp *, unsigned int);
static void xml2c_22AIV_08_out_set(struct cpssp *, unsigned int);
static void xml2c_22AIII_8_out_set(struct cpssp *, unsigned int);
static void xml2c_22AII_05_out_set(struct cpssp *, unsigned int);
static void xml2c_22AI_5_out_set(struct cpssp *, unsigned int);
static void xml2c_21AVIII_014_out_set(struct cpssp *, unsigned int);
static void xml2c_21AVII_14_out_set(struct cpssp *, unsigned int);
static void xml2c_21AV_11_out_set(struct cpssp *, unsigned int);
static void xml2c_21AIII_8_out_set(struct cpssp *, unsigned int);
static void xml2c_21AII_05_out_set(struct cpssp *, unsigned int);
static void xml2c_21AI_5_out_set(struct cpssp *, unsigned int);
static void xml2c_31AIV_9_out_set(struct cpssp *, unsigned int);
static void xml2c_31AIII_7_out_set(struct cpssp *, unsigned int);
static void xml2c_31AII_5_out_set(struct cpssp *, unsigned int);
static void xml2c_31AI_3_out_set(struct cpssp *, unsigned int);
static void xml2c_30AVI_13_out_set(struct cpssp *, unsigned int);
static void xml2c_30AV_11_out_set(struct cpssp *, unsigned int);
static void xml2c_30AIV_9_out_set(struct cpssp *, unsigned int);
static void xml2c_30AIII_7_out_set(struct cpssp *, unsigned int);
static void xml2c_30AII_5_out_set(struct cpssp *, unsigned int);
static void xml2c_30AI_3_out_set(struct cpssp *, unsigned int);
static void xml2c_29AVI_13_out_set(struct cpssp *, unsigned int);
static void xml2c_29AV_11_out_set(struct cpssp *, unsigned int);
static void xml2c_29AIV_9_out_set(struct cpssp *, unsigned int);
static void xml2c_29AIII_7_out_set(struct cpssp *, unsigned int);
static void xml2c_29AII_5_out_set(struct cpssp *, unsigned int);
static void xml2c_29AI_3_out_set(struct cpssp *, unsigned int);
static void xml2c_12AI_11_out_set(struct cpssp *, unsigned int);
static void xml2c_17AII_8_out_set(struct cpssp *, unsigned int);
static void xml2c_12AII_8_out_set(struct cpssp *, unsigned int);
static void xml2c_15AII_011_out_set(struct cpssp *, unsigned int);
static void xml2c_15AII_11_out_set(struct cpssp *, unsigned int);
static void xml2c_15AI_09_out_set(struct cpssp *, unsigned int);
static void xml2c_15AI_9_out_set(struct cpssp *, unsigned int);
static void xml2c_18AII_7_out_set(struct cpssp *, unsigned int);
static void xml2c_14A_6_out_set(struct cpssp *, unsigned int);
static void xml2c_14A_4_out_set(struct cpssp *, unsigned int);
static void xml2c_14A_5_out_set(struct cpssp *, unsigned int);
static void xml2c_14A_7_out_set(struct cpssp *, unsigned int);
static void xml2c_13A_5_out_set(struct cpssp *, unsigned int);
static void xml2c_13A_4_out_set(struct cpssp *, unsigned int);
static void xml2c_13A_6_out_set(struct cpssp *, unsigned int);
static void xml2c_13A_7_out_set(struct cpssp *, unsigned int);
static void xml2c_3A_9_out_set(struct cpssp *, unsigned int);
static void xml2c_3A_10_out_set(struct cpssp *, unsigned int);
static void xml2c_3A_7_out_set(struct cpssp *, unsigned int);
static void xml2c_3A_12_out_set(struct cpssp *, unsigned int);
static void xml2c_2A_13_out_set(struct cpssp *, unsigned int);
static void xml2c_2A_5_out_set(struct cpssp *, unsigned int);
static void xml2c_4A_7_out_set(struct cpssp *, unsigned int);
static void xml2c_23AII_12_out_set(struct cpssp *, unsigned int);
static void xml2c_24AIII_3_out_set(struct cpssp *, unsigned int);
static void xml2c_24AII_12_out_set(struct cpssp *, unsigned int);
static void xml2c_24AI_8_out_set(struct cpssp *, unsigned int);
static void xml2c_25AIII_3_out_set(struct cpssp *, unsigned int);
static void xml2c_25AII_12_out_set(struct cpssp *, unsigned int);
static void xml2c_25AI_8_out_set(struct cpssp *, unsigned int);
static void xml2c_26AIII_3_out_set(struct cpssp *, unsigned int);
static void xml2c_26AII_12_out_set(struct cpssp *, unsigned int);
static void xml2c_26AI_8_out_set(struct cpssp *, unsigned int);
static void xml2c_27AIII_3_out_set(struct cpssp *, unsigned int);
static void xml2c_27AII_12_out_set(struct cpssp *, unsigned int);
static void xml2c_27AI_8_out_set(struct cpssp *, unsigned int);
static void xml2c_28AIII_3_out_set(struct cpssp *, unsigned int);
static void xml2c_28AII_12_out_set(struct cpssp *, unsigned int);
static void xml2c_28AI_8_out_set(struct cpssp *, unsigned int);
static void xml2c_21AVI_011_out_set(struct cpssp *, unsigned int);
static void xml2c_21AIV_08_out_set(struct cpssp *, unsigned int);
static void xml2c_S0_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S0_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S0_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S0_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S1_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S1_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S1_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S1_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S2_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S2_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S2_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S2_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S3_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S3_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S3_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S3_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S4_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S4_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S4_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S4_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S5_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S5_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S5_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S5_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S6_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S6_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S6_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S6_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S7_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S7_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S7_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S7_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S8_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S8_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S8_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S8_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S9_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S9_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S9_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S9_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S10_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S10_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S10_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S10_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S11_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S11_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S11_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S11_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S12_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S12_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S12_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S12_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S13_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S13_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S13_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S13_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S14_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S14_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S14_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S14_8_out_set(struct cpssp *, unsigned int);
static void xml2c_S15_5_out_set(struct cpssp *, unsigned int);
static void xml2c_S15_6_out_set(struct cpssp *, unsigned int);
static void xml2c_S15_7_out_set(struct cpssp *, unsigned int);
static void xml2c_S15_8_out_set(struct cpssp *, unsigned int);
static void xml2c_15BI_10_out_set(struct cpssp *, unsigned int);
static void xml2c_16AVI_14_out_set(struct cpssp *, unsigned int);
static void xml2c_6AV_13_out_set(struct cpssp *, unsigned int);
static void xml2c_16AV_13_out_set(struct cpssp *, unsigned int);
static void xml2c_17B_5_out_set(struct cpssp *, unsigned int);
static void xml2c_17B_4_out_set(struct cpssp *, unsigned int);
static void xml2c_6AVI_14_out_set(struct cpssp *, unsigned int);

/* element update funcs */
#define BEHAVIOUR
#define NAME xml2c_20AII
#define NAME_(x)  xml2c_20AII_ ## x
#include "zuse_Ts333II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_6AI
#define NAME_(x)  xml2c_6AI_ ## x
#include "zuse_Ts701I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_6AII
#define NAME_(x)  xml2c_6AII_ ## x
#include "zuse_Ts701II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_6AIII
#define NAME_(x)  xml2c_6AIII_ ## x
#include "zuse_Ts701III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_6AIV
#define NAME_(x)  xml2c_6AIV_ ## x
#include "zuse_Ts701IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_32BIV
#define NAME_(x)  xml2c_32BIV_ ## x
#include "zuse_Ts701IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_32BIII
#define NAME_(x)  xml2c_32BIII_ ## x
#include "zuse_Ts701III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_16AI
#define NAME_(x)  xml2c_16AI_ ## x
#include "zuse_Ts701I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_16AII
#define NAME_(x)  xml2c_16AII_ ## x
#include "zuse_Ts701II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_16AIII
#define NAME_(x)  xml2c_16AIII_ ## x
#include "zuse_Ts701III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_16AIV
#define NAME_(x)  xml2c_16AIV_ ## x
#include "zuse_Ts701IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_17AI
#define NAME_(x)  xml2c_17AI_ ## x
#include "zuse_Ts235I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_18AI
#define NAME_(x)  xml2c_18AI_ ## x
#include "zuse_Ts230I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_19A
#define NAME_(x)  xml2c_19A_ ## x
#include "zuse_Ts100.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_5A
#define NAME_(x)  xml2c_5A_ ## x
#include "zuse_Ts100.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AVIII
#define NAME_(x)  xml2c_22AVIII_ ## x
#include "zuse_Ts560VIII.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AVII
#define NAME_(x)  xml2c_22AVII_ ## x
#include "zuse_Ts560VII.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AVI
#define NAME_(x)  xml2c_22AVI_ ## x
#include "zuse_Ts560VI.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AV
#define NAME_(x)  xml2c_22AV_ ## x
#include "zuse_Ts560V.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AIV
#define NAME_(x)  xml2c_22AIV_ ## x
#include "zuse_Ts560IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AIII
#define NAME_(x)  xml2c_22AIII_ ## x
#include "zuse_Ts560III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AII
#define NAME_(x)  xml2c_22AII_ ## x
#include "zuse_Ts560II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_22AI
#define NAME_(x)  xml2c_22AI_ ## x
#include "zuse_Ts560I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AVIII
#define NAME_(x)  xml2c_21AVIII_ ## x
#include "zuse_Ts560VIII.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AVII
#define NAME_(x)  xml2c_21AVII_ ## x
#include "zuse_Ts560VII.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AV
#define NAME_(x)  xml2c_21AV_ ## x
#include "zuse_Ts560V.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AIII
#define NAME_(x)  xml2c_21AIII_ ## x
#include "zuse_Ts560III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AII
#define NAME_(x)  xml2c_21AII_ ## x
#include "zuse_Ts560II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AI
#define NAME_(x)  xml2c_21AI_ ## x
#include "zuse_Ts560I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_31AIV
#define NAME_(x)  xml2c_31AIV_ ## x
#include "zuse_Ts500IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_31AIII
#define NAME_(x)  xml2c_31AIII_ ## x
#include "zuse_Ts500III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_31AII
#define NAME_(x)  xml2c_31AII_ ## x
#include "zuse_Ts500II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_31AI
#define NAME_(x)  xml2c_31AI_ ## x
#include "zuse_Ts500I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_30AVI
#define NAME_(x)  xml2c_30AVI_ ## x
#include "zuse_Ts500VI.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_30AV
#define NAME_(x)  xml2c_30AV_ ## x
#include "zuse_Ts500V.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_30AIV
#define NAME_(x)  xml2c_30AIV_ ## x
#include "zuse_Ts500IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_30AIII
#define NAME_(x)  xml2c_30AIII_ ## x
#include "zuse_Ts500III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_30AII
#define NAME_(x)  xml2c_30AII_ ## x
#include "zuse_Ts500II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_30AI
#define NAME_(x)  xml2c_30AI_ ## x
#include "zuse_Ts500I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_29AVI
#define NAME_(x)  xml2c_29AVI_ ## x
#include "zuse_Ts500VI.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_29AV
#define NAME_(x)  xml2c_29AV_ ## x
#include "zuse_Ts500V.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_29AIV
#define NAME_(x)  xml2c_29AIV_ ## x
#include "zuse_Ts500IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_29AIII
#define NAME_(x)  xml2c_29AIII_ ## x
#include "zuse_Ts500III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_29AII
#define NAME_(x)  xml2c_29AII_ ## x
#include "zuse_Ts500II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_29AI
#define NAME_(x)  xml2c_29AI_ ## x
#include "zuse_Ts500I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_12AI
#define NAME_(x)  xml2c_12AI_ ## x
#include "zuse_Ts235I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_17AII
#define NAME_(x)  xml2c_17AII_ ## x
#include "zuse_Ts235II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_12AII
#define NAME_(x)  xml2c_12AII_ ## x
#include "zuse_Ts235II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_15AII
#define NAME_(x)  xml2c_15AII_ ## x
#include "zuse_Ts101II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_15AI
#define NAME_(x)  xml2c_15AI_ ## x
#include "zuse_Ts101I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_18AII
#define NAME_(x)  xml2c_18AII_ ## x
#include "zuse_Ts230II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_14A
#define NAME_(x)  xml2c_14A_ ## x
#include "zuse_Ts106.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_13A
#define NAME_(x)  xml2c_13A_ ## x
#include "zuse_Ts106.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_3A
#define NAME_(x)  xml2c_3A_ ## x
#include "zuse_Ts630.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_2A
#define NAME_(x)  xml2c_2A_ ## x
#include "zuse_Ts600.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_4A
#define NAME_(x)  xml2c_4A_ ## x
#include "zuse_Ts601.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_23AII
#define NAME_(x)  xml2c_23AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_24AIII
#define NAME_(x)  xml2c_24AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_24AII
#define NAME_(x)  xml2c_24AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_24AI
#define NAME_(x)  xml2c_24AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_25AIII
#define NAME_(x)  xml2c_25AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_25AII
#define NAME_(x)  xml2c_25AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_25AI
#define NAME_(x)  xml2c_25AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_26AIII
#define NAME_(x)  xml2c_26AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_26AII
#define NAME_(x)  xml2c_26AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_26AI
#define NAME_(x)  xml2c_26AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_27AIII
#define NAME_(x)  xml2c_27AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_27AII
#define NAME_(x)  xml2c_27AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_27AI
#define NAME_(x)  xml2c_27AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_28AIII
#define NAME_(x)  xml2c_28AIII_ ## x
#include "zuse_Ts220III.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_28AII
#define NAME_(x)  xml2c_28AII_ ## x
#include "zuse_Ts220II.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_28AI
#define NAME_(x)  xml2c_28AI_ ## x
#include "zuse_Ts220I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AVI
#define NAME_(x)  xml2c_21AVI_ ## x
#include "zuse_Ts560VI.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_21AIV
#define NAME_(x)  xml2c_21AIV_ ## x
#include "zuse_Ts560IV.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S0
#define NAME_(x)  xml2c_S0_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S1
#define NAME_(x)  xml2c_S1_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S2
#define NAME_(x)  xml2c_S2_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S3
#define NAME_(x)  xml2c_S3_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S4
#define NAME_(x)  xml2c_S4_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S5
#define NAME_(x)  xml2c_S5_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S6
#define NAME_(x)  xml2c_S6_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S7
#define NAME_(x)  xml2c_S7_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S8
#define NAME_(x)  xml2c_S8_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S9
#define NAME_(x)  xml2c_S9_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S10
#define NAME_(x)  xml2c_S10_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S11
#define NAME_(x)  xml2c_S11_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S12
#define NAME_(x)  xml2c_S12_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S13
#define NAME_(x)  xml2c_S13_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S14
#define NAME_(x)  xml2c_S14_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_S15
#define NAME_(x)  xml2c_S15_ ## x
#include "zuse_switch.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_15BI
#define NAME_(x)  xml2c_15BI_ ## x
#include "zuse_Ts230I.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_16AVI
#define NAME_(x)  xml2c_16AVI_ ## x
#include "zuse_Ts701VI.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_6AV
#define NAME_(x)  xml2c_6AV_ ## x
#include "zuse_Ts701V.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_16AV
#define NAME_(x)  xml2c_16AV_ ## x
#include "zuse_Ts701V.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_17B
#define NAME_(x)  xml2c_17B_ ## x
#include "zuse_Ts632.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR

#define BEHAVIOUR
#define NAME xml2c_6AVI
#define NAME_(x)  xml2c_6AVI_ ## x
#include "zuse_Ts701VIH.c"
#undef NAME
#undef NAME_
#undef BEHAVIOUR


/* signal resolves */
static void
COMP_(resolve_sig_0x1bb8760)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II4);
	res = sig_std_logic_resolve(res, cpssp->pin_22II6);
	res = sig_std_logic_resolve(res, cpssp->pin_22II8);
	res = sig_std_logic_resolve(res, cpssp->pin_22II0);
	res = sig_std_logic_resolve(res, cpssp->pin_22III0);
	res = sig_std_logic_resolve(res, cpssp->pin_30II1);
	res = sig_std_logic_resolve(res, cpssp->pin_30II2);
	res = sig_std_logic_resolve(res, cpssp->pin_30II3);
	res = sig_std_logic_resolve(res, cpssp->pin_30II4);
	res = sig_std_logic_resolve(res, cpssp->pin_30II5);
	res = sig_std_logic_resolve(res, cpssp->pin_30II6);
	res = sig_std_logic_resolve(res, cpssp->pin_16AIII_06);
	res = sig_std_logic_resolve(res, cpssp->pin_17AI_11);
	res = sig_std_logic_resolve(res, cpssp->pin_16AVI_14);
	if(res != cpssp->pin_20AII_5) {
#if DEBUG
		fprintf(stderr, "pin 20AII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_20AII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
		xml2c_20AII_5_in_set(cpssp, res);
	}
	if(res != cpssp->pin_16AI_3) {
#if DEBUG
		fprintf(stderr, "pin 16AI_3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_16AI_3 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
		xml2c_16AI_3_in_set(cpssp, res);
	}
	if(res != cpssp->pin_16AII_03) {
#if DEBUG
		fprintf(stderr, "pin 16AII_03 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_16AII_03 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
		xml2c_16AII_03_in_set(cpssp, res);
	}
	if(res != cpssp->pin_18AI_14) {
#if DEBUG
		fprintf(stderr, "pin 18AI_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_18AI_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
		xml2c_18AI_14_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S0_2) {
#if DEBUG
		fprintf(stderr, "pin S0_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S0_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
		xml2c_S0_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S1_2) {
#if DEBUG
		fprintf(stderr, "pin S1_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S1_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
		xml2c_S1_2_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 22II4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II4, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 22II6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II6, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 22II8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II8, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 22II0 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II0, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 22III0 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III0, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 30II1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 30II2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 30II3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II3, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 30II4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II4, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 30II5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II5, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
#if DEBUG
		fprintf(stderr, "port 30II6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II6, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bb9650)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III8);
	res = sig_std_logic_resolve(res, cpssp->pin_16AIV_013);
#if DEBUG
		fprintf(stderr, "port 30III8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III8, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb9650, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bb9630)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I0);
	if(res != cpssp->pin_S14_2) {
#if DEBUG
		fprintf(stderr, "pin S14_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S14_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb9630, (void *) cpssp, res);
		xml2c_S14_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S15_2) {
#if DEBUG
		fprintf(stderr, "pin S15_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S15_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb9630, (void *) cpssp, res);
		xml2c_S15_2_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30I0 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I0, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb9630, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bb81b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_31AIV_9);
	if(res != cpssp->pin_23AII_14) {
#if DEBUG
		fprintf(stderr, "pin 23AII_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_23AII_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb81b0, (void *) cpssp, res);
		xml2c_23AII_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bb6a40)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_31AIII_7);
	if(res != cpssp->pin_24AIII_5) {
#if DEBUG
		fprintf(stderr, "pin 24AIII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_24AIII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb6a40, (void *) cpssp, res);
		xml2c_24AIII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bb8550)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30II8);
	if(res != cpssp->pin_S8_2) {
#if DEBUG
		fprintf(stderr, "pin S8_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S8_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8550, (void *) cpssp, res);
		xml2c_S8_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S9_2) {
#if DEBUG
		fprintf(stderr, "pin S9_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S9_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8550, (void *) cpssp, res);
		xml2c_S9_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S12_2) {
#if DEBUG
		fprintf(stderr, "pin S12_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S12_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8550, (void *) cpssp, res);
		xml2c_S12_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S13_2) {
#if DEBUG
		fprintf(stderr, "pin S13_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S13_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb8550, (void *) cpssp, res);
		xml2c_S13_2_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30II8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II8, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bb8550, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bb6640)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_31AII_5);
	if(res != cpssp->pin_24AII_14) {
#if DEBUG
		fprintf(stderr, "pin 24AII_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_24AII_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bb6640, (void *) cpssp, res);
		xml2c_24AII_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbe9f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_31AI_3);
	if(res != cpssp->pin_24AI_10) {
#if DEBUG
		fprintf(stderr, "pin 24AI_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_24AI_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbe9f0, (void *) cpssp, res);
		xml2c_24AI_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbea10)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I8);
	if(res != cpssp->pin_S6_2) {
#if DEBUG
		fprintf(stderr, "pin S6_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S6_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbea10, (void *) cpssp, res);
		xml2c_S6_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S7_2) {
#if DEBUG
		fprintf(stderr, "pin S7_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S7_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbea10, (void *) cpssp, res);
		xml2c_S7_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S10_2) {
#if DEBUG
		fprintf(stderr, "pin S10_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S10_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbea10, (void *) cpssp, res);
		xml2c_S10_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S11_2) {
#if DEBUG
		fprintf(stderr, "pin S11_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S11_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbea10, (void *) cpssp, res);
		xml2c_S11_2_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30I8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I8, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbea10, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbea70)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30AVI_13);
	if(res != cpssp->pin_25AIII_5) {
#if DEBUG
		fprintf(stderr, "pin 25AIII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_25AIII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbea70, (void *) cpssp, res);
		xml2c_25AIII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbead0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30AV_11);
	if(res != cpssp->pin_25AII_14) {
#if DEBUG
		fprintf(stderr, "pin 25AII_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_25AII_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbead0, (void *) cpssp, res);
		xml2c_25AII_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbeb30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30AIV_9);
	if(res != cpssp->pin_25AI_10) {
#if DEBUG
		fprintf(stderr, "pin 25AI_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_25AI_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbeb30, (void *) cpssp, res);
		xml2c_25AI_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbeb90)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30AIII_7);
	if(res != cpssp->pin_26AIII_5) {
#if DEBUG
		fprintf(stderr, "pin 26AIII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_26AIII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbeb90, (void *) cpssp, res);
		xml2c_26AIII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbebd0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30AII_5);
	if(res != cpssp->pin_26AII_14) {
#if DEBUG
		fprintf(stderr, "pin 26AII_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_26AII_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbebd0, (void *) cpssp, res);
		xml2c_26AII_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbec30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30AI_3);
	if(res != cpssp->pin_26AI_10) {
#if DEBUG
		fprintf(stderr, "pin 26AI_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_26AI_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbec30, (void *) cpssp, res);
		xml2c_26AI_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbec70)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30II7);
	if(res != cpssp->pin_S4_2) {
#if DEBUG
		fprintf(stderr, "pin S4_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S4_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbec70, (void *) cpssp, res);
		xml2c_S4_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S5_2) {
#if DEBUG
		fprintf(stderr, "pin S5_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S5_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbec70, (void *) cpssp, res);
		xml2c_S5_2_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30II7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II7, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbec70, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbecd0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_29AVI_13);
	if(res != cpssp->pin_27AIII_5) {
#if DEBUG
		fprintf(stderr, "pin 27AIII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_27AIII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbecd0, (void *) cpssp, res);
		xml2c_27AIII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbed30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_29AV_11);
	if(res != cpssp->pin_27AII_14) {
#if DEBUG
		fprintf(stderr, "pin 27AII_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_27AII_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbed30, (void *) cpssp, res);
		xml2c_27AII_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbed50)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I7);
	if(res != cpssp->pin_S2_2) {
#if DEBUG
		fprintf(stderr, "pin S2_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S2_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbed50, (void *) cpssp, res);
		xml2c_S2_2_in_set(cpssp, res);
	}
	if(res != cpssp->pin_S3_2) {
#if DEBUG
		fprintf(stderr, "pin S3_2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_S3_2 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbed50, (void *) cpssp, res);
		xml2c_S3_2_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30I7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I7, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbed50, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbedb0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_29AIV_9);
	if(res != cpssp->pin_27AI_10) {
#if DEBUG
		fprintf(stderr, "pin 27AI_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_27AI_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbedb0, (void *) cpssp, res);
		xml2c_27AI_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbee30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_29AIII_7);
	if(res != cpssp->pin_28AIII_5) {
#if DEBUG
		fprintf(stderr, "pin 28AIII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_28AIII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbee30, (void *) cpssp, res);
		xml2c_28AIII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbee70)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_29AI_3);
	if(res != cpssp->pin_28AI_10) {
#if DEBUG
		fprintf(stderr, "pin 28AI_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_28AI_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbee70, (void *) cpssp, res);
		xml2c_28AI_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbeed0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_29AII_5);
	if(res != cpssp->pin_28AII_14) {
#if DEBUG
		fprintf(stderr, "pin 28AII_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_28AII_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbeed0, (void *) cpssp, res);
		xml2c_28AII_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbeef0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_28AI_8);
	if(res != cpssp->pin_21AI_6) {
#if DEBUG
		fprintf(stderr, "pin 21AI_6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AI_6 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbeef0, (void *) cpssp, res);
		xml2c_21AI_6_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbef10)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_28AII_12);
	if(res != cpssp->pin_21AII_06) {
#if DEBUG
		fprintf(stderr, "pin 21AII_06 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AII_06 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbef10, (void *) cpssp, res);
		xml2c_21AII_06_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbef30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22AVIII_014);
	res = sig_std_logic_resolve(res, cpssp->pin_22AVII_14);
	res = sig_std_logic_resolve(res, cpssp->pin_22AVI_011);
	res = sig_std_logic_resolve(res, cpssp->pin_22AV_11);
	res = sig_std_logic_resolve(res, cpssp->pin_22AIV_08);
	res = sig_std_logic_resolve(res, cpssp->pin_22AIII_8);
	res = sig_std_logic_resolve(res, cpssp->pin_22AII_05);
	res = sig_std_logic_resolve(res, cpssp->pin_22AI_5);
	res = sig_std_logic_resolve(res, cpssp->pin_21AVIII_014);
	res = sig_std_logic_resolve(res, cpssp->pin_21AVII_14);
	res = sig_std_logic_resolve(res, cpssp->pin_21AV_11);
	res = sig_std_logic_resolve(res, cpssp->pin_21AIII_8);
	res = sig_std_logic_resolve(res, cpssp->pin_21AII_05);
	res = sig_std_logic_resolve(res, cpssp->pin_21AI_5);
	res = sig_std_logic_resolve(res, cpssp->pin_21AVI_011);
	res = sig_std_logic_resolve(res, cpssp->pin_21AIV_08);
	if(res != cpssp->pin_19A_13) {
#if DEBUG
		fprintf(stderr, "pin 19A_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_19A_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, res);
		xml2c_19A_13_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbef50)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_28AIII_3);
	if(res != cpssp->pin_21AIII_9) {
#if DEBUG
		fprintf(stderr, "pin 21AIII_9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AIII_9 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbef50, (void *) cpssp, res);
		xml2c_21AIII_9_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbef70)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_27AI_8);
	if(res != cpssp->pin_21AIV_09) {
#if DEBUG
		fprintf(stderr, "pin 21AIV_09 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AIV_09 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbef70, (void *) cpssp, res);
		xml2c_21AIV_09_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbef90)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_27AII_12);
	if(res != cpssp->pin_21AV_12) {
#if DEBUG
		fprintf(stderr, "pin 21AV_12 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AV_12 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbef90, (void *) cpssp, res);
		xml2c_21AV_12_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbefb0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_27AIII_3);
	if(res != cpssp->pin_21AVI_012) {
#if DEBUG
		fprintf(stderr, "pin 21AVI_012 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AVI_012 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbefb0, (void *) cpssp, res);
		xml2c_21AVI_012_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbefd0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_26AI_8);
	if(res != cpssp->pin_21AVII_15) {
#if DEBUG
		fprintf(stderr, "pin 21AVII_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AVII_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbefd0, (void *) cpssp, res);
		xml2c_21AVII_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbeff0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_26AII_12);
	if(res != cpssp->pin_21AVIII_015) {
#if DEBUG
		fprintf(stderr, "pin 21AVIII_015 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AVIII_015 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbeff0, (void *) cpssp, res);
		xml2c_21AVIII_015_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf010)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_26AIII_3);
	if(res != cpssp->pin_22AI_6) {
#if DEBUG
		fprintf(stderr, "pin 22AI_6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AI_6 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf010, (void *) cpssp, res);
		xml2c_22AI_6_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf030)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_25AI_8);
	if(res != cpssp->pin_22AII_06) {
#if DEBUG
		fprintf(stderr, "pin 22AII_06 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AII_06 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf030, (void *) cpssp, res);
		xml2c_22AII_06_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf050)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_25AII_12);
	if(res != cpssp->pin_22AIII_9) {
#if DEBUG
		fprintf(stderr, "pin 22AIII_9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AIII_9 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf050, (void *) cpssp, res);
		xml2c_22AIII_9_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf070)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_25AIII_3);
	if(res != cpssp->pin_22AIV_09) {
#if DEBUG
		fprintf(stderr, "pin 22AIV_09 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AIV_09 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf070, (void *) cpssp, res);
		xml2c_22AIV_09_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf090)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_24AI_8);
	if(res != cpssp->pin_22AV_12) {
#if DEBUG
		fprintf(stderr, "pin 22AV_12 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AV_12 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf090, (void *) cpssp, res);
		xml2c_22AV_12_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf0b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_24AII_12);
	if(res != cpssp->pin_22AVI_012) {
#if DEBUG
		fprintf(stderr, "pin 22AVI_012 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AVI_012 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf0b0, (void *) cpssp, res);
		xml2c_22AVI_012_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf0d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_24AIII_3);
	if(res != cpssp->pin_22AVII_15) {
#if DEBUG
		fprintf(stderr, "pin 22AVII_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AVII_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf0d0, (void *) cpssp, res);
		xml2c_22AVII_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf0f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_23AII_12);
	if(res != cpssp->pin_22AVIII_015) {
#if DEBUG
		fprintf(stderr, "pin 22AVIII_015 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AVIII_015 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf0f0, (void *) cpssp, res);
		xml2c_22AVIII_015_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf110)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_Uhr1);
	if(res != cpssp->pin_2A_14) {
#if DEBUG
		fprintf(stderr, "pin 2A_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_2A_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf110, (void *) cpssp, res);
		xml2c_2A_14_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port Uhr1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_Uhr1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf110, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf130)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_Uhr2);
	if(res != cpssp->pin_2A_15) {
#if DEBUG
		fprintf(stderr, "pin 2A_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_2A_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf130, (void *) cpssp, res);
		xml2c_2A_15_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port Uhr2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_Uhr2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf130, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf150)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_Imp1);
	if(res != cpssp->pin_4A_11) {
#if DEBUG
		fprintf(stderr, "pin 4A_11 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_4A_11 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf150, (void *) cpssp, res);
		xml2c_4A_11_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port Imp1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_Imp1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf150, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf170)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_Imp2);
	if(res != cpssp->pin_4A_13) {
#if DEBUG
		fprintf(stderr, "pin 4A_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_4A_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf170, (void *) cpssp, res);
		xml2c_4A_13_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port Imp2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_Imp2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf170, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf190)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_16AII_6);
	if(res != cpssp->pin_16AIII_7) {
#if DEBUG
		fprintf(stderr, "pin 16AIII_7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_16AIII_7 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf190, (void *) cpssp, res);
		xml2c_16AIII_7_in_set(cpssp, res);
	}
	if(res != cpssp->pin_17AI_13) {
#if DEBUG
		fprintf(stderr, "pin 17AI_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_17AI_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf190, (void *) cpssp, res);
		xml2c_17AI_13_in_set(cpssp, res);
	}
	if(res != cpssp->pin_15BI_14) {
#if DEBUG
		fprintf(stderr, "pin 15BI_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15BI_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf190, (void *) cpssp, res);
		xml2c_15BI_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf1b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_16AI_4);
	if(res != cpssp->pin_17AI_14) {
#if DEBUG
		fprintf(stderr, "pin 17AI_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_17AI_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf1b0, (void *) cpssp, res);
		xml2c_17AI_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf1d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_19A_4);
	if(res != cpssp->pin_17AI_15) {
#if DEBUG
		fprintf(stderr, "pin 17AI_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_17AI_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf1d0, (void *) cpssp, res);
		xml2c_17AI_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf1f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_18AI_10);
	if(res != cpssp->pin_16AIV_11) {
#if DEBUG
		fprintf(stderr, "pin 16AIV_11 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_16AIV_11 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf1f0, (void *) cpssp, res);
		xml2c_16AIV_11_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf210)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_19A_5);
	if(res != cpssp->pin_18AI_12) {
#if DEBUG
		fprintf(stderr, "pin 18AI_12 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_18AI_12 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf210, (void *) cpssp, res);
		xml2c_18AI_12_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf230)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_32BIII_06);
	if(res != cpssp->pin_19A_8) {
#if DEBUG
		fprintf(stderr, "pin 19A_8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_19A_8 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf230, (void *) cpssp, res);
		xml2c_19A_8_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf250)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_20AII_7);
	if(res != cpssp->pin_22AVIII_013) {
#if DEBUG
		fprintf(stderr, "pin 22AVIII_013 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AVIII_013 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AVIII_013_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AVII_13) {
#if DEBUG
		fprintf(stderr, "pin 22AVII_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AVII_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AVII_13_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AVI_010) {
#if DEBUG
		fprintf(stderr, "pin 22AVI_010 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AVI_010 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AVI_010_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AV_10) {
#if DEBUG
		fprintf(stderr, "pin 22AV_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AV_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AV_10_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AIV_07) {
#if DEBUG
		fprintf(stderr, "pin 22AIV_07 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AIV_07 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AIV_07_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AIII_7) {
#if DEBUG
		fprintf(stderr, "pin 22AIII_7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AIII_7 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AIII_7_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AII_04) {
#if DEBUG
		fprintf(stderr, "pin 22AII_04 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AII_04 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AII_04_in_set(cpssp, res);
	}
	if(res != cpssp->pin_22AI_4) {
#if DEBUG
		fprintf(stderr, "pin 22AI_4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_22AI_4 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_22AI_4_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AVIII_013) {
#if DEBUG
		fprintf(stderr, "pin 21AVIII_013 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AVIII_013 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AVIII_013_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AVII_13) {
#if DEBUG
		fprintf(stderr, "pin 21AVII_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AVII_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AVII_13_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AV_10) {
#if DEBUG
		fprintf(stderr, "pin 21AV_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AV_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AV_10_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AIII_7) {
#if DEBUG
		fprintf(stderr, "pin 21AIII_7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AIII_7 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AIII_7_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AII_04) {
#if DEBUG
		fprintf(stderr, "pin 21AII_04 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AII_04 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AII_04_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AI_4) {
#if DEBUG
		fprintf(stderr, "pin 21AI_4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AI_4 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AI_4_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AVI_010) {
#if DEBUG
		fprintf(stderr, "pin 21AVI_010 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AVI_010 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AVI_010_in_set(cpssp, res);
	}
	if(res != cpssp->pin_21AIV_07) {
#if DEBUG
		fprintf(stderr, "pin 21AIV_07 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_21AIV_07 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, res);
		xml2c_21AIV_07_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf270)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_32BIV_013);
	if(res != cpssp->pin_32BIII_7) {
#if DEBUG
		fprintf(stderr, "pin 32BIII_7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_32BIII_7 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf270, (void *) cpssp, res);
		xml2c_32BIII_7_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf290)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III6);
	if(res != cpssp->pin_32BIV_11) {
#if DEBUG
		fprintf(stderr, "pin 32BIV_11 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_32BIV_11 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf290, (void *) cpssp, res);
		xml2c_32BIV_11_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30III6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III6, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf290, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf2b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_15AII_011);
	if(res != cpssp->pin_16AVI_15) {
#if DEBUG
		fprintf(stderr, "pin 16AVI_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_16AVI_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf2b0, (void *) cpssp, res);
		xml2c_16AVI_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf2d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_16AV_13);
	if(res != cpssp->pin_15AII_12) {
#if DEBUG
		fprintf(stderr, "pin 15AII_12 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15AII_12 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf2d0, (void *) cpssp, res);
		xml2c_15AII_12_in_set(cpssp, res);
	}
	if(res != cpssp->pin_15AII_13) {
#if DEBUG
		fprintf(stderr, "pin 15AII_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15AII_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf2d0, (void *) cpssp, res);
		xml2c_15AII_13_in_set(cpssp, res);
	}
	if(res != cpssp->pin_18AII_4) {
#if DEBUG
		fprintf(stderr, "pin 18AII_4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_18AII_4 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf2d0, (void *) cpssp, res);
		xml2c_18AII_4_in_set(cpssp, res);
	}
	if(res != cpssp->pin_6AV_015) {
#if DEBUG
		fprintf(stderr, "pin 6AV_015 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_6AV_015 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf2d0, (void *) cpssp, res);
		xml2c_6AV_015_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf2f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_18AII_7);
	if(res != cpssp->pin_14A_15) {
#if DEBUG
		fprintf(stderr, "pin 14A_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_14A_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf2f0, (void *) cpssp, res);
		xml2c_14A_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf310)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_15AI_09);
	if(res != cpssp->pin_15AII_013) {
#if DEBUG
		fprintf(stderr, "pin 15AII_013 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15AII_013 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf310, (void *) cpssp, res);
		xml2c_15AII_013_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf330)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_15AI_9);
	if(res != cpssp->pin_15AII_012) {
#if DEBUG
		fprintf(stderr, "pin 15AII_012 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15AII_012 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf330, (void *) cpssp, res);
		xml2c_15AII_012_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf350)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_17AII_8);
	if(res != cpssp->pin_15AI_5) {
#if DEBUG
		fprintf(stderr, "pin 15AI_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15AI_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf350, (void *) cpssp, res);
		xml2c_15AI_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf370)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_12AI_11);
	if(res != cpssp->pin_15AI_7) {
#if DEBUG
		fprintf(stderr, "pin 15AI_7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15AI_7 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf370, (void *) cpssp, res);
		xml2c_15AI_7_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf390)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_6AVI_14);
	if(res != cpssp->pin_12AI_13) {
#if DEBUG
		fprintf(stderr, "pin 12AI_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_12AI_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf390, (void *) cpssp, res);
		xml2c_12AI_13_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf3d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_17B_5);
	if(res != cpssp->pin_17AII_5) {
#if DEBUG
		fprintf(stderr, "pin 17AII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_17AII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf3d0, (void *) cpssp, res);
		xml2c_17AII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf3f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_17B_4);
	if(res != cpssp->pin_12AI_14) {
#if DEBUG
		fprintf(stderr, "pin 12AI_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_12AI_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf3f0, (void *) cpssp, res);
		xml2c_12AI_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf410)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_12AII_8);
	if(res != cpssp->pin_6AVI_15) {
#if DEBUG
		fprintf(stderr, "pin 6AVI_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_6AVI_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf410, (void *) cpssp, res);
		xml2c_6AVI_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf430)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_14A_6);
	if(res != cpssp->pin_12AII_5) {
#if DEBUG
		fprintf(stderr, "pin 12AII_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_12AII_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf430, (void *) cpssp, res);
		xml2c_12AII_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf450)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_13A_5);
	if(res != cpssp->pin_12AII_3) {
#if DEBUG
		fprintf(stderr, "pin 12AII_3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_12AII_3 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf450, (void *) cpssp, res);
		xml2c_12AII_3_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf470)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_6AV_13);
	if(res != cpssp->pin_13A_15) {
#if DEBUG
		fprintf(stderr, "pin 13A_15 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_13A_15 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf470, (void *) cpssp, res);
		xml2c_13A_15_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf490)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III7);
	if(res != cpssp->pin_16AV_015) {
#if DEBUG
		fprintf(stderr, "pin 16AV_015 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_16AV_015 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf490, (void *) cpssp, res);
		xml2c_16AV_015_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30III7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III7, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf490, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf4b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_15BI_10);
	if(res != cpssp->pin_17B_13) {
#if DEBUG
		fprintf(stderr, "pin 17B_13 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_17B_13 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf4b0, (void *) cpssp, res);
		xml2c_17B_13_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf4d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30II0);
	if(res != cpssp->pin_15BI_12) {
#if DEBUG
		fprintf(stderr, "pin 15BI_12 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_15BI_12 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf4d0, (void *) cpssp, res);
		xml2c_15BI_12_in_set(cpssp, res);
	}
#if DEBUG
		fprintf(stderr, "port 30II0 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II0, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf4d0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf530)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_14A_8);
	if(res != cpssp->pin_14A_8) {
#if DEBUG
		fprintf(stderr, "pin 14A_8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_14A_8 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf530, (void *) cpssp, res);
		xml2c_14A_8_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf550)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_14A_10);
	if(res != cpssp->pin_14A_10) {
#if DEBUG
		fprintf(stderr, "pin 14A_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_14A_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf550, (void *) cpssp, res);
		xml2c_14A_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf570)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_13A_10);
	if(res != cpssp->pin_13A_10) {
#if DEBUG
		fprintf(stderr, "pin 13A_10 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_13A_10 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf570, (void *) cpssp, res);
		xml2c_13A_10_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf590)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_13A_8);
	if(res != cpssp->pin_13A_8) {
#if DEBUG
		fprintf(stderr, "pin 13A_8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_13A_8 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf590, (void *) cpssp, res);
		xml2c_13A_8_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf5d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_4A_7);
	if(res != cpssp->pin_6AIV_11) {
#if DEBUG
		fprintf(stderr, "pin 6AIV_11 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_6AIV_11 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf5d0, (void *) cpssp, res);
		xml2c_6AIV_11_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf5f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I3);
	res = sig_std_logic_resolve(res, cpssp->pin_6AIV_013);
#if DEBUG
		fprintf(stderr, "port 30I3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I3, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf5f0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf610)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_2A_13);
	if(res != cpssp->pin_3A_5) {
#if DEBUG
		fprintf(stderr, "pin 3A_5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_3A_5 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf610, (void *) cpssp, res);
		xml2c_3A_5_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf630)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_2A_5);
	if(res != cpssp->pin_3A_14) {
#if DEBUG
		fprintf(stderr, "pin 3A_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_3A_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf630, (void *) cpssp, res);
		xml2c_3A_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf650)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_3A_9);
	if(res != cpssp->pin_5A_9) {
#if DEBUG
		fprintf(stderr, "pin 5A_9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_5A_9 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf650, (void *) cpssp, res);
		xml2c_5A_9_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf670)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I6);
	res = sig_std_logic_resolve(res, cpssp->pin_6AI_4);
#if DEBUG
		fprintf(stderr, "port 30I6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I6, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf670, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf690)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_5A_4);
	if(res != cpssp->pin_6AII_03) {
#if DEBUG
		fprintf(stderr, "pin 6AII_03 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_6AII_03 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf690, (void *) cpssp, res);
		xml2c_6AII_03_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf6b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_5A_5);
	if(res != cpssp->pin_6AIII_7) {
#if DEBUG
		fprintf(stderr, "pin 6AIII_7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_6AIII_7 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf6b0, (void *) cpssp, res);
		xml2c_6AIII_7_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf6d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I4);
	res = sig_std_logic_resolve(res, cpssp->pin_6AIII_06);
#if DEBUG
		fprintf(stderr, "port 30I4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I4, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf6d0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf6f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I5);
	res = sig_std_logic_resolve(res, cpssp->pin_6AII_6);
#if DEBUG
		fprintf(stderr, "port 30I5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I5, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bbf6f0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bbf710)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_3A_10);
	if(res != cpssp->pin_5A_12) {
#if DEBUG
		fprintf(stderr, "pin 5A_12 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_5A_12 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf710, (void *) cpssp, res);
		xml2c_5A_12_in_set(cpssp, res);
	}
	if(res != cpssp->pin_5A_8) {
#if DEBUG
		fprintf(stderr, "pin 5A_8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_5A_8 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf710, (void *) cpssp, res);
		xml2c_5A_8_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf730)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_3A_7);
	if(res != cpssp->pin_5A_14) {
#if DEBUG
		fprintf(stderr, "pin 5A_14 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_5A_14 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf730, (void *) cpssp, res);
		xml2c_5A_14_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bbf750)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_3A_12);
	if(res != cpssp->pin_6AI_3) {
#if DEBUG
		fprintf(stderr, "pin 6AI_3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		cpssp->pin_6AI_3 = res;
		sig_std_logic_set(cpssp->gui_port_0x1bbf750, (void *) cpssp, res);
		xml2c_6AI_3_in_set(cpssp, res);
	}
}
static void
COMP_(resolve_sig_0x1bc26c0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_15AII_11);
}
static void
COMP_(resolve_sig_0x1bc3d10)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_14A_4);
}
static void
COMP_(resolve_sig_0x1bc3e60)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_14A_5);
}
static void
COMP_(resolve_sig_0x1bc3fb0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_14A_7);
}
static void
COMP_(resolve_sig_0x1bc44f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_13A_4);
}
static void
COMP_(resolve_sig_0x1bc4640)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_13A_6);
}
static void
COMP_(resolve_sig_0x1bc4790)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_13A_7);
}
static void
COMP_(resolve_sig_0x1bc5600)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S0_5);
}
static void
COMP_(resolve_sig_0x1bc5750)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S0_6);
}
static void
COMP_(resolve_sig_0x1bc58a0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S0_7);
}
static void
COMP_(resolve_sig_0x1bc59f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S0_8);
}
static void
COMP_(resolve_sig_0x1bc5de0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S1_5);
}
static void
COMP_(resolve_sig_0x1bc5f30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S1_6);
}
static void
COMP_(resolve_sig_0x1bc6080)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S1_7);
}
static void
COMP_(resolve_sig_0x1bc61d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S1_8);
}
static void
COMP_(resolve_sig_0x1bc65c0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S2_5);
}
static void
COMP_(resolve_sig_0x1bc6710)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S2_6);
}
static void
COMP_(resolve_sig_0x1bc6860)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S2_7);
}
static void
COMP_(resolve_sig_0x1bc69b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S2_8);
}
static void
COMP_(resolve_sig_0x1bc6da0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S3_5);
}
static void
COMP_(resolve_sig_0x1bc6ef0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S3_6);
}
static void
COMP_(resolve_sig_0x1bc7040)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S3_7);
}
static void
COMP_(resolve_sig_0x1bc7190)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S3_8);
}
static void
COMP_(resolve_sig_0x1bc7580)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S4_5);
}
static void
COMP_(resolve_sig_0x1bc76d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S4_6);
}
static void
COMP_(resolve_sig_0x1bc7820)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S4_7);
}
static void
COMP_(resolve_sig_0x1bc7970)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S4_8);
}
static void
COMP_(resolve_sig_0x1bc7d60)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S5_5);
}
static void
COMP_(resolve_sig_0x1bc7eb0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S5_6);
}
static void
COMP_(resolve_sig_0x1bc8000)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S5_7);
}
static void
COMP_(resolve_sig_0x1bc8150)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S5_8);
}
static void
COMP_(resolve_sig_0x1bc8540)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S6_5);
}
static void
COMP_(resolve_sig_0x1bc8690)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S6_6);
}
static void
COMP_(resolve_sig_0x1bc87e0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S6_7);
}
static void
COMP_(resolve_sig_0x1bc8930)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S6_8);
}
static void
COMP_(resolve_sig_0x1bc8d20)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S7_5);
}
static void
COMP_(resolve_sig_0x1bc8e70)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S7_6);
}
static void
COMP_(resolve_sig_0x1bc8fc0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S7_7);
}
static void
COMP_(resolve_sig_0x1bb6b50)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S7_8);
}
static void
COMP_(resolve_sig_0x1bc91c0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S8_5);
}
static void
COMP_(resolve_sig_0x1bc9310)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S8_6);
}
static void
COMP_(resolve_sig_0x1bc9460)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S8_7);
}
static void
COMP_(resolve_sig_0x1bc95b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S8_8);
}
static void
COMP_(resolve_sig_0x1bc99a0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S9_5);
}
static void
COMP_(resolve_sig_0x1bc9af0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S9_6);
}
static void
COMP_(resolve_sig_0x1bc9c40)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S9_7);
}
static void
COMP_(resolve_sig_0x1bc9d90)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S9_8);
}
static void
COMP_(resolve_sig_0x1bca180)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S10_5);
}
static void
COMP_(resolve_sig_0x1bca2d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S10_6);
}
static void
COMP_(resolve_sig_0x1bca420)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S10_7);
}
static void
COMP_(resolve_sig_0x1bca570)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S10_8);
}
static void
COMP_(resolve_sig_0x1bca960)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S11_5);
}
static void
COMP_(resolve_sig_0x1bcaab0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S11_6);
}
static void
COMP_(resolve_sig_0x1bcac00)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S11_7);
}
static void
COMP_(resolve_sig_0x1bcad50)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S11_8);
}
static void
COMP_(resolve_sig_0x1bcb140)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S12_5);
}
static void
COMP_(resolve_sig_0x1bcb290)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S12_6);
}
static void
COMP_(resolve_sig_0x1bcb3e0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S12_7);
}
static void
COMP_(resolve_sig_0x1bcb530)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S12_8);
}
static void
COMP_(resolve_sig_0x1bcb920)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S13_5);
}
static void
COMP_(resolve_sig_0x1bcba70)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S13_6);
}
static void
COMP_(resolve_sig_0x1bcbbc0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S13_7);
}
static void
COMP_(resolve_sig_0x1bcbd10)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S13_8);
}
static void
COMP_(resolve_sig_0x1bcc100)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S14_5);
}
static void
COMP_(resolve_sig_0x1bcc250)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S14_6);
}
static void
COMP_(resolve_sig_0x1bcc3a0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S14_7);
}
static void
COMP_(resolve_sig_0x1bcc4f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S14_8);
}
static void
COMP_(resolve_sig_0x1bcc8e0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S15_5);
}
static void
COMP_(resolve_sig_0x1bcca30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S15_6);
}
static void
COMP_(resolve_sig_0x1bccb80)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S15_7);
}
static void
COMP_(resolve_sig_0x1bcccd0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_S15_8);
}
static void
COMP_(resolve_sig_0x1bcd0c0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I0);
#if DEBUG
		fprintf(stderr, "port 22I0 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I0, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd0c0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd210)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I1);
#if DEBUG
		fprintf(stderr, "port 22I1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd210, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd360)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I2);
#if DEBUG
		fprintf(stderr, "port 22I2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd360, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd4b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I3);
#if DEBUG
		fprintf(stderr, "port 22I3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I3, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd4b0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd600)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I4);
#if DEBUG
		fprintf(stderr, "port 22I4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I4, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd600, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd750)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I5);
#if DEBUG
		fprintf(stderr, "port 22I5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I5, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd750, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd8a0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I6);
#if DEBUG
		fprintf(stderr, "port 22I6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I6, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd8a0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcd9f0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I7);
#if DEBUG
		fprintf(stderr, "port 22I7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I7, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcd9f0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcdb40)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I8);
#if DEBUG
		fprintf(stderr, "port 22I8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I8, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcdb40, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcdc90)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22I9);
#if DEBUG
		fprintf(stderr, "port 22I9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22I9, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcdc90, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcdde0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II1);
#if DEBUG
		fprintf(stderr, "port 22II1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcdde0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcdf30)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II2);
#if DEBUG
		fprintf(stderr, "port 22II2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcdf30, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce080)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II3);
#if DEBUG
		fprintf(stderr, "port 22II3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II3, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce080, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce1d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II5);
#if DEBUG
		fprintf(stderr, "port 22II5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II5, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce1d0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce320)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II7);
#if DEBUG
		fprintf(stderr, "port 22II7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II7, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce320, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce470)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22II9);
#if DEBUG
		fprintf(stderr, "port 22II9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22II9, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce470, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce5c0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III1);
#if DEBUG
		fprintf(stderr, "port 22III1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce5c0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce710)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III2);
#if DEBUG
		fprintf(stderr, "port 22III2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce710, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce860)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III3);
#if DEBUG
		fprintf(stderr, "port 22III3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III3, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce860, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bce9b0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III4);
#if DEBUG
		fprintf(stderr, "port 22III4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III4, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bce9b0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bceb00)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III5);
#if DEBUG
		fprintf(stderr, "port 22III5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III5, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bceb00, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcec50)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III6);
#if DEBUG
		fprintf(stderr, "port 22III6 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III6, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcec50, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bceda0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III7);
#if DEBUG
		fprintf(stderr, "port 22III7 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III7, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bceda0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bceef0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III8);
#if DEBUG
		fprintf(stderr, "port 22III8 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III8, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bceef0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf040)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_22III9);
#if DEBUG
		fprintf(stderr, "port 22III9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_22III9, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf040, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf190)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I1);
#if DEBUG
		fprintf(stderr, "port 30I1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf190, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf2e0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I2);
#if DEBUG
		fprintf(stderr, "port 30I2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf2e0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf430)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30I9);
#if DEBUG
		fprintf(stderr, "port 30I9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30I9, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf430, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf580)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30II9);
#if DEBUG
		fprintf(stderr, "port 30II9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30II9, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf580, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf6d0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III0);
#if DEBUG
		fprintf(stderr, "port 30III0 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III0, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf6d0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf820)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III1);
#if DEBUG
		fprintf(stderr, "port 30III1 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III1, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf820, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcf970)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III2);
#if DEBUG
		fprintf(stderr, "port 30III2 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III2, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcf970, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcfac0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III3);
#if DEBUG
		fprintf(stderr, "port 30III3 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III3, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcfac0, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcfc10)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III4);
#if DEBUG
		fprintf(stderr, "port 30III4 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III4, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcfc10, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcfd60)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III5);
#if DEBUG
		fprintf(stderr, "port 30III5 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III5, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcfd60, (void *) cpssp, res);
}
static void
COMP_(resolve_sig_0x1bcfeb0)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int res = SIG_STD_LOGIC_Z;
	res = sig_std_logic_resolve(res, cpssp->pin_30III9);
#if DEBUG
		fprintf(stderr, "port 30III9 sets to ");
		printlogic(res);
#endif /* DEBUG */
		//sig_std_logic_set(cpssp->port_30III9, (void *) cpssp, res);
		//sig_std_logic_set(cpssp->gui_port_0x1bcfeb0, (void *) cpssp, res);
}

/* pins */
static void
xml2c_20AII_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_20AII_7) {
		cpssp->pin_20AII_7 = val;
#if DEBUG
		fprintf(stderr, "pin 20AII_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf250, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf250)(cpssp);
	}
}

static void
xml2c_6AI_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_6AI_4) {
		cpssp->pin_6AI_4 = val;
#if DEBUG
		fprintf(stderr, "pin 6AI_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf670, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf670)(cpssp);
	}
}

static void
xml2c_6AII_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_6AII_6) {
		cpssp->pin_6AII_6 = val;
#if DEBUG
		fprintf(stderr, "pin 6AII_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf6f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf6f0)(cpssp);
	}
}

static void
xml2c_6AIII_06_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_6AIII_06) {
		cpssp->pin_6AIII_06 = val;
#if DEBUG
		fprintf(stderr, "pin 6AIII_06 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf6d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf6d0)(cpssp);
	}
}

static void
xml2c_6AIV_013_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_6AIV_013) {
		cpssp->pin_6AIV_013 = val;
#if DEBUG
		fprintf(stderr, "pin 6AIV_013 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf5f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf5f0)(cpssp);
	}
}

static void
xml2c_32BIV_013_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_32BIV_013) {
		cpssp->pin_32BIV_013 = val;
#if DEBUG
		fprintf(stderr, "pin 32BIV_013 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf270, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf270)(cpssp);
	}
}

static void
xml2c_32BIII_06_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_32BIII_06) {
		cpssp->pin_32BIII_06 = val;
#if DEBUG
		fprintf(stderr, "pin 32BIII_06 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf230, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf230)(cpssp);
	}
}

static void
xml2c_16AI_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_16AI_4) {
		cpssp->pin_16AI_4 = val;
#if DEBUG
		fprintf(stderr, "pin 16AI_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf1b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf1b0)(cpssp);
	}
}

static void
xml2c_16AII_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_16AII_6) {
		cpssp->pin_16AII_6 = val;
#if DEBUG
		fprintf(stderr, "pin 16AII_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf190, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf190)(cpssp);
	}
}

static void
xml2c_16AIII_06_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_16AIII_06) {
		cpssp->pin_16AIII_06 = val;
#if DEBUG
		fprintf(stderr, "pin 16AIII_06 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb8760)(cpssp);
	}
}

static void
xml2c_16AIV_013_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_16AIV_013) {
		cpssp->pin_16AIV_013 = val;
#if DEBUG
		fprintf(stderr, "pin 16AIV_013 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb9650, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb9650)(cpssp);
	}
}

static void
xml2c_17AI_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_17AI_11) {
		cpssp->pin_17AI_11 = val;
#if DEBUG
		fprintf(stderr, "pin 17AI_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb8760)(cpssp);
	}
}

static void
xml2c_18AI_10_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_18AI_10) {
		cpssp->pin_18AI_10 = val;
#if DEBUG
		fprintf(stderr, "pin 18AI_10 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf1f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf1f0)(cpssp);
	}
}

static void
xml2c_19A_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_19A_4) {
		cpssp->pin_19A_4 = val;
#if DEBUG
		fprintf(stderr, "pin 19A_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf1d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf1d0)(cpssp);
	}
}

static void
xml2c_19A_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_19A_5) {
		cpssp->pin_19A_5 = val;
#if DEBUG
		fprintf(stderr, "pin 19A_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf210, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf210)(cpssp);
	}
}

static void
xml2c_5A_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_5A_4) {
		cpssp->pin_5A_4 = val;
#if DEBUG
		fprintf(stderr, "pin 5A_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf690, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf690)(cpssp);
	}
}

static void
xml2c_5A_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_5A_5) {
		cpssp->pin_5A_5 = val;
#if DEBUG
		fprintf(stderr, "pin 5A_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf6b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf6b0)(cpssp);
	}
}

static void
xml2c_22AVIII_014_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AVIII_014) {
		cpssp->pin_22AVIII_014 = val;
#if DEBUG
		fprintf(stderr, "pin 22AVIII_014 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AVII_14_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AVII_14) {
		cpssp->pin_22AVII_14 = val;
#if DEBUG
		fprintf(stderr, "pin 22AVII_14 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AVI_011_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AVI_011) {
		cpssp->pin_22AVI_011 = val;
#if DEBUG
		fprintf(stderr, "pin 22AVI_011 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AV_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AV_11) {
		cpssp->pin_22AV_11 = val;
#if DEBUG
		fprintf(stderr, "pin 22AV_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AIV_08_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AIV_08) {
		cpssp->pin_22AIV_08 = val;
#if DEBUG
		fprintf(stderr, "pin 22AIV_08 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AIII_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AIII_8) {
		cpssp->pin_22AIII_8 = val;
#if DEBUG
		fprintf(stderr, "pin 22AIII_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AII_05_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AII_05) {
		cpssp->pin_22AII_05 = val;
#if DEBUG
		fprintf(stderr, "pin 22AII_05 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_22AI_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_22AI_5) {
		cpssp->pin_22AI_5 = val;
#if DEBUG
		fprintf(stderr, "pin 22AI_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AVIII_014_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AVIII_014) {
		cpssp->pin_21AVIII_014 = val;
#if DEBUG
		fprintf(stderr, "pin 21AVIII_014 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AVII_14_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AVII_14) {
		cpssp->pin_21AVII_14 = val;
#if DEBUG
		fprintf(stderr, "pin 21AVII_14 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AV_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AV_11) {
		cpssp->pin_21AV_11 = val;
#if DEBUG
		fprintf(stderr, "pin 21AV_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AIII_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AIII_8) {
		cpssp->pin_21AIII_8 = val;
#if DEBUG
		fprintf(stderr, "pin 21AIII_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AII_05_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AII_05) {
		cpssp->pin_21AII_05 = val;
#if DEBUG
		fprintf(stderr, "pin 21AII_05 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AI_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AI_5) {
		cpssp->pin_21AI_5 = val;
#if DEBUG
		fprintf(stderr, "pin 21AI_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_31AIV_9_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_31AIV_9) {
		cpssp->pin_31AIV_9 = val;
#if DEBUG
		fprintf(stderr, "pin 31AIV_9 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb81b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb81b0)(cpssp);
	}
}

static void
xml2c_31AIII_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_31AIII_7) {
		cpssp->pin_31AIII_7 = val;
#if DEBUG
		fprintf(stderr, "pin 31AIII_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb6a40, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb6a40)(cpssp);
	}
}

static void
xml2c_31AII_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_31AII_5) {
		cpssp->pin_31AII_5 = val;
#if DEBUG
		fprintf(stderr, "pin 31AII_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb6640, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb6640)(cpssp);
	}
}

static void
xml2c_31AI_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_31AI_3) {
		cpssp->pin_31AI_3 = val;
#if DEBUG
		fprintf(stderr, "pin 31AI_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbe9f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbe9f0)(cpssp);
	}
}

static void
xml2c_30AVI_13_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_30AVI_13) {
		cpssp->pin_30AVI_13 = val;
#if DEBUG
		fprintf(stderr, "pin 30AVI_13 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbea70, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbea70)(cpssp);
	}
}

static void
xml2c_30AV_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_30AV_11) {
		cpssp->pin_30AV_11 = val;
#if DEBUG
		fprintf(stderr, "pin 30AV_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbead0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbead0)(cpssp);
	}
}

static void
xml2c_30AIV_9_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_30AIV_9) {
		cpssp->pin_30AIV_9 = val;
#if DEBUG
		fprintf(stderr, "pin 30AIV_9 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbeb30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbeb30)(cpssp);
	}
}

static void
xml2c_30AIII_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_30AIII_7) {
		cpssp->pin_30AIII_7 = val;
#if DEBUG
		fprintf(stderr, "pin 30AIII_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbeb90, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbeb90)(cpssp);
	}
}

static void
xml2c_30AII_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_30AII_5) {
		cpssp->pin_30AII_5 = val;
#if DEBUG
		fprintf(stderr, "pin 30AII_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbebd0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbebd0)(cpssp);
	}
}

static void
xml2c_30AI_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_30AI_3) {
		cpssp->pin_30AI_3 = val;
#if DEBUG
		fprintf(stderr, "pin 30AI_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbec30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbec30)(cpssp);
	}
}

static void
xml2c_29AVI_13_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_29AVI_13) {
		cpssp->pin_29AVI_13 = val;
#if DEBUG
		fprintf(stderr, "pin 29AVI_13 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbecd0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbecd0)(cpssp);
	}
}

static void
xml2c_29AV_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_29AV_11) {
		cpssp->pin_29AV_11 = val;
#if DEBUG
		fprintf(stderr, "pin 29AV_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbed30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbed30)(cpssp);
	}
}

static void
xml2c_29AIV_9_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_29AIV_9) {
		cpssp->pin_29AIV_9 = val;
#if DEBUG
		fprintf(stderr, "pin 29AIV_9 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbedb0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbedb0)(cpssp);
	}
}

static void
xml2c_29AIII_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_29AIII_7) {
		cpssp->pin_29AIII_7 = val;
#if DEBUG
		fprintf(stderr, "pin 29AIII_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbee30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbee30)(cpssp);
	}
}

static void
xml2c_29AII_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_29AII_5) {
		cpssp->pin_29AII_5 = val;
#if DEBUG
		fprintf(stderr, "pin 29AII_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbeed0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbeed0)(cpssp);
	}
}

static void
xml2c_29AI_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_29AI_3) {
		cpssp->pin_29AI_3 = val;
#if DEBUG
		fprintf(stderr, "pin 29AI_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbee70, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbee70)(cpssp);
	}
}

static void
xml2c_12AI_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_12AI_11) {
		cpssp->pin_12AI_11 = val;
#if DEBUG
		fprintf(stderr, "pin 12AI_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf370, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf370)(cpssp);
	}
}

static void
xml2c_17AII_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_17AII_8) {
		cpssp->pin_17AII_8 = val;
#if DEBUG
		fprintf(stderr, "pin 17AII_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf350, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf350)(cpssp);
	}
}

static void
xml2c_12AII_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_12AII_8) {
		cpssp->pin_12AII_8 = val;
#if DEBUG
		fprintf(stderr, "pin 12AII_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf410, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf410)(cpssp);
	}
}

static void
xml2c_15AII_011_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_15AII_011) {
		cpssp->pin_15AII_011 = val;
#if DEBUG
		fprintf(stderr, "pin 15AII_011 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf2b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf2b0)(cpssp);
	}
}

static void
xml2c_15AII_11_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_15AII_11) {
		cpssp->pin_15AII_11 = val;
#if DEBUG
		fprintf(stderr, "pin 15AII_11 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc26c0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc26c0)(cpssp);
	}
}

static void
xml2c_15AI_09_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_15AI_09) {
		cpssp->pin_15AI_09 = val;
#if DEBUG
		fprintf(stderr, "pin 15AI_09 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf310, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf310)(cpssp);
	}
}

static void
xml2c_15AI_9_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_15AI_9) {
		cpssp->pin_15AI_9 = val;
#if DEBUG
		fprintf(stderr, "pin 15AI_9 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf330, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf330)(cpssp);
	}
}

static void
xml2c_18AII_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_18AII_7) {
		cpssp->pin_18AII_7 = val;
#if DEBUG
		fprintf(stderr, "pin 18AII_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf2f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf2f0)(cpssp);
	}
}

static void
xml2c_14A_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_14A_6) {
		cpssp->pin_14A_6 = val;
#if DEBUG
		fprintf(stderr, "pin 14A_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf430, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf430)(cpssp);
	}
}

static void
xml2c_14A_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_14A_8) {
		cpssp->pin_14A_8 = val;
#if DEBUG
		fprintf(stderr, "pin 14A_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf530, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf530)(cpssp);
	}
}

static void
xml2c_14A_10_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_14A_10) {
		cpssp->pin_14A_10 = val;
#if DEBUG
		fprintf(stderr, "pin 14A_10 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf550, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf550)(cpssp);
	}
}

static void
xml2c_14A_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_14A_4) {
		cpssp->pin_14A_4 = val;
#if DEBUG
		fprintf(stderr, "pin 14A_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc3d10, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc3d10)(cpssp);
	}
}

static void
xml2c_14A_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_14A_5) {
		cpssp->pin_14A_5 = val;
#if DEBUG
		fprintf(stderr, "pin 14A_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc3e60, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc3e60)(cpssp);
	}
}

static void
xml2c_14A_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_14A_7) {
		cpssp->pin_14A_7 = val;
#if DEBUG
		fprintf(stderr, "pin 14A_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc3fb0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc3fb0)(cpssp);
	}
}

static void
xml2c_13A_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_13A_5) {
		cpssp->pin_13A_5 = val;
#if DEBUG
		fprintf(stderr, "pin 13A_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf450, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf450)(cpssp);
	}
}

static void
xml2c_13A_10_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_13A_10) {
		cpssp->pin_13A_10 = val;
#if DEBUG
		fprintf(stderr, "pin 13A_10 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf570, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf570)(cpssp);
	}
}

static void
xml2c_13A_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_13A_8) {
		cpssp->pin_13A_8 = val;
#if DEBUG
		fprintf(stderr, "pin 13A_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf590, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf590)(cpssp);
	}
}

static void
xml2c_13A_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_13A_4) {
		cpssp->pin_13A_4 = val;
#if DEBUG
		fprintf(stderr, "pin 13A_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc44f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc44f0)(cpssp);
	}
}

static void
xml2c_13A_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_13A_6) {
		cpssp->pin_13A_6 = val;
#if DEBUG
		fprintf(stderr, "pin 13A_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc4640, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc4640)(cpssp);
	}
}

static void
xml2c_13A_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_13A_7) {
		cpssp->pin_13A_7 = val;
#if DEBUG
		fprintf(stderr, "pin 13A_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc4790, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc4790)(cpssp);
	}
}

static void
xml2c_3A_9_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_3A_9) {
		cpssp->pin_3A_9 = val;
#if DEBUG
		fprintf(stderr, "pin 3A_9 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf650, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf650)(cpssp);
	}
}

static void
xml2c_3A_10_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_3A_10) {
		cpssp->pin_3A_10 = val;
#if DEBUG
		fprintf(stderr, "pin 3A_10 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf710, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf710)(cpssp);
	}
}

static void
xml2c_3A_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_3A_7) {
		cpssp->pin_3A_7 = val;
#if DEBUG
		fprintf(stderr, "pin 3A_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf730, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf730)(cpssp);
	}
}

static void
xml2c_3A_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_3A_12) {
		cpssp->pin_3A_12 = val;
#if DEBUG
		fprintf(stderr, "pin 3A_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf750, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf750)(cpssp);
	}
}

static void
xml2c_2A_13_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_2A_13) {
		cpssp->pin_2A_13 = val;
#if DEBUG
		fprintf(stderr, "pin 2A_13 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf610, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf610)(cpssp);
	}
}

static void
xml2c_2A_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_2A_5) {
		cpssp->pin_2A_5 = val;
#if DEBUG
		fprintf(stderr, "pin 2A_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf630, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf630)(cpssp);
	}
}

static void
xml2c_4A_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_4A_7) {
		cpssp->pin_4A_7 = val;
#if DEBUG
		fprintf(stderr, "pin 4A_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf5d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf5d0)(cpssp);
	}
}

static void
xml2c_23AII_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_23AII_12) {
		cpssp->pin_23AII_12 = val;
#if DEBUG
		fprintf(stderr, "pin 23AII_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf0f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf0f0)(cpssp);
	}
}

static void
xml2c_24AIII_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_24AIII_3) {
		cpssp->pin_24AIII_3 = val;
#if DEBUG
		fprintf(stderr, "pin 24AIII_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf0d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf0d0)(cpssp);
	}
}

static void
xml2c_24AII_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_24AII_12) {
		cpssp->pin_24AII_12 = val;
#if DEBUG
		fprintf(stderr, "pin 24AII_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf0b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf0b0)(cpssp);
	}
}

static void
xml2c_24AI_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_24AI_8) {
		cpssp->pin_24AI_8 = val;
#if DEBUG
		fprintf(stderr, "pin 24AI_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf090, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf090)(cpssp);
	}
}

static void
xml2c_25AIII_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_25AIII_3) {
		cpssp->pin_25AIII_3 = val;
#if DEBUG
		fprintf(stderr, "pin 25AIII_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf070, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf070)(cpssp);
	}
}

static void
xml2c_25AII_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_25AII_12) {
		cpssp->pin_25AII_12 = val;
#if DEBUG
		fprintf(stderr, "pin 25AII_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf050, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf050)(cpssp);
	}
}

static void
xml2c_25AI_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_25AI_8) {
		cpssp->pin_25AI_8 = val;
#if DEBUG
		fprintf(stderr, "pin 25AI_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf030, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf030)(cpssp);
	}
}

static void
xml2c_26AIII_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_26AIII_3) {
		cpssp->pin_26AIII_3 = val;
#if DEBUG
		fprintf(stderr, "pin 26AIII_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf010, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf010)(cpssp);
	}
}

static void
xml2c_26AII_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_26AII_12) {
		cpssp->pin_26AII_12 = val;
#if DEBUG
		fprintf(stderr, "pin 26AII_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbeff0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbeff0)(cpssp);
	}
}

static void
xml2c_26AI_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_26AI_8) {
		cpssp->pin_26AI_8 = val;
#if DEBUG
		fprintf(stderr, "pin 26AI_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbefd0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbefd0)(cpssp);
	}
}

static void
xml2c_27AIII_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_27AIII_3) {
		cpssp->pin_27AIII_3 = val;
#if DEBUG
		fprintf(stderr, "pin 27AIII_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbefb0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbefb0)(cpssp);
	}
}

static void
xml2c_27AII_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_27AII_12) {
		cpssp->pin_27AII_12 = val;
#if DEBUG
		fprintf(stderr, "pin 27AII_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef90, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef90)(cpssp);
	}
}

static void
xml2c_27AI_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_27AI_8) {
		cpssp->pin_27AI_8 = val;
#if DEBUG
		fprintf(stderr, "pin 27AI_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef70, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef70)(cpssp);
	}
}

static void
xml2c_28AIII_3_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_28AIII_3) {
		cpssp->pin_28AIII_3 = val;
#if DEBUG
		fprintf(stderr, "pin 28AIII_3 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef50, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef50)(cpssp);
	}
}

static void
xml2c_28AII_12_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_28AII_12) {
		cpssp->pin_28AII_12 = val;
#if DEBUG
		fprintf(stderr, "pin 28AII_12 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef10, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef10)(cpssp);
	}
}

static void
xml2c_28AI_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_28AI_8) {
		cpssp->pin_28AI_8 = val;
#if DEBUG
		fprintf(stderr, "pin 28AI_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbeef0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbeef0)(cpssp);
	}
}

static void
xml2c_21AVI_011_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AVI_011) {
		cpssp->pin_21AVI_011 = val;
#if DEBUG
		fprintf(stderr, "pin 21AVI_011 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_21AIV_08_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_21AIV_08) {
		cpssp->pin_21AIV_08 = val;
#if DEBUG
		fprintf(stderr, "pin 21AIV_08 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbef30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbef30)(cpssp);
	}
}

static void
xml2c_S0_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S0_5) {
		cpssp->pin_S0_5 = val;
#if DEBUG
		fprintf(stderr, "pin S0_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc5600, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc5600)(cpssp);
	}
}

static void
xml2c_S0_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S0_6) {
		cpssp->pin_S0_6 = val;
#if DEBUG
		fprintf(stderr, "pin S0_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc5750, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc5750)(cpssp);
	}
}

static void
xml2c_S0_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S0_7) {
		cpssp->pin_S0_7 = val;
#if DEBUG
		fprintf(stderr, "pin S0_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc58a0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc58a0)(cpssp);
	}
}

static void
xml2c_S0_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S0_8) {
		cpssp->pin_S0_8 = val;
#if DEBUG
		fprintf(stderr, "pin S0_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc59f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc59f0)(cpssp);
	}
}

static void
xml2c_S1_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S1_5) {
		cpssp->pin_S1_5 = val;
#if DEBUG
		fprintf(stderr, "pin S1_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc5de0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc5de0)(cpssp);
	}
}

static void
xml2c_S1_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S1_6) {
		cpssp->pin_S1_6 = val;
#if DEBUG
		fprintf(stderr, "pin S1_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc5f30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc5f30)(cpssp);
	}
}

static void
xml2c_S1_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S1_7) {
		cpssp->pin_S1_7 = val;
#if DEBUG
		fprintf(stderr, "pin S1_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc6080, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc6080)(cpssp);
	}
}

static void
xml2c_S1_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S1_8) {
		cpssp->pin_S1_8 = val;
#if DEBUG
		fprintf(stderr, "pin S1_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc61d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc61d0)(cpssp);
	}
}

static void
xml2c_S2_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S2_5) {
		cpssp->pin_S2_5 = val;
#if DEBUG
		fprintf(stderr, "pin S2_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc65c0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc65c0)(cpssp);
	}
}

static void
xml2c_S2_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S2_6) {
		cpssp->pin_S2_6 = val;
#if DEBUG
		fprintf(stderr, "pin S2_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc6710, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc6710)(cpssp);
	}
}

static void
xml2c_S2_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S2_7) {
		cpssp->pin_S2_7 = val;
#if DEBUG
		fprintf(stderr, "pin S2_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc6860, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc6860)(cpssp);
	}
}

static void
xml2c_S2_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S2_8) {
		cpssp->pin_S2_8 = val;
#if DEBUG
		fprintf(stderr, "pin S2_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc69b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc69b0)(cpssp);
	}
}

static void
xml2c_S3_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S3_5) {
		cpssp->pin_S3_5 = val;
#if DEBUG
		fprintf(stderr, "pin S3_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc6da0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc6da0)(cpssp);
	}
}

static void
xml2c_S3_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S3_6) {
		cpssp->pin_S3_6 = val;
#if DEBUG
		fprintf(stderr, "pin S3_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc6ef0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc6ef0)(cpssp);
	}
}

static void
xml2c_S3_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S3_7) {
		cpssp->pin_S3_7 = val;
#if DEBUG
		fprintf(stderr, "pin S3_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7040, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7040)(cpssp);
	}
}

static void
xml2c_S3_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S3_8) {
		cpssp->pin_S3_8 = val;
#if DEBUG
		fprintf(stderr, "pin S3_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7190, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7190)(cpssp);
	}
}

static void
xml2c_S4_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S4_5) {
		cpssp->pin_S4_5 = val;
#if DEBUG
		fprintf(stderr, "pin S4_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7580, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7580)(cpssp);
	}
}

static void
xml2c_S4_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S4_6) {
		cpssp->pin_S4_6 = val;
#if DEBUG
		fprintf(stderr, "pin S4_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc76d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc76d0)(cpssp);
	}
}

static void
xml2c_S4_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S4_7) {
		cpssp->pin_S4_7 = val;
#if DEBUG
		fprintf(stderr, "pin S4_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7820, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7820)(cpssp);
	}
}

static void
xml2c_S4_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S4_8) {
		cpssp->pin_S4_8 = val;
#if DEBUG
		fprintf(stderr, "pin S4_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7970, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7970)(cpssp);
	}
}

static void
xml2c_S5_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S5_5) {
		cpssp->pin_S5_5 = val;
#if DEBUG
		fprintf(stderr, "pin S5_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7d60, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7d60)(cpssp);
	}
}

static void
xml2c_S5_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S5_6) {
		cpssp->pin_S5_6 = val;
#if DEBUG
		fprintf(stderr, "pin S5_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc7eb0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc7eb0)(cpssp);
	}
}

static void
xml2c_S5_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S5_7) {
		cpssp->pin_S5_7 = val;
#if DEBUG
		fprintf(stderr, "pin S5_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8000, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8000)(cpssp);
	}
}

static void
xml2c_S5_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S5_8) {
		cpssp->pin_S5_8 = val;
#if DEBUG
		fprintf(stderr, "pin S5_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8150, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8150)(cpssp);
	}
}

static void
xml2c_S6_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S6_5) {
		cpssp->pin_S6_5 = val;
#if DEBUG
		fprintf(stderr, "pin S6_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8540, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8540)(cpssp);
	}
}

static void
xml2c_S6_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S6_6) {
		cpssp->pin_S6_6 = val;
#if DEBUG
		fprintf(stderr, "pin S6_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8690, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8690)(cpssp);
	}
}

static void
xml2c_S6_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S6_7) {
		cpssp->pin_S6_7 = val;
#if DEBUG
		fprintf(stderr, "pin S6_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc87e0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc87e0)(cpssp);
	}
}

static void
xml2c_S6_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S6_8) {
		cpssp->pin_S6_8 = val;
#if DEBUG
		fprintf(stderr, "pin S6_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8930, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8930)(cpssp);
	}
}

static void
xml2c_S7_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S7_5) {
		cpssp->pin_S7_5 = val;
#if DEBUG
		fprintf(stderr, "pin S7_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8d20, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8d20)(cpssp);
	}
}

static void
xml2c_S7_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S7_6) {
		cpssp->pin_S7_6 = val;
#if DEBUG
		fprintf(stderr, "pin S7_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8e70, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8e70)(cpssp);
	}
}

static void
xml2c_S7_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S7_7) {
		cpssp->pin_S7_7 = val;
#if DEBUG
		fprintf(stderr, "pin S7_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc8fc0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc8fc0)(cpssp);
	}
}

static void
xml2c_S7_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S7_8) {
		cpssp->pin_S7_8 = val;
#if DEBUG
		fprintf(stderr, "pin S7_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb6b50, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb6b50)(cpssp);
	}
}

static void
xml2c_S8_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S8_5) {
		cpssp->pin_S8_5 = val;
#if DEBUG
		fprintf(stderr, "pin S8_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc91c0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc91c0)(cpssp);
	}
}

static void
xml2c_S8_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S8_6) {
		cpssp->pin_S8_6 = val;
#if DEBUG
		fprintf(stderr, "pin S8_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc9310, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc9310)(cpssp);
	}
}

static void
xml2c_S8_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S8_7) {
		cpssp->pin_S8_7 = val;
#if DEBUG
		fprintf(stderr, "pin S8_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc9460, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc9460)(cpssp);
	}
}

static void
xml2c_S8_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S8_8) {
		cpssp->pin_S8_8 = val;
#if DEBUG
		fprintf(stderr, "pin S8_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc95b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc95b0)(cpssp);
	}
}

static void
xml2c_S9_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S9_5) {
		cpssp->pin_S9_5 = val;
#if DEBUG
		fprintf(stderr, "pin S9_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc99a0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc99a0)(cpssp);
	}
}

static void
xml2c_S9_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S9_6) {
		cpssp->pin_S9_6 = val;
#if DEBUG
		fprintf(stderr, "pin S9_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc9af0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc9af0)(cpssp);
	}
}

static void
xml2c_S9_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S9_7) {
		cpssp->pin_S9_7 = val;
#if DEBUG
		fprintf(stderr, "pin S9_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc9c40, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc9c40)(cpssp);
	}
}

static void
xml2c_S9_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S9_8) {
		cpssp->pin_S9_8 = val;
#if DEBUG
		fprintf(stderr, "pin S9_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bc9d90, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bc9d90)(cpssp);
	}
}

static void
xml2c_S10_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S10_5) {
		cpssp->pin_S10_5 = val;
#if DEBUG
		fprintf(stderr, "pin S10_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bca180, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bca180)(cpssp);
	}
}

static void
xml2c_S10_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S10_6) {
		cpssp->pin_S10_6 = val;
#if DEBUG
		fprintf(stderr, "pin S10_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bca2d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bca2d0)(cpssp);
	}
}

static void
xml2c_S10_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S10_7) {
		cpssp->pin_S10_7 = val;
#if DEBUG
		fprintf(stderr, "pin S10_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bca420, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bca420)(cpssp);
	}
}

static void
xml2c_S10_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S10_8) {
		cpssp->pin_S10_8 = val;
#if DEBUG
		fprintf(stderr, "pin S10_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bca570, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bca570)(cpssp);
	}
}

static void
xml2c_S11_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S11_5) {
		cpssp->pin_S11_5 = val;
#if DEBUG
		fprintf(stderr, "pin S11_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bca960, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bca960)(cpssp);
	}
}

static void
xml2c_S11_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S11_6) {
		cpssp->pin_S11_6 = val;
#if DEBUG
		fprintf(stderr, "pin S11_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcaab0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcaab0)(cpssp);
	}
}

static void
xml2c_S11_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S11_7) {
		cpssp->pin_S11_7 = val;
#if DEBUG
		fprintf(stderr, "pin S11_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcac00, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcac00)(cpssp);
	}
}

static void
xml2c_S11_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S11_8) {
		cpssp->pin_S11_8 = val;
#if DEBUG
		fprintf(stderr, "pin S11_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcad50, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcad50)(cpssp);
	}
}

static void
xml2c_S12_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S12_5) {
		cpssp->pin_S12_5 = val;
#if DEBUG
		fprintf(stderr, "pin S12_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcb140, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcb140)(cpssp);
	}
}

static void
xml2c_S12_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S12_6) {
		cpssp->pin_S12_6 = val;
#if DEBUG
		fprintf(stderr, "pin S12_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcb290, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcb290)(cpssp);
	}
}

static void
xml2c_S12_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S12_7) {
		cpssp->pin_S12_7 = val;
#if DEBUG
		fprintf(stderr, "pin S12_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcb3e0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcb3e0)(cpssp);
	}
}

static void
xml2c_S12_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S12_8) {
		cpssp->pin_S12_8 = val;
#if DEBUG
		fprintf(stderr, "pin S12_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcb530, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcb530)(cpssp);
	}
}

static void
xml2c_S13_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S13_5) {
		cpssp->pin_S13_5 = val;
#if DEBUG
		fprintf(stderr, "pin S13_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcb920, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcb920)(cpssp);
	}
}

static void
xml2c_S13_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S13_6) {
		cpssp->pin_S13_6 = val;
#if DEBUG
		fprintf(stderr, "pin S13_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcba70, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcba70)(cpssp);
	}
}

static void
xml2c_S13_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S13_7) {
		cpssp->pin_S13_7 = val;
#if DEBUG
		fprintf(stderr, "pin S13_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcbbc0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcbbc0)(cpssp);
	}
}

static void
xml2c_S13_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S13_8) {
		cpssp->pin_S13_8 = val;
#if DEBUG
		fprintf(stderr, "pin S13_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcbd10, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcbd10)(cpssp);
	}
}

static void
xml2c_S14_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S14_5) {
		cpssp->pin_S14_5 = val;
#if DEBUG
		fprintf(stderr, "pin S14_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcc100, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcc100)(cpssp);
	}
}

static void
xml2c_S14_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S14_6) {
		cpssp->pin_S14_6 = val;
#if DEBUG
		fprintf(stderr, "pin S14_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcc250, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcc250)(cpssp);
	}
}

static void
xml2c_S14_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S14_7) {
		cpssp->pin_S14_7 = val;
#if DEBUG
		fprintf(stderr, "pin S14_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcc3a0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcc3a0)(cpssp);
	}
}

static void
xml2c_S14_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S14_8) {
		cpssp->pin_S14_8 = val;
#if DEBUG
		fprintf(stderr, "pin S14_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcc4f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcc4f0)(cpssp);
	}
}

static void
xml2c_S15_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S15_5) {
		cpssp->pin_S15_5 = val;
#if DEBUG
		fprintf(stderr, "pin S15_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcc8e0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcc8e0)(cpssp);
	}
}

static void
xml2c_S15_6_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S15_6) {
		cpssp->pin_S15_6 = val;
#if DEBUG
		fprintf(stderr, "pin S15_6 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcca30, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcca30)(cpssp);
	}
}

static void
xml2c_S15_7_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S15_7) {
		cpssp->pin_S15_7 = val;
#if DEBUG
		fprintf(stderr, "pin S15_7 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bccb80, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bccb80)(cpssp);
	}
}

static void
xml2c_S15_8_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_S15_8) {
		cpssp->pin_S15_8 = val;
#if DEBUG
		fprintf(stderr, "pin S15_8 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bcccd0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bcccd0)(cpssp);
	}
}

static void
xml2c_15BI_10_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_15BI_10) {
		cpssp->pin_15BI_10 = val;
#if DEBUG
		fprintf(stderr, "pin 15BI_10 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf4b0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf4b0)(cpssp);
	}
}

static void
xml2c_16AVI_14_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_16AVI_14) {
		cpssp->pin_16AVI_14 = val;
#if DEBUG
		fprintf(stderr, "pin 16AVI_14 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bb8760, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bb8760)(cpssp);
	}
}

static void
xml2c_6AV_13_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_6AV_13) {
		cpssp->pin_6AV_13 = val;
#if DEBUG
		fprintf(stderr, "pin 6AV_13 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf470, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf470)(cpssp);
	}
}

static void
xml2c_16AV_13_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_16AV_13) {
		cpssp->pin_16AV_13 = val;
#if DEBUG
		fprintf(stderr, "pin 16AV_13 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf2d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf2d0)(cpssp);
	}
}

static void
xml2c_17B_5_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_17B_5) {
		cpssp->pin_17B_5 = val;
#if DEBUG
		fprintf(stderr, "pin 17B_5 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf3d0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf3d0)(cpssp);
	}
}

static void
xml2c_17B_4_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_17B_4) {
		cpssp->pin_17B_4 = val;
#if DEBUG
		fprintf(stderr, "pin 17B_4 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf3f0, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf3f0)(cpssp);
	}
}

static void
xml2c_6AVI_14_out_set(struct cpssp *cpssp, unsigned int val)

{
	if(val != cpssp->pin_6AVI_14) {
		cpssp->pin_6AVI_14 = val;
#if DEBUG
		fprintf(stderr, "pin 6AVI_14 sets to ");
		printlogic(val);
#endif /* DEBUG */
sig_std_logic_set(cpssp->gui_port_0x1bbf390, (void *) cpssp, val);
		COMP_(resolve_sig_0x1bbf390)(cpssp);
	}
}

/* ports */
static void
COMP_(port_Uhr1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_Uhr1) {
		cpssp->pin_Uhr1 = val;
#if DEBUG
		fprintf(stderr, "port Uhr1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf110), _cpssp);
	}
}

static void
COMP_(port_Uhr2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_Uhr2) {
		cpssp->pin_Uhr2 = val;
#if DEBUG
		fprintf(stderr, "port Uhr2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf130), _cpssp);
	}
}

static void
COMP_(port_Imp1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_Imp1) {
		cpssp->pin_Imp1 = val;
#if DEBUG
		fprintf(stderr, "port Imp1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf150), _cpssp);
	}
}

static void
COMP_(port_Imp2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_Imp2) {
		cpssp->pin_Imp2 = val;
#if DEBUG
		fprintf(stderr, "port Imp2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf170), _cpssp);
	}
}

static void
COMP_(port_22I1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I1) {
		cpssp->pin_22I1 = val;
#if DEBUG
		fprintf(stderr, "port 22I1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd210), _cpssp);
	}
}

static void
COMP_(port_22I2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I2) {
		cpssp->pin_22I2 = val;
#if DEBUG
		fprintf(stderr, "port 22I2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd360), _cpssp);
	}
}

static void
COMP_(port_22I3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I3) {
		cpssp->pin_22I3 = val;
#if DEBUG
		fprintf(stderr, "port 22I3 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd4b0), _cpssp);
	}
}

static void
COMP_(port_22I4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I4) {
		cpssp->pin_22I4 = val;
#if DEBUG
		fprintf(stderr, "port 22I4 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd600), _cpssp);
	}
}

static void
COMP_(port_22I5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I5) {
		cpssp->pin_22I5 = val;
#if DEBUG
		fprintf(stderr, "port 22I5 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd750), _cpssp);
	}
}

static void
COMP_(port_22I6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I6) {
		cpssp->pin_22I6 = val;
#if DEBUG
		fprintf(stderr, "port 22I6 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd8a0), _cpssp);
	}
}

static void
COMP_(port_22I7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I7) {
		cpssp->pin_22I7 = val;
#if DEBUG
		fprintf(stderr, "port 22I7 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd9f0), _cpssp);
	}
}

static void
COMP_(port_22I8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I8) {
		cpssp->pin_22I8 = val;
#if DEBUG
		fprintf(stderr, "port 22I8 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcdb40), _cpssp);
	}
}

static void
COMP_(port_22I9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I9) {
		cpssp->pin_22I9 = val;
#if DEBUG
		fprintf(stderr, "port 22I9 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcdc90), _cpssp);
	}
}

static void
COMP_(port_22I0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22I0) {
		cpssp->pin_22I0 = val;
#if DEBUG
		fprintf(stderr, "port 22I0 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcd0c0), _cpssp);
	}
}

static void
COMP_(port_22II1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II1) {
		cpssp->pin_22II1 = val;
#if DEBUG
		fprintf(stderr, "port 22II1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcdde0), _cpssp);
	}
}

static void
COMP_(port_22II2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II2) {
		cpssp->pin_22II2 = val;
#if DEBUG
		fprintf(stderr, "port 22II2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcdf30), _cpssp);
	}
}

static void
COMP_(port_22II3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II3) {
		cpssp->pin_22II3 = val;
#if DEBUG
		fprintf(stderr, "port 22II3 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce080), _cpssp);
	}
}

static void
COMP_(port_22II4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II4) {
		cpssp->pin_22II4 = val;
#if DEBUG
		fprintf(stderr, "port 22II4 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_22II5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II5) {
		cpssp->pin_22II5 = val;
#if DEBUG
		fprintf(stderr, "port 22II5 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce1d0), _cpssp);
	}
}

static void
COMP_(port_22II6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II6) {
		cpssp->pin_22II6 = val;
#if DEBUG
		fprintf(stderr, "port 22II6 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_22II7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II7) {
		cpssp->pin_22II7 = val;
#if DEBUG
		fprintf(stderr, "port 22II7 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce320), _cpssp);
	}
}

static void
COMP_(port_22II8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II8) {
		cpssp->pin_22II8 = val;
#if DEBUG
		fprintf(stderr, "port 22II8 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_22II9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II9) {
		cpssp->pin_22II9 = val;
#if DEBUG
		fprintf(stderr, "port 22II9 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce470), _cpssp);
	}
}

static void
COMP_(port_22II0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22II0) {
		cpssp->pin_22II0 = val;
#if DEBUG
		fprintf(stderr, "port 22II0 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_22III1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III1) {
		cpssp->pin_22III1 = val;
#if DEBUG
		fprintf(stderr, "port 22III1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce5c0), _cpssp);
	}
}

static void
COMP_(port_22III2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III2) {
		cpssp->pin_22III2 = val;
#if DEBUG
		fprintf(stderr, "port 22III2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce710), _cpssp);
	}
}

static void
COMP_(port_22III3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III3) {
		cpssp->pin_22III3 = val;
#if DEBUG
		fprintf(stderr, "port 22III3 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce860), _cpssp);
	}
}

static void
COMP_(port_22III4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III4) {
		cpssp->pin_22III4 = val;
#if DEBUG
		fprintf(stderr, "port 22III4 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bce9b0), _cpssp);
	}
}

static void
COMP_(port_22III5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III5) {
		cpssp->pin_22III5 = val;
#if DEBUG
		fprintf(stderr, "port 22III5 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bceb00), _cpssp);
	}
}

static void
COMP_(port_22III6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III6) {
		cpssp->pin_22III6 = val;
#if DEBUG
		fprintf(stderr, "port 22III6 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcec50), _cpssp);
	}
}

static void
COMP_(port_22III7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III7) {
		cpssp->pin_22III7 = val;
#if DEBUG
		fprintf(stderr, "port 22III7 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bceda0), _cpssp);
	}
}

static void
COMP_(port_22III8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III8) {
		cpssp->pin_22III8 = val;
#if DEBUG
		fprintf(stderr, "port 22III8 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bceef0), _cpssp);
	}
}

static void
COMP_(port_22III9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III9) {
		cpssp->pin_22III9 = val;
#if DEBUG
		fprintf(stderr, "port 22III9 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf040), _cpssp);
	}
}

static void
COMP_(port_22III0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_22III0) {
		cpssp->pin_22III0 = val;
#if DEBUG
		fprintf(stderr, "port 22III0 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30I1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I1) {
		cpssp->pin_30I1 = val;
#if DEBUG
		fprintf(stderr, "port 30I1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf190), _cpssp);
	}
}

static void
COMP_(port_30I2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I2) {
		cpssp->pin_30I2 = val;
#if DEBUG
		fprintf(stderr, "port 30I2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf2e0), _cpssp);
	}
}

static void
COMP_(port_30I3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I3) {
		cpssp->pin_30I3 = val;
#if DEBUG
		fprintf(stderr, "port 30I3 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf5f0), _cpssp);
	}
}

static void
COMP_(port_30I4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I4) {
		cpssp->pin_30I4 = val;
#if DEBUG
		fprintf(stderr, "port 30I4 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf6d0), _cpssp);
	}
}

static void
COMP_(port_30I5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I5) {
		cpssp->pin_30I5 = val;
#if DEBUG
		fprintf(stderr, "port 30I5 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf6f0), _cpssp);
	}
}

static void
COMP_(port_30I6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I6) {
		cpssp->pin_30I6 = val;
#if DEBUG
		fprintf(stderr, "port 30I6 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf670), _cpssp);
	}
}

static void
COMP_(port_30I7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I7) {
		cpssp->pin_30I7 = val;
#if DEBUG
		fprintf(stderr, "port 30I7 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbed50), _cpssp);
	}
}

static void
COMP_(port_30I8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I8) {
		cpssp->pin_30I8 = val;
#if DEBUG
		fprintf(stderr, "port 30I8 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbea10), _cpssp);
	}
}

static void
COMP_(port_30I9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I9) {
		cpssp->pin_30I9 = val;
#if DEBUG
		fprintf(stderr, "port 30I9 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf430), _cpssp);
	}
}

static void
COMP_(port_30I0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30I0) {
		cpssp->pin_30I0 = val;
#if DEBUG
		fprintf(stderr, "port 30I0 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb9630), _cpssp);
	}
}

static void
COMP_(port_30II1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II1) {
		cpssp->pin_30II1 = val;
#if DEBUG
		fprintf(stderr, "port 30II1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30II2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II2) {
		cpssp->pin_30II2 = val;
#if DEBUG
		fprintf(stderr, "port 30II2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30II3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II3) {
		cpssp->pin_30II3 = val;
#if DEBUG
		fprintf(stderr, "port 30II3 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30II4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II4) {
		cpssp->pin_30II4 = val;
#if DEBUG
		fprintf(stderr, "port 30II4 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30II5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II5) {
		cpssp->pin_30II5 = val;
#if DEBUG
		fprintf(stderr, "port 30II5 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30II6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II6) {
		cpssp->pin_30II6 = val;
#if DEBUG
		fprintf(stderr, "port 30II6 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8760), _cpssp);
	}
}

static void
COMP_(port_30II7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II7) {
		cpssp->pin_30II7 = val;
#if DEBUG
		fprintf(stderr, "port 30II7 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbec70), _cpssp);
	}
}

static void
COMP_(port_30II8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II8) {
		cpssp->pin_30II8 = val;
#if DEBUG
		fprintf(stderr, "port 30II8 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb8550), _cpssp);
	}
}

static void
COMP_(port_30II9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II9) {
		cpssp->pin_30II9 = val;
#if DEBUG
		fprintf(stderr, "port 30II9 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf580), _cpssp);
	}
}

static void
COMP_(port_30II0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30II0) {
		cpssp->pin_30II0 = val;
#if DEBUG
		fprintf(stderr, "port 30II0 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf4d0), _cpssp);
	}
}

static void
COMP_(port_30III1_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III1) {
		cpssp->pin_30III1 = val;
#if DEBUG
		fprintf(stderr, "port 30III1 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf820), _cpssp);
	}
}

static void
COMP_(port_30III2_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III2) {
		cpssp->pin_30III2 = val;
#if DEBUG
		fprintf(stderr, "port 30III2 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf970), _cpssp);
	}
}

static void
COMP_(port_30III3_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III3) {
		cpssp->pin_30III3 = val;
#if DEBUG
		fprintf(stderr, "port 30III3 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcfac0), _cpssp);
	}
}

static void
COMP_(port_30III4_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III4) {
		cpssp->pin_30III4 = val;
#if DEBUG
		fprintf(stderr, "port 30III4 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcfc10), _cpssp);
	}
}

static void
COMP_(port_30III5_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III5) {
		cpssp->pin_30III5 = val;
#if DEBUG
		fprintf(stderr, "port 30III5 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcfd60), _cpssp);
	}
}

static void
COMP_(port_30III6_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III6) {
		cpssp->pin_30III6 = val;
#if DEBUG
		fprintf(stderr, "port 30III6 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf290), _cpssp);
	}
}

static void
COMP_(port_30III7_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III7) {
		cpssp->pin_30III7 = val;
#if DEBUG
		fprintf(stderr, "port 30III7 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bbf490), _cpssp);
	}
}

static void
COMP_(port_30III8_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III8) {
		cpssp->pin_30III8 = val;
#if DEBUG
		fprintf(stderr, "port 30III8 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bb9650), _cpssp);
	}
}

static void
COMP_(port_30III9_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III9) {
		cpssp->pin_30III9 = val;
#if DEBUG
		fprintf(stderr, "port 30III9 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcfeb0), _cpssp);
	}
}

static void
COMP_(port_30III0_set)(void *_cpssp, unsigned int val)
{
	struct cpssp *cpssp = _cpssp;

	if(val != cpssp->pin_30III0) {
		cpssp->pin_30III0 = val;
#if DEBUG
		fprintf(stderr, "port 30III0 sets to ");
		printlogic(val);
#endif /* DEBUG */
		time_call_after(1, COMP_(resolve_sig_0x1bcf6d0), _cpssp);
	}
}

/* gui ports */
static void
COMP_(gui_port_0x1bb8760_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb8760 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb9650_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb9650 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb9630_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb9630 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb69a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb69a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb82f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb82f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb81b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb81b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb8f00_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb8f00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb3b20_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb3b20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb6a40_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb6a40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb8550_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb8550 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb6980_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb6980 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb8190_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb8190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb6640_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb6640 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbe9b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbe9b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbe9d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbe9d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbe9f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbe9f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbea10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbea10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbea30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbea30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbea50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbea50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbea70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbea70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbea90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbea90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeab0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeab0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbead0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbead0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeaf0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeaf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeb10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeb10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeb30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeb30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeb50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeb50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeb70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeb70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeb90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeb90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbebb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbebb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbebd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbebd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbebf0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbebf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbec10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbec10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbec30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbec30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbec50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbec50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbec70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbec70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbec90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbec90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbecb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbecb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbecd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbecd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbecf0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbecf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbed10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbed10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbed30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbed30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbed50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbed50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbed70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbed70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbed90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbed90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbedb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbedb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbedd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbedd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbedf0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbedf0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbee10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbee10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbee30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbee30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbee50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbee50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbee70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbee70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbee90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbee90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeeb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeeb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeed0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeed0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeef0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeef0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbef10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbef10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbef30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbef30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbef50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbef50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbef70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbef70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbef90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbef90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbefb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbefb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbefd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbefd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbeff0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbeff0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf010_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf010 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf030_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf030 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf050_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf050 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf070_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf070 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf090_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf090 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf0b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf0b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf0d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf0d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf0f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf0f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf110_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf110 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf130_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf130 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf150_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf150 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf170_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf170 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf190_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf1b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf1b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf1d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf1d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf1f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf1f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf210_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf210 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf230_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf230 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf250_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf270_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf270 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf290_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf290 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf2b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf2b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf2d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf2d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf2f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf2f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf310_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf310 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf330_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf330 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf350_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf350 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf370_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf370 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf390_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf390 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf3b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf3b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf3d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf3d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf3f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf3f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf410_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf410 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf430_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf430 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf450_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf450 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf470_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf470 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf490_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf490 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf4b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf4b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf4d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf4d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf4f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf4f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf510_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf510 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf530_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf530 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf550_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf550 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf570_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf570 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf590_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf590 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf5b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf5b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf5d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf5d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf5f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf5f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf610_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf610 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf630_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf630 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf650_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf650 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf670_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf670 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf690_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf690 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf6b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf6b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf6d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf6d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf6f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf6f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf710_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf710 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf730_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf730 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bbf750_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bbf750 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc05f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc05f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc0740_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc0740 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc0890_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc0890 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc09e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc09e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc0b30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc0b30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc0c80_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc0c80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc0dd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc0dd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc0f20_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc0f20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1070_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1070 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc11c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc11c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1310_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1310 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1460_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1460 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc15b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc15b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1700_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1700 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1850_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1850 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc19a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc19a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1af0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1af0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1c40_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1c40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1d90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1d90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc1ee0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc1ee0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2030_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2030 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2180_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2180 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc22d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc22d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2420_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2420 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2570_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2570 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc26c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc26c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2810_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2810 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2960_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2960 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2ab0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2ab0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2c00_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2c00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2d50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2d50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2ea0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2ea0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc2ff0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc2ff0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3140_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3140 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3290_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3290 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc33e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc33e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3530_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3530 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3680_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3680 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc37d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc37d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3920_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3920 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3a70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3a70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3bc0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3bc0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3d10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3d10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3e60_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3e60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc3fb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc3fb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4100_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4100 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4250_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc43a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc43a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc44f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc44f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4640_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4640 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4790_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4790 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc48e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc48e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4a30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4a30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4b80_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4b80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4cd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4cd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4e20_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4e20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc4f70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc4f70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc50c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc50c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5210_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5210 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5360_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5360 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc54b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc54b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5600_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5600 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5750_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5750 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc58a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc58a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc59f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc59f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5b40_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5b40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5c90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5c90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5de0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5de0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc5f30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc5f30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6080_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6080 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc61d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc61d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6320_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6320 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6470_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6470 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc65c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc65c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6710_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6710 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6860_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6860 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc69b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc69b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6b00_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6b00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6c50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6c50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6da0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6da0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc6ef0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc6ef0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7040_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7040 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7190_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc72e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc72e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7430_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7430 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7580_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7580 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc76d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc76d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7820_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7820 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7970_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7970 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7ac0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7ac0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7c10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7c10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7d60_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7d60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc7eb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc7eb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8000_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8000 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8150_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8150 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc82a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc82a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc83f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc83f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8540_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8540 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8690_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8690 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc87e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc87e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8930_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8930 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8a80_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8a80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8bd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8bd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8d20_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8d20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8e70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8e70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc8fc0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc8fc0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb6b50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb6b50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb8250_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb8250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bb82b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bb82b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc91c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc91c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9310_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9310 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9460_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9460 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc95b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc95b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9700_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9700 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9850_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9850 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc99a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc99a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9af0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9af0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9c40_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9c40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9d90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9d90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bc9ee0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bc9ee0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca030_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca030 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca180_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca180 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca2d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca2d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca420_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca420 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca570_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca570 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca6c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca6c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca810_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca810 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bca960_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bca960 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcaab0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcaab0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcac00_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcac00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcad50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcad50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcaea0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcaea0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcaff0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcaff0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb140_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb140 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb290_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb290 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb3e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb3e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb530_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb530 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb680_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb680 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb7d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb7d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcb920_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcb920 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcba70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcba70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcbbc0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcbbc0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcbd10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcbd10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcbe60_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcbe60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcbfb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcbfb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc100_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc100 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc250_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc250 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc3a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc3a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc4f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc4f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc640_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc640 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc790_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc790 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcc8e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcc8e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcca30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcca30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bccb80_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bccb80 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcccd0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcccd0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcce20_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcce20 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bccf70_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bccf70 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd0c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd0c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd210_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd210 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd360_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd360 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd4b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd4b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd600_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd600 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd750_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd750 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd8a0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd8a0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcd9f0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcd9f0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcdb40_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcdb40 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcdc90_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcdc90 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcdde0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcdde0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcdf30_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcdf30 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce080_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce080 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce1d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce1d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce320_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce320 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce470_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce470 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce5c0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce5c0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce710_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce710 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce860_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce860 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bce9b0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bce9b0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bceb00_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bceb00 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcec50_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcec50 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bceda0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bceda0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bceef0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bceef0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf040_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf040 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf190_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf190 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf2e0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf2e0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf430_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf430 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf580_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf580 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf6d0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf6d0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf820_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf820 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcf970_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcf970 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcfac0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcfac0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcfc10_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcfc10 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcfd60_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcfd60 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
static void
COMP_(gui_port_0x1bcfeb0_set)(void *_cpssp, unsigned int val)
{
#if DEBUG
	fprintf(stderr, "gui_port_0x1bcfeb0 sets to ");
	printlogic(val);
#endif /* DEBUG */
}
void *
COMP_(create)(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_Uhr1,
	struct sig_std_logic *port_Uhr2,
	struct sig_std_logic *port_Imp1,
	struct sig_std_logic *port_Imp2,
	struct sig_std_logic *port_22I1,
	struct sig_std_logic *port_22I2,
	struct sig_std_logic *port_22I3,
	struct sig_std_logic *port_22I4,
	struct sig_std_logic *port_22I5,
	struct sig_std_logic *port_22I6,
	struct sig_std_logic *port_22I7,
	struct sig_std_logic *port_22I8,
	struct sig_std_logic *port_22I9,
	struct sig_std_logic *port_22I0,
	struct sig_std_logic *port_22II1,
	struct sig_std_logic *port_22II2,
	struct sig_std_logic *port_22II3,
	struct sig_std_logic *port_22II4,
	struct sig_std_logic *port_22II5,
	struct sig_std_logic *port_22II6,
	struct sig_std_logic *port_22II7,
	struct sig_std_logic *port_22II8,
	struct sig_std_logic *port_22II9,
	struct sig_std_logic *port_22II0,
	struct sig_std_logic *port_22III1,
	struct sig_std_logic *port_22III2,
	struct sig_std_logic *port_22III3,
	struct sig_std_logic *port_22III4,
	struct sig_std_logic *port_22III5,
	struct sig_std_logic *port_22III6,
	struct sig_std_logic *port_22III7,
	struct sig_std_logic *port_22III8,
	struct sig_std_logic *port_22III9,
	struct sig_std_logic *port_22III0,
	struct sig_std_logic *port_30I1,
	struct sig_std_logic *port_30I2,
	struct sig_std_logic *port_30I3,
	struct sig_std_logic *port_30I4,
	struct sig_std_logic *port_30I5,
	struct sig_std_logic *port_30I6,
	struct sig_std_logic *port_30I7,
	struct sig_std_logic *port_30I8,
	struct sig_std_logic *port_30I9,
	struct sig_std_logic *port_30I0,
	struct sig_std_logic *port_30II1,
	struct sig_std_logic *port_30II2,
	struct sig_std_logic *port_30II3,
	struct sig_std_logic *port_30II4,
	struct sig_std_logic *port_30II5,
	struct sig_std_logic *port_30II6,
	struct sig_std_logic *port_30II7,
	struct sig_std_logic *port_30II8,
	struct sig_std_logic *port_30II9,
	struct sig_std_logic *port_30II0,
	struct sig_std_logic *port_30III1,
	struct sig_std_logic *port_30III2,
	struct sig_std_logic *port_30III3,
	struct sig_std_logic *port_30III4,
	struct sig_std_logic *port_30III5,
	struct sig_std_logic *port_30III6,
	struct sig_std_logic *port_30III7,
	struct sig_std_logic *port_30III8,
	struct sig_std_logic *port_30III9,
	struct sig_std_logic *port_30III0,
	struct sig_std_logic *gui_port_0x1bb8760,
	struct sig_std_logic *gui_port_0x1bb9650,
	struct sig_std_logic *gui_port_0x1bb9630,
	struct sig_std_logic *gui_port_0x1bb69a0,
	struct sig_std_logic *gui_port_0x1bb82f0,
	struct sig_std_logic *gui_port_0x1bb81b0,
	struct sig_std_logic *gui_port_0x1bb8f00,
	struct sig_std_logic *gui_port_0x1bb3b20,
	struct sig_std_logic *gui_port_0x1bb6a40,
	struct sig_std_logic *gui_port_0x1bb8550,
	struct sig_std_logic *gui_port_0x1bb6980,
	struct sig_std_logic *gui_port_0x1bb8190,
	struct sig_std_logic *gui_port_0x1bb6640,
	struct sig_std_logic *gui_port_0x1bbe9b0,
	struct sig_std_logic *gui_port_0x1bbe9d0,
	struct sig_std_logic *gui_port_0x1bbe9f0,
	struct sig_std_logic *gui_port_0x1bbea10,
	struct sig_std_logic *gui_port_0x1bbea30,
	struct sig_std_logic *gui_port_0x1bbea50,
	struct sig_std_logic *gui_port_0x1bbea70,
	struct sig_std_logic *gui_port_0x1bbea90,
	struct sig_std_logic *gui_port_0x1bbeab0,
	struct sig_std_logic *gui_port_0x1bbead0,
	struct sig_std_logic *gui_port_0x1bbeaf0,
	struct sig_std_logic *gui_port_0x1bbeb10,
	struct sig_std_logic *gui_port_0x1bbeb30,
	struct sig_std_logic *gui_port_0x1bbeb50,
	struct sig_std_logic *gui_port_0x1bbeb70,
	struct sig_std_logic *gui_port_0x1bbeb90,
	struct sig_std_logic *gui_port_0x1bbebb0,
	struct sig_std_logic *gui_port_0x1bbebd0,
	struct sig_std_logic *gui_port_0x1bbebf0,
	struct sig_std_logic *gui_port_0x1bbec10,
	struct sig_std_logic *gui_port_0x1bbec30,
	struct sig_std_logic *gui_port_0x1bbec50,
	struct sig_std_logic *gui_port_0x1bbec70,
	struct sig_std_logic *gui_port_0x1bbec90,
	struct sig_std_logic *gui_port_0x1bbecb0,
	struct sig_std_logic *gui_port_0x1bbecd0,
	struct sig_std_logic *gui_port_0x1bbecf0,
	struct sig_std_logic *gui_port_0x1bbed10,
	struct sig_std_logic *gui_port_0x1bbed30,
	struct sig_std_logic *gui_port_0x1bbed50,
	struct sig_std_logic *gui_port_0x1bbed70,
	struct sig_std_logic *gui_port_0x1bbed90,
	struct sig_std_logic *gui_port_0x1bbedb0,
	struct sig_std_logic *gui_port_0x1bbedd0,
	struct sig_std_logic *gui_port_0x1bbedf0,
	struct sig_std_logic *gui_port_0x1bbee10,
	struct sig_std_logic *gui_port_0x1bbee30,
	struct sig_std_logic *gui_port_0x1bbee50,
	struct sig_std_logic *gui_port_0x1bbee70,
	struct sig_std_logic *gui_port_0x1bbee90,
	struct sig_std_logic *gui_port_0x1bbeeb0,
	struct sig_std_logic *gui_port_0x1bbeed0,
	struct sig_std_logic *gui_port_0x1bbeef0,
	struct sig_std_logic *gui_port_0x1bbef10,
	struct sig_std_logic *gui_port_0x1bbef30,
	struct sig_std_logic *gui_port_0x1bbef50,
	struct sig_std_logic *gui_port_0x1bbef70,
	struct sig_std_logic *gui_port_0x1bbef90,
	struct sig_std_logic *gui_port_0x1bbefb0,
	struct sig_std_logic *gui_port_0x1bbefd0,
	struct sig_std_logic *gui_port_0x1bbeff0,
	struct sig_std_logic *gui_port_0x1bbf010,
	struct sig_std_logic *gui_port_0x1bbf030,
	struct sig_std_logic *gui_port_0x1bbf050,
	struct sig_std_logic *gui_port_0x1bbf070,
	struct sig_std_logic *gui_port_0x1bbf090,
	struct sig_std_logic *gui_port_0x1bbf0b0,
	struct sig_std_logic *gui_port_0x1bbf0d0,
	struct sig_std_logic *gui_port_0x1bbf0f0,
	struct sig_std_logic *gui_port_0x1bbf110,
	struct sig_std_logic *gui_port_0x1bbf130,
	struct sig_std_logic *gui_port_0x1bbf150,
	struct sig_std_logic *gui_port_0x1bbf170,
	struct sig_std_logic *gui_port_0x1bbf190,
	struct sig_std_logic *gui_port_0x1bbf1b0,
	struct sig_std_logic *gui_port_0x1bbf1d0,
	struct sig_std_logic *gui_port_0x1bbf1f0,
	struct sig_std_logic *gui_port_0x1bbf210,
	struct sig_std_logic *gui_port_0x1bbf230,
	struct sig_std_logic *gui_port_0x1bbf250,
	struct sig_std_logic *gui_port_0x1bbf270,
	struct sig_std_logic *gui_port_0x1bbf290,
	struct sig_std_logic *gui_port_0x1bbf2b0,
	struct sig_std_logic *gui_port_0x1bbf2d0,
	struct sig_std_logic *gui_port_0x1bbf2f0,
	struct sig_std_logic *gui_port_0x1bbf310,
	struct sig_std_logic *gui_port_0x1bbf330,
	struct sig_std_logic *gui_port_0x1bbf350,
	struct sig_std_logic *gui_port_0x1bbf370,
	struct sig_std_logic *gui_port_0x1bbf390,
	struct sig_std_logic *gui_port_0x1bbf3b0,
	struct sig_std_logic *gui_port_0x1bbf3d0,
	struct sig_std_logic *gui_port_0x1bbf3f0,
	struct sig_std_logic *gui_port_0x1bbf410,
	struct sig_std_logic *gui_port_0x1bbf430,
	struct sig_std_logic *gui_port_0x1bbf450,
	struct sig_std_logic *gui_port_0x1bbf470,
	struct sig_std_logic *gui_port_0x1bbf490,
	struct sig_std_logic *gui_port_0x1bbf4b0,
	struct sig_std_logic *gui_port_0x1bbf4d0,
	struct sig_std_logic *gui_port_0x1bbf4f0,
	struct sig_std_logic *gui_port_0x1bbf510,
	struct sig_std_logic *gui_port_0x1bbf530,
	struct sig_std_logic *gui_port_0x1bbf550,
	struct sig_std_logic *gui_port_0x1bbf570,
	struct sig_std_logic *gui_port_0x1bbf590,
	struct sig_std_logic *gui_port_0x1bbf5b0,
	struct sig_std_logic *gui_port_0x1bbf5d0,
	struct sig_std_logic *gui_port_0x1bbf5f0,
	struct sig_std_logic *gui_port_0x1bbf610,
	struct sig_std_logic *gui_port_0x1bbf630,
	struct sig_std_logic *gui_port_0x1bbf650,
	struct sig_std_logic *gui_port_0x1bbf670,
	struct sig_std_logic *gui_port_0x1bbf690,
	struct sig_std_logic *gui_port_0x1bbf6b0,
	struct sig_std_logic *gui_port_0x1bbf6d0,
	struct sig_std_logic *gui_port_0x1bbf6f0,
	struct sig_std_logic *gui_port_0x1bbf710,
	struct sig_std_logic *gui_port_0x1bbf730,
	struct sig_std_logic *gui_port_0x1bbf750,
	struct sig_std_logic *gui_port_0x1bc05f0,
	struct sig_std_logic *gui_port_0x1bc0740,
	struct sig_std_logic *gui_port_0x1bc0890,
	struct sig_std_logic *gui_port_0x1bc09e0,
	struct sig_std_logic *gui_port_0x1bc0b30,
	struct sig_std_logic *gui_port_0x1bc0c80,
	struct sig_std_logic *gui_port_0x1bc0dd0,
	struct sig_std_logic *gui_port_0x1bc0f20,
	struct sig_std_logic *gui_port_0x1bc1070,
	struct sig_std_logic *gui_port_0x1bc11c0,
	struct sig_std_logic *gui_port_0x1bc1310,
	struct sig_std_logic *gui_port_0x1bc1460,
	struct sig_std_logic *gui_port_0x1bc15b0,
	struct sig_std_logic *gui_port_0x1bc1700,
	struct sig_std_logic *gui_port_0x1bc1850,
	struct sig_std_logic *gui_port_0x1bc19a0,
	struct sig_std_logic *gui_port_0x1bc1af0,
	struct sig_std_logic *gui_port_0x1bc1c40,
	struct sig_std_logic *gui_port_0x1bc1d90,
	struct sig_std_logic *gui_port_0x1bc1ee0,
	struct sig_std_logic *gui_port_0x1bc2030,
	struct sig_std_logic *gui_port_0x1bc2180,
	struct sig_std_logic *gui_port_0x1bc22d0,
	struct sig_std_logic *gui_port_0x1bc2420,
	struct sig_std_logic *gui_port_0x1bc2570,
	struct sig_std_logic *gui_port_0x1bc26c0,
	struct sig_std_logic *gui_port_0x1bc2810,
	struct sig_std_logic *gui_port_0x1bc2960,
	struct sig_std_logic *gui_port_0x1bc2ab0,
	struct sig_std_logic *gui_port_0x1bc2c00,
	struct sig_std_logic *gui_port_0x1bc2d50,
	struct sig_std_logic *gui_port_0x1bc2ea0,
	struct sig_std_logic *gui_port_0x1bc2ff0,
	struct sig_std_logic *gui_port_0x1bc3140,
	struct sig_std_logic *gui_port_0x1bc3290,
	struct sig_std_logic *gui_port_0x1bc33e0,
	struct sig_std_logic *gui_port_0x1bc3530,
	struct sig_std_logic *gui_port_0x1bc3680,
	struct sig_std_logic *gui_port_0x1bc37d0,
	struct sig_std_logic *gui_port_0x1bc3920,
	struct sig_std_logic *gui_port_0x1bc3a70,
	struct sig_std_logic *gui_port_0x1bc3bc0,
	struct sig_std_logic *gui_port_0x1bc3d10,
	struct sig_std_logic *gui_port_0x1bc3e60,
	struct sig_std_logic *gui_port_0x1bc3fb0,
	struct sig_std_logic *gui_port_0x1bc4100,
	struct sig_std_logic *gui_port_0x1bc4250,
	struct sig_std_logic *gui_port_0x1bc43a0,
	struct sig_std_logic *gui_port_0x1bc44f0,
	struct sig_std_logic *gui_port_0x1bc4640,
	struct sig_std_logic *gui_port_0x1bc4790,
	struct sig_std_logic *gui_port_0x1bc48e0,
	struct sig_std_logic *gui_port_0x1bc4a30,
	struct sig_std_logic *gui_port_0x1bc4b80,
	struct sig_std_logic *gui_port_0x1bc4cd0,
	struct sig_std_logic *gui_port_0x1bc4e20,
	struct sig_std_logic *gui_port_0x1bc4f70,
	struct sig_std_logic *gui_port_0x1bc50c0,
	struct sig_std_logic *gui_port_0x1bc5210,
	struct sig_std_logic *gui_port_0x1bc5360,
	struct sig_std_logic *gui_port_0x1bc54b0,
	struct sig_std_logic *gui_port_0x1bc5600,
	struct sig_std_logic *gui_port_0x1bc5750,
	struct sig_std_logic *gui_port_0x1bc58a0,
	struct sig_std_logic *gui_port_0x1bc59f0,
	struct sig_std_logic *gui_port_0x1bc5b40,
	struct sig_std_logic *gui_port_0x1bc5c90,
	struct sig_std_logic *gui_port_0x1bc5de0,
	struct sig_std_logic *gui_port_0x1bc5f30,
	struct sig_std_logic *gui_port_0x1bc6080,
	struct sig_std_logic *gui_port_0x1bc61d0,
	struct sig_std_logic *gui_port_0x1bc6320,
	struct sig_std_logic *gui_port_0x1bc6470,
	struct sig_std_logic *gui_port_0x1bc65c0,
	struct sig_std_logic *gui_port_0x1bc6710,
	struct sig_std_logic *gui_port_0x1bc6860,
	struct sig_std_logic *gui_port_0x1bc69b0,
	struct sig_std_logic *gui_port_0x1bc6b00,
	struct sig_std_logic *gui_port_0x1bc6c50,
	struct sig_std_logic *gui_port_0x1bc6da0,
	struct sig_std_logic *gui_port_0x1bc6ef0,
	struct sig_std_logic *gui_port_0x1bc7040,
	struct sig_std_logic *gui_port_0x1bc7190,
	struct sig_std_logic *gui_port_0x1bc72e0,
	struct sig_std_logic *gui_port_0x1bc7430,
	struct sig_std_logic *gui_port_0x1bc7580,
	struct sig_std_logic *gui_port_0x1bc76d0,
	struct sig_std_logic *gui_port_0x1bc7820,
	struct sig_std_logic *gui_port_0x1bc7970,
	struct sig_std_logic *gui_port_0x1bc7ac0,
	struct sig_std_logic *gui_port_0x1bc7c10,
	struct sig_std_logic *gui_port_0x1bc7d60,
	struct sig_std_logic *gui_port_0x1bc7eb0,
	struct sig_std_logic *gui_port_0x1bc8000,
	struct sig_std_logic *gui_port_0x1bc8150,
	struct sig_std_logic *gui_port_0x1bc82a0,
	struct sig_std_logic *gui_port_0x1bc83f0,
	struct sig_std_logic *gui_port_0x1bc8540,
	struct sig_std_logic *gui_port_0x1bc8690,
	struct sig_std_logic *gui_port_0x1bc87e0,
	struct sig_std_logic *gui_port_0x1bc8930,
	struct sig_std_logic *gui_port_0x1bc8a80,
	struct sig_std_logic *gui_port_0x1bc8bd0,
	struct sig_std_logic *gui_port_0x1bc8d20,
	struct sig_std_logic *gui_port_0x1bc8e70,
	struct sig_std_logic *gui_port_0x1bc8fc0,
	struct sig_std_logic *gui_port_0x1bb6b50,
	struct sig_std_logic *gui_port_0x1bb8250,
	struct sig_std_logic *gui_port_0x1bb82b0,
	struct sig_std_logic *gui_port_0x1bc91c0,
	struct sig_std_logic *gui_port_0x1bc9310,
	struct sig_std_logic *gui_port_0x1bc9460,
	struct sig_std_logic *gui_port_0x1bc95b0,
	struct sig_std_logic *gui_port_0x1bc9700,
	struct sig_std_logic *gui_port_0x1bc9850,
	struct sig_std_logic *gui_port_0x1bc99a0,
	struct sig_std_logic *gui_port_0x1bc9af0,
	struct sig_std_logic *gui_port_0x1bc9c40,
	struct sig_std_logic *gui_port_0x1bc9d90,
	struct sig_std_logic *gui_port_0x1bc9ee0,
	struct sig_std_logic *gui_port_0x1bca030,
	struct sig_std_logic *gui_port_0x1bca180,
	struct sig_std_logic *gui_port_0x1bca2d0,
	struct sig_std_logic *gui_port_0x1bca420,
	struct sig_std_logic *gui_port_0x1bca570,
	struct sig_std_logic *gui_port_0x1bca6c0,
	struct sig_std_logic *gui_port_0x1bca810,
	struct sig_std_logic *gui_port_0x1bca960,
	struct sig_std_logic *gui_port_0x1bcaab0,
	struct sig_std_logic *gui_port_0x1bcac00,
	struct sig_std_logic *gui_port_0x1bcad50,
	struct sig_std_logic *gui_port_0x1bcaea0,
	struct sig_std_logic *gui_port_0x1bcaff0,
	struct sig_std_logic *gui_port_0x1bcb140,
	struct sig_std_logic *gui_port_0x1bcb290,
	struct sig_std_logic *gui_port_0x1bcb3e0,
	struct sig_std_logic *gui_port_0x1bcb530,
	struct sig_std_logic *gui_port_0x1bcb680,
	struct sig_std_logic *gui_port_0x1bcb7d0,
	struct sig_std_logic *gui_port_0x1bcb920,
	struct sig_std_logic *gui_port_0x1bcba70,
	struct sig_std_logic *gui_port_0x1bcbbc0,
	struct sig_std_logic *gui_port_0x1bcbd10,
	struct sig_std_logic *gui_port_0x1bcbe60,
	struct sig_std_logic *gui_port_0x1bcbfb0,
	struct sig_std_logic *gui_port_0x1bcc100,
	struct sig_std_logic *gui_port_0x1bcc250,
	struct sig_std_logic *gui_port_0x1bcc3a0,
	struct sig_std_logic *gui_port_0x1bcc4f0,
	struct sig_std_logic *gui_port_0x1bcc640,
	struct sig_std_logic *gui_port_0x1bcc790,
	struct sig_std_logic *gui_port_0x1bcc8e0,
	struct sig_std_logic *gui_port_0x1bcca30,
	struct sig_std_logic *gui_port_0x1bccb80,
	struct sig_std_logic *gui_port_0x1bcccd0,
	struct sig_std_logic *gui_port_0x1bcce20,
	struct sig_std_logic *gui_port_0x1bccf70,
	struct sig_std_logic *gui_port_0x1bcd0c0,
	struct sig_std_logic *gui_port_0x1bcd210,
	struct sig_std_logic *gui_port_0x1bcd360,
	struct sig_std_logic *gui_port_0x1bcd4b0,
	struct sig_std_logic *gui_port_0x1bcd600,
	struct sig_std_logic *gui_port_0x1bcd750,
	struct sig_std_logic *gui_port_0x1bcd8a0,
	struct sig_std_logic *gui_port_0x1bcd9f0,
	struct sig_std_logic *gui_port_0x1bcdb40,
	struct sig_std_logic *gui_port_0x1bcdc90,
	struct sig_std_logic *gui_port_0x1bcdde0,
	struct sig_std_logic *gui_port_0x1bcdf30,
	struct sig_std_logic *gui_port_0x1bce080,
	struct sig_std_logic *gui_port_0x1bce1d0,
	struct sig_std_logic *gui_port_0x1bce320,
	struct sig_std_logic *gui_port_0x1bce470,
	struct sig_std_logic *gui_port_0x1bce5c0,
	struct sig_std_logic *gui_port_0x1bce710,
	struct sig_std_logic *gui_port_0x1bce860,
	struct sig_std_logic *gui_port_0x1bce9b0,
	struct sig_std_logic *gui_port_0x1bceb00,
	struct sig_std_logic *gui_port_0x1bcec50,
	struct sig_std_logic *gui_port_0x1bceda0,
	struct sig_std_logic *gui_port_0x1bceef0,
	struct sig_std_logic *gui_port_0x1bcf040,
	struct sig_std_logic *gui_port_0x1bcf190,
	struct sig_std_logic *gui_port_0x1bcf2e0,
	struct sig_std_logic *gui_port_0x1bcf430,
	struct sig_std_logic *gui_port_0x1bcf580,
	struct sig_std_logic *gui_port_0x1bcf6d0,
	struct sig_std_logic *gui_port_0x1bcf820,
	struct sig_std_logic *gui_port_0x1bcf970,
	struct sig_std_logic *gui_port_0x1bcfac0,
	struct sig_std_logic *gui_port_0x1bcfc10,
	struct sig_std_logic *gui_port_0x1bcfd60,
	struct sig_std_logic *gui_port_0x1bcfeb0
)
{
	static const struct sig_std_logic_funcs port_func_Uhr1 = {
		.std_logic_set = COMP_(port_Uhr1_set),
	};
	static const struct sig_std_logic_funcs port_func_Uhr2 = {
		.std_logic_set = COMP_(port_Uhr2_set),
	};
	static const struct sig_std_logic_funcs port_func_Imp1 = {
		.std_logic_set = COMP_(port_Imp1_set),
	};
	static const struct sig_std_logic_funcs port_func_Imp2 = {
		.std_logic_set = COMP_(port_Imp2_set),
	};
	static const struct sig_std_logic_funcs port_func_22I1 = {
		.std_logic_set = COMP_(port_22I1_set),
	};
	static const struct sig_std_logic_funcs port_func_22I2 = {
		.std_logic_set = COMP_(port_22I2_set),
	};
	static const struct sig_std_logic_funcs port_func_22I3 = {
		.std_logic_set = COMP_(port_22I3_set),
	};
	static const struct sig_std_logic_funcs port_func_22I4 = {
		.std_logic_set = COMP_(port_22I4_set),
	};
	static const struct sig_std_logic_funcs port_func_22I5 = {
		.std_logic_set = COMP_(port_22I5_set),
	};
	static const struct sig_std_logic_funcs port_func_22I6 = {
		.std_logic_set = COMP_(port_22I6_set),
	};
	static const struct sig_std_logic_funcs port_func_22I7 = {
		.std_logic_set = COMP_(port_22I7_set),
	};
	static const struct sig_std_logic_funcs port_func_22I8 = {
		.std_logic_set = COMP_(port_22I8_set),
	};
	static const struct sig_std_logic_funcs port_func_22I9 = {
		.std_logic_set = COMP_(port_22I9_set),
	};
	static const struct sig_std_logic_funcs port_func_22I0 = {
		.std_logic_set = COMP_(port_22I0_set),
	};
	static const struct sig_std_logic_funcs port_func_22II1 = {
		.std_logic_set = COMP_(port_22II1_set),
	};
	static const struct sig_std_logic_funcs port_func_22II2 = {
		.std_logic_set = COMP_(port_22II2_set),
	};
	static const struct sig_std_logic_funcs port_func_22II3 = {
		.std_logic_set = COMP_(port_22II3_set),
	};
	static const struct sig_std_logic_funcs port_func_22II4 = {
		.std_logic_set = COMP_(port_22II4_set),
	};
	static const struct sig_std_logic_funcs port_func_22II5 = {
		.std_logic_set = COMP_(port_22II5_set),
	};
	static const struct sig_std_logic_funcs port_func_22II6 = {
		.std_logic_set = COMP_(port_22II6_set),
	};
	static const struct sig_std_logic_funcs port_func_22II7 = {
		.std_logic_set = COMP_(port_22II7_set),
	};
	static const struct sig_std_logic_funcs port_func_22II8 = {
		.std_logic_set = COMP_(port_22II8_set),
	};
	static const struct sig_std_logic_funcs port_func_22II9 = {
		.std_logic_set = COMP_(port_22II9_set),
	};
	static const struct sig_std_logic_funcs port_func_22II0 = {
		.std_logic_set = COMP_(port_22II0_set),
	};
	static const struct sig_std_logic_funcs port_func_22III1 = {
		.std_logic_set = COMP_(port_22III1_set),
	};
	static const struct sig_std_logic_funcs port_func_22III2 = {
		.std_logic_set = COMP_(port_22III2_set),
	};
	static const struct sig_std_logic_funcs port_func_22III3 = {
		.std_logic_set = COMP_(port_22III3_set),
	};
	static const struct sig_std_logic_funcs port_func_22III4 = {
		.std_logic_set = COMP_(port_22III4_set),
	};
	static const struct sig_std_logic_funcs port_func_22III5 = {
		.std_logic_set = COMP_(port_22III5_set),
	};
	static const struct sig_std_logic_funcs port_func_22III6 = {
		.std_logic_set = COMP_(port_22III6_set),
	};
	static const struct sig_std_logic_funcs port_func_22III7 = {
		.std_logic_set = COMP_(port_22III7_set),
	};
	static const struct sig_std_logic_funcs port_func_22III8 = {
		.std_logic_set = COMP_(port_22III8_set),
	};
	static const struct sig_std_logic_funcs port_func_22III9 = {
		.std_logic_set = COMP_(port_22III9_set),
	};
	static const struct sig_std_logic_funcs port_func_22III0 = {
		.std_logic_set = COMP_(port_22III0_set),
	};
	static const struct sig_std_logic_funcs port_func_30I1 = {
		.std_logic_set = COMP_(port_30I1_set),
	};
	static const struct sig_std_logic_funcs port_func_30I2 = {
		.std_logic_set = COMP_(port_30I2_set),
	};
	static const struct sig_std_logic_funcs port_func_30I3 = {
		.std_logic_set = COMP_(port_30I3_set),
	};
	static const struct sig_std_logic_funcs port_func_30I4 = {
		.std_logic_set = COMP_(port_30I4_set),
	};
	static const struct sig_std_logic_funcs port_func_30I5 = {
		.std_logic_set = COMP_(port_30I5_set),
	};
	static const struct sig_std_logic_funcs port_func_30I6 = {
		.std_logic_set = COMP_(port_30I6_set),
	};
	static const struct sig_std_logic_funcs port_func_30I7 = {
		.std_logic_set = COMP_(port_30I7_set),
	};
	static const struct sig_std_logic_funcs port_func_30I8 = {
		.std_logic_set = COMP_(port_30I8_set),
	};
	static const struct sig_std_logic_funcs port_func_30I9 = {
		.std_logic_set = COMP_(port_30I9_set),
	};
	static const struct sig_std_logic_funcs port_func_30I0 = {
		.std_logic_set = COMP_(port_30I0_set),
	};
	static const struct sig_std_logic_funcs port_func_30II1 = {
		.std_logic_set = COMP_(port_30II1_set),
	};
	static const struct sig_std_logic_funcs port_func_30II2 = {
		.std_logic_set = COMP_(port_30II2_set),
	};
	static const struct sig_std_logic_funcs port_func_30II3 = {
		.std_logic_set = COMP_(port_30II3_set),
	};
	static const struct sig_std_logic_funcs port_func_30II4 = {
		.std_logic_set = COMP_(port_30II4_set),
	};
	static const struct sig_std_logic_funcs port_func_30II5 = {
		.std_logic_set = COMP_(port_30II5_set),
	};
	static const struct sig_std_logic_funcs port_func_30II6 = {
		.std_logic_set = COMP_(port_30II6_set),
	};
	static const struct sig_std_logic_funcs port_func_30II7 = {
		.std_logic_set = COMP_(port_30II7_set),
	};
	static const struct sig_std_logic_funcs port_func_30II8 = {
		.std_logic_set = COMP_(port_30II8_set),
	};
	static const struct sig_std_logic_funcs port_func_30II9 = {
		.std_logic_set = COMP_(port_30II9_set),
	};
	static const struct sig_std_logic_funcs port_func_30II0 = {
		.std_logic_set = COMP_(port_30II0_set),
	};
	static const struct sig_std_logic_funcs port_func_30III1 = {
		.std_logic_set = COMP_(port_30III1_set),
	};
	static const struct sig_std_logic_funcs port_func_30III2 = {
		.std_logic_set = COMP_(port_30III2_set),
	};
	static const struct sig_std_logic_funcs port_func_30III3 = {
		.std_logic_set = COMP_(port_30III3_set),
	};
	static const struct sig_std_logic_funcs port_func_30III4 = {
		.std_logic_set = COMP_(port_30III4_set),
	};
	static const struct sig_std_logic_funcs port_func_30III5 = {
		.std_logic_set = COMP_(port_30III5_set),
	};
	static const struct sig_std_logic_funcs port_func_30III6 = {
		.std_logic_set = COMP_(port_30III6_set),
	};
	static const struct sig_std_logic_funcs port_func_30III7 = {
		.std_logic_set = COMP_(port_30III7_set),
	};
	static const struct sig_std_logic_funcs port_func_30III8 = {
		.std_logic_set = COMP_(port_30III8_set),
	};
	static const struct sig_std_logic_funcs port_func_30III9 = {
		.std_logic_set = COMP_(port_30III9_set),
	};
	static const struct sig_std_logic_funcs port_func_30III0 = {
		.std_logic_set = COMP_(port_30III0_set),
	};

	static const struct sig_std_logic_funcs gui_port_func_0x1bb8760 = {
		.std_logic_set = COMP_(gui_port_0x1bb8760_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb9650 = {
		.std_logic_set = COMP_(gui_port_0x1bb9650_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb9630 = {
		.std_logic_set = COMP_(gui_port_0x1bb9630_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb69a0 = {
		.std_logic_set = COMP_(gui_port_0x1bb69a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb82f0 = {
		.std_logic_set = COMP_(gui_port_0x1bb82f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb81b0 = {
		.std_logic_set = COMP_(gui_port_0x1bb81b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8f00 = {
		.std_logic_set = COMP_(gui_port_0x1bb8f00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb3b20 = {
		.std_logic_set = COMP_(gui_port_0x1bb3b20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6a40 = {
		.std_logic_set = COMP_(gui_port_0x1bb6a40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8550 = {
		.std_logic_set = COMP_(gui_port_0x1bb8550_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6980 = {
		.std_logic_set = COMP_(gui_port_0x1bb6980_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8190 = {
		.std_logic_set = COMP_(gui_port_0x1bb8190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6640 = {
		.std_logic_set = COMP_(gui_port_0x1bb6640_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbe9b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbe9b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbe9d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbe9d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbe9f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbe9f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea10 = {
		.std_logic_set = COMP_(gui_port_0x1bbea10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea30 = {
		.std_logic_set = COMP_(gui_port_0x1bbea30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea50 = {
		.std_logic_set = COMP_(gui_port_0x1bbea50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea70 = {
		.std_logic_set = COMP_(gui_port_0x1bbea70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbea90 = {
		.std_logic_set = COMP_(gui_port_0x1bbea90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeab0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeab0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbead0 = {
		.std_logic_set = COMP_(gui_port_0x1bbead0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeaf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeaf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb10 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb30 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb50 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb70 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeb90 = {
		.std_logic_set = COMP_(gui_port_0x1bbeb90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbebb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbebb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbebd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbebd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbebf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbebf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec10 = {
		.std_logic_set = COMP_(gui_port_0x1bbec10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec30 = {
		.std_logic_set = COMP_(gui_port_0x1bbec30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec50 = {
		.std_logic_set = COMP_(gui_port_0x1bbec50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec70 = {
		.std_logic_set = COMP_(gui_port_0x1bbec70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbec90 = {
		.std_logic_set = COMP_(gui_port_0x1bbec90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbecb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbecb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbecd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbecd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbecf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbecf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed10 = {
		.std_logic_set = COMP_(gui_port_0x1bbed10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed30 = {
		.std_logic_set = COMP_(gui_port_0x1bbed30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed50 = {
		.std_logic_set = COMP_(gui_port_0x1bbed50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed70 = {
		.std_logic_set = COMP_(gui_port_0x1bbed70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbed90 = {
		.std_logic_set = COMP_(gui_port_0x1bbed90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbedb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbedb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbedd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbedd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbedf0 = {
		.std_logic_set = COMP_(gui_port_0x1bbedf0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee10 = {
		.std_logic_set = COMP_(gui_port_0x1bbee10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee30 = {
		.std_logic_set = COMP_(gui_port_0x1bbee30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee50 = {
		.std_logic_set = COMP_(gui_port_0x1bbee50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee70 = {
		.std_logic_set = COMP_(gui_port_0x1bbee70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbee90 = {
		.std_logic_set = COMP_(gui_port_0x1bbee90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeeb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeeb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeed0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeed0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeef0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeef0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef10 = {
		.std_logic_set = COMP_(gui_port_0x1bbef10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef30 = {
		.std_logic_set = COMP_(gui_port_0x1bbef30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef50 = {
		.std_logic_set = COMP_(gui_port_0x1bbef50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef70 = {
		.std_logic_set = COMP_(gui_port_0x1bbef70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbef90 = {
		.std_logic_set = COMP_(gui_port_0x1bbef90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbefb0 = {
		.std_logic_set = COMP_(gui_port_0x1bbefb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbefd0 = {
		.std_logic_set = COMP_(gui_port_0x1bbefd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbeff0 = {
		.std_logic_set = COMP_(gui_port_0x1bbeff0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf010 = {
		.std_logic_set = COMP_(gui_port_0x1bbf010_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf030 = {
		.std_logic_set = COMP_(gui_port_0x1bbf030_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf050 = {
		.std_logic_set = COMP_(gui_port_0x1bbf050_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf070 = {
		.std_logic_set = COMP_(gui_port_0x1bbf070_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf090 = {
		.std_logic_set = COMP_(gui_port_0x1bbf090_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf0b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf0b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf0d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf0d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf0f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf0f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf110 = {
		.std_logic_set = COMP_(gui_port_0x1bbf110_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf130 = {
		.std_logic_set = COMP_(gui_port_0x1bbf130_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf150 = {
		.std_logic_set = COMP_(gui_port_0x1bbf150_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf170 = {
		.std_logic_set = COMP_(gui_port_0x1bbf170_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf190 = {
		.std_logic_set = COMP_(gui_port_0x1bbf190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf1b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf1b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf1d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf1d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf1f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf1f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf210 = {
		.std_logic_set = COMP_(gui_port_0x1bbf210_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf230 = {
		.std_logic_set = COMP_(gui_port_0x1bbf230_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf250 = {
		.std_logic_set = COMP_(gui_port_0x1bbf250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf270 = {
		.std_logic_set = COMP_(gui_port_0x1bbf270_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf290 = {
		.std_logic_set = COMP_(gui_port_0x1bbf290_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf2b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf2b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf2d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf2d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf2f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf2f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf310 = {
		.std_logic_set = COMP_(gui_port_0x1bbf310_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf330 = {
		.std_logic_set = COMP_(gui_port_0x1bbf330_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf350 = {
		.std_logic_set = COMP_(gui_port_0x1bbf350_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf370 = {
		.std_logic_set = COMP_(gui_port_0x1bbf370_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf390 = {
		.std_logic_set = COMP_(gui_port_0x1bbf390_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf3b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf3b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf3d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf3d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf3f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf3f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf410 = {
		.std_logic_set = COMP_(gui_port_0x1bbf410_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf430 = {
		.std_logic_set = COMP_(gui_port_0x1bbf430_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf450 = {
		.std_logic_set = COMP_(gui_port_0x1bbf450_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf470 = {
		.std_logic_set = COMP_(gui_port_0x1bbf470_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf490 = {
		.std_logic_set = COMP_(gui_port_0x1bbf490_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf4b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf4b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf4d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf4d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf4f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf4f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf510 = {
		.std_logic_set = COMP_(gui_port_0x1bbf510_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf530 = {
		.std_logic_set = COMP_(gui_port_0x1bbf530_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf550 = {
		.std_logic_set = COMP_(gui_port_0x1bbf550_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf570 = {
		.std_logic_set = COMP_(gui_port_0x1bbf570_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf590 = {
		.std_logic_set = COMP_(gui_port_0x1bbf590_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf5b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf5b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf5d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf5d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf5f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf5f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf610 = {
		.std_logic_set = COMP_(gui_port_0x1bbf610_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf630 = {
		.std_logic_set = COMP_(gui_port_0x1bbf630_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf650 = {
		.std_logic_set = COMP_(gui_port_0x1bbf650_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf670 = {
		.std_logic_set = COMP_(gui_port_0x1bbf670_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf690 = {
		.std_logic_set = COMP_(gui_port_0x1bbf690_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf6b0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf6b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf6d0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf6d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf6f0 = {
		.std_logic_set = COMP_(gui_port_0x1bbf6f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf710 = {
		.std_logic_set = COMP_(gui_port_0x1bbf710_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf730 = {
		.std_logic_set = COMP_(gui_port_0x1bbf730_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bbf750 = {
		.std_logic_set = COMP_(gui_port_0x1bbf750_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc05f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc05f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0740 = {
		.std_logic_set = COMP_(gui_port_0x1bc0740_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0890 = {
		.std_logic_set = COMP_(gui_port_0x1bc0890_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc09e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc09e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0b30 = {
		.std_logic_set = COMP_(gui_port_0x1bc0b30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0c80 = {
		.std_logic_set = COMP_(gui_port_0x1bc0c80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0dd0 = {
		.std_logic_set = COMP_(gui_port_0x1bc0dd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc0f20 = {
		.std_logic_set = COMP_(gui_port_0x1bc0f20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1070 = {
		.std_logic_set = COMP_(gui_port_0x1bc1070_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc11c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc11c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1310 = {
		.std_logic_set = COMP_(gui_port_0x1bc1310_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1460 = {
		.std_logic_set = COMP_(gui_port_0x1bc1460_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc15b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc15b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1700 = {
		.std_logic_set = COMP_(gui_port_0x1bc1700_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1850 = {
		.std_logic_set = COMP_(gui_port_0x1bc1850_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc19a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc19a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1af0 = {
		.std_logic_set = COMP_(gui_port_0x1bc1af0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1c40 = {
		.std_logic_set = COMP_(gui_port_0x1bc1c40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1d90 = {
		.std_logic_set = COMP_(gui_port_0x1bc1d90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc1ee0 = {
		.std_logic_set = COMP_(gui_port_0x1bc1ee0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2030 = {
		.std_logic_set = COMP_(gui_port_0x1bc2030_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2180 = {
		.std_logic_set = COMP_(gui_port_0x1bc2180_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc22d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc22d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2420 = {
		.std_logic_set = COMP_(gui_port_0x1bc2420_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2570 = {
		.std_logic_set = COMP_(gui_port_0x1bc2570_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc26c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc26c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2810 = {
		.std_logic_set = COMP_(gui_port_0x1bc2810_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2960 = {
		.std_logic_set = COMP_(gui_port_0x1bc2960_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2ab0 = {
		.std_logic_set = COMP_(gui_port_0x1bc2ab0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2c00 = {
		.std_logic_set = COMP_(gui_port_0x1bc2c00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2d50 = {
		.std_logic_set = COMP_(gui_port_0x1bc2d50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2ea0 = {
		.std_logic_set = COMP_(gui_port_0x1bc2ea0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc2ff0 = {
		.std_logic_set = COMP_(gui_port_0x1bc2ff0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3140 = {
		.std_logic_set = COMP_(gui_port_0x1bc3140_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3290 = {
		.std_logic_set = COMP_(gui_port_0x1bc3290_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc33e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc33e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3530 = {
		.std_logic_set = COMP_(gui_port_0x1bc3530_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3680 = {
		.std_logic_set = COMP_(gui_port_0x1bc3680_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc37d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc37d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3920 = {
		.std_logic_set = COMP_(gui_port_0x1bc3920_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3a70 = {
		.std_logic_set = COMP_(gui_port_0x1bc3a70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3bc0 = {
		.std_logic_set = COMP_(gui_port_0x1bc3bc0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3d10 = {
		.std_logic_set = COMP_(gui_port_0x1bc3d10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3e60 = {
		.std_logic_set = COMP_(gui_port_0x1bc3e60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc3fb0 = {
		.std_logic_set = COMP_(gui_port_0x1bc3fb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4100 = {
		.std_logic_set = COMP_(gui_port_0x1bc4100_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4250 = {
		.std_logic_set = COMP_(gui_port_0x1bc4250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc43a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc43a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc44f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc44f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4640 = {
		.std_logic_set = COMP_(gui_port_0x1bc4640_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4790 = {
		.std_logic_set = COMP_(gui_port_0x1bc4790_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc48e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc48e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4a30 = {
		.std_logic_set = COMP_(gui_port_0x1bc4a30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4b80 = {
		.std_logic_set = COMP_(gui_port_0x1bc4b80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4cd0 = {
		.std_logic_set = COMP_(gui_port_0x1bc4cd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4e20 = {
		.std_logic_set = COMP_(gui_port_0x1bc4e20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc4f70 = {
		.std_logic_set = COMP_(gui_port_0x1bc4f70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc50c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc50c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5210 = {
		.std_logic_set = COMP_(gui_port_0x1bc5210_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5360 = {
		.std_logic_set = COMP_(gui_port_0x1bc5360_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc54b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc54b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5600 = {
		.std_logic_set = COMP_(gui_port_0x1bc5600_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5750 = {
		.std_logic_set = COMP_(gui_port_0x1bc5750_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc58a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc58a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc59f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc59f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5b40 = {
		.std_logic_set = COMP_(gui_port_0x1bc5b40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5c90 = {
		.std_logic_set = COMP_(gui_port_0x1bc5c90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5de0 = {
		.std_logic_set = COMP_(gui_port_0x1bc5de0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc5f30 = {
		.std_logic_set = COMP_(gui_port_0x1bc5f30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6080 = {
		.std_logic_set = COMP_(gui_port_0x1bc6080_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc61d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc61d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6320 = {
		.std_logic_set = COMP_(gui_port_0x1bc6320_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6470 = {
		.std_logic_set = COMP_(gui_port_0x1bc6470_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc65c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc65c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6710 = {
		.std_logic_set = COMP_(gui_port_0x1bc6710_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6860 = {
		.std_logic_set = COMP_(gui_port_0x1bc6860_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc69b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc69b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6b00 = {
		.std_logic_set = COMP_(gui_port_0x1bc6b00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6c50 = {
		.std_logic_set = COMP_(gui_port_0x1bc6c50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6da0 = {
		.std_logic_set = COMP_(gui_port_0x1bc6da0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc6ef0 = {
		.std_logic_set = COMP_(gui_port_0x1bc6ef0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7040 = {
		.std_logic_set = COMP_(gui_port_0x1bc7040_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7190 = {
		.std_logic_set = COMP_(gui_port_0x1bc7190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc72e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc72e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7430 = {
		.std_logic_set = COMP_(gui_port_0x1bc7430_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7580 = {
		.std_logic_set = COMP_(gui_port_0x1bc7580_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc76d0 = {
		.std_logic_set = COMP_(gui_port_0x1bc76d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7820 = {
		.std_logic_set = COMP_(gui_port_0x1bc7820_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7970 = {
		.std_logic_set = COMP_(gui_port_0x1bc7970_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7ac0 = {
		.std_logic_set = COMP_(gui_port_0x1bc7ac0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7c10 = {
		.std_logic_set = COMP_(gui_port_0x1bc7c10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7d60 = {
		.std_logic_set = COMP_(gui_port_0x1bc7d60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc7eb0 = {
		.std_logic_set = COMP_(gui_port_0x1bc7eb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8000 = {
		.std_logic_set = COMP_(gui_port_0x1bc8000_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8150 = {
		.std_logic_set = COMP_(gui_port_0x1bc8150_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc82a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc82a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc83f0 = {
		.std_logic_set = COMP_(gui_port_0x1bc83f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8540 = {
		.std_logic_set = COMP_(gui_port_0x1bc8540_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8690 = {
		.std_logic_set = COMP_(gui_port_0x1bc8690_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc87e0 = {
		.std_logic_set = COMP_(gui_port_0x1bc87e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8930 = {
		.std_logic_set = COMP_(gui_port_0x1bc8930_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8a80 = {
		.std_logic_set = COMP_(gui_port_0x1bc8a80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8bd0 = {
		.std_logic_set = COMP_(gui_port_0x1bc8bd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8d20 = {
		.std_logic_set = COMP_(gui_port_0x1bc8d20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8e70 = {
		.std_logic_set = COMP_(gui_port_0x1bc8e70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc8fc0 = {
		.std_logic_set = COMP_(gui_port_0x1bc8fc0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb6b50 = {
		.std_logic_set = COMP_(gui_port_0x1bb6b50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb8250 = {
		.std_logic_set = COMP_(gui_port_0x1bb8250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bb82b0 = {
		.std_logic_set = COMP_(gui_port_0x1bb82b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc91c0 = {
		.std_logic_set = COMP_(gui_port_0x1bc91c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9310 = {
		.std_logic_set = COMP_(gui_port_0x1bc9310_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9460 = {
		.std_logic_set = COMP_(gui_port_0x1bc9460_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc95b0 = {
		.std_logic_set = COMP_(gui_port_0x1bc95b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9700 = {
		.std_logic_set = COMP_(gui_port_0x1bc9700_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9850 = {
		.std_logic_set = COMP_(gui_port_0x1bc9850_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc99a0 = {
		.std_logic_set = COMP_(gui_port_0x1bc99a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9af0 = {
		.std_logic_set = COMP_(gui_port_0x1bc9af0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9c40 = {
		.std_logic_set = COMP_(gui_port_0x1bc9c40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9d90 = {
		.std_logic_set = COMP_(gui_port_0x1bc9d90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bc9ee0 = {
		.std_logic_set = COMP_(gui_port_0x1bc9ee0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca030 = {
		.std_logic_set = COMP_(gui_port_0x1bca030_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca180 = {
		.std_logic_set = COMP_(gui_port_0x1bca180_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca2d0 = {
		.std_logic_set = COMP_(gui_port_0x1bca2d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca420 = {
		.std_logic_set = COMP_(gui_port_0x1bca420_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca570 = {
		.std_logic_set = COMP_(gui_port_0x1bca570_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca6c0 = {
		.std_logic_set = COMP_(gui_port_0x1bca6c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca810 = {
		.std_logic_set = COMP_(gui_port_0x1bca810_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bca960 = {
		.std_logic_set = COMP_(gui_port_0x1bca960_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcaab0 = {
		.std_logic_set = COMP_(gui_port_0x1bcaab0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcac00 = {
		.std_logic_set = COMP_(gui_port_0x1bcac00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcad50 = {
		.std_logic_set = COMP_(gui_port_0x1bcad50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcaea0 = {
		.std_logic_set = COMP_(gui_port_0x1bcaea0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcaff0 = {
		.std_logic_set = COMP_(gui_port_0x1bcaff0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb140 = {
		.std_logic_set = COMP_(gui_port_0x1bcb140_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb290 = {
		.std_logic_set = COMP_(gui_port_0x1bcb290_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb3e0 = {
		.std_logic_set = COMP_(gui_port_0x1bcb3e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb530 = {
		.std_logic_set = COMP_(gui_port_0x1bcb530_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb680 = {
		.std_logic_set = COMP_(gui_port_0x1bcb680_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb7d0 = {
		.std_logic_set = COMP_(gui_port_0x1bcb7d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcb920 = {
		.std_logic_set = COMP_(gui_port_0x1bcb920_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcba70 = {
		.std_logic_set = COMP_(gui_port_0x1bcba70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbbc0 = {
		.std_logic_set = COMP_(gui_port_0x1bcbbc0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbd10 = {
		.std_logic_set = COMP_(gui_port_0x1bcbd10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbe60 = {
		.std_logic_set = COMP_(gui_port_0x1bcbe60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcbfb0 = {
		.std_logic_set = COMP_(gui_port_0x1bcbfb0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc100 = {
		.std_logic_set = COMP_(gui_port_0x1bcc100_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc250 = {
		.std_logic_set = COMP_(gui_port_0x1bcc250_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc3a0 = {
		.std_logic_set = COMP_(gui_port_0x1bcc3a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc4f0 = {
		.std_logic_set = COMP_(gui_port_0x1bcc4f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc640 = {
		.std_logic_set = COMP_(gui_port_0x1bcc640_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc790 = {
		.std_logic_set = COMP_(gui_port_0x1bcc790_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcc8e0 = {
		.std_logic_set = COMP_(gui_port_0x1bcc8e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcca30 = {
		.std_logic_set = COMP_(gui_port_0x1bcca30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bccb80 = {
		.std_logic_set = COMP_(gui_port_0x1bccb80_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcccd0 = {
		.std_logic_set = COMP_(gui_port_0x1bcccd0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcce20 = {
		.std_logic_set = COMP_(gui_port_0x1bcce20_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bccf70 = {
		.std_logic_set = COMP_(gui_port_0x1bccf70_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd0c0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd0c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd210 = {
		.std_logic_set = COMP_(gui_port_0x1bcd210_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd360 = {
		.std_logic_set = COMP_(gui_port_0x1bcd360_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd4b0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd4b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd600 = {
		.std_logic_set = COMP_(gui_port_0x1bcd600_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd750 = {
		.std_logic_set = COMP_(gui_port_0x1bcd750_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd8a0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd8a0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcd9f0 = {
		.std_logic_set = COMP_(gui_port_0x1bcd9f0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdb40 = {
		.std_logic_set = COMP_(gui_port_0x1bcdb40_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdc90 = {
		.std_logic_set = COMP_(gui_port_0x1bcdc90_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdde0 = {
		.std_logic_set = COMP_(gui_port_0x1bcdde0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcdf30 = {
		.std_logic_set = COMP_(gui_port_0x1bcdf30_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce080 = {
		.std_logic_set = COMP_(gui_port_0x1bce080_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce1d0 = {
		.std_logic_set = COMP_(gui_port_0x1bce1d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce320 = {
		.std_logic_set = COMP_(gui_port_0x1bce320_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce470 = {
		.std_logic_set = COMP_(gui_port_0x1bce470_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce5c0 = {
		.std_logic_set = COMP_(gui_port_0x1bce5c0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce710 = {
		.std_logic_set = COMP_(gui_port_0x1bce710_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce860 = {
		.std_logic_set = COMP_(gui_port_0x1bce860_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bce9b0 = {
		.std_logic_set = COMP_(gui_port_0x1bce9b0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bceb00 = {
		.std_logic_set = COMP_(gui_port_0x1bceb00_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcec50 = {
		.std_logic_set = COMP_(gui_port_0x1bcec50_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bceda0 = {
		.std_logic_set = COMP_(gui_port_0x1bceda0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bceef0 = {
		.std_logic_set = COMP_(gui_port_0x1bceef0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf040 = {
		.std_logic_set = COMP_(gui_port_0x1bcf040_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf190 = {
		.std_logic_set = COMP_(gui_port_0x1bcf190_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf2e0 = {
		.std_logic_set = COMP_(gui_port_0x1bcf2e0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf430 = {
		.std_logic_set = COMP_(gui_port_0x1bcf430_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf580 = {
		.std_logic_set = COMP_(gui_port_0x1bcf580_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf6d0 = {
		.std_logic_set = COMP_(gui_port_0x1bcf6d0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf820 = {
		.std_logic_set = COMP_(gui_port_0x1bcf820_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcf970 = {
		.std_logic_set = COMP_(gui_port_0x1bcf970_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfac0 = {
		.std_logic_set = COMP_(gui_port_0x1bcfac0_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfc10 = {
		.std_logic_set = COMP_(gui_port_0x1bcfc10_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfd60 = {
		.std_logic_set = COMP_(gui_port_0x1bcfd60_set),
	};
	static const struct sig_std_logic_funcs gui_port_func_0x1bcfeb0 = {
		.std_logic_set = COMP_(gui_port_0x1bcfeb0_set),
	};

	struct cpssp *cpssp;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	/* connect ports as out */
	cpssp->port_Uhr1 = port_Uhr1;
	sig_std_logic_connect_out(port_Uhr1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_Uhr2 = port_Uhr2;
	sig_std_logic_connect_out(port_Uhr2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_Imp1 = port_Imp1;
	sig_std_logic_connect_out(port_Imp1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_Imp2 = port_Imp2;
	sig_std_logic_connect_out(port_Imp2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I1 = port_22I1;
	sig_std_logic_connect_out(port_22I1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I2 = port_22I2;
	sig_std_logic_connect_out(port_22I2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I3 = port_22I3;
	sig_std_logic_connect_out(port_22I3, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I4 = port_22I4;
	sig_std_logic_connect_out(port_22I4, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I5 = port_22I5;
	sig_std_logic_connect_out(port_22I5, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I6 = port_22I6;
	sig_std_logic_connect_out(port_22I6, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I7 = port_22I7;
	sig_std_logic_connect_out(port_22I7, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I8 = port_22I8;
	sig_std_logic_connect_out(port_22I8, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I9 = port_22I9;
	sig_std_logic_connect_out(port_22I9, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22I0 = port_22I0;
	sig_std_logic_connect_out(port_22I0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II1 = port_22II1;
	sig_std_logic_connect_out(port_22II1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II2 = port_22II2;
	sig_std_logic_connect_out(port_22II2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II3 = port_22II3;
	sig_std_logic_connect_out(port_22II3, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II4 = port_22II4;
	sig_std_logic_connect_out(port_22II4, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II5 = port_22II5;
	sig_std_logic_connect_out(port_22II5, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II6 = port_22II6;
	sig_std_logic_connect_out(port_22II6, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II7 = port_22II7;
	sig_std_logic_connect_out(port_22II7, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II8 = port_22II8;
	sig_std_logic_connect_out(port_22II8, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II9 = port_22II9;
	sig_std_logic_connect_out(port_22II9, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22II0 = port_22II0;
	sig_std_logic_connect_out(port_22II0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III1 = port_22III1;
	sig_std_logic_connect_out(port_22III1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III2 = port_22III2;
	sig_std_logic_connect_out(port_22III2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III3 = port_22III3;
	sig_std_logic_connect_out(port_22III3, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III4 = port_22III4;
	sig_std_logic_connect_out(port_22III4, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III5 = port_22III5;
	sig_std_logic_connect_out(port_22III5, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III6 = port_22III6;
	sig_std_logic_connect_out(port_22III6, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III7 = port_22III7;
	sig_std_logic_connect_out(port_22III7, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III8 = port_22III8;
	sig_std_logic_connect_out(port_22III8, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III9 = port_22III9;
	sig_std_logic_connect_out(port_22III9, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_22III0 = port_22III0;
	sig_std_logic_connect_out(port_22III0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I1 = port_30I1;
	sig_std_logic_connect_out(port_30I1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I2 = port_30I2;
	sig_std_logic_connect_out(port_30I2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I3 = port_30I3;
	sig_std_logic_connect_out(port_30I3, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I4 = port_30I4;
	sig_std_logic_connect_out(port_30I4, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I5 = port_30I5;
	sig_std_logic_connect_out(port_30I5, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I6 = port_30I6;
	sig_std_logic_connect_out(port_30I6, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I7 = port_30I7;
	sig_std_logic_connect_out(port_30I7, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I8 = port_30I8;
	sig_std_logic_connect_out(port_30I8, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I9 = port_30I9;
	sig_std_logic_connect_out(port_30I9, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30I0 = port_30I0;
	sig_std_logic_connect_out(port_30I0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II1 = port_30II1;
	sig_std_logic_connect_out(port_30II1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II2 = port_30II2;
	sig_std_logic_connect_out(port_30II2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II3 = port_30II3;
	sig_std_logic_connect_out(port_30II3, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II4 = port_30II4;
	sig_std_logic_connect_out(port_30II4, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II5 = port_30II5;
	sig_std_logic_connect_out(port_30II5, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II6 = port_30II6;
	sig_std_logic_connect_out(port_30II6, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II7 = port_30II7;
	sig_std_logic_connect_out(port_30II7, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II8 = port_30II8;
	sig_std_logic_connect_out(port_30II8, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II9 = port_30II9;
	sig_std_logic_connect_out(port_30II9, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30II0 = port_30II0;
	sig_std_logic_connect_out(port_30II0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III1 = port_30III1;
	sig_std_logic_connect_out(port_30III1, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III2 = port_30III2;
	sig_std_logic_connect_out(port_30III2, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III3 = port_30III3;
	sig_std_logic_connect_out(port_30III3, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III4 = port_30III4;
	sig_std_logic_connect_out(port_30III4, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III5 = port_30III5;
	sig_std_logic_connect_out(port_30III5, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III6 = port_30III6;
	sig_std_logic_connect_out(port_30III6, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III7 = port_30III7;
	sig_std_logic_connect_out(port_30III7, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III8 = port_30III8;
	sig_std_logic_connect_out(port_30III8, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III9 = port_30III9;
	sig_std_logic_connect_out(port_30III9, cpssp, SIG_STD_LOGIC_Z);
	cpssp->port_30III0 = port_30III0;
	sig_std_logic_connect_out(port_30III0, cpssp, SIG_STD_LOGIC_Z);

	/* connect gui ports as out */
	cpssp->gui_port_0x1bb8760 = gui_port_0x1bb8760;
	sig_std_logic_connect_out(gui_port_0x1bb8760, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb9650 = gui_port_0x1bb9650;
	sig_std_logic_connect_out(gui_port_0x1bb9650, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb9630 = gui_port_0x1bb9630;
	sig_std_logic_connect_out(gui_port_0x1bb9630, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb69a0 = gui_port_0x1bb69a0;
	sig_std_logic_connect_out(gui_port_0x1bb69a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb82f0 = gui_port_0x1bb82f0;
	sig_std_logic_connect_out(gui_port_0x1bb82f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb81b0 = gui_port_0x1bb81b0;
	sig_std_logic_connect_out(gui_port_0x1bb81b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb8f00 = gui_port_0x1bb8f00;
	sig_std_logic_connect_out(gui_port_0x1bb8f00, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb3b20 = gui_port_0x1bb3b20;
	sig_std_logic_connect_out(gui_port_0x1bb3b20, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb6a40 = gui_port_0x1bb6a40;
	sig_std_logic_connect_out(gui_port_0x1bb6a40, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb8550 = gui_port_0x1bb8550;
	sig_std_logic_connect_out(gui_port_0x1bb8550, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb6980 = gui_port_0x1bb6980;
	sig_std_logic_connect_out(gui_port_0x1bb6980, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb8190 = gui_port_0x1bb8190;
	sig_std_logic_connect_out(gui_port_0x1bb8190, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb6640 = gui_port_0x1bb6640;
	sig_std_logic_connect_out(gui_port_0x1bb6640, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbe9b0 = gui_port_0x1bbe9b0;
	sig_std_logic_connect_out(gui_port_0x1bbe9b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbe9d0 = gui_port_0x1bbe9d0;
	sig_std_logic_connect_out(gui_port_0x1bbe9d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbe9f0 = gui_port_0x1bbe9f0;
	sig_std_logic_connect_out(gui_port_0x1bbe9f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbea10 = gui_port_0x1bbea10;
	sig_std_logic_connect_out(gui_port_0x1bbea10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbea30 = gui_port_0x1bbea30;
	sig_std_logic_connect_out(gui_port_0x1bbea30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbea50 = gui_port_0x1bbea50;
	sig_std_logic_connect_out(gui_port_0x1bbea50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbea70 = gui_port_0x1bbea70;
	sig_std_logic_connect_out(gui_port_0x1bbea70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbea90 = gui_port_0x1bbea90;
	sig_std_logic_connect_out(gui_port_0x1bbea90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeab0 = gui_port_0x1bbeab0;
	sig_std_logic_connect_out(gui_port_0x1bbeab0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbead0 = gui_port_0x1bbead0;
	sig_std_logic_connect_out(gui_port_0x1bbead0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeaf0 = gui_port_0x1bbeaf0;
	sig_std_logic_connect_out(gui_port_0x1bbeaf0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeb10 = gui_port_0x1bbeb10;
	sig_std_logic_connect_out(gui_port_0x1bbeb10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeb30 = gui_port_0x1bbeb30;
	sig_std_logic_connect_out(gui_port_0x1bbeb30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeb50 = gui_port_0x1bbeb50;
	sig_std_logic_connect_out(gui_port_0x1bbeb50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeb70 = gui_port_0x1bbeb70;
	sig_std_logic_connect_out(gui_port_0x1bbeb70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeb90 = gui_port_0x1bbeb90;
	sig_std_logic_connect_out(gui_port_0x1bbeb90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbebb0 = gui_port_0x1bbebb0;
	sig_std_logic_connect_out(gui_port_0x1bbebb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbebd0 = gui_port_0x1bbebd0;
	sig_std_logic_connect_out(gui_port_0x1bbebd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbebf0 = gui_port_0x1bbebf0;
	sig_std_logic_connect_out(gui_port_0x1bbebf0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbec10 = gui_port_0x1bbec10;
	sig_std_logic_connect_out(gui_port_0x1bbec10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbec30 = gui_port_0x1bbec30;
	sig_std_logic_connect_out(gui_port_0x1bbec30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbec50 = gui_port_0x1bbec50;
	sig_std_logic_connect_out(gui_port_0x1bbec50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbec70 = gui_port_0x1bbec70;
	sig_std_logic_connect_out(gui_port_0x1bbec70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbec90 = gui_port_0x1bbec90;
	sig_std_logic_connect_out(gui_port_0x1bbec90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbecb0 = gui_port_0x1bbecb0;
	sig_std_logic_connect_out(gui_port_0x1bbecb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbecd0 = gui_port_0x1bbecd0;
	sig_std_logic_connect_out(gui_port_0x1bbecd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbecf0 = gui_port_0x1bbecf0;
	sig_std_logic_connect_out(gui_port_0x1bbecf0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbed10 = gui_port_0x1bbed10;
	sig_std_logic_connect_out(gui_port_0x1bbed10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbed30 = gui_port_0x1bbed30;
	sig_std_logic_connect_out(gui_port_0x1bbed30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbed50 = gui_port_0x1bbed50;
	sig_std_logic_connect_out(gui_port_0x1bbed50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbed70 = gui_port_0x1bbed70;
	sig_std_logic_connect_out(gui_port_0x1bbed70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbed90 = gui_port_0x1bbed90;
	sig_std_logic_connect_out(gui_port_0x1bbed90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbedb0 = gui_port_0x1bbedb0;
	sig_std_logic_connect_out(gui_port_0x1bbedb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbedd0 = gui_port_0x1bbedd0;
	sig_std_logic_connect_out(gui_port_0x1bbedd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbedf0 = gui_port_0x1bbedf0;
	sig_std_logic_connect_out(gui_port_0x1bbedf0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbee10 = gui_port_0x1bbee10;
	sig_std_logic_connect_out(gui_port_0x1bbee10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbee30 = gui_port_0x1bbee30;
	sig_std_logic_connect_out(gui_port_0x1bbee30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbee50 = gui_port_0x1bbee50;
	sig_std_logic_connect_out(gui_port_0x1bbee50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbee70 = gui_port_0x1bbee70;
	sig_std_logic_connect_out(gui_port_0x1bbee70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbee90 = gui_port_0x1bbee90;
	sig_std_logic_connect_out(gui_port_0x1bbee90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeeb0 = gui_port_0x1bbeeb0;
	sig_std_logic_connect_out(gui_port_0x1bbeeb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeed0 = gui_port_0x1bbeed0;
	sig_std_logic_connect_out(gui_port_0x1bbeed0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeef0 = gui_port_0x1bbeef0;
	sig_std_logic_connect_out(gui_port_0x1bbeef0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbef10 = gui_port_0x1bbef10;
	sig_std_logic_connect_out(gui_port_0x1bbef10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbef30 = gui_port_0x1bbef30;
	sig_std_logic_connect_out(gui_port_0x1bbef30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbef50 = gui_port_0x1bbef50;
	sig_std_logic_connect_out(gui_port_0x1bbef50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbef70 = gui_port_0x1bbef70;
	sig_std_logic_connect_out(gui_port_0x1bbef70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbef90 = gui_port_0x1bbef90;
	sig_std_logic_connect_out(gui_port_0x1bbef90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbefb0 = gui_port_0x1bbefb0;
	sig_std_logic_connect_out(gui_port_0x1bbefb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbefd0 = gui_port_0x1bbefd0;
	sig_std_logic_connect_out(gui_port_0x1bbefd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbeff0 = gui_port_0x1bbeff0;
	sig_std_logic_connect_out(gui_port_0x1bbeff0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf010 = gui_port_0x1bbf010;
	sig_std_logic_connect_out(gui_port_0x1bbf010, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf030 = gui_port_0x1bbf030;
	sig_std_logic_connect_out(gui_port_0x1bbf030, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf050 = gui_port_0x1bbf050;
	sig_std_logic_connect_out(gui_port_0x1bbf050, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf070 = gui_port_0x1bbf070;
	sig_std_logic_connect_out(gui_port_0x1bbf070, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf090 = gui_port_0x1bbf090;
	sig_std_logic_connect_out(gui_port_0x1bbf090, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf0b0 = gui_port_0x1bbf0b0;
	sig_std_logic_connect_out(gui_port_0x1bbf0b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf0d0 = gui_port_0x1bbf0d0;
	sig_std_logic_connect_out(gui_port_0x1bbf0d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf0f0 = gui_port_0x1bbf0f0;
	sig_std_logic_connect_out(gui_port_0x1bbf0f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf110 = gui_port_0x1bbf110;
	sig_std_logic_connect_out(gui_port_0x1bbf110, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf130 = gui_port_0x1bbf130;
	sig_std_logic_connect_out(gui_port_0x1bbf130, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf150 = gui_port_0x1bbf150;
	sig_std_logic_connect_out(gui_port_0x1bbf150, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf170 = gui_port_0x1bbf170;
	sig_std_logic_connect_out(gui_port_0x1bbf170, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf190 = gui_port_0x1bbf190;
	sig_std_logic_connect_out(gui_port_0x1bbf190, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf1b0 = gui_port_0x1bbf1b0;
	sig_std_logic_connect_out(gui_port_0x1bbf1b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf1d0 = gui_port_0x1bbf1d0;
	sig_std_logic_connect_out(gui_port_0x1bbf1d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf1f0 = gui_port_0x1bbf1f0;
	sig_std_logic_connect_out(gui_port_0x1bbf1f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf210 = gui_port_0x1bbf210;
	sig_std_logic_connect_out(gui_port_0x1bbf210, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf230 = gui_port_0x1bbf230;
	sig_std_logic_connect_out(gui_port_0x1bbf230, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf250 = gui_port_0x1bbf250;
	sig_std_logic_connect_out(gui_port_0x1bbf250, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf270 = gui_port_0x1bbf270;
	sig_std_logic_connect_out(gui_port_0x1bbf270, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf290 = gui_port_0x1bbf290;
	sig_std_logic_connect_out(gui_port_0x1bbf290, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf2b0 = gui_port_0x1bbf2b0;
	sig_std_logic_connect_out(gui_port_0x1bbf2b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf2d0 = gui_port_0x1bbf2d0;
	sig_std_logic_connect_out(gui_port_0x1bbf2d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf2f0 = gui_port_0x1bbf2f0;
	sig_std_logic_connect_out(gui_port_0x1bbf2f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf310 = gui_port_0x1bbf310;
	sig_std_logic_connect_out(gui_port_0x1bbf310, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf330 = gui_port_0x1bbf330;
	sig_std_logic_connect_out(gui_port_0x1bbf330, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf350 = gui_port_0x1bbf350;
	sig_std_logic_connect_out(gui_port_0x1bbf350, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf370 = gui_port_0x1bbf370;
	sig_std_logic_connect_out(gui_port_0x1bbf370, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf390 = gui_port_0x1bbf390;
	sig_std_logic_connect_out(gui_port_0x1bbf390, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf3b0 = gui_port_0x1bbf3b0;
	sig_std_logic_connect_out(gui_port_0x1bbf3b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf3d0 = gui_port_0x1bbf3d0;
	sig_std_logic_connect_out(gui_port_0x1bbf3d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf3f0 = gui_port_0x1bbf3f0;
	sig_std_logic_connect_out(gui_port_0x1bbf3f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf410 = gui_port_0x1bbf410;
	sig_std_logic_connect_out(gui_port_0x1bbf410, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf430 = gui_port_0x1bbf430;
	sig_std_logic_connect_out(gui_port_0x1bbf430, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf450 = gui_port_0x1bbf450;
	sig_std_logic_connect_out(gui_port_0x1bbf450, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf470 = gui_port_0x1bbf470;
	sig_std_logic_connect_out(gui_port_0x1bbf470, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf490 = gui_port_0x1bbf490;
	sig_std_logic_connect_out(gui_port_0x1bbf490, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf4b0 = gui_port_0x1bbf4b0;
	sig_std_logic_connect_out(gui_port_0x1bbf4b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf4d0 = gui_port_0x1bbf4d0;
	sig_std_logic_connect_out(gui_port_0x1bbf4d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf4f0 = gui_port_0x1bbf4f0;
	sig_std_logic_connect_out(gui_port_0x1bbf4f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf510 = gui_port_0x1bbf510;
	sig_std_logic_connect_out(gui_port_0x1bbf510, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf530 = gui_port_0x1bbf530;
	sig_std_logic_connect_out(gui_port_0x1bbf530, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf550 = gui_port_0x1bbf550;
	sig_std_logic_connect_out(gui_port_0x1bbf550, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf570 = gui_port_0x1bbf570;
	sig_std_logic_connect_out(gui_port_0x1bbf570, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf590 = gui_port_0x1bbf590;
	sig_std_logic_connect_out(gui_port_0x1bbf590, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf5b0 = gui_port_0x1bbf5b0;
	sig_std_logic_connect_out(gui_port_0x1bbf5b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf5d0 = gui_port_0x1bbf5d0;
	sig_std_logic_connect_out(gui_port_0x1bbf5d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf5f0 = gui_port_0x1bbf5f0;
	sig_std_logic_connect_out(gui_port_0x1bbf5f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf610 = gui_port_0x1bbf610;
	sig_std_logic_connect_out(gui_port_0x1bbf610, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf630 = gui_port_0x1bbf630;
	sig_std_logic_connect_out(gui_port_0x1bbf630, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf650 = gui_port_0x1bbf650;
	sig_std_logic_connect_out(gui_port_0x1bbf650, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf670 = gui_port_0x1bbf670;
	sig_std_logic_connect_out(gui_port_0x1bbf670, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf690 = gui_port_0x1bbf690;
	sig_std_logic_connect_out(gui_port_0x1bbf690, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf6b0 = gui_port_0x1bbf6b0;
	sig_std_logic_connect_out(gui_port_0x1bbf6b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf6d0 = gui_port_0x1bbf6d0;
	sig_std_logic_connect_out(gui_port_0x1bbf6d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf6f0 = gui_port_0x1bbf6f0;
	sig_std_logic_connect_out(gui_port_0x1bbf6f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf710 = gui_port_0x1bbf710;
	sig_std_logic_connect_out(gui_port_0x1bbf710, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf730 = gui_port_0x1bbf730;
	sig_std_logic_connect_out(gui_port_0x1bbf730, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bbf750 = gui_port_0x1bbf750;
	sig_std_logic_connect_out(gui_port_0x1bbf750, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc05f0 = gui_port_0x1bc05f0;
	sig_std_logic_connect_out(gui_port_0x1bc05f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc0740 = gui_port_0x1bc0740;
	sig_std_logic_connect_out(gui_port_0x1bc0740, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc0890 = gui_port_0x1bc0890;
	sig_std_logic_connect_out(gui_port_0x1bc0890, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc09e0 = gui_port_0x1bc09e0;
	sig_std_logic_connect_out(gui_port_0x1bc09e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc0b30 = gui_port_0x1bc0b30;
	sig_std_logic_connect_out(gui_port_0x1bc0b30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc0c80 = gui_port_0x1bc0c80;
	sig_std_logic_connect_out(gui_port_0x1bc0c80, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc0dd0 = gui_port_0x1bc0dd0;
	sig_std_logic_connect_out(gui_port_0x1bc0dd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc0f20 = gui_port_0x1bc0f20;
	sig_std_logic_connect_out(gui_port_0x1bc0f20, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1070 = gui_port_0x1bc1070;
	sig_std_logic_connect_out(gui_port_0x1bc1070, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc11c0 = gui_port_0x1bc11c0;
	sig_std_logic_connect_out(gui_port_0x1bc11c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1310 = gui_port_0x1bc1310;
	sig_std_logic_connect_out(gui_port_0x1bc1310, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1460 = gui_port_0x1bc1460;
	sig_std_logic_connect_out(gui_port_0x1bc1460, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc15b0 = gui_port_0x1bc15b0;
	sig_std_logic_connect_out(gui_port_0x1bc15b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1700 = gui_port_0x1bc1700;
	sig_std_logic_connect_out(gui_port_0x1bc1700, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1850 = gui_port_0x1bc1850;
	sig_std_logic_connect_out(gui_port_0x1bc1850, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc19a0 = gui_port_0x1bc19a0;
	sig_std_logic_connect_out(gui_port_0x1bc19a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1af0 = gui_port_0x1bc1af0;
	sig_std_logic_connect_out(gui_port_0x1bc1af0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1c40 = gui_port_0x1bc1c40;
	sig_std_logic_connect_out(gui_port_0x1bc1c40, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1d90 = gui_port_0x1bc1d90;
	sig_std_logic_connect_out(gui_port_0x1bc1d90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc1ee0 = gui_port_0x1bc1ee0;
	sig_std_logic_connect_out(gui_port_0x1bc1ee0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2030 = gui_port_0x1bc2030;
	sig_std_logic_connect_out(gui_port_0x1bc2030, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2180 = gui_port_0x1bc2180;
	sig_std_logic_connect_out(gui_port_0x1bc2180, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc22d0 = gui_port_0x1bc22d0;
	sig_std_logic_connect_out(gui_port_0x1bc22d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2420 = gui_port_0x1bc2420;
	sig_std_logic_connect_out(gui_port_0x1bc2420, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2570 = gui_port_0x1bc2570;
	sig_std_logic_connect_out(gui_port_0x1bc2570, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc26c0 = gui_port_0x1bc26c0;
	sig_std_logic_connect_out(gui_port_0x1bc26c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2810 = gui_port_0x1bc2810;
	sig_std_logic_connect_out(gui_port_0x1bc2810, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2960 = gui_port_0x1bc2960;
	sig_std_logic_connect_out(gui_port_0x1bc2960, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2ab0 = gui_port_0x1bc2ab0;
	sig_std_logic_connect_out(gui_port_0x1bc2ab0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2c00 = gui_port_0x1bc2c00;
	sig_std_logic_connect_out(gui_port_0x1bc2c00, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2d50 = gui_port_0x1bc2d50;
	sig_std_logic_connect_out(gui_port_0x1bc2d50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2ea0 = gui_port_0x1bc2ea0;
	sig_std_logic_connect_out(gui_port_0x1bc2ea0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc2ff0 = gui_port_0x1bc2ff0;
	sig_std_logic_connect_out(gui_port_0x1bc2ff0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3140 = gui_port_0x1bc3140;
	sig_std_logic_connect_out(gui_port_0x1bc3140, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3290 = gui_port_0x1bc3290;
	sig_std_logic_connect_out(gui_port_0x1bc3290, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc33e0 = gui_port_0x1bc33e0;
	sig_std_logic_connect_out(gui_port_0x1bc33e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3530 = gui_port_0x1bc3530;
	sig_std_logic_connect_out(gui_port_0x1bc3530, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3680 = gui_port_0x1bc3680;
	sig_std_logic_connect_out(gui_port_0x1bc3680, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc37d0 = gui_port_0x1bc37d0;
	sig_std_logic_connect_out(gui_port_0x1bc37d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3920 = gui_port_0x1bc3920;
	sig_std_logic_connect_out(gui_port_0x1bc3920, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3a70 = gui_port_0x1bc3a70;
	sig_std_logic_connect_out(gui_port_0x1bc3a70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3bc0 = gui_port_0x1bc3bc0;
	sig_std_logic_connect_out(gui_port_0x1bc3bc0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3d10 = gui_port_0x1bc3d10;
	sig_std_logic_connect_out(gui_port_0x1bc3d10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3e60 = gui_port_0x1bc3e60;
	sig_std_logic_connect_out(gui_port_0x1bc3e60, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc3fb0 = gui_port_0x1bc3fb0;
	sig_std_logic_connect_out(gui_port_0x1bc3fb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4100 = gui_port_0x1bc4100;
	sig_std_logic_connect_out(gui_port_0x1bc4100, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4250 = gui_port_0x1bc4250;
	sig_std_logic_connect_out(gui_port_0x1bc4250, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc43a0 = gui_port_0x1bc43a0;
	sig_std_logic_connect_out(gui_port_0x1bc43a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc44f0 = gui_port_0x1bc44f0;
	sig_std_logic_connect_out(gui_port_0x1bc44f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4640 = gui_port_0x1bc4640;
	sig_std_logic_connect_out(gui_port_0x1bc4640, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4790 = gui_port_0x1bc4790;
	sig_std_logic_connect_out(gui_port_0x1bc4790, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc48e0 = gui_port_0x1bc48e0;
	sig_std_logic_connect_out(gui_port_0x1bc48e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4a30 = gui_port_0x1bc4a30;
	sig_std_logic_connect_out(gui_port_0x1bc4a30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4b80 = gui_port_0x1bc4b80;
	sig_std_logic_connect_out(gui_port_0x1bc4b80, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4cd0 = gui_port_0x1bc4cd0;
	sig_std_logic_connect_out(gui_port_0x1bc4cd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4e20 = gui_port_0x1bc4e20;
	sig_std_logic_connect_out(gui_port_0x1bc4e20, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc4f70 = gui_port_0x1bc4f70;
	sig_std_logic_connect_out(gui_port_0x1bc4f70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc50c0 = gui_port_0x1bc50c0;
	sig_std_logic_connect_out(gui_port_0x1bc50c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5210 = gui_port_0x1bc5210;
	sig_std_logic_connect_out(gui_port_0x1bc5210, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5360 = gui_port_0x1bc5360;
	sig_std_logic_connect_out(gui_port_0x1bc5360, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc54b0 = gui_port_0x1bc54b0;
	sig_std_logic_connect_out(gui_port_0x1bc54b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5600 = gui_port_0x1bc5600;
	sig_std_logic_connect_out(gui_port_0x1bc5600, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5750 = gui_port_0x1bc5750;
	sig_std_logic_connect_out(gui_port_0x1bc5750, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc58a0 = gui_port_0x1bc58a0;
	sig_std_logic_connect_out(gui_port_0x1bc58a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc59f0 = gui_port_0x1bc59f0;
	sig_std_logic_connect_out(gui_port_0x1bc59f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5b40 = gui_port_0x1bc5b40;
	sig_std_logic_connect_out(gui_port_0x1bc5b40, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5c90 = gui_port_0x1bc5c90;
	sig_std_logic_connect_out(gui_port_0x1bc5c90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5de0 = gui_port_0x1bc5de0;
	sig_std_logic_connect_out(gui_port_0x1bc5de0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc5f30 = gui_port_0x1bc5f30;
	sig_std_logic_connect_out(gui_port_0x1bc5f30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6080 = gui_port_0x1bc6080;
	sig_std_logic_connect_out(gui_port_0x1bc6080, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc61d0 = gui_port_0x1bc61d0;
	sig_std_logic_connect_out(gui_port_0x1bc61d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6320 = gui_port_0x1bc6320;
	sig_std_logic_connect_out(gui_port_0x1bc6320, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6470 = gui_port_0x1bc6470;
	sig_std_logic_connect_out(gui_port_0x1bc6470, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc65c0 = gui_port_0x1bc65c0;
	sig_std_logic_connect_out(gui_port_0x1bc65c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6710 = gui_port_0x1bc6710;
	sig_std_logic_connect_out(gui_port_0x1bc6710, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6860 = gui_port_0x1bc6860;
	sig_std_logic_connect_out(gui_port_0x1bc6860, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc69b0 = gui_port_0x1bc69b0;
	sig_std_logic_connect_out(gui_port_0x1bc69b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6b00 = gui_port_0x1bc6b00;
	sig_std_logic_connect_out(gui_port_0x1bc6b00, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6c50 = gui_port_0x1bc6c50;
	sig_std_logic_connect_out(gui_port_0x1bc6c50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6da0 = gui_port_0x1bc6da0;
	sig_std_logic_connect_out(gui_port_0x1bc6da0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc6ef0 = gui_port_0x1bc6ef0;
	sig_std_logic_connect_out(gui_port_0x1bc6ef0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7040 = gui_port_0x1bc7040;
	sig_std_logic_connect_out(gui_port_0x1bc7040, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7190 = gui_port_0x1bc7190;
	sig_std_logic_connect_out(gui_port_0x1bc7190, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc72e0 = gui_port_0x1bc72e0;
	sig_std_logic_connect_out(gui_port_0x1bc72e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7430 = gui_port_0x1bc7430;
	sig_std_logic_connect_out(gui_port_0x1bc7430, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7580 = gui_port_0x1bc7580;
	sig_std_logic_connect_out(gui_port_0x1bc7580, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc76d0 = gui_port_0x1bc76d0;
	sig_std_logic_connect_out(gui_port_0x1bc76d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7820 = gui_port_0x1bc7820;
	sig_std_logic_connect_out(gui_port_0x1bc7820, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7970 = gui_port_0x1bc7970;
	sig_std_logic_connect_out(gui_port_0x1bc7970, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7ac0 = gui_port_0x1bc7ac0;
	sig_std_logic_connect_out(gui_port_0x1bc7ac0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7c10 = gui_port_0x1bc7c10;
	sig_std_logic_connect_out(gui_port_0x1bc7c10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7d60 = gui_port_0x1bc7d60;
	sig_std_logic_connect_out(gui_port_0x1bc7d60, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc7eb0 = gui_port_0x1bc7eb0;
	sig_std_logic_connect_out(gui_port_0x1bc7eb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8000 = gui_port_0x1bc8000;
	sig_std_logic_connect_out(gui_port_0x1bc8000, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8150 = gui_port_0x1bc8150;
	sig_std_logic_connect_out(gui_port_0x1bc8150, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc82a0 = gui_port_0x1bc82a0;
	sig_std_logic_connect_out(gui_port_0x1bc82a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc83f0 = gui_port_0x1bc83f0;
	sig_std_logic_connect_out(gui_port_0x1bc83f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8540 = gui_port_0x1bc8540;
	sig_std_logic_connect_out(gui_port_0x1bc8540, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8690 = gui_port_0x1bc8690;
	sig_std_logic_connect_out(gui_port_0x1bc8690, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc87e0 = gui_port_0x1bc87e0;
	sig_std_logic_connect_out(gui_port_0x1bc87e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8930 = gui_port_0x1bc8930;
	sig_std_logic_connect_out(gui_port_0x1bc8930, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8a80 = gui_port_0x1bc8a80;
	sig_std_logic_connect_out(gui_port_0x1bc8a80, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8bd0 = gui_port_0x1bc8bd0;
	sig_std_logic_connect_out(gui_port_0x1bc8bd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8d20 = gui_port_0x1bc8d20;
	sig_std_logic_connect_out(gui_port_0x1bc8d20, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8e70 = gui_port_0x1bc8e70;
	sig_std_logic_connect_out(gui_port_0x1bc8e70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc8fc0 = gui_port_0x1bc8fc0;
	sig_std_logic_connect_out(gui_port_0x1bc8fc0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb6b50 = gui_port_0x1bb6b50;
	sig_std_logic_connect_out(gui_port_0x1bb6b50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb8250 = gui_port_0x1bb8250;
	sig_std_logic_connect_out(gui_port_0x1bb8250, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bb82b0 = gui_port_0x1bb82b0;
	sig_std_logic_connect_out(gui_port_0x1bb82b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc91c0 = gui_port_0x1bc91c0;
	sig_std_logic_connect_out(gui_port_0x1bc91c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9310 = gui_port_0x1bc9310;
	sig_std_logic_connect_out(gui_port_0x1bc9310, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9460 = gui_port_0x1bc9460;
	sig_std_logic_connect_out(gui_port_0x1bc9460, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc95b0 = gui_port_0x1bc95b0;
	sig_std_logic_connect_out(gui_port_0x1bc95b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9700 = gui_port_0x1bc9700;
	sig_std_logic_connect_out(gui_port_0x1bc9700, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9850 = gui_port_0x1bc9850;
	sig_std_logic_connect_out(gui_port_0x1bc9850, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc99a0 = gui_port_0x1bc99a0;
	sig_std_logic_connect_out(gui_port_0x1bc99a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9af0 = gui_port_0x1bc9af0;
	sig_std_logic_connect_out(gui_port_0x1bc9af0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9c40 = gui_port_0x1bc9c40;
	sig_std_logic_connect_out(gui_port_0x1bc9c40, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9d90 = gui_port_0x1bc9d90;
	sig_std_logic_connect_out(gui_port_0x1bc9d90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bc9ee0 = gui_port_0x1bc9ee0;
	sig_std_logic_connect_out(gui_port_0x1bc9ee0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca030 = gui_port_0x1bca030;
	sig_std_logic_connect_out(gui_port_0x1bca030, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca180 = gui_port_0x1bca180;
	sig_std_logic_connect_out(gui_port_0x1bca180, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca2d0 = gui_port_0x1bca2d0;
	sig_std_logic_connect_out(gui_port_0x1bca2d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca420 = gui_port_0x1bca420;
	sig_std_logic_connect_out(gui_port_0x1bca420, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca570 = gui_port_0x1bca570;
	sig_std_logic_connect_out(gui_port_0x1bca570, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca6c0 = gui_port_0x1bca6c0;
	sig_std_logic_connect_out(gui_port_0x1bca6c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca810 = gui_port_0x1bca810;
	sig_std_logic_connect_out(gui_port_0x1bca810, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bca960 = gui_port_0x1bca960;
	sig_std_logic_connect_out(gui_port_0x1bca960, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcaab0 = gui_port_0x1bcaab0;
	sig_std_logic_connect_out(gui_port_0x1bcaab0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcac00 = gui_port_0x1bcac00;
	sig_std_logic_connect_out(gui_port_0x1bcac00, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcad50 = gui_port_0x1bcad50;
	sig_std_logic_connect_out(gui_port_0x1bcad50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcaea0 = gui_port_0x1bcaea0;
	sig_std_logic_connect_out(gui_port_0x1bcaea0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcaff0 = gui_port_0x1bcaff0;
	sig_std_logic_connect_out(gui_port_0x1bcaff0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb140 = gui_port_0x1bcb140;
	sig_std_logic_connect_out(gui_port_0x1bcb140, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb290 = gui_port_0x1bcb290;
	sig_std_logic_connect_out(gui_port_0x1bcb290, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb3e0 = gui_port_0x1bcb3e0;
	sig_std_logic_connect_out(gui_port_0x1bcb3e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb530 = gui_port_0x1bcb530;
	sig_std_logic_connect_out(gui_port_0x1bcb530, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb680 = gui_port_0x1bcb680;
	sig_std_logic_connect_out(gui_port_0x1bcb680, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb7d0 = gui_port_0x1bcb7d0;
	sig_std_logic_connect_out(gui_port_0x1bcb7d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcb920 = gui_port_0x1bcb920;
	sig_std_logic_connect_out(gui_port_0x1bcb920, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcba70 = gui_port_0x1bcba70;
	sig_std_logic_connect_out(gui_port_0x1bcba70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcbbc0 = gui_port_0x1bcbbc0;
	sig_std_logic_connect_out(gui_port_0x1bcbbc0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcbd10 = gui_port_0x1bcbd10;
	sig_std_logic_connect_out(gui_port_0x1bcbd10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcbe60 = gui_port_0x1bcbe60;
	sig_std_logic_connect_out(gui_port_0x1bcbe60, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcbfb0 = gui_port_0x1bcbfb0;
	sig_std_logic_connect_out(gui_port_0x1bcbfb0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc100 = gui_port_0x1bcc100;
	sig_std_logic_connect_out(gui_port_0x1bcc100, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc250 = gui_port_0x1bcc250;
	sig_std_logic_connect_out(gui_port_0x1bcc250, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc3a0 = gui_port_0x1bcc3a0;
	sig_std_logic_connect_out(gui_port_0x1bcc3a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc4f0 = gui_port_0x1bcc4f0;
	sig_std_logic_connect_out(gui_port_0x1bcc4f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc640 = gui_port_0x1bcc640;
	sig_std_logic_connect_out(gui_port_0x1bcc640, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc790 = gui_port_0x1bcc790;
	sig_std_logic_connect_out(gui_port_0x1bcc790, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcc8e0 = gui_port_0x1bcc8e0;
	sig_std_logic_connect_out(gui_port_0x1bcc8e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcca30 = gui_port_0x1bcca30;
	sig_std_logic_connect_out(gui_port_0x1bcca30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bccb80 = gui_port_0x1bccb80;
	sig_std_logic_connect_out(gui_port_0x1bccb80, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcccd0 = gui_port_0x1bcccd0;
	sig_std_logic_connect_out(gui_port_0x1bcccd0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcce20 = gui_port_0x1bcce20;
	sig_std_logic_connect_out(gui_port_0x1bcce20, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bccf70 = gui_port_0x1bccf70;
	sig_std_logic_connect_out(gui_port_0x1bccf70, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd0c0 = gui_port_0x1bcd0c0;
	sig_std_logic_connect_out(gui_port_0x1bcd0c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd210 = gui_port_0x1bcd210;
	sig_std_logic_connect_out(gui_port_0x1bcd210, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd360 = gui_port_0x1bcd360;
	sig_std_logic_connect_out(gui_port_0x1bcd360, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd4b0 = gui_port_0x1bcd4b0;
	sig_std_logic_connect_out(gui_port_0x1bcd4b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd600 = gui_port_0x1bcd600;
	sig_std_logic_connect_out(gui_port_0x1bcd600, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd750 = gui_port_0x1bcd750;
	sig_std_logic_connect_out(gui_port_0x1bcd750, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd8a0 = gui_port_0x1bcd8a0;
	sig_std_logic_connect_out(gui_port_0x1bcd8a0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcd9f0 = gui_port_0x1bcd9f0;
	sig_std_logic_connect_out(gui_port_0x1bcd9f0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcdb40 = gui_port_0x1bcdb40;
	sig_std_logic_connect_out(gui_port_0x1bcdb40, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcdc90 = gui_port_0x1bcdc90;
	sig_std_logic_connect_out(gui_port_0x1bcdc90, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcdde0 = gui_port_0x1bcdde0;
	sig_std_logic_connect_out(gui_port_0x1bcdde0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcdf30 = gui_port_0x1bcdf30;
	sig_std_logic_connect_out(gui_port_0x1bcdf30, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce080 = gui_port_0x1bce080;
	sig_std_logic_connect_out(gui_port_0x1bce080, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce1d0 = gui_port_0x1bce1d0;
	sig_std_logic_connect_out(gui_port_0x1bce1d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce320 = gui_port_0x1bce320;
	sig_std_logic_connect_out(gui_port_0x1bce320, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce470 = gui_port_0x1bce470;
	sig_std_logic_connect_out(gui_port_0x1bce470, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce5c0 = gui_port_0x1bce5c0;
	sig_std_logic_connect_out(gui_port_0x1bce5c0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce710 = gui_port_0x1bce710;
	sig_std_logic_connect_out(gui_port_0x1bce710, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce860 = gui_port_0x1bce860;
	sig_std_logic_connect_out(gui_port_0x1bce860, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bce9b0 = gui_port_0x1bce9b0;
	sig_std_logic_connect_out(gui_port_0x1bce9b0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bceb00 = gui_port_0x1bceb00;
	sig_std_logic_connect_out(gui_port_0x1bceb00, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcec50 = gui_port_0x1bcec50;
	sig_std_logic_connect_out(gui_port_0x1bcec50, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bceda0 = gui_port_0x1bceda0;
	sig_std_logic_connect_out(gui_port_0x1bceda0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bceef0 = gui_port_0x1bceef0;
	sig_std_logic_connect_out(gui_port_0x1bceef0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf040 = gui_port_0x1bcf040;
	sig_std_logic_connect_out(gui_port_0x1bcf040, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf190 = gui_port_0x1bcf190;
	sig_std_logic_connect_out(gui_port_0x1bcf190, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf2e0 = gui_port_0x1bcf2e0;
	sig_std_logic_connect_out(gui_port_0x1bcf2e0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf430 = gui_port_0x1bcf430;
	sig_std_logic_connect_out(gui_port_0x1bcf430, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf580 = gui_port_0x1bcf580;
	sig_std_logic_connect_out(gui_port_0x1bcf580, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf6d0 = gui_port_0x1bcf6d0;
	sig_std_logic_connect_out(gui_port_0x1bcf6d0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf820 = gui_port_0x1bcf820;
	sig_std_logic_connect_out(gui_port_0x1bcf820, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcf970 = gui_port_0x1bcf970;
	sig_std_logic_connect_out(gui_port_0x1bcf970, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcfac0 = gui_port_0x1bcfac0;
	sig_std_logic_connect_out(gui_port_0x1bcfac0, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcfc10 = gui_port_0x1bcfc10;
	sig_std_logic_connect_out(gui_port_0x1bcfc10, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcfd60 = gui_port_0x1bcfd60;
	sig_std_logic_connect_out(gui_port_0x1bcfd60, cpssp, SIG_STD_LOGIC_Z);
	cpssp->gui_port_0x1bcfeb0 = gui_port_0x1bcfeb0;
	sig_std_logic_connect_out(gui_port_0x1bcfeb0, cpssp, SIG_STD_LOGIC_Z);

	/* connect ports as in */
	sig_std_logic_connect_in(port_Uhr1, cpssp, &port_func_Uhr1);
	sig_std_logic_connect_in(port_Uhr2, cpssp, &port_func_Uhr2);
	sig_std_logic_connect_in(port_Imp1, cpssp, &port_func_Imp1);
	sig_std_logic_connect_in(port_Imp2, cpssp, &port_func_Imp2);
	sig_std_logic_connect_in(port_22I1, cpssp, &port_func_22I1);
	sig_std_logic_connect_in(port_22I2, cpssp, &port_func_22I2);
	sig_std_logic_connect_in(port_22I3, cpssp, &port_func_22I3);
	sig_std_logic_connect_in(port_22I4, cpssp, &port_func_22I4);
	sig_std_logic_connect_in(port_22I5, cpssp, &port_func_22I5);
	sig_std_logic_connect_in(port_22I6, cpssp, &port_func_22I6);
	sig_std_logic_connect_in(port_22I7, cpssp, &port_func_22I7);
	sig_std_logic_connect_in(port_22I8, cpssp, &port_func_22I8);
	sig_std_logic_connect_in(port_22I9, cpssp, &port_func_22I9);
	sig_std_logic_connect_in(port_22I0, cpssp, &port_func_22I0);
	sig_std_logic_connect_in(port_22II1, cpssp, &port_func_22II1);
	sig_std_logic_connect_in(port_22II2, cpssp, &port_func_22II2);
	sig_std_logic_connect_in(port_22II3, cpssp, &port_func_22II3);
	sig_std_logic_connect_in(port_22II4, cpssp, &port_func_22II4);
	sig_std_logic_connect_in(port_22II5, cpssp, &port_func_22II5);
	sig_std_logic_connect_in(port_22II6, cpssp, &port_func_22II6);
	sig_std_logic_connect_in(port_22II7, cpssp, &port_func_22II7);
	sig_std_logic_connect_in(port_22II8, cpssp, &port_func_22II8);
	sig_std_logic_connect_in(port_22II9, cpssp, &port_func_22II9);
	sig_std_logic_connect_in(port_22II0, cpssp, &port_func_22II0);
	sig_std_logic_connect_in(port_22III1, cpssp, &port_func_22III1);
	sig_std_logic_connect_in(port_22III2, cpssp, &port_func_22III2);
	sig_std_logic_connect_in(port_22III3, cpssp, &port_func_22III3);
	sig_std_logic_connect_in(port_22III4, cpssp, &port_func_22III4);
	sig_std_logic_connect_in(port_22III5, cpssp, &port_func_22III5);
	sig_std_logic_connect_in(port_22III6, cpssp, &port_func_22III6);
	sig_std_logic_connect_in(port_22III7, cpssp, &port_func_22III7);
	sig_std_logic_connect_in(port_22III8, cpssp, &port_func_22III8);
	sig_std_logic_connect_in(port_22III9, cpssp, &port_func_22III9);
	sig_std_logic_connect_in(port_22III0, cpssp, &port_func_22III0);
	sig_std_logic_connect_in(port_30I1, cpssp, &port_func_30I1);
	sig_std_logic_connect_in(port_30I2, cpssp, &port_func_30I2);
	sig_std_logic_connect_in(port_30I3, cpssp, &port_func_30I3);
	sig_std_logic_connect_in(port_30I4, cpssp, &port_func_30I4);
	sig_std_logic_connect_in(port_30I5, cpssp, &port_func_30I5);
	sig_std_logic_connect_in(port_30I6, cpssp, &port_func_30I6);
	sig_std_logic_connect_in(port_30I7, cpssp, &port_func_30I7);
	sig_std_logic_connect_in(port_30I8, cpssp, &port_func_30I8);
	sig_std_logic_connect_in(port_30I9, cpssp, &port_func_30I9);
	sig_std_logic_connect_in(port_30I0, cpssp, &port_func_30I0);
	sig_std_logic_connect_in(port_30II1, cpssp, &port_func_30II1);
	sig_std_logic_connect_in(port_30II2, cpssp, &port_func_30II2);
	sig_std_logic_connect_in(port_30II3, cpssp, &port_func_30II3);
	sig_std_logic_connect_in(port_30II4, cpssp, &port_func_30II4);
	sig_std_logic_connect_in(port_30II5, cpssp, &port_func_30II5);
	sig_std_logic_connect_in(port_30II6, cpssp, &port_func_30II6);
	sig_std_logic_connect_in(port_30II7, cpssp, &port_func_30II7);
	sig_std_logic_connect_in(port_30II8, cpssp, &port_func_30II8);
	sig_std_logic_connect_in(port_30II9, cpssp, &port_func_30II9);
	sig_std_logic_connect_in(port_30II0, cpssp, &port_func_30II0);
	sig_std_logic_connect_in(port_30III1, cpssp, &port_func_30III1);
	sig_std_logic_connect_in(port_30III2, cpssp, &port_func_30III2);
	sig_std_logic_connect_in(port_30III3, cpssp, &port_func_30III3);
	sig_std_logic_connect_in(port_30III4, cpssp, &port_func_30III4);
	sig_std_logic_connect_in(port_30III5, cpssp, &port_func_30III5);
	sig_std_logic_connect_in(port_30III6, cpssp, &port_func_30III6);
	sig_std_logic_connect_in(port_30III7, cpssp, &port_func_30III7);
	sig_std_logic_connect_in(port_30III8, cpssp, &port_func_30III8);
	sig_std_logic_connect_in(port_30III9, cpssp, &port_func_30III9);
	sig_std_logic_connect_in(port_30III0, cpssp, &port_func_30III0);

	/* connect gui ports as in */
	sig_std_logic_connect_in(gui_port_0x1bb8760, cpssp, &gui_port_func_0x1bb8760);
	sig_std_logic_connect_in(gui_port_0x1bb9650, cpssp, &gui_port_func_0x1bb9650);
	sig_std_logic_connect_in(gui_port_0x1bb9630, cpssp, &gui_port_func_0x1bb9630);
	sig_std_logic_connect_in(gui_port_0x1bb69a0, cpssp, &gui_port_func_0x1bb69a0);
	sig_std_logic_connect_in(gui_port_0x1bb82f0, cpssp, &gui_port_func_0x1bb82f0);
	sig_std_logic_connect_in(gui_port_0x1bb81b0, cpssp, &gui_port_func_0x1bb81b0);
	sig_std_logic_connect_in(gui_port_0x1bb8f00, cpssp, &gui_port_func_0x1bb8f00);
	sig_std_logic_connect_in(gui_port_0x1bb3b20, cpssp, &gui_port_func_0x1bb3b20);
	sig_std_logic_connect_in(gui_port_0x1bb6a40, cpssp, &gui_port_func_0x1bb6a40);
	sig_std_logic_connect_in(gui_port_0x1bb8550, cpssp, &gui_port_func_0x1bb8550);
	sig_std_logic_connect_in(gui_port_0x1bb6980, cpssp, &gui_port_func_0x1bb6980);
	sig_std_logic_connect_in(gui_port_0x1bb8190, cpssp, &gui_port_func_0x1bb8190);
	sig_std_logic_connect_in(gui_port_0x1bb6640, cpssp, &gui_port_func_0x1bb6640);
	sig_std_logic_connect_in(gui_port_0x1bbe9b0, cpssp, &gui_port_func_0x1bbe9b0);
	sig_std_logic_connect_in(gui_port_0x1bbe9d0, cpssp, &gui_port_func_0x1bbe9d0);
	sig_std_logic_connect_in(gui_port_0x1bbe9f0, cpssp, &gui_port_func_0x1bbe9f0);
	sig_std_logic_connect_in(gui_port_0x1bbea10, cpssp, &gui_port_func_0x1bbea10);
	sig_std_logic_connect_in(gui_port_0x1bbea30, cpssp, &gui_port_func_0x1bbea30);
	sig_std_logic_connect_in(gui_port_0x1bbea50, cpssp, &gui_port_func_0x1bbea50);
	sig_std_logic_connect_in(gui_port_0x1bbea70, cpssp, &gui_port_func_0x1bbea70);
	sig_std_logic_connect_in(gui_port_0x1bbea90, cpssp, &gui_port_func_0x1bbea90);
	sig_std_logic_connect_in(gui_port_0x1bbeab0, cpssp, &gui_port_func_0x1bbeab0);
	sig_std_logic_connect_in(gui_port_0x1bbead0, cpssp, &gui_port_func_0x1bbead0);
	sig_std_logic_connect_in(gui_port_0x1bbeaf0, cpssp, &gui_port_func_0x1bbeaf0);
	sig_std_logic_connect_in(gui_port_0x1bbeb10, cpssp, &gui_port_func_0x1bbeb10);
	sig_std_logic_connect_in(gui_port_0x1bbeb30, cpssp, &gui_port_func_0x1bbeb30);
	sig_std_logic_connect_in(gui_port_0x1bbeb50, cpssp, &gui_port_func_0x1bbeb50);
	sig_std_logic_connect_in(gui_port_0x1bbeb70, cpssp, &gui_port_func_0x1bbeb70);
	sig_std_logic_connect_in(gui_port_0x1bbeb90, cpssp, &gui_port_func_0x1bbeb90);
	sig_std_logic_connect_in(gui_port_0x1bbebb0, cpssp, &gui_port_func_0x1bbebb0);
	sig_std_logic_connect_in(gui_port_0x1bbebd0, cpssp, &gui_port_func_0x1bbebd0);
	sig_std_logic_connect_in(gui_port_0x1bbebf0, cpssp, &gui_port_func_0x1bbebf0);
	sig_std_logic_connect_in(gui_port_0x1bbec10, cpssp, &gui_port_func_0x1bbec10);
	sig_std_logic_connect_in(gui_port_0x1bbec30, cpssp, &gui_port_func_0x1bbec30);
	sig_std_logic_connect_in(gui_port_0x1bbec50, cpssp, &gui_port_func_0x1bbec50);
	sig_std_logic_connect_in(gui_port_0x1bbec70, cpssp, &gui_port_func_0x1bbec70);
	sig_std_logic_connect_in(gui_port_0x1bbec90, cpssp, &gui_port_func_0x1bbec90);
	sig_std_logic_connect_in(gui_port_0x1bbecb0, cpssp, &gui_port_func_0x1bbecb0);
	sig_std_logic_connect_in(gui_port_0x1bbecd0, cpssp, &gui_port_func_0x1bbecd0);
	sig_std_logic_connect_in(gui_port_0x1bbecf0, cpssp, &gui_port_func_0x1bbecf0);
	sig_std_logic_connect_in(gui_port_0x1bbed10, cpssp, &gui_port_func_0x1bbed10);
	sig_std_logic_connect_in(gui_port_0x1bbed30, cpssp, &gui_port_func_0x1bbed30);
	sig_std_logic_connect_in(gui_port_0x1bbed50, cpssp, &gui_port_func_0x1bbed50);
	sig_std_logic_connect_in(gui_port_0x1bbed70, cpssp, &gui_port_func_0x1bbed70);
	sig_std_logic_connect_in(gui_port_0x1bbed90, cpssp, &gui_port_func_0x1bbed90);
	sig_std_logic_connect_in(gui_port_0x1bbedb0, cpssp, &gui_port_func_0x1bbedb0);
	sig_std_logic_connect_in(gui_port_0x1bbedd0, cpssp, &gui_port_func_0x1bbedd0);
	sig_std_logic_connect_in(gui_port_0x1bbedf0, cpssp, &gui_port_func_0x1bbedf0);
	sig_std_logic_connect_in(gui_port_0x1bbee10, cpssp, &gui_port_func_0x1bbee10);
	sig_std_logic_connect_in(gui_port_0x1bbee30, cpssp, &gui_port_func_0x1bbee30);
	sig_std_logic_connect_in(gui_port_0x1bbee50, cpssp, &gui_port_func_0x1bbee50);
	sig_std_logic_connect_in(gui_port_0x1bbee70, cpssp, &gui_port_func_0x1bbee70);
	sig_std_logic_connect_in(gui_port_0x1bbee90, cpssp, &gui_port_func_0x1bbee90);
	sig_std_logic_connect_in(gui_port_0x1bbeeb0, cpssp, &gui_port_func_0x1bbeeb0);
	sig_std_logic_connect_in(gui_port_0x1bbeed0, cpssp, &gui_port_func_0x1bbeed0);
	sig_std_logic_connect_in(gui_port_0x1bbeef0, cpssp, &gui_port_func_0x1bbeef0);
	sig_std_logic_connect_in(gui_port_0x1bbef10, cpssp, &gui_port_func_0x1bbef10);
	sig_std_logic_connect_in(gui_port_0x1bbef30, cpssp, &gui_port_func_0x1bbef30);
	sig_std_logic_connect_in(gui_port_0x1bbef50, cpssp, &gui_port_func_0x1bbef50);
	sig_std_logic_connect_in(gui_port_0x1bbef70, cpssp, &gui_port_func_0x1bbef70);
	sig_std_logic_connect_in(gui_port_0x1bbef90, cpssp, &gui_port_func_0x1bbef90);
	sig_std_logic_connect_in(gui_port_0x1bbefb0, cpssp, &gui_port_func_0x1bbefb0);
	sig_std_logic_connect_in(gui_port_0x1bbefd0, cpssp, &gui_port_func_0x1bbefd0);
	sig_std_logic_connect_in(gui_port_0x1bbeff0, cpssp, &gui_port_func_0x1bbeff0);
	sig_std_logic_connect_in(gui_port_0x1bbf010, cpssp, &gui_port_func_0x1bbf010);
	sig_std_logic_connect_in(gui_port_0x1bbf030, cpssp, &gui_port_func_0x1bbf030);
	sig_std_logic_connect_in(gui_port_0x1bbf050, cpssp, &gui_port_func_0x1bbf050);
	sig_std_logic_connect_in(gui_port_0x1bbf070, cpssp, &gui_port_func_0x1bbf070);
	sig_std_logic_connect_in(gui_port_0x1bbf090, cpssp, &gui_port_func_0x1bbf090);
	sig_std_logic_connect_in(gui_port_0x1bbf0b0, cpssp, &gui_port_func_0x1bbf0b0);
	sig_std_logic_connect_in(gui_port_0x1bbf0d0, cpssp, &gui_port_func_0x1bbf0d0);
	sig_std_logic_connect_in(gui_port_0x1bbf0f0, cpssp, &gui_port_func_0x1bbf0f0);
	sig_std_logic_connect_in(gui_port_0x1bbf110, cpssp, &gui_port_func_0x1bbf110);
	sig_std_logic_connect_in(gui_port_0x1bbf130, cpssp, &gui_port_func_0x1bbf130);
	sig_std_logic_connect_in(gui_port_0x1bbf150, cpssp, &gui_port_func_0x1bbf150);
	sig_std_logic_connect_in(gui_port_0x1bbf170, cpssp, &gui_port_func_0x1bbf170);
	sig_std_logic_connect_in(gui_port_0x1bbf190, cpssp, &gui_port_func_0x1bbf190);
	sig_std_logic_connect_in(gui_port_0x1bbf1b0, cpssp, &gui_port_func_0x1bbf1b0);
	sig_std_logic_connect_in(gui_port_0x1bbf1d0, cpssp, &gui_port_func_0x1bbf1d0);
	sig_std_logic_connect_in(gui_port_0x1bbf1f0, cpssp, &gui_port_func_0x1bbf1f0);
	sig_std_logic_connect_in(gui_port_0x1bbf210, cpssp, &gui_port_func_0x1bbf210);
	sig_std_logic_connect_in(gui_port_0x1bbf230, cpssp, &gui_port_func_0x1bbf230);
	sig_std_logic_connect_in(gui_port_0x1bbf250, cpssp, &gui_port_func_0x1bbf250);
	sig_std_logic_connect_in(gui_port_0x1bbf270, cpssp, &gui_port_func_0x1bbf270);
	sig_std_logic_connect_in(gui_port_0x1bbf290, cpssp, &gui_port_func_0x1bbf290);
	sig_std_logic_connect_in(gui_port_0x1bbf2b0, cpssp, &gui_port_func_0x1bbf2b0);
	sig_std_logic_connect_in(gui_port_0x1bbf2d0, cpssp, &gui_port_func_0x1bbf2d0);
	sig_std_logic_connect_in(gui_port_0x1bbf2f0, cpssp, &gui_port_func_0x1bbf2f0);
	sig_std_logic_connect_in(gui_port_0x1bbf310, cpssp, &gui_port_func_0x1bbf310);
	sig_std_logic_connect_in(gui_port_0x1bbf330, cpssp, &gui_port_func_0x1bbf330);
	sig_std_logic_connect_in(gui_port_0x1bbf350, cpssp, &gui_port_func_0x1bbf350);
	sig_std_logic_connect_in(gui_port_0x1bbf370, cpssp, &gui_port_func_0x1bbf370);
	sig_std_logic_connect_in(gui_port_0x1bbf390, cpssp, &gui_port_func_0x1bbf390);
	sig_std_logic_connect_in(gui_port_0x1bbf3b0, cpssp, &gui_port_func_0x1bbf3b0);
	sig_std_logic_connect_in(gui_port_0x1bbf3d0, cpssp, &gui_port_func_0x1bbf3d0);
	sig_std_logic_connect_in(gui_port_0x1bbf3f0, cpssp, &gui_port_func_0x1bbf3f0);
	sig_std_logic_connect_in(gui_port_0x1bbf410, cpssp, &gui_port_func_0x1bbf410);
	sig_std_logic_connect_in(gui_port_0x1bbf430, cpssp, &gui_port_func_0x1bbf430);
	sig_std_logic_connect_in(gui_port_0x1bbf450, cpssp, &gui_port_func_0x1bbf450);
	sig_std_logic_connect_in(gui_port_0x1bbf470, cpssp, &gui_port_func_0x1bbf470);
	sig_std_logic_connect_in(gui_port_0x1bbf490, cpssp, &gui_port_func_0x1bbf490);
	sig_std_logic_connect_in(gui_port_0x1bbf4b0, cpssp, &gui_port_func_0x1bbf4b0);
	sig_std_logic_connect_in(gui_port_0x1bbf4d0, cpssp, &gui_port_func_0x1bbf4d0);
	sig_std_logic_connect_in(gui_port_0x1bbf4f0, cpssp, &gui_port_func_0x1bbf4f0);
	sig_std_logic_connect_in(gui_port_0x1bbf510, cpssp, &gui_port_func_0x1bbf510);
	sig_std_logic_connect_in(gui_port_0x1bbf530, cpssp, &gui_port_func_0x1bbf530);
	sig_std_logic_connect_in(gui_port_0x1bbf550, cpssp, &gui_port_func_0x1bbf550);
	sig_std_logic_connect_in(gui_port_0x1bbf570, cpssp, &gui_port_func_0x1bbf570);
	sig_std_logic_connect_in(gui_port_0x1bbf590, cpssp, &gui_port_func_0x1bbf590);
	sig_std_logic_connect_in(gui_port_0x1bbf5b0, cpssp, &gui_port_func_0x1bbf5b0);
	sig_std_logic_connect_in(gui_port_0x1bbf5d0, cpssp, &gui_port_func_0x1bbf5d0);
	sig_std_logic_connect_in(gui_port_0x1bbf5f0, cpssp, &gui_port_func_0x1bbf5f0);
	sig_std_logic_connect_in(gui_port_0x1bbf610, cpssp, &gui_port_func_0x1bbf610);
	sig_std_logic_connect_in(gui_port_0x1bbf630, cpssp, &gui_port_func_0x1bbf630);
	sig_std_logic_connect_in(gui_port_0x1bbf650, cpssp, &gui_port_func_0x1bbf650);
	sig_std_logic_connect_in(gui_port_0x1bbf670, cpssp, &gui_port_func_0x1bbf670);
	sig_std_logic_connect_in(gui_port_0x1bbf690, cpssp, &gui_port_func_0x1bbf690);
	sig_std_logic_connect_in(gui_port_0x1bbf6b0, cpssp, &gui_port_func_0x1bbf6b0);
	sig_std_logic_connect_in(gui_port_0x1bbf6d0, cpssp, &gui_port_func_0x1bbf6d0);
	sig_std_logic_connect_in(gui_port_0x1bbf6f0, cpssp, &gui_port_func_0x1bbf6f0);
	sig_std_logic_connect_in(gui_port_0x1bbf710, cpssp, &gui_port_func_0x1bbf710);
	sig_std_logic_connect_in(gui_port_0x1bbf730, cpssp, &gui_port_func_0x1bbf730);
	sig_std_logic_connect_in(gui_port_0x1bbf750, cpssp, &gui_port_func_0x1bbf750);
	sig_std_logic_connect_in(gui_port_0x1bc05f0, cpssp, &gui_port_func_0x1bc05f0);
	sig_std_logic_connect_in(gui_port_0x1bc0740, cpssp, &gui_port_func_0x1bc0740);
	sig_std_logic_connect_in(gui_port_0x1bc0890, cpssp, &gui_port_func_0x1bc0890);
	sig_std_logic_connect_in(gui_port_0x1bc09e0, cpssp, &gui_port_func_0x1bc09e0);
	sig_std_logic_connect_in(gui_port_0x1bc0b30, cpssp, &gui_port_func_0x1bc0b30);
	sig_std_logic_connect_in(gui_port_0x1bc0c80, cpssp, &gui_port_func_0x1bc0c80);
	sig_std_logic_connect_in(gui_port_0x1bc0dd0, cpssp, &gui_port_func_0x1bc0dd0);
	sig_std_logic_connect_in(gui_port_0x1bc0f20, cpssp, &gui_port_func_0x1bc0f20);
	sig_std_logic_connect_in(gui_port_0x1bc1070, cpssp, &gui_port_func_0x1bc1070);
	sig_std_logic_connect_in(gui_port_0x1bc11c0, cpssp, &gui_port_func_0x1bc11c0);
	sig_std_logic_connect_in(gui_port_0x1bc1310, cpssp, &gui_port_func_0x1bc1310);
	sig_std_logic_connect_in(gui_port_0x1bc1460, cpssp, &gui_port_func_0x1bc1460);
	sig_std_logic_connect_in(gui_port_0x1bc15b0, cpssp, &gui_port_func_0x1bc15b0);
	sig_std_logic_connect_in(gui_port_0x1bc1700, cpssp, &gui_port_func_0x1bc1700);
	sig_std_logic_connect_in(gui_port_0x1bc1850, cpssp, &gui_port_func_0x1bc1850);
	sig_std_logic_connect_in(gui_port_0x1bc19a0, cpssp, &gui_port_func_0x1bc19a0);
	sig_std_logic_connect_in(gui_port_0x1bc1af0, cpssp, &gui_port_func_0x1bc1af0);
	sig_std_logic_connect_in(gui_port_0x1bc1c40, cpssp, &gui_port_func_0x1bc1c40);
	sig_std_logic_connect_in(gui_port_0x1bc1d90, cpssp, &gui_port_func_0x1bc1d90);
	sig_std_logic_connect_in(gui_port_0x1bc1ee0, cpssp, &gui_port_func_0x1bc1ee0);
	sig_std_logic_connect_in(gui_port_0x1bc2030, cpssp, &gui_port_func_0x1bc2030);
	sig_std_logic_connect_in(gui_port_0x1bc2180, cpssp, &gui_port_func_0x1bc2180);
	sig_std_logic_connect_in(gui_port_0x1bc22d0, cpssp, &gui_port_func_0x1bc22d0);
	sig_std_logic_connect_in(gui_port_0x1bc2420, cpssp, &gui_port_func_0x1bc2420);
	sig_std_logic_connect_in(gui_port_0x1bc2570, cpssp, &gui_port_func_0x1bc2570);
	sig_std_logic_connect_in(gui_port_0x1bc26c0, cpssp, &gui_port_func_0x1bc26c0);
	sig_std_logic_connect_in(gui_port_0x1bc2810, cpssp, &gui_port_func_0x1bc2810);
	sig_std_logic_connect_in(gui_port_0x1bc2960, cpssp, &gui_port_func_0x1bc2960);
	sig_std_logic_connect_in(gui_port_0x1bc2ab0, cpssp, &gui_port_func_0x1bc2ab0);
	sig_std_logic_connect_in(gui_port_0x1bc2c00, cpssp, &gui_port_func_0x1bc2c00);
	sig_std_logic_connect_in(gui_port_0x1bc2d50, cpssp, &gui_port_func_0x1bc2d50);
	sig_std_logic_connect_in(gui_port_0x1bc2ea0, cpssp, &gui_port_func_0x1bc2ea0);
	sig_std_logic_connect_in(gui_port_0x1bc2ff0, cpssp, &gui_port_func_0x1bc2ff0);
	sig_std_logic_connect_in(gui_port_0x1bc3140, cpssp, &gui_port_func_0x1bc3140);
	sig_std_logic_connect_in(gui_port_0x1bc3290, cpssp, &gui_port_func_0x1bc3290);
	sig_std_logic_connect_in(gui_port_0x1bc33e0, cpssp, &gui_port_func_0x1bc33e0);
	sig_std_logic_connect_in(gui_port_0x1bc3530, cpssp, &gui_port_func_0x1bc3530);
	sig_std_logic_connect_in(gui_port_0x1bc3680, cpssp, &gui_port_func_0x1bc3680);
	sig_std_logic_connect_in(gui_port_0x1bc37d0, cpssp, &gui_port_func_0x1bc37d0);
	sig_std_logic_connect_in(gui_port_0x1bc3920, cpssp, &gui_port_func_0x1bc3920);
	sig_std_logic_connect_in(gui_port_0x1bc3a70, cpssp, &gui_port_func_0x1bc3a70);
	sig_std_logic_connect_in(gui_port_0x1bc3bc0, cpssp, &gui_port_func_0x1bc3bc0);
	sig_std_logic_connect_in(gui_port_0x1bc3d10, cpssp, &gui_port_func_0x1bc3d10);
	sig_std_logic_connect_in(gui_port_0x1bc3e60, cpssp, &gui_port_func_0x1bc3e60);
	sig_std_logic_connect_in(gui_port_0x1bc3fb0, cpssp, &gui_port_func_0x1bc3fb0);
	sig_std_logic_connect_in(gui_port_0x1bc4100, cpssp, &gui_port_func_0x1bc4100);
	sig_std_logic_connect_in(gui_port_0x1bc4250, cpssp, &gui_port_func_0x1bc4250);
	sig_std_logic_connect_in(gui_port_0x1bc43a0, cpssp, &gui_port_func_0x1bc43a0);
	sig_std_logic_connect_in(gui_port_0x1bc44f0, cpssp, &gui_port_func_0x1bc44f0);
	sig_std_logic_connect_in(gui_port_0x1bc4640, cpssp, &gui_port_func_0x1bc4640);
	sig_std_logic_connect_in(gui_port_0x1bc4790, cpssp, &gui_port_func_0x1bc4790);
	sig_std_logic_connect_in(gui_port_0x1bc48e0, cpssp, &gui_port_func_0x1bc48e0);
	sig_std_logic_connect_in(gui_port_0x1bc4a30, cpssp, &gui_port_func_0x1bc4a30);
	sig_std_logic_connect_in(gui_port_0x1bc4b80, cpssp, &gui_port_func_0x1bc4b80);
	sig_std_logic_connect_in(gui_port_0x1bc4cd0, cpssp, &gui_port_func_0x1bc4cd0);
	sig_std_logic_connect_in(gui_port_0x1bc4e20, cpssp, &gui_port_func_0x1bc4e20);
	sig_std_logic_connect_in(gui_port_0x1bc4f70, cpssp, &gui_port_func_0x1bc4f70);
	sig_std_logic_connect_in(gui_port_0x1bc50c0, cpssp, &gui_port_func_0x1bc50c0);
	sig_std_logic_connect_in(gui_port_0x1bc5210, cpssp, &gui_port_func_0x1bc5210);
	sig_std_logic_connect_in(gui_port_0x1bc5360, cpssp, &gui_port_func_0x1bc5360);
	sig_std_logic_connect_in(gui_port_0x1bc54b0, cpssp, &gui_port_func_0x1bc54b0);
	sig_std_logic_connect_in(gui_port_0x1bc5600, cpssp, &gui_port_func_0x1bc5600);
	sig_std_logic_connect_in(gui_port_0x1bc5750, cpssp, &gui_port_func_0x1bc5750);
	sig_std_logic_connect_in(gui_port_0x1bc58a0, cpssp, &gui_port_func_0x1bc58a0);
	sig_std_logic_connect_in(gui_port_0x1bc59f0, cpssp, &gui_port_func_0x1bc59f0);
	sig_std_logic_connect_in(gui_port_0x1bc5b40, cpssp, &gui_port_func_0x1bc5b40);
	sig_std_logic_connect_in(gui_port_0x1bc5c90, cpssp, &gui_port_func_0x1bc5c90);
	sig_std_logic_connect_in(gui_port_0x1bc5de0, cpssp, &gui_port_func_0x1bc5de0);
	sig_std_logic_connect_in(gui_port_0x1bc5f30, cpssp, &gui_port_func_0x1bc5f30);
	sig_std_logic_connect_in(gui_port_0x1bc6080, cpssp, &gui_port_func_0x1bc6080);
	sig_std_logic_connect_in(gui_port_0x1bc61d0, cpssp, &gui_port_func_0x1bc61d0);
	sig_std_logic_connect_in(gui_port_0x1bc6320, cpssp, &gui_port_func_0x1bc6320);
	sig_std_logic_connect_in(gui_port_0x1bc6470, cpssp, &gui_port_func_0x1bc6470);
	sig_std_logic_connect_in(gui_port_0x1bc65c0, cpssp, &gui_port_func_0x1bc65c0);
	sig_std_logic_connect_in(gui_port_0x1bc6710, cpssp, &gui_port_func_0x1bc6710);
	sig_std_logic_connect_in(gui_port_0x1bc6860, cpssp, &gui_port_func_0x1bc6860);
	sig_std_logic_connect_in(gui_port_0x1bc69b0, cpssp, &gui_port_func_0x1bc69b0);
	sig_std_logic_connect_in(gui_port_0x1bc6b00, cpssp, &gui_port_func_0x1bc6b00);
	sig_std_logic_connect_in(gui_port_0x1bc6c50, cpssp, &gui_port_func_0x1bc6c50);
	sig_std_logic_connect_in(gui_port_0x1bc6da0, cpssp, &gui_port_func_0x1bc6da0);
	sig_std_logic_connect_in(gui_port_0x1bc6ef0, cpssp, &gui_port_func_0x1bc6ef0);
	sig_std_logic_connect_in(gui_port_0x1bc7040, cpssp, &gui_port_func_0x1bc7040);
	sig_std_logic_connect_in(gui_port_0x1bc7190, cpssp, &gui_port_func_0x1bc7190);
	sig_std_logic_connect_in(gui_port_0x1bc72e0, cpssp, &gui_port_func_0x1bc72e0);
	sig_std_logic_connect_in(gui_port_0x1bc7430, cpssp, &gui_port_func_0x1bc7430);
	sig_std_logic_connect_in(gui_port_0x1bc7580, cpssp, &gui_port_func_0x1bc7580);
	sig_std_logic_connect_in(gui_port_0x1bc76d0, cpssp, &gui_port_func_0x1bc76d0);
	sig_std_logic_connect_in(gui_port_0x1bc7820, cpssp, &gui_port_func_0x1bc7820);
	sig_std_logic_connect_in(gui_port_0x1bc7970, cpssp, &gui_port_func_0x1bc7970);
	sig_std_logic_connect_in(gui_port_0x1bc7ac0, cpssp, &gui_port_func_0x1bc7ac0);
	sig_std_logic_connect_in(gui_port_0x1bc7c10, cpssp, &gui_port_func_0x1bc7c10);
	sig_std_logic_connect_in(gui_port_0x1bc7d60, cpssp, &gui_port_func_0x1bc7d60);
	sig_std_logic_connect_in(gui_port_0x1bc7eb0, cpssp, &gui_port_func_0x1bc7eb0);
	sig_std_logic_connect_in(gui_port_0x1bc8000, cpssp, &gui_port_func_0x1bc8000);
	sig_std_logic_connect_in(gui_port_0x1bc8150, cpssp, &gui_port_func_0x1bc8150);
	sig_std_logic_connect_in(gui_port_0x1bc82a0, cpssp, &gui_port_func_0x1bc82a0);
	sig_std_logic_connect_in(gui_port_0x1bc83f0, cpssp, &gui_port_func_0x1bc83f0);
	sig_std_logic_connect_in(gui_port_0x1bc8540, cpssp, &gui_port_func_0x1bc8540);
	sig_std_logic_connect_in(gui_port_0x1bc8690, cpssp, &gui_port_func_0x1bc8690);
	sig_std_logic_connect_in(gui_port_0x1bc87e0, cpssp, &gui_port_func_0x1bc87e0);
	sig_std_logic_connect_in(gui_port_0x1bc8930, cpssp, &gui_port_func_0x1bc8930);
	sig_std_logic_connect_in(gui_port_0x1bc8a80, cpssp, &gui_port_func_0x1bc8a80);
	sig_std_logic_connect_in(gui_port_0x1bc8bd0, cpssp, &gui_port_func_0x1bc8bd0);
	sig_std_logic_connect_in(gui_port_0x1bc8d20, cpssp, &gui_port_func_0x1bc8d20);
	sig_std_logic_connect_in(gui_port_0x1bc8e70, cpssp, &gui_port_func_0x1bc8e70);
	sig_std_logic_connect_in(gui_port_0x1bc8fc0, cpssp, &gui_port_func_0x1bc8fc0);
	sig_std_logic_connect_in(gui_port_0x1bb6b50, cpssp, &gui_port_func_0x1bb6b50);
	sig_std_logic_connect_in(gui_port_0x1bb8250, cpssp, &gui_port_func_0x1bb8250);
	sig_std_logic_connect_in(gui_port_0x1bb82b0, cpssp, &gui_port_func_0x1bb82b0);
	sig_std_logic_connect_in(gui_port_0x1bc91c0, cpssp, &gui_port_func_0x1bc91c0);
	sig_std_logic_connect_in(gui_port_0x1bc9310, cpssp, &gui_port_func_0x1bc9310);
	sig_std_logic_connect_in(gui_port_0x1bc9460, cpssp, &gui_port_func_0x1bc9460);
	sig_std_logic_connect_in(gui_port_0x1bc95b0, cpssp, &gui_port_func_0x1bc95b0);
	sig_std_logic_connect_in(gui_port_0x1bc9700, cpssp, &gui_port_func_0x1bc9700);
	sig_std_logic_connect_in(gui_port_0x1bc9850, cpssp, &gui_port_func_0x1bc9850);
	sig_std_logic_connect_in(gui_port_0x1bc99a0, cpssp, &gui_port_func_0x1bc99a0);
	sig_std_logic_connect_in(gui_port_0x1bc9af0, cpssp, &gui_port_func_0x1bc9af0);
	sig_std_logic_connect_in(gui_port_0x1bc9c40, cpssp, &gui_port_func_0x1bc9c40);
	sig_std_logic_connect_in(gui_port_0x1bc9d90, cpssp, &gui_port_func_0x1bc9d90);
	sig_std_logic_connect_in(gui_port_0x1bc9ee0, cpssp, &gui_port_func_0x1bc9ee0);
	sig_std_logic_connect_in(gui_port_0x1bca030, cpssp, &gui_port_func_0x1bca030);
	sig_std_logic_connect_in(gui_port_0x1bca180, cpssp, &gui_port_func_0x1bca180);
	sig_std_logic_connect_in(gui_port_0x1bca2d0, cpssp, &gui_port_func_0x1bca2d0);
	sig_std_logic_connect_in(gui_port_0x1bca420, cpssp, &gui_port_func_0x1bca420);
	sig_std_logic_connect_in(gui_port_0x1bca570, cpssp, &gui_port_func_0x1bca570);
	sig_std_logic_connect_in(gui_port_0x1bca6c0, cpssp, &gui_port_func_0x1bca6c0);
	sig_std_logic_connect_in(gui_port_0x1bca810, cpssp, &gui_port_func_0x1bca810);
	sig_std_logic_connect_in(gui_port_0x1bca960, cpssp, &gui_port_func_0x1bca960);
	sig_std_logic_connect_in(gui_port_0x1bcaab0, cpssp, &gui_port_func_0x1bcaab0);
	sig_std_logic_connect_in(gui_port_0x1bcac00, cpssp, &gui_port_func_0x1bcac00);
	sig_std_logic_connect_in(gui_port_0x1bcad50, cpssp, &gui_port_func_0x1bcad50);
	sig_std_logic_connect_in(gui_port_0x1bcaea0, cpssp, &gui_port_func_0x1bcaea0);
	sig_std_logic_connect_in(gui_port_0x1bcaff0, cpssp, &gui_port_func_0x1bcaff0);
	sig_std_logic_connect_in(gui_port_0x1bcb140, cpssp, &gui_port_func_0x1bcb140);
	sig_std_logic_connect_in(gui_port_0x1bcb290, cpssp, &gui_port_func_0x1bcb290);
	sig_std_logic_connect_in(gui_port_0x1bcb3e0, cpssp, &gui_port_func_0x1bcb3e0);
	sig_std_logic_connect_in(gui_port_0x1bcb530, cpssp, &gui_port_func_0x1bcb530);
	sig_std_logic_connect_in(gui_port_0x1bcb680, cpssp, &gui_port_func_0x1bcb680);
	sig_std_logic_connect_in(gui_port_0x1bcb7d0, cpssp, &gui_port_func_0x1bcb7d0);
	sig_std_logic_connect_in(gui_port_0x1bcb920, cpssp, &gui_port_func_0x1bcb920);
	sig_std_logic_connect_in(gui_port_0x1bcba70, cpssp, &gui_port_func_0x1bcba70);
	sig_std_logic_connect_in(gui_port_0x1bcbbc0, cpssp, &gui_port_func_0x1bcbbc0);
	sig_std_logic_connect_in(gui_port_0x1bcbd10, cpssp, &gui_port_func_0x1bcbd10);
	sig_std_logic_connect_in(gui_port_0x1bcbe60, cpssp, &gui_port_func_0x1bcbe60);
	sig_std_logic_connect_in(gui_port_0x1bcbfb0, cpssp, &gui_port_func_0x1bcbfb0);
	sig_std_logic_connect_in(gui_port_0x1bcc100, cpssp, &gui_port_func_0x1bcc100);
	sig_std_logic_connect_in(gui_port_0x1bcc250, cpssp, &gui_port_func_0x1bcc250);
	sig_std_logic_connect_in(gui_port_0x1bcc3a0, cpssp, &gui_port_func_0x1bcc3a0);
	sig_std_logic_connect_in(gui_port_0x1bcc4f0, cpssp, &gui_port_func_0x1bcc4f0);
	sig_std_logic_connect_in(gui_port_0x1bcc640, cpssp, &gui_port_func_0x1bcc640);
	sig_std_logic_connect_in(gui_port_0x1bcc790, cpssp, &gui_port_func_0x1bcc790);
	sig_std_logic_connect_in(gui_port_0x1bcc8e0, cpssp, &gui_port_func_0x1bcc8e0);
	sig_std_logic_connect_in(gui_port_0x1bcca30, cpssp, &gui_port_func_0x1bcca30);
	sig_std_logic_connect_in(gui_port_0x1bccb80, cpssp, &gui_port_func_0x1bccb80);
	sig_std_logic_connect_in(gui_port_0x1bcccd0, cpssp, &gui_port_func_0x1bcccd0);
	sig_std_logic_connect_in(gui_port_0x1bcce20, cpssp, &gui_port_func_0x1bcce20);
	sig_std_logic_connect_in(gui_port_0x1bccf70, cpssp, &gui_port_func_0x1bccf70);
	sig_std_logic_connect_in(gui_port_0x1bcd0c0, cpssp, &gui_port_func_0x1bcd0c0);
	sig_std_logic_connect_in(gui_port_0x1bcd210, cpssp, &gui_port_func_0x1bcd210);
	sig_std_logic_connect_in(gui_port_0x1bcd360, cpssp, &gui_port_func_0x1bcd360);
	sig_std_logic_connect_in(gui_port_0x1bcd4b0, cpssp, &gui_port_func_0x1bcd4b0);
	sig_std_logic_connect_in(gui_port_0x1bcd600, cpssp, &gui_port_func_0x1bcd600);
	sig_std_logic_connect_in(gui_port_0x1bcd750, cpssp, &gui_port_func_0x1bcd750);
	sig_std_logic_connect_in(gui_port_0x1bcd8a0, cpssp, &gui_port_func_0x1bcd8a0);
	sig_std_logic_connect_in(gui_port_0x1bcd9f0, cpssp, &gui_port_func_0x1bcd9f0);
	sig_std_logic_connect_in(gui_port_0x1bcdb40, cpssp, &gui_port_func_0x1bcdb40);
	sig_std_logic_connect_in(gui_port_0x1bcdc90, cpssp, &gui_port_func_0x1bcdc90);
	sig_std_logic_connect_in(gui_port_0x1bcdde0, cpssp, &gui_port_func_0x1bcdde0);
	sig_std_logic_connect_in(gui_port_0x1bcdf30, cpssp, &gui_port_func_0x1bcdf30);
	sig_std_logic_connect_in(gui_port_0x1bce080, cpssp, &gui_port_func_0x1bce080);
	sig_std_logic_connect_in(gui_port_0x1bce1d0, cpssp, &gui_port_func_0x1bce1d0);
	sig_std_logic_connect_in(gui_port_0x1bce320, cpssp, &gui_port_func_0x1bce320);
	sig_std_logic_connect_in(gui_port_0x1bce470, cpssp, &gui_port_func_0x1bce470);
	sig_std_logic_connect_in(gui_port_0x1bce5c0, cpssp, &gui_port_func_0x1bce5c0);
	sig_std_logic_connect_in(gui_port_0x1bce710, cpssp, &gui_port_func_0x1bce710);
	sig_std_logic_connect_in(gui_port_0x1bce860, cpssp, &gui_port_func_0x1bce860);
	sig_std_logic_connect_in(gui_port_0x1bce9b0, cpssp, &gui_port_func_0x1bce9b0);
	sig_std_logic_connect_in(gui_port_0x1bceb00, cpssp, &gui_port_func_0x1bceb00);
	sig_std_logic_connect_in(gui_port_0x1bcec50, cpssp, &gui_port_func_0x1bcec50);
	sig_std_logic_connect_in(gui_port_0x1bceda0, cpssp, &gui_port_func_0x1bceda0);
	sig_std_logic_connect_in(gui_port_0x1bceef0, cpssp, &gui_port_func_0x1bceef0);
	sig_std_logic_connect_in(gui_port_0x1bcf040, cpssp, &gui_port_func_0x1bcf040);
	sig_std_logic_connect_in(gui_port_0x1bcf190, cpssp, &gui_port_func_0x1bcf190);
	sig_std_logic_connect_in(gui_port_0x1bcf2e0, cpssp, &gui_port_func_0x1bcf2e0);
	sig_std_logic_connect_in(gui_port_0x1bcf430, cpssp, &gui_port_func_0x1bcf430);
	sig_std_logic_connect_in(gui_port_0x1bcf580, cpssp, &gui_port_func_0x1bcf580);
	sig_std_logic_connect_in(gui_port_0x1bcf6d0, cpssp, &gui_port_func_0x1bcf6d0);
	sig_std_logic_connect_in(gui_port_0x1bcf820, cpssp, &gui_port_func_0x1bcf820);
	sig_std_logic_connect_in(gui_port_0x1bcf970, cpssp, &gui_port_func_0x1bcf970);
	sig_std_logic_connect_in(gui_port_0x1bcfac0, cpssp, &gui_port_func_0x1bcfac0);
	sig_std_logic_connect_in(gui_port_0x1bcfc10, cpssp, &gui_port_func_0x1bcfc10);
	sig_std_logic_connect_in(gui_port_0x1bcfd60, cpssp, &gui_port_func_0x1bcfd60);
	sig_std_logic_connect_in(gui_port_0x1bcfeb0, cpssp, &gui_port_func_0x1bcfeb0);
	/* create all elements */
	xml2c_20AII_create(cpssp);
	cpssp->pin_20AII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_20AII_7 = SIG_STD_LOGIC_Z;

	xml2c_6AI_create(cpssp);
	cpssp->pin_6AI_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_6AI_3 = SIG_STD_LOGIC_Z;

	xml2c_6AII_create(cpssp);
	cpssp->pin_6AII_03 = SIG_STD_LOGIC_Z;
	cpssp->pin_6AII_6 = SIG_STD_LOGIC_Z;

	xml2c_6AIII_create(cpssp);
	cpssp->pin_6AIII_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_6AIII_06 = SIG_STD_LOGIC_Z;

	xml2c_6AIV_create(cpssp);
	cpssp->pin_6AIV_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_6AIV_013 = SIG_STD_LOGIC_Z;

	xml2c_32BIV_create(cpssp);
	cpssp->pin_32BIV_013 = SIG_STD_LOGIC_Z;
	cpssp->pin_32BIV_11 = SIG_STD_LOGIC_Z;

	xml2c_32BIII_create(cpssp);
	cpssp->pin_32BIII_06 = SIG_STD_LOGIC_Z;
	cpssp->pin_32BIII_7 = SIG_STD_LOGIC_Z;

	xml2c_16AI_create(cpssp);
	cpssp->pin_16AI_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_16AI_3 = SIG_STD_LOGIC_Z;

	xml2c_16AII_create(cpssp);
	cpssp->pin_16AII_03 = SIG_STD_LOGIC_Z;
	cpssp->pin_16AII_6 = SIG_STD_LOGIC_Z;

	xml2c_16AIII_create(cpssp);
	cpssp->pin_16AIII_06 = SIG_STD_LOGIC_Z;
	cpssp->pin_16AIII_7 = SIG_STD_LOGIC_Z;

	xml2c_16AIV_create(cpssp);
	cpssp->pin_16AIV_013 = SIG_STD_LOGIC_Z;
	cpssp->pin_16AIV_11 = SIG_STD_LOGIC_Z;

	xml2c_17AI_create(cpssp);
	cpssp->pin_17AI_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AI_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AI_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AI_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AI_12 = SIG_STD_LOGIC_Z;

	xml2c_18AI_create(cpssp);
	cpssp->pin_18AI_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AI_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AI_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AI_15 = SIG_STD_LOGIC_Z;

	xml2c_19A_create(cpssp);
	cpssp->pin_19A_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_19A_15 = SIG_STD_LOGIC_Z;

	xml2c_5A_create(cpssp);
	cpssp->pin_5A_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_5A_15 = SIG_STD_LOGIC_Z;

	xml2c_22AVIII_create(cpssp);
	cpssp->pin_22AVIII_015 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AVIII_014 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AVIII_013 = SIG_STD_LOGIC_Z;

	xml2c_22AVII_create(cpssp);
	cpssp->pin_22AVII_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AVII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AVII_13 = SIG_STD_LOGIC_Z;

	xml2c_22AVI_create(cpssp);
	cpssp->pin_22AVI_012 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AVI_011 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AVI_010 = SIG_STD_LOGIC_Z;

	xml2c_22AV_create(cpssp);
	cpssp->pin_22AV_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AV_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AV_10 = SIG_STD_LOGIC_Z;

	xml2c_22AIV_create(cpssp);
	cpssp->pin_22AIV_09 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AIV_08 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AIV_07 = SIG_STD_LOGIC_Z;

	xml2c_22AIII_create(cpssp);
	cpssp->pin_22AIII_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AIII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AIII_7 = SIG_STD_LOGIC_Z;

	xml2c_22AII_create(cpssp);
	cpssp->pin_22AII_05 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AII_06 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AII_04 = SIG_STD_LOGIC_Z;

	xml2c_22AI_create(cpssp);
	cpssp->pin_22AI_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AI_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_22AI_4 = SIG_STD_LOGIC_Z;

	xml2c_21AVIII_create(cpssp);
	cpssp->pin_21AVIII_015 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AVIII_014 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AVIII_013 = SIG_STD_LOGIC_Z;

	xml2c_21AVII_create(cpssp);
	cpssp->pin_21AVII_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AVII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AVII_13 = SIG_STD_LOGIC_Z;

	xml2c_21AV_create(cpssp);
	cpssp->pin_21AV_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AV_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AV_10 = SIG_STD_LOGIC_Z;

	xml2c_21AIII_create(cpssp);
	cpssp->pin_21AIII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AIII_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AIII_7 = SIG_STD_LOGIC_Z;

	xml2c_21AII_create(cpssp);
	cpssp->pin_21AII_06 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AII_05 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AII_04 = SIG_STD_LOGIC_Z;

	xml2c_21AI_create(cpssp);
	cpssp->pin_21AI_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AI_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AI_4 = SIG_STD_LOGIC_Z;

	xml2c_31AIV_create(cpssp);
	cpssp->pin_31AIV_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_31AIV_9 = SIG_STD_LOGIC_Z;

	xml2c_31AIII_create(cpssp);
	cpssp->pin_31AIII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_31AIII_7 = SIG_STD_LOGIC_Z;

	xml2c_31AII_create(cpssp);
	cpssp->pin_31AII_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_31AII_5 = SIG_STD_LOGIC_Z;

	xml2c_31AI_create(cpssp);
	cpssp->pin_31AI_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_31AI_3 = SIG_STD_LOGIC_Z;

	xml2c_30AVI_create(cpssp);
	cpssp->pin_30AVI_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_30AVI_13 = SIG_STD_LOGIC_Z;

	xml2c_30AV_create(cpssp);
	cpssp->pin_30AV_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_30AV_11 = SIG_STD_LOGIC_Z;

	xml2c_30AIV_create(cpssp);
	cpssp->pin_30AIV_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_30AIV_9 = SIG_STD_LOGIC_Z;

	xml2c_30AIII_create(cpssp);
	cpssp->pin_30AIII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_30AIII_7 = SIG_STD_LOGIC_Z;

	xml2c_30AII_create(cpssp);
	cpssp->pin_30AII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_30AII_6 = SIG_STD_LOGIC_Z;

	xml2c_30AI_create(cpssp);
	cpssp->pin_30AI_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_30AI_3 = SIG_STD_LOGIC_Z;

	xml2c_29AVI_create(cpssp);
	cpssp->pin_29AVI_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_29AVI_13 = SIG_STD_LOGIC_Z;

	xml2c_29AV_create(cpssp);
	cpssp->pin_29AV_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_29AV_11 = SIG_STD_LOGIC_Z;

	xml2c_29AIV_create(cpssp);
	cpssp->pin_29AIV_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_29AIV_9 = SIG_STD_LOGIC_Z;

	xml2c_29AIII_create(cpssp);
	cpssp->pin_29AIII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_29AIII_7 = SIG_STD_LOGIC_Z;

	xml2c_29AII_create(cpssp);
	cpssp->pin_29AII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_29AII_6 = SIG_STD_LOGIC_Z;

	xml2c_29AI_create(cpssp);
	cpssp->pin_29AI_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_29AI_3 = SIG_STD_LOGIC_Z;

	xml2c_12AI_create(cpssp);
	cpssp->pin_12AI_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AI_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AI_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AI_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AI_15 = SIG_STD_LOGIC_Z;

	xml2c_17AII_create(cpssp);
	cpssp->pin_17AII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_17AII_7 = SIG_STD_LOGIC_Z;

	xml2c_12AII_create(cpssp);
	cpssp->pin_12AII_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_12AII_7 = SIG_STD_LOGIC_Z;

	xml2c_15AII_create(cpssp);
	cpssp->pin_15AII_011 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_013 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_012 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_010 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_014 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AII_015 = SIG_STD_LOGIC_Z;

	xml2c_15AI_create(cpssp);
	cpssp->pin_15AI_09 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_04 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_05 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_06 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_07 = SIG_STD_LOGIC_Z;
	cpssp->pin_15AI_08 = SIG_STD_LOGIC_Z;

	xml2c_18AII_create(cpssp);
	cpssp->pin_18AII_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_18AII_6 = SIG_STD_LOGIC_Z;

	xml2c_14A_create(cpssp);
	cpssp->pin_14A_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_14A_14 = SIG_STD_LOGIC_Z;

	xml2c_13A_create(cpssp);
	cpssp->pin_13A_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_8 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_13A_14 = SIG_STD_LOGIC_Z;

	xml2c_3A_create(cpssp);
	cpssp->pin_3A_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_3A_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_3A_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_3A_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_3A_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_3A_12 = SIG_STD_LOGIC_Z;

	xml2c_2A_create(cpssp);
	cpssp->pin_2A_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_2A_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_2A_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_2A_5 = SIG_STD_LOGIC_Z;

	xml2c_4A_create(cpssp);
	cpssp->pin_4A_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_4A_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_4A_7 = SIG_STD_LOGIC_Z;

	xml2c_23AII_create(cpssp);
	cpssp->pin_23AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_23AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_23AII_12 = SIG_STD_LOGIC_Z;

	xml2c_24AIII_create(cpssp);
	cpssp->pin_24AIII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AIII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AIII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AIII_6 = SIG_STD_LOGIC_Z;

	xml2c_24AII_create(cpssp);
	cpssp->pin_24AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AII_12 = SIG_STD_LOGIC_Z;

	xml2c_24AI_create(cpssp);
	cpssp->pin_24AI_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_24AI_8 = SIG_STD_LOGIC_Z;

	xml2c_25AIII_create(cpssp);
	cpssp->pin_25AIII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AIII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AIII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AIII_6 = SIG_STD_LOGIC_Z;

	xml2c_25AII_create(cpssp);
	cpssp->pin_25AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AII_12 = SIG_STD_LOGIC_Z;

	xml2c_25AI_create(cpssp);
	cpssp->pin_25AI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AI_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_25AI_8 = SIG_STD_LOGIC_Z;

	xml2c_26AIII_create(cpssp);
	cpssp->pin_26AIII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AIII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AIII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AIII_6 = SIG_STD_LOGIC_Z;

	xml2c_26AII_create(cpssp);
	cpssp->pin_26AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AII_12 = SIG_STD_LOGIC_Z;

	xml2c_26AI_create(cpssp);
	cpssp->pin_26AI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AI_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_26AI_8 = SIG_STD_LOGIC_Z;

	xml2c_27AIII_create(cpssp);
	cpssp->pin_27AIII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AIII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AIII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AIII_6 = SIG_STD_LOGIC_Z;

	xml2c_27AII_create(cpssp);
	cpssp->pin_27AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AII_12 = SIG_STD_LOGIC_Z;

	xml2c_27AI_create(cpssp);
	cpssp->pin_27AI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AI_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_27AI_8 = SIG_STD_LOGIC_Z;

	xml2c_28AIII_create(cpssp);
	cpssp->pin_28AIII_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AIII_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AIII_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AIII_6 = SIG_STD_LOGIC_Z;

	xml2c_28AII_create(cpssp);
	cpssp->pin_28AII_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AII_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AII_12 = SIG_STD_LOGIC_Z;

	xml2c_28AI_create(cpssp);
	cpssp->pin_28AI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AI_9 = SIG_STD_LOGIC_Z;
	cpssp->pin_28AI_8 = SIG_STD_LOGIC_Z;

	xml2c_21AVI_create(cpssp);
	cpssp->pin_21AVI_012 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AVI_011 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AVI_010 = SIG_STD_LOGIC_Z;

	xml2c_21AIV_create(cpssp);
	cpssp->pin_21AIV_08 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AIV_09 = SIG_STD_LOGIC_Z;
	cpssp->pin_21AIV_07 = SIG_STD_LOGIC_Z;

	xml2c_S0_create(cpssp);
	cpssp->pin_S0_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S0_8 = SIG_STD_LOGIC_Z;

	xml2c_S1_create(cpssp);
	cpssp->pin_S1_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S1_8 = SIG_STD_LOGIC_Z;

	xml2c_S2_create(cpssp);
	cpssp->pin_S2_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S2_8 = SIG_STD_LOGIC_Z;

	xml2c_S3_create(cpssp);
	cpssp->pin_S3_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S3_8 = SIG_STD_LOGIC_Z;

	xml2c_S4_create(cpssp);
	cpssp->pin_S4_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S4_8 = SIG_STD_LOGIC_Z;

	xml2c_S5_create(cpssp);
	cpssp->pin_S5_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S5_8 = SIG_STD_LOGIC_Z;

	xml2c_S6_create(cpssp);
	cpssp->pin_S6_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S6_8 = SIG_STD_LOGIC_Z;

	xml2c_S7_create(cpssp);
	cpssp->pin_S7_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S7_8 = SIG_STD_LOGIC_Z;

	xml2c_S8_create(cpssp);
	cpssp->pin_S8_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S8_8 = SIG_STD_LOGIC_Z;

	xml2c_S9_create(cpssp);
	cpssp->pin_S9_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S9_8 = SIG_STD_LOGIC_Z;

	xml2c_S10_create(cpssp);
	cpssp->pin_S10_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S10_8 = SIG_STD_LOGIC_Z;

	xml2c_S11_create(cpssp);
	cpssp->pin_S11_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S11_8 = SIG_STD_LOGIC_Z;

	xml2c_S12_create(cpssp);
	cpssp->pin_S12_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S12_8 = SIG_STD_LOGIC_Z;

	xml2c_S13_create(cpssp);
	cpssp->pin_S13_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S13_8 = SIG_STD_LOGIC_Z;

	xml2c_S14_create(cpssp);
	cpssp->pin_S14_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S14_8 = SIG_STD_LOGIC_Z;

	xml2c_S15_create(cpssp);
	cpssp->pin_S15_2 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_1 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_3 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_6 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_7 = SIG_STD_LOGIC_Z;
	cpssp->pin_S15_8 = SIG_STD_LOGIC_Z;

	xml2c_15BI_create(cpssp);
	cpssp->pin_15BI_10 = SIG_STD_LOGIC_Z;
	cpssp->pin_15BI_12 = SIG_STD_LOGIC_Z;
	cpssp->pin_15BI_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_15BI_11 = SIG_STD_LOGIC_Z;
	cpssp->pin_15BI_15 = SIG_STD_LOGIC_Z;

	xml2c_16AVI_create(cpssp);
	cpssp->pin_16AVI_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_16AVI_15 = SIG_STD_LOGIC_Z;

	xml2c_6AV_create(cpssp);
	cpssp->pin_6AV_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_6AV_015 = SIG_STD_LOGIC_Z;

	xml2c_16AV_create(cpssp);
	cpssp->pin_16AV_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_16AV_015 = SIG_STD_LOGIC_Z;

	xml2c_17B_create(cpssp);
	cpssp->pin_17B_5 = SIG_STD_LOGIC_Z;
	cpssp->pin_17B_4 = SIG_STD_LOGIC_Z;
	cpssp->pin_17B_13 = SIG_STD_LOGIC_Z;
	cpssp->pin_17B_15 = SIG_STD_LOGIC_Z;
	cpssp->pin_17B_12 = SIG_STD_LOGIC_Z;

	xml2c_6AVI_create(cpssp);
	cpssp->pin_6AVI_14 = SIG_STD_LOGIC_Z;
	cpssp->pin_6AVI_15 = SIG_STD_LOGIC_Z;


	return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	/* destroy elements */
	xml2c_20AII_destroy(cpssp);
	xml2c_6AI_destroy(cpssp);
	xml2c_6AII_destroy(cpssp);
	xml2c_6AIII_destroy(cpssp);
	xml2c_6AIV_destroy(cpssp);
	xml2c_32BIV_destroy(cpssp);
	xml2c_32BIII_destroy(cpssp);
	xml2c_16AI_destroy(cpssp);
	xml2c_16AII_destroy(cpssp);
	xml2c_16AIII_destroy(cpssp);
	xml2c_16AIV_destroy(cpssp);
	xml2c_17AI_destroy(cpssp);
	xml2c_18AI_destroy(cpssp);
	xml2c_19A_destroy(cpssp);
	xml2c_5A_destroy(cpssp);
	xml2c_22AVIII_destroy(cpssp);
	xml2c_22AVII_destroy(cpssp);
	xml2c_22AVI_destroy(cpssp);
	xml2c_22AV_destroy(cpssp);
	xml2c_22AIV_destroy(cpssp);
	xml2c_22AIII_destroy(cpssp);
	xml2c_22AII_destroy(cpssp);
	xml2c_22AI_destroy(cpssp);
	xml2c_21AVIII_destroy(cpssp);
	xml2c_21AVII_destroy(cpssp);
	xml2c_21AV_destroy(cpssp);
	xml2c_21AIII_destroy(cpssp);
	xml2c_21AII_destroy(cpssp);
	xml2c_21AI_destroy(cpssp);
	xml2c_31AIV_destroy(cpssp);
	xml2c_31AIII_destroy(cpssp);
	xml2c_31AII_destroy(cpssp);
	xml2c_31AI_destroy(cpssp);
	xml2c_30AVI_destroy(cpssp);
	xml2c_30AV_destroy(cpssp);
	xml2c_30AIV_destroy(cpssp);
	xml2c_30AIII_destroy(cpssp);
	xml2c_30AII_destroy(cpssp);
	xml2c_30AI_destroy(cpssp);
	xml2c_29AVI_destroy(cpssp);
	xml2c_29AV_destroy(cpssp);
	xml2c_29AIV_destroy(cpssp);
	xml2c_29AIII_destroy(cpssp);
	xml2c_29AII_destroy(cpssp);
	xml2c_29AI_destroy(cpssp);
	xml2c_12AI_destroy(cpssp);
	xml2c_17AII_destroy(cpssp);
	xml2c_12AII_destroy(cpssp);
	xml2c_15AII_destroy(cpssp);
	xml2c_15AI_destroy(cpssp);
	xml2c_18AII_destroy(cpssp);
	xml2c_14A_destroy(cpssp);
	xml2c_13A_destroy(cpssp);
	xml2c_3A_destroy(cpssp);
	xml2c_2A_destroy(cpssp);
	xml2c_4A_destroy(cpssp);
	xml2c_23AII_destroy(cpssp);
	xml2c_24AIII_destroy(cpssp);
	xml2c_24AII_destroy(cpssp);
	xml2c_24AI_destroy(cpssp);
	xml2c_25AIII_destroy(cpssp);
	xml2c_25AII_destroy(cpssp);
	xml2c_25AI_destroy(cpssp);
	xml2c_26AIII_destroy(cpssp);
	xml2c_26AII_destroy(cpssp);
	xml2c_26AI_destroy(cpssp);
	xml2c_27AIII_destroy(cpssp);
	xml2c_27AII_destroy(cpssp);
	xml2c_27AI_destroy(cpssp);
	xml2c_28AIII_destroy(cpssp);
	xml2c_28AII_destroy(cpssp);
	xml2c_28AI_destroy(cpssp);
	xml2c_21AVI_destroy(cpssp);
	xml2c_21AIV_destroy(cpssp);
	xml2c_S0_destroy(cpssp);
	xml2c_S1_destroy(cpssp);
	xml2c_S2_destroy(cpssp);
	xml2c_S3_destroy(cpssp);
	xml2c_S4_destroy(cpssp);
	xml2c_S5_destroy(cpssp);
	xml2c_S6_destroy(cpssp);
	xml2c_S7_destroy(cpssp);
	xml2c_S8_destroy(cpssp);
	xml2c_S9_destroy(cpssp);
	xml2c_S10_destroy(cpssp);
	xml2c_S11_destroy(cpssp);
	xml2c_S12_destroy(cpssp);
	xml2c_S13_destroy(cpssp);
	xml2c_S14_destroy(cpssp);
	xml2c_S15_destroy(cpssp);
	xml2c_15BI_destroy(cpssp);
	xml2c_16AVI_destroy(cpssp);
	xml2c_6AV_destroy(cpssp);
	xml2c_16AV_destroy(cpssp);
	xml2c_17B_destroy(cpssp);
	xml2c_6AVI_destroy(cpssp);

	shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fComp);
}
