/*
 * $Id: cpu_intel_80386.c,v 1.24 2013-05-port_10 07:48:14 vrsieh Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "zuse_trommel.h"

#define COMP_(x)	zuse_trommel_ ## x

struct cpssp {
    int takt;

    struct sig_std_logic *port_Uhr1;
    struct sig_std_logic *port_Uhr2;
    struct sig_std_logic *port_Imp1;
    struct sig_std_logic *port_Imp2;
};

static void
COMP_(step)(void *_cpssp) {

    struct cpssp *cpssp = _cpssp;

    fprintf(stderr, "\n\nSTEP %i\n", cpssp->takt);

    switch (cpssp->takt) {
	case 0:
	    sig_std_logic_set(cpssp->port_Uhr1, (void*) cpssp, SIG_STD_LOGIC_1);
	    sig_std_logic_set(cpssp->port_Uhr2, (void*) cpssp, SIG_STD_LOGIC_0);
	    sig_std_logic_set(cpssp->port_Imp1, (void*) cpssp, SIG_STD_LOGIC_1);
	    sig_std_logic_set(cpssp->port_Imp2, (void*) cpssp, SIG_STD_LOGIC_0);

	    break;
	case 1:
	    sig_std_logic_set(cpssp->port_Uhr1, (void*) cpssp, SIG_STD_LOGIC_0);
	    sig_std_logic_set(cpssp->port_Uhr2, (void*) cpssp, SIG_STD_LOGIC_1);
	    sig_std_logic_set(cpssp->port_Imp1, (void*) cpssp, SIG_STD_LOGIC_0);
	    sig_std_logic_set(cpssp->port_Imp2, (void*) cpssp, SIG_STD_LOGIC_1);

	    break;
    }

    cpssp->takt = (cpssp->takt + 1) % 2;
    time_call_after(1 * TIME_HZ, COMP_(step), cpssp);
    return;
}

void *
COMP_(create)(
	      const char *name,
	      struct sig_manage *port_manage,
	      struct sig_std_logic *port_Uhr1,
	      struct sig_std_logic *port_Uhr2,
	      struct sig_std_logic *port_Imp1,
	      struct sig_std_logic *port_Imp2
	     )
{
    struct cpssp *cpssp;

    /* cpssp */
    cpssp = shm_alloc(sizeof(*cpssp));
    assert(cpssp);

    cpssp->takt = 0;

    /* outs */
    cpssp->port_Uhr1 = port_Uhr1;
    sig_std_logic_connect_out(port_Uhr1, cpssp, SIG_STD_LOGIC_Z);
    cpssp->port_Uhr2 = port_Uhr2;
    sig_std_logic_connect_out(port_Uhr2, cpssp, SIG_STD_LOGIC_Z);
    cpssp->port_Imp1 = port_Imp1;
    sig_std_logic_connect_out(port_Imp1, cpssp, SIG_STD_LOGIC_Z);
    cpssp->port_Imp2 = port_Imp2;
    sig_std_logic_connect_out(port_Imp2, cpssp, SIG_STD_LOGIC_Z);

    /* ins */

    COMP_(step)(cpssp);

    return cpssp;
}

void
COMP_(destroy)(void *_cpssp)
{
    struct cpssp *cpssp = _cpssp;

    shm_free(cpssp);
}

void
COMP_(suspend)(void *_cpssp, FILE *fComp)
{
    struct cpssp *cpssp = _cpssp;

    generic_suspend(cpssp, sizeof(*cpssp), fComp);
}

void
COMP_(resume)(void *_cpssp, FILE *fComp)
{
    struct cpssp *cpssp = _cpssp;

    generic_resume(cpssp, sizeof(*cpssp), fComp);
}
