/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

struct {

#ifdef INP_0
#define IN_N 1
#endif

#ifdef INP_1
#undef IN_N
#define IN_N 2
#endif

#ifdef INP_2
#undef IN_N
#define IN_N 3
#endif

#ifdef INP_3
#undef IN_N
#define IN_N 4
#endif

#ifdef INP_4
#undef IN_N
#define IN_N 5
#endif

#ifdef INP_5
#undef IN_N
#define IN_N 6
#endif

#ifdef INP_6
#undef IN_N
#define IN_N 7
#endif

#ifdef INP_7
#undef IN_N
#define IN_N 8
#endif

#ifdef INP_8
#undef IN_N
#define IN_N 9
#endif

#ifdef INP_9
#undef IN_N
#define IN_N 10
#endif

#ifdef INP_10
#undef IN_N
#define IN_N 11
#endif

    unsigned int states[IN_N];
#undef IN_N
} NAME;

#endif /*STATE*/

#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)       x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

/* macros to concat function names */
#ifdef INP_0
#define NAME_IN_PORT_0_(z)  EVALUATOR(NAME, INP_0, z)
#endif

#ifdef INP_1
#define NAME_IN_PORT_1_(z)  EVALUATOR(NAME, INP_1, z)
#endif

#ifdef INP_2
#define NAME_IN_PORT_2_(z)  EVALUATOR(NAME, INP_2, z)
#endif

#ifdef INP_3
#define NAME_IN_PORT_3_(z)  EVALUATOR(NAME, INP_3, z)
#endif

#ifdef INP_4
#define NAME_IN_PORT_4_(z)  EVALUATOR(NAME, INP_4, z)
#endif

#ifdef INP_5
#define NAME_IN_PORT_5_(z)  EVALUATOR(NAME, INP_5, z)
#endif

#ifdef INP_6
#define NAME_IN_PORT_6_(z)  EVALUATOR(NAME, INP_6, z)
#endif

#ifdef INP_7
#define NAME_IN_PORT_7_(z)  EVALUATOR(NAME, INP_7, z)
#endif

#ifdef INP_8
#define NAME_IN_PORT_8_(z)  EVALUATOR(NAME, INP_8, z)
#endif

#ifdef INP_9
#define NAME_IN_PORT_9_(z)  EVALUATOR(NAME, INP_9, z)
#endif

#ifdef INP_10
#define NAME_IN_PORT_10_(z)  EVALUATOR(NAME, INP_10, z)
#endif

#ifdef OUTP_0
#define NAME_OUT_PORT_0_(z) EVALUATOR(NAME, OUTP_0, z)
#endif

#ifdef OUTP_1
#define NAME_OUT_PORT_1_(z) EVALUATOR(NAME, OUTP_1, z)
#endif

#ifdef OUTP_2
#define NAME_OUT_PORT_2_(z) EVALUATOR(NAME, OUTP_2, z)
#endif

#ifdef OUTP_3
#define NAME_OUT_PORT_3_(z) EVALUATOR(NAME, OUTP_3, z)
#endif

/* Debug makros */
#if DEBUG

#ifndef STR
#define STR(x)   #x
#endif /* STR */

#ifndef SHOW_DEFINE
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* SHOW_DEFINE */

#endif /* DEBUG */

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res = neutral;

#if DEBUG
    fprintf(stderr, "\nsolving ");
    SHOW_DEFINE(NAME);
    fprintf(stderr, ", pins are ");
    printlogic(cpssp->NAME.states[0]);
    printlogic(cpssp->NAME.states[1]);
    printlogic(cpssp->NAME.states[2]);
    //fprintf(stderr, "res is %i\n", res);
#endif /* DEBUG */



#ifdef INP_0
    if(cpssp->NAME.states[0] != SIG_STD_LOGIC_Z &&
       cpssp->NAME.states[0] != SIG_STD_LOGIC_U){
#ifdef NOT
	res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[0]));
#else
	res = res sign 2000 < SIG_mV(cpssp->NAME.states[0]);
#endif /* NOT */
    }
    //fprintf(stderr, "res 0 is %i\n", res);
#endif

#ifdef INP_1
    if(cpssp->NAME.states[1] != SIG_STD_LOGIC_Z &&
       cpssp->NAME.states[1] != SIG_STD_LOGIC_U){
#ifdef NOT
	res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[1]));
#else
	res = res sign 2000 < SIG_mV(cpssp->NAME.states[1]);
#endif /* NOT */
    }
    //fprintf(stderr, "res 1 is %i\n", res);
#endif

#ifdef INP_2
    if(cpssp->NAME.states[2] != SIG_STD_LOGIC_Z &&
       cpssp->NAME.states[2] != SIG_STD_LOGIC_U){
#ifdef NOT
	res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[2]));
#else
	res = res sign 2000 < SIG_mV(cpssp->NAME.states[2]);
#endif /* NOT */
    }
    //fprintf(stderr, "res 2 is %i\n", res);
#endif

#ifdef INP_3
    if(cpssp->NAME.states[3] != SIG_STD_LOGIC_Z){
#ifdef NOT
	res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[3]));
#else
	res = res sign 2000 < SIG_mV(cpssp->NAME.states[3]);
#endif /* NOT */
    }
#endif

#ifdef INP_4
    if(cpssp->NAME.states[4] != SIG_STD_LOGIC_Z){
#ifdef NOT
	res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[4]));
#else
	res = res sign 2000 < SIG_mV(cpssp->NAME.states[4]);
#endif /* NOT */
    }
#endif

#ifdef INP_5
#ifdef NOT
    res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[5]));
#else
    res = res sign 2000 < SIG_mV(cpssp->NAME.states[5]);
#endif /* NOT */
#endif

#ifdef INP_6
#ifdef NOT
    res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[6]));
#else
    res = res sign 2000 < SIG_mV(cpssp->NAME.states[6]);
#endif /* NOT */
#endif

#ifdef INP_7
#ifdef NOT
    res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[7]));
#else
    res = res sign 2000 < SIG_mV(cpssp->NAME.states[7]);
#endif /* NOT */
#endif

#ifdef INP_8
#ifdef NOT
    res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[8]));
#else
    res = res sign 2000 < SIG_mV(cpssp->NAME.states[8]);
#endif /* NOT */
#endif

#ifdef INP_9
#ifdef NOT
    res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[9]));
#else
    res = res sign 2000 < SIG_mV(cpssp->NAME.states[9]);
#endif /* NOT */
#endif

#ifdef INP_10
#ifdef NOT
    res = ! (res sign 2000 < SIG_mV(cpssp->NAME.states[10]));
#else
    res = res sign 2000 < SIG_mV(cpssp->NAME.states[10]);
#endif /* NOT */
#endif

#if DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to ");
    if(res == SIG_STD_LOGIC_Z) {
	printlogic(SIG_STD_LOGIC_Z);
    } else {
	printlogic(res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    }
    fprintf(stderr, "\n");
#endif /* DEBUG */

#ifdef OUTP_0
    if(res == SIG_STD_LOGIC_Z) {
	NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_Z);
    } else {
	NAME_OUT_PORT_0_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    }
#endif
#ifdef OUTP_1
    if(res == SIG_STD_LOGIC_Z) {
	NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_Z);
    } else {
	NAME_OUT_PORT_1_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    }
#endif
#ifdef OUTP_2
    if(res == SIG_STD_LOGIC_Z) {
	NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_Z);
    } else {
	NAME_OUT_PORT_2_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    }
#endif
#ifdef OUTP_3
    if(res == SIG_STD_LOGIC_Z) {
	NAME_OUT_PORT_0_(out_set)(cpssp, SIG_STD_LOGIC_Z);
    } else {
	NAME_OUT_PORT_3_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    }
#endif
}

#ifdef NAME_IN_PORT_0_
static void
NAME_IN_PORT_0_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[0] != val) {
	cpssp->NAME.states[0] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_0_ */

#ifdef NAME_IN_PORT_1_
static void
NAME_IN_PORT_1_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[1] != val) {
	cpssp->NAME.states[1] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_1_ */

#ifdef NAME_IN_PORT_2_
static void
NAME_IN_PORT_2_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[2] != val) {
	cpssp->NAME.states[2] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_2_ */


#ifdef NAME_IN_PORT_3_
static void
NAME_IN_PORT_3_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[3] != val) {
	cpssp->NAME.states[3] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_3_ */


#ifdef NAME_IN_PORT_4_
static void
NAME_IN_PORT_4_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[4] != val) {
	cpssp->NAME.states[4] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_4_ */


#ifdef NAME_IN_PORT_5_
static void
NAME_IN_PORT_5_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[5] != val) {
	cpssp->NAME.states[5] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_5_ */


#ifdef NAME_IN_PORT_6_
static void
NAME_IN_PORT_6_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[6] != val) {
	cpssp->NAME.states[6] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_6_ */


#ifdef NAME_IN_PORT_7_
static void
NAME_IN_PORT_7_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[7] != val) {
	cpssp->NAME.states[7] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_7_ */


#ifdef NAME_IN_PORT_8_
static void
NAME_IN_PORT_8_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[8] != val) {
	cpssp->NAME.states[8] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_8_ */


#ifdef NAME_IN_PORT_9_
static void
NAME_IN_PORT_9_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[9] != val) {
	cpssp->NAME.states[9] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_9_ */


#ifdef NAME_IN_PORT_10_
static void
NAME_IN_PORT_10_(in_set)(struct cpssp *cpssp, unsigned int val)
{
    if(cpssp->NAME.states[10] != val) {
	cpssp->NAME.states[10] = val;
	NAME_(solve)(cpssp);
    }
}
#endif /* NAME_IN_PORT_10_ */

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef INP_0
    NAME_IN_PORT_0_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_1
    NAME_IN_PORT_1_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_2
    NAME_IN_PORT_2_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_3
    NAME_IN_PORT_3_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_4
    NAME_IN_PORT_4_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_5
    NAME_IN_PORT_5_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_6
    NAME_IN_PORT_6_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_7
    NAME_IN_PORT_7_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_8
    NAME_IN_PORT_8_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_9
    NAME_IN_PORT_9_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_10
    NAME_IN_PORT_10_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
}


#ifdef INP_0
#undef NAME_IN_PORT_0_
#endif

#ifdef INP_1
#undef NAME_IN_PORT_1_
#endif

#ifdef INP_2
#undef NAME_IN_PORT_2_
#endif

#ifdef INP_3
#undef NAME_IN_PORT_3_
#endif

#ifdef INP_4
#undef NAME_IN_PORT_4_
#endif

#ifdef INP_5
#undef NAME_IN_PORT_5_
#endif

#ifdef INP_6
#undef NAME_IN_PORT_6_
#endif

#ifdef INP_7
#undef NAME_IN_PORT_7_
#endif

#ifdef INP_8
#undef NAME_IN_PORT_8_
#endif

#ifdef INP_9
#undef NAME_IN_PORT_9_
#endif

#ifdef OUTP_0
#undef NAME_OUT_PORT_0_
#endif

#ifdef OUTP_1
#undef NAME_OUT_PORT_1_
#endif

#undef PASTER
#undef EVALUATOR

#endif /*BEHAVIOUR*/
