/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifdef STATE

#ifdef INP_0
#define IN_N 1
#endif

#ifdef INP_1
#undef IN_N
#define IN_N 2
#endif

#ifdef INP_2
#undef IN_N
#define IN_N 3
#endif

#ifdef INP_3
#undef IN_N
#define IN_N 4
#endif

#include "zuse_generic.c"

#undef IN_N

#endif /*STATE*/



#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)	    x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

/* macros to concat function names */
#ifdef INP_0
#define NAME_IN_PORT_0_(z)  EVALUATOR(NAME, INP_0, z)
#endif

#ifdef INP_1
#define NAME_IN_PORT_1_(z)  EVALUATOR(NAME, INP_1, z)
#endif

#ifdef INP_2
#define NAME_IN_PORT_2_(z)  EVALUATOR(NAME, INP_2, z)
#endif

#ifdef INP_3
#define NAME_IN_PORT_3_(z)  EVALUATOR(NAME, INP_3, z)
#endif

#ifdef OUTP_0
#define NAME_OUT_PORT_0_(z) EVALUATOR(NAME, OUTP_0, z)
#endif

/* Debug makros */
#if DEBUG

#ifndef STR
#define STR(x)   #x
#endif /* STR */

#ifndef SHOW_DEFINE
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* SHOW_DEFINE */

#endif /* DEBUG */

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}


static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res = 0;

#ifdef INP_0
        res = 2000 < SIG_mV(cpssp->NAME.states[0]);
    fprintf(stderr, " erste res is %u\n", res);
#endif
#ifdef INP_1
        res = res && 2000 < SIG_mV(cpssp->NAME.states[1]);
    fprintf(stderr, " zweite res is %u\n", res);
#endif
#ifdef INP_2
        res = res && 2000 < SIG_mV(cpssp->NAME.states[2]);
#endif
#ifdef INP_3
        res = res && 2000 < SIG_mV(cpssp->NAME.states[3]);
#endif
#ifdef INP_4
        res = res && 2000 < SIG_mV(cpssp->NAME.states[4]);
#endif

#if DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to ");
    printlogic(res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    fprintf(stderr, " state 0 is %u\n", cpssp->NAME.states[0]);
    printlogic(cpssp->NAME.states[0]);
    fprintf(stderr, " state 1 is %u\n", cpssp->NAME.states[1]);
    printlogic(cpssp->NAME.states[1]);
    fprintf(stderr, "res is %u\n", res);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
}

#include "zuse_generic.c"

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef INP_0
    NAME_IN_PORT_0_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_1
    NAME_IN_PORT_1_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_2
    NAME_IN_PORT_2_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_3
    NAME_IN_PORT_3_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_4
    NAME_IN_PORT_4_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
}
#ifdef INP_0
#undef NAME_IN_PORT_0_
#undef INP_0
#endif

#ifdef INP_1
#undef NAME_IN_PORT_1_
#undef INP_1
#endif

#ifdef INP_2
#undef NAME_IN_PORT_2_
#undef INP_2
#endif

#ifdef INP_3
#undef NAME_IN_PORT_3_
#undef INP_3
#endif

#ifdef INP_4
#undef NAME_IN_PORT_4_
#undef INP_4
#endif

#undef PASTER
#undef EVALUATOR

#ifdef OUTP_0
#undef OUTP_0
#endif

#endif /*BEHAVIOUR*/
