/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define INP_0 14
#define INP_1 5

#define OUTP_0 10
#define OUTP_1 12
#define OUTP_2 7
#define OUTP_3 9


#ifdef STATE

#ifdef INP_0
#define IN_N 1
#endif

#ifdef INP_1
#undef IN_N
#define IN_N 2
#endif

#include "zuse_generic.c"

#endif /*STATE*/


#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)	    x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

/* macros to concat function names */
#ifdef INP_0
#define NAME_IN_PORT_0_(z)  EVALUATOR(NAME, INP_0, z)
#endif

#ifdef INP_1
#define NAME_IN_PORT_1_(z)  EVALUATOR(NAME, INP_1, z)
#endif

#ifdef OUTP_0
#define NAME_OUT_PORT_0_(z) EVALUATOR(NAME, OUTP_0, z)
#endif

#ifdef OUTP_1
#define NAME_OUT_PORT_1_(z) EVALUATOR(NAME, OUTP_1, z)
#endif

#ifdef OUTP_2
#define NAME_OUT_PORT_2_(z) EVALUATOR(NAME, OUTP_2, z)
#endif

#ifdef OUTP_3
#define NAME_OUT_PORT_3_(z) EVALUATOR(NAME, OUTP_3, z)
#endif

/* Debug makros */
#if DEBUG

#ifndef STR
#define STR(x)   #x
#endif /* STR */

#ifndef SHOW_DEFINE
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* SHOW_DEFINE */

#endif /* DEBUG */

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res_in_2 = SIG_STD_LOGIC_Z;
    unsigned int res_in_1 = SIG_STD_LOGIC_Z;

#ifdef INP_0
    res_in_1 = 2000 < SIG_mV(cpssp->NAME.states[0]);
#endif
#ifdef INP_1
    res_in_2 = 2000 < SIG_mV(cpssp->NAME.states[1]);
#endif

#if DEBUG
    SHOW_DEFINE(NAME);
    if(res_in_1) {
	fprintf(stderr, "sets port 0 to 1, port 1 to 0");
    } else {
	fprintf(stderr, "sets port 0 to 0 and port 1 to 1");
    }
    if(res_in_2) {
	fprintf(stderr, ", port 3 to 1 and port 4 to 0\n");
    } else {
	fprintf(stderr, ", port 3 to 0 and port 4 to 1\n");
    }
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res_in_1 ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    NAME_OUT_PORT_2_(out_set)(cpssp, res_in_2 ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);

    /* negated */
    NAME_OUT_PORT_1_(out_set)(cpssp, res_in_1 ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_1);
    NAME_OUT_PORT_3_(out_set)(cpssp, res_in_2 ? SIG_STD_LOGIC_0 : SIG_STD_LOGIC_1);
}

#include "zuse_generic.c"

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef INP_0
    NAME_IN_PORT_0_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_1
    NAME_IN_PORT_1_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_2
    NAME_IN_PORT_2_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_3
    NAME_IN_PORT_3_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_4
    NAME_IN_PORT_4_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
}

#ifdef INP_0
#undef NAME_IN_PORT_0_
#undef INP_0
#endif

#ifdef INP_1
#undef NAME_IN_PORT_1_
#undef INP_1
#endif

#ifdef INP_2
#undef NAME_IN_PORT_2_
#undef INP_2
#endif

#ifdef INP_3
#undef NAME_IN_PORT_3_
#undef INP_3
#endif

#ifdef INP_4
#undef NAME_IN_PORT_4_
#undef INP_4
#endif

#ifdef OUTP_0
#undef NAME_OUT_PORT_0_
#undef OUTP_0
#endif

#ifdef OUTP_1
#undef NAME_OUT_PORT_1_
#undef OUTP_1
#endif

#ifdef OUTP_2
#undef NAME_OUT_PORT_2_
#undef OUTP_2
#endif

#ifdef OUTP_3
#undef NAME_OUT_PORT_3_
#undef OUTP_3
#endif

#undef PASTER
#undef EVALUATOR

#endif /*BEHAVIOUR*/


#undef INP_0
#undef INP_1

#undef OUTP_0
#undef OUTP_1
#undef OUTP_2
#undef OUTP_3


