/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define INP_0 6
#define INP_1 7
#define INP_2 8
#define INP_3 9
#define INP_4 10
#define INP_5 11
#define INP_6 12
#define INP_7 13
#define INP_8 14
#define INP_9 15

#define OUTP_0 4
#define OUTP_1 5


#ifdef STATE

#ifdef INP_0
#define IN_N 1
#endif

#ifdef INP_1
#undef IN_N
#define IN_N 2
#endif

#ifdef INP_2
#undef IN_N
#define IN_N 3
#endif

#ifdef INP_3
#undef IN_N
#define IN_N 4
#endif

#ifdef INP_4
#undef IN_N
#define IN_N 5
#endif

#ifdef INP_5
#undef IN_N
#define IN_N 6
#endif

#ifdef INP_6
#undef IN_N
#define IN_N 7
#endif

#ifdef INP_7
#undef IN_N
#define IN_N 8
#endif

#ifdef INP_8
#undef IN_N
#define IN_N 9
#endif

#ifdef INP_9
#undef IN_N
#define IN_N 10
#endif

#include "zuse_generic.c"

#endif /*STATE*/


#ifdef BEHAVIOUR

/* beautiful helper macros to create the function names*/
#define PASTER(x,y,z)	    x ## _ ## y ## _ ## z
#define EVALUATOR(x,y,z)    PASTER(x,y,z)

/* macros to concat function names */
#ifdef INP_0
#define NAME_IN_PORT_0_(z)  EVALUATOR(NAME, INP_0, z)
#endif

#ifdef INP_1
#define NAME_IN_PORT_1_(z)  EVALUATOR(NAME, INP_1, z)
#endif

#ifdef INP_2
#define NAME_IN_PORT_2_(z)  EVALUATOR(NAME, INP_2, z)
#endif

#ifdef INP_3
#define NAME_IN_PORT_3_(z)  EVALUATOR(NAME, INP_3, z)
#endif

#ifdef INP_4
#define NAME_IN_PORT_4_(z)  EVALUATOR(NAME, INP_4, z)
#endif

#ifdef INP_5
#define NAME_IN_PORT_5_(z)  EVALUATOR(NAME, INP_5, z)
#endif

#ifdef INP_6
#define NAME_IN_PORT_6_(z)  EVALUATOR(NAME, INP_6, z)
#endif

#ifdef INP_7
#define NAME_IN_PORT_7_(z)  EVALUATOR(NAME, INP_7, z)
#endif

#ifdef INP_8
#define NAME_IN_PORT_8_(z)  EVALUATOR(NAME, INP_8, z)
#endif

#ifdef INP_9
#define NAME_IN_PORT_9_(z)  EVALUATOR(NAME, INP_9, z)
#endif

#ifdef OUTP_0
#define NAME_OUT_PORT_0_(z) EVALUATOR(NAME, OUTP_0, z)
#endif

#ifdef OUTP_1
#define NAME_OUT_PORT_1_(z) EVALUATOR(NAME, OUTP_1, z)
#endif

/* Debug makros */
#if DEBUG

#ifndef STR
#define STR(x)   #x
#endif /* STR */

#ifndef SHOW_DEFINE
#define SHOW_DEFINE(x) fprintf(stderr, "%s", STR(x))
#endif /* SHOW_DEFINE */

#endif /* DEBUG */

static void
NAME_(destroy)(struct cpssp *cpssp)
{
    return;
}

static void
NAME_(solve)(struct cpssp *cpssp) {
    unsigned int res = SIG_STD_LOGIC_Z;

    /*
#ifdef INP_0
        res = res && 2000 < SIG_mV(cpssp->NAME.states[0]);
#endif
#ifdef INP_1
        res = res && 2000 < SIG_mV(cpssp->NAME.states[1]);
#endif
#ifdef INP_2
        res = res && 2000 < SIG_mV(cpssp->NAME.states[2]);
#endif
#ifdef INP_3
        res = res && 2000 < SIG_mV(cpssp->NAME.states[3]);
#endif
#ifdef INP_4
        res = res && 2000 < SIG_mV(cpssp->NAME.states[4]);
#endif
#ifdef INP_5
        res = res && 2000 < SIG_mV(cpssp->NAME.states[5]);
#endif
#ifdef INP_6
        res = res && 2000 < SIG_mV(cpssp->NAME.states[6]);
#endif
#ifdef INP_7
        res = res && 2000 < SIG_mV(cpssp->NAME.states[7]);
#endif
#ifdef INP_8
        res = res && 2000 < SIG_mV(cpssp->NAME.states[8]);
#endif
#ifdef INP_9
        res = res && 2000 < SIG_mV(cpssp->NAME.states[9]);
#endif
FIXME */

#if DEBUG
    SHOW_DEFINE(NAME);
    fprintf(stderr, " sets to DUMMY");
    printlogic(res);
#endif /* DEBUG */

    NAME_OUT_PORT_0_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
    NAME_OUT_PORT_1_(out_set)(cpssp, res ? SIG_STD_LOGIC_1 : SIG_STD_LOGIC_0);
}

#include "zuse_generic.c"

static void
NAME_(create)(struct cpssp *cpssp)
{
#ifdef INP_0
    NAME_IN_PORT_0_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_1
    NAME_IN_PORT_1_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_2
    NAME_IN_PORT_2_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_3
    NAME_IN_PORT_3_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_4
    NAME_IN_PORT_4_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_5
    NAME_IN_PORT_5_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_6
    NAME_IN_PORT_6_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_7
    NAME_IN_PORT_7_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_8
    NAME_IN_PORT_8_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_9
    NAME_IN_PORT_9_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
#ifdef INP_10
    NAME_IN_PORT_10_(in_set)(cpssp, SIG_STD_LOGIC_Z);
#endif
}

#ifdef INP_0
#undef NAME_IN_PORT_0_
#undef INP_0
#endif

#ifdef INP_1
#undef NAME_IN_PORT_1_
#undef INP_1
#endif

#ifdef INP_2
#undef NAME_IN_PORT_2_
#undef INP_2
#endif

#ifdef INP_3
#undef NAME_IN_PORT_3_
#undef INP_3
#endif

#ifdef INP_4
#undef NAME_IN_PORT_4_
#undef INP_4
#endif

#ifdef INP_5
#undef NAME_IN_PORT_5_
#undef INP_5
#endif

#ifdef INP_6
#undef NAME_IN_PORT_6_
#undef INP_6
#endif

#ifdef INP_7
#undef NAME_IN_PORT_7_
#undef INP_7
#endif

#ifdef INP_8
#undef NAME_IN_PORT_8_
#undef INP_8
#endif

#ifdef INP_9
#undef NAME_IN_PORT_9_
#undef INP_9
#endif

#ifdef OUTP_0
#undef NAME_OUT_PORT_0_
#undef OUTP_0
#endif

#ifdef OUTP_1
#undef NAME_OUT_PORT_1_
#undef OUTP_1
#endif

#undef PASTER
#undef EVALUATOR

#endif /*BEHAVIOUR*/


#undef INP_0
#undef INP_1
#undef INP_2
#undef INP_3
#undef INP_4
#undef INP_5
#undef INP_6
#undef INP_7
#undef INP_8
#undef INP_9

#undef OUTP_0
#undef OUTP_1


